/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalOffset.dev",["Lexical"],(function $module_LexicalOffset_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var




OffsetView=function(){
function OffsetView(offsetMap,firstNode,blockOffsetSize){if(blockOffsetSize===void 0){blockOffsetSize=1;}
this._offsetMap=offsetMap;
this._firstNode=firstNode;
this._blockOffsetSize=blockOffsetSize;
}var _proto=OffsetView.prototype;_proto.
createSelectionFromOffsets=function createSelectionFromOffsets(originalStart,originalEnd,diffOffsetView){
var firstNode=this._firstNode;
if(firstNode===null){
return null;
}
var start=originalStart;
var end=originalEnd;
var startOffsetNode=$searchForNodeWithOffset(firstNode,start,this._blockOffsetSize);
var endOffsetNode=$searchForNodeWithOffset(firstNode,end,this._blockOffsetSize);
if(diffOffsetView!==undefined){
start=$getAdjustedOffsetFromDiff(start,startOffsetNode,diffOffsetView,this,this._blockOffsetSize);
startOffsetNode=$searchForNodeWithOffset(firstNode,start,this._blockOffsetSize);
end=$getAdjustedOffsetFromDiff(end,endOffsetNode,diffOffsetView,this,this._blockOffsetSize);
endOffsetNode=$searchForNodeWithOffset(firstNode,end,this._blockOffsetSize);
}
if(startOffsetNode===null||endOffsetNode===null){
return null;
}
var startKey=startOffsetNode.key;
var endKey=endOffsetNode.key;
var startNode=require("Lexical").$getNodeByKey(startKey);
var endNode=require("Lexical").$getNodeByKey(endKey);
if(startNode===null||endNode===null){
return null;
}
var startOffset=0;
var endOffset=0;
var startType='element';
var endType='element';
if(startOffsetNode.type==='text'){
startOffset=start-startOffsetNode.start;
startType='text';



var sibling=startNode.getNextSibling();
if(start!==end&&startOffset===startNode.getTextContentSize()&&require("Lexical").$isTextNode(sibling)){
startOffset=0;
startKey=sibling.__key;
}
}else if(startOffsetNode.type==='inline'){
startKey=startNode.getParentOrThrow().getKey();
startOffset=end>startOffsetNode.start?startOffsetNode.end:startOffsetNode.start;
}
if(endOffsetNode.type==='text'){
endOffset=end-endOffsetNode.start;
endType='text';
}else if(endOffsetNode.type==='inline'){
endKey=endNode.getParentOrThrow().getKey();
endOffset=end>endOffsetNode.start?endOffsetNode.end:endOffsetNode.start;
}
var selection=require("Lexical").$createRangeSelection();
if(selection===null){
return null;
}
selection.anchor.set(startKey,startOffset,startType);
selection.focus.set(endKey,endOffset,endType);
return selection;
};_proto.
getOffsetsFromSelection=function getOffsetsFromSelection(selection){
var anchor=selection.anchor;
var focus=selection.focus;
var offsetMap=this._offsetMap;
var anchorOffset=anchor.offset;
var focusOffset=focus.offset;
var start=-1;
var end=-1;
if(anchor.type==='text'){
var offsetNode=offsetMap.get(anchor.key);
if(offsetNode!==undefined){
start=offsetNode.start+anchorOffset;
}
}else{
var node=anchor.getNode().getDescendantByIndex(anchorOffset);
if(node!==null){
var _offsetNode=offsetMap.get(node.getKey());
if(_offsetNode!==undefined){
var isAtEnd=node.getIndexWithinParent()!==anchorOffset;
start=isAtEnd?_offsetNode.end:_offsetNode.start;
}
}
}
if(focus.type==='text'){
var _offsetNode2=offsetMap.get(focus.key);
if(_offsetNode2!==undefined){
end=_offsetNode2.start+focus.offset;
}
}else{
var _node=focus.getNode().getDescendantByIndex(focusOffset);
if(_node!==null){
var _offsetNode3=offsetMap.get(_node.getKey());
if(_offsetNode3!==undefined){
var _isAtEnd=_node.getIndexWithinParent()!==focusOffset;
end=_isAtEnd?_offsetNode3.end:_offsetNode3.start;
}
}
}
return[start,end];
};return OffsetView;}();

function $getAdjustedOffsetFromDiff(offset,offsetNode,prevOffsetView,offsetView,blockOffsetSize){
var prevOffsetMap=prevOffsetView._offsetMap;
var offsetMap=offsetView._offsetMap;
var visited=new Set();
var adjustedOffset=offset;
var currentNode=offsetNode;
while(currentNode!==null){
var key=currentNode.key;
var prevNode=prevOffsetMap.get(key);
var diff=currentNode.end-currentNode.start;
visited.add(key);
if(prevNode===undefined){
adjustedOffset+=diff;
}else{
var prevDiff=prevNode.end-prevNode.start;
if(prevDiff!==diff){
adjustedOffset+=diff-prevDiff;
}
}
var sibling=currentNode.prev;
if(sibling!==null){
currentNode=sibling;
continue;
}
var parent=currentNode.parent;
while(parent!==null){
var parentSibling=parent.prev;
if(parentSibling!==null){
var parentSiblingKey=parentSibling.key;
var prevParentSibling=prevOffsetMap.get(parentSiblingKey);
var parentDiff=parentSibling.end-parentSibling.start;
visited.add(parentSiblingKey);
if(prevParentSibling===undefined){
adjustedOffset+=parentDiff;
}else{
var prevParentDiff=prevParentSibling.end-prevParentSibling.start;
if(prevParentDiff!==parentDiff){
adjustedOffset+=parentDiff-prevParentDiff;
}
}
parentSibling=parentSibling.prev;
}
parent=parent.parent;
}
break;
}




var prevFirstNode=prevOffsetView._firstNode;
if(prevFirstNode!==null){
currentNode=$searchForNodeWithOffset(prevFirstNode,offset,blockOffsetSize);
var alreadyVisitedParentOfCurrentNode=false;
while(currentNode!==null){
if(!visited.has(currentNode.key)){
alreadyVisitedParentOfCurrentNode=true;
break;
}
currentNode=currentNode.parent;
}
if(!alreadyVisitedParentOfCurrentNode){
while(currentNode!==null){
var _key=currentNode.key;
if(!visited.has(_key)){
var node=offsetMap.get(_key);
var _prevDiff=currentNode.end-currentNode.start;
if(node===undefined){
adjustedOffset-=_prevDiff;
}else{
var _diff=node.end-node.start;
if(_prevDiff!==_diff){
adjustedOffset+=_diff-_prevDiff;
}
}
}
currentNode=currentNode.prev;
}
}
}
return adjustedOffset;
}
function $searchForNodeWithOffset(firstNode,offset,blockOffsetSize){
var currentNode=firstNode;
while(currentNode!==null){
var end=currentNode.end+(currentNode.type!=='element'||blockOffsetSize===0?1:0);
if(offset<end){
var child=currentNode.child;
if(child!==null){
currentNode=child;
continue;
}
return currentNode;
}
var sibling=currentNode.next;
if(sibling===null){
break;
}
currentNode=sibling;
}
return null;
}
function $createInternalOffsetNode(child,type,start,end,key,parent){
return{
child:child,
end:end,
key:key,
next:null,
parent:parent,
prev:null,
start:start,
type:type};

}
function $createOffsetNode(state,key,parent,nodeMap,offsetMap,blockOffsetSize){
var node=nodeMap.get(key);
if(node===undefined){
{
throw Error("createOffsetModel: could not find node by key");
}
}
var start=state.offset;
if(require("Lexical").$isElementNode(node)){
var childKeys=createChildrenArray(node,nodeMap);
var blockIsEmpty=childKeys.length===0;
var child=blockIsEmpty?null:$createOffsetChild(state,childKeys,null,nodeMap,offsetMap,blockOffsetSize);



if(!state.prevIsBlock||blockIsEmpty){
state.prevIsBlock=true;
state.offset+=blockOffsetSize;
}
var _offsetNode4=$createInternalOffsetNode(child,'element',start,start,key,parent);
if(child!==null){
child.parent=_offsetNode4;
}
var _end=state.offset;
_offsetNode4.end=_end;
offsetMap.set(key,_offsetNode4);
return _offsetNode4;
}
state.prevIsBlock=false;
var isText=require("Lexical").$isTextNode(node);
var length=isText?node.__text.length:1;
var end=state.offset+=length;
var offsetNode=$createInternalOffsetNode(null,isText?'text':'inline',start,end,key,parent);
offsetMap.set(key,offsetNode);
return offsetNode;
}
function $createOffsetChild(state,children,parent,nodeMap,offsetMap,blockOffsetSize){
var firstNode=null;
var currentNode=null;
var childrenLength=children.length;
for(var i=0;i<childrenLength;i++){
var childKey=children[i];
var offsetNode=$createOffsetNode(state,childKey,parent,nodeMap,offsetMap,blockOffsetSize);
if(currentNode===null){
firstNode=offsetNode;
}else{
offsetNode.prev=currentNode;
currentNode.next=offsetNode;
}
currentNode=offsetNode;
}
return firstNode;
}
function createChildrenArray(element,nodeMap){
var children=[];
var nodeKey=element.__first;
while(nodeKey!==null){
var node=nodeMap===null?require("Lexical").$getNodeByKey(nodeKey):nodeMap.get(nodeKey);
if(node===null||node===undefined){
{
throw Error("createChildrenArray: node does not exist in nodeMap");
}
}
children.push(nodeKey);
nodeKey=node.__next;
}
return children;
}
function $createOffsetView(editor,blockOffsetSize,editorState){if(blockOffsetSize===void 0){blockOffsetSize=1;}
var targetEditorState=editorState||editor._pendingEditorState||editor._editorState;
var nodeMap=targetEditorState._nodeMap;
var root=nodeMap.get('root');
var offsetMap=new Map();
var state={
offset:0,
prevIsBlock:false};

var node=$createOffsetChild(state,createChildrenArray(root,nodeMap),null,nodeMap,offsetMap,blockOffsetSize);
return new OffsetView(offsetMap,node,blockOffsetSize);
}

exports.$createOffsetView=$createOffsetView;
exports.OffsetView=OffsetView;
exports.createChildrenArray=createChildrenArray;}),null);