__d("ZenonVideoProcessingFragmentShader",[],(function(a,b,c,d,e,f){"use strict";a="\n  precision highp float;\n\n  varying vec2 v_texCoord;\n  uniform vec2 u_resolution;\n  uniform bool u_horizontal;\n\n  /**\n   * The semantics of the RGBA values of the mask (u_mask) is as follows:\n   *  - The image mask is the same size as the input image, where green and blue channels are always set to 0.\n   *  - Different red values denote different body parts.\n   *  - Each pixel of the mask is assigned a float number that has a range between [0.0, 1.0].\n   *  - The closer the alpha value is to 1.0, the higher the confidence that the pixel represents a person, and vice versa.\n   *\n   *  Useful links:\n   *  https://developers.google.com/ml-kit/vision/selfie-segmentation\n   *  https://github.com/tensorflow/tfjs-models/blob/master/body-segmentation/README.md#how-to-run-it\n   *  https://blog.research.google/2020/10/background-features-in-google-meet.html\n  */\n  uniform sampler2D u_mask;\n  uniform sampler2D u_image;\n\n  vec2 TEXEL_SIZE = 1.0 / u_resolution;\n  const int BLUR_STRENGTH = 12;\n\n  vec4 calculateBlurredColor(sampler2D imageTexture, sampler2D maskTexture, int i) {\n    // This is a weird way I found to flip the image vertically. For some reason, after rendering it off-screen, it flips.\n    // Haven't found a cause, so flipped it in the shader. Same is done below.\n    vec2 offset = u_horizontal ? vec2(float(i), 0.0) : vec2(0.0, float(i));\n    offset *= TEXEL_SIZE;\n    vec2 texCoord = u_horizontal ? vec2(v_texCoord.x, 1.0 - v_texCoord.y) : v_texCoord;\n    vec4 imageSample = texture2D(imageTexture, texCoord + offset);\n    vec4 maskSample = texture2D(maskTexture, texCoord + offset);\n\n    // calculate weight based on distance to edge of mask\n    // so that the blur strength is reduced at the edges\n    // and halo effects and artefacts are minimized\n    float weight = 1.0 - maskSample.a;\n\n    return imageSample * weight;\n  }\n\n  vec4 applyGaussianBlur(sampler2D imageTexture, sampler2D maskTexture) {\n    vec4 blurredColor = vec4(0.0);\n    float totalWeight = 0.0;\n\n    for (int i = -BLUR_STRENGTH; i <= BLUR_STRENGTH; i++) {\n      vec4 color = calculateBlurredColor(imageTexture, maskTexture, i);\n      blurredColor += color;\n      totalWeight += color.a;\n    }\n    return totalWeight > 0.0 ? blurredColor / totalWeight : blurredColor;\n  }\n\n  void main() {\n    vec2 texCoord = u_horizontal ? vec2(v_texCoord.x, 1.0 - v_texCoord.y) : v_texCoord;\n    vec4 imageColor = texture2D(u_image, texCoord);\n    vec4 maskSample = texture2D(u_mask, texCoord);\n    vec4 gaussianBlurColor = applyGaussianBlur(u_image, u_mask);\n    gl_FragColor = mix(gaussianBlurColor, imageColor, maskSample.a);\n  }\n";b=a;f["default"]=b}),66);
__d("ZenonVideoProcessingVertexShader",[],(function(a,b,c,d,e,f){"use strict";a="\n  precision highp float;\n\n  attribute vec2 a_position;\n  attribute vec2 a_texCoord;\n  uniform vec2 u_resolution;\n  varying vec2 v_texCoord;\n\n  void main() {\n    // convert the rectangle from pixels to coordinates between 0.0 - 1.0\n    vec2 zeroToOne = a_position / u_resolution;\n\n    // scales the coordinates to a range between 0.0 - 2.0\n    vec2 zeroToTwo = zeroToOne * 2.0;\n\n    // transform the coordinates to clipspace ranging from -1.0 to 1.0\n    vec2 clipSpace = zeroToTwo - 1.0;\n\n    // set the final position of the vertex in the clipspace\n    gl_Position = vec4(clipSpace * vec2(1, -1), 0, 1);\n\n    // pass the texture coordinate to the fragment shader,\n    // which will be interpolated by the GPU\n    v_texCoord = a_texCoord;\n  }\n";b=a;f["default"]=b}),66);
__d("useZenonVideoProcessingWebGLRenderer",["ZenonVideoProcessingFragmentShader","ZenonVideoProcessingVertexShader","err","react"],(function(a,b,c,d,e,f,g){"use strict";var h;b=h||d("react");var i=b.useCallback,j=b.useRef,k=2,l=!1,m=0,n=0;function a(){var a=j(),b=j(null),d=j(null),e=j(null),f=j(null),g=j(null),h=i(function(a){if(b.current!=null)return b.current;var d=o(a,c("ZenonVideoProcessingVertexShader"),c("ZenonVideoProcessingFragmentShader"));a.useProgram(d);b.current=d;return b.current},[]),q=i(function(a,b){if(d.current!=null)return d.current;var c=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,c);r(a,0,0,b.image.width,b.image.height);b=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,b);a.bufferData(a.ARRAY_BUFFER,new Float32Array([0,0,1,0,0,1,0,1,1,0,1,1]),a.STATIC_DRAW);d.current={positionBuffer:c,texcoordBuffer:b};return d.current},[]),u=i(function(a,b,c){if(e.current!=null)return e.current;var d=s(a,a.TEXTURE0),f=s(a,a.TEXTURE1);a=p(a,b,c);b=a.offscreenFramebuffer;c=a.offscreenTexture;e.current={imageTexture:f,offscreenFramebuffer:b,offscreenTexture:c,segmentationMaskTexture:d};return e.current},[]),v=i(function(a,b){if(f.current!=null)return f.current;f.current={uHorizontal:a.getUniformLocation(b,"u_horizontal"),uImage:a.getUniformLocation(b,"u_image"),uMask:a.getUniformLocation(b,"u_mask"),uResolution:a.getUniformLocation(b,"u_resolution")};return f.current},[]),w=i(function(a,b){if(g.current!=null)return g.current;g.current={positionLocation:a.getAttribLocation(b,"a_position"),texcoordLocation:a.getAttribLocation(b,"a_texCoord")};return g.current},[]),x=j(!1);return i(function(b,d){var e,f;if(b.current==null)return;e=(e=b.current.width)!=null?e:0;f=(f=b.current.height)!=null?f:0;if(e===0||f===0)throw c("err")("outputCanvasWidth or outputCanvasHeight is 0");a.current==null?(b=b.current.getContext("webgl"),a.current=b):b=a.current;if(b==null)throw c("err")("WebGL not supported");var g=h(b),i=w(b,g),j=i.positionLocation;i=i.texcoordLocation;var o=q(b,d),p=o.positionBuffer;o=o.texcoordBuffer;e=u(b,e,f);f=e.imageTexture;var r=e.offscreenFramebuffer,s=e.offscreenTexture;e=e.segmentationMaskTexture;t(b,e,d.segmentationMask);t(b,f,d.image);e=v(b,g);f=e.uHorizontal;d=e.uImage;g=e.uMask;e=e.uResolution;b.clearColor(0,0,0,0);b.clear(b.COLOR_BUFFER_BIT|b.DEPTH_BUFFER_BIT);x.current||(x.current=!0,b.viewport(0,0,b.canvas.width,b.canvas.height),b.enableVertexAttribArray(j),b.bindBuffer(b.ARRAY_BUFFER,p),b.vertexAttribPointer(j,k,b.FLOAT,l,m,n),b.enableVertexAttribArray(i),b.bindBuffer(b.ARRAY_BUFFER,o),b.vertexAttribPointer(i,k,b.FLOAT,l,m,n));b.uniform2f(e,b.canvas.width,b.canvas.height);b.uniform1i(g,0);b.uniform1i(d,1);b.bindFramebuffer(b.FRAMEBUFFER,r);b.uniform1i(f,1);b.drawArrays(b.TRIANGLES,n,6);b.bindFramebuffer(b.FRAMEBUFFER,null);b.uniform1i(f,0);b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_2D,s);b.drawArrays(b.TRIANGLES,n,6)},[w,q,h,u,v])}function o(a,b,d){var e=a.createProgram();if(e==null)throw c("err")("Cannot make a shader program");a.attachShader(e,q(a,a.VERTEX_SHADER,b));a.attachShader(e,q(a,a.FRAGMENT_SHADER,d));a.linkProgram(e);if(a.getProgramParameter(e,a.LINK_STATUS)===!1)throw c("err")("Program link error: "+String(a.getProgramInfoLog(e)));else return e}function p(a,b,c){var d=a.createFramebuffer();a.bindFramebuffer(a.FRAMEBUFFER,d);var e;try{e=s(a,a.TEXTURE2);a.bindTexture(a.TEXTURE_2D,e);a.texImage2D(a.TEXTURE_2D,0,a.RGBA,b,c,0,a.RGBA,a.UNSIGNED_BYTE,null);a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,e,0);if(a.checkFramebufferStatus(a.FRAMEBUFFER)!==a.FRAMEBUFFER_COMPLETE)throw new Error("Incomplete framebuffer")}catch(b){d&&a.deleteFramebuffer(d);e&&a.deleteTexture(e);throw b}finally{a.bindFramebuffer(a.FRAMEBUFFER,null)}return{offscreenFramebuffer:d,offscreenTexture:e}}function q(a,b,d){b=a.createShader(b);if(b==null)throw c("err")("Cannot make a shader");a.shaderSource(b,d);a.compileShader(b);if(a.getShaderParameter(b,a.COMPILE_STATUS)===!1)throw c("err")("Shader error: "+String(a.getShaderInfoLog(b)));else return b}function r(a,b,c,d,e){var f=b;b=b+d;d=c;c=c+e;a.bufferData(a.ARRAY_BUFFER,new Float32Array([f,d,b,d,f,c,f,c,b,d,b,c]),a.STATIC_DRAW)}function s(a,b){var c=a.createTexture();a.activeTexture(b);a.bindTexture(a.TEXTURE_2D,c);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR);return c}function t(a,b,c){var d=0,e=a.RGBA,f=a.RGBA,g=a.UNSIGNED_BYTE;a.bindTexture(a.TEXTURE_2D,b);a.texImage2D(a.TEXTURE_2D,d,e,f,g,c)}g["default"]=a}),98);