/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalTabIndentationPlugin.dev",["Lexical","LexicalComposerContext","LexicalUtils","react"],(function $module_LexicalTabIndentationPlugin_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;




var react=_require_closure_react||(_require_closure_react=require("react"));








function indentOverTab(selection){

var nodes=selection.getNodes();
var canIndentBlockNodes=require("LexicalUtils").$filter(nodes,function(node){
if(require("Lexical").$isBlockElementNode(node)&&node.canIndent()){
return node;
}
return null;
});

if(canIndentBlockNodes.length>0){
return true;
}

var anchor=selection.anchor;
var focus=selection.focus;
var first=focus.isBefore(anchor)?focus:anchor;
var firstNode=first.getNode();
var firstBlock=require("LexicalUtils").$getNearestBlockElementAncestorOrThrow(firstNode);
if(firstBlock.canIndent()){
var firstBlockKey=firstBlock.getKey();
var selectionAtStart=require("Lexical").$createRangeSelection();
selectionAtStart.anchor.set(firstBlockKey,0,'element');
selectionAtStart.focus.set(firstBlockKey,0,'element');
selectionAtStart=require("Lexical").$normalizeSelection__EXPERIMENTAL(selectionAtStart);
if(selectionAtStart.anchor.is(first)){
return true;
}
}

return false;
}
function registerTabIndentation(editor){
return editor.registerCommand(require("Lexical").KEY_TAB_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
event.preventDefault();
var command=indentOverTab(selection)?event.shiftKey?require("Lexical").OUTDENT_CONTENT_COMMAND:require("Lexical").INDENT_CONTENT_COMMAND:require("Lexical").INSERT_TAB_COMMAND;
return editor.dispatchCommand(command,undefined);
},require("Lexical").COMMAND_PRIORITY_EDITOR);
}






function TabIndentationPlugin(){var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];
react.useEffect(function(){
return registerTabIndentation(editor);
});
return null;
}

exports.TabIndentationPlugin=TabIndentationPlugin;
exports.registerTabIndentation=registerTabIndentation;}),null);