/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalMarkdown.dev",["Lexical","LexicalCode","LexicalLink","LexicalList","LexicalRichText","LexicalUtils"],(function $module_LexicalMarkdown_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';















function indexBy(list,callback){
var index={};
for(var _iterator=list,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var item=_ref;
var key=callback(item);
if(index[key]){
index[key].push(item);
}else{
index[key]=[item];
}
}
return index;
}
function transformersByType(transformers){
var byType=indexBy(transformers,function(t){return t.type;});
return{
element:byType.element||[],
textFormat:byType['text-format']||[],
textMatch:byType['text-match']||[]};

}
var PUNCTUATION_OR_SPACE=/[!-/:-@[-`{-~\s]/;








function createMarkdownExport(transformers){
var byType=transformersByType(transformers);



var textFormatTransformers=byType.textFormat.filter(function(transformer){return transformer.format.length===1;});
return function(node){
var output=[];
var children=(node||require("Lexical").$getRoot()).getChildren();
for(var _iterator2=children,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray2){if(_i2>=_iterator2.length)break;_ref2=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref2=_i2.value;}var child=_ref2;
var result=exportTopLevelElements(child,byType.element,textFormatTransformers,byType.textMatch);
if(result!=null){
output.push(result);
}
}
return output.join('\n\n');
};
}
function exportTopLevelElements(node,elementTransformers,textTransformersIndex,textMatchTransformers){
for(var _iterator3=elementTransformers,_isArray3=Array.isArray(_iterator3),_i3=0,_iterator3=_isArray3?_iterator3:_iterator3[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref3;if(_isArray3){if(_i3>=_iterator3.length)break;_ref3=_iterator3[_i3++];}else{_i3=_iterator3.next();if(_i3.done)break;_ref3=_i3.value;}var transformer=_ref3;
var result=transformer["export"](node,function(_node){return exportChildren(_node,textTransformersIndex,textMatchTransformers);});
if(result!=null){
return result;
}
}
if(require("Lexical").$isElementNode(node)){
return exportChildren(node,textTransformersIndex,textMatchTransformers);
}else if(require("Lexical").$isDecoratorNode(node)){
return node.getTextContent();
}else{
return null;
}
}
function exportChildren(node,textTransformersIndex,textMatchTransformers){
var output=[];
var children=node.getChildren();
mainLoop:for(var _iterator4=children,_isArray4=Array.isArray(_iterator4),_i4=0,_iterator4=_isArray4?_iterator4:_iterator4[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref4;if(_isArray4){if(_i4>=_iterator4.length)break;_ref4=_iterator4[_i4++];}else{_i4=_iterator4.next();if(_i4.done)break;_ref4=_i4.value;}var child=_ref4;
for(var _iterator5=textMatchTransformers,_isArray5=Array.isArray(_iterator5),_i5=0,_iterator5=_isArray5?_iterator5:_iterator5[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref5;if(_isArray5){if(_i5>=_iterator5.length)break;_ref5=_iterator5[_i5++];}else{_i5=_iterator5.next();if(_i5.done)break;_ref5=_i5.value;}var transformer=_ref5;
var result=transformer["export"](child,function(parentNode){return exportChildren(parentNode,textTransformersIndex,textMatchTransformers);},function(textNode,textContent){return exportTextFormat(textNode,textContent,textTransformersIndex);});
if(result!=null){
output.push(result);
continue mainLoop;
}
}
if(require("Lexical").$isLineBreakNode(child)){
output.push('\n');
}else if(require("Lexical").$isTextNode(child)){
output.push(exportTextFormat(child,child.getTextContent(),textTransformersIndex));
}else if(require("Lexical").$isElementNode(child)){
output.push(exportChildren(child,textTransformersIndex,textMatchTransformers));
}else if(require("Lexical").$isDecoratorNode(child)){
output.push(child.getTextContent());
}
}
return output.join('');
}
function exportTextFormat(node,textContent,textTransformers){




var frozenString=textContent.trim();
var output=frozenString;
var applied=new Set();
for(var _iterator6=textTransformers,_isArray6=Array.isArray(_iterator6),_i6=0,_iterator6=_isArray6?_iterator6:_iterator6[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref6;if(_isArray6){if(_i6>=_iterator6.length)break;_ref6=_iterator6[_i6++];}else{_i6=_iterator6.next();if(_i6.done)break;_ref6=_i6.value;}var transformer=_ref6;
var format=transformer.format[0];
var tag=transformer.tag;
if(hasFormat(node,format)&&!applied.has(format)){

applied.add(format);

var previousNode=getTextSibling(node,true);
if(!hasFormat(previousNode,format)){
output=tag+output;
}


var nextNode=getTextSibling(node,false);
if(!hasFormat(nextNode,format)){
output+=tag;
}
}
}


return textContent.replace(frozenString,function(){return output;});
}



function getTextSibling(node,backward){
var sibling=backward?node.getPreviousSibling():node.getNextSibling();
if(!sibling){
var parent=node.getParentOrThrow();
if(parent.isInline()){
sibling=backward?parent.getPreviousSibling():parent.getNextSibling();
}
}
while(sibling){
if(require("Lexical").$isElementNode(sibling)){
if(!sibling.isInline()){
break;
}
var descendant=backward?sibling.getLastDescendant():sibling.getFirstDescendant();
if(require("Lexical").$isTextNode(descendant)){
return descendant;
}else{
sibling=backward?sibling.getPreviousSibling():sibling.getNextSibling();
}
}
if(require("Lexical").$isTextNode(sibling)){
return sibling;
}
if(!require("Lexical").$isElementNode(sibling)){
return null;
}
}
return null;
}
function hasFormat(node,format){
return require("Lexical").$isTextNode(node)&&node.hasFormat(format);
}









var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var documentMode=CAN_USE_DOM&&'documentMode'in document?document.documentMode:null;
CAN_USE_DOM&&/Mac|iPod|iPhone|iPad/.test(navigator.platform);
CAN_USE_DOM&&/^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);
CAN_USE_DOM&&'InputEvent'in window&&!documentMode?'getTargetRanges'in new window.InputEvent('input'):false;
var IS_SAFARI=CAN_USE_DOM&&/Version\/[\d.]+.*Safari/.test(navigator.userAgent);
var IS_IOS=CAN_USE_DOM&&/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream;
CAN_USE_DOM&&/Android/.test(navigator.userAgent);



var IS_CHROME=CAN_USE_DOM&&/^(?=.*Chrome).*/i.test(navigator.userAgent);


var IS_APPLE_WEBKIT=CAN_USE_DOM&&/AppleWebKit\/[\d.]+/.test(navigator.userAgent)&&!IS_CHROME;








var MARKDOWN_EMPTY_LINE_REG_EXP=/^\s{0,3}$/;
var CODE_BLOCK_REG_EXP=/^```(\w{1,10})?\s?$/;
function createMarkdownImport(transformers){
var byType=transformersByType(transformers);
var textFormatTransformersIndex=createTextFormatTransformersIndex(byType.textFormat);
return function(markdownString,node){
var lines=markdownString.split('\n');
var linesLength=lines.length;
var root=node||require("Lexical").$getRoot();
root.clear();
for(var i=0;i<linesLength;i++){
var lineText=lines[i];var _importCodeBlock=




importCodeBlock(lines,i,root),codeBlockNode=_importCodeBlock[0],shiftedIndex=_importCodeBlock[1];
if(codeBlockNode!=null){
i=shiftedIndex;
continue;
}
importBlocks(lineText,root,byType.element,textFormatTransformersIndex,byType.textMatch);
}



var children=root.getChildren();
for(var _iterator7=children,_isArray7=Array.isArray(_iterator7),_i7=0,_iterator7=_isArray7?_iterator7:_iterator7[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref7;if(_isArray7){if(_i7>=_iterator7.length)break;_ref7=_iterator7[_i7++];}else{_i7=_iterator7.next();if(_i7.done)break;_ref7=_i7.value;}var child=_ref7;
if(isEmptyParagraph(child)&&root.getChildrenSize()>1){
child.remove();
}
}
if(require("Lexical").$getSelection()!==null){
root.selectEnd();
}
};
}
function isEmptyParagraph(node){
if(!require("Lexical").$isParagraphNode(node)){
return false;
}
var firstChild=node.getFirstChild();
return firstChild==null||node.getChildrenSize()===1&&require("Lexical").$isTextNode(firstChild)&&MARKDOWN_EMPTY_LINE_REG_EXP.test(firstChild.getTextContent());
}
function importBlocks(lineText,rootNode,elementTransformers,textFormatTransformersIndex,textMatchTransformers){
var lineTextTrimmed=lineText.trim();
var textNode=require("Lexical").$createTextNode(lineTextTrimmed);
var elementNode=require("Lexical").$createParagraphNode();
elementNode.append(textNode);
rootNode.append(elementNode);
for(var _iterator8=


elementTransformers,_isArray8=Array.isArray(_iterator8),_i8=0,_iterator8=_isArray8?_iterator8:_iterator8[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref9;if(_isArray8){if(_i8>=_iterator8.length)break;_ref9=_iterator8[_i8++];}else{_i8=_iterator8.next();if(_i8.done)break;_ref9=_i8.value;}var _ref10=_ref9;var regExp=_ref10.regExp;var replace=_ref10.replace;
var match=lineText.match(regExp);
if(match){
textNode.setTextContent(lineText.slice(match[0].length));
replace(elementNode,[textNode],match,true);
break;
}
}
importTextFormatTransformers(textNode,textFormatTransformersIndex,textMatchTransformers);




if(elementNode.isAttached()&&lineTextTrimmed.length>0){
var previousNode=elementNode.getPreviousSibling();
if(require("Lexical").$isParagraphNode(previousNode)||require("LexicalRichText").$isQuoteNode(previousNode)||require("LexicalList").$isListNode(previousNode)){
var targetNode=previousNode;
if(require("LexicalList").$isListNode(previousNode)){
var lastDescendant=previousNode.getLastDescendant();
if(lastDescendant==null){
targetNode=null;
}else{
targetNode=require("LexicalUtils").$findMatchingParent(lastDescendant,require("LexicalList").$isListItemNode);
}
}
if(targetNode!=null&&targetNode.getTextContentSize()>0){
targetNode.splice(targetNode.getChildrenSize(),0,[require("Lexical").$createLineBreakNode()].concat(elementNode.getChildren()));
elementNode.remove();
}
}
}
}
function importCodeBlock(lines,startLineIndex,rootNode){
var openMatch=lines[startLineIndex].match(CODE_BLOCK_REG_EXP);
if(openMatch){
var endLineIndex=startLineIndex;
var linesLength=lines.length;
while(++endLineIndex<linesLength){
var closeMatch=lines[endLineIndex].match(CODE_BLOCK_REG_EXP);
if(closeMatch){
var codeBlockNode=require("LexicalCode").$createCodeNode(openMatch[1]);
var textNode=require("Lexical").$createTextNode(lines.slice(startLineIndex+1,endLineIndex).join('\n'));
codeBlockNode.append(textNode);
rootNode.append(codeBlockNode);
return[codeBlockNode,endLineIndex];
}
}
}
return[null,startLineIndex];
}








function importTextFormatTransformers(textNode,textFormatTransformersIndex,textMatchTransformers){
var textContent=textNode.getTextContent();
var match=findOutermostMatch(textContent,textFormatTransformersIndex);
if(!match){


importTextMatchTransformers(textNode,textMatchTransformers);
return;
}
var currentNode,remainderNode,leadingNode;




if(match[0]===textContent){
currentNode=textNode;
}else{
var startIndex=match.index||0;
var endIndex=startIndex+match[0].length;
if(startIndex===0){var _textNode$splitText=
textNode.splitText(endIndex);currentNode=_textNode$splitText[0];remainderNode=_textNode$splitText[1];
}else{var _textNode$splitText2=
textNode.splitText(startIndex,endIndex);leadingNode=_textNode$splitText2[0];currentNode=_textNode$splitText2[1];remainderNode=_textNode$splitText2[2];
}
}
currentNode.setTextContent(match[2]);
var transformer=textFormatTransformersIndex.transformersByTag[match[1]];
if(transformer){
for(var _iterator9=transformer.format,_isArray9=Array.isArray(_iterator9),_i9=0,_iterator9=_isArray9?_iterator9:_iterator9[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref11;if(_isArray9){if(_i9>=_iterator9.length)break;_ref11=_iterator9[_i9++];}else{_i9=_iterator9.next();if(_i9.done)break;_ref11=_i9.value;}var format=_ref11;
if(!currentNode.hasFormat(format)){
currentNode.toggleFormat(format);
}
}
}


if(!currentNode.hasFormat('code')){
importTextFormatTransformers(currentNode,textFormatTransformersIndex,textMatchTransformers);
}


if(leadingNode){
importTextFormatTransformers(leadingNode,textFormatTransformersIndex,textMatchTransformers);
}
if(remainderNode){
importTextFormatTransformers(remainderNode,textFormatTransformersIndex,textMatchTransformers);
}
}
function importTextMatchTransformers(textNode_,textMatchTransformers){
var textNode=textNode_;
mainLoop:while(textNode){
for(var _iterator10=textMatchTransformers,_isArray10=Array.isArray(_iterator10),_i10=0,_iterator10=_isArray10?_iterator10:_iterator10[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref12;if(_isArray10){if(_i10>=_iterator10.length)break;_ref12=_iterator10[_i10++];}else{_i10=_iterator10.next();if(_i10.done)break;_ref12=_i10.value;}var transformer=_ref12;
var match=textNode.getTextContent().match(transformer.importRegExp);
if(!match){
continue;
}
var startIndex=match.index||0;
var endIndex=startIndex+match[0].length;
var replaceNode=void 0,newTextNode=void 0;
if(startIndex===0){var _textNode$splitText3=
textNode.splitText(endIndex);replaceNode=_textNode$splitText3[0];textNode=_textNode$splitText3[1];
}else{var _textNode$splitText4=
textNode.splitText(startIndex,endIndex);replaceNode=_textNode$splitText4[1];newTextNode=_textNode$splitText4[2];
}
if(newTextNode){
importTextMatchTransformers(newTextNode,textMatchTransformers);
}
transformer.replace(replaceNode,match);
continue mainLoop;
}
break;
}
}


function findOutermostMatch(textContent,textTransformersIndex){
var openTagsMatch=textContent.match(textTransformersIndex.openTagsRegExp);
if(openTagsMatch==null){
return null;
}
for(var _iterator11=openTagsMatch,_isArray11=Array.isArray(_iterator11),_i11=0,_iterator11=_isArray11?_iterator11:_iterator11[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref13;if(_isArray11){if(_i11>=_iterator11.length)break;_ref13=_iterator11[_i11++];}else{_i11=_iterator11.next();if(_i11.done)break;_ref13=_i11.value;}var match=_ref13;


var tag=match.replace(/^\s/,'');
var fullMatchRegExp=textTransformersIndex.fullMatchRegExpByTag[tag];
if(fullMatchRegExp==null){
continue;
}
var fullMatch=textContent.match(fullMatchRegExp);
var transformer=textTransformersIndex.transformersByTag[tag];
if(fullMatch!=null&&transformer!=null){
if(transformer.intraword!==false){
return fullMatch;
}var _fullMatch$index=





fullMatch.index,index=_fullMatch$index===void 0?0:_fullMatch$index;
var beforeChar=textContent[index-1];
var afterChar=textContent[index+fullMatch[0].length];
if((!beforeChar||PUNCTUATION_OR_SPACE.test(beforeChar))&&(!afterChar||PUNCTUATION_OR_SPACE.test(afterChar))){
return fullMatch;
}
}
}
return null;
}
function createTextFormatTransformersIndex(textTransformers){
var transformersByTag={};
var fullMatchRegExpByTag={};
var openTagsRegExp=[];
var escapeRegExp="(?<![\\\\])";
for(var _iterator12=textTransformers,_isArray12=Array.isArray(_iterator12),_i12=0,_iterator12=_isArray12?_iterator12:_iterator12[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref14;if(_isArray12){if(_i12>=_iterator12.length)break;_ref14=_iterator12[_i12++];}else{_i12=_iterator12.next();if(_i12.done)break;_ref14=_i12.value;}var transformer=_ref14;var

tag=
transformer.tag;
transformersByTag[tag]=transformer;
var tagRegExp=tag.replace(/(\*|\^|\+)/g,'\\$1');
openTagsRegExp.push(tagRegExp);
if(IS_SAFARI||IS_IOS||IS_APPLE_WEBKIT){
fullMatchRegExpByTag[tag]=new RegExp("("+tagRegExp+")(?!["+tagRegExp+"\\s])(.*?[^"+tagRegExp+"\\s])"+tagRegExp+"(?!"+tagRegExp+")");
}else{
fullMatchRegExpByTag[tag]=new RegExp("(?<![\\\\"+tagRegExp+"])("+tagRegExp+")((\\\\"+tagRegExp+")?.*?[^"+tagRegExp+"\\s](\\\\"+tagRegExp+")?)((?<!\\\\)|(?<=\\\\\\\\))("+tagRegExp+")(?![\\\\"+tagRegExp+"])");
}
}
return{

fullMatchRegExpByTag:fullMatchRegExpByTag,

openTagsRegExp:new RegExp((IS_SAFARI||IS_IOS||IS_APPLE_WEBKIT?'':""+escapeRegExp)+'('+openTagsRegExp.join('|')+')','g'),
transformersByTag:transformersByTag};

}








function runElementTransformers(parentNode,anchorNode,anchorOffset,elementTransformers){
var grandParentNode=parentNode.getParent();
if(!require("Lexical").$isRootOrShadowRoot(grandParentNode)||parentNode.getFirstChild()!==anchorNode){
return false;
}
var textContent=anchorNode.getTextContent();







if(textContent[anchorOffset-1]!==' '){
return false;
}
for(var _iterator13=


elementTransformers,_isArray13=Array.isArray(_iterator13),_i13=0,_iterator13=_isArray13?_iterator13:_iterator13[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref16;if(_isArray13){if(_i13>=_iterator13.length)break;_ref16=_iterator13[_i13++];}else{_i13=_iterator13.next();if(_i13.done)break;_ref16=_i13.value;}var _ref17=_ref16;var regExp=_ref17.regExp;var replace=_ref17.replace;
var match=textContent.match(regExp);
if(match&&match[0].length===anchorOffset){
var nextSiblings=anchorNode.getNextSiblings();var _anchorNode$splitText=
anchorNode.splitText(anchorOffset),leadingNode=_anchorNode$splitText[0],remainderNode=_anchorNode$splitText[1];
leadingNode.remove();
var siblings=remainderNode?[remainderNode].concat(nextSiblings):nextSiblings;
replace(parentNode,siblings,match,false);
return true;
}
}
return false;
}
function runTextMatchTransformers(anchorNode,anchorOffset,transformersByTrigger){
var textContent=anchorNode.getTextContent();
var lastChar=textContent[anchorOffset-1];
var transformers=transformersByTrigger[lastChar];
if(transformers==null){
return false;
}



if(anchorOffset<textContent.length){
textContent=textContent.slice(0,anchorOffset);
}
for(var _iterator14=transformers,_isArray14=Array.isArray(_iterator14),_i14=0,_iterator14=_isArray14?_iterator14:_iterator14[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref18;if(_isArray14){if(_i14>=_iterator14.length)break;_ref18=_iterator14[_i14++];}else{_i14=_iterator14.next();if(_i14.done)break;_ref18=_i14.value;}var transformer=_ref18;
var match=textContent.match(transformer.regExp);
if(match===null){
continue;
}
var startIndex=match.index||0;
var endIndex=startIndex+match[0].length;
var replaceNode=void 0;
if(startIndex===0){var _anchorNode$splitText2=
anchorNode.splitText(endIndex);replaceNode=_anchorNode$splitText2[0];
}else{var _anchorNode$splitText3=
anchorNode.splitText(startIndex,endIndex);replaceNode=_anchorNode$splitText3[1];
}
replaceNode.selectNext(0,0);
transformer.replace(replaceNode,match);
return true;
}
return false;
}
function runTextFormatTransformers(anchorNode,anchorOffset,textFormatTransformers){
var textContent=anchorNode.getTextContent();
var closeTagEndIndex=anchorOffset-1;
var closeChar=textContent[closeTagEndIndex];

var matchers=textFormatTransformers[closeChar];
if(!matchers){
return false;
}
for(var _iterator15=matchers,_isArray15=Array.isArray(_iterator15),_i15=0,_iterator15=_isArray15?_iterator15:_iterator15[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref19;if(_isArray15){if(_i15>=_iterator15.length)break;_ref19=_iterator15[_i15++];}else{_i15=_iterator15.next();if(_i15.done)break;_ref19=_i15.value;}var matcher=_ref19;var

tag=
matcher.tag;
var tagLength=tag.length;
var closeTagStartIndex=closeTagEndIndex-tagLength+1;


if(tagLength>1){
if(!isEqualSubString(textContent,closeTagStartIndex,tag,0,tagLength)){
continue;
}
}


if(textContent[closeTagStartIndex-1]===' '){
continue;
}


var afterCloseTagChar=textContent[closeTagEndIndex+1];
if(matcher.intraword===false&&afterCloseTagChar&&!PUNCTUATION_OR_SPACE.test(afterCloseTagChar)){
continue;
}
var closeNode=anchorNode;
var openNode=closeNode;
var openTagStartIndex=getOpenTagStartIndex(textContent,closeTagStartIndex,tag);



var sibling=openNode;
while(openTagStartIndex<0&&(sibling=sibling.getPreviousSibling())){
if(require("Lexical").$isLineBreakNode(sibling)){
break;
}
if(require("Lexical").$isTextNode(sibling)){
var siblingTextContent=sibling.getTextContent();
openNode=sibling;
openTagStartIndex=getOpenTagStartIndex(siblingTextContent,siblingTextContent.length,tag);
}
}


if(openTagStartIndex<0){
continue;
}


if(openNode===closeNode&&openTagStartIndex+tagLength===closeTagStartIndex){
continue;
}


var prevOpenNodeText=openNode.getTextContent();
if(openTagStartIndex>0&&prevOpenNodeText[openTagStartIndex-1]===closeChar){
continue;
}


var beforeOpenTagChar=prevOpenNodeText[openTagStartIndex-1];
if(matcher.intraword===false&&beforeOpenTagChar&&!PUNCTUATION_OR_SPACE.test(beforeOpenTagChar)){
continue;
}



var prevCloseNodeText=closeNode.getTextContent();
var closeNodeText=prevCloseNodeText.slice(0,closeTagStartIndex)+prevCloseNodeText.slice(closeTagEndIndex+1);
closeNode.setTextContent(closeNodeText);
var openNodeText=openNode===closeNode?closeNodeText:prevOpenNodeText;
openNode.setTextContent(openNodeText.slice(0,openTagStartIndex)+openNodeText.slice(openTagStartIndex+tagLength));
var selection=require("Lexical").$getSelection();
var nextSelection=require("Lexical").$createRangeSelection();
require("Lexical").$setSelection(nextSelection);

var newOffset=closeTagEndIndex-tagLength*(openNode===closeNode?2:1)+1;
nextSelection.anchor.set(openNode.__key,openTagStartIndex,'text');
nextSelection.focus.set(closeNode.__key,newOffset,'text');


for(var _iterator16=matcher.format,_isArray16=Array.isArray(_iterator16),_i16=0,_iterator16=_isArray16?_iterator16:_iterator16[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref20;if(_isArray16){if(_i16>=_iterator16.length)break;_ref20=_iterator16[_i16++];}else{_i16=_iterator16.next();if(_i16.done)break;_ref20=_i16.value;}var format=_ref20;
if(!nextSelection.hasFormat(format)){
nextSelection.formatText(format);
}
}


nextSelection.anchor.set(nextSelection.focus.key,nextSelection.focus.offset,nextSelection.focus.type);


for(var _iterator17=matcher.format,_isArray17=Array.isArray(_iterator17),_i17=0,_iterator17=_isArray17?_iterator17:_iterator17[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref21;if(_isArray17){if(_i17>=_iterator17.length)break;_ref21=_iterator17[_i17++];}else{_i17=_iterator17.next();if(_i17.done)break;_ref21=_i17.value;}var _format=_ref21;
if(nextSelection.hasFormat(_format)){
nextSelection.toggleFormat(_format);
}
}
if(require("Lexical").$isRangeSelection(selection)){
nextSelection.format=selection.format;
}
return true;
}
return false;
}
function getOpenTagStartIndex(string,maxIndex,tag){
var tagLength=tag.length;
for(var i=maxIndex;i>=tagLength;i--){
var startIndex=i-tagLength;
if(isEqualSubString(string,startIndex,tag,0,tagLength)&&

string[startIndex+tagLength]!==' '){
return startIndex;
}
}
return-1;
}
function isEqualSubString(stringA,aStart,stringB,bStart,length){
for(var i=0;i<length;i++){
if(stringA[aStart+i]!==stringB[bStart+i]){
return false;
}
}
return true;
}
function registerMarkdownShortcuts(editor,transformers){if(transformers===void 0){transformers=TRANSFORMERS;}
var byType=transformersByType(transformers);
var textFormatTransformersIndex=indexBy(byType.textFormat,function(_ref22){var
tag=_ref22.tag;return(
tag[tag.length-1]);});
var textMatchTransformersIndex=indexBy(byType.textMatch,function(_ref23){var
trigger=_ref23.trigger;return(
trigger);});
for(var _iterator18=transformers,_isArray18=Array.isArray(_iterator18),_i18=0,_iterator18=_isArray18?_iterator18:_iterator18[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref24;if(_isArray18){if(_i18>=_iterator18.length)break;_ref24=_iterator18[_i18++];}else{_i18=_iterator18.next();if(_i18.done)break;_ref24=_i18.value;}var transformer=_ref24;
var type=transformer.type;
if(type==='element'||type==='text-match'){
var dependencies=transformer.dependencies;
for(var _iterator19=dependencies,_isArray19=Array.isArray(_iterator19),_i19=0,_iterator19=_isArray19?_iterator19:_iterator19[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref26;if(_isArray19){if(_i19>=_iterator19.length)break;_ref26=_iterator19[_i19++];}else{_i19=_iterator19.next();if(_i19.done)break;_ref26=_i19.value;}var node=_ref26;
if(!editor.hasNode(node)){
{
throw Error("MarkdownShortcuts: missing dependency "+node.getType()+" for transformer. Ensure node dependency is included in editor initial config.");
}
}
}
}
}
var transform=function transform(parentNode,anchorNode,anchorOffset){
if(runElementTransformers(parentNode,anchorNode,anchorOffset,byType.element)){
return;
}
if(runTextMatchTransformers(anchorNode,anchorOffset,textMatchTransformersIndex)){
return;
}
runTextFormatTransformers(anchorNode,anchorOffset,textFormatTransformersIndex);
};
return editor.registerUpdateListener(function(_ref25)




{var tags=_ref25.tags,dirtyLeaves=_ref25.dirtyLeaves,editorState=_ref25.editorState,prevEditorState=_ref25.prevEditorState;

if(tags.has('collaboration')||tags.has('historic')){
return;
}


if(editor.isComposing()){
return;
}
var selection=editorState.read(require("Lexical").$getSelection);
var prevSelection=prevEditorState.read(require("Lexical").$getSelection);
if(!require("Lexical").$isRangeSelection(prevSelection)||!require("Lexical").$isRangeSelection(selection)||!selection.isCollapsed()){
return;
}
var anchorKey=selection.anchor.key;
var anchorOffset=selection.anchor.offset;
var anchorNode=editorState._nodeMap.get(anchorKey);
if(!require("Lexical").$isTextNode(anchorNode)||!dirtyLeaves.has(anchorKey)||anchorOffset!==1&&anchorOffset>prevSelection.anchor.offset+1){
return;
}
editor.update(function(){

if(anchorNode.hasFormat('code')){
return;
}
var parentNode=anchorNode.getParent();
if(parentNode===null||require("LexicalCode").$isCodeNode(parentNode)){
return;
}
transform(parentNode,anchorNode,selection.anchor.offset);
});
});
}








var createBlockNode=function createBlockNode(createNode){
return function(parentNode,children,match){
var node=createNode(match);
node.append.apply(node,children);
parentNode.replace(node);
node.select(0,0);
};
};



var LIST_INDENT_SIZE=4;
var listReplace=function listReplace(listType){
return function(parentNode,children,match){
var previousNode=parentNode.getPreviousSibling();
var nextNode=parentNode.getNextSibling();
var listItem=require("LexicalList").$createListItemNode(listType==='check'?match[3]==='x':undefined);
if(require("LexicalList").$isListNode(nextNode)&&nextNode.getListType()===listType){
var firstChild=nextNode.getFirstChild();
if(firstChild!==null){
firstChild.insertBefore(listItem);
}else{

nextNode.append(listItem);
}
parentNode.remove();
}else if(require("LexicalList").$isListNode(previousNode)&&previousNode.getListType()===listType){
previousNode.append(listItem);
parentNode.remove();
}else{
var list=require("LexicalList").$createListNode(listType,listType==='number'?Number(match[2]):undefined);
list.append(listItem);
parentNode.replace(list);
}
listItem.append.apply(listItem,children);
listItem.select(0,0);
var indent=Math.floor(match[1].length/LIST_INDENT_SIZE);
if(indent){
listItem.setIndent(indent);
}
};
};
var listExport=function listExport(listNode,exportChildren,depth){
var output=[];
var children=listNode.getChildren();
var index=0;
for(var _iterator20=children,_isArray20=Array.isArray(_iterator20),_i20=0,_iterator20=_isArray20?_iterator20:_iterator20[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref27;if(_isArray20){if(_i20>=_iterator20.length)break;_ref27=_iterator20[_i20++];}else{_i20=_iterator20.next();if(_i20.done)break;_ref27=_i20.value;}var listItemNode=_ref27;
if(require("LexicalList").$isListItemNode(listItemNode)){
if(listItemNode.getChildrenSize()===1){
var firstChild=listItemNode.getFirstChild();
if(require("LexicalList").$isListNode(firstChild)){
output.push(listExport(firstChild,exportChildren,depth+1));
continue;
}
}
var indent=' '.repeat(depth*LIST_INDENT_SIZE);
var listType=listNode.getListType();
var prefix=listType==='number'?listNode.getStart()+index+". ":listType==='check'?"- ["+(listItemNode.getChecked()?'x':' ')+"] ":'- ';
output.push(indent+prefix+exportChildren(listItemNode));
index++;
}
}
return output.join('\n');
};
var HEADING={
dependencies:[require("LexicalRichText").HeadingNode],
"export":function _export(node,exportChildren){
if(!require("LexicalRichText").$isHeadingNode(node)){
return null;
}
var level=Number(node.getTag().slice(1));
return'#'.repeat(level)+' '+exportChildren(node);
},
regExp:/^(#{1,6})\s/,
replace:createBlockNode(function(match){
var tag='h'+match[1].length;
return require("LexicalRichText").$createHeadingNode(tag);
}),
type:'element'};

var QUOTE={
dependencies:[require("LexicalRichText").QuoteNode],
"export":function _export(node,exportChildren){
if(!require("LexicalRichText").$isQuoteNode(node)){
return null;
}
var lines=exportChildren(node).split('\n');
var output=[];
for(var _iterator21=lines,_isArray21=Array.isArray(_iterator21),_i21=0,_iterator21=_isArray21?_iterator21:_iterator21[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref28;if(_isArray21){if(_i21>=_iterator21.length)break;_ref28=_iterator21[_i21++];}else{_i21=_iterator21.next();if(_i21.done)break;_ref28=_i21.value;}var line=_ref28;
output.push('> '+line);
}
return output.join('\n');
},
regExp:/^>\s/,
replace:function replace(parentNode,children,_match,isImport){
if(isImport){
var previousNode=parentNode.getPreviousSibling();
if(require("LexicalRichText").$isQuoteNode(previousNode)){
previousNode.splice(previousNode.getChildrenSize(),0,[require("Lexical").$createLineBreakNode()].concat(children));
previousNode.select(0,0);
parentNode.remove();
return;
}
}
var node=require("LexicalRichText").$createQuoteNode();
node.append.apply(node,children);
parentNode.replace(node);
node.select(0,0);
},
type:'element'};

var CODE={
dependencies:[require("LexicalCode").CodeNode],
"export":function _export(node){
if(!require("LexicalCode").$isCodeNode(node)){
return null;
}
var textContent=node.getTextContent();
return'```'+(node.getLanguage()||'')+(textContent?'\n'+textContent:'')+'\n'+'```';
},
regExp:/^```(\w{1,10})?\s/,
replace:createBlockNode(function(match){
return require("LexicalCode").$createCodeNode(match?match[1]:undefined);
}),
type:'element'};

var UNORDERED_LIST={
dependencies:[require("LexicalList").ListNode,require("LexicalList").ListItemNode],
"export":function _export(node,exportChildren){
return require("LexicalList").$isListNode(node)?listExport(node,exportChildren,0):null;
},
regExp:/^(\s*)[-*+]\s/,
replace:listReplace('bullet'),
type:'element'};

var CHECK_LIST={
dependencies:[require("LexicalList").ListNode,require("LexicalList").ListItemNode],
"export":function _export(node,exportChildren){
return require("LexicalList").$isListNode(node)?listExport(node,exportChildren,0):null;
},
regExp:/^(\s*)(?:-\s)?\s?(\[(\s|x)?\])\s/i,
replace:listReplace('check'),
type:'element'};

var ORDERED_LIST={
dependencies:[require("LexicalList").ListNode,require("LexicalList").ListItemNode],
"export":function _export(node,exportChildren){
return require("LexicalList").$isListNode(node)?listExport(node,exportChildren,0):null;
},
regExp:/^(\s*)(\d{1,})\.\s/,
replace:listReplace('number'),
type:'element'};

var INLINE_CODE={
format:['code'],
tag:'`',
type:'text-format'};

var HIGHLIGHT={
format:['highlight'],
tag:'==',
type:'text-format'};

var BOLD_ITALIC_STAR={
format:['bold','italic'],
tag:'***',
type:'text-format'};

var BOLD_ITALIC_UNDERSCORE={
format:['bold','italic'],
intraword:false,
tag:'___',
type:'text-format'};

var BOLD_STAR={
format:['bold'],
tag:'**',
type:'text-format'};

var BOLD_UNDERSCORE={
format:['bold'],
intraword:false,
tag:'__',
type:'text-format'};

var STRIKETHROUGH={
format:['strikethrough'],
tag:'~~',
type:'text-format'};

var ITALIC_STAR={
format:['italic'],
tag:'*',
type:'text-format'};

var ITALIC_UNDERSCORE={
format:['italic'],
intraword:false,
tag:'_',
type:'text-format'};






var LINK={
dependencies:[require("LexicalLink").LinkNode],
"export":function _export(node,exportChildren,exportFormat){
if(!require("LexicalLink").$isLinkNode(node)){
return null;
}
var title=node.getTitle();
var linkContent=title?"["+node.getTextContent()+"]("+node.getURL()+" \""+title+"\")":"["+node.getTextContent()+"]("+node.getURL()+")";
var firstChild=node.getFirstChild();


if(node.getChildrenSize()===1&&require("Lexical").$isTextNode(firstChild)){
return exportFormat(firstChild,linkContent);
}else{
return linkContent;
}
},
importRegExp:/(?:\[([^[]+)\])(?:\((?:([^()\s]+)(?:\s\"((?:[^\"]*\\")*[^\"]*)\"\s*)?)\))/,
regExp:/(?:\[([^[]+)\])(?:\((?:([^()\s]+)(?:\s\"((?:[^\"]*\\")*[^\"]*)\"\s*)?)\))$/,
replace:function replace(textNode,match){var
linkText=match[1],linkUrl=match[2],linkTitle=match[3];
var linkNode=require("LexicalLink").$createLinkNode(linkUrl,{
title:linkTitle});

var linkTextNode=require("Lexical").$createTextNode(linkText);
linkTextNode.setFormat(textNode.getFormat());
linkNode.append(linkTextNode);
textNode.replace(linkNode);
},
trigger:')',
type:'text-match'};



var ELEMENT_TRANSFORMERS=[HEADING,QUOTE,CODE,UNORDERED_LIST,ORDERED_LIST];





var TEXT_FORMAT_TRANSFORMERS=[INLINE_CODE,BOLD_ITALIC_STAR,BOLD_ITALIC_UNDERSCORE,BOLD_STAR,BOLD_UNDERSCORE,HIGHLIGHT,ITALIC_STAR,ITALIC_UNDERSCORE,STRIKETHROUGH];
var TEXT_MATCH_TRANSFORMERS=[LINK];
var TRANSFORMERS=[].concat(ELEMENT_TRANSFORMERS,TEXT_FORMAT_TRANSFORMERS,TEXT_MATCH_TRANSFORMERS);
function $convertFromMarkdownString(markdown,transformers,node){if(transformers===void 0){transformers=TRANSFORMERS;}
var importMarkdown=createMarkdownImport(transformers);
return importMarkdown(markdown,node);
}
function $convertToMarkdownString(transformers,node){if(transformers===void 0){transformers=TRANSFORMERS;}
var exportMarkdown=createMarkdownExport(transformers);
return exportMarkdown(node);
}

exports.$convertFromMarkdownString=$convertFromMarkdownString;
exports.$convertToMarkdownString=$convertToMarkdownString;
exports.BOLD_ITALIC_STAR=BOLD_ITALIC_STAR;
exports.BOLD_ITALIC_UNDERSCORE=BOLD_ITALIC_UNDERSCORE;
exports.BOLD_STAR=BOLD_STAR;
exports.BOLD_UNDERSCORE=BOLD_UNDERSCORE;
exports.CHECK_LIST=CHECK_LIST;
exports.CODE=CODE;
exports.ELEMENT_TRANSFORMERS=ELEMENT_TRANSFORMERS;
exports.HEADING=HEADING;
exports.HIGHLIGHT=HIGHLIGHT;
exports.INLINE_CODE=INLINE_CODE;
exports.ITALIC_STAR=ITALIC_STAR;
exports.ITALIC_UNDERSCORE=ITALIC_UNDERSCORE;
exports.LINK=LINK;
exports.ORDERED_LIST=ORDERED_LIST;
exports.QUOTE=QUOTE;
exports.STRIKETHROUGH=STRIKETHROUGH;
exports.TEXT_FORMAT_TRANSFORMERS=TEXT_FORMAT_TRANSFORMERS;
exports.TEXT_MATCH_TRANSFORMERS=TEXT_MATCH_TRANSFORMERS;
exports.TRANSFORMERS=TRANSFORMERS;
exports.UNORDERED_LIST=UNORDERED_LIST;
exports.registerMarkdownShortcuts=registerMarkdownShortcuts;}),null);