/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalTypeaheadMenuPlugin.dev",["Lexical","LexicalComposerContext","LexicalUtils","react"],(function $module_LexicalTypeaheadMenuPlugin_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;



var React=_require_closure_react||(_require_closure_react=require("react"));










var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var useLayoutEffectImpl=CAN_USE_DOM?React.useLayoutEffect:React.useEffect;
var useLayoutEffect=useLayoutEffectImpl;var








MenuOption=function(){
function MenuOption(key){
this.key=key;
this.ref={
current:null};

this.setRefElement=this.setRefElement.bind(this);
}var _proto=MenuOption.prototype;_proto.
setRefElement=function setRefElement(element){
this.ref={
current:element};

};return MenuOption;}();

var scrollIntoViewIfNeeded=function scrollIntoViewIfNeeded(target){
var typeaheadContainerNode=document.getElementById('typeahead-menu');
if(!typeaheadContainerNode)return;
var typeaheadRect=typeaheadContainerNode.getBoundingClientRect();
if(typeaheadRect.top+typeaheadRect.height>window.innerHeight){
typeaheadContainerNode.scrollIntoView({
block:'center'});

}
if(typeaheadRect.top<0){
typeaheadContainerNode.scrollIntoView({
block:'center'});

}
target.scrollIntoView({
block:'nearest'});

};





function getFullMatchOffset(documentText,entryText,offset){
var triggerOffset=offset;
for(var i=triggerOffset;i<=entryText.length;i++){
if(documentText.substr(-i)===entryText.substr(0,i)){
triggerOffset=i;
}
}
return triggerOffset;
}





function $splitNodeContainingQuery(match){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)||!selection.isCollapsed()){
return null;
}
var anchor=selection.anchor;
if(anchor.type!=='text'){
return null;
}
var anchorNode=anchor.getNode();
if(!anchorNode.isSimpleText()){
return null;
}
var selectionOffset=anchor.offset;
var textContent=anchorNode.getTextContent().slice(0,selectionOffset);
var characterOffset=match.replaceableString.length;
var queryOffset=getFullMatchOffset(textContent,match.matchingString,characterOffset);
var startOffset=selectionOffset-queryOffset;
if(startOffset<0){
return null;
}
var newNode;
if(startOffset===0){var _anchorNode$splitText=
anchorNode.splitText(selectionOffset);newNode=_anchorNode$splitText[0];
}else{var _anchorNode$splitText2=
anchorNode.splitText(startOffset,selectionOffset);newNode=_anchorNode$splitText2[1];
}
return newNode;
}


function getScrollParent$1(element,includeHidden){
var style=getComputedStyle(element);
var excludeStaticParent=style.position==='absolute';
var overflowRegex=includeHidden?/(auto|scroll|hidden)/:/(auto|scroll)/;
if(style.position==='fixed'){
return document.body;
}
for(var parent=element;parent=parent.parentElement;){
style=getComputedStyle(parent);
if(excludeStaticParent&&style.position==='static'){
continue;
}
if(overflowRegex.test(style.overflow+style.overflowY+style.overflowX)){
return parent;
}
}
return document.body;
}
function isTriggerVisibleInNearestScrollContainer(targetElement,containerElement){
var tRect=targetElement.getBoundingClientRect();
var cRect=containerElement.getBoundingClientRect();
return tRect.top>cRect.top&&tRect.top<cRect.bottom;
}


function useDynamicPositioning(resolution,targetElement,onReposition,onVisibilityChange){var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];
React.useEffect(function(){
if(targetElement!=null&&resolution!=null){
var rootElement=editor.getRootElement();
var rootScrollParent=rootElement!=null?getScrollParent$1(rootElement,false):document.body;
var ticking=false;
var previousIsInView=isTriggerVisibleInNearestScrollContainer(targetElement,rootScrollParent);
var handleScroll=function handleScroll(){
if(!ticking){
window.requestAnimationFrame(function(){
onReposition();
ticking=false;
});
ticking=true;
}
var isInView=isTriggerVisibleInNearestScrollContainer(targetElement,rootScrollParent);
if(isInView!==previousIsInView){
previousIsInView=isInView;
if(onVisibilityChange!=null){
onVisibilityChange(isInView);
}
}
};
var resizeObserver=new ResizeObserver(onReposition);
window.addEventListener('resize',onReposition);
document.addEventListener('scroll',handleScroll,{
capture:true,
passive:true});

resizeObserver.observe(targetElement);
return function(){
resizeObserver.unobserve(targetElement);
window.removeEventListener('resize',onReposition);
document.removeEventListener('scroll',handleScroll,true);
};
}
},[targetElement,editor,onVisibilityChange,onReposition,resolution]);
}
var SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND$1=require("Lexical").createCommand('SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND');
function LexicalMenu(_ref)









{var close=_ref.close,editor=_ref.editor,anchorElementRef=_ref.anchorElementRef,resolution=_ref.resolution,options=_ref.options,menuRenderFn=_ref.menuRenderFn,onSelectOption=_ref.onSelectOption,_ref$shouldSplitNodeW=_ref.shouldSplitNodeWithQuery,shouldSplitNodeWithQuery=_ref$shouldSplitNodeW===void 0?false:_ref$shouldSplitNodeW,_ref$commandPriority=_ref.commandPriority,commandPriority=_ref$commandPriority===void 0?require("Lexical").COMMAND_PRIORITY_LOW:_ref$commandPriority;var _React$useState=
React.useState(null),selectedIndex=_React$useState[0],setHighlightedIndex=_React$useState[1];
var matchingString=resolution.match&&resolution.match.matchingString;
React.useEffect(function(){
setHighlightedIndex(0);
},[matchingString]);
var selectOptionAndCleanUp=React.useCallback(function(selectedEntry){
editor.update(function(){
var textNodeContainingQuery=resolution.match!=null&&shouldSplitNodeWithQuery?$splitNodeContainingQuery(resolution.match):null;
onSelectOption(selectedEntry,textNodeContainingQuery,close,resolution.match?resolution.match.matchingString:'');
});
},[editor,shouldSplitNodeWithQuery,resolution.match,onSelectOption,close]);
var updateSelectedIndex=React.useCallback(function(index){
var rootElem=editor.getRootElement();
if(rootElem!==null){
rootElem.setAttribute('aria-activedescendant','typeahead-item-'+index);
setHighlightedIndex(index);
}
},[editor]);
React.useEffect(function(){
return function(){
var rootElem=editor.getRootElement();
if(rootElem!==null){
rootElem.removeAttribute('aria-activedescendant');
}
};
},[editor]);
useLayoutEffect(function(){
if(options===null){
setHighlightedIndex(null);
}else if(selectedIndex===null){
updateSelectedIndex(0);
}
},[options,selectedIndex,updateSelectedIndex]);
React.useEffect(function(){
return require("LexicalUtils").mergeRegister(editor.registerCommand(SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND$1,function(_ref2)

{var option=_ref2.option;
if(option.ref&&option.ref.current!=null){
scrollIntoViewIfNeeded(option.ref.current);
return true;
}
return false;
},commandPriority));
},[editor,updateSelectedIndex,commandPriority]);
React.useEffect(function(){var _require_Lexical;
return require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).KEY_ARROW_DOWN_COMMAND,function(payload){
var event=payload;
if(options!==null&&options.length&&selectedIndex!==null){
var newSelectedIndex=selectedIndex!==options.length-1?selectedIndex+1:0;
updateSelectedIndex(newSelectedIndex);
var option=options[newSelectedIndex];
if(option.ref!=null&&option.ref.current){
editor.dispatchCommand(SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND$1,{
index:newSelectedIndex,
option:option});

}
event.preventDefault();
event.stopImmediatePropagation();
}
return true;
},commandPriority),editor.registerCommand(_require_Lexical.KEY_ARROW_UP_COMMAND,function(payload){
var event=payload;
if(options!==null&&options.length&&selectedIndex!==null){
var newSelectedIndex=selectedIndex!==0?selectedIndex-1:options.length-1;
updateSelectedIndex(newSelectedIndex);
var option=options[newSelectedIndex];
if(option.ref!=null&&option.ref.current){
scrollIntoViewIfNeeded(option.ref.current);
}
event.preventDefault();
event.stopImmediatePropagation();
}
return true;
},commandPriority),editor.registerCommand(_require_Lexical.KEY_ESCAPE_COMMAND,function(payload){
var event=payload;
event.preventDefault();
event.stopImmediatePropagation();
close();
return true;
},commandPriority),editor.registerCommand(_require_Lexical.KEY_TAB_COMMAND,function(payload){
var event=payload;
if(options===null||selectedIndex===null||options[selectedIndex]==null){
return false;
}
event.preventDefault();
event.stopImmediatePropagation();
selectOptionAndCleanUp(options[selectedIndex]);
return true;
},commandPriority),editor.registerCommand(_require_Lexical.KEY_ENTER_COMMAND,function(event){
if(options===null||selectedIndex===null||options[selectedIndex]==null){
return false;
}
if(event!==null){
event.preventDefault();
event.stopImmediatePropagation();
}
selectOptionAndCleanUp(options[selectedIndex]);
return true;
},commandPriority));
},[selectOptionAndCleanUp,close,editor,options,selectedIndex,updateSelectedIndex,commandPriority]);
var listItemProps=React.useMemo(function(){return{
options:options,
selectOptionAndCleanUp:selectOptionAndCleanUp,
selectedIndex:selectedIndex,
setHighlightedIndex:setHighlightedIndex};},
[selectOptionAndCleanUp,selectedIndex,options]);
return menuRenderFn(anchorElementRef,listItemProps,resolution.match?resolution.match.matchingString:'');
}
function useMenuAnchorRef(resolution,setResolution,className,parent){if(parent===void 0){parent=document.body;}var _LexicalComposerConte2=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte2[0];
var anchorElementRef=React.useRef(document.createElement('div'));
var positionMenu=React.useCallback(function(){
anchorElementRef.current.style.top=anchorElementRef.current.style.bottom;
var rootElement=editor.getRootElement();
var containerDiv=anchorElementRef.current;
var menuEle=containerDiv.firstChild;
if(rootElement!==null&&resolution!==null){var _resolution$getRect=





resolution.getRect(),left=_resolution$getRect.left,top=_resolution$getRect.top,width=_resolution$getRect.width,height=_resolution$getRect.height;
var anchorHeight=anchorElementRef.current.offsetHeight;
containerDiv.style.top=top+window.pageYOffset+anchorHeight+3+"px";
containerDiv.style.left=left+window.pageXOffset+"px";
containerDiv.style.height=height+"px";
containerDiv.style.width=width+"px";
if(menuEle!==null){
menuEle.style.top=""+top;
var menuRect=menuEle.getBoundingClientRect();
var menuHeight=menuRect.height;
var menuWidth=menuRect.width;
var rootElementRect=rootElement.getBoundingClientRect();
if(left+menuWidth>rootElementRect.right){
containerDiv.style.left=rootElementRect.right-menuWidth+window.pageXOffset+"px";
}
if((top+menuHeight>window.innerHeight||top+menuHeight>rootElementRect.bottom)&&top-rootElementRect.top>menuHeight){
containerDiv.style.top=top-menuHeight+window.pageYOffset-height+"px";
}
}
if(!containerDiv.isConnected){
if(className!=null){
containerDiv.className=className;
}
containerDiv.setAttribute('aria-label','Typeahead menu');
containerDiv.setAttribute('id','typeahead-menu');
containerDiv.setAttribute('role','listbox');
containerDiv.style.display='block';
containerDiv.style.position='absolute';
parent.append(containerDiv);
}
anchorElementRef.current=containerDiv;
rootElement.setAttribute('aria-controls','typeahead-menu');
}
},[editor,resolution,className,parent]);
React.useEffect(function(){
var rootElement=editor.getRootElement();
if(resolution!==null){
positionMenu();
return function(){
if(rootElement!==null){
rootElement.removeAttribute('aria-controls');
}
var containerDiv=anchorElementRef.current;
if(containerDiv!==null&&containerDiv.isConnected){
containerDiv.remove();
}
};
}
},[editor,positionMenu,resolution]);
var onVisibilityChange=React.useCallback(function(isInView){
if(resolution!==null){
if(!isInView){
setResolution(null);
}
}
},[resolution,setResolution]);
useDynamicPositioning(resolution,anchorElementRef.current,positionMenu,onVisibilityChange);
return anchorElementRef;
}








var PUNCTUATION='\\.,\\+\\*\\?\\$\\@\\|#{}\\(\\)\\^\\-\\[\\]\\\\/!%\'"~=<>_:;';
function getTextUpToAnchor(selection){
var anchor=selection.anchor;
if(anchor.type!=='text'){
return null;
}
var anchorNode=anchor.getNode();
if(!anchorNode.isSimpleText()){
return null;
}
var anchorOffset=anchor.offset;
return anchorNode.getTextContent().slice(0,anchorOffset);
}
function tryToPositionRange(leadOffset,range,editorWindow){
var domSelection=editorWindow.getSelection();
if(domSelection===null||!domSelection.isCollapsed){
return false;
}
var anchorNode=domSelection.anchorNode;
var startOffset=leadOffset;
var endOffset=domSelection.anchorOffset;
if(anchorNode==null||endOffset==null){
return false;
}
try{
range.setStart(anchorNode,startOffset);
range.setEnd(anchorNode,endOffset);
}catch(error){
return false;
}
return true;
}
function getQueryTextForSearch(editor){
var text=null;
editor.getEditorState().read(function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return;
}
text=getTextUpToAnchor(selection);
});
return text;
}
function isSelectionOnEntityBoundary(editor,offset){
if(offset!==0){
return false;
}
return editor.getEditorState().read(function(){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){
var anchor=selection.anchor;
var anchorNode=anchor.getNode();
var prevSibling=anchorNode.getPreviousSibling();
return require("Lexical").$isTextNode(prevSibling)&&prevSibling.isTextEntity();
}
return false;
});
}
function startTransition(callback){
if(React.startTransition){
React.startTransition(callback);
}else{
callback();
}
}


function getScrollParent(element,includeHidden){
var style=getComputedStyle(element);
var excludeStaticParent=style.position==='absolute';
var overflowRegex=includeHidden?/(auto|scroll|hidden)/:/(auto|scroll)/;
if(style.position==='fixed'){
return document.body;
}
for(var parent=element;parent=parent.parentElement;){
style=getComputedStyle(parent);
if(excludeStaticParent&&style.position==='static'){
continue;
}
if(overflowRegex.test(style.overflow+style.overflowY+style.overflowX)){
return parent;
}
}
return document.body;
}
var SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND=require("Lexical").createCommand('SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND');
function useBasicTypeaheadTriggerMatch(trigger,_ref3)


{var _ref3$minLength=_ref3.minLength,minLength=_ref3$minLength===void 0?1:_ref3$minLength,_ref3$maxLength=_ref3.maxLength,maxLength=_ref3$maxLength===void 0?75:_ref3$maxLength;
return React.useCallback(function(text){
var validChars='[^'+trigger+PUNCTUATION+'\\s]';
var TypeaheadTriggerRegex=new RegExp('(^|\\s|\\()('+'['+trigger+']'+'((?:'+validChars+'){0,'+maxLength+'})'+')$');
var match=TypeaheadTriggerRegex.exec(text);
if(match!==null){
var maybeLeadingWhitespace=match[1];
var matchingString=match[3];
if(matchingString.length>=minLength){
return{
leadOffset:match.index+maybeLeadingWhitespace.length,
matchingString:matchingString,
replaceableString:match[2]};

}
}
return null;
},[maxLength,minLength,trigger]);
}
function LexicalTypeaheadMenuPlugin(_ref4)










{var options=_ref4.options,onQueryChange=_ref4.onQueryChange,onSelectOption=_ref4.onSelectOption,onOpen=_ref4.onOpen,onClose=_ref4.onClose,menuRenderFn=_ref4.menuRenderFn,triggerFn=_ref4.triggerFn,anchorClassName=_ref4.anchorClassName,_ref4$commandPriority=_ref4.commandPriority,commandPriority=_ref4$commandPriority===void 0?require("Lexical").COMMAND_PRIORITY_LOW:_ref4$commandPriority,parent=_ref4.parent;var _LexicalComposerConte3=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte3[0];var _React$useState2=
React.useState(null),resolution=_React$useState2[0],setResolution=_React$useState2[1];
var anchorElementRef=useMenuAnchorRef(resolution,setResolution,anchorClassName,parent);
var closeTypeahead=React.useCallback(function(){
setResolution(null);
if(onClose!=null&&resolution!==null){
onClose();
}
},[onClose,resolution]);
var openTypeahead=React.useCallback(function(res){
setResolution(res);
if(onOpen!=null&&resolution===null){
onOpen(res);
}
},[onOpen,resolution]);
React.useEffect(function(){
var updateListener=function updateListener(){
editor.getEditorState().read(function(){
var editorWindow=editor._window||window;
var range=editorWindow.document.createRange();
var selection=require("Lexical").$getSelection();
var text=getQueryTextForSearch(editor);
if(!require("Lexical").$isRangeSelection(selection)||!selection.isCollapsed()||text===null||range===null){
closeTypeahead();
return;
}
var match=triggerFn(text,editor);
onQueryChange(match?match.matchingString:null);
if(match!==null&&!isSelectionOnEntityBoundary(editor,match.leadOffset)){
var isRangePositioned=tryToPositionRange(match.leadOffset,range,editorWindow);
if(isRangePositioned!==null){
startTransition(function(){return openTypeahead({
getRect:function getRect(){return range.getBoundingClientRect();},
match:match});});

return;
}
}
closeTypeahead();
});
};
var removeUpdateListener=editor.registerUpdateListener(updateListener);
return function(){
removeUpdateListener();
};
},[editor,triggerFn,onQueryChange,resolution,closeTypeahead,openTypeahead]);
return resolution===null||editor===null?null:React.createElement(LexicalMenu,{
close:closeTypeahead,
resolution:resolution,
editor:editor,
anchorElementRef:anchorElementRef,
options:options,
menuRenderFn:menuRenderFn,
shouldSplitNodeWithQuery:true,
onSelectOption:onSelectOption,
commandPriority:commandPriority});

}

exports.LexicalTypeaheadMenuPlugin=LexicalTypeaheadMenuPlugin;
exports.MenuOption=MenuOption;
exports.PUNCTUATION=PUNCTUATION;
exports.SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND=SCROLL_TYPEAHEAD_OPTION_INTO_VIEW_COMMAND;
exports.getScrollParent=getScrollParent;
exports.useBasicTypeaheadTriggerMatch=useBasicTypeaheadTriggerMatch;
exports.useDynamicPositioning=useDynamicPositioning;}),null);