/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalText.dev",["Lexical"],(function $module_LexicalText_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';











function $findTextIntersectionFromCharacters(root,targetCharacters){
var node=root.getFirstChild();
var currentCharacters=0;
mainLoop:while(node!==null){
if(require("Lexical").$isElementNode(node)){
var child=node.getFirstChild();
if(child!==null){
node=child;
continue;
}
}else if(require("Lexical").$isTextNode(node)){
var characters=node.getTextContentSize();
if(currentCharacters+characters>targetCharacters){
return{
node:node,
offset:targetCharacters-currentCharacters};

}
currentCharacters+=characters;
}
var sibling=node.getNextSibling();
if(sibling!==null){
node=sibling;
continue;
}
var parent=node.getParent();
while(parent!==null){
var parentSibling=parent.getNextSibling();
if(parentSibling!==null){
node=parentSibling;
continue mainLoop;
}
parent=parent.getParent();
}
break;
}
return null;
}







function $isRootTextContentEmpty(isEditorComposing,trim){if(trim===void 0){trim=true;}
if(isEditorComposing){
return false;
}
var text=$rootTextContent();
if(trim){
text=text.trim();
}
return text==='';
}







function $isRootTextContentEmptyCurry(isEditorComposing,trim){
return function(){return $isRootTextContentEmpty(isEditorComposing,trim);};
}





function $rootTextContent(){
var root=require("Lexical").$getRoot();
return root.getTextContent();
}







function $canShowPlaceholder(isComposing){
if(!$isRootTextContentEmpty(isComposing,false)){
return false;
}
var root=require("Lexical").$getRoot();
var children=root.getChildren();
var childrenLength=children.length;
if(childrenLength>1){
return false;
}
for(var i=0;i<childrenLength;i++){
var topBlock=children[i];
if(require("Lexical").$isDecoratorNode(topBlock)){
return false;
}
if(require("Lexical").$isElementNode(topBlock)){
if(!require("Lexical").$isParagraphNode(topBlock)){
return false;
}
if(topBlock.__indent!==0){
return false;
}
var topBlockChildren=topBlock.getChildren();
var topBlockChildrenLength=topBlockChildren.length;
for(var s=0;s<topBlockChildrenLength;s++){
var child=topBlockChildren[i];
if(!require("Lexical").$isTextNode(child)){
return false;
}
}
}
}
return true;
}






function $canShowPlaceholderCurry(isEditorComposing){
return function(){return $canShowPlaceholder(isEditorComposing);};
}



















function registerLexicalTextEntity(editor,getMatch,targetNode,createNode){
var isTargetNode=function isTargetNode(node){
return node instanceof targetNode;
};
var replaceWithSimpleText=function replaceWithSimpleText(node){
var textNode=require("Lexical").$createTextNode(node.getTextContent());
textNode.setFormat(node.getFormat());
node.replace(textNode);
};
var getMode=function getMode(node){
return node.getLatest().__mode;
};
var textNodeTransform=function textNodeTransform(node){
if(!node.isSimpleText()){
return;
}
var prevSibling=node.getPreviousSibling();
var text=node.getTextContent();
var currentNode=node;
var match;
if(require("Lexical").$isTextNode(prevSibling)){
var previousText=prevSibling.getTextContent();
var combinedText=previousText+text;
var prevMatch=getMatch(combinedText);
if(isTargetNode(prevSibling)){
if(prevMatch===null||getMode(prevSibling)!==0){
replaceWithSimpleText(prevSibling);
return;
}else{
var diff=prevMatch.end-previousText.length;
if(diff>0){
var concatText=text.slice(0,diff);
var newTextContent=previousText+concatText;
prevSibling.select();
prevSibling.setTextContent(newTextContent);
if(diff===text.length){
node.remove();
}else{
var remainingText=text.slice(diff);
node.setTextContent(remainingText);
}
return;
}
}
}else if(prevMatch===null||prevMatch.start<previousText.length){
return;
}
}


while(true){
match=getMatch(text);
var nextText=match===null?'':text.slice(match.end);
text=nextText;
if(nextText===''){
var nextSibling=currentNode.getNextSibling();
if(require("Lexical").$isTextNode(nextSibling)){
nextText=currentNode.getTextContent()+nextSibling.getTextContent();
var nextMatch=getMatch(nextText);
if(nextMatch===null){
if(isTargetNode(nextSibling)){
replaceWithSimpleText(nextSibling);
}else{
nextSibling.markDirty();
}
return;
}else if(nextMatch.start!==0){
return;
}
}
}else{
var _nextMatch=getMatch(nextText);
if(_nextMatch!==null&&_nextMatch.start===0){
return;
}
}
if(match===null){
return;
}
if(match.start===0&&require("Lexical").$isTextNode(prevSibling)&&prevSibling.isTextEntity()){
continue;
}
var nodeToReplace=void 0;
if(match.start===0){var _currentNode$splitTex=
currentNode.splitText(match.end);nodeToReplace=_currentNode$splitTex[0];currentNode=_currentNode$splitTex[1];
}else{var _currentNode$splitTex2=
currentNode.splitText(match.start,match.end);nodeToReplace=_currentNode$splitTex2[1];currentNode=_currentNode$splitTex2[2];
}
var replacementNode=createNode(nodeToReplace);
replacementNode.setFormat(nodeToReplace.getFormat());
nodeToReplace.replace(replacementNode);
if(currentNode==null){
return;
}
}
};
var reverseNodeTransform=function reverseNodeTransform(node){
var text=node.getTextContent();
var match=getMatch(text);
if(match===null||match.start!==0){
replaceWithSimpleText(node);
return;
}
if(text.length>match.end){

node.splitText(match.end);
return;
}
var prevSibling=node.getPreviousSibling();
if(require("Lexical").$isTextNode(prevSibling)&&prevSibling.isTextEntity()){
replaceWithSimpleText(prevSibling);
replaceWithSimpleText(node);
}
var nextSibling=node.getNextSibling();
if(require("Lexical").$isTextNode(nextSibling)&&nextSibling.isTextEntity()){
replaceWithSimpleText(nextSibling);


if(isTargetNode(node)){
replaceWithSimpleText(node);
}
}
};
var removePlainTextTransform=editor.registerNodeTransform(require("Lexical").TextNode,textNodeTransform);
var removeReverseNodeTransform=editor.registerNodeTransform(targetNode,reverseNodeTransform);
return[removePlainTextTransform,removeReverseNodeTransform];
}

exports.$canShowPlaceholder=$canShowPlaceholder;
exports.$canShowPlaceholderCurry=$canShowPlaceholderCurry;
exports.$findTextIntersectionFromCharacters=$findTextIntersectionFromCharacters;
exports.$isRootTextContentEmpty=$isRootTextContentEmpty;
exports.$isRootTextContentEmptyCurry=$isRootTextContentEmptyCurry;
exports.$rootTextContent=$rootTextContent;
exports.registerLexicalTextEntity=registerLexicalTextEntity;}),null);