__d("source_erlang_TextMateGrammar",[],(function(a,b,c,d,e,f){e.exports="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n\t<key>comment</key>\n\t<string>The recognition of function definitions and compiler directives (such as module, record and macro definitions) requires that each of the aforementioned constructs must be the first string inside a line (except for whitespace).  Also, the function/module/record/macro names must be given unquoted.  -- desp</string>\n\t<key>fileTypes</key>\n\t<array>\n\t\t<string>erl</string>\n\t\t<string>escript</string>\n\t\t<string>hrl</string>\n\t\t<string>xrl</string>\n\t\t<string>yrl</string>\n\t</array>\n\t<key>keyEquivalent</key>\n\t<string>^~E</string>\n\t<key>name</key>\n\t<string>Erlang</string>\n\t<key>patterns</key>\n\t<array>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#module-directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#import-export-directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#behaviour-directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#record-directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#define-directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#macro-directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#directive</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#function</string>\n\t\t</dict>\n\t\t<dict>\n\t\t\t<key>include</key>\n\t\t\t<string>#everything-else</string>\n\t\t</dict>\n\t</array>\n\t<key>repository</key>\n\t<dict>\n\t\t<key>atom</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>(')</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.symbol.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(')</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.symbol.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.other.symbol.quoted.single.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.escape.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.escape.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t<string>(\\\\)([bdefnrstv\\\\'\"]|(\\^)[@-_a-z]|[0-7]{1,3}|x[\\da-fA-F]{2})</string>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>constant.other.symbol.escape.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t<string>\\\\\\^?.?</string>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>invalid.illegal.atom.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>[a-z][a-zA-Z\\d@_]*+</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.other.symbol.unquoted.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>behaviour-directive</key>\n\t\t<dict>\n\t\t\t<key>captures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>keyword.control.directive.behaviour.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>3</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>4</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>entity.name.type.class.behaviour.definition.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>5</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>6</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>match</key>\n\t\t\t<string>^\\s*+(-)\\s*+(behaviour)\\s*+(\\()\\s*+([a-z][a-zA-Z\\d@_]*+)\\s*+(\\))\\s*+(\\.)</string>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.directive.behaviour.erlang</string>\n\t\t</dict>\n\t\t<key>binary</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(&lt;&lt;)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.binary.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(&gt;&gt;)</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.binary.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.structure.binary.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.binary.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.value-size.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(,)|(:)</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#internal-type-specifiers</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>character</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.character.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>constant.character.escape.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.escape.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.escape.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(\\$)((\\\\)([bdefnrstv\\\\'\"]|(\\^)[@-_a-z]|[0-7]{1,3}|x[\\da-fA-F]{2}))</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.character.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\$\\\\\\^?.?</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>invalid.illegal.character.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.character.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(\\$)[ \\S]</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.character.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\$.?</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>invalid.illegal.character.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>comment</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(^[ \\t]+)?(?=%)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.whitespace.comment.leading.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(?!\\G)</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>%</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>0</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.comment.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\n</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>comment.line.percentage.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>define-directive</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+(define)\\s*+(\\()\\s*+([a-zA-Z\\d@_]++)\\s*+</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.define.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.macro.definition.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.define.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>(?=^\\s*+-\\s*+define\\s*+\\(\\s*+[a-zA-Z\\d@_]++\\s*+\\()</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.define.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t\t\t<string>^\\s*+(-)\\s*+(define)\\s*+(\\()\\s*+([a-zA-Z\\d@_]++)\\s*+(\\()</string>\n\t\t\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>keyword.control.directive.define.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>entity.name.function.macro.definition.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t<key>end</key>\n\t\t\t\t\t\t\t<string>(\\))\\s*(,)</string>\n\t\t\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t\t\t<array>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t\t\t<string>,</string>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</array>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t<string>\\|\\||\\||:|;|,|\\.|-&gt;</string>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.define.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>directive</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+([a-z][a-zA-Z\\d@_]*+)\\s*+(\\(?)</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(\\)?)\\s*+(\\.)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+([a-z][a-zA-Z\\d@_]*+)\\s*+(\\.)</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>everything-else</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#comment</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#record-usage</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#macro-usage</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#expression</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#keyword</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#textual-operator</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#language-constant</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#function-call</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#tuple</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#list</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#binary</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#parenthesized-expression</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#character</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#number</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#atom</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#string</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#symbolic-operator</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#variable</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>expression</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(if)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.if.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.if.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-expression-punctuation</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(case)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.case.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.case.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-expression-punctuation</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(receive)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.receive.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.receive.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-expression-punctuation</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(maybe)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.maybe.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.maybe.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-expression-punctuation</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.fun.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>10</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.function-arity.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.module.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>6</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.module-function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>8</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>9</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>comment</key>\n\t\t\t\t\t<string>Implicit function expression with optional module qualifier when both module and function can be atom or variable</string>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\b(fun)\\s+((([a-z][a-zA-Z\\d@_]*+)|(_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+))\\s*+(:)\\s*+)?(([a-z][a-zA-Z\\d@_]*+|'[^']*+')|(_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+))\\s*(/)</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.fun.implicit.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(fun)\\s+(([a-z][a-zA-Z\\d@_]*+)|(_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+))\\s*+(:)</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.fun.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.module.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.module-function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>comment</key>\n\t\t\t\t\t<string>Implicit function expression with module qualifier when module can be atom or variable and function can by anything</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(/)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.function-arity.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.fun.implicit.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(fun)\\s+(?!\\()</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.fun.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>comment</key>\n\t\t\t\t\t<string>Implicit function expression when both module and function can by anything</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(/)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.function-arity.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.fun.implicit.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(fun)\\s*+(\\()(?=(\\s*+\\())</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>comment</key>\n\t\t\t\t\t<string>Function type in type specification</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(\\))</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(fun)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.fun.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>comment</key>\n\t\t\t\t\t<string>Explicit function expression</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.fun.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t\t\t<string>(?=\\()</string>\n\t\t\t\t\t\t\t<key>end</key>\n\t\t\t\t\t\t\t<string>(;)|(?=\\bend\\b)</string>\n\t\t\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.separator.clauses.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t\t\t<array>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t\t\t<string>#internal-function-parts</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</array>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(try)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.try.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.try.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-expression-punctuation</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>\\b(begin)\\b</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>\\b(end)\\b</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.expression.begin.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-expression-punctuation</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>function</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>^\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')\\s*+(?=\\()</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>entity.name.function.definition.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\.)</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.terminator.function.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.function.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>^\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')\\s*+(?=\\()</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>(?=\\()</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(;)|(?=\\.)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.clauses.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#parenthesized-expression</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-function-parts</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>function-call</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(?=([a-z][a-zA-Z\\d@_]*+|'[^']*+'|_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+)\\s*+(\\(|:\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+'|_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+)\\s*+\\())</string>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\))</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.function-call.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>((erlang)\\s*+(:)\\s*+)?(is_atom|is_binary|is_constant|is_float|is_function|is_integer|is_list|is_number|is_pid|is_port|is_reference|is_tuple|is_record|abs|element|hd|length|node|round|self|size|tl|trunc)\\s*+(\\()</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.module.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.module-function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.guard.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(?=\\))</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t<string>,</string>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>((([a-z][a-zA-Z\\d@_]*+|'[^']*+')|(_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+))\\s*+(:)\\s*+)?(([a-z][a-zA-Z\\d@_]*+|'[^']*+')|(_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+))\\s*+(\\()</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.module.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.module-function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>7</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>8</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>9</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(?=\\))</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t<string>,</string>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>import-export-directive</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+(import)\\s*+(\\()\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')\\s*+(,)</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.import.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.module.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.import.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-function-list</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+(export)\\s*+(\\()</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.export.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.export.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-function-list</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>internal-expression-punctuation</key>\n\t\t<dict>\n\t\t\t<key>captures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.clause-head-body.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.clauses.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>3</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.expressions.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>match</key>\n\t\t\t<string>(-&gt;)|(;)|(,)</string>\n\t\t</dict>\n\t\t<key>internal-function-list</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(\\[)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.list.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\])</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.list.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.structure.list.function.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>([a-z][a-zA-Z\\d@_]*+|'[^']*+')\\s*+(/)</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.function-arity.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(,)|(?=\\])</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.list.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>internal-function-parts</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>(?=\\()</string>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(-&gt;)</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.clause-head-body.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t\t\t<string>(\\()</string>\n\t\t\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t<key>end</key>\n\t\t\t\t\t\t\t<string>(\\))</string>\n\t\t\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t\t\t<array>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t\t\t<string>,</string>\n\t\t\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t\t</array>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>match</key>\n\t\t\t\t\t\t\t<string>,|;</string>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.guards.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>,</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.expressions.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>internal-record-body</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(\\{)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.class.record.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\})</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.class.record.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.structure.record.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>(([a-z][a-zA-Z\\d@_]*+|'[^']*+')|(_))</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.field.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.language.omitted.field.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(,)|(?=\\})</string>\n\t\t\t\t\t<key>endCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.class.record.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>internal-type-specifiers</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(/)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.value-type.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(?=,|:|&gt;&gt;)</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>storage.type.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>storage.modifier.signedness.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>storage.modifier.endianness.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>storage.modifier.unit.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.unit-specifiers.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>6</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>constant.numeric.integer.decimal.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>7</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.type-specifiers.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(integer|float|binary|bytes|bitstring|bits|utf8|utf16|utf32)|(signed|unsigned)|(big|little|native)|(unit)(:)(\\d++)|(-)</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>keyword</key>\n\t\t<dict>\n\t\t\t<key>match</key>\n\t\t\t<string>\\b(after|begin|case|catch|cond|else|end|fun|if|let|maybe|of|try|receive|when)\\b</string>\n\t\t\t<key>name</key>\n\t\t\t<string>keyword.control.erlang</string>\n\t\t</dict>\n\t\t<key>language-constant</key>\n\t\t<dict>\n\t\t\t<key>match</key>\n\t\t\t<string>\\b(false|true|undefined)\\b</string>\n\t\t\t<key>name</key>\n\t\t\t<string>constant.language</string>\n\t\t</dict>\n\t\t<key>list</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(\\[)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.list.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\])</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.list.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.structure.list.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\||\\|\\||,</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.list.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>macro-directive</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.ifdef.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.macro.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>6</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+(ifdef)\\s*+(\\()\\s*+([a-zA-z\\d@_]++)\\s*+(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.ifdef.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.ifndef.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.macro.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>6</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+(ifndef)\\s*+(\\()\\s*+([a-zA-z\\d@_]++)\\s*+(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.ifndef.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.control.directive.undef.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.function.macro.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>5</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>6</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>^\\s*+(-)\\s*+(undef)\\s*+(\\()\\s*+([a-zA-z\\d@_]++)\\s*+(\\))\\s*+(\\.)</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.directive.undef.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>macro-usage</key>\n\t\t<dict>\n\t\t\t<key>captures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>keyword.operator.macro.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>entity.name.function.macro.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>match</key>\n\t\t\t<string>(\\?\\??)\\s*+([a-zA-Z\\d@_]++)</string>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.macro-usage.erlang</string>\n\t\t</dict>\n\t\t<key>module-directive</key>\n\t\t<dict>\n\t\t\t<key>captures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>keyword.control.directive.module.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>3</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>4</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>entity.name.type.class.module.definition.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>5</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>6</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>match</key>\n\t\t\t<string>^\\s*+(-)\\s*+(module)\\s*+(\\()\\s*+([a-z][a-zA-Z\\d@_]*+)\\s*+(\\))\\s*+(\\.)</string>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.directive.module.erlang</string>\n\t\t</dict>\n\t\t<key>number</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(?=\\d)</string>\n\t\t\t<key>end</key>\n\t\t\t<string>(?!\\d)</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.integer-float.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.float-exponent.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\d++(\\.)\\d++([eE][\\+\\-]?\\d++)?</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.float.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>2(#)([0-1]++_)*[0-1]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.binary.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>3(#)([0-2]++_)*[0-2]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-3.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>4(#)([0-3]++_)*[0-3]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-4.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>5(#)([0-4]++_)*[0-4]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-5.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>6(#)([0-5]++_)*[0-5]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-6.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>7(#)([0-6]++_)*[0-6]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-7.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>8(#)([0-7]++_)*[0-7]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.octal.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>9(#)([0-8]++_)*[0-8]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-9.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>10(#)(\\d++_)*\\d++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.decimal.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>11(#)([\\daA]++_)*[\\daA]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-11.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>12(#)([\\da-bA-B]++_)*[\\da-bA-B]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-12.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>13(#)([\\da-cA-C]++_)*[\\da-cA-C]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-13.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>14(#)([\\da-dA-D]++_)*[\\da-dA-D]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-14.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>15(#)([\\da-eA-E]++_)*[\\da-eA-E]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-15.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>16(#)([\\da-fA-F]++_)*[\\da-fA-F]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.hexadecimal.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>17(#)([\\da-gA-G]++_)*[\\da-gA-G]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-17.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>18(#)([\\da-hA-H]++_)*[\\da-hA-H]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-18.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>19(#)([\\da-iA-I]++_)*[\\da-iA-I]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-19.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>20(#)([\\da-jA-J]++_)*[\\da-jA-J]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-20.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>21(#)([\\da-kA-K]++_)*[\\da-kA-K]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-21.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>22(#)([\\da-lA-L]++_)*[\\da-lA-L]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-22.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>23(#)([\\da-mA-M]++_)*[\\da-mA-M]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-23.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>24(#)([\\da-nA-N]++_)*[\\da-nA-N]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-24.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>25(#)([\\da-oA-O]++_)*[\\da-oA-O]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-25.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>26(#)([\\da-pA-P]++_)*[\\da-pA-P]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-26.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>27(#)([\\da-qA-Q]++_)*[\\da-qA-Q]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-27.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>28(#)([\\da-rA-R]++_)*[\\da-rA-R]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-28.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>29(#)([\\da-sA-S]++_)*[\\da-sA-S]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-29.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>30(#)([\\da-tA-T]++_)*[\\da-tA-T]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-30.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>31(#)([\\da-uA-U]++_)*[\\da-uA-U]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-31.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>32(#)([\\da-vA-V]++_)*[\\da-vA-V]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-32.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>33(#)([\\da-wA-W]++_)*[\\da-wA-W]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-33.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>34(#)([\\da-xA-X]++_)*[\\da-xA-X]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-34.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>35(#)([\\da-yA-Y]++_)*[\\da-yA-Y]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-35.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.base-integer.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>36(#)([\\da-zA-Z]++_)*[\\da-zA-Z]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.base-36.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\d++#([\\da-zA-Z]++_)*[\\da-zA-Z]++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>invalid.illegal.integer.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(\\d++_)*\\d++</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.numeric.integer.decimal.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>parenthesized-expression</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(\\()</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.expression.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\))</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.expression.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.expression.parenthesized</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>record-directive</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>^\\s*+(-)\\s*+(record)\\s*+(\\()\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')\\s*+(,)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.directive.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>keyword.control.directive.import.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>3</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>4</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>entity.name.type.class.record.definition.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>5</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.parameters.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\))\\s*+(\\.)</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.parameters.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.section.directive.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.directive.record.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#internal-record-body</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#comment</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>record-usage</key>\n\t\t<dict>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.operator.record.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.record.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.record-field.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>variable.other.field.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(#)\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')\\s*+(\\.)\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.record-usage.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>begin</key>\n\t\t\t\t\t<string>(#)\\s*+([a-z][a-zA-Z\\d@_]*+|'[^']*+')</string>\n\t\t\t\t\t<key>beginCaptures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>keyword.operator.record.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>entity.name.type.class.record.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>end</key>\n\t\t\t\t\t<string>(?&lt;=\\})</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>meta.record-usage.erlang</string>\n\t\t\t\t\t<key>patterns</key>\n\t\t\t\t\t<array>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>include</key>\n\t\t\t\t\t\t\t<string>#internal-record-body</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</array>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>string</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(\")</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.string.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\")</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.string.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>string.quoted.double.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.escape.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.escape.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(\\\\)([bdefnrstv\\\\'\"]|(\\^)[@-_a-z]|[0-7]{1,3}|x[\\da-fA-F]{2})</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.character.escape.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>\\\\\\^?.?</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>invalid.illegal.string.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.placeholder.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>10</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>12</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>3</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>4</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>6</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>8</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(~)((\\-)?\\d++|(\\*))?((\\.)(\\d++|(\\*)))?((\\.)((\\*)|.))?[~cfegswpWPBX#bx\\+ni]</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.other.placeholder.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>captures</key>\n\t\t\t\t\t<dict>\n\t\t\t\t\t\t<key>1</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.definition.placeholder.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t\t<key>2</key>\n\t\t\t\t\t\t<dict>\n\t\t\t\t\t\t\t<key>name</key>\n\t\t\t\t\t\t\t<string>punctuation.separator.placeholder-parts.erlang</string>\n\t\t\t\t\t\t</dict>\n\t\t\t\t\t</dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>(~)(\\*)?(\\d++)?[~du\\-#fsacl]</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>constant.other.placeholder.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>~[^\"]?</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>invalid.illegal.string.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>symbolic-operator</key>\n\t\t<dict>\n\t\t\t<key>match</key>\n\t\t\t<string>\\+\\+|\\+|--|-|\\*|/=|/|=/=|=:=|==|=&lt;|=|&lt;-|&lt;|&gt;=|&gt;|!|::</string>\n\t\t\t<key>name</key>\n\t\t\t<string>keyword.operator.symbolic.erlang</string>\n\t\t</dict>\n\t\t<key>textual-operator</key>\n\t\t<dict>\n\t\t\t<key>match</key>\n\t\t\t<string>\\b(andalso|band|and|bxor|xor|bor|orelse|or|bnot|not|bsl|bsr|div|rem)\\b</string>\n\t\t\t<key>name</key>\n\t\t\t<string>keyword.operator.textual.erlang</string>\n\t\t</dict>\n\t\t<key>tuple</key>\n\t\t<dict>\n\t\t\t<key>begin</key>\n\t\t\t<string>(\\{)</string>\n\t\t\t<key>beginCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.tuple.begin.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>end</key>\n\t\t\t<string>(\\})</string>\n\t\t\t<key>endCaptures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.definition.tuple.end.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>name</key>\n\t\t\t<string>meta.structure.tuple.erlang</string>\n\t\t\t<key>patterns</key>\n\t\t\t<array>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>match</key>\n\t\t\t\t\t<string>,</string>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>punctuation.separator.tuple.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>include</key>\n\t\t\t\t\t<string>#everything-else</string>\n\t\t\t\t</dict>\n\t\t\t</array>\n\t\t</dict>\n\t\t<key>variable</key>\n\t\t<dict>\n\t\t\t<key>captures</key>\n\t\t\t<dict>\n\t\t\t\t<key>1</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>variable.other.erlang</string>\n\t\t\t\t</dict>\n\t\t\t\t<key>2</key>\n\t\t\t\t<dict>\n\t\t\t\t\t<key>name</key>\n\t\t\t\t\t<string>variable.language.omitted.erlang</string>\n\t\t\t\t</dict>\n\t\t\t</dict>\n\t\t\t<key>match</key>\n\t\t\t<string>(_[a-zA-Z\\d@_]++|[A-Z][a-zA-Z\\d@_]*+)|(_)</string>\n\t\t</dict>\n\t</dict>\n\t<key>scopeName</key>\n\t<string>source.erlang</string>\n\t<key>uuid</key>\n\t<string>58EA597D-5158-4BF7-9FB2-B05135D1E166</string>\n</dict>\n</plist>\n"}),null);