/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalBlockWithAlignableContents.dev",["Lexical","LexicalComposerContext","LexicalDecoratorBlockNode","LexicalUtils","react","useLexicalNodeSelection"],(function $module_LexicalBlockWithAlignableContents_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;






var React=_require_closure_react||(_require_closure_react=require("react"));








function BlockWithAlignableContents(_ref)




{var children=_ref.children,format=_ref.format,nodeKey=_ref.nodeKey,className=_ref.className;var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];var _useLexicalNodeSelect=
require("useLexicalNodeSelection").useLexicalNodeSelection(nodeKey),isSelected=_useLexicalNodeSelect[0],setSelected=_useLexicalNodeSelect[1],clearSelection=_useLexicalNodeSelect[2];
var ref=React.useRef(null);
var onDelete=React.useCallback(function(event){
if(isSelected&&require("Lexical").$isNodeSelection(require("Lexical").$getSelection())){
event.preventDefault();
var node=require("Lexical").$getNodeByKey(nodeKey);
if(require("Lexical").$isDecoratorNode(node)){
node.remove();
return true;
}
}
return false;
},[isSelected,nodeKey]);
React.useEffect(function(){var _require_Lexical;
return require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).FORMAT_ELEMENT_COMMAND,function(formatType){
if(isSelected){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)){
var node=require("Lexical").$getNodeByKey(nodeKey);
if(require("LexicalDecoratorBlockNode").$isDecoratorBlockNode(node)){
node.setFormat(formatType);
}
}else if(require("Lexical").$isRangeSelection(selection)){
var nodes=selection.getNodes();
for(var _iterator=nodes,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray){if(_i>=_iterator.length)break;_ref2=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref2=_i.value;}var _node=_ref2;
if(require("LexicalDecoratorBlockNode").$isDecoratorBlockNode(_node)){
_node.setFormat(formatType);
}else{
var element=require("LexicalUtils").$getNearestBlockElementAncestorOrThrow(_node);
element.setFormat(formatType);
}
}
}
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_LOW),editor.registerCommand(_require_Lexical.CLICK_COMMAND,function(event){
if(event.target===ref.current){
event.preventDefault();
if(!event.shiftKey){
clearSelection();
}
setSelected(!isSelected);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_LOW),editor.registerCommand(_require_Lexical.KEY_DELETE_COMMAND,onDelete,_require_Lexical.COMMAND_PRIORITY_LOW),editor.registerCommand(_require_Lexical.KEY_BACKSPACE_COMMAND,onDelete,_require_Lexical.COMMAND_PRIORITY_LOW));
},[clearSelection,editor,isSelected,nodeKey,onDelete,setSelected]);
return React.createElement("div",{
className:[className.base,isSelected?className.focus:null].filter(Boolean).join(' '),
ref:ref,
style:{
textAlign:format?format:undefined}},

children);
}

exports.BlockWithAlignableContents=BlockWithAlignableContents;}),null);