/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalUtils.dev",["Lexical","LexicalSelection","Promise"],(function $module_LexicalUtils_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_Promise;


































function mergeRegister(){for(var _len=arguments.length,func=new Array(_len),_key=0;_key<_len;_key++){func[_key]=arguments[_key];}
return function(){
func.forEach(function(f){return f();});
};
}









function px(value){
return value+"px";
}








var mutationObserverConfig={
attributes:true,
characterData:true,
childList:true,
subtree:true};

function positionNodeOnRange(editor,range,onReposition){
var rootDOMNode=null;
var parentDOMNode=null;
var observer=null;
var lastNodes=[];
var wrapperNode=document.createElement('div');
function position(){
if(!(rootDOMNode!==null)){
throw Error("Unexpected null rootDOMNode");
}
if(!(parentDOMNode!==null)){
throw Error("Unexpected null parentDOMNode");
}var _rootDOMNode$getBound=



rootDOMNode.getBoundingClientRect(),rootLeft=_rootDOMNode$getBound.left,rootTop=_rootDOMNode$getBound.top;
var parentDOMNode_=parentDOMNode;
var rects=require("LexicalSelection").createRectsFromDOMRange(editor,range);
if(!wrapperNode.isConnected){
parentDOMNode_.append(wrapperNode);
}
var hasRepositioned=false;
for(var i=0;i<rects.length;i++){
var rect=rects[i];


var rectNode=lastNodes[i]||document.createElement('div');
var rectNodeStyle=rectNode.style;
if(rectNodeStyle.position!=='absolute'){
rectNodeStyle.position='absolute';
hasRepositioned=true;
}
var left=px(rect.left-rootLeft);
if(rectNodeStyle.left!==left){
rectNodeStyle.left=left;
hasRepositioned=true;
}
var top=px(rect.top-rootTop);
if(rectNodeStyle.top!==top){
rectNode.style.top=top;
hasRepositioned=true;
}
var width=px(rect.width);
if(rectNodeStyle.width!==width){
rectNode.style.width=width;
hasRepositioned=true;
}
var height=px(rect.height);
if(rectNodeStyle.height!==height){
rectNode.style.height=height;
hasRepositioned=true;
}
if(rectNode.parentNode!==wrapperNode){
wrapperNode.append(rectNode);
hasRepositioned=true;
}
lastNodes[i]=rectNode;
}
while(lastNodes.length>rects.length){
lastNodes.pop();
}
if(hasRepositioned){
onReposition(lastNodes);
}
}
function stop(){
parentDOMNode=null;
rootDOMNode=null;
if(observer!==null){
observer.disconnect();
}
observer=null;
wrapperNode.remove();
for(var _i=0;_i<lastNodes.length;_i++){var node=lastNodes[_i];
node.remove();
}
lastNodes=[];
}
function restart(){
var currentRootDOMNode=editor.getRootElement();
if(currentRootDOMNode===null){
return stop();
}
var currentParentDOMNode=currentRootDOMNode.parentElement;
if(!(currentParentDOMNode instanceof HTMLElement)){
return stop();
}
stop();
rootDOMNode=currentRootDOMNode;
parentDOMNode=currentParentDOMNode;
observer=new MutationObserver(function(mutations){
var nextRootDOMNode=editor.getRootElement();
var nextParentDOMNode=nextRootDOMNode&&nextRootDOMNode.parentElement;
if(nextRootDOMNode!==rootDOMNode||nextParentDOMNode!==parentDOMNode){
return restart();
}
for(var _iterator=mutations,_isArray=Array.isArray(_iterator),_i2=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i2>=_iterator.length)break;_ref=_iterator[_i2++];}else{_i2=_iterator.next();if(_i2.done)break;_ref=_i2.value;}var mutation=_ref;
if(!wrapperNode.contains(mutation.target)){

return position();
}
}
});
observer.observe(currentParentDOMNode,mutationObserverConfig);
position();
}
var removeRootListener=editor.registerRootListener(restart);
return function(){
removeRootListener();
stop();
};
}








function markSelection(editor,onReposition){
var previousAnchorNode=null;
var previousAnchorOffset=null;
var previousFocusNode=null;
var previousFocusOffset=null;
var removeRangeListener=function removeRangeListener(){};
function compute(editorState){
editorState.read(function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){

previousAnchorNode=null;
previousAnchorOffset=null;
previousFocusNode=null;
previousFocusOffset=null;
removeRangeListener();
removeRangeListener=function removeRangeListener(){};
return;
}var

anchor=

selection.anchor,focus=selection.focus;
var currentAnchorNode=anchor.getNode();
var currentAnchorNodeKey=currentAnchorNode.getKey();
var currentAnchorOffset=anchor.offset;
var currentFocusNode=focus.getNode();
var currentFocusNodeKey=currentFocusNode.getKey();
var currentFocusOffset=focus.offset;
var currentAnchorNodeDOM=editor.getElementByKey(currentAnchorNodeKey);
var currentFocusNodeDOM=editor.getElementByKey(currentFocusNodeKey);
var differentAnchorDOM=previousAnchorNode===null||currentAnchorNodeDOM===null||currentAnchorOffset!==previousAnchorOffset||currentAnchorNodeKey!==previousAnchorNode.getKey()||currentAnchorNode!==previousAnchorNode&&(!(previousAnchorNode instanceof require("Lexical").TextNode)||currentAnchorNode.updateDOM(previousAnchorNode,currentAnchorNodeDOM,editor._config));
var differentFocusDOM=previousFocusNode===null||currentFocusNodeDOM===null||currentFocusOffset!==previousFocusOffset||currentFocusNodeKey!==previousFocusNode.getKey()||currentFocusNode!==previousFocusNode&&(!(previousFocusNode instanceof require("Lexical").TextNode)||currentFocusNode.updateDOM(previousFocusNode,currentFocusNodeDOM,editor._config));
if(differentAnchorDOM||differentFocusDOM){
var anchorHTMLElement=editor.getElementByKey(anchor.getNode().getKey());
var focusHTMLElement=editor.getElementByKey(focus.getNode().getKey());

if(anchorHTMLElement!==null&&focusHTMLElement!==null&&anchorHTMLElement.tagName==='SPAN'&&focusHTMLElement.tagName==='SPAN'){
var range=document.createRange();
var firstHTMLElement;
var firstOffset;
var lastHTMLElement;
var lastOffset;
if(focus.isBefore(anchor)){
firstHTMLElement=focusHTMLElement;
firstOffset=focus.offset;
lastHTMLElement=anchorHTMLElement;
lastOffset=anchor.offset;
}else{
firstHTMLElement=anchorHTMLElement;
firstOffset=anchor.offset;
lastHTMLElement=focusHTMLElement;
lastOffset=focus.offset;
}
var firstTextNode=firstHTMLElement.firstChild;
if(!(firstTextNode!==null)){
throw Error("Expected text node to be first child of span");
}
var lastTextNode=lastHTMLElement.firstChild;
if(!(lastTextNode!==null)){
throw Error("Expected text node to be first child of span");
}
range.setStart(firstTextNode,firstOffset);
range.setEnd(lastTextNode,lastOffset);
removeRangeListener();
removeRangeListener=positionNodeOnRange(editor,range,function(domNodes){
for(var _iterator2=domNodes,_isArray2=Array.isArray(_iterator2),_i3=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray2){if(_i3>=_iterator2.length)break;_ref2=_iterator2[_i3++];}else{_i3=_iterator2.next();if(_i3.done)break;_ref2=_i3.value;}var domNode=_ref2;
var domNodeStyle=domNode.style;
if(domNodeStyle.background!=='Highlight'){
domNodeStyle.background='Highlight';
}
if(domNodeStyle.color!=='HighlightText'){
domNodeStyle.color='HighlightText';
}
if(domNodeStyle.zIndex!=='-1'){
domNodeStyle.zIndex='-1';
}
if(domNodeStyle.pointerEvents!=='none'){
domNodeStyle.pointerEvents='none';
}
if(domNodeStyle.marginTop!==px(-1.5)){
domNodeStyle.marginTop=px(-1.5);
}
if(domNodeStyle.paddingTop!==px(4)){
domNodeStyle.paddingTop=px(4);
}
if(domNodeStyle.paddingBottom!==px(0)){
domNodeStyle.paddingBottom=px(0);
}
}
if(onReposition!==undefined){
onReposition(domNodes);
}
});
}
}
previousAnchorNode=currentAnchorNode;
previousAnchorOffset=currentAnchorOffset;
previousFocusNode=currentFocusNode;
previousFocusOffset=currentFocusOffset;
});
}
compute(editor.getEditorState());
return mergeRegister(editor.registerUpdateListener(function(_ref3){var
editorState=_ref3.editorState;return(
compute(editorState));}),removeRangeListener,function(){
removeRangeListener();
});
}










function addClassNamesToElement(element){for(var _len2=arguments.length,classNames=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++){classNames[_key2-1]=arguments[_key2];}
classNames.forEach(function(className){
if(typeof className==='string'){var _element$classList;
var classesToAdd=className.split(' ').filter(function(n){return n!=='';});
(_element$classList=element.classList).add.apply(_element$classList,classesToAdd);
}
});
}









function removeClassNamesFromElement(element){for(var _len3=arguments.length,classNames=new Array(_len3>1?_len3-1:0),_key3=1;_key3<_len3;_key3++){classNames[_key3-1]=arguments[_key3];}
classNames.forEach(function(className){
if(typeof className==='string'){var _element$classList2;
(_element$classList2=element.classList).remove.apply(_element$classList2,className.split(' '));
}
});
}









function isMimeType(file,acceptableMimeTypes){
for(var _iterator3=acceptableMimeTypes,_isArray3=Array.isArray(_iterator3),_i4=0,_iterator3=_isArray3?_iterator3:_iterator3[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref4;if(_isArray3){if(_i4>=_iterator3.length)break;_ref4=_iterator3[_i4++];}else{_i4=_iterator3.next();if(_i4.done)break;_ref4=_i4.value;}var acceptableType=_ref4;
if(file.type.startsWith(acceptableType)){
return true;
}
}
return false;
}












function mediaFileReader(files,acceptableMimeTypes){
var filesIterator=files[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();
return new(_require_closure_Promise||(_require_closure_Promise=require("Promise")))(function(resolve,reject){
var processed=[];
var handleNextFile=function handleNextFile(){var _filesIterator$next=



filesIterator.next(),done=_filesIterator$next.done,file=_filesIterator$next.value;
if(done){
return resolve(processed);
}
var fileReader=new FileReader();
fileReader.addEventListener('error',reject);
fileReader.addEventListener('load',function(){
var result=fileReader.result;
if(typeof result==='string'){
processed.push({
file:file,
result:result});

}
handleNextFile();
});
if(isMimeType(file,acceptableMimeTypes)){
fileReader.readAsDataURL(file);
}else{
handleNextFile();
}
};
handleNextFile();
});
}











function $dfs(startingNode,endingNode){
var nodes=[];
var start=(startingNode||require("Lexical").$getRoot()).getLatest();
var end=endingNode||(require("Lexical").$isElementNode(start)?start.getLastDescendant():start);
var node=start;
var depth=$getDepth(node);
while(node!==null&&!node.is(end)){
nodes.push({
depth:depth,
node:node});

if(require("Lexical").$isElementNode(node)&&node.getChildrenSize()>0){
node=node.getFirstChild();
depth++;
}else{

var sibling=null;
while(sibling===null&&node!==null){
sibling=node.getNextSibling();
if(sibling===null){
node=node.getParent();
depth--;
}else{
node=sibling;
}
}
}
}
if(node!==null&&node.is(end)){
nodes.push({
depth:depth,
node:node});

}
return nodes;
}
function $getDepth(node){
var innerNode=node;
var depth=0;
while((innerNode=innerNode.getParent())!==null){
depth++;
}
return depth;
}








function $getNearestNodeOfType(node,klass){
var parent=node;
while(parent!=null){
if(parent instanceof klass){
return parent;
}
parent=parent.getParent();
}
return null;
}






function $getNearestBlockElementAncestorOrThrow(startNode){
var blockNode=$findMatchingParent(startNode,function(node){return require("Lexical").$isElementNode(node)&&!node.isInline();});
if(!require("Lexical").$isElementNode(blockNode)){
{
throw Error("Expected node "+startNode.__key+" to have closest block element node.");
}
}
return blockNode;
}








var $findMatchingParent=function $findMatchingParent(startingNode,findFn){
var curr=startingNode;
while(curr!==require("Lexical").$getRoot()&&curr!=null){
if(findFn(curr)){
return curr;
}
curr=curr.getParent();
}
return null;
};










function registerNestedElementResolver(editor,targetNode,cloneNode,handleOverlap){
var $isTargetNode=function $isTargetNode(node){
return node instanceof targetNode;
};
var $findMatch=function $findMatch(node){


var children=node.getChildren();
for(var i=0;i<children.length;i++){
var child=children[i];
if($isTargetNode(child)){
return null;
}
}
var parentNode=node;
var childNode=node;
while(parentNode!==null){
childNode=parentNode;
parentNode=parentNode.getParent();
if($isTargetNode(parentNode)){
return{
child:childNode,
parent:parentNode};

}
}
return null;
};
var elementNodeTransform=function elementNodeTransform(node){
var match=$findMatch(node);
if(match!==null){var

child=

match.child,parent=match.parent;



if(child.is(node)){
handleOverlap(parent,node);
var nextSiblings=child.getNextSiblings();
var nextSiblingsLength=nextSiblings.length;
parent.insertAfter(child);
if(nextSiblingsLength!==0){
var newParent=cloneNode(parent);
child.insertAfter(newParent);
for(var i=0;i<nextSiblingsLength;i++){
newParent.append(nextSiblings[i]);
}
}
if(!parent.canBeEmpty()&&parent.getChildrenSize()===0){
parent.remove();
}
}
}
};
return editor.registerNodeTransform(targetNode,elementNodeTransform);
}







function $restoreEditorState(editor,editorState){
var FULL_RECONCILE=2;
var nodeMap=new Map();
var activeEditorState=editor._pendingEditorState;
for(var _iterator4=editorState._nodeMap,_isArray4=Array.isArray(_iterator4),_i5=0,_iterator4=_isArray4?_iterator4:_iterator4[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref6;if(_isArray4){if(_i5>=_iterator4.length)break;_ref6=_iterator4[_i5++];}else{_i5=_iterator4.next();if(_i5.done)break;_ref6=_i5.value;}var _ref7=_ref6;var key=_ref7[0];var node=_ref7[1];
var clone=require("LexicalSelection").$cloneWithProperties(node);
if(require("Lexical").$isTextNode(clone)){
if(!require("Lexical").$isTextNode(node)){
throw Error("Expected node be a TextNode");
}
clone.__text=node.__text;
}
nodeMap.set(key,clone);
}
if(activeEditorState){
activeEditorState._nodeMap=nodeMap;
}
editor._dirtyType=FULL_RECONCILE;
var selection=editorState._selection;
require("Lexical").$setSelection(selection===null?null:selection.clone());
}









function $insertNodeToNearestRoot(node){
var selection=require("Lexical").$getSelection()||require("Lexical").$getPreviousSelection();
if(require("Lexical").$isRangeSelection(selection)){var

focus=
selection.focus;
var focusNode=focus.getNode();
var focusOffset=focus.offset;
if(require("Lexical").$isRootOrShadowRoot(focusNode)){
var focusChild=focusNode.getChildAtIndex(focusOffset);
if(focusChild==null){
focusNode.append(node);
}else{
focusChild.insertBefore(node);
}
node.selectNext();
}else{
var splitNode;
var splitOffset;
if(require("Lexical").$isTextNode(focusNode)){
splitNode=focusNode.getParentOrThrow();
splitOffset=focusNode.getIndexWithinParent();
if(focusOffset>0){
splitOffset+=1;
focusNode.splitText(focusOffset);
}
}else{
splitNode=focusNode;
splitOffset=focusOffset;
}var _Lexical$$splitNode=
require("Lexical").$splitNode(splitNode,splitOffset),rightTree=_Lexical$$splitNode[1];
rightTree.insertBefore(node);
rightTree.selectStart();
}
}else{
if(selection!=null){
var nodes=selection.getNodes();
nodes[nodes.length-1].getTopLevelElementOrThrow().insertAfter(node);
}else{
var root=require("Lexical").$getRoot();
root.append(node);
}
var paragraphNode=require("Lexical").$createParagraphNode();
node.insertAfter(paragraphNode);
paragraphNode.select();
}
return node.getLatest();
}







function $wrapNodeInElement(node,createElementNode){
var elementNode=createElementNode();
node.replace(elementNode);
elementNode.append(node);
return elementNode;
}








function objectKlassEquals(object,objectClass){
return object!==null?Object.getPrototypeOf(object).constructor.name===objectClass.name:false;
}








function $filter(nodes,filterFn){
var result=[];
for(var i=0;i<nodes.length;i++){
var node=filterFn(nodes[i]);
if(node!==null){
result.push(node);
}
}
return result;
}





function $insertFirst(parent,node){
var firstChild=parent.getFirstChild();
if(firstChild!==null){
firstChild.insertBefore(node);
}else{
parent.append(node);
}
}

exports.$splitNode=require("Lexical").$splitNode;
exports.isHTMLAnchorElement=require("Lexical").isHTMLAnchorElement;
exports.isHTMLElement=require("Lexical").isHTMLElement;
exports.$dfs=$dfs;
exports.$filter=$filter;
exports.$findMatchingParent=$findMatchingParent;
exports.$getNearestBlockElementAncestorOrThrow=$getNearestBlockElementAncestorOrThrow;
exports.$getNearestNodeOfType=$getNearestNodeOfType;
exports.$insertFirst=$insertFirst;
exports.$insertNodeToNearestRoot=$insertNodeToNearestRoot;
exports.$restoreEditorState=$restoreEditorState;
exports.$wrapNodeInElement=$wrapNodeInElement;
exports.addClassNamesToElement=addClassNamesToElement;
exports.isMimeType=isMimeType;
exports.markSelection=markSelection;
exports.mediaFileReader=mediaFileReader;
exports.mergeRegister=mergeRegister;
exports.objectKlassEquals=objectKlassEquals;
exports.positionNodeOnRange=positionNodeOnRange;
exports.registerNestedElementResolver=registerNestedElementResolver;
exports.removeClassNamesFromElement=removeClassNamesFromElement;}),null);