/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalRichTextPlugin.dev",["LexicalComposerContext","LexicalDragon","LexicalRichText","LexicalText","LexicalUtils","ReactDOMComet","react","useLexicalEditable"],(function $module_LexicalRichTextPlugin_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;



var React=_require_closure_react||(_require_closure_react=require("react"));














var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var useLayoutEffectImpl=CAN_USE_DOM?React.useLayoutEffect:React.useEffect;
var useLayoutEffect=useLayoutEffectImpl;








function canShowPlaceholderFromCurrentEditorState(editor){
var currentCanShowPlaceholder=editor.getEditorState().read(require("LexicalText").$canShowPlaceholderCurry(editor.isComposing()));
return currentCanShowPlaceholder;
}
function useCanShowPlaceholder(editor){var _React$useState=
React.useState(function(){return canShowPlaceholderFromCurrentEditorState(editor);}),canShowPlaceholder=_React$useState[0],setCanShowPlaceholder=_React$useState[1];
useLayoutEffect(function(){
function resetCanShowPlaceholder(){
var currentCanShowPlaceholder=canShowPlaceholderFromCurrentEditorState(editor);
setCanShowPlaceholder(currentCanShowPlaceholder);
}
resetCanShowPlaceholder();
return require("LexicalUtils").mergeRegister(editor.registerUpdateListener(function(){
resetCanShowPlaceholder();
}),editor.registerEditableListener(function(){
resetCanShowPlaceholder();
}));
},[editor]);
return canShowPlaceholder;
}








function useDecorators(editor,ErrorBoundary){var _React$useState2=
React.useState(function(){return editor.getDecorators();}),decorators=_React$useState2[0],setDecorators=_React$useState2[1];


useLayoutEffect(function(){
return editor.registerDecoratorListener(function(nextDecorators){
require("ReactDOMComet").flushSync(function(){
setDecorators(nextDecorators);
});
});
},[editor]);
React.useEffect(function(){



setDecorators(editor.getDecorators());
},[editor]);


return React.useMemo(function(){
var decoratedPortals=[];
var decoratorKeys=Object.keys(decorators);
for(var i=0;i<decoratorKeys.length;i++){
var nodeKey=decoratorKeys[i];
var reactDecorator=React.createElement(ErrorBoundary,{
onError:function onError(e){return editor._onError(e);}},
React.createElement(React.Suspense,{
fallback:null},
decorators[nodeKey]));
var element=editor.getElementByKey(nodeKey);
if(element!==null){
decoratedPortals.push(require("ReactDOMComet").createPortal(reactDecorator,element,nodeKey));
}
}
return decoratedPortals;
},[ErrorBoundary,decorators,editor]);
}








function useRichTextSetup(editor){
useLayoutEffect(function(){
return require("LexicalUtils").mergeRegister(require("LexicalRichText").registerRichText(editor),require("LexicalDragon").registerDragonSupport(editor));



},[editor]);
}








function RichTextPlugin(_ref)



{var contentEditable=_ref.contentEditable,placeholder=_ref.placeholder,ErrorBoundary=_ref.ErrorBoundary;var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];
var decorators=useDecorators(editor,ErrorBoundary);
useRichTextSetup(editor);
return React.createElement(React.Fragment,null,contentEditable,React.createElement(Placeholder,{
content:placeholder}),
decorators);
}
function Placeholder(_ref2)

{var content=_ref2.content;var _LexicalComposerConte2=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte2[0];
var showPlaceholder=useCanShowPlaceholder(editor);
var editable=require("useLexicalEditable")();
if(!showPlaceholder){
return null;
}
if(typeof content==='function'){
return content(editable);
}else{
return content;
}
}

exports.RichTextPlugin=RichTextPlugin;}),null);