/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("Lexical.dev",["Promise"],(function $module_Lexical_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _ELEMENT_FORMAT_TO_TY,_TEXT_TYPE_TO_MODE;var _require_closure_Promise;









function createCommand(type){
return{
type:type};

}
var SELECTION_CHANGE_COMMAND=createCommand('SELECTION_CHANGE_COMMAND');
var SELECTION_INSERT_CLIPBOARD_NODES_COMMAND=createCommand('SELECTION_INSERT_CLIPBOARD_NODES_COMMAND');
var CLICK_COMMAND=createCommand('CLICK_COMMAND');
var DELETE_CHARACTER_COMMAND=createCommand('DELETE_CHARACTER_COMMAND');
var INSERT_LINE_BREAK_COMMAND=createCommand('INSERT_LINE_BREAK_COMMAND');
var INSERT_PARAGRAPH_COMMAND=createCommand('INSERT_PARAGRAPH_COMMAND');
var CONTROLLED_TEXT_INSERTION_COMMAND=createCommand('CONTROLLED_TEXT_INSERTION_COMMAND');
var PASTE_COMMAND=createCommand('PASTE_COMMAND');
var REMOVE_TEXT_COMMAND=createCommand('REMOVE_TEXT_COMMAND');
var DELETE_WORD_COMMAND=createCommand('DELETE_WORD_COMMAND');
var DELETE_LINE_COMMAND=createCommand('DELETE_LINE_COMMAND');
var FORMAT_TEXT_COMMAND=createCommand('FORMAT_TEXT_COMMAND');
var UNDO_COMMAND=createCommand('UNDO_COMMAND');
var REDO_COMMAND=createCommand('REDO_COMMAND');
var KEY_DOWN_COMMAND=createCommand('KEYDOWN_COMMAND');
var KEY_ARROW_RIGHT_COMMAND=createCommand('KEY_ARROW_RIGHT_COMMAND');
var MOVE_TO_END=createCommand('MOVE_TO_END');
var KEY_ARROW_LEFT_COMMAND=createCommand('KEY_ARROW_LEFT_COMMAND');
var MOVE_TO_START=createCommand('MOVE_TO_START');
var KEY_ARROW_UP_COMMAND=createCommand('KEY_ARROW_UP_COMMAND');
var KEY_ARROW_DOWN_COMMAND=createCommand('KEY_ARROW_DOWN_COMMAND');
var KEY_ENTER_COMMAND=createCommand('KEY_ENTER_COMMAND');
var KEY_SPACE_COMMAND=createCommand('KEY_SPACE_COMMAND');
var KEY_BACKSPACE_COMMAND=createCommand('KEY_BACKSPACE_COMMAND');
var KEY_ESCAPE_COMMAND=createCommand('KEY_ESCAPE_COMMAND');
var KEY_DELETE_COMMAND=createCommand('KEY_DELETE_COMMAND');
var KEY_TAB_COMMAND=createCommand('KEY_TAB_COMMAND');
var INSERT_TAB_COMMAND=createCommand('INSERT_TAB_COMMAND');
var INDENT_CONTENT_COMMAND=createCommand('INDENT_CONTENT_COMMAND');
var OUTDENT_CONTENT_COMMAND=createCommand('OUTDENT_CONTENT_COMMAND');
var DROP_COMMAND=createCommand('DROP_COMMAND');
var FORMAT_ELEMENT_COMMAND=createCommand('FORMAT_ELEMENT_COMMAND');
var DRAGSTART_COMMAND=createCommand('DRAGSTART_COMMAND');
var DRAGOVER_COMMAND=createCommand('DRAGOVER_COMMAND');
var DRAGEND_COMMAND=createCommand('DRAGEND_COMMAND');
var COPY_COMMAND=createCommand('COPY_COMMAND');
var CUT_COMMAND=createCommand('CUT_COMMAND');
var SELECT_ALL_COMMAND=createCommand('SELECT_ALL_COMMAND');
var CLEAR_EDITOR_COMMAND=createCommand('CLEAR_EDITOR_COMMAND');
var CLEAR_HISTORY_COMMAND=createCommand('CLEAR_HISTORY_COMMAND');
var CAN_REDO_COMMAND=createCommand('CAN_REDO_COMMAND');
var CAN_UNDO_COMMAND=createCommand('CAN_UNDO_COMMAND');
var FOCUS_COMMAND=createCommand('FOCUS_COMMAND');
var BLUR_COMMAND=createCommand('BLUR_COMMAND');
var KEY_MODIFIER_COMMAND=createCommand('KEY_MODIFIER_COMMAND');









var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var documentMode=CAN_USE_DOM&&'documentMode'in document?document.documentMode:null;
var IS_APPLE=CAN_USE_DOM&&/Mac|iPod|iPhone|iPad/.test(navigator.platform);
var IS_FIREFOX=CAN_USE_DOM&&/^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);
var CAN_USE_BEFORE_INPUT=CAN_USE_DOM&&'InputEvent'in window&&!documentMode?'getTargetRanges'in new window.InputEvent('input'):false;
var IS_SAFARI=CAN_USE_DOM&&/Version\/[\d.]+.*Safari/.test(navigator.userAgent);
var IS_IOS=CAN_USE_DOM&&/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream;
var IS_ANDROID=CAN_USE_DOM&&/Android/.test(navigator.userAgent);



var IS_CHROME=CAN_USE_DOM&&/^(?=.*Chrome).*/i.test(navigator.userAgent);


var IS_APPLE_WEBKIT=CAN_USE_DOM&&/AppleWebKit\/[\d.]+/.test(navigator.userAgent)&&!IS_CHROME;










var DOM_ELEMENT_TYPE=1;
var DOM_TEXT_TYPE=3;


var NO_DIRTY_NODES=0;
var HAS_DIRTY_NODES=1;
var FULL_RECONCILE=2;


var IS_NORMAL=0;
var IS_TOKEN=1;
var IS_SEGMENTED=2;



var IS_BOLD=1;
var IS_ITALIC=1<<1;
var IS_STRIKETHROUGH=1<<2;
var IS_UNDERLINE=1<<3;
var IS_CODE=1<<4;
var IS_SUBSCRIPT=1<<5;
var IS_SUPERSCRIPT=1<<6;
var IS_HIGHLIGHT=1<<7;
var IS_ALL_FORMATTING=IS_BOLD|IS_ITALIC|IS_STRIKETHROUGH|IS_UNDERLINE|IS_CODE|IS_SUBSCRIPT|IS_SUPERSCRIPT|IS_HIGHLIGHT;


var IS_DIRECTIONLESS=1;
var IS_UNMERGEABLE=1<<1;


var IS_ALIGN_LEFT=1;
var IS_ALIGN_CENTER=2;
var IS_ALIGN_RIGHT=3;
var IS_ALIGN_JUSTIFY=4;
var IS_ALIGN_START=5;
var IS_ALIGN_END=6;


var NON_BREAKING_SPACE='\u00A0';
var ZERO_WIDTH_SPACE='\u200b';



var COMPOSITION_SUFFIX=IS_SAFARI||IS_IOS||IS_APPLE_WEBKIT?NON_BREAKING_SPACE:ZERO_WIDTH_SPACE;
var DOUBLE_LINE_BREAK='\n\n';



var COMPOSITION_START_CHAR=IS_FIREFOX?NON_BREAKING_SPACE:COMPOSITION_SUFFIX;
var RTL='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC';
var LTR='A-Za-z\u00C0-\u00D6\u00D8-\u00F6'+'\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF\u200E\u2C00-\uFB1C'+'\uFE00-\uFE6F\uFEFD-\uFFFF';


var RTL_REGEX=new RegExp('^[^'+LTR+']*['+RTL+']');

var LTR_REGEX=new RegExp('^[^'+RTL+']*['+LTR+']');
var TEXT_TYPE_TO_FORMAT={
bold:IS_BOLD,
code:IS_CODE,
highlight:IS_HIGHLIGHT,
italic:IS_ITALIC,
strikethrough:IS_STRIKETHROUGH,
subscript:IS_SUBSCRIPT,
superscript:IS_SUPERSCRIPT,
underline:IS_UNDERLINE};

var DETAIL_TYPE_TO_DETAIL={
directionless:IS_DIRECTIONLESS,
unmergeable:IS_UNMERGEABLE};

var ELEMENT_TYPE_TO_FORMAT={
center:IS_ALIGN_CENTER,
end:IS_ALIGN_END,
justify:IS_ALIGN_JUSTIFY,
left:IS_ALIGN_LEFT,
right:IS_ALIGN_RIGHT,
start:IS_ALIGN_START};

var ELEMENT_FORMAT_TO_TYPE=(_ELEMENT_FORMAT_TO_TY={},_ELEMENT_FORMAT_TO_TY[
IS_ALIGN_CENTER]='center',_ELEMENT_FORMAT_TO_TY[
IS_ALIGN_END]='end',_ELEMENT_FORMAT_TO_TY[
IS_ALIGN_JUSTIFY]='justify',_ELEMENT_FORMAT_TO_TY[
IS_ALIGN_LEFT]='left',_ELEMENT_FORMAT_TO_TY[
IS_ALIGN_RIGHT]='right',_ELEMENT_FORMAT_TO_TY[
IS_ALIGN_START]='start',_ELEMENT_FORMAT_TO_TY);

var TEXT_MODE_TO_TYPE={
normal:IS_NORMAL,
segmented:IS_SEGMENTED,
token:IS_TOKEN};

var TEXT_TYPE_TO_MODE=(_TEXT_TYPE_TO_MODE={},_TEXT_TYPE_TO_MODE[
IS_NORMAL]='normal',_TEXT_TYPE_TO_MODE[
IS_SEGMENTED]='segmented',_TEXT_TYPE_TO_MODE[
IS_TOKEN]='token',_TEXT_TYPE_TO_MODE);










var TEXT_MUTATION_VARIANCE=100;
var isProcessingMutations=false;
var lastTextEntryTimeStamp=0;
function getIsProcessingMutations(){
return isProcessingMutations;
}
function updateTimeStamp(event){
lastTextEntryTimeStamp=event.timeStamp;
}
function initTextEntryListener(editor){
if(lastTextEntryTimeStamp===0){
getWindow(editor).addEventListener('textInput',updateTimeStamp,true);
}
}
function isManagedLineBreak(dom,target,editor){
return(

target.__lexicalLineBreak===dom||

dom["__lexicalKey_"+editor._key]!==undefined);

}
function getLastSelection(editor){
return editor.getEditorState().read(function(){
var selection=$getSelection();
return selection!==null?selection.clone():null;
});
}
function handleTextMutation(target,node,editor){
var domSelection=getDOMSelection(editor._window);
var anchorOffset=null;
var focusOffset=null;
if(domSelection!==null&&domSelection.anchorNode===target){
anchorOffset=domSelection.anchorOffset;
focusOffset=domSelection.focusOffset;
}
var text=target.nodeValue;
if(text!==null){
$updateTextNodeFromDOMContent(node,text,anchorOffset,focusOffset,false);
}
}
function shouldUpdateTextNodeFromMutation(selection,targetDOM,targetNode){
if($isRangeSelection(selection)){
var anchorNode=selection.anchor.getNode();
if(anchorNode.is(targetNode)&&selection.format!==anchorNode.getFormat()){
return false;
}
}
return targetDOM.nodeType===DOM_TEXT_TYPE&&targetNode.isAttached();
}
function $flushMutations$1(editor,mutations,observer){
isProcessingMutations=true;
var shouldFlushTextMutations=performance.now()-lastTextEntryTimeStamp>TEXT_MUTATION_VARIANCE;
try{
updateEditor(editor,function(){
var selection=$getSelection()||getLastSelection(editor);
var badDOMTargets=new Map();
var rootElement=editor.getRootElement();


var currentEditorState=editor._editorState;
var blockCursorElement=editor._blockCursorElement;
var shouldRevertSelection=false;
var possibleTextForFirefoxPaste='';
for(var i=0;i<mutations.length;i++){
var mutation=mutations[i];
var type=mutation.type;
var targetDOM=mutation.target;
var targetNode=$getNearestNodeFromDOMNode(targetDOM,currentEditorState);
if(targetNode===null&&targetDOM!==rootElement||$isDecoratorNode(targetNode)){
continue;
}
if(type==='characterData'){


if(shouldFlushTextMutations&&$isTextNode(targetNode)&&shouldUpdateTextNodeFromMutation(selection,targetDOM,targetNode)){
handleTextMutation(

targetDOM,targetNode,editor);
}
}else if(type==='childList'){
shouldRevertSelection=true;



var addedDOMs=mutation.addedNodes;
for(var s=0;s<addedDOMs.length;s++){
var addedDOM=addedDOMs[s];
var node=getNodeFromDOMNode(addedDOM);
var parentDOM=addedDOM.parentNode;
if(parentDOM!=null&&addedDOM!==blockCursorElement&&node===null&&(addedDOM.nodeName!=='BR'||!isManagedLineBreak(addedDOM,parentDOM,editor))){
if(IS_FIREFOX){
var possibleText=addedDOM.innerText||addedDOM.nodeValue;
if(possibleText){
possibleTextForFirefoxPaste+=possibleText;
}
}
parentDOM.removeChild(addedDOM);
}
}
var removedDOMs=mutation.removedNodes;
var removedDOMsLength=removedDOMs.length;
if(removedDOMsLength>0){
var unremovedBRs=0;
for(var _s=0;_s<removedDOMsLength;_s++){
var removedDOM=removedDOMs[_s];
if(removedDOM.nodeName==='BR'&&isManagedLineBreak(removedDOM,targetDOM,editor)||blockCursorElement===removedDOM){
targetDOM.appendChild(removedDOM);
unremovedBRs++;
}
}
if(removedDOMsLength!==unremovedBRs){
if(targetDOM===rootElement){
targetNode=internalGetRoot(currentEditorState);
}
badDOMTargets.set(targetDOM,targetNode);
}
}
}
}





if(badDOMTargets.size>0){
for(var _iterator=badDOMTargets,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray){if(_i>=_iterator.length)break;_ref2=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref2=_i.value;}var _ref3=_ref2;var _targetDOM=_ref3[0];var _targetNode=_ref3[1];
if($isElementNode(_targetNode)){
var childKeys=_targetNode.getChildrenKeys();
var currentDOM=_targetDOM.firstChild;
for(var _s2=0;_s2<childKeys.length;_s2++){
var key=childKeys[_s2];
var correctDOM=editor.getElementByKey(key);
if(correctDOM===null){
continue;
}
if(currentDOM==null){
_targetDOM.appendChild(correctDOM);
currentDOM=correctDOM;
}else if(currentDOM!==correctDOM){
_targetDOM.replaceChild(correctDOM,currentDOM);
}
currentDOM=currentDOM.nextSibling;
}
}else if($isTextNode(_targetNode)){
_targetNode.markDirty();
}
}
}




var records=observer.takeRecords();




if(records.length>0){
for(var _i2=0;_i2<records.length;_i2++){
var record=records[_i2];
var addedNodes=record.addedNodes;
var target=record.target;
for(var _s3=0;_s3<addedNodes.length;_s3++){
var _addedDOM=addedNodes[_s3];
var _parentDOM=_addedDOM.parentNode;
if(_parentDOM!=null&&_addedDOM.nodeName==='BR'&&!isManagedLineBreak(_addedDOM,target,editor)){
_parentDOM.removeChild(_addedDOM);
}
}
}


observer.takeRecords();
}
if(selection!==null){
if(shouldRevertSelection){
selection.dirty=true;
$setSelection(selection);
}
if(IS_FIREFOX&&isFirefoxClipboardEvents(editor)){
selection.insertRawText(possibleTextForFirefoxPaste);
}
}
});
}finally{
isProcessingMutations=false;
}
}
function flushRootMutations(editor){
var observer=editor._observer;
if(observer!==null){
var mutations=observer.takeRecords();
$flushMutations$1(editor,mutations,observer);
}
}
function initMutationObserver(editor){
initTextEntryListener(editor);
editor._observer=new MutationObserver(function(mutations,observer){
$flushMutations$1(editor,mutations,observer);
});
}








function $canSimpleTextNodesBeMerged(node1,node2){
var node1Mode=node1.__mode;
var node1Format=node1.__format;
var node1Style=node1.__style;
var node2Mode=node2.__mode;
var node2Format=node2.__format;
var node2Style=node2.__style;
return(node1Mode===null||node1Mode===node2Mode)&&(node1Format===null||node1Format===node2Format)&&(node1Style===null||node1Style===node2Style);
}
function $mergeTextNodes(node1,node2){
var writableNode1=node1.mergeWithSibling(node2);
var normalizedNodes=getActiveEditor()._normalizedNodes;
normalizedNodes.add(node1.__key);
normalizedNodes.add(node2.__key);
return writableNode1;
}
function $normalizeTextNode(textNode){
var node=textNode;
if(node.__text===''&&node.isSimpleText()&&!node.isUnmergeable()){
node.remove();
return;
}


var previousNode;
while((previousNode=node.getPreviousSibling())!==null&&$isTextNode(previousNode)&&previousNode.isSimpleText()&&!previousNode.isUnmergeable()){
if(previousNode.__text===''){
previousNode.remove();
}else if($canSimpleTextNodesBeMerged(previousNode,node)){
node=$mergeTextNodes(previousNode,node);
break;
}else{
break;
}
}


var nextNode;
while((nextNode=node.getNextSibling())!==null&&$isTextNode(nextNode)&&nextNode.isSimpleText()&&!nextNode.isUnmergeable()){
if(nextNode.__text===''){
nextNode.remove();
}else if($canSimpleTextNodesBeMerged(node,nextNode)){
node=$mergeTextNodes(node,nextNode);
break;
}else{
break;
}
}
}
function $normalizeSelection(selection){
$normalizePoint(selection.anchor);
$normalizePoint(selection.focus);
return selection;
}
function $normalizePoint(point){
while(point.type==='element'){
var node=point.getNode();
var offset=point.offset;
var nextNode=void 0;
var nextOffsetAtEnd=void 0;
if(offset===node.getChildrenSize()){
nextNode=node.getChildAtIndex(offset-1);
nextOffsetAtEnd=true;
}else{
nextNode=node.getChildAtIndex(offset);
nextOffsetAtEnd=false;
}
if($isTextNode(nextNode)){
point.set(nextNode.__key,nextOffsetAtEnd?nextNode.getTextContentSize():0,'text');
break;
}else if(!$isElementNode(nextNode)){
break;
}
point.set(nextNode.__key,nextOffsetAtEnd?nextNode.getChildrenSize():0,'element');
}
}








var keyCounter=1;
function generateRandomKey(){
return''+keyCounter++;
}
function getRegisteredNodeOrThrow(editor,nodeType){
var registeredNode=editor._nodes.get(nodeType);
if(registeredNode===undefined){
{
throw Error("registeredNode: Type "+nodeType+" not found");
}
}
return registeredNode;
}
var scheduleMicroTask=typeof queueMicrotask==='function'?queueMicrotask:function(fn){

(_require_closure_Promise||(_require_closure_Promise=require("Promise"))).resolve().then(fn);
};
function $isSelectionCapturedInDecorator(node){
return $isDecoratorNode($getNearestNodeFromDOMNode(node));
}
function isSelectionCapturedInDecoratorInput(anchorDOM){
var activeElement=document.activeElement;
if(activeElement===null){
return false;
}
var nodeName=activeElement.nodeName;
return $isDecoratorNode($getNearestNodeFromDOMNode(anchorDOM))&&(nodeName==='INPUT'||nodeName==='TEXTAREA'||activeElement.contentEditable==='true'&&

activeElement.__lexicalEditor==null);
}
function isSelectionWithinEditor(editor,anchorDOM,focusDOM){
var rootElement=editor.getRootElement();
try{
return rootElement!==null&&rootElement.contains(anchorDOM)&&rootElement.contains(focusDOM)&&

anchorDOM!==null&&!isSelectionCapturedInDecoratorInput(anchorDOM)&&getNearestEditorFromDOMNode(anchorDOM)===editor;
}catch(error){
return false;
}
}
function getNearestEditorFromDOMNode(node){
var currentNode=node;
while(currentNode!=null){

var editor=currentNode.__lexicalEditor;
if(editor!=null){
return editor;
}
currentNode=getParentElement(currentNode);
}
return null;
}
function getTextDirection(text){
if(RTL_REGEX.test(text)){
return'rtl';
}
if(LTR_REGEX.test(text)){
return'ltr';
}
return null;
}
function $isTokenOrSegmented(node){
return node.isToken()||node.isSegmented();
}
function isDOMNodeLexicalTextNode(node){
return node.nodeType===DOM_TEXT_TYPE;
}
function getDOMTextNode(element){
var node=element;
while(node!=null){
if(isDOMNodeLexicalTextNode(node)){
return node;
}
node=node.firstChild;
}
return null;
}
function toggleTextFormatType(format,type,alignWithFormat){
var activeFormat=TEXT_TYPE_TO_FORMAT[type];
if(alignWithFormat!==null&&(format&activeFormat)===(alignWithFormat&activeFormat)){
return format;
}
var newFormat=format^activeFormat;
if(type==='subscript'){
newFormat&=~TEXT_TYPE_TO_FORMAT.superscript;
}else if(type==='superscript'){
newFormat&=~TEXT_TYPE_TO_FORMAT.subscript;
}
return newFormat;
}
function $isLeafNode(node){
return $isTextNode(node)||$isLineBreakNode(node)||$isDecoratorNode(node);
}
function $setNodeKey(node,existingKey){
if(existingKey!=null){
node.__key=existingKey;
return;
}
errorOnReadOnly();
errorOnInfiniteTransforms();
var editor=getActiveEditor();
var editorState=getActiveEditorState();
var key=generateRandomKey();
editorState._nodeMap.set(key,node);

if($isElementNode(node)){
editor._dirtyElements.set(key,true);
}else{
editor._dirtyLeaves.add(key);
}
editor._cloneNotNeeded.add(key);
editor._dirtyType=HAS_DIRTY_NODES;
node.__key=key;
}
function internalMarkParentElementsAsDirty(parentKey,nodeMap,dirtyElements){
var nextParentKey=parentKey;
while(nextParentKey!==null){
if(dirtyElements.has(nextParentKey)){
return;
}
var node=nodeMap.get(nextParentKey);
if(node===undefined){
break;
}
dirtyElements.set(nextParentKey,false);
nextParentKey=node.__parent;
}
}
function removeFromParent(node){
var oldParent=node.getParent();
if(oldParent!==null){
var writableNode=node.getWritable();
var writableParent=oldParent.getWritable();
var prevSibling=node.getPreviousSibling();
var nextSibling=node.getNextSibling();

if(prevSibling===null){
if(nextSibling!==null){
var writableNextSibling=nextSibling.getWritable();
writableParent.__first=nextSibling.__key;
writableNextSibling.__prev=null;
}else{
writableParent.__first=null;
}
}else{
var writablePrevSibling=prevSibling.getWritable();
if(nextSibling!==null){
var _writableNextSibling=nextSibling.getWritable();
_writableNextSibling.__prev=writablePrevSibling.__key;
writablePrevSibling.__next=_writableNextSibling.__key;
}else{
writablePrevSibling.__next=null;
}
writableNode.__prev=null;
}
if(nextSibling===null){
if(prevSibling!==null){
var _writablePrevSibling=prevSibling.getWritable();
writableParent.__last=prevSibling.__key;
_writablePrevSibling.__next=null;
}else{
writableParent.__last=null;
}
}else{
var _writableNextSibling2=nextSibling.getWritable();
if(prevSibling!==null){
var _writablePrevSibling2=prevSibling.getWritable();
_writablePrevSibling2.__next=_writableNextSibling2.__key;
_writableNextSibling2.__prev=_writablePrevSibling2.__key;
}else{
_writableNextSibling2.__prev=null;
}
writableNode.__next=null;
}
writableParent.__size--;
writableNode.__parent=null;
}
}



function internalMarkNodeAsDirty(node){
errorOnInfiniteTransforms();
var latest=node.getLatest();
var parent=latest.__parent;
var editorState=getActiveEditorState();
var editor=getActiveEditor();
var nodeMap=editorState._nodeMap;
var dirtyElements=editor._dirtyElements;
if(parent!==null){
internalMarkParentElementsAsDirty(parent,nodeMap,dirtyElements);
}
var key=latest.__key;
editor._dirtyType=HAS_DIRTY_NODES;
if($isElementNode(node)){
dirtyElements.set(key,true);
}else{

editor._dirtyLeaves.add(key);
}
}
function internalMarkSiblingsAsDirty(node){
var previousNode=node.getPreviousSibling();
var nextNode=node.getNextSibling();
if(previousNode!==null){
internalMarkNodeAsDirty(previousNode);
}
if(nextNode!==null){
internalMarkNodeAsDirty(nextNode);
}
}
function $setCompositionKey(compositionKey){
errorOnReadOnly();
var editor=getActiveEditor();
var previousCompositionKey=editor._compositionKey;
if(compositionKey!==previousCompositionKey){
editor._compositionKey=compositionKey;
if(previousCompositionKey!==null){
var node=$getNodeByKey(previousCompositionKey);
if(node!==null){
node.getWritable();
}
}
if(compositionKey!==null){
var _node=$getNodeByKey(compositionKey);
if(_node!==null){
_node.getWritable();
}
}
}
}
function $getCompositionKey(){
if(isCurrentlyReadOnlyMode()){
return null;
}
var editor=getActiveEditor();
return editor._compositionKey;
}
function $getNodeByKey(key,_editorState){
var editorState=_editorState||getActiveEditorState();
var node=editorState._nodeMap.get(key);
if(node===undefined){
return null;
}
return node;
}
function getNodeFromDOMNode(dom,editorState){
var editor=getActiveEditor();

var key=dom["__lexicalKey_"+editor._key];
if(key!==undefined){
return $getNodeByKey(key,editorState);
}
return null;
}
function $getNearestNodeFromDOMNode(startingDOM,editorState){
var dom=startingDOM;
while(dom!=null){
var node=getNodeFromDOMNode(dom,editorState);
if(node!==null){
return node;
}
dom=getParentElement(dom);
}
return null;
}
function cloneDecorators(editor){
var currentDecorators=editor._decorators;
var pendingDecorators=Object.assign({},currentDecorators);
editor._pendingDecorators=pendingDecorators;
return pendingDecorators;
}
function getEditorStateTextContent(editorState){
return editorState.read(function(){return $getRoot().getTextContent();});
}
function markAllNodesAsDirty(editor,type){

updateEditor(editor,function(){
var editorState=getActiveEditorState();
if(editorState.isEmpty()){
return;
}
if(type==='root'){
$getRoot().markDirty();
return;
}
var nodeMap=editorState._nodeMap;
for(var _iterator2=nodeMap,_isArray2=Array.isArray(_iterator2),_i3=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref5;if(_isArray2){if(_i3>=_iterator2.length)break;_ref5=_iterator2[_i3++];}else{_i3=_iterator2.next();if(_i3.done)break;_ref5=_i3.value;}var _ref6=_ref5;var node=_ref6[1];
node.markDirty();
}
},editor._pendingEditorState===null?{
tag:'history-merge'}:
undefined);
}
function $getRoot(){
return internalGetRoot(getActiveEditorState());
}
function internalGetRoot(editorState){
return editorState._nodeMap.get('root');
}
function $setSelection(selection){
errorOnReadOnly();
var editorState=getActiveEditorState();
if(selection!==null){
{
if(Object.isFrozen(selection)){
{
throw Error("$setSelection called on frozen selection object. Ensure selection is cloned before passing in.");
}
}
}
selection.dirty=true;
selection.setCachedNodes(null);
}
editorState._selection=selection;
}
function $flushMutations(){
errorOnReadOnly();
var editor=getActiveEditor();
flushRootMutations(editor);
}
function getNodeFromDOM(dom){
var editor=getActiveEditor();
var nodeKey=getNodeKeyFromDOM(dom,editor);
if(nodeKey===null){
var rootElement=editor.getRootElement();
if(dom===rootElement){
return $getNodeByKey('root');
}
return null;
}
return $getNodeByKey(nodeKey);
}
function getTextNodeOffset(node,moveSelectionToEnd){
return moveSelectionToEnd?node.getTextContentSize():0;
}
function getNodeKeyFromDOM(

dom,editor){
var node=dom;
while(node!=null){

var key=node["__lexicalKey_"+editor._key];
if(key!==undefined){
return key;
}
node=getParentElement(node);
}
return null;
}
function doesContainGrapheme(str){
return /[\uD800-\uDBFF][\uDC00-\uDFFF]/g.test(str);
}
function getEditorsToPropagate(editor){
var editorsToPropagate=[];
var currentEditor=editor;
while(currentEditor!==null){
editorsToPropagate.push(currentEditor);
currentEditor=currentEditor._parentEditor;
}
return editorsToPropagate;
}
function createUID(){
return Math.random().toString(36).replace(/[^a-z]+/g,'').substr(0,5);
}
function getAnchorTextFromDOM(anchorNode){
if(anchorNode.nodeType===DOM_TEXT_TYPE){
return anchorNode.nodeValue;
}
return null;
}
function $updateSelectedTextFromDOM(isCompositionEnd,editor,data){

var domSelection=getDOMSelection(editor._window);
if(domSelection===null){
return;
}
var anchorNode=domSelection.anchorNode;var

anchorOffset=

domSelection.anchorOffset,focusOffset=domSelection.focusOffset;
if(anchorNode!==null){
var textContent=getAnchorTextFromDOM(anchorNode);
var node=$getNearestNodeFromDOMNode(anchorNode);
if(textContent!==null&&$isTextNode(node)){

if(textContent===COMPOSITION_SUFFIX&&data){
var offset=data.length;
textContent=data;
anchorOffset=offset;
focusOffset=offset;
}
if(textContent!==null){
$updateTextNodeFromDOMContent(node,textContent,anchorOffset,focusOffset,isCompositionEnd);
}
}
}
}
function $updateTextNodeFromDOMContent(textNode,textContent,anchorOffset,focusOffset,compositionEnd){
var node=textNode;
if(node.isAttached()&&(compositionEnd||!node.isDirty())){
var isComposing=node.isComposing();
var normalizedTextContent=textContent;
if((isComposing||compositionEnd)&&textContent[textContent.length-1]===COMPOSITION_SUFFIX){
normalizedTextContent=textContent.slice(0,-1);
}
var prevTextContent=node.getTextContent();
if(compositionEnd||normalizedTextContent!==prevTextContent){
if(normalizedTextContent===''){
$setCompositionKey(null);
if(!IS_SAFARI&&!IS_IOS&&!IS_APPLE_WEBKIT){

var editor=getActiveEditor();
setTimeout(function(){
editor.update(function(){
if(node.isAttached()){
node.remove();
}
});
},20);
}else{
node.remove();
}
return;
}
var parent=node.getParent();
var prevSelection=$getPreviousSelection();
var prevTextContentSize=node.getTextContentSize();
var compositionKey=$getCompositionKey();
var nodeKey=node.getKey();
if(node.isToken()||compositionKey!==null&&nodeKey===compositionKey&&!isComposing||


$isRangeSelection(prevSelection)&&(parent!==null&&!parent.canInsertTextBefore()&&prevSelection.anchor.offset===0||prevSelection.anchor.key===textNode.__key&&prevSelection.anchor.offset===0&&!node.canInsertTextBefore()&&!isComposing||prevSelection.focus.key===textNode.__key&&prevSelection.focus.offset===prevTextContentSize&&!node.canInsertTextAfter()&&!isComposing)){
node.markDirty();
return;
}
var selection=$getSelection();
if(!$isRangeSelection(selection)||anchorOffset===null||focusOffset===null){
node.setTextContent(normalizedTextContent);
return;
}
selection.setTextNodeRange(node,anchorOffset,node,focusOffset);
if(node.isSegmented()){
var originalTextContent=node.getTextContent();
var replacement=$createTextNode(originalTextContent);
node.replace(replacement);
node=replacement;
}
node.setTextContent(normalizedTextContent);
}
}
}
function $previousSiblingDoesNotAcceptText(node){
var previousSibling=node.getPreviousSibling();
return($isTextNode(previousSibling)||$isElementNode(previousSibling)&&previousSibling.isInline())&&!previousSibling.canInsertTextAfter();
}




function $shouldInsertTextAfterOrBeforeTextNode(selection,node){
if(node.isSegmented()){
return true;
}
if(!selection.isCollapsed()){
return false;
}
var offset=selection.anchor.offset;
var parent=node.getParentOrThrow();
var isToken=node.isToken();
if(offset===0){
return!node.canInsertTextBefore()||!parent.canInsertTextBefore()||isToken||$previousSiblingDoesNotAcceptText(node);
}else if(offset===node.getTextContentSize()){
return!node.canInsertTextAfter()||!parent.canInsertTextAfter()||isToken;
}else{
return false;
}
}
function isTab(keyCode,altKey,ctrlKey,metaKey){
return keyCode===9&&!altKey&&!ctrlKey&&!metaKey;
}
function isBold(keyCode,altKey,metaKey,ctrlKey){
return keyCode===66&&!altKey&&controlOrMeta(metaKey,ctrlKey);
}
function isItalic(keyCode,altKey,metaKey,ctrlKey){
return keyCode===73&&!altKey&&controlOrMeta(metaKey,ctrlKey);
}
function isUnderline(keyCode,altKey,metaKey,ctrlKey){
return keyCode===85&&!altKey&&controlOrMeta(metaKey,ctrlKey);
}
function isParagraph(keyCode,shiftKey){
return isReturn(keyCode)&&!shiftKey;
}
function isLineBreak(keyCode,shiftKey){
return isReturn(keyCode)&&shiftKey;
}



function isOpenLineBreak(keyCode,ctrlKey){

return IS_APPLE&&ctrlKey&&keyCode===79;
}
function isDeleteWordBackward(keyCode,altKey,ctrlKey){
return isBackspace(keyCode)&&(IS_APPLE?altKey:ctrlKey);
}
function isDeleteWordForward(keyCode,altKey,ctrlKey){
return isDelete(keyCode)&&(IS_APPLE?altKey:ctrlKey);
}
function isDeleteLineBackward(keyCode,metaKey){
return IS_APPLE&&metaKey&&isBackspace(keyCode);
}
function isDeleteLineForward(keyCode,metaKey){
return IS_APPLE&&metaKey&&isDelete(keyCode);
}
function isDeleteBackward(keyCode,altKey,metaKey,ctrlKey){
if(IS_APPLE){
if(altKey||metaKey){
return false;
}
return isBackspace(keyCode)||keyCode===72&&ctrlKey;
}
if(ctrlKey||altKey||metaKey){
return false;
}
return isBackspace(keyCode);
}
function isDeleteForward(keyCode,ctrlKey,shiftKey,altKey,metaKey){
if(IS_APPLE){
if(shiftKey||altKey||metaKey){
return false;
}
return isDelete(keyCode)||keyCode===68&&ctrlKey;
}
if(ctrlKey||altKey||metaKey){
return false;
}
return isDelete(keyCode);
}
function isUndo(keyCode,shiftKey,metaKey,ctrlKey){
return keyCode===90&&!shiftKey&&controlOrMeta(metaKey,ctrlKey);
}
function isRedo(keyCode,shiftKey,metaKey,ctrlKey){
if(IS_APPLE){
return keyCode===90&&metaKey&&shiftKey;
}
return keyCode===89&&ctrlKey||keyCode===90&&ctrlKey&&shiftKey;
}
function isCopy(keyCode,shiftKey,metaKey,ctrlKey){
if(shiftKey){
return false;
}
if(keyCode===67){
return IS_APPLE?metaKey:ctrlKey;
}
return false;
}
function isCut(keyCode,shiftKey,metaKey,ctrlKey){
if(shiftKey){
return false;
}
if(keyCode===88){
return IS_APPLE?metaKey:ctrlKey;
}
return false;
}
function isArrowLeft(keyCode){
return keyCode===37;
}
function isArrowRight(keyCode){
return keyCode===39;
}
function isArrowUp(keyCode){
return keyCode===38;
}
function isArrowDown(keyCode){
return keyCode===40;
}
function isMoveBackward(keyCode,ctrlKey,altKey,metaKey){
return isArrowLeft(keyCode)&&!ctrlKey&&!metaKey&&!altKey;
}
function isMoveToStart(keyCode,ctrlKey,shiftKey,altKey,metaKey){
return isArrowLeft(keyCode)&&!altKey&&!shiftKey&&(ctrlKey||metaKey);
}
function isMoveForward(keyCode,ctrlKey,altKey,metaKey){
return isArrowRight(keyCode)&&!ctrlKey&&!metaKey&&!altKey;
}
function isMoveToEnd(keyCode,ctrlKey,shiftKey,altKey,metaKey){
return isArrowRight(keyCode)&&!altKey&&!shiftKey&&(ctrlKey||metaKey);
}
function isMoveUp(keyCode,ctrlKey,metaKey){
return isArrowUp(keyCode)&&!ctrlKey&&!metaKey;
}
function isMoveDown(keyCode,ctrlKey,metaKey){
return isArrowDown(keyCode)&&!ctrlKey&&!metaKey;
}
function isModifier(ctrlKey,shiftKey,altKey,metaKey){
return ctrlKey||shiftKey||altKey||metaKey;
}
function isSpace(keyCode){
return keyCode===32;
}
function controlOrMeta(metaKey,ctrlKey){
if(IS_APPLE){
return metaKey;
}
return ctrlKey;
}
function isReturn(keyCode){
return keyCode===13;
}
function isBackspace(keyCode){
return keyCode===8;
}
function isEscape(keyCode){
return keyCode===27;
}
function isDelete(keyCode){
return keyCode===46;
}
function isSelectAll(keyCode,metaKey,ctrlKey){
return keyCode===65&&controlOrMeta(metaKey,ctrlKey);
}
function $selectAll(){
var root=$getRoot();
var selection=root.select(0,root.getChildrenSize());
$setSelection($normalizeSelection(selection));
}
function getCachedClassNameArray(classNamesTheme,classNameThemeType){
if(classNamesTheme.__lexicalClassNameCache===undefined){
classNamesTheme.__lexicalClassNameCache={};
}
var classNamesCache=classNamesTheme.__lexicalClassNameCache;
var cachedClassNames=classNamesCache[classNameThemeType];
if(cachedClassNames!==undefined){
return cachedClassNames;
}
var classNames=classNamesTheme[classNameThemeType];





if(typeof classNames==='string'){
var classNamesArr=classNames.split(' ');
classNamesCache[classNameThemeType]=classNamesArr;
return classNamesArr;
}
return classNames;
}
function setMutatedNode(mutatedNodes,registeredNodes,mutationListeners,node,mutation){
if(mutationListeners.size===0){
return;
}
var nodeType=node.__type;
var nodeKey=node.__key;
var registeredNode=registeredNodes.get(nodeType);
if(registeredNode===undefined){
{
throw Error("Type "+nodeType+" not in registeredNodes");
}
}
var klass=registeredNode.klass;
var mutatedNodesByType=mutatedNodes.get(klass);
if(mutatedNodesByType===undefined){
mutatedNodesByType=new Map();
mutatedNodes.set(klass,mutatedNodesByType);
}
var prevMutation=mutatedNodesByType.get(nodeKey);




var isMove=prevMutation==='destroyed'&&mutation==='created';
if(prevMutation===undefined||isMove){
mutatedNodesByType.set(nodeKey,isMove?'updated':mutation);
}
}
function $nodesOfType(klass){
var editorState=getActiveEditorState();
var readOnly=editorState._readOnly;
var klassType=klass.getType();
var nodes=editorState._nodeMap;
var nodesOfType=[];
for(var _iterator3=nodes,_isArray3=Array.isArray(_iterator3),_i4=0,_iterator3=_isArray3?_iterator3:_iterator3[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref8;if(_isArray3){if(_i4>=_iterator3.length)break;_ref8=_iterator3[_i4++];}else{_i4=_iterator3.next();if(_i4.done)break;_ref8=_i4.value;}var _ref9=_ref8;var node=_ref9[1];
if(node instanceof klass&&node.__type===klassType&&(readOnly||node.isAttached())){
nodesOfType.push(node);
}
}
return nodesOfType;
}
function resolveElement(element,isBackward,focusOffset){
var parent=element.getParent();
var offset=focusOffset;
var block=element;
if(parent!==null){
if(isBackward&&focusOffset===0){
offset=block.getIndexWithinParent();
block=parent;
}else if(!isBackward&&focusOffset===block.getChildrenSize()){
offset=block.getIndexWithinParent()+1;
block=parent;
}
}
return block.getChildAtIndex(isBackward?offset-1:offset);
}
function $getAdjacentNode(focus,isBackward){
var focusOffset=focus.offset;
if(focus.type==='element'){
var block=focus.getNode();
return resolveElement(block,isBackward,focusOffset);
}else{
var focusNode=focus.getNode();
if(isBackward&&focusOffset===0||!isBackward&&focusOffset===focusNode.getTextContentSize()){
var possibleNode=isBackward?focusNode.getPreviousSibling():focusNode.getNextSibling();
if(possibleNode===null){
return resolveElement(focusNode.getParentOrThrow(),isBackward,focusNode.getIndexWithinParent()+(isBackward?0:1));
}
return possibleNode;
}
}
return null;
}
function isFirefoxClipboardEvents(editor){
var event=getWindow(editor).event;
var inputType=event&&event.inputType;
return inputType==='insertFromPaste'||inputType==='insertFromPasteAsQuotation';
}
function _dispatchCommand(editor,command,payload){
return triggerCommandListeners(editor,command,payload);
}
function $textContentRequiresDoubleLinebreakAtEnd(node){
return!$isRootNode(node)&&!node.isLastChild()&&!node.isInline();
}
function getElementByKeyOrThrow(editor,key){
var element=editor._keyToDOMMap.get(key);
if(element===undefined){
{
throw Error("Reconciliation: could not find DOM element for node key "+key);
}
}
return element;
}
function getParentElement(node){
var parentElement=node.assignedSlot||node.parentElement;
return parentElement!==null&&parentElement.nodeType===11?parentElement.host:parentElement;
}
function scrollIntoViewIfNeeded(editor,selectionRect,rootElement){
var doc=rootElement.ownerDocument;
var defaultView=doc.defaultView;
if(defaultView===null){
return;
}var

currentTop=

selectionRect.top,currentBottom=selectionRect.bottom;
var targetTop=0;
var targetBottom=0;
var element=rootElement;
while(element!==null){
var isBodyElement=element===doc.body;
if(isBodyElement){
targetTop=0;
targetBottom=getWindow(editor).innerHeight;
}else{
var targetRect=element.getBoundingClientRect();
targetTop=targetRect.top;
targetBottom=targetRect.bottom;
}
var diff=0;
if(currentTop<targetTop){
diff=-(targetTop-currentTop);
}else if(currentBottom>targetBottom){
diff=currentBottom-targetBottom;
}
if(diff!==0){
if(isBodyElement){

defaultView.scrollBy(0,diff);
}else{
var scrollTop=element.scrollTop;
element.scrollTop+=diff;
var yOffset=element.scrollTop-scrollTop;
currentTop-=yOffset;
currentBottom-=yOffset;
}
}
if(isBodyElement){
break;
}
element=getParentElement(element);
}
}
function $hasUpdateTag(tag){
var editor=getActiveEditor();
return editor._updateTags.has(tag);
}
function $addUpdateTag(tag){
errorOnReadOnly();
var editor=getActiveEditor();
editor._updateTags.add(tag);
}
function $maybeMoveChildrenSelectionToParent(parentNode){
var selection=$getSelection();
if(!$isRangeSelection(selection)||!$isElementNode(parentNode)){
return selection;
}var

anchor=

selection.anchor,focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if($hasAncestor(anchorNode,parentNode)){
anchor.set(parentNode.__key,0,'element');
}
if($hasAncestor(focusNode,parentNode)){
focus.set(parentNode.__key,0,'element');
}
return selection;
}
function $hasAncestor(child,targetNode){
var parent=child.getParent();
while(parent!==null){
if(parent.is(targetNode)){
return true;
}
parent=parent.getParent();
}
return false;
}
function getDefaultView(domElem){
var ownerDoc=domElem.ownerDocument;
return ownerDoc&&ownerDoc.defaultView||null;
}
function getWindow(editor){
var windowObj=editor._window;
if(windowObj===null){
{
throw Error("window object not found");
}
}
return windowObj;
}
function $isInlineElementOrDecoratorNode(node){
return $isElementNode(node)&&node.isInline()||$isDecoratorNode(node)&&node.isInline();
}
function $getNearestRootOrShadowRoot(node){
var parent=node.getParentOrThrow();
while(parent!==null){
if($isRootOrShadowRoot(parent)){
return parent;
}
parent=parent.getParentOrThrow();
}
return parent;
}
function $isRootOrShadowRoot(node){
return $isRootNode(node)||$isElementNode(node)&&node.isShadowRoot();
}
function $copyNode(node){
var copy=node.constructor.clone(node);
$setNodeKey(copy,null);

return copy;
}
function $applyNodeReplacement(node){
var editor=getActiveEditor();
var nodeType=node.constructor.getType();
var registeredNode=editor._nodes.get(nodeType);
if(registeredNode===undefined){
{
throw Error("$initializeNode failed. Ensure node has been registered to the editor. You can do this by passing the node class via the \"nodes\" array in the editor config.");
}
}
var replaceFunc=registeredNode.replace;
if(replaceFunc!==null){
var replacementNode=replaceFunc(node);
if(!(replacementNode instanceof node.constructor)){
{
throw Error("$initializeNode failed. Ensure replacement node is a subclass of the original node.");
}
}
return replacementNode;
}
return node;
}
function errorOnInsertTextNodeOnRoot(node,insertNode){
var parentNode=node.getParent();
if($isRootNode(parentNode)&&!$isElementNode(insertNode)&&!$isDecoratorNode(insertNode)){
{
throw Error("Only element or decorator nodes can be inserted in to the root node");
}
}
}
function createBlockCursorElement(editorConfig){
var theme=editorConfig.theme;
var element=document.createElement('div');
element.contentEditable='false';
element.setAttribute('data-lexical-cursor','true');
var blockCursorTheme=theme.blockCursor;
if(blockCursorTheme!==undefined){
if(typeof blockCursorTheme==='string'){
var classNamesArr=blockCursorTheme.split(' ');

blockCursorTheme=theme.blockCursor=classNamesArr;
}
if(blockCursorTheme!==undefined){var _element$classList;
(_element$classList=element.classList).add.apply(_element$classList,blockCursorTheme);
}
}
return element;
}
function needsBlockCursor(node){
return($isDecoratorNode(node)||$isElementNode(node)&&!node.canBeEmpty())&&!node.isInline();
}
function removeDOMBlockCursorElement(blockCursorElement,editor,rootElement){
rootElement.style.removeProperty('caret-color');
editor._blockCursorElement=null;
var parentElement=blockCursorElement.parentElement;
if(parentElement!==null){
parentElement.removeChild(blockCursorElement);
}
}
function updateDOMBlockCursorElement(editor,rootElement,nextSelection){
var blockCursorElement=editor._blockCursorElement;
if($isRangeSelection(nextSelection)&&nextSelection.isCollapsed()&&nextSelection.anchor.type==='element'&&rootElement.contains(document.activeElement)){
var anchor=nextSelection.anchor;
var elementNode=anchor.getNode();
var offset=anchor.offset;
var elementNodeSize=elementNode.getChildrenSize();
var isBlockCursor=false;
var insertBeforeElement=null;
if(offset===elementNodeSize){
var child=elementNode.getChildAtIndex(offset-1);
if(needsBlockCursor(child)){
isBlockCursor=true;
}
}else{
var _child=elementNode.getChildAtIndex(offset);
if(needsBlockCursor(_child)){
var sibling=_child.getPreviousSibling();
if(sibling===null||needsBlockCursor(sibling)){
isBlockCursor=true;
insertBeforeElement=editor.getElementByKey(_child.__key);
}
}
}
if(isBlockCursor){
var elementDOM=editor.getElementByKey(elementNode.__key);
if(blockCursorElement===null){
editor._blockCursorElement=blockCursorElement=createBlockCursorElement(editor._config);
}
rootElement.style.caretColor='transparent';
if(insertBeforeElement===null){
elementDOM.appendChild(blockCursorElement);
}else{
elementDOM.insertBefore(blockCursorElement,insertBeforeElement);
}
return;
}
}

if(blockCursorElement!==null){
removeDOMBlockCursorElement(blockCursorElement,editor,rootElement);
}
}
function getDOMSelection(targetWindow){
return!CAN_USE_DOM?null:(targetWindow||window).getSelection();
}
function $splitNode(node,offset){
var startNode=node.getChildAtIndex(offset);
if(startNode==null){
startNode=node;
}
if(!!$isRootOrShadowRoot(node)){
throw Error("Can not call $splitNode() on root element");
}
var recurse=function recurse(currentNode){
var parent=currentNode.getParentOrThrow();
var isParentRoot=$isRootOrShadowRoot(parent);


var nodeToMove=currentNode===startNode&&!isParentRoot?currentNode:$copyNode(currentNode);
if(isParentRoot){
if(!($isElementNode(currentNode)&&$isElementNode(nodeToMove))){
throw Error("Children of a root must be ElementNode");
}
currentNode.insertAfter(nodeToMove);
return[currentNode,nodeToMove,nodeToMove];
}else{var _recurse=
recurse(parent),_leftTree=_recurse[0],_rightTree=_recurse[1],newParent=_recurse[2];
var nextSiblings=currentNode.getNextSiblings();
newParent.append.apply(newParent,[nodeToMove].concat(nextSiblings));
return[_leftTree,_rightTree,nodeToMove];
}
};var _recurse2=
recurse(startNode),leftTree=_recurse2[0],rightTree=_recurse2[1];
return[leftTree,rightTree];
}





function isHTMLAnchorElement(x){
return isHTMLElement(x)&&x.tagName==='A';
}





function isHTMLElement(x){

return x.nodeType===1;
}





function INTERNAL_$isBlock(node){
if($isDecoratorNode(node)&&!node.isInline()){
return true;
}
if(!$isElementNode(node)||$isRootOrShadowRoot(node)){
return false;
}
var firstChild=node.getFirstChild();
var isLeafElement=firstChild===null||$isLineBreakNode(firstChild)||$isTextNode(firstChild)||firstChild.isInline();
return!node.isInline()&&node.canBeEmpty()!==false&&isLeafElement;
}
function $getAncestor(node,predicate){
var parent=node;
while(parent!==null&&parent.getParent()!==null&&!predicate(parent)){
parent=parent.getParentOrThrow();
}
return predicate(parent)?parent:null;
}





function $getEditor(){
return getActiveEditor();
}








function $garbageCollectDetachedDecorators(editor,pendingEditorState){
var currentDecorators=editor._decorators;
var pendingDecorators=editor._pendingDecorators;
var decorators=pendingDecorators||currentDecorators;
var nodeMap=pendingEditorState._nodeMap;
var key;
for(key in decorators){
if(!nodeMap.has(key)){
if(decorators===currentDecorators){
decorators=cloneDecorators(editor);
}
delete decorators[key];
}
}
}
function $garbageCollectDetachedDeepChildNodes(node,parentKey,prevNodeMap,nodeMap,nodeMapDelete,dirtyNodes){
var child=node.getFirstChild();
while(child!==null){
var childKey=child.__key;

if(child.__parent===parentKey){
if($isElementNode(child)){
$garbageCollectDetachedDeepChildNodes(child,childKey,prevNodeMap,nodeMap,nodeMapDelete,dirtyNodes);
}



if(!prevNodeMap.has(childKey)){
dirtyNodes["delete"](childKey);
}
nodeMapDelete.push(childKey);
}
child=child.getNextSibling();
}
}
function $garbageCollectDetachedNodes(prevEditorState,editorState,dirtyLeaves,dirtyElements){
var prevNodeMap=prevEditorState._nodeMap;
var nodeMap=editorState._nodeMap;


var nodeMapDelete=[];
for(var _iterator4=dirtyElements,_isArray4=Array.isArray(_iterator4),_i5=0,_iterator4=_isArray4?_iterator4:_iterator4[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref11;if(_isArray4){if(_i5>=_iterator4.length)break;_ref11=_iterator4[_i5++];}else{_i5=_iterator4.next();if(_i5.done)break;_ref11=_i5.value;}var _ref13=_ref11;var nodeKey=_ref13[0];
var node=nodeMap.get(nodeKey);
if(node!==undefined){

if(!node.isAttached()){
if($isElementNode(node)){
$garbageCollectDetachedDeepChildNodes(node,nodeKey,prevNodeMap,nodeMap,nodeMapDelete,dirtyElements);
}


if(!prevNodeMap.has(nodeKey)){
dirtyElements["delete"](nodeKey);
}
nodeMapDelete.push(nodeKey);
}
}
}
for(var _i6=0;_i6<nodeMapDelete.length;_i6++){var _nodeKey=nodeMapDelete[_i6];
nodeMap["delete"](_nodeKey);
}
for(var _iterator5=dirtyLeaves,_isArray5=Array.isArray(_iterator5),_i7=0,_iterator5=_isArray5?_iterator5:_iterator5[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref12;if(_isArray5){if(_i7>=_iterator5.length)break;_ref12=_iterator5[_i7++];}else{_i7=_iterator5.next();if(_i7.done)break;_ref12=_i7.value;}var _nodeKey2=_ref12;
var _node2=nodeMap.get(_nodeKey2);
if(_node2!==undefined&&!_node2.isAttached()){
if(!prevNodeMap.has(_nodeKey2)){
dirtyLeaves["delete"](_nodeKey2);
}
nodeMap["delete"](_nodeKey2);
}
}
}








var subTreeTextContent='';
var subTreeDirectionedTextContent='';
var editorTextContent='';
var activeEditorConfig;
var activeEditor$1;
var activeEditorNodes;
var treatAllNodesAsDirty=false;
var activeEditorStateReadOnly=false;
var activeMutationListeners;
var activeTextDirection=null;
var activeDirtyElements;
var activeDirtyLeaves;
var activePrevNodeMap;
var activeNextNodeMap;
var activePrevKeyToDOMMap;
var mutatedNodes;
function destroyNode(key,parentDOM){
var node=activePrevNodeMap.get(key);
if(parentDOM!==null){
var dom=getPrevElementByKeyOrThrow(key);
if(dom.parentNode===parentDOM){
parentDOM.removeChild(dom);
}
}



if(!activeNextNodeMap.has(key)){
activeEditor$1._keyToDOMMap["delete"](key);
}
if($isElementNode(node)){
var children=createChildrenArray(node,activePrevNodeMap);
destroyChildren(children,0,children.length-1,null);
}
if(node!==undefined){
setMutatedNode(mutatedNodes,activeEditorNodes,activeMutationListeners,node,'destroyed');
}
}
function destroyChildren(children,_startIndex,endIndex,dom){
var startIndex=_startIndex;
for(;startIndex<=endIndex;++startIndex){
var child=children[startIndex];
if(child!==undefined){
destroyNode(child,dom);
}
}
}
function setTextAlign(domStyle,value){
domStyle.setProperty('text-align',value);
}
var DEFAULT_INDENT_VALUE='40px';
function setElementIndent(dom,indent){
var indentClassName=activeEditorConfig.theme.indent;
if(typeof indentClassName==='string'){
var elementHasClassName=dom.classList.contains(indentClassName);
if(indent>0&&!elementHasClassName){
dom.classList.add(indentClassName);
}else if(indent<1&&elementHasClassName){
dom.classList.remove(indentClassName);
}
}
var indentationBaseValue=getComputedStyle(dom).getPropertyValue('--lexical-indent-base-value')||DEFAULT_INDENT_VALUE;
dom.style.setProperty('padding-inline-start',indent===0?'':"calc("+indent+" * "+indentationBaseValue+")");
}
function setElementFormat(dom,format){
var domStyle=dom.style;
if(format===0){
setTextAlign(domStyle,'');
}else if(format===IS_ALIGN_LEFT){
setTextAlign(domStyle,'left');
}else if(format===IS_ALIGN_CENTER){
setTextAlign(domStyle,'center');
}else if(format===IS_ALIGN_RIGHT){
setTextAlign(domStyle,'right');
}else if(format===IS_ALIGN_JUSTIFY){
setTextAlign(domStyle,'justify');
}else if(format===IS_ALIGN_START){
setTextAlign(domStyle,'start');
}else if(format===IS_ALIGN_END){
setTextAlign(domStyle,'end');
}
}
function createNode(key,parentDOM,insertDOM){
var node=activeNextNodeMap.get(key);
if(node===undefined){
{
throw Error("createNode: node does not exist in nodeMap");
}
}
var dom=node.createDOM(activeEditorConfig,activeEditor$1);
storeDOMWithKey(key,dom,activeEditor$1);




if($isTextNode(node)){
dom.setAttribute('data-lexical-text','true');
}else if($isDecoratorNode(node)){
dom.setAttribute('data-lexical-decorator','true');
}
if($isElementNode(node)){
var indent=node.__indent;
var childrenSize=node.__size;
if(indent!==0){
setElementIndent(dom,indent);
}
if(childrenSize!==0){
var endIndex=childrenSize-1;
var children=createChildrenArray(node,activeNextNodeMap);
createChildrenWithDirection(children,endIndex,node,dom);
}
var format=node.__format;
if(format!==0){
setElementFormat(dom,format);
}
if(!node.isInline()){
reconcileElementTerminatingLineBreak(null,node,dom);
}
if($textContentRequiresDoubleLinebreakAtEnd(node)){
subTreeTextContent+=DOUBLE_LINE_BREAK;
editorTextContent+=DOUBLE_LINE_BREAK;
}
}else{
var text=node.getTextContent();
if($isDecoratorNode(node)){
var decorator=node.decorate(activeEditor$1,activeEditorConfig);
if(decorator!==null){
reconcileDecorator(key,decorator);
}

dom.contentEditable='false';
}else if($isTextNode(node)){
if(!node.isDirectionless()){
subTreeDirectionedTextContent+=text;
}
}
subTreeTextContent+=text;
editorTextContent+=text;
}
if(parentDOM!==null){
if(insertDOM!=null){
parentDOM.insertBefore(dom,insertDOM);
}else{

var possibleLineBreak=parentDOM.__lexicalLineBreak;
if(possibleLineBreak!=null){
parentDOM.insertBefore(dom,possibleLineBreak);
}else{
parentDOM.appendChild(dom);
}
}
}
{

Object.freeze(node);
}
setMutatedNode(mutatedNodes,activeEditorNodes,activeMutationListeners,node,'created');
return dom;
}
function createChildrenWithDirection(children,endIndex,element,dom){
var previousSubTreeDirectionedTextContent=subTreeDirectionedTextContent;
subTreeDirectionedTextContent='';
createChildren(children,element,0,endIndex,dom,null);
reconcileBlockDirection(element,dom);
subTreeDirectionedTextContent=previousSubTreeDirectionedTextContent;
}
function createChildren(children,element,_startIndex,endIndex,dom,insertDOM){
var previousSubTreeTextContent=subTreeTextContent;
subTreeTextContent='';
var startIndex=_startIndex;
for(;startIndex<=endIndex;++startIndex){
createNode(children[startIndex],dom,insertDOM);
}
if($textContentRequiresDoubleLinebreakAtEnd(element)){
subTreeTextContent+=DOUBLE_LINE_BREAK;
}

dom.__lexicalTextContent=subTreeTextContent;
subTreeTextContent=previousSubTreeTextContent+subTreeTextContent;
}
function isLastChildLineBreakOrDecorator(childKey,nodeMap){
var node=nodeMap.get(childKey);
return $isLineBreakNode(node)||$isDecoratorNode(node)&&node.isInline();
}


function reconcileElementTerminatingLineBreak(prevElement,nextElement,dom){
var prevLineBreak=prevElement!==null&&(prevElement.__size===0||isLastChildLineBreakOrDecorator(prevElement.__last,activePrevNodeMap));
var nextLineBreak=nextElement.__size===0||isLastChildLineBreakOrDecorator(nextElement.__last,activeNextNodeMap);
if(prevLineBreak){
if(!nextLineBreak){

var element=dom.__lexicalLineBreak;
if(element!=null){
dom.removeChild(element);
}


dom.__lexicalLineBreak=null;
}
}else if(nextLineBreak){
var _element=document.createElement('br');

dom.__lexicalLineBreak=_element;
dom.appendChild(_element);
}
}
function reconcileBlockDirection(element,dom){
var previousSubTreeDirectionTextContent=

dom.__lexicalDirTextContent;

var previousDirection=dom.__lexicalDir;
if(previousSubTreeDirectionTextContent!==subTreeDirectionedTextContent||previousDirection!==activeTextDirection){
var hasEmptyDirectionedTextContent=subTreeDirectionedTextContent==='';
var direction=hasEmptyDirectionedTextContent?activeTextDirection:getTextDirection(subTreeDirectionedTextContent);
if(direction!==previousDirection){
var classList=dom.classList;
var theme=activeEditorConfig.theme;
var previousDirectionTheme=previousDirection!==null?theme[previousDirection]:undefined;
var nextDirectionTheme=direction!==null?theme[direction]:undefined;


if(previousDirectionTheme!==undefined){
if(typeof previousDirectionTheme==='string'){
var classNamesArr=previousDirectionTheme.split(' ');
previousDirectionTheme=theme[previousDirection]=classNamesArr;
}


classList.remove.apply(classList,previousDirectionTheme);
}
if(direction===null||hasEmptyDirectionedTextContent&&direction==='ltr'){

dom.removeAttribute('dir');
}else{

if(nextDirectionTheme!==undefined){
if(typeof nextDirectionTheme==='string'){
var _classNamesArr=nextDirectionTheme.split(' ');

nextDirectionTheme=theme[direction]=_classNamesArr;
}
if(nextDirectionTheme!==undefined){
classList.add.apply(classList,nextDirectionTheme);
}
}


dom.dir=direction;
}
if(!activeEditorStateReadOnly){
var writableNode=element.getWritable();
writableNode.__dir=direction;
}
}
activeTextDirection=direction;

dom.__lexicalDirTextContent=subTreeDirectionedTextContent;

dom.__lexicalDir=direction;
}
}
function reconcileChildrenWithDirection(prevElement,nextElement,dom){
var previousSubTreeDirectionTextContent=subTreeDirectionedTextContent;
subTreeDirectionedTextContent='';
reconcileChildren(prevElement,nextElement,dom);
reconcileBlockDirection(nextElement,dom);
subTreeDirectionedTextContent=previousSubTreeDirectionTextContent;
}
function createChildrenArray(element,nodeMap){
var children=[];
var nodeKey=element.__first;
while(nodeKey!==null){
var node=nodeMap.get(nodeKey);
if(node===undefined){
{
throw Error("createChildrenArray: node does not exist in nodeMap");
}
}
children.push(nodeKey);
nodeKey=node.__next;
}
return children;
}
function reconcileChildren(prevElement,nextElement,dom){
var previousSubTreeTextContent=subTreeTextContent;
var prevChildrenSize=prevElement.__size;
var nextChildrenSize=nextElement.__size;
subTreeTextContent='';
if(prevChildrenSize===1&&nextChildrenSize===1){
var prevFirstChildKey=prevElement.__first;
var nextFrstChildKey=nextElement.__first;
if(prevFirstChildKey===nextFrstChildKey){
reconcileNode(prevFirstChildKey,dom);
}else{
var lastDOM=getPrevElementByKeyOrThrow(prevFirstChildKey);
var replacementDOM=createNode(nextFrstChildKey,null,null);
dom.replaceChild(replacementDOM,lastDOM);
destroyNode(prevFirstChildKey,null);
}
}else{
var prevChildren=createChildrenArray(prevElement,activePrevNodeMap);
var nextChildren=createChildrenArray(nextElement,activeNextNodeMap);
if(prevChildrenSize===0){
if(nextChildrenSize!==0){
createChildren(nextChildren,nextElement,0,nextChildrenSize-1,dom,null);
}
}else if(nextChildrenSize===0){
if(prevChildrenSize!==0){

var lexicalLineBreak=dom.__lexicalLineBreak;
var canUseFastPath=lexicalLineBreak==null;
destroyChildren(prevChildren,0,prevChildrenSize-1,canUseFastPath?null:dom);
if(canUseFastPath){

dom.textContent='';
}
}
}else{
reconcileNodeChildren(nextElement,prevChildren,nextChildren,prevChildrenSize,nextChildrenSize,dom);
}
}
if($textContentRequiresDoubleLinebreakAtEnd(nextElement)){
subTreeTextContent+=DOUBLE_LINE_BREAK;
}


dom.__lexicalTextContent=subTreeTextContent;
subTreeTextContent=previousSubTreeTextContent+subTreeTextContent;
}
function reconcileNode(key,parentDOM){
var prevNode=activePrevNodeMap.get(key);
var nextNode=activeNextNodeMap.get(key);
if(prevNode===undefined||nextNode===undefined){
{
throw Error("reconcileNode: prevNode or nextNode does not exist in nodeMap");
}
}
var isDirty=treatAllNodesAsDirty||activeDirtyLeaves.has(key)||activeDirtyElements.has(key);
var dom=getElementByKeyOrThrow(activeEditor$1,key);




if(prevNode===nextNode&&!isDirty){
if($isElementNode(prevNode)){

var previousSubTreeTextContent=dom.__lexicalTextContent;
if(previousSubTreeTextContent!==undefined){
subTreeTextContent+=previousSubTreeTextContent;
editorTextContent+=previousSubTreeTextContent;
}


var previousSubTreeDirectionTextContent=dom.__lexicalDirTextContent;
if(previousSubTreeDirectionTextContent!==undefined){
subTreeDirectionedTextContent+=previousSubTreeDirectionTextContent;
}
}else{
var text=prevNode.getTextContent();
if($isTextNode(prevNode)&&!prevNode.isDirectionless()){
subTreeDirectionedTextContent+=text;
}
editorTextContent+=text;
subTreeTextContent+=text;
}
return dom;
}


if(prevNode!==nextNode&&isDirty){
setMutatedNode(mutatedNodes,activeEditorNodes,activeMutationListeners,nextNode,'updated');
}


if(nextNode.updateDOM(prevNode,dom,activeEditorConfig)){
var replacementDOM=createNode(key,null,null);
if(parentDOM===null){
{
throw Error("reconcileNode: parentDOM is null");
}
}
parentDOM.replaceChild(replacementDOM,dom);
destroyNode(key,null);
return replacementDOM;
}
if($isElementNode(prevNode)&&$isElementNode(nextNode)){

var nextIndent=nextNode.__indent;
if(nextIndent!==prevNode.__indent){
setElementIndent(dom,nextIndent);
}
var nextFormat=nextNode.__format;
if(nextFormat!==prevNode.__format){
setElementFormat(dom,nextFormat);
}
if(isDirty){
reconcileChildrenWithDirection(prevNode,nextNode,dom);
if(!$isRootNode(nextNode)&&!nextNode.isInline()){
reconcileElementTerminatingLineBreak(prevNode,nextNode,dom);
}
}
if($textContentRequiresDoubleLinebreakAtEnd(nextNode)){
subTreeTextContent+=DOUBLE_LINE_BREAK;
editorTextContent+=DOUBLE_LINE_BREAK;
}
}else{
var _text2=nextNode.getTextContent();
if($isDecoratorNode(nextNode)){
var decorator=nextNode.decorate(activeEditor$1,activeEditorConfig);
if(decorator!==null){
reconcileDecorator(key,decorator);
}
}else if($isTextNode(nextNode)&&!nextNode.isDirectionless()){

subTreeDirectionedTextContent+=_text2;
}
subTreeTextContent+=_text2;
editorTextContent+=_text2;
}
if(!activeEditorStateReadOnly&&$isRootNode(nextNode)&&nextNode.__cachedText!==editorTextContent){

var nextRootNode=nextNode.getWritable();
nextRootNode.__cachedText=editorTextContent;
nextNode=nextRootNode;
}
{

Object.freeze(nextNode);
}
return dom;
}
function reconcileDecorator(key,decorator){
var pendingDecorators=activeEditor$1._pendingDecorators;
var currentDecorators=activeEditor$1._decorators;
if(pendingDecorators===null){
if(currentDecorators[key]===decorator){
return;
}
pendingDecorators=cloneDecorators(activeEditor$1);
}
pendingDecorators[key]=decorator;
}
function getFirstChild(element){
return element.firstChild;
}
function getNextSibling(element){
var nextSibling=element.nextSibling;
if(nextSibling!==null&&nextSibling===activeEditor$1._blockCursorElement){
nextSibling=nextSibling.nextSibling;
}
return nextSibling;
}
function reconcileNodeChildren(nextElement,prevChildren,nextChildren,prevChildrenLength,nextChildrenLength,dom){
var prevEndIndex=prevChildrenLength-1;
var nextEndIndex=nextChildrenLength-1;
var prevChildrenSet;
var nextChildrenSet;
var siblingDOM=getFirstChild(dom);
var prevIndex=0;
var nextIndex=0;
while(prevIndex<=prevEndIndex&&nextIndex<=nextEndIndex){
var prevKey=prevChildren[prevIndex];
var nextKey=nextChildren[nextIndex];
if(prevKey===nextKey){
siblingDOM=getNextSibling(reconcileNode(nextKey,dom));
prevIndex++;
nextIndex++;
}else{
if(prevChildrenSet===undefined){
prevChildrenSet=new Set(prevChildren);
}
if(nextChildrenSet===undefined){
nextChildrenSet=new Set(nextChildren);
}
var nextHasPrevKey=nextChildrenSet.has(prevKey);
var prevHasNextKey=prevChildrenSet.has(nextKey);
if(!nextHasPrevKey){

siblingDOM=getNextSibling(getPrevElementByKeyOrThrow(prevKey));
destroyNode(prevKey,dom);
prevIndex++;
}else if(!prevHasNextKey){

createNode(nextKey,dom,siblingDOM);
nextIndex++;
}else{

var childDOM=getElementByKeyOrThrow(activeEditor$1,nextKey);
if(childDOM===siblingDOM){
siblingDOM=getNextSibling(reconcileNode(nextKey,dom));
}else{
if(siblingDOM!=null){
dom.insertBefore(childDOM,siblingDOM);
}else{
dom.appendChild(childDOM);
}
reconcileNode(nextKey,dom);
}
prevIndex++;
nextIndex++;
}
}
}
var appendNewChildren=prevIndex>prevEndIndex;
var removeOldChildren=nextIndex>nextEndIndex;
if(appendNewChildren&&!removeOldChildren){
var previousNode=nextChildren[nextEndIndex+1];
var insertDOM=previousNode===undefined?null:activeEditor$1.getElementByKey(previousNode);
createChildren(nextChildren,nextElement,nextIndex,nextEndIndex,dom,insertDOM);
}else if(removeOldChildren&&!appendNewChildren){
destroyChildren(prevChildren,prevIndex,prevEndIndex,dom);
}
}
function reconcileRoot(prevEditorState,nextEditorState,editor,dirtyType,dirtyElements,dirtyLeaves){


subTreeTextContent='';
editorTextContent='';
subTreeDirectionedTextContent='';


treatAllNodesAsDirty=dirtyType===FULL_RECONCILE;
activeTextDirection=null;
activeEditor$1=editor;
activeEditorConfig=editor._config;
activeEditorNodes=editor._nodes;
activeMutationListeners=activeEditor$1._listeners.mutation;
activeDirtyElements=dirtyElements;
activeDirtyLeaves=dirtyLeaves;
activePrevNodeMap=prevEditorState._nodeMap;
activeNextNodeMap=nextEditorState._nodeMap;
activeEditorStateReadOnly=nextEditorState._readOnly;
activePrevKeyToDOMMap=new Map(editor._keyToDOMMap);


var currentMutatedNodes=new Map();
mutatedNodes=currentMutatedNodes;
reconcileNode('root',null);





activeEditor$1=undefined;

activeEditorNodes=undefined;

activeDirtyElements=undefined;

activeDirtyLeaves=undefined;

activePrevNodeMap=undefined;

activeNextNodeMap=undefined;

activeEditorConfig=undefined;

activePrevKeyToDOMMap=undefined;

mutatedNodes=undefined;
return currentMutatedNodes;
}
function storeDOMWithKey(key,dom,editor){
var keyToDOMMap=editor._keyToDOMMap;

dom['__lexicalKey_'+editor._key]=key;
keyToDOMMap.set(key,dom);
}
function getPrevElementByKeyOrThrow(key){
var element=activePrevKeyToDOMMap.get(key);
if(element===undefined){
{
throw Error("Reconciliation: could not find DOM element for node key "+key);
}
}
return element;
}








var PASS_THROUGH_COMMAND=Object.freeze({});
var ANDROID_COMPOSITION_LATENCY=30;
var rootElementEvents=[['keydown',onKeyDown],['pointerdown',onPointerDown],['compositionstart',onCompositionStart],['compositionend',onCompositionEnd],['input',onInput],['click',onClick],['cut',PASS_THROUGH_COMMAND],['copy',PASS_THROUGH_COMMAND],['dragstart',PASS_THROUGH_COMMAND],['dragover',PASS_THROUGH_COMMAND],['dragend',PASS_THROUGH_COMMAND],['paste',PASS_THROUGH_COMMAND],['focus',PASS_THROUGH_COMMAND],['blur',PASS_THROUGH_COMMAND],['drop',PASS_THROUGH_COMMAND]];
if(CAN_USE_BEFORE_INPUT){
rootElementEvents.push(['beforeinput',function(event,editor){return onBeforeInput(event,editor);}]);
}
var lastKeyDownTimeStamp=0;
var lastKeyCode=0;
var lastBeforeInputInsertTextTimeStamp=0;
var unprocessedBeforeInputData=null;
var rootElementsRegistered=0;
var isSelectionChangeFromDOMUpdate=false;
var isSelectionChangeFromMouseDown=false;
var isInsertLineBreak=false;
var isFirefoxEndingComposition=false;
var collapsedSelectionFormat=[0,'',0,'root',0];








function $shouldPreventDefaultAndInsertText(selection,domTargetRange,text,timeStamp,isBeforeInput){
var anchor=selection.anchor;
var focus=selection.focus;
var anchorNode=anchor.getNode();
var editor=getActiveEditor();
var domSelection=getDOMSelection(editor._window);
var domAnchorNode=domSelection!==null?domSelection.anchorNode:null;
var anchorKey=anchor.key;
var backingAnchorElement=editor.getElementByKey(anchorKey);
var textLength=text.length;
return anchorKey!==focus.key||

!$isTextNode(anchorNode)||

(!isBeforeInput&&(!CAN_USE_BEFORE_INPUT||




lastBeforeInputInsertTextTimeStamp<timeStamp+50)||anchorNode.isDirty()&&textLength<2||doesContainGrapheme(text))&&anchor.offset!==focus.offset&&!anchorNode.isComposing()||

$isTokenOrSegmented(anchorNode)||



anchorNode.isDirty()&&textLength>1||

(isBeforeInput||!CAN_USE_BEFORE_INPUT)&&backingAnchorElement!==null&&!anchorNode.isComposing()&&domAnchorNode!==getDOMTextNode(backingAnchorElement)||


domSelection!==null&&domTargetRange!==null&&(!domTargetRange.collapsed||domTargetRange.startContainer!==domSelection.anchorNode||domTargetRange.startOffset!==domSelection.anchorOffset)||

anchorNode.getFormat()!==selection.format||anchorNode.getStyle()!==selection.style||

$shouldInsertTextAfterOrBeforeTextNode(selection,anchorNode);
}
function shouldSkipSelectionChange(domNode,offset){
return domNode!==null&&domNode.nodeValue!==null&&domNode.nodeType===DOM_TEXT_TYPE&&offset!==0&&offset!==domNode.nodeValue.length;
}
function onSelectionChange(domSelection,editor,isActive){var

anchorDOM=



domSelection.anchorNode,anchorOffset=domSelection.anchorOffset,focusDOM=domSelection.focusNode,focusOffset=domSelection.focusOffset;
if(isSelectionChangeFromDOMUpdate){
isSelectionChangeFromDOMUpdate=false;









if(shouldSkipSelectionChange(anchorDOM,anchorOffset)&&shouldSkipSelectionChange(focusDOM,focusOffset)){
return;
}
}
updateEditor(editor,function(){


if(!isActive){
$setSelection(null);
return;
}
if(!isSelectionWithinEditor(editor,anchorDOM,focusDOM)){
return;
}
var selection=$getSelection();


if($isRangeSelection(selection)){
var anchor=selection.anchor;
var anchorNode=anchor.getNode();
if(selection.isCollapsed()){

if(domSelection.type==='Range'&&domSelection.anchorNode===domSelection.focusNode){
selection.dirty=true;
}




var windowEvent=getWindow(editor).event;
var currentTimeStamp=windowEvent?windowEvent.timeStamp:performance.now();var _collapsedSelectionFo=
collapsedSelectionFormat,lastFormat=_collapsedSelectionFo[0],lastStyle=_collapsedSelectionFo[1],lastOffset=_collapsedSelectionFo[2],lastKey=_collapsedSelectionFo[3],timeStamp=_collapsedSelectionFo[4];
var root=$getRoot();
var isRootTextContentEmpty=editor.isComposing()===false&&root.getTextContent()==='';
if(currentTimeStamp<timeStamp+200&&anchor.offset===lastOffset&&anchor.key===lastKey){
selection.format=lastFormat;
selection.style=lastStyle;
}else{
if(anchor.type==='text'){
if(!$isTextNode(anchorNode)){
throw Error("Point.getNode() must return TextNode when type is text");
}
selection.format=anchorNode.getFormat();
selection.style=anchorNode.getStyle();
}else if(anchor.type==='element'&&!isRootTextContentEmpty){
selection.format=0;
selection.style='';
}
}
}else{
var anchorKey=anchor.key;
var focus=selection.focus;
var focusKey=focus.key;
var nodes=selection.getNodes();
var nodesLength=nodes.length;
var isBackward=selection.isBackward();
var startOffset=isBackward?focusOffset:anchorOffset;
var endOffset=isBackward?anchorOffset:focusOffset;
var startKey=isBackward?focusKey:anchorKey;
var endKey=isBackward?anchorKey:focusKey;
var combinedFormat=IS_ALL_FORMATTING;
var hasTextNodes=false;
for(var i=0;i<nodesLength;i++){
var node=nodes[i];
var textContentSize=node.getTextContentSize();
if($isTextNode(node)&&textContentSize!==0&&

!(i===0&&node.__key===startKey&&startOffset===textContentSize||i===nodesLength-1&&node.__key===endKey&&endOffset===0)){

hasTextNodes=true;
combinedFormat&=node.getFormat();
if(combinedFormat===0){
break;
}
}
}
selection.format=hasTextNodes?combinedFormat:0;
}
}
_dispatchCommand(editor,SELECTION_CHANGE_COMMAND,undefined);
});
}






function onClick(event,editor){
updateEditor(editor,function(){
var selection=$getSelection();
var domSelection=getDOMSelection(editor._window);
var lastSelection=$getPreviousSelection();
if(domSelection){
if($isRangeSelection(selection)){
var anchor=selection.anchor;
var anchorNode=anchor.getNode();
if(anchor.type==='element'&&anchor.offset===0&&selection.isCollapsed()&&!$isRootNode(anchorNode)&&$getRoot().getChildrenSize()===1&&anchorNode.getTopLevelElementOrThrow().isEmpty()&&lastSelection!==null&&selection.is(lastSelection)){
domSelection.removeAllRanges();
selection.dirty=true;
}else if(event.detail===3&&!selection.isCollapsed()){




var focus=selection.focus;
var focusNode=focus.getNode();
if(anchorNode!==focusNode){
if($isElementNode(anchorNode)){
anchorNode.select(0);
}else{
anchorNode.getParentOrThrow().select(0);
}
}
}
}else if(event.pointerType==='touch'){


var domAnchorNode=domSelection.anchorNode;
if(domAnchorNode!==null){
var nodeType=domAnchorNode.nodeType;




if(nodeType===DOM_ELEMENT_TYPE||nodeType===DOM_TEXT_TYPE){
var newSelection=internalCreateRangeSelection(lastSelection,domSelection,editor,event);
$setSelection(newSelection);
}
}
}
}
_dispatchCommand(editor,CLICK_COMMAND,event);
});
}
function onPointerDown(event,editor){

var target=event.target;
var pointerType=event.pointerType;
if(target instanceof Node&&pointerType!=='touch'){
updateEditor(editor,function(){


if(!$isSelectionCapturedInDecorator(target)){
isSelectionChangeFromMouseDown=true;
}
});
}
}
function getTargetRange(event){
if(!event.getTargetRanges){
return null;
}
var targetRanges=event.getTargetRanges();
if(targetRanges.length===0){
return null;
}
return targetRanges[0];
}
function $canRemoveText(anchorNode,focusNode){
return anchorNode!==focusNode||$isElementNode(anchorNode)||$isElementNode(focusNode)||!anchorNode.isToken()||!focusNode.isToken();
}
function isPossiblyAndroidKeyPress(timeStamp){
return lastKeyCode===229&&timeStamp<lastKeyDownTimeStamp+ANDROID_COMPOSITION_LATENCY;
}
function onBeforeInput(event,editor){
var inputType=event.inputType;
var targetRange=getTargetRange(event);


if(inputType==='deleteCompositionText'||





IS_FIREFOX&&isFirefoxClipboardEvents(editor)){
return;
}else if(inputType==='insertCompositionText'){
return;
}
updateEditor(editor,function(){
var selection=$getSelection();
if(inputType==='deleteContentBackward'){
if(selection===null){

var prevSelection=$getPreviousSelection();
if(!$isRangeSelection(prevSelection)){
return;
}
$setSelection(prevSelection.clone());
}
if($isRangeSelection(selection)){

if(IS_ANDROID){
$setCompositionKey(selection.anchor.key);
}
if(isPossiblyAndroidKeyPress(event.timeStamp)&&editor.isComposing()&&selection.anchor.key===selection.focus.key){
$setCompositionKey(null);
lastKeyDownTimeStamp=0;

setTimeout(function(){
updateEditor(editor,function(){
$setCompositionKey(null);
});
},ANDROID_COMPOSITION_LATENCY);
if($isRangeSelection(selection)){
var _anchorNode=selection.anchor.getNode();
_anchorNode.markDirty();
selection.format=_anchorNode.getFormat();
if(!$isTextNode(_anchorNode)){
throw Error("Anchor node must be a TextNode");
}
selection.style=_anchorNode.getStyle();
}
var selectedText=selection.anchor.getNode().getTextContent();
if(selectedText.length<=1){
event.preventDefault();
_dispatchCommand(editor,DELETE_CHARACTER_COMMAND,true);
}
}else{
$setCompositionKey(null);
event.preventDefault();
_dispatchCommand(editor,DELETE_CHARACTER_COMMAND,true);
}
return;
}
}
if(!$isRangeSelection(selection)){
return;
}
var data=event.data;








if(unprocessedBeforeInputData!==null){
$updateSelectedTextFromDOM(false,editor,unprocessedBeforeInputData);
}
if((!selection.dirty||unprocessedBeforeInputData!==null)&&selection.isCollapsed()&&!$isRootNode(selection.anchor.getNode())&&targetRange!==null){
selection.applyDOMRange(targetRange);
}
unprocessedBeforeInputData=null;
var anchor=selection.anchor;
var focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if(inputType==='insertText'||inputType==='insertTranspose'){
if(data==='\n'){
event.preventDefault();
_dispatchCommand(editor,INSERT_LINE_BREAK_COMMAND,false);
}else if(data===DOUBLE_LINE_BREAK){
event.preventDefault();
_dispatchCommand(editor,INSERT_PARAGRAPH_COMMAND,undefined);
}else if(data==null&&event.dataTransfer){

var text=event.dataTransfer.getData('text/plain');
event.preventDefault();
selection.insertRawText(text);
}else if(data!=null&&$shouldPreventDefaultAndInsertText(selection,targetRange,data,event.timeStamp,true)){
event.preventDefault();
_dispatchCommand(editor,CONTROLLED_TEXT_INSERTION_COMMAND,data);
}else{
unprocessedBeforeInputData=data;
}
lastBeforeInputInsertTextTimeStamp=event.timeStamp;
return;
}




event.preventDefault();
switch(inputType){
case'insertFromYank':
case'insertFromDrop':
case'insertReplacementText':
{
_dispatchCommand(editor,CONTROLLED_TEXT_INSERTION_COMMAND,event);
break;
}
case'insertFromComposition':
{

$setCompositionKey(null);
_dispatchCommand(editor,CONTROLLED_TEXT_INSERTION_COMMAND,event);
break;
}
case'insertLineBreak':
{

$setCompositionKey(null);
_dispatchCommand(editor,INSERT_LINE_BREAK_COMMAND,false);
break;
}
case'insertParagraph':
{

$setCompositionKey(null);





if(isInsertLineBreak&&!IS_IOS){
isInsertLineBreak=false;
_dispatchCommand(editor,INSERT_LINE_BREAK_COMMAND,false);
}else{
_dispatchCommand(editor,INSERT_PARAGRAPH_COMMAND,undefined);
}
break;
}
case'insertFromPaste':
case'insertFromPasteAsQuotation':
{
_dispatchCommand(editor,PASTE_COMMAND,event);
break;
}
case'deleteByComposition':
{
if($canRemoveText(anchorNode,focusNode)){
_dispatchCommand(editor,REMOVE_TEXT_COMMAND,event);
}
break;
}
case'deleteByDrag':
case'deleteByCut':
{
_dispatchCommand(editor,REMOVE_TEXT_COMMAND,event);
break;
}
case'deleteContent':
{
_dispatchCommand(editor,DELETE_CHARACTER_COMMAND,false);
break;
}
case'deleteWordBackward':
{
_dispatchCommand(editor,DELETE_WORD_COMMAND,true);
break;
}
case'deleteWordForward':
{
_dispatchCommand(editor,DELETE_WORD_COMMAND,false);
break;
}
case'deleteHardLineBackward':
case'deleteSoftLineBackward':
{
_dispatchCommand(editor,DELETE_LINE_COMMAND,true);
break;
}
case'deleteContentForward':
case'deleteHardLineForward':
case'deleteSoftLineForward':
{
_dispatchCommand(editor,DELETE_LINE_COMMAND,false);
break;
}
case'formatStrikeThrough':
{
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'strikethrough');
break;
}
case'formatBold':
{
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'bold');
break;
}
case'formatItalic':
{
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'italic');
break;
}
case'formatUnderline':
{
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'underline');
break;
}
case'historyUndo':
{
_dispatchCommand(editor,UNDO_COMMAND,undefined);
break;
}
case'historyRedo':
{
_dispatchCommand(editor,REDO_COMMAND,undefined);
break;
}}


});
}
function onInput(event,editor){

event.stopPropagation();
updateEditor(editor,function(){
var selection=$getSelection();
var data=event.data;
var targetRange=getTargetRange(event);
if(data!=null&&$isRangeSelection(selection)&&$shouldPreventDefaultAndInsertText(selection,targetRange,data,event.timeStamp,false)){



if(isFirefoxEndingComposition){
onCompositionEndImpl(editor,data);
isFirefoxEndingComposition=false;
}
var anchor=selection.anchor;
var anchorNode=anchor.getNode();
var domSelection=getDOMSelection(editor._window);
if(domSelection===null){
return;
}
var offset=anchor.offset;



if(!CAN_USE_BEFORE_INPUT||selection.isCollapsed()||!$isTextNode(anchorNode)||domSelection.anchorNode===null||anchorNode.getTextContent().slice(0,offset)+data+anchorNode.getTextContent().slice(offset+selection.focus.offset)!==getAnchorTextFromDOM(domSelection.anchorNode)){
_dispatchCommand(editor,CONTROLLED_TEXT_INSERTION_COMMAND,data);
}
var textLength=data.length;



if(IS_FIREFOX&&textLength>1&&event.inputType==='insertCompositionText'&&!editor.isComposing()){
selection.anchor.offset-=textLength;
}


if(!IS_SAFARI&&!IS_IOS&&!IS_APPLE_WEBKIT&&editor.isComposing()){
lastKeyDownTimeStamp=0;
$setCompositionKey(null);
}
}else{
var characterData=data!==null?data:undefined;
$updateSelectedTextFromDOM(false,editor,characterData);


if(isFirefoxEndingComposition){
onCompositionEndImpl(editor,data||undefined);
isFirefoxEndingComposition=false;
}
}



$flushMutations();
});
unprocessedBeforeInputData=null;
}
function onCompositionStart(event,editor){
updateEditor(editor,function(){
var selection=$getSelection();
if($isRangeSelection(selection)&&!editor.isComposing()){
var anchor=selection.anchor;
var node=selection.anchor.getNode();
$setCompositionKey(anchor.key);
if(



event.timeStamp<lastKeyDownTimeStamp+ANDROID_COMPOSITION_LATENCY||


anchor.type==='element'||!selection.isCollapsed()||node.getFormat()!==selection.format||$isTextNode(node)&&node.getStyle()!==selection.style){




_dispatchCommand(editor,CONTROLLED_TEXT_INSERTION_COMMAND,COMPOSITION_START_CHAR);
}
}
});
}
function onCompositionEndImpl(editor,data){
var compositionKey=editor._compositionKey;
$setCompositionKey(null);


if(compositionKey!==null&&data!=null){


if(data===''){
var node=$getNodeByKey(compositionKey);
var textNode=getDOMTextNode(editor.getElementByKey(compositionKey));
if(textNode!==null&&textNode.nodeValue!==null&&$isTextNode(node)){
$updateTextNodeFromDOMContent(node,textNode.nodeValue,null,null,true);
}
return;
}



if(data[data.length-1]==='\n'){
var selection=$getSelection();
if($isRangeSelection(selection)){


var focus=selection.focus;
selection.anchor.set(focus.key,focus.offset,focus.type);
_dispatchCommand(editor,KEY_ENTER_COMMAND,null);
return;
}
}
}
$updateSelectedTextFromDOM(true,editor,data);
}
function onCompositionEnd(event,editor){





if(IS_FIREFOX){
isFirefoxEndingComposition=true;
}else{
updateEditor(editor,function(){
onCompositionEndImpl(editor,event.data);
});
}
}
function onKeyDown(event,editor){
lastKeyDownTimeStamp=event.timeStamp;
lastKeyCode=event.keyCode;
if(editor.isComposing()){
return;
}var

keyCode=




event.keyCode,shiftKey=event.shiftKey,ctrlKey=event.ctrlKey,metaKey=event.metaKey,altKey=event.altKey;
if(_dispatchCommand(editor,KEY_DOWN_COMMAND,event)){
return;
}
if(isMoveForward(keyCode,ctrlKey,altKey,metaKey)){
_dispatchCommand(editor,KEY_ARROW_RIGHT_COMMAND,event);
}else if(isMoveToEnd(keyCode,ctrlKey,shiftKey,altKey,metaKey)){
_dispatchCommand(editor,MOVE_TO_END,event);
}else if(isMoveBackward(keyCode,ctrlKey,altKey,metaKey)){
_dispatchCommand(editor,KEY_ARROW_LEFT_COMMAND,event);
}else if(isMoveToStart(keyCode,ctrlKey,shiftKey,altKey,metaKey)){
_dispatchCommand(editor,MOVE_TO_START,event);
}else if(isMoveUp(keyCode,ctrlKey,metaKey)){
_dispatchCommand(editor,KEY_ARROW_UP_COMMAND,event);
}else if(isMoveDown(keyCode,ctrlKey,metaKey)){
_dispatchCommand(editor,KEY_ARROW_DOWN_COMMAND,event);
}else if(isLineBreak(keyCode,shiftKey)){
isInsertLineBreak=true;
_dispatchCommand(editor,KEY_ENTER_COMMAND,event);
}else if(isSpace(keyCode)){
_dispatchCommand(editor,KEY_SPACE_COMMAND,event);
}else if(isOpenLineBreak(keyCode,ctrlKey)){
event.preventDefault();
isInsertLineBreak=true;
_dispatchCommand(editor,INSERT_LINE_BREAK_COMMAND,true);
}else if(isParagraph(keyCode,shiftKey)){
isInsertLineBreak=false;
_dispatchCommand(editor,KEY_ENTER_COMMAND,event);
}else if(isDeleteBackward(keyCode,altKey,metaKey,ctrlKey)){
if(isBackspace(keyCode)){
_dispatchCommand(editor,KEY_BACKSPACE_COMMAND,event);
}else{
event.preventDefault();
_dispatchCommand(editor,DELETE_CHARACTER_COMMAND,true);
}
}else if(isEscape(keyCode)){
_dispatchCommand(editor,KEY_ESCAPE_COMMAND,event);
}else if(isDeleteForward(keyCode,ctrlKey,shiftKey,altKey,metaKey)){
if(isDelete(keyCode)){
_dispatchCommand(editor,KEY_DELETE_COMMAND,event);
}else{
event.preventDefault();
_dispatchCommand(editor,DELETE_CHARACTER_COMMAND,false);
}
}else if(isDeleteWordBackward(keyCode,altKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,DELETE_WORD_COMMAND,true);
}else if(isDeleteWordForward(keyCode,altKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,DELETE_WORD_COMMAND,false);
}else if(isDeleteLineBackward(keyCode,metaKey)){
event.preventDefault();
_dispatchCommand(editor,DELETE_LINE_COMMAND,true);
}else if(isDeleteLineForward(keyCode,metaKey)){
event.preventDefault();
_dispatchCommand(editor,DELETE_LINE_COMMAND,false);
}else if(isBold(keyCode,altKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'bold');
}else if(isUnderline(keyCode,altKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'underline');
}else if(isItalic(keyCode,altKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,FORMAT_TEXT_COMMAND,'italic');
}else if(isTab(keyCode,altKey,ctrlKey,metaKey)){
_dispatchCommand(editor,KEY_TAB_COMMAND,event);
}else if(isUndo(keyCode,shiftKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,UNDO_COMMAND,undefined);
}else if(isRedo(keyCode,shiftKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,REDO_COMMAND,undefined);
}else{
var prevSelection=editor._editorState._selection;
if($isNodeSelection(prevSelection)){
if(isCopy(keyCode,shiftKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,COPY_COMMAND,event);
}else if(isCut(keyCode,shiftKey,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,CUT_COMMAND,event);
}else if(isSelectAll(keyCode,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,SELECT_ALL_COMMAND,event);
}

}else if(!IS_FIREFOX&&isSelectAll(keyCode,metaKey,ctrlKey)){
event.preventDefault();
_dispatchCommand(editor,SELECT_ALL_COMMAND,event);
}
}
if(isModifier(ctrlKey,shiftKey,altKey,metaKey)){
_dispatchCommand(editor,KEY_MODIFIER_COMMAND,event);
}
}
function getRootElementRemoveHandles(rootElement){

var eventHandles=rootElement.__lexicalEventHandles;
if(eventHandles===undefined){
eventHandles=[];

rootElement.__lexicalEventHandles=eventHandles;
}
return eventHandles;
}



var activeNestedEditorsMap=new Map();
function onDocumentSelectionChange(event){
var target=event.target;
var targetWindow=target==null?null:target.nodeType===9?target.defaultView:target.ownerDocument.defaultView;
var domSelection=getDOMSelection(targetWindow);
if(domSelection===null){
return;
}
var nextActiveEditor=getNearestEditorFromDOMNode(domSelection.anchorNode);
if(nextActiveEditor===null){
return;
}
if(isSelectionChangeFromMouseDown){
isSelectionChangeFromMouseDown=false;
updateEditor(nextActiveEditor,function(){
var lastSelection=$getPreviousSelection();
var domAnchorNode=domSelection.anchorNode;
if(domAnchorNode===null){
return;
}
var nodeType=domAnchorNode.nodeType;




if(nodeType!==DOM_ELEMENT_TYPE&&nodeType!==DOM_TEXT_TYPE){
return;
}
var newSelection=internalCreateRangeSelection(lastSelection,domSelection,nextActiveEditor,event);
$setSelection(newSelection);
});
}




var editors=getEditorsToPropagate(nextActiveEditor);
var rootEditor=editors[editors.length-1];
var rootEditorKey=rootEditor._key;
var activeNestedEditor=activeNestedEditorsMap.get(rootEditorKey);
var prevActiveEditor=activeNestedEditor||rootEditor;
if(prevActiveEditor!==nextActiveEditor){
onSelectionChange(domSelection,prevActiveEditor,false);
}
onSelectionChange(domSelection,nextActiveEditor,true);


if(nextActiveEditor!==rootEditor){
activeNestedEditorsMap.set(rootEditorKey,nextActiveEditor);
}else if(activeNestedEditor){
activeNestedEditorsMap["delete"](rootEditorKey);
}
}
function stopLexicalPropagation(event){



event._lexicalHandled=true;
}
function hasStoppedLexicalPropagation(event){

var stopped=event._lexicalHandled===true;
return stopped;
}
function addRootElementEvents(rootElement,editor){


if(rootElementsRegistered===0){
var doc=rootElement.ownerDocument;
doc.addEventListener('selectionchange',onDocumentSelectionChange);
}
rootElementsRegistered++;

rootElement.__lexicalEditor=editor;
var removeHandles=getRootElementRemoveHandles(rootElement);var _loop=function _loop(
i){var _rootElementEvents$i=
rootElementEvents[i],eventName=_rootElementEvents$i[0],onEvent=_rootElementEvents$i[1];
var eventHandler=typeof onEvent==='function'?function(event){
if(hasStoppedLexicalPropagation(event)){
return;
}
stopLexicalPropagation(event);
if(editor.isEditable()){
onEvent(event,editor);
}
}:function(event){
if(hasStoppedLexicalPropagation(event)){
return;
}
stopLexicalPropagation(event);
if(editor.isEditable()){
switch(eventName){
case'cut':
return _dispatchCommand(editor,CUT_COMMAND,event);
case'copy':
return _dispatchCommand(editor,COPY_COMMAND,event);
case'paste':
return _dispatchCommand(editor,PASTE_COMMAND,event);
case'dragstart':
return _dispatchCommand(editor,DRAGSTART_COMMAND,event);
case'dragover':
return _dispatchCommand(editor,DRAGOVER_COMMAND,event);
case'dragend':
return _dispatchCommand(editor,DRAGEND_COMMAND,event);
case'focus':
return _dispatchCommand(editor,FOCUS_COMMAND,event);
case'blur':
{
return _dispatchCommand(editor,BLUR_COMMAND,event);
}
case'drop':
return _dispatchCommand(editor,DROP_COMMAND,event);}

}
};
rootElement.addEventListener(eventName,eventHandler);
removeHandles.push(function(){
rootElement.removeEventListener(eventName,eventHandler);
});};for(var i=0;i<rootElementEvents.length;i++){_loop(i);
}
}
function removeRootElementEvents(rootElement){
if(rootElementsRegistered!==0){
rootElementsRegistered--;



if(rootElementsRegistered===0){
var doc=rootElement.ownerDocument;
doc.removeEventListener('selectionchange',onDocumentSelectionChange);
}
}


var editor=rootElement.__lexicalEditor;
if(editor!==null&&editor!==undefined){
cleanActiveNestedEditorsMap(editor);

rootElement.__lexicalEditor=null;
}
var removeHandles=getRootElementRemoveHandles(rootElement);
for(var i=0;i<removeHandles.length;i++){
removeHandles[i]();
}


rootElement.__lexicalEventHandles=[];
}
function cleanActiveNestedEditorsMap(editor){
if(editor._parentEditor!==null){

var editors=getEditorsToPropagate(editor);
var rootEditor=editors[editors.length-1];
var rootEditorKey=rootEditor._key;
if(activeNestedEditorsMap.get(rootEditorKey)===editor){
activeNestedEditorsMap["delete"](rootEditorKey);
}
}else{

activeNestedEditorsMap["delete"](editor._key);
}
}
function markSelectionChangeFromDOMUpdate(){
isSelectionChangeFromDOMUpdate=true;
}
function markCollapsedSelectionFormat(format,style,offset,key,timeStamp){
collapsedSelectionFormat=[format,style,offset,key,timeStamp];
}








function removeNode(nodeToRemove,restoreSelection,preserveEmptyParent){
errorOnReadOnly();
var key=nodeToRemove.__key;
var parent=nodeToRemove.getParent();
if(parent===null){
return;
}
var selection=$maybeMoveChildrenSelectionToParent(nodeToRemove);
var selectionMoved=false;
if($isRangeSelection(selection)&&restoreSelection){
var anchor=selection.anchor;
var focus=selection.focus;
if(anchor.key===key){
moveSelectionPointToSibling(anchor,nodeToRemove,parent,nodeToRemove.getPreviousSibling(),nodeToRemove.getNextSibling());
selectionMoved=true;
}
if(focus.key===key){
moveSelectionPointToSibling(focus,nodeToRemove,parent,nodeToRemove.getPreviousSibling(),nodeToRemove.getNextSibling());
selectionMoved=true;
}
}else if($isNodeSelection(selection)&&restoreSelection&&nodeToRemove.isSelected()){
nodeToRemove.selectPrevious();
}
if($isRangeSelection(selection)&&restoreSelection&&!selectionMoved){

var index=nodeToRemove.getIndexWithinParent();
removeFromParent(nodeToRemove);
$updateElementSelectionOnCreateDeleteNode(selection,parent,index,-1);
}else{
removeFromParent(nodeToRemove);
}
if(!preserveEmptyParent&&!$isRootOrShadowRoot(parent)&&!parent.canBeEmpty()&&parent.isEmpty()){
removeNode(parent,restoreSelection);
}
if(restoreSelection&&$isRootNode(parent)&&parent.isEmpty()){
parent.selectEnd();
}
}var
LexicalNode=function(){LexicalNode.
























getType=function getType(){
{
throw Error("LexicalNode: Node "+this.name+" does not implement .getType().");
}
};LexicalNode.







clone=function clone(_data){
{
throw Error("LexicalNode: Node "+this.name+" does not implement .clone().");
}
};



function LexicalNode(key){
this.__type=this.constructor.getType();
this.__parent=null;
this.__prev=null;
this.__next=null;
$setNodeKey(this,key);
{
if(this.__type!=='root'){
errorOnReadOnly();
errorOnTypeKlassMismatch(this.__type,this.constructor);
}
}
}var _proto=LexicalNode.prototype;_proto.





getType=function getType(){
return this.__type;
};_proto.
isInline=function isInline(){
{
throw Error("LexicalNode: Node "+this.constructor.name+" does not implement .isInline().");
}
};_proto.






isAttached=function isAttached(){
var nodeKey=this.__key;
while(nodeKey!==null){
if(nodeKey==='root'){
return true;
}
var node=$getNodeByKey(nodeKey);
if(node===null){
break;
}
nodeKey=node.__parent;
}
return false;
};_proto.








isSelected=function isSelected(selection){var _this5=this;
var targetSelection=selection||$getSelection();
if(targetSelection==null){
return false;
}
var isSelected=targetSelection.getNodes().some(function(n){return n.__key===_this5.__key;});
if($isTextNode(this)){
return isSelected;
}


if($isRangeSelection(targetSelection)&&targetSelection.anchor.type==='element'&&targetSelection.focus.type==='element'&&targetSelection.anchor.key===targetSelection.focus.key&&targetSelection.anchor.offset===targetSelection.focus.offset){
return false;
}
return isSelected;
};_proto.




getKey=function getKey(){

return this.__key;
};_proto.




getIndexWithinParent=function getIndexWithinParent(){
var parent=this.getParent();
if(parent===null){
return-1;
}
var node=parent.getFirstChild();
var index=0;
while(node!==null){
if(this.is(node)){
return index;
}
index++;
node=node.getNextSibling();
}
return-1;
};_proto.




getParent=function getParent(){
var parent=this.getLatest().__parent;
if(parent===null){
return null;
}
return $getNodeByKey(parent);
};_proto.




getParentOrThrow=function getParentOrThrow(){
var parent=this.getParent();
if(parent===null){
{
throw Error("Expected node "+this.__key+" to have a parent.");
}
}
return parent;
};_proto.






getTopLevelElement=function getTopLevelElement(){
var node=this;
while(node!==null){
var parent=node.getParent();
if($isRootOrShadowRoot(parent)){
if(!$isElementNode(node)){
throw Error("Children of root nodes must be elements");
}
return node;
}
node=parent;
}
return null;
};_proto.






getTopLevelElementOrThrow=function getTopLevelElementOrThrow(){
var parent=this.getTopLevelElement();
if(parent===null){
{
throw Error("Expected node "+this.__key+" to have a top parent element.");
}
}
return parent;
};_proto.






getParents=function getParents(){
var parents=[];
var node=this.getParent();
while(node!==null){
parents.push(node);
node=node.getParent();
}
return parents;
};_proto.






getParentKeys=function getParentKeys(){
var parents=[];
var node=this.getParent();
while(node!==null){
parents.push(node.__key);
node=node.getParent();
}
return parents;
};_proto.






getPreviousSibling=function getPreviousSibling(){
var self=this.getLatest();
var prevKey=self.__prev;
return prevKey===null?null:$getNodeByKey(prevKey);
};_proto.






getPreviousSiblings=function getPreviousSiblings(){
var siblings=[];
var parent=this.getParent();
if(parent===null){
return siblings;
}
var node=parent.getFirstChild();
while(node!==null){
if(node.is(this)){
break;
}
siblings.push(node);
node=node.getNextSibling();
}
return siblings;
};_proto.






getNextSibling=function getNextSibling(){
var self=this.getLatest();
var nextKey=self.__next;
return nextKey===null?null:$getNodeByKey(nextKey);
};_proto.






getNextSiblings=function getNextSiblings(){
var siblings=[];
var node=this.getNextSibling();
while(node!==null){
siblings.push(node);
node=node.getNextSibling();
}
return siblings;
};_proto.







getCommonAncestor=function getCommonAncestor(node){
var a=this.getParents();
var b=node.getParents();
if($isElementNode(this)){
a.unshift(this);
}
if($isElementNode(node)){
b.unshift(node);
}
var aLength=a.length;
var bLength=b.length;
if(aLength===0||bLength===0||a[aLength-1]!==b[bLength-1]){
return null;
}
var bSet=new Set(b);
for(var i=0;i<aLength;i++){
var ancestor=a[i];
if(bSet.has(ancestor)){
return ancestor;
}
}
return null;
};_proto.







is=function is(object){
if(object==null){
return false;
}
return this.__key===object.__key;
};_proto.






isBefore=function isBefore(targetNode){
if(this===targetNode){
return false;
}
if(targetNode.isParentOf(this)){
return true;
}
if(this.isParentOf(targetNode)){
return false;
}
var commonAncestor=this.getCommonAncestor(targetNode);
var indexA=0;
var indexB=0;
var node=this;
while(true){
var parent=node.getParentOrThrow();
if(parent===commonAncestor){
indexA=node.getIndexWithinParent();
break;
}
node=parent;
}
node=targetNode;
while(true){
var _parent=node.getParentOrThrow();
if(_parent===commonAncestor){
indexB=node.getIndexWithinParent();
break;
}
node=_parent;
}
return indexA<indexB;
};_proto.






isParentOf=function isParentOf(targetNode){
var key=this.__key;
if(key===targetNode.__key){
return false;
}
var node=targetNode;
while(node!==null){
if(node.__key===key){
return true;
}
node=node.getParent();
}
return false;
};_proto.








getNodesBetween=function getNodesBetween(targetNode){
var isBefore=this.isBefore(targetNode);
var nodes=[];
var visited=new Set();
var node=this;
while(true){
if(node===null){
break;
}
var key=node.__key;
if(!visited.has(key)){
visited.add(key);
nodes.push(node);
}
if(node===targetNode){
break;
}
var child=$isElementNode(node)?isBefore?node.getFirstChild():node.getLastChild():null;
if(child!==null){
node=child;
continue;
}
var nextSibling=isBefore?node.getNextSibling():node.getPreviousSibling();
if(nextSibling!==null){
node=nextSibling;
continue;
}
var parent=node.getParentOrThrow();
if(!visited.has(parent.__key)){
nodes.push(parent);
}
if(parent===targetNode){
break;
}
var parentSibling=null;
var ancestor=parent;
do{
if(ancestor===null){
{
throw Error("getNodesBetween: ancestor is null");
}
}
parentSibling=isBefore?ancestor.getNextSibling():ancestor.getPreviousSibling();
ancestor=ancestor.getParent();
if(ancestor!==null){
if(parentSibling===null&&!visited.has(ancestor.__key)){
nodes.push(ancestor);
}
}else{
break;
}
}while(parentSibling===null);
node=parentSibling;
}
if(!isBefore){
nodes.reverse();
}
return nodes;
};_proto.





isDirty=function isDirty(){
var editor=getActiveEditor();
var dirtyLeaves=editor._dirtyLeaves;
return dirtyLeaves!==null&&dirtyLeaves.has(this.__key);
};_proto.






getLatest=function getLatest(){
var latest=$getNodeByKey(this.__key);
if(latest===null){
{
throw Error("Lexical node does not exist in active editor state. Avoid using the same node references between nested closures from editorState.read/editor.update.");
}
}
return latest;
};_proto.






getWritable=function getWritable(){
errorOnReadOnly();
var editorState=getActiveEditorState();
var editor=getActiveEditor();
var nodeMap=editorState._nodeMap;
var key=this.__key;

var latestNode=this.getLatest();
var parent=latestNode.__parent;
var cloneNotNeeded=editor._cloneNotNeeded;
var selection=$getSelection();
if(selection!==null){
selection.setCachedNodes(null);
}
if(cloneNotNeeded.has(key)){

internalMarkNodeAsDirty(latestNode);
return latestNode;
}
var constructor=latestNode.constructor;
var mutableNode=constructor.clone(latestNode);
mutableNode.__parent=parent;
mutableNode.__next=latestNode.__next;
mutableNode.__prev=latestNode.__prev;
if($isElementNode(latestNode)&&$isElementNode(mutableNode)){
mutableNode.__first=latestNode.__first;
mutableNode.__last=latestNode.__last;
mutableNode.__size=latestNode.__size;
mutableNode.__indent=latestNode.__indent;
mutableNode.__format=latestNode.__format;
mutableNode.__dir=latestNode.__dir;
}else if($isTextNode(latestNode)&&$isTextNode(mutableNode)){
mutableNode.__format=latestNode.__format;
mutableNode.__style=latestNode.__style;
mutableNode.__mode=latestNode.__mode;
mutableNode.__detail=latestNode.__detail;
}
cloneNotNeeded.add(key);
mutableNode.__key=key;
internalMarkNodeAsDirty(mutableNode);

nodeMap.set(key,mutableNode);


return mutableNode;
};_proto.







getTextContent=function getTextContent(){
return'';
};_proto.





getTextContentSize=function getTextContentSize(){
return this.getTextContent().length;
};_proto.















createDOM=function createDOM(_config,_editor){
{
throw Error("createDOM: base method not extended");
}
};_proto.











updateDOM=function updateDOM(_prevNode,_dom,_config){
{
throw Error("updateDOM: base method not extended");
}
};_proto.









exportDOM=function exportDOM(editor){
var element=this.createDOM(editor._config,editor);
return{
element:element};

};_proto.








exportJSON=function exportJSON(){
{
throw Error("exportJSON: base method not extended");
}
};LexicalNode.








importJSON=function importJSON(_serializedNode){
{
throw Error("LexicalNode: Node "+this.name+" does not implement .importJSON().");
}
};LexicalNode.









transform=function transform(){
return null;
};_proto.











remove=function remove(preserveEmptyParent){
removeNode(this,true,preserveEmptyParent);
};_proto.








replace=function replace(replaceWith,includeChildren){
errorOnReadOnly();
var selection=$getSelection();
if(selection!==null)selection=selection.clone();
errorOnInsertTextNodeOnRoot(this,replaceWith);
var self=this.getLatest();
var toReplaceKey=this.__key;
var key=replaceWith.__key;
var writableReplaceWith=replaceWith.getWritable();
var writableParent=this.getParentOrThrow().getWritable();
var size=writableParent.__size;
removeFromParent(writableReplaceWith);
var prevSibling=self.getPreviousSibling();
var nextSibling=self.getNextSibling();
var prevKey=self.__prev;
var nextKey=self.__next;
var parentKey=self.__parent;
removeNode(self,false,true);
if(prevSibling===null){
writableParent.__first=key;
}else{
var writablePrevSibling=prevSibling.getWritable();
writablePrevSibling.__next=key;
}
writableReplaceWith.__prev=prevKey;
if(nextSibling===null){
writableParent.__last=key;
}else{
var writableNextSibling=nextSibling.getWritable();
writableNextSibling.__prev=key;
}
writableReplaceWith.__next=nextKey;
writableReplaceWith.__parent=parentKey;
writableParent.__size=size;
if(includeChildren){
if(!($isElementNode(this)&&$isElementNode(writableReplaceWith))){
throw Error("includeChildren should only be true for ElementNodes");
}
this.getChildren().forEach(function(child){
writableReplaceWith.append(child);
});
}
if($isRangeSelection(selection)){
$setSelection(selection);
var anchor=selection.anchor;
var focus=selection.focus;
if(anchor.key===toReplaceKey){
$moveSelectionPointToEnd(anchor,writableReplaceWith);
}
if(focus.key===toReplaceKey){
$moveSelectionPointToEnd(focus,writableReplaceWith);
}
}
if($getCompositionKey()===toReplaceKey){
$setCompositionKey(key);
}
return writableReplaceWith;
};_proto.








insertAfter=function insertAfter(nodeToInsert,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
errorOnReadOnly();
errorOnInsertTextNodeOnRoot(this,nodeToInsert);
var writableSelf=this.getWritable();
var writableNodeToInsert=nodeToInsert.getWritable();
var oldParent=writableNodeToInsert.getParent();
var selection=$getSelection();
var elementAnchorSelectionOnNode=false;
var elementFocusSelectionOnNode=false;
if(oldParent!==null){

var oldIndex=nodeToInsert.getIndexWithinParent();
removeFromParent(writableNodeToInsert);
if($isRangeSelection(selection)){
var oldParentKey=oldParent.__key;
var anchor=selection.anchor;
var focus=selection.focus;
elementAnchorSelectionOnNode=anchor.type==='element'&&anchor.key===oldParentKey&&anchor.offset===oldIndex+1;
elementFocusSelectionOnNode=focus.type==='element'&&focus.key===oldParentKey&&focus.offset===oldIndex+1;
}
}
var nextSibling=this.getNextSibling();
var writableParent=this.getParentOrThrow().getWritable();
var insertKey=writableNodeToInsert.__key;
var nextKey=writableSelf.__next;
if(nextSibling===null){
writableParent.__last=insertKey;
}else{
var writableNextSibling=nextSibling.getWritable();
writableNextSibling.__prev=insertKey;
}
writableParent.__size++;
writableSelf.__next=insertKey;
writableNodeToInsert.__next=nextKey;
writableNodeToInsert.__prev=writableSelf.__key;
writableNodeToInsert.__parent=writableSelf.__parent;
if(restoreSelection&&$isRangeSelection(selection)){
var index=this.getIndexWithinParent();
$updateElementSelectionOnCreateDeleteNode(selection,writableParent,index+1);
var writableParentKey=writableParent.__key;
if(elementAnchorSelectionOnNode){
selection.anchor.set(writableParentKey,index+2,'element');
}
if(elementFocusSelectionOnNode){
selection.focus.set(writableParentKey,index+2,'element');
}
}
return nodeToInsert;
};_proto.








insertBefore=function insertBefore(nodeToInsert,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
errorOnReadOnly();
errorOnInsertTextNodeOnRoot(this,nodeToInsert);
var writableSelf=this.getWritable();
var writableNodeToInsert=nodeToInsert.getWritable();
var insertKey=writableNodeToInsert.__key;
removeFromParent(writableNodeToInsert);
var prevSibling=this.getPreviousSibling();
var writableParent=this.getParentOrThrow().getWritable();
var prevKey=writableSelf.__prev;

var index=this.getIndexWithinParent();
if(prevSibling===null){
writableParent.__first=insertKey;
}else{
var writablePrevSibling=prevSibling.getWritable();
writablePrevSibling.__next=insertKey;
}
writableParent.__size++;
writableSelf.__prev=insertKey;
writableNodeToInsert.__prev=prevKey;
writableNodeToInsert.__next=writableSelf.__key;
writableNodeToInsert.__parent=writableSelf.__parent;
var selection=$getSelection();
if(restoreSelection&&$isRangeSelection(selection)){
var parent=this.getParentOrThrow();
$updateElementSelectionOnCreateDeleteNode(selection,parent,index);
}
return nodeToInsert;
};_proto.







isParentRequired=function isParentRequired(){
return false;
};_proto.





createParentElementNode=function createParentElementNode(){
return $createParagraphNode();
};_proto.
selectStart=function selectStart(){
return this.selectPrevious();
};_proto.
selectEnd=function selectEnd(){
return this.selectNext(0,0);
};_proto.







selectPrevious=function selectPrevious(anchorOffset,focusOffset){
errorOnReadOnly();
var prevSibling=this.getPreviousSibling();
var parent=this.getParentOrThrow();
if(prevSibling===null){
return parent.select(0,0);
}
if($isElementNode(prevSibling)){
return prevSibling.select();
}else if(!$isTextNode(prevSibling)){
var index=prevSibling.getIndexWithinParent()+1;
return parent.select(index,index);
}
return prevSibling.select(anchorOffset,focusOffset);
};_proto.







selectNext=function selectNext(anchorOffset,focusOffset){
errorOnReadOnly();
var nextSibling=this.getNextSibling();
var parent=this.getParentOrThrow();
if(nextSibling===null){
return parent.select();
}
if($isElementNode(nextSibling)){
return nextSibling.select(0,0);
}else if(!$isTextNode(nextSibling)){
var index=nextSibling.getIndexWithinParent();
return parent.select(index,index);
}
return nextSibling.select(anchorOffset,focusOffset);
};_proto.






markDirty=function markDirty(){
this.getWritable();
};return LexicalNode;}();

function errorOnTypeKlassMismatch(type,klass){
var registeredNode=getActiveEditor()._nodes.get(type);

if(registeredNode===undefined){
{
throw Error("Create node: Attempted to create node "+klass.name+" that was not configured to be used on the editor.");
}
}
var editorKlass=registeredNode.klass;
if(editorKlass!==klass){
{
throw Error("Create node: Type "+type+" in node "+klass.name+" does not match registered node "+editorKlass.name+" with the same type");
}
}
}








function insertRangeAfter(node,firstToInsert,lastToInsert){
var lastToInsert2=lastToInsert||firstToInsert.getParentOrThrow().getLastChild();
var current=firstToInsert;
var nodesToInsert=[firstToInsert];
while(current!==lastToInsert2){
if(!current.getNextSibling()){
{
throw Error("insertRangeAfter: lastToInsert must be a later sibling of firstToInsert");
}
}
current=current.getNextSibling();
nodesToInsert.push(current);
}
var currentNode=node;
for(var _i8=0;_i8<nodesToInsert.length;_i8++){var nodeToInsert=nodesToInsert[_i8];
currentNode=currentNode.insertAfter(nodeToInsert);
}
}var









LineBreakNode=function(_LexicalNode){babelHelpers.inheritsLoose(LineBreakNode,_LexicalNode);LineBreakNode.
getType=function getType(){
return'linebreak';
};LineBreakNode.
clone=function clone(node){
return new LineBreakNode(node.__key);
};
function LineBreakNode(key){return(
_LexicalNode.call(this,key)||this);
}var _proto2=LineBreakNode.prototype;_proto2.
getTextContent=function getTextContent(){
return'\n';
};_proto2.
createDOM=function createDOM(){
return document.createElement('br');
};_proto2.
updateDOM=function updateDOM(){
return false;
};LineBreakNode.
importDOM=function importDOM(){
return{
br:function br(node){
if(isOnlyChild(node)){
return null;
}
return{
conversion:convertLineBreakElement,
priority:0};

}};

};LineBreakNode.
importJSON=function importJSON(serializedLineBreakNode){
return $createLineBreakNode();
};_proto2.
exportJSON=function exportJSON(){
return{
type:'linebreak',
version:1};

};return LineBreakNode;}(LexicalNode);

function convertLineBreakElement(node){
return{
node:$createLineBreakNode()};

}
function $createLineBreakNode(){
return $applyNodeReplacement(new LineBreakNode());
}
function $isLineBreakNode(node){
return node instanceof LineBreakNode;
}
function isOnlyChild(node){
var parentElement=node.parentElement;
if(parentElement!==null){
var firstChild=parentElement.firstChild;
if(firstChild===node||firstChild.nextSibling===node&&isWhitespaceDomTextNode(firstChild)){
var lastChild=parentElement.lastChild;
if(lastChild===node||lastChild.previousSibling===node&&isWhitespaceDomTextNode(lastChild)){
return true;
}
}
}
return false;
}
function isWhitespaceDomTextNode(node){
return node.nodeType===DOM_TEXT_TYPE&&/^( |\t|\r?\n)+$/.test(node.textContent||'');
}








function getElementOuterTag(node,format){
if(format&IS_CODE){
return'code';
}
if(format&IS_HIGHLIGHT){
return'mark';
}
if(format&IS_SUBSCRIPT){
return'sub';
}
if(format&IS_SUPERSCRIPT){
return'sup';
}
return null;
}
function getElementInnerTag(node,format){
if(format&IS_BOLD){
return'strong';
}
if(format&IS_ITALIC){
return'em';
}
return'span';
}
function setTextThemeClassNames(tag,prevFormat,nextFormat,dom,textClassNames){
var domClassList=dom.classList;

var classNames=getCachedClassNameArray(textClassNames,'base');
if(classNames!==undefined){
domClassList.add.apply(domClassList,classNames);
}





classNames=getCachedClassNameArray(textClassNames,'underlineStrikethrough');
var hasUnderlineStrikethrough=false;
var prevUnderlineStrikethrough=prevFormat&IS_UNDERLINE&&prevFormat&IS_STRIKETHROUGH;
var nextUnderlineStrikethrough=nextFormat&IS_UNDERLINE&&nextFormat&IS_STRIKETHROUGH;
if(classNames!==undefined){
if(nextUnderlineStrikethrough){
hasUnderlineStrikethrough=true;
if(!prevUnderlineStrikethrough){
domClassList.add.apply(domClassList,classNames);
}
}else if(prevUnderlineStrikethrough){
domClassList.remove.apply(domClassList,classNames);
}
}
for(var key in TEXT_TYPE_TO_FORMAT){
var format=key;
var flag=TEXT_TYPE_TO_FORMAT[format];
classNames=getCachedClassNameArray(textClassNames,key);
if(classNames!==undefined){
if(nextFormat&flag){
if(hasUnderlineStrikethrough&&(key==='underline'||key==='strikethrough')){
if(prevFormat&flag){
domClassList.remove.apply(domClassList,classNames);
}
continue;
}
if((prevFormat&flag)===0||prevUnderlineStrikethrough&&key==='underline'||key==='strikethrough'){
domClassList.add.apply(domClassList,classNames);
}
}else if(prevFormat&flag){
domClassList.remove.apply(domClassList,classNames);
}
}
}
}
function diffComposedText(a,b){
var aLength=a.length;
var bLength=b.length;
var left=0;
var right=0;
while(left<aLength&&left<bLength&&a[left]===b[left]){
left++;
}
while(right+left<aLength&&right+left<bLength&&a[aLength-right-1]===b[bLength-right-1]){
right++;
}
return[left,aLength-left-right,b.slice(left,bLength-right)];
}
function setTextContent(nextText,dom,node){
var firstChild=dom.firstChild;
var isComposing=node.isComposing();

var suffix=isComposing?COMPOSITION_SUFFIX:'';
var text=nextText+suffix;
if(firstChild==null){
dom.textContent=text;
}else{
var nodeValue=firstChild.nodeValue;
if(nodeValue!==text){
if(isComposing||IS_FIREFOX){var _diffComposedText=


diffComposedText(nodeValue,text),index=_diffComposedText[0],remove=_diffComposedText[1],insert=_diffComposedText[2];
if(remove!==0){

firstChild.deleteData(index,remove);
}

firstChild.insertData(index,insert);
}else{
firstChild.nodeValue=text;
}
}
}
}
function createTextInnerDOM(innerDOM,node,innerTag,format,text,config){
setTextContent(text,innerDOM,node);
var theme=config.theme;

var textClassNames=theme.text;
if(textClassNames!==undefined){
setTextThemeClassNames(innerTag,0,format,innerDOM,textClassNames);
}
}
function wrapElementWith(element,tag){
var el=document.createElement(tag);
el.appendChild(element);
return el;
}var


TextNode=function(_LexicalNode2){babelHelpers.inheritsLoose(TextNode,_LexicalNode2);TextNode.








getType=function getType(){
return'text';
};TextNode.
clone=function clone(node){
return new TextNode(node.__text,node.__key);
};
function TextNode(text,key){var _this;
_this=_LexicalNode2.call(this,key)||this;
_this.__text=text;
_this.__format=0;
_this.__style='';
_this.__mode=0;
_this.__detail=0;return _this;
}var _proto3=TextNode.prototype;_proto3.







getFormat=function getFormat(){
var self=this.getLatest();
return self.__format;
};_proto3.








getDetail=function getDetail(){
var self=this.getLatest();
return self.__detail;
};_proto3.






getMode=function getMode(){
var self=this.getLatest();
return TEXT_TYPE_TO_MODE[self.__mode];
};_proto3.






getStyle=function getStyle(){
var self=this.getLatest();
return self.__style;
};_proto3.







isToken=function isToken(){
var self=this.getLatest();
return self.__mode===IS_TOKEN;
};_proto3.






isComposing=function isComposing(){
return this.__key===$getCompositionKey();
};_proto3.







isSegmented=function isSegmented(){
var self=this.getLatest();
return self.__mode===IS_SEGMENTED;
};_proto3.





isDirectionless=function isDirectionless(){
var self=this.getLatest();
return(self.__detail&IS_DIRECTIONLESS)!==0;
};_proto3.






isUnmergeable=function isUnmergeable(){
var self=this.getLatest();
return(self.__detail&IS_UNMERGEABLE)!==0;
};_proto3.









hasFormat=function hasFormat(type){
var formatFlag=TEXT_TYPE_TO_FORMAT[type];
return(this.getFormat()&formatFlag)!==0;
};_proto3.







isSimpleText=function isSimpleText(){
return this.__type==='text'&&this.__mode===0;
};_proto3.






getTextContent=function getTextContent(){
var self=this.getLatest();
return self.__text;
};_proto3.






getFormatFlags=function getFormatFlags(type,alignWithFormat){
var self=this.getLatest();
var format=self.__format;
return toggleTextFormatType(format,type,alignWithFormat);
};_proto3.





canHaveFormat=function canHaveFormat(){
return true;
};_proto3.



createDOM=function createDOM(config,editor){
var format=this.__format;
var outerTag=getElementOuterTag(this,format);
var innerTag=getElementInnerTag(this,format);
var tag=outerTag===null?innerTag:outerTag;
var dom=document.createElement(tag);
var innerDOM=dom;
if(this.hasFormat('code')){
dom.setAttribute('spellcheck','false');
}
if(outerTag!==null){
innerDOM=document.createElement(innerTag);
dom.appendChild(innerDOM);
}
var text=this.__text;
createTextInnerDOM(innerDOM,this,innerTag,format,text,config);
var style=this.__style;
if(style!==''){
dom.style.cssText=style;
}
return dom;
};_proto3.
updateDOM=function updateDOM(prevNode,dom,config){
var nextText=this.__text;
var prevFormat=prevNode.__format;
var nextFormat=this.__format;
var prevOuterTag=getElementOuterTag(this,prevFormat);
var nextOuterTag=getElementOuterTag(this,nextFormat);
var prevInnerTag=getElementInnerTag(this,prevFormat);
var nextInnerTag=getElementInnerTag(this,nextFormat);
var prevTag=prevOuterTag===null?prevInnerTag:prevOuterTag;
var nextTag=nextOuterTag===null?nextInnerTag:nextOuterTag;
if(prevTag!==nextTag){
return true;
}
if(prevOuterTag===nextOuterTag&&prevInnerTag!==nextInnerTag){

var prevInnerDOM=dom.firstChild;
if(prevInnerDOM==null){
{
throw Error("updateDOM: prevInnerDOM is null or undefined");
}
}
var nextInnerDOM=document.createElement(nextInnerTag);
createTextInnerDOM(nextInnerDOM,this,nextInnerTag,nextFormat,nextText,config);
dom.replaceChild(nextInnerDOM,prevInnerDOM);
return false;
}
var innerDOM=dom;
if(nextOuterTag!==null){
if(prevOuterTag!==null){
innerDOM=dom.firstChild;
if(innerDOM==null){
{
throw Error("updateDOM: innerDOM is null or undefined");
}
}
}
}
setTextContent(nextText,innerDOM,this);
var theme=config.theme;

var textClassNames=theme.text;
if(textClassNames!==undefined&&prevFormat!==nextFormat){
setTextThemeClassNames(nextInnerTag,prevFormat,nextFormat,innerDOM,textClassNames);
}
var prevStyle=prevNode.__style;
var nextStyle=this.__style;
if(prevStyle!==nextStyle){
dom.style.cssText=nextStyle;
}
return false;
};TextNode.
importDOM=function importDOM(){
return{
'#text':function text(){return{
conversion:convertTextDOMNode,
priority:0};},

b:function b(){return{
conversion:convertBringAttentionToElement,
priority:0};},

code:function code(){return{
conversion:convertTextFormatElement,
priority:0};},

em:function em(){return{
conversion:convertTextFormatElement,
priority:0};},

i:function i(){return{
conversion:convertTextFormatElement,
priority:0};},

s:function s(){return{
conversion:convertTextFormatElement,
priority:0};},

span:function span(){return{
conversion:convertSpanElement,
priority:0};},

strong:function strong(){return{
conversion:convertTextFormatElement,
priority:0};},

sub:function sub(){return{
conversion:convertTextFormatElement,
priority:0};},

sup:function sup(){return{
conversion:convertTextFormatElement,
priority:0};},

u:function u(){return{
conversion:convertTextFormatElement,
priority:0};}};


};TextNode.
importJSON=function importJSON(serializedNode){
var node=$createTextNode(serializedNode.text);
node.setFormat(serializedNode.format);
node.setDetail(serializedNode.detail);
node.setMode(serializedNode.mode);
node.setStyle(serializedNode.style);
return node;
};_proto3.




exportDOM=function exportDOM(editor){var _LexicalNode2$prototy=_LexicalNode2.prototype.


exportDOM.call(this,editor),element=_LexicalNode2$prototy.element;
if(!(element!==null&&isHTMLElement(element))){
throw Error("Expected TextNode createDOM to always return a HTMLElement");
}
element.style.whiteSpace='pre-wrap';



if(this.hasFormat('bold')){
element=wrapElementWith(element,'b');
}
if(this.hasFormat('italic')){
element=wrapElementWith(element,'i');
}
if(this.hasFormat('strikethrough')){
element=wrapElementWith(element,'s');
}
if(this.hasFormat('underline')){
element=wrapElementWith(element,'u');
}
return{
element:element};

};_proto3.
exportJSON=function exportJSON(){
return{
detail:this.getDetail(),
format:this.getFormat(),
mode:this.getMode(),
style:this.getStyle(),
text:this.getTextContent(),
type:'text',
version:1};

};_proto3.


selectionTransform=function selectionTransform(prevSelection,nextSelection){
return;
};_proto3.











setFormat=function setFormat(format){
var self=this.getWritable();
self.__format=typeof format==='string'?TEXT_TYPE_TO_FORMAT[format]:format;
return self;
};_proto3.












setDetail=function setDetail(detail){
var self=this.getWritable();
self.__detail=typeof detail==='string'?DETAIL_TYPE_TO_DETAIL[detail]:detail;
return self;
};_proto3.









setStyle=function setStyle(style){
var self=this.getWritable();
self.__style=style;
return self;
};_proto3.










toggleFormat=function toggleFormat(type){
var format=this.getFormat();
var newFormat=toggleTextFormatType(format,type,null);
return this.setFormat(newFormat);
};_proto3.






toggleDirectionless=function toggleDirectionless(){
var self=this.getWritable();
self.__detail^=IS_DIRECTIONLESS;
return self;
};_proto3.






toggleUnmergeable=function toggleUnmergeable(){
var self=this.getWritable();
self.__detail^=IS_UNMERGEABLE;
return self;
};_proto3.






setMode=function setMode(type){
var mode=TEXT_MODE_TO_TYPE[type];
if(this.__mode===mode){
return this;
}
var self=this.getWritable();
self.__mode=mode;
return self;
};_proto3.








setTextContent=function setTextContent(text){
if(this.__text===text){
return this;
}
var self=this.getWritable();
self.__text=text;
return self;
};_proto3.









select=function select(_anchorOffset,_focusOffset){
errorOnReadOnly();
var anchorOffset=_anchorOffset;
var focusOffset=_focusOffset;
var selection=$getSelection();
var text=this.getTextContent();
var key=this.__key;
if(typeof text==='string'){
var lastOffset=text.length;
if(anchorOffset===undefined){
anchorOffset=lastOffset;
}
if(focusOffset===undefined){
focusOffset=lastOffset;
}
}else{
anchorOffset=0;
focusOffset=0;
}
if(!$isRangeSelection(selection)){
return internalMakeRangeSelection(key,anchorOffset,key,focusOffset,'text','text');
}else{
var compositionKey=$getCompositionKey();
if(compositionKey===selection.anchor.key||compositionKey===selection.focus.key){
$setCompositionKey(key);
}
selection.setTextNodeRange(this,anchorOffset,this,focusOffset);
}
return selection;
};_proto3.
selectStart=function selectStart(){
return this.select(0,0);
};_proto3.
selectEnd=function selectEnd(){
var size=this.getTextContentSize();
return this.select(size,size);
};_proto3.












spliceText=function spliceText(offset,delCount,newText,moveSelection){
var writableSelf=this.getWritable();
var text=writableSelf.__text;
var handledTextLength=newText.length;
var index=offset;
if(index<0){
index=handledTextLength+index;
if(index<0){
index=0;
}
}
var selection=$getSelection();
if(moveSelection&&$isRangeSelection(selection)){
var newOffset=offset+handledTextLength;
selection.setTextNodeRange(writableSelf,newOffset,writableSelf,newOffset);
}
var updatedText=text.slice(0,index)+newText+text.slice(index+delCount);
writableSelf.__text=updatedText;
return writableSelf;
};_proto3.








canInsertTextBefore=function canInsertTextBefore(){
return true;
};_proto3.








canInsertTextAfter=function canInsertTextAfter(){
return true;
};_proto3.









splitText=function splitText(){
errorOnReadOnly();
var self=this.getLatest();
var textContent=self.getTextContent();
var key=self.__key;
var compositionKey=$getCompositionKey();for(var _len=arguments.length,splitOffsets=new Array(_len),_key=0;_key<_len;_key++){splitOffsets[_key]=arguments[_key];}
var offsetsSet=new Set(splitOffsets);
var parts=[];
var textLength=textContent.length;
var string='';
for(var i=0;i<textLength;i++){
if(string!==''&&offsetsSet.has(i)){
parts.push(string);
string='';
}
string+=textContent[i];
}
if(string!==''){
parts.push(string);
}
var partsLength=parts.length;
if(partsLength===0){
return[];
}else if(parts[0]===textContent){
return[self];
}
var firstPart=parts[0];
var parent=self.getParentOrThrow();
var writableNode;
var format=self.getFormat();
var style=self.getStyle();
var detail=self.__detail;
var hasReplacedSelf=false;
if(self.isSegmented()){

writableNode=$createTextNode(firstPart);
writableNode.__format=format;
writableNode.__style=style;
writableNode.__detail=detail;
hasReplacedSelf=true;
}else{

writableNode=self.getWritable();
writableNode.__text=firstPart;
}


var selection=$getSelection();


var splitNodes=[writableNode];
var textSize=firstPart.length;
for(var _i9=1;_i9<partsLength;_i9++){
var part=parts[_i9];
var partSize=part.length;
var sibling=$createTextNode(part).getWritable();
sibling.__format=format;
sibling.__style=style;
sibling.__detail=detail;
var siblingKey=sibling.__key;
var nextTextSize=textSize+partSize;
if($isRangeSelection(selection)){
var anchor=selection.anchor;
var focus=selection.focus;
if(anchor.key===key&&anchor.type==='text'&&anchor.offset>textSize&&anchor.offset<=nextTextSize){
anchor.key=siblingKey;
anchor.offset-=textSize;
selection.dirty=true;
}
if(focus.key===key&&focus.type==='text'&&focus.offset>textSize&&focus.offset<=nextTextSize){
focus.key=siblingKey;
focus.offset-=textSize;
selection.dirty=true;
}
}
if(compositionKey===key){
$setCompositionKey(siblingKey);
}
textSize=nextTextSize;
splitNodes.push(sibling);
}


internalMarkSiblingsAsDirty(this);
var writableParent=parent.getWritable();
var insertionIndex=this.getIndexWithinParent();
if(hasReplacedSelf){
writableParent.splice(insertionIndex,0,splitNodes);
this.remove();
}else{
writableParent.splice(insertionIndex,1,splitNodes);
}
if($isRangeSelection(selection)){
$updateElementSelectionOnCreateDeleteNode(selection,parent,insertionIndex,partsLength-1);
}
return splitNodes;
};_proto3.








mergeWithSibling=function mergeWithSibling(target){
var isBefore=target===this.getPreviousSibling();
if(!isBefore&&target!==this.getNextSibling()){
{
throw Error("mergeWithSibling: sibling must be a previous or next sibling");
}
}
var key=this.__key;
var targetKey=target.__key;
var text=this.__text;
var textLength=text.length;
var compositionKey=$getCompositionKey();
if(compositionKey===targetKey){
$setCompositionKey(key);
}
var selection=$getSelection();
if($isRangeSelection(selection)){
var anchor=selection.anchor;
var focus=selection.focus;
if(anchor!==null&&anchor.key===targetKey){
adjustPointOffsetForMergedSibling(anchor,isBefore,key,target,textLength);
selection.dirty=true;
}
if(focus!==null&&focus.key===targetKey){
adjustPointOffsetForMergedSibling(focus,isBefore,key,target,textLength);
selection.dirty=true;
}
}
var targetText=target.__text;
var newText=isBefore?targetText+text:text+targetText;
this.setTextContent(newText);
var writableSelf=this.getWritable();
target.remove();
return writableSelf;
};_proto3.








isTextEntity=function isTextEntity(){
return false;
};return TextNode;}(LexicalNode);

function convertSpanElement(domNode){

var span=domNode;

var hasBoldFontWeight=span.style.fontWeight==='700';

var hasLinethroughTextDecoration=span.style.textDecoration==='line-through';

var hasItalicFontStyle=span.style.fontStyle==='italic';

var hasUnderlineTextDecoration=span.style.textDecoration==='underline';

var verticalAlign=span.style.verticalAlign;
return{
forChild:function forChild(lexicalNode){
if(!$isTextNode(lexicalNode)){
return lexicalNode;
}
if(hasBoldFontWeight){
lexicalNode.toggleFormat('bold');
}
if(hasLinethroughTextDecoration){
lexicalNode.toggleFormat('strikethrough');
}
if(hasItalicFontStyle){
lexicalNode.toggleFormat('italic');
}
if(hasUnderlineTextDecoration){
lexicalNode.toggleFormat('underline');
}
if(verticalAlign==='sub'){
lexicalNode.toggleFormat('subscript');
}
if(verticalAlign==='super'){
lexicalNode.toggleFormat('superscript');
}
return lexicalNode;
},
node:null};

}
function convertBringAttentionToElement(domNode){

var b=domNode;

var hasNormalFontWeight=b.style.fontWeight==='normal';
return{
forChild:function forChild(lexicalNode){
if($isTextNode(lexicalNode)&&!hasNormalFontWeight){
lexicalNode.toggleFormat('bold');
}
return lexicalNode;
},
node:null};

}
var preParentCache=new WeakMap();
function isNodePre(node){
return node.nodeName==='PRE'||node.nodeType===DOM_ELEMENT_TYPE&&node.style!==undefined&&node.style.whiteSpace!==undefined&&node.style.whiteSpace.startsWith('pre');
}
function findParentPreDOMNode(node){
var cached;
var parent=node.parentNode;
var visited=[node];
while(parent!==null&&(cached=preParentCache.get(parent))===undefined&&!isNodePre(parent)){
visited.push(parent);
parent=parent.parentNode;
}
var resultNode=cached===undefined?parent:cached;
for(var i=0;i<visited.length;i++){
preParentCache.set(visited[i],resultNode);
}
return resultNode;
}
function convertTextDOMNode(domNode){
var domNode_=domNode;
var parentDom=domNode.parentElement;
if(!(parentDom!==null)){
throw Error("Expected parentElement of Text not to be null");
}
var textContent=domNode_.textContent||'';

if(findParentPreDOMNode(domNode_)!==null){
var parts=textContent.split(/(\r?\n|\t)/);
var nodes=[];
var length=parts.length;
for(var i=0;i<length;i++){
var part=parts[i];
if(part==='\n'||part==='\r\n'){
nodes.push($createLineBreakNode());
}else if(part==='\t'){
nodes.push($createTabNode());
}else if(part!==''){
nodes.push($createTextNode(part));
}
}
return{
node:nodes};

}
textContent=textContent.replace(/\r/g,'').replace(/[ \t\n]+/g,' ');
if(textContent===''){
return{
node:null};

}
if(textContent[0]===' '){



var previousText=domNode_;
var isStartOfLine=true;
while(previousText!==null&&(previousText=findTextInLine(previousText,false))!==null){
var previousTextContent=previousText.textContent||'';
if(previousTextContent.length>0){
if(/[ \t\n]$/.test(previousTextContent)){
textContent=textContent.slice(1);
}
isStartOfLine=false;
break;
}
}
if(isStartOfLine){
textContent=textContent.slice(1);
}
}
if(textContent[textContent.length-1]===' '){

var nextText=domNode_;
var isEndOfLine=true;
while(nextText!==null&&(nextText=findTextInLine(nextText,true))!==null){
var nextTextContent=(nextText.textContent||'').replace(/^( |\t|\r?\n)+/,'');
if(nextTextContent.length>0){
isEndOfLine=false;
break;
}
}
if(isEndOfLine){
textContent=textContent.slice(0,textContent.length-1);
}
}
if(textContent===''){
return{
node:null};

}
return{
node:$createTextNode(textContent)};

}
var inlineParents=new RegExp(/^(a|abbr|acronym|b|cite|code|del|em|i|ins|kbd|label|output|q|ruby|s|samp|span|strong|sub|sup|time|u|tt|var)$/,'i');
function findTextInLine(text,forward){
var node=text;

while(true){
var sibling=void 0;
while((sibling=forward?node.nextSibling:node.previousSibling)===null){
var parentElement=node.parentElement;
if(parentElement===null){
return null;
}
node=parentElement;
}
node=sibling;
if(node.nodeType===DOM_ELEMENT_TYPE){
var display=node.style.display;
if(display===''&&node.nodeName.match(inlineParents)===null||display!==''&&!display.startsWith('inline')){
return null;
}
}
var descendant=node;
while((descendant=forward?node.firstChild:node.lastChild)!==null){
node=descendant;
}
if(node.nodeType===DOM_TEXT_TYPE){
return node;
}else if(node.nodeName==='BR'){
return null;
}
}
}
var nodeNameToTextFormat={
code:'code',
em:'italic',
i:'italic',
s:'strikethrough',
strong:'bold',
sub:'subscript',
sup:'superscript',
u:'underline'};

function convertTextFormatElement(domNode){
var format=nodeNameToTextFormat[domNode.nodeName.toLowerCase()];
if(format===undefined){
return{
node:null};

}
return{
forChild:function forChild(lexicalNode){
if($isTextNode(lexicalNode)&&!lexicalNode.hasFormat(format)){
lexicalNode.toggleFormat(format);
}
return lexicalNode;
},
node:null};

}
function $createTextNode(text){if(text===void 0){text='';}
return $applyNodeReplacement(new TextNode(text));
}
function $isTextNode(node){
return node instanceof TextNode;
}var









TabNode=function(_TextNode){babelHelpers.inheritsLoose(TabNode,_TextNode);TabNode.
getType=function getType(){
return'tab';
};TabNode.
clone=function clone(node){
var newNode=new TabNode(node.__key);

newNode.__text=node.__text;
newNode.__format=node.__format;
newNode.__style=node.__style;
return newNode;
};
function TabNode(key){var _this2;
_this2=_TextNode.call(this,'\t',key)||this;
_this2.__detail=IS_UNMERGEABLE;return _this2;
}TabNode.
importDOM=function importDOM(){
return null;
};TabNode.
importJSON=function importJSON(serializedTabNode){
var node=$createTabNode();
node.setFormat(serializedTabNode.format);
node.setStyle(serializedTabNode.style);
return node;
};var _proto4=TabNode.prototype;_proto4.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_TextNode.prototype.
exportJSON.call(this),{
type:'tab',
version:1});

};_proto4.
setTextContent=function setTextContent(_text){
{
throw Error("TabNode does not support setTextContent");
}
};_proto4.
setDetail=function setDetail(_detail){
{
throw Error("TabNode does not support setDetail");
}
};_proto4.
setMode=function setMode(_type){
{
throw Error("TabNode does not support setMode");
}
};_proto4.
canInsertTextBefore=function canInsertTextBefore(){
return false;
};_proto4.
canInsertTextAfter=function canInsertTextAfter(){
return false;
};return TabNode;}(TextNode);

function $createTabNode(){
return $applyNodeReplacement(new TabNode());
}
function $isTabNode(node){
return node instanceof TabNode;
}var








Point=function(){
function Point(key,offset,type){
this._selection=null;
this.key=key;
this.offset=offset;
this.type=type;
}var _proto5=Point.prototype;_proto5.
is=function is(point){
return this.key===point.key&&this.offset===point.offset&&this.type===point.type;
};_proto5.
isBefore=function isBefore(b){
var aNode=this.getNode();
var bNode=b.getNode();
var aOffset=this.offset;
var bOffset=b.offset;
if($isElementNode(aNode)){
var aNodeDescendant=aNode.getDescendantByIndex(aOffset);
aNode=aNodeDescendant!=null?aNodeDescendant:aNode;
}
if($isElementNode(bNode)){
var bNodeDescendant=bNode.getDescendantByIndex(bOffset);
bNode=bNodeDescendant!=null?bNodeDescendant:bNode;
}
if(aNode===bNode){
return aOffset<bOffset;
}
return aNode.isBefore(bNode);
};_proto5.
getNode=function getNode(){
var key=this.key;
var node=$getNodeByKey(key);
if(node===null){
{
throw Error("Point.getNode: node not found");
}
}
return node;
};_proto5.
set=function set(key,offset,type){
var selection=this._selection;
var oldKey=this.key;
this.key=key;
this.offset=offset;
this.type=type;
if(!isCurrentlyReadOnlyMode()){
if($getCompositionKey()===oldKey){
$setCompositionKey(key);
}
if(selection!==null){
selection.setCachedNodes(null);
selection.dirty=true;
}
}
};return Point;}();

function $createPoint(key,offset,type){

return new Point(key,offset,type);
}
function selectPointOnNode(point,node){
var key=node.__key;
var offset=point.offset;
var type='element';
if($isTextNode(node)){
type='text';
var textContentLength=node.getTextContentSize();
if(offset>textContentLength){
offset=textContentLength;
}
}else if(!$isElementNode(node)){
var nextSibling=node.getNextSibling();
if($isTextNode(nextSibling)){
key=nextSibling.__key;
offset=0;
type='text';
}else{
var parentNode=node.getParent();
if(parentNode){
key=parentNode.__key;
offset=node.getIndexWithinParent()+1;
}
}
}
point.set(key,offset,type);
}
function $moveSelectionPointToEnd(point,node){
if($isElementNode(node)){
var lastNode=node.getLastDescendant();
if($isElementNode(lastNode)||$isTextNode(lastNode)){
selectPointOnNode(point,lastNode);
}else{
selectPointOnNode(point,node);
}
}else{
selectPointOnNode(point,node);
}
}
function $transferStartingElementPointToTextPoint(start,end,format,style){
var element=start.getNode();
var placementNode=element.getChildAtIndex(start.offset);
var textNode=$createTextNode();
var target=$isRootNode(element)?$createParagraphNode().append(textNode):textNode;
textNode.setFormat(format);
textNode.setStyle(style);
if(placementNode===null){
element.append(target);
}else{
placementNode.insertBefore(target);
}

if(start.is(end)){
end.set(textNode.__key,0,'text');
}
start.set(textNode.__key,0,'text');
}
function $setPointValues(point,key,offset,type){
point.key=key;
point.offset=offset;
point.type=type;
}var
NodeSelection=function(){
function NodeSelection(objects){
this._cachedNodes=null;
this._nodes=objects;
this.dirty=false;
}var _proto6=NodeSelection.prototype;_proto6.
getCachedNodes=function getCachedNodes(){
return this._cachedNodes;
};_proto6.
setCachedNodes=function setCachedNodes(nodes){
this._cachedNodes=nodes;
};_proto6.
is=function is(selection){
if(!$isNodeSelection(selection)){
return false;
}
var a=this._nodes;
var b=selection._nodes;
return a.size===b.size&&Array.from(a).every(function(key){return b.has(key);});
};_proto6.
isCollapsed=function isCollapsed(){
return false;
};_proto6.
isBackward=function isBackward(){
return false;
};_proto6.
getStartEndPoints=function getStartEndPoints(){
return null;
};_proto6.
add=function add(key){
this.dirty=true;
this._nodes.add(key);
this._cachedNodes=null;
};_proto6["delete"]=
function _delete(key){
this.dirty=true;
this._nodes["delete"](key);
this._cachedNodes=null;
};_proto6.
clear=function clear(){
this.dirty=true;
this._nodes.clear();
this._cachedNodes=null;
};_proto6.
has=function has(key){
return this._nodes.has(key);
};_proto6.
clone=function clone(){
return new NodeSelection(new Set(this._nodes));
};_proto6.
extract=function extract(){
return this.getNodes();
};_proto6.
insertRawText=function insertRawText(text){

};_proto6.
insertText=function insertText(){

};_proto6.
insertNodes=function insertNodes(nodes){
var selectedNodes=this.getNodes();
var selectedNodesLength=selectedNodes.length;
var lastSelectedNode=selectedNodes[selectedNodesLength-1];
var selectionAtEnd;

if($isTextNode(lastSelectedNode)){
selectionAtEnd=lastSelectedNode.select();
}else{
var index=lastSelectedNode.getIndexWithinParent()+1;
selectionAtEnd=lastSelectedNode.getParentOrThrow().select(index,index);
}
selectionAtEnd.insertNodes(nodes);

for(var i=0;i<selectedNodesLength;i++){
selectedNodes[i].remove();
}
};_proto6.
getNodes=function getNodes(){
var cachedNodes=this._cachedNodes;
if(cachedNodes!==null){
return cachedNodes;
}
var objects=this._nodes;
var nodes=[];
for(var _iterator6=objects,_isArray6=Array.isArray(_iterator6),_i10=0,_iterator6=_isArray6?_iterator6:_iterator6[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref14;if(_isArray6){if(_i10>=_iterator6.length)break;_ref14=_iterator6[_i10++];}else{_i10=_iterator6.next();if(_i10.done)break;_ref14=_i10.value;}var object=_ref14;
var node=$getNodeByKey(object);
if(node!==null){
nodes.push(node);
}
}
if(!isCurrentlyReadOnlyMode()){
this._cachedNodes=nodes;
}
return nodes;
};_proto6.
getTextContent=function getTextContent(){
var nodes=this.getNodes();
var textContent='';
for(var i=0;i<nodes.length;i++){
textContent+=nodes[i].getTextContent();
}
return textContent;
};return NodeSelection;}();

function $isRangeSelection(x){
return x instanceof RangeSelection;
}var
RangeSelection=function(){
function RangeSelection(anchor,focus,format,style){
this.anchor=anchor;
this.focus=focus;
anchor._selection=this;
focus._selection=this;
this._cachedNodes=null;
this.format=format;
this.style=style;
this.dirty=false;
}var _proto7=RangeSelection.prototype;_proto7.
getCachedNodes=function getCachedNodes(){
return this._cachedNodes;
};_proto7.
setCachedNodes=function setCachedNodes(nodes){
this._cachedNodes=nodes;
};_proto7.







is=function is(selection){
if(!$isRangeSelection(selection)){
return false;
}
return this.anchor.is(selection.anchor)&&this.focus.is(selection.focus)&&this.format===selection.format&&this.style===selection.style;
};_proto7.







isCollapsed=function isCollapsed(){
return this.anchor.is(this.focus);
};_proto7.







getNodes=function getNodes(){
var cachedNodes=this._cachedNodes;
if(cachedNodes!==null){
return cachedNodes;
}
var anchor=this.anchor;
var focus=this.focus;
var isBefore=anchor.isBefore(focus);
var firstPoint=isBefore?anchor:focus;
var lastPoint=isBefore?focus:anchor;
var firstNode=firstPoint.getNode();
var lastNode=lastPoint.getNode();
var startOffset=firstPoint.offset;
var endOffset=lastPoint.offset;
if($isElementNode(firstNode)){
var firstNodeDescendant=firstNode.getDescendantByIndex(startOffset);
firstNode=firstNodeDescendant!=null?firstNodeDescendant:firstNode;
}
if($isElementNode(lastNode)){
var lastNodeDescendant=lastNode.getDescendantByIndex(endOffset);


if(lastNodeDescendant!==null&&lastNodeDescendant!==firstNode&&lastNode.getChildAtIndex(endOffset)===lastNodeDescendant){
lastNodeDescendant=lastNodeDescendant.getPreviousSibling();
}
lastNode=lastNodeDescendant!=null?lastNodeDescendant:lastNode;
}
var nodes;
if(firstNode.is(lastNode)){
if($isElementNode(firstNode)&&firstNode.getChildrenSize()>0){
nodes=[];
}else{
nodes=[firstNode];
}
}else{
nodes=firstNode.getNodesBetween(lastNode);
}
if(!isCurrentlyReadOnlyMode()){
this._cachedNodes=nodes;
}
return nodes;
};_proto7.









setTextNodeRange=function setTextNodeRange(anchorNode,anchorOffset,focusNode,focusOffset){
$setPointValues(this.anchor,anchorNode.__key,anchorOffset,'text');
$setPointValues(this.focus,focusNode.__key,focusOffset,'text');
this._cachedNodes=null;
this.dirty=true;
};_proto7.






getTextContent=function getTextContent(){
var nodes=this.getNodes();
if(nodes.length===0){
return'';
}
var firstNode=nodes[0];
var lastNode=nodes[nodes.length-1];
var anchor=this.anchor;
var focus=this.focus;
var isBefore=anchor.isBefore(focus);var _$getCharacterOffsets=
$getCharacterOffsets(this),anchorOffset=_$getCharacterOffsets[0],focusOffset=_$getCharacterOffsets[1];
var textContent='';
var prevWasElement=true;
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if($isElementNode(node)&&!node.isInline()){
if(!prevWasElement){
textContent+='\n';
}
if(node.isEmpty()){
prevWasElement=false;
}else{
prevWasElement=true;
}
}else{
prevWasElement=false;
if($isTextNode(node)){
var text=node.getTextContent();
if(node===firstNode){
if(node===lastNode){
if(anchor.type!=='element'||focus.type!=='element'||focus.offset===anchor.offset){
text=anchorOffset<focusOffset?text.slice(anchorOffset,focusOffset):text.slice(focusOffset,anchorOffset);
}
}else{
text=isBefore?text.slice(anchorOffset):text.slice(focusOffset);
}
}else if(node===lastNode){
text=isBefore?text.slice(0,focusOffset):text.slice(0,anchorOffset);
}
textContent+=text;
}else if(($isDecoratorNode(node)||$isLineBreakNode(node))&&(node!==lastNode||!this.isCollapsed())){
textContent+=node.getTextContent();
}
}
}
return textContent;
};_proto7.







applyDOMRange=function applyDOMRange(range){
var editor=getActiveEditor();
var currentEditorState=editor.getEditorState();
var lastSelection=currentEditorState._selection;
var resolvedSelectionPoints=internalResolveSelectionPoints(range.startContainer,range.startOffset,range.endContainer,range.endOffset,editor,lastSelection);
if(resolvedSelectionPoints===null){
return;
}var
anchorPoint=resolvedSelectionPoints[0],focusPoint=resolvedSelectionPoints[1];
$setPointValues(this.anchor,anchorPoint.key,anchorPoint.offset,anchorPoint.type);
$setPointValues(this.focus,focusPoint.key,focusPoint.offset,focusPoint.type);
this._cachedNodes=null;
};_proto7.






clone=function clone(){
var anchor=this.anchor;
var focus=this.focus;
var selection=new RangeSelection($createPoint(anchor.key,anchor.offset,anchor.type),$createPoint(focus.key,focus.offset,focus.type),this.format,this.style);
return selection;
};_proto7.






toggleFormat=function toggleFormat(format){
this.format=toggleTextFormatType(this.format,format,null);
this.dirty=true;
};_proto7.






setStyle=function setStyle(style){
this.style=style;
this.dirty=true;
};_proto7.








hasFormat=function hasFormat(type){
var formatFlag=TEXT_TYPE_TO_FORMAT[type];
return(this.format&formatFlag)!==0;
};_proto7.







insertRawText=function insertRawText(text){
var parts=text.split(/(\r?\n|\t)/);
var nodes=[];
var length=parts.length;
for(var i=0;i<length;i++){
var part=parts[i];
if(part==='\n'||part==='\r\n'){
nodes.push($createLineBreakNode());
}else if(part==='\t'){
nodes.push($createTabNode());
}else{
nodes.push($createTextNode(part));
}
}
this.insertNodes(nodes);
};_proto7.







insertText=function insertText(text){
var anchor=this.anchor;
var focus=this.focus;
var isBefore=this.isCollapsed()||anchor.isBefore(focus);
var format=this.format;
var style=this.style;
if(isBefore&&anchor.type==='element'){
$transferStartingElementPointToTextPoint(anchor,focus,format,style);
}else if(!isBefore&&focus.type==='element'){
$transferStartingElementPointToTextPoint(focus,anchor,format,style);
}
var selectedNodes=this.getNodes();
var selectedNodesLength=selectedNodes.length;
var firstPoint=isBefore?anchor:focus;
var endPoint=isBefore?focus:anchor;
var startOffset=firstPoint.offset;
var endOffset=endPoint.offset;
var firstNode=selectedNodes[0];
if(!$isTextNode(firstNode)){
{
throw Error("insertText: first node is not a text node");
}
}
var firstNodeText=firstNode.getTextContent();
var firstNodeTextLength=firstNodeText.length;
var firstNodeParent=firstNode.getParentOrThrow();
var lastIndex=selectedNodesLength-1;
var lastNode=selectedNodes[lastIndex];
if(this.isCollapsed()&&startOffset===firstNodeTextLength&&(firstNode.isSegmented()||firstNode.isToken()||!firstNode.canInsertTextAfter()||!firstNodeParent.canInsertTextAfter()&&firstNode.getNextSibling()===null)){
var nextSibling=firstNode.getNextSibling();
if(!$isTextNode(nextSibling)||!nextSibling.canInsertTextBefore()||$isTokenOrSegmented(nextSibling)){
nextSibling=$createTextNode();
nextSibling.setFormat(format);
if(!firstNodeParent.canInsertTextAfter()){
firstNodeParent.insertAfter(nextSibling);
}else{
firstNode.insertAfter(nextSibling);
}
}
nextSibling.select(0,0);
firstNode=nextSibling;
if(text!==''){
this.insertText(text);
return;
}
}else if(this.isCollapsed()&&startOffset===0&&(firstNode.isSegmented()||firstNode.isToken()||!firstNode.canInsertTextBefore()||!firstNodeParent.canInsertTextBefore()&&firstNode.getPreviousSibling()===null)){
var prevSibling=firstNode.getPreviousSibling();
if(!$isTextNode(prevSibling)||$isTokenOrSegmented(prevSibling)){
prevSibling=$createTextNode();
prevSibling.setFormat(format);
if(!firstNodeParent.canInsertTextBefore()){
firstNodeParent.insertBefore(prevSibling);
}else{
firstNode.insertBefore(prevSibling);
}
}
prevSibling.select();
firstNode=prevSibling;
if(text!==''){
this.insertText(text);
return;
}
}else if(firstNode.isSegmented()&&startOffset!==firstNodeTextLength){
var textNode=$createTextNode(firstNode.getTextContent());
textNode.setFormat(format);
firstNode.replace(textNode);
firstNode=textNode;
}else if(!this.isCollapsed()&&text!==''){




var lastNodeParent=lastNode.getParent();
if(!firstNodeParent.canInsertTextBefore()||!firstNodeParent.canInsertTextAfter()||$isElementNode(lastNodeParent)&&(!lastNodeParent.canInsertTextBefore()||!lastNodeParent.canInsertTextAfter())){
this.insertText('');
normalizeSelectionPointsForBoundaries(this.anchor,this.focus,null);
this.insertText(text);
return;
}
}
if(selectedNodesLength===1){
if(firstNode.isToken()){
var _textNode=$createTextNode(text);
_textNode.select();
firstNode.replace(_textNode);
return;
}
var firstNodeFormat=firstNode.getFormat();
var firstNodeStyle=firstNode.getStyle();
if(startOffset===endOffset&&(firstNodeFormat!==format||firstNodeStyle!==style)){
if(firstNode.getTextContent()===''){
firstNode.setFormat(format);
firstNode.setStyle(style);
}else{
var _textNode2=$createTextNode(text);
_textNode2.setFormat(format);
_textNode2.setStyle(style);
_textNode2.select();
if(startOffset===0){
firstNode.insertBefore(_textNode2,false);
}else{var _firstNode$splitText=
firstNode.splitText(startOffset),targetNode=_firstNode$splitText[0];
targetNode.insertAfter(_textNode2,false);
}


if(_textNode2.isComposing()&&this.anchor.type==='text'){
this.anchor.offset-=text.length;
}
return;
}
}else if($isTabNode(firstNode)){


var _textNode3=$createTextNode(text);
_textNode3.setFormat(format);
_textNode3.setStyle(style);
_textNode3.select();
firstNode.replace(_textNode3);
return;
}
var delCount=endOffset-startOffset;
firstNode=firstNode.spliceText(startOffset,delCount,text,true);
if(firstNode.getTextContent()===''){
firstNode.remove();
}else if(this.anchor.type==='text'){
if(firstNode.isComposing()){


this.anchor.offset-=text.length;
}else{
this.format=firstNodeFormat;
this.style=firstNodeStyle;
}
}
}else{
var markedNodeKeysForKeep=new Set([].concat(firstNode.getParentKeys(),lastNode.getParentKeys()));



var firstElement=$isElementNode(firstNode)?firstNode:firstNode.getParentOrThrow();
var lastElement=$isElementNode(lastNode)?lastNode:lastNode.getParentOrThrow();
var lastElementChild=lastNode;





if(!firstElement.is(lastElement)&&lastElement.isInline()){

do{
lastElementChild=lastElement;
lastElement=lastElement.getParentOrThrow();
}while(lastElement.isInline());
}


if(endPoint.type==='text'&&(endOffset!==0||lastNode.getTextContent()==='')||endPoint.type==='element'&&lastNode.getIndexWithinParent()<endOffset){
if($isTextNode(lastNode)&&!lastNode.isToken()&&endOffset!==lastNode.getTextContentSize()){
if(lastNode.isSegmented()){
var _textNode4=$createTextNode(lastNode.getTextContent());
lastNode.replace(_textNode4);
lastNode=_textNode4;
}

if(!$isRootNode(endPoint.getNode())&&endPoint.type==='text'){
lastNode=lastNode.spliceText(0,endOffset,'');
}
markedNodeKeysForKeep.add(lastNode.__key);
}else{
var _lastNodeParent=lastNode.getParentOrThrow();
if(!_lastNodeParent.canBeEmpty()&&_lastNodeParent.getChildrenSize()===1){
_lastNodeParent.remove();
}else{
lastNode.remove();
}
}
}else{
markedNodeKeysForKeep.add(lastNode.__key);
}




var lastNodeChildren=lastElement.getChildren();
var selectedNodesSet=new Set(selectedNodes);
var firstAndLastElementsAreEqual=firstElement.is(lastElement);







var insertionTarget=firstElement.isInline()&&firstNode.getNextSibling()===null?firstElement:firstNode;
for(var i=lastNodeChildren.length-1;i>=0;i--){
var lastNodeChild=lastNodeChildren[i];
if(lastNodeChild.is(firstNode)||$isElementNode(lastNodeChild)&&lastNodeChild.isParentOf(firstNode)){
break;
}
if(lastNodeChild.isAttached()){
if(!selectedNodesSet.has(lastNodeChild)||lastNodeChild.is(lastElementChild)){
if(!firstAndLastElementsAreEqual){
insertionTarget.insertAfter(lastNodeChild,false);
}
}else{
lastNodeChild.remove();
}
}
}
if(!firstAndLastElementsAreEqual){



var parent=lastElement;
var lastRemovedParent=null;
while(parent!==null){
var children=parent.getChildren();
var childrenLength=children.length;
if(childrenLength===0||children[childrenLength-1].is(lastRemovedParent)){
markedNodeKeysForKeep["delete"](parent.__key);
lastRemovedParent=parent;
}
parent=parent.getParent();
}
}



if(!firstNode.isToken()){
firstNode=firstNode.spliceText(startOffset,firstNodeTextLength-startOffset,text,true);
if(firstNode.getTextContent()===''){
firstNode.remove();
}else if(firstNode.isComposing()&&this.anchor.type==='text'){


this.anchor.offset-=text.length;
}
}else if(startOffset===firstNodeTextLength){
firstNode.select();
}else{
var _textNode5=$createTextNode(text);
_textNode5.select();
firstNode.replace(_textNode5);
}


for(var _i11=1;_i11<selectedNodesLength;_i11++){
var selectedNode=selectedNodes[_i11];
var key=selectedNode.__key;
if(!markedNodeKeysForKeep.has(key)){
selectedNode.remove();
}
}
}
};_proto7.




removeText=function removeText(){
this.insertText('');
};_proto7.







formatText=function formatText(formatType){
if(this.isCollapsed()){
this.toggleFormat(formatType);

$setCompositionKey(null);
return;
}
var selectedNodes=this.getNodes();
var selectedTextNodes=[];
for(var _iterator7=selectedNodes,_isArray7=Array.isArray(_iterator7),_i12=0,_iterator7=_isArray7?_iterator7:_iterator7[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref15;if(_isArray7){if(_i12>=_iterator7.length)break;_ref15=_iterator7[_i12++];}else{_i12=_iterator7.next();if(_i12.done)break;_ref15=_i12.value;}var selectedNode=_ref15;
if($isTextNode(selectedNode)){
selectedTextNodes.push(selectedNode);
}
}
var selectedTextNodesLength=selectedTextNodes.length;
if(selectedTextNodesLength===0){
this.toggleFormat(formatType);

$setCompositionKey(null);
return;
}
var anchor=this.anchor;
var focus=this.focus;
var isBackward=this.isBackward();
var startPoint=isBackward?focus:anchor;
var endPoint=isBackward?anchor:focus;
var firstIndex=0;
var firstNode=selectedTextNodes[0];
var startOffset=startPoint.type==='element'?0:startPoint.offset;


if(startPoint.type==='text'&&startOffset===firstNode.getTextContentSize()){
firstIndex=1;
firstNode=selectedTextNodes[1];
startOffset=0;
}
if(firstNode==null){
return;
}
var firstNextFormat=firstNode.getFormatFlags(formatType,null);
var lastIndex=selectedTextNodesLength-1;
var lastNode=selectedTextNodes[lastIndex];
var endOffset=endPoint.type==='text'?endPoint.offset:lastNode.getTextContentSize();


if(firstNode.is(lastNode)){

if(startOffset===endOffset){
return;
}

if(startOffset===0&&endOffset===firstNode.getTextContentSize()){
firstNode.setFormat(firstNextFormat);
}else{


var splitNodes=firstNode.splitText(startOffset,endOffset);
var replacement=startOffset===0?splitNodes[0]:splitNodes[1];
replacement.setFormat(firstNextFormat);


if(startPoint.type==='text'){
startPoint.set(replacement.__key,0,'text');
}
if(endPoint.type==='text'){
endPoint.set(replacement.__key,endOffset-startOffset,'text');
}
}
this.format=firstNextFormat;
return;
}


if(startOffset!==0){var _firstNode$splitText2=
firstNode.splitText(startOffset);firstNode=_firstNode$splitText2[1];
startOffset=0;
}
firstNode.setFormat(firstNextFormat);
var lastNextFormat=lastNode.getFormatFlags(formatType,firstNextFormat);


if(endOffset>0){
if(endOffset!==lastNode.getTextContentSize()){var _lastNode$splitText=
lastNode.splitText(endOffset);lastNode=_lastNode$splitText[0];
}
lastNode.setFormat(lastNextFormat);
}


for(var i=firstIndex+1;i<lastIndex;i++){
var textNode=selectedTextNodes[i];
if(!textNode.isToken()){
var nextFormat=textNode.getFormatFlags(formatType,lastNextFormat);
textNode.setFormat(nextFormat);
}
}


if(startPoint.type==='text'){
startPoint.set(firstNode.__key,startOffset,'text');
}
if(endPoint.type==='text'){
endPoint.set(lastNode.__key,endOffset,'text');
}
this.format=firstNextFormat|lastNextFormat;
};_proto7.








insertNodes=function insertNodes(nodes){
if(nodes.length===0){
return;
}
if(this.anchor.key==='root'){
this.insertParagraph();
var selection=$getSelection();
if(!$isRangeSelection(selection)){
throw Error("Expected RangeSelection after insertParagraph");
}
return selection.insertNodes(nodes);
}
var firstPoint=this.isBackward()?this.focus:this.anchor;
var firstBlock=$getAncestor(firstPoint.getNode(),INTERNAL_$isBlock);
var last=nodes[nodes.length-1];


if('__language'in firstBlock&&$isElementNode(firstBlock)){
if('__language'in nodes[0]){
this.insertText(nodes[0].getTextContent());
}else{
var index=removeTextAndSplitBlock(this);
firstBlock.splice(index,0,nodes);
last.selectEnd();
}
return;
}


var notInline=function notInline(node){return($isElementNode(node)||$isDecoratorNode(node))&&!node.isInline();};
if(!nodes.some(notInline)){
if(!$isElementNode(firstBlock)){
throw Error("Expected 'firstBlock' to be an ElementNode");
}
var _index=removeTextAndSplitBlock(this);
firstBlock.splice(_index,0,nodes);
last.selectEnd();
return;
}


var blocksParent=$wrapInlineNodes(nodes);
var nodeToSelect=blocksParent.getLastDescendant();
var blocks=blocksParent.getChildren();
var isLI=function isLI(node){return'__value'in node&&'__checked'in node;};
var isMergeable=function isMergeable(node){return $isElementNode(node)&&INTERNAL_$isBlock(node)&&!node.isEmpty()&&$isElementNode(firstBlock)&&(!firstBlock.isEmpty()||isLI(firstBlock));};
var shouldInsert=!$isElementNode(firstBlock)||!firstBlock.isEmpty();
var insertedParagraph=shouldInsert?this.insertParagraph():null;
var lastToInsert=blocks[blocks.length-1];
var firstToInsert=blocks[0];
if(isMergeable(firstToInsert)){
if(!$isElementNode(firstBlock)){
throw Error("Expected 'firstBlock' to be an ElementNode");
}
firstBlock.append.apply(firstBlock,firstToInsert.getChildren());
firstToInsert=blocks[1];
}
if(firstToInsert){
insertRangeAfter(firstBlock,firstToInsert);
}
var lastInsertedBlock=$getAncestor(nodeToSelect,INTERNAL_$isBlock);
if(insertedParagraph&&$isElementNode(lastInsertedBlock)&&(isLI(insertedParagraph)||INTERNAL_$isBlock(lastToInsert))){
lastInsertedBlock.append.apply(lastInsertedBlock,insertedParagraph.getChildren());
insertedParagraph.remove();
}
if($isElementNode(firstBlock)&&firstBlock.isEmpty()){
firstBlock.remove();
}
nodeToSelect.selectEnd();


var lastChild=$isElementNode(firstBlock)?firstBlock.getLastChild():null;
if($isLineBreakNode(lastChild)&&lastInsertedBlock!==firstBlock){
lastChild.remove();
}
};_proto7.






insertParagraph=function insertParagraph(){
if(this.anchor.key==='root'){
var paragraph=$createParagraphNode();
$getRoot().splice(this.anchor.offset,0,[paragraph]);
paragraph.select();
return paragraph;
}
var index=removeTextAndSplitBlock(this);
var block=$getAncestor(this.anchor.getNode(),INTERNAL_$isBlock);
if(!$isElementNode(block)){
throw Error("Expected ancestor to be an ElementNode");
}
var firstToAppend=block.getChildAtIndex(index);
var nodesToInsert=firstToAppend?[firstToAppend].concat(firstToAppend.getNextSiblings()):[];
var newBlock=block.insertNewAfter(this,false);
if(newBlock){
newBlock.append.apply(newBlock,nodesToInsert);
newBlock.selectStart();
return newBlock;
}

return null;
};_proto7.





insertLineBreak=function insertLineBreak(selectStart){
var lineBreak=$createLineBreakNode();
this.insertNodes([lineBreak]);

if(selectStart){
var parent=lineBreak.getParentOrThrow();
var index=lineBreak.getIndexWithinParent();
parent.select(index,index);
}
};_proto7.







extract=function extract(){
var selectedNodes=this.getNodes();
var selectedNodesLength=selectedNodes.length;
var lastIndex=selectedNodesLength-1;
var anchor=this.anchor;
var focus=this.focus;
var firstNode=selectedNodes[0];
var lastNode=selectedNodes[lastIndex];var _$getCharacterOffsets2=
$getCharacterOffsets(this),anchorOffset=_$getCharacterOffsets2[0],focusOffset=_$getCharacterOffsets2[1];
if(selectedNodesLength===0){
return[];
}else if(selectedNodesLength===1){
if($isTextNode(firstNode)&&!this.isCollapsed()){
var startOffset=anchorOffset>focusOffset?focusOffset:anchorOffset;
var endOffset=anchorOffset>focusOffset?anchorOffset:focusOffset;
var splitNodes=firstNode.splitText(startOffset,endOffset);
var node=startOffset===0?splitNodes[0]:splitNodes[1];
return node!=null?[node]:[];
}
return[firstNode];
}
var isBefore=anchor.isBefore(focus);
if($isTextNode(firstNode)){
var _startOffset=isBefore?anchorOffset:focusOffset;
if(_startOffset===firstNode.getTextContentSize()){
selectedNodes.shift();
}else if(_startOffset!==0){var _firstNode$splitText3=
firstNode.splitText(_startOffset);firstNode=_firstNode$splitText3[1];
selectedNodes[0]=firstNode;
}
}
if($isTextNode(lastNode)){
var lastNodeText=lastNode.getTextContent();
var lastNodeTextLength=lastNodeText.length;
var _endOffset=isBefore?focusOffset:anchorOffset;
if(_endOffset===0){
selectedNodes.pop();
}else if(_endOffset!==lastNodeTextLength){var _lastNode$splitText2=
lastNode.splitText(_endOffset);lastNode=_lastNode$splitText2[0];
selectedNodes[lastIndex]=lastNode;
}
}
return selectedNodes;
};_proto7.










modify=function modify(alter,isBackward,granularity){
var focus=this.focus;
var anchor=this.anchor;
var collapse=alter==='move';


var possibleNode=$getAdjacentNode(focus,isBackward);
if($isDecoratorNode(possibleNode)&&!possibleNode.isIsolated()){


if(collapse&&possibleNode.isKeyboardSelectable()){
var nodeSelection=$createNodeSelection();
nodeSelection.add(possibleNode.__key);
$setSelection(nodeSelection);
return;
}
var sibling=isBackward?possibleNode.getPreviousSibling():possibleNode.getNextSibling();
if(!$isTextNode(sibling)){
var parent=possibleNode.getParentOrThrow();
var offset;
var elementKey;
if($isElementNode(sibling)){
elementKey=sibling.__key;
offset=isBackward?sibling.getChildrenSize():0;
}else{
offset=possibleNode.getIndexWithinParent();
elementKey=parent.__key;
if(!isBackward){
offset++;
}
}
focus.set(elementKey,offset,'element');
if(collapse){
anchor.set(elementKey,offset,'element');
}
return;
}else{
var siblingKey=sibling.__key;
var _offset=isBackward?sibling.getTextContent().length:0;
focus.set(siblingKey,_offset,'text');
if(collapse){
anchor.set(siblingKey,_offset,'text');
}
return;
}
}
var editor=getActiveEditor();
var domSelection=getDOMSelection(editor._window);
if(!domSelection){
return;
}
var blockCursorElement=editor._blockCursorElement;
var rootElement=editor._rootElement;



if(rootElement!==null&&blockCursorElement!==null&&$isElementNode(possibleNode)&&!possibleNode.isInline()&&!possibleNode.canBeEmpty()){
removeDOMBlockCursorElement(blockCursorElement,editor,rootElement);
}






moveNativeSelection(domSelection,alter,isBackward?'backward':'forward',granularity);

if(domSelection.rangeCount>0){
var range=domSelection.getRangeAt(0);

var anchorNode=this.anchor.getNode();
var root=$isRootNode(anchorNode)?anchorNode:$getNearestRootOrShadowRoot(anchorNode);
this.applyDOMRange(range);
this.dirty=true;
if(!collapse){

var nodes=this.getNodes();
var validNodes=[];
var shrinkSelection=false;
for(var i=0;i<nodes.length;i++){
var nextNode=nodes[i];
if($hasAncestor(nextNode,root)){
validNodes.push(nextNode);
}else{
shrinkSelection=true;
}
}
if(shrinkSelection&&validNodes.length>0){


if(isBackward){
var firstValidNode=validNodes[0];
if($isElementNode(firstValidNode)){
firstValidNode.selectStart();
}else{
firstValidNode.getParentOrThrow().selectStart();
}
}else{
var lastValidNode=validNodes[validNodes.length-1];
if($isElementNode(lastValidNode)){
lastValidNode.selectEnd();
}else{
lastValidNode.getParentOrThrow().selectEnd();
}
}
}




if(domSelection.anchorNode!==range.startContainer||domSelection.anchorOffset!==range.startOffset){
$swapPoints(this);
}
}
}
};_proto7.







deleteCharacter=function deleteCharacter(isBackward){
var wasCollapsed=this.isCollapsed();
if(this.isCollapsed()){
var anchor=this.anchor;
var focus=this.focus;
var anchorNode=anchor.getNode();
if(!isBackward&&(

anchor.type==='element'&&$isElementNode(anchorNode)&&anchor.offset===anchorNode.getChildrenSize()||anchor.type==='text'&&anchor.offset===anchorNode.getTextContentSize())){
var parent=anchorNode.getParent();
var nextSibling=anchorNode.getNextSibling()||(parent===null?null:parent.getNextSibling());
if($isElementNode(nextSibling)&&nextSibling.isShadowRoot()){
return;
}
}

var possibleNode=$getAdjacentNode(focus,isBackward);
if($isDecoratorNode(possibleNode)&&!possibleNode.isIsolated()){


if(possibleNode.isKeyboardSelectable()&&$isElementNode(anchorNode)&&anchorNode.getChildrenSize()===0){
anchorNode.remove();
var nodeSelection=$createNodeSelection();
nodeSelection.add(possibleNode.__key);
$setSelection(nodeSelection);
}else{
possibleNode.remove();
var editor=getActiveEditor();
editor.dispatchCommand(SELECTION_CHANGE_COMMAND,undefined);
}
return;
}else if(!isBackward&&$isElementNode(possibleNode)&&$isElementNode(anchorNode)&&anchorNode.isEmpty()){
anchorNode.remove();
possibleNode.selectStart();
return;
}
this.modify('extend',isBackward,'character');
if(!this.isCollapsed()){
var focusNode=focus.type==='text'?focus.getNode():null;
anchorNode=anchor.type==='text'?anchor.getNode():null;
if(focusNode!==null&&focusNode.isSegmented()){
var offset=focus.offset;
var textContentSize=focusNode.getTextContentSize();
if(focusNode.is(anchorNode)||isBackward&&offset!==textContentSize||!isBackward&&offset!==0){
$removeSegment(focusNode,isBackward,offset);
return;
}
}else if(anchorNode!==null&&anchorNode.isSegmented()){
var _offset2=anchor.offset;
var _textContentSize=anchorNode.getTextContentSize();
if(anchorNode.is(focusNode)||isBackward&&_offset2!==0||!isBackward&&_offset2!==_textContentSize){
$removeSegment(anchorNode,isBackward,_offset2);
return;
}
}
$updateCaretSelectionForUnicodeCharacter(this,isBackward);
}else if(isBackward&&anchor.offset===0){

var element=anchor.type==='element'?anchor.getNode():anchor.getNode().getParentOrThrow();
if(element.collapseAtStart(this)){
return;
}
}
}
this.removeText();
if(isBackward&&!wasCollapsed&&this.isCollapsed()&&this.anchor.type==='element'&&this.anchor.offset===0){
var _anchorNode2=this.anchor.getNode();
if(_anchorNode2.isEmpty()&&$isRootNode(_anchorNode2.getParent())&&_anchorNode2.getIndexWithinParent()===0){
_anchorNode2.collapseAtStart(this);
}
}
};_proto7.







deleteLine=function deleteLine(isBackward){
if(this.isCollapsed()){
if(this.anchor.type==='text'){
this.modify('extend',isBackward,'lineboundary');
}




var endPoint=isBackward?this.focus:this.anchor;
if(endPoint.offset===0){
this.modify('extend',isBackward,'character');
}
}
this.removeText();
};_proto7.







deleteWord=function deleteWord(isBackward){
if(this.isCollapsed()){
this.modify('extend',isBackward,'word');
}
this.removeText();
};_proto7.






isBackward=function isBackward(){
return this.focus.isBefore(this.anchor);
};_proto7.
getStartEndPoints=function getStartEndPoints(){
return[this.anchor,this.focus];
};return RangeSelection;}();

function $isNodeSelection(x){
return x instanceof NodeSelection;
}
function getCharacterOffset(point){
var offset=point.offset;
if(point.type==='text'){
return offset;
}
var parent=point.getNode();
return offset===parent.getChildrenSize()?parent.getTextContent().length:0;
}
function $getCharacterOffsets(selection){
var anchorAndFocus=selection.getStartEndPoints();
if(anchorAndFocus===null){
return[0,0];
}var
anchor=anchorAndFocus[0],focus=anchorAndFocus[1];
if(anchor.type==='element'&&focus.type==='element'&&anchor.key===focus.key&&anchor.offset===focus.offset){
return[0,0];
}
return[getCharacterOffset(anchor),getCharacterOffset(focus)];
}
function $swapPoints(selection){
var focus=selection.focus;
var anchor=selection.anchor;
var anchorKey=anchor.key;
var anchorOffset=anchor.offset;
var anchorType=anchor.type;
$setPointValues(anchor,focus.key,focus.offset,focus.type);
$setPointValues(focus,anchorKey,anchorOffset,anchorType);
selection._cachedNodes=null;
}
function moveNativeSelection(domSelection,alter,direction,granularity){


domSelection.modify(alter,direction,granularity);
}
function $updateCaretSelectionForUnicodeCharacter(selection,isBackward){
var anchor=selection.anchor;
var focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if(anchorNode===focusNode&&anchor.type==='text'&&focus.type==='text'){

var anchorOffset=anchor.offset;
var focusOffset=focus.offset;
var isBefore=anchorOffset<focusOffset;
var startOffset=isBefore?anchorOffset:focusOffset;
var endOffset=isBefore?focusOffset:anchorOffset;
var characterOffset=endOffset-1;
if(startOffset!==characterOffset){
var text=anchorNode.getTextContent().slice(startOffset,endOffset);
if(!doesContainGrapheme(text)){
if(isBackward){
focus.offset=characterOffset;
}else{
anchor.offset=characterOffset;
}
}
}
}
}
function $removeSegment(node,isBackward,offset){
var textNode=node;
var textContent=textNode.getTextContent();
var split=textContent.split(/(?=\s)/g);
var splitLength=split.length;
var segmentOffset=0;
var restoreOffset=0;
for(var i=0;i<splitLength;i++){
var text=split[i];
var isLast=i===splitLength-1;
restoreOffset=segmentOffset;
segmentOffset+=text.length;
if(isBackward&&segmentOffset===offset||segmentOffset>offset||isLast){
split.splice(i,1);
if(isLast){
restoreOffset=undefined;
}
break;
}
}
var nextTextContent=split.join('').trim();
if(nextTextContent===''){
textNode.remove();
}else{
textNode.setTextContent(nextTextContent);
textNode.select(restoreOffset,restoreOffset);
}
}
function shouldResolveAncestor(resolvedElement,resolvedOffset,lastPoint){
var parent=resolvedElement.getParent();
return lastPoint===null||parent===null||!parent.canBeEmpty()||parent!==lastPoint.getNode();
}
function internalResolveSelectionPoint(dom,offset,lastPoint,editor){
var resolvedOffset=offset;
var resolvedNode;




if(dom.nodeType===DOM_ELEMENT_TYPE){

var moveSelectionToEnd=false;



var childNodes=dom.childNodes;
var childNodesLength=childNodes.length;


if(resolvedOffset===childNodesLength){
moveSelectionToEnd=true;
resolvedOffset=childNodesLength-1;
}
var childDOM=childNodes[resolvedOffset];
var hasBlockCursor=false;
if(childDOM===editor._blockCursorElement){
childDOM=childNodes[resolvedOffset+1];
hasBlockCursor=true;
}else if(editor._blockCursorElement!==null){
resolvedOffset--;
}
resolvedNode=getNodeFromDOM(childDOM);
if($isTextNode(resolvedNode)){
resolvedOffset=getTextNodeOffset(resolvedNode,moveSelectionToEnd);
}else{
var resolvedElement=getNodeFromDOM(dom);

if(resolvedElement===null){
return null;
}
if($isElementNode(resolvedElement)){
var child=resolvedElement.getChildAtIndex(resolvedOffset);
if($isElementNode(child)&&shouldResolveAncestor(child,resolvedOffset,lastPoint)){
var descendant=moveSelectionToEnd?child.getLastDescendant():child.getFirstDescendant();
if(descendant===null){
resolvedElement=child;
resolvedOffset=0;
}else{
child=descendant;
resolvedElement=$isElementNode(child)?child:child.getParentOrThrow();
}
}
if($isTextNode(child)){
resolvedNode=child;
resolvedElement=null;
resolvedOffset=getTextNodeOffset(child,moveSelectionToEnd);
}else if(child!==resolvedElement&&moveSelectionToEnd&&!hasBlockCursor){
resolvedOffset++;
}
}else{
var index=resolvedElement.getIndexWithinParent();


if(offset===0&&$isDecoratorNode(resolvedElement)&&getNodeFromDOM(dom)===resolvedElement){
resolvedOffset=index;
}else{
resolvedOffset=index+1;
}
resolvedElement=resolvedElement.getParentOrThrow();
}
if($isElementNode(resolvedElement)){
return $createPoint(resolvedElement.__key,resolvedOffset,'element');
}
}
}else{

resolvedNode=getNodeFromDOM(dom);
}
if(!$isTextNode(resolvedNode)){
return null;
}
return $createPoint(resolvedNode.__key,resolvedOffset,'text');
}
function resolveSelectionPointOnBoundary(point,isBackward,isCollapsed){
var offset=point.offset;
var node=point.getNode();
if(offset===0){
var prevSibling=node.getPreviousSibling();
var parent=node.getParent();
if(!isBackward){
if($isElementNode(prevSibling)&&!isCollapsed&&prevSibling.isInline()){
point.key=prevSibling.__key;
point.offset=prevSibling.getChildrenSize();

point.type='element';
}else if($isTextNode(prevSibling)){
point.key=prevSibling.__key;
point.offset=prevSibling.getTextContent().length;
}
}else if((isCollapsed||!isBackward)&&prevSibling===null&&$isElementNode(parent)&&parent.isInline()){
var parentSibling=parent.getPreviousSibling();
if($isTextNode(parentSibling)){
point.key=parentSibling.__key;
point.offset=parentSibling.getTextContent().length;
}
}
}else if(offset===node.getTextContent().length){
var nextSibling=node.getNextSibling();
var _parent2=node.getParent();
if(isBackward&&$isElementNode(nextSibling)&&nextSibling.isInline()){
point.key=nextSibling.__key;
point.offset=0;

point.type='element';
}else if((isCollapsed||isBackward)&&nextSibling===null&&$isElementNode(_parent2)&&_parent2.isInline()&&!_parent2.canInsertTextAfter()){
var _parentSibling=_parent2.getNextSibling();
if($isTextNode(_parentSibling)){
point.key=_parentSibling.__key;
point.offset=0;
}
}
}
}
function normalizeSelectionPointsForBoundaries(anchor,focus,lastSelection){
if(anchor.type==='text'&&focus.type==='text'){
var isBackward=anchor.isBefore(focus);
var isCollapsed=anchor.is(focus);



resolveSelectionPointOnBoundary(anchor,isBackward,isCollapsed);
resolveSelectionPointOnBoundary(focus,!isBackward,isCollapsed);
if(isCollapsed){
focus.key=anchor.key;
focus.offset=anchor.offset;
focus.type=anchor.type;
}
var editor=getActiveEditor();
if(editor.isComposing()&&editor._compositionKey!==anchor.key&&$isRangeSelection(lastSelection)){
var lastAnchor=lastSelection.anchor;
var lastFocus=lastSelection.focus;
$setPointValues(anchor,lastAnchor.key,lastAnchor.offset,lastAnchor.type);
$setPointValues(focus,lastFocus.key,lastFocus.offset,lastFocus.type);
}
}
}
function internalResolveSelectionPoints(anchorDOM,anchorOffset,focusDOM,focusOffset,editor,lastSelection){
if(anchorDOM===null||focusDOM===null||!isSelectionWithinEditor(editor,anchorDOM,focusDOM)){
return null;
}
var resolvedAnchorPoint=internalResolveSelectionPoint(anchorDOM,anchorOffset,$isRangeSelection(lastSelection)?lastSelection.anchor:null,editor);
if(resolvedAnchorPoint===null){
return null;
}
var resolvedFocusPoint=internalResolveSelectionPoint(focusDOM,focusOffset,$isRangeSelection(lastSelection)?lastSelection.focus:null,editor);
if(resolvedFocusPoint===null){
return null;
}
if(resolvedAnchorPoint.type==='element'&&resolvedFocusPoint.type==='element'){
var anchorNode=getNodeFromDOM(anchorDOM);
var focusNode=getNodeFromDOM(focusDOM);



if($isDecoratorNode(anchorNode)&&$isDecoratorNode(focusNode)){
return null;
}
}


normalizeSelectionPointsForBoundaries(resolvedAnchorPoint,resolvedFocusPoint,lastSelection);
return[resolvedAnchorPoint,resolvedFocusPoint];
}
function $isBlockElementNode(node){
return $isElementNode(node)&&!node.isInline();
}





function internalMakeRangeSelection(anchorKey,anchorOffset,focusKey,focusOffset,anchorType,focusType){
var editorState=getActiveEditorState();
var selection=new RangeSelection($createPoint(anchorKey,anchorOffset,anchorType),$createPoint(focusKey,focusOffset,focusType),0,'');
selection.dirty=true;
editorState._selection=selection;
return selection;
}
function $createRangeSelection(){
var anchor=$createPoint('root',0,'element');
var focus=$createPoint('root',0,'element');
return new RangeSelection(anchor,focus,0,'');
}
function $createNodeSelection(){
return new NodeSelection(new Set());
}
function internalCreateSelection(editor){
var currentEditorState=editor.getEditorState();
var lastSelection=currentEditorState._selection;
var domSelection=getDOMSelection(editor._window);
if($isRangeSelection(lastSelection)||lastSelection==null){
return internalCreateRangeSelection(lastSelection,domSelection,editor,null);
}
return lastSelection.clone();
}
function internalCreateRangeSelection(lastSelection,domSelection,editor,event){
var windowObj=editor._window;
if(windowObj===null){
return null;
}














var windowEvent=event||windowObj.event;
var eventType=windowEvent?windowEvent.type:undefined;
var isSelectionChange=eventType==='selectionchange';
var useDOMSelection=!getIsProcessingMutations()&&(isSelectionChange||eventType==='beforeinput'||eventType==='compositionstart'||eventType==='compositionend'||eventType==='click'&&windowEvent&&windowEvent.detail===3||eventType==='drop'||eventType===undefined);
var anchorDOM,focusDOM,anchorOffset,focusOffset;
if(!$isRangeSelection(lastSelection)||useDOMSelection){
if(domSelection===null){
return null;
}
anchorDOM=domSelection.anchorNode;
focusDOM=domSelection.focusNode;
anchorOffset=domSelection.anchorOffset;
focusOffset=domSelection.focusOffset;
if(isSelectionChange&&$isRangeSelection(lastSelection)&&!isSelectionWithinEditor(editor,anchorDOM,focusDOM)){
return lastSelection.clone();
}
}else{
return lastSelection.clone();
}


var resolvedSelectionPoints=internalResolveSelectionPoints(anchorDOM,anchorOffset,focusDOM,focusOffset,editor,lastSelection);
if(resolvedSelectionPoints===null){
return null;
}var
resolvedAnchorPoint=resolvedSelectionPoints[0],resolvedFocusPoint=resolvedSelectionPoints[1];
return new RangeSelection(resolvedAnchorPoint,resolvedFocusPoint,!$isRangeSelection(lastSelection)?0:lastSelection.format,!$isRangeSelection(lastSelection)?'':lastSelection.style);
}
function $getSelection(){
var editorState=getActiveEditorState();
return editorState._selection;
}
function $getPreviousSelection(){
var editor=getActiveEditor();
return editor._editorState._selection;
}
function $updateElementSelectionOnCreateDeleteNode(selection,parentNode,nodeOffset,times){if(times===void 0){times=1;}
var anchor=selection.anchor;
var focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if(!parentNode.is(anchorNode)&&!parentNode.is(focusNode)){
return;
}
var parentKey=parentNode.__key;

if(selection.isCollapsed()){
var selectionOffset=anchor.offset;
if(nodeOffset<=selectionOffset&&times>0||nodeOffset<selectionOffset&&times<0){
var newSelectionOffset=Math.max(0,selectionOffset+times);
anchor.set(parentKey,newSelectionOffset,'element');
focus.set(parentKey,newSelectionOffset,'element');

$updateSelectionResolveTextNodes(selection);
}
}else{

var isBackward=selection.isBackward();
var firstPoint=isBackward?focus:anchor;
var firstPointNode=firstPoint.getNode();
var lastPoint=isBackward?anchor:focus;
var lastPointNode=lastPoint.getNode();
if(parentNode.is(firstPointNode)){
var firstPointOffset=firstPoint.offset;
if(nodeOffset<=firstPointOffset&&times>0||nodeOffset<firstPointOffset&&times<0){
firstPoint.set(parentKey,Math.max(0,firstPointOffset+times),'element');
}
}
if(parentNode.is(lastPointNode)){
var lastPointOffset=lastPoint.offset;
if(nodeOffset<=lastPointOffset&&times>0||nodeOffset<lastPointOffset&&times<0){
lastPoint.set(parentKey,Math.max(0,lastPointOffset+times),'element');
}
}
}

$updateSelectionResolveTextNodes(selection);
}
function $updateSelectionResolveTextNodes(selection){
var anchor=selection.anchor;
var anchorOffset=anchor.offset;
var focus=selection.focus;
var focusOffset=focus.offset;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if(selection.isCollapsed()){
if(!$isElementNode(anchorNode)){
return;
}
var childSize=anchorNode.getChildrenSize();
var anchorOffsetAtEnd=anchorOffset>=childSize;
var child=anchorOffsetAtEnd?anchorNode.getChildAtIndex(childSize-1):anchorNode.getChildAtIndex(anchorOffset);
if($isTextNode(child)){
var newOffset=0;
if(anchorOffsetAtEnd){
newOffset=child.getTextContentSize();
}
anchor.set(child.__key,newOffset,'text');
focus.set(child.__key,newOffset,'text');
}
return;
}
if($isElementNode(anchorNode)){
var _childSize=anchorNode.getChildrenSize();
var _anchorOffsetAtEnd=anchorOffset>=_childSize;
var _child2=_anchorOffsetAtEnd?anchorNode.getChildAtIndex(_childSize-1):anchorNode.getChildAtIndex(anchorOffset);
if($isTextNode(_child2)){
var _newOffset=0;
if(_anchorOffsetAtEnd){
_newOffset=_child2.getTextContentSize();
}
anchor.set(_child2.__key,_newOffset,'text');
}
}
if($isElementNode(focusNode)){
var _childSize2=focusNode.getChildrenSize();
var focusOffsetAtEnd=focusOffset>=_childSize2;
var _child3=focusOffsetAtEnd?focusNode.getChildAtIndex(_childSize2-1):focusNode.getChildAtIndex(focusOffset);
if($isTextNode(_child3)){
var _newOffset2=0;
if(focusOffsetAtEnd){
_newOffset2=_child3.getTextContentSize();
}
focus.set(_child3.__key,_newOffset2,'text');
}
}
}
function applySelectionTransforms(nextEditorState,editor){
var prevEditorState=editor.getEditorState();
var prevSelection=prevEditorState._selection;
var nextSelection=nextEditorState._selection;
if($isRangeSelection(nextSelection)){
var anchor=nextSelection.anchor;
var focus=nextSelection.focus;
var anchorNode;
if(anchor.type==='text'){
anchorNode=anchor.getNode();
anchorNode.selectionTransform(prevSelection,nextSelection);
}
if(focus.type==='text'){
var focusNode=focus.getNode();
if(anchorNode!==focusNode){
focusNode.selectionTransform(prevSelection,nextSelection);
}
}
}
}
function moveSelectionPointToSibling(point,node,parent,prevSibling,nextSibling){
var siblingKey=null;
var offset=0;
var type=null;
if(prevSibling!==null){
siblingKey=prevSibling.__key;
if($isTextNode(prevSibling)){
offset=prevSibling.getTextContentSize();
type='text';
}else if($isElementNode(prevSibling)){
offset=prevSibling.getChildrenSize();
type='element';
}
}else{
if(nextSibling!==null){
siblingKey=nextSibling.__key;
if($isTextNode(nextSibling)){
type='text';
}else if($isElementNode(nextSibling)){
type='element';
}
}
}
if(siblingKey!==null&&type!==null){
point.set(siblingKey,offset,type);
}else{
offset=node.getIndexWithinParent();
if(offset===-1){

offset=parent.getChildrenSize();
}
point.set(parent.__key,offset,'element');
}
}
function adjustPointOffsetForMergedSibling(point,isBefore,key,target,textLength){
if(point.type==='text'){
point.key=key;
if(!isBefore){
point.offset+=textLength;
}
}else if(point.offset>target.getIndexWithinParent()){
point.offset-=1;
}
}
function updateDOMSelection(prevSelection,nextSelection,editor,domSelection,tags,rootElement,nodeCount){
var anchorDOMNode=domSelection.anchorNode;
var focusDOMNode=domSelection.focusNode;
var anchorOffset=domSelection.anchorOffset;
var focusOffset=domSelection.focusOffset;
var activeElement=document.activeElement;



if(tags.has('collaboration')&&activeElement!==rootElement||activeElement!==null&&isSelectionCapturedInDecoratorInput(activeElement)){
return;
}
if(!$isRangeSelection(nextSelection)){




if(prevSelection!==null&&isSelectionWithinEditor(editor,anchorDOMNode,focusDOMNode)){
domSelection.removeAllRanges();
}
return;
}
var anchor=nextSelection.anchor;
var focus=nextSelection.focus;
var anchorKey=anchor.key;
var focusKey=focus.key;
var anchorDOM=getElementByKeyOrThrow(editor,anchorKey);
var focusDOM=getElementByKeyOrThrow(editor,focusKey);
var nextAnchorOffset=anchor.offset;
var nextFocusOffset=focus.offset;
var nextFormat=nextSelection.format;
var nextStyle=nextSelection.style;
var isCollapsed=nextSelection.isCollapsed();
var nextAnchorNode=anchorDOM;
var nextFocusNode=focusDOM;
var anchorFormatOrStyleChanged=false;
if(anchor.type==='text'){
nextAnchorNode=getDOMTextNode(anchorDOM);
var anchorNode=anchor.getNode();
anchorFormatOrStyleChanged=anchorNode.getFormat()!==nextFormat||anchorNode.getStyle()!==nextStyle;
}else if($isRangeSelection(prevSelection)&&prevSelection.anchor.type==='text'){
anchorFormatOrStyleChanged=true;
}
if(focus.type==='text'){
nextFocusNode=getDOMTextNode(focusDOM);
}



if(nextAnchorNode===null||nextFocusNode===null){
return;
}
if(isCollapsed&&(prevSelection===null||anchorFormatOrStyleChanged||$isRangeSelection(prevSelection)&&(prevSelection.format!==nextFormat||prevSelection.style!==nextStyle))){
markCollapsedSelectionFormat(nextFormat,nextStyle,nextAnchorOffset,anchorKey,performance.now());
}





if(anchorOffset===nextAnchorOffset&&focusOffset===nextFocusOffset&&anchorDOMNode===nextAnchorNode&&focusDOMNode===nextFocusNode&&

!(domSelection.type==='Range'&&isCollapsed)){

if(activeElement===null||!rootElement.contains(activeElement)){
rootElement.focus({
preventScroll:true});

}
if(anchor.type!=='element'){
return;
}
}



try{
domSelection.setBaseAndExtent(nextAnchorNode,nextAnchorOffset,nextFocusNode,nextFocusOffset);
}catch(error){



}
if(!tags.has('skip-scroll-into-view')&&nextSelection.isCollapsed()&&rootElement!==null&&rootElement===document.activeElement){
var selectionTarget=nextSelection instanceof RangeSelection&&nextSelection.anchor.type==='element'?nextAnchorNode.childNodes[nextAnchorOffset]||null:domSelection.rangeCount>0?domSelection.getRangeAt(0):null;
if(selectionTarget!==null){
var selectionRect;
if(selectionTarget instanceof Text){
var range=document.createRange();
range.selectNode(selectionTarget);
selectionRect=range.getBoundingClientRect();
}else{
selectionRect=selectionTarget.getBoundingClientRect();
}
scrollIntoViewIfNeeded(editor,selectionRect,rootElement);
}
}
markSelectionChangeFromDOMUpdate();
}
function $insertNodes(nodes){
var selection=$getSelection()||$getPreviousSelection();
if(selection===null){
selection=$getRoot().selectEnd();
}
selection.insertNodes(nodes);
}
function $getTextContent(){
var selection=$getSelection();
if(selection===null){
return'';
}
return selection.getTextContent();
}
function removeTextAndSplitBlock(selection){
if(!selection.isCollapsed()){
selection.removeText();
}
var anchor=selection.anchor;
var node=anchor.getNode();
var offset=anchor.offset;
while(!INTERNAL_$isBlock(node)){var _splitNodeAtPoint=
splitNodeAtPoint(node,offset);node=_splitNodeAtPoint[0];offset=_splitNodeAtPoint[1];
}
return offset;
}
function splitNodeAtPoint(node,offset){
var parent=node.getParent();
if(!parent){
var paragraph=$createParagraphNode();
$getRoot().append(paragraph);
paragraph.select();
return[$getRoot(),0];
}
if($isTextNode(node)){
var split=node.splitText(offset);
if(split.length===0){
return[parent,node.getIndexWithinParent()];
}
var x=offset===0?0:1;
var index=split[0].getIndexWithinParent()+x;
return[parent,index];
}
if(!$isElementNode(node)||offset===0){
return[parent,node.getIndexWithinParent()];
}
var firstToAppend=node.getChildAtIndex(offset);
if(firstToAppend){
var insertPoint=new RangeSelection($createPoint(node.__key,offset,'element'),$createPoint(node.__key,offset,'element'),0,'');
var newElement=node.insertNewAfter(insertPoint);
if(newElement){
newElement.append.apply(newElement,[firstToAppend].concat(firstToAppend.getNextSiblings()));
}
}
return[parent,node.getIndexWithinParent()+1];
}
function $wrapInlineNodes(nodes){


var virtualRoot=$createParagraphNode();
var currentBlock=null;
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
var isLineBreakNode=$isLineBreakNode(node);
if(isLineBreakNode||$isDecoratorNode(node)&&node.isInline()||$isElementNode(node)&&node.isInline()||$isTextNode(node)||node.isParentRequired()){
if(currentBlock===null){
currentBlock=node.createParentElementNode();
virtualRoot.append(currentBlock);


if(isLineBreakNode){
continue;
}
}
if(currentBlock!==null){
currentBlock.append(node);
}
}else{
virtualRoot.append(node);
currentBlock=null;
}
}
return virtualRoot;
}








var activeEditorState=null;
var activeEditor=null;
var isReadOnlyMode=false;
var isAttemptingToRecoverFromReconcilerError=false;
var infiniteTransformCount=0;
var observerOptions={
characterData:true,
childList:true,
subtree:true};

function isCurrentlyReadOnlyMode(){
return isReadOnlyMode||activeEditorState!==null&&activeEditorState._readOnly;
}
function errorOnReadOnly(){
if(isReadOnlyMode){
{
throw Error("Cannot use method in read-only mode.");
}
}
}
function errorOnInfiniteTransforms(){
if(infiniteTransformCount>99){
{
throw Error("One or more transforms are endlessly triggering additional transforms. May have encountered infinite recursion caused by transforms that have their preconditions too lose and/or conflict with each other.");
}
}
}
function getActiveEditorState(){
if(activeEditorState===null){
{
throw Error("Unable to find an active editor state. State helpers or node methods can only be used synchronously during the callback of editor.update() or editorState.read().");
}
}
return activeEditorState;
}
function getActiveEditor(){
if(activeEditor===null){
{
throw Error("Unable to find an active editor. This method can only be used synchronously during the callback of editor.update().");
}
}
return activeEditor;
}
function internalGetActiveEditor(){
return activeEditor;
}
function $applyTransforms(editor,node,transformsCache){
var type=node.__type;
var registeredNode=getRegisteredNodeOrThrow(editor,type);
var transformsArr=transformsCache.get(type);
if(transformsArr===undefined){
transformsArr=Array.from(registeredNode.transforms);
transformsCache.set(type,transformsArr);
}
var transformsArrLength=transformsArr.length;
for(var i=0;i<transformsArrLength;i++){
transformsArr[i](node);
if(!node.isAttached()){
break;
}
}
}
function $isNodeValidForTransform(node,compositionKey){
return node!==undefined&&

node.__key!==compositionKey&&node.isAttached();
}
function $normalizeAllDirtyTextNodes(editorState,editor){
var dirtyLeaves=editor._dirtyLeaves;
var nodeMap=editorState._nodeMap;
for(var _iterator8=dirtyLeaves,_isArray8=Array.isArray(_iterator8),_i13=0,_iterator8=_isArray8?_iterator8:_iterator8[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref16;if(_isArray8){if(_i13>=_iterator8.length)break;_ref16=_iterator8[_i13++];}else{_i13=_iterator8.next();if(_i13.done)break;_ref16=_i13.value;}var nodeKey=_ref16;
var node=nodeMap.get(nodeKey);
if($isTextNode(node)&&node.isAttached()&&node.isSimpleText()&&!node.isUnmergeable()){
$normalizeTextNode(node);
}
}
}











function $applyAllTransforms(editorState,editor){
var dirtyLeaves=editor._dirtyLeaves;
var dirtyElements=editor._dirtyElements;
var nodeMap=editorState._nodeMap;
var compositionKey=$getCompositionKey();
var transformsCache=new Map();
var untransformedDirtyLeaves=dirtyLeaves;
var untransformedDirtyLeavesLength=untransformedDirtyLeaves.size;
var untransformedDirtyElements=dirtyElements;
var untransformedDirtyElementsLength=untransformedDirtyElements.size;
while(untransformedDirtyLeavesLength>0||untransformedDirtyElementsLength>0){
if(untransformedDirtyLeavesLength>0){

editor._dirtyLeaves=new Set();
for(var _iterator9=untransformedDirtyLeaves,_isArray9=Array.isArray(_iterator9),_i14=0,_iterator9=_isArray9?_iterator9:_iterator9[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref17;if(_isArray9){if(_i14>=_iterator9.length)break;_ref17=_iterator9[_i14++];}else{_i14=_iterator9.next();if(_i14.done)break;_ref17=_i14.value;}var nodeKey=_ref17;
var node=nodeMap.get(nodeKey);
if($isTextNode(node)&&node.isAttached()&&node.isSimpleText()&&!node.isUnmergeable()){
$normalizeTextNode(node);
}
if(node!==undefined&&$isNodeValidForTransform(node,compositionKey)){
$applyTransforms(editor,node,transformsCache);
}
dirtyLeaves.add(nodeKey);
}
untransformedDirtyLeaves=editor._dirtyLeaves;
untransformedDirtyLeavesLength=untransformedDirtyLeaves.size;


if(untransformedDirtyLeavesLength>0){
infiniteTransformCount++;
continue;
}
}




editor._dirtyLeaves=new Set();
editor._dirtyElements=new Map();
for(var _iterator10=untransformedDirtyElements,_isArray10=Array.isArray(_iterator10),_i15=0,_iterator10=_isArray10?_iterator10:_iterator10[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref18;if(_isArray10){if(_i15>=_iterator10.length)break;_ref18=_iterator10[_i15++];}else{_i15=_iterator10.next();if(_i15.done)break;_ref18=_i15.value;}var currentUntransformedDirtyElement=_ref18;
var _nodeKey3=currentUntransformedDirtyElement[0];
var intentionallyMarkedAsDirty=currentUntransformedDirtyElement[1];
if(_nodeKey3!=='root'&&!intentionallyMarkedAsDirty){
continue;
}
var _node3=nodeMap.get(_nodeKey3);
if(_node3!==undefined&&$isNodeValidForTransform(_node3,compositionKey)){
$applyTransforms(editor,_node3,transformsCache);
}
dirtyElements.set(_nodeKey3,intentionallyMarkedAsDirty);
}
untransformedDirtyLeaves=editor._dirtyLeaves;
untransformedDirtyLeavesLength=untransformedDirtyLeaves.size;
untransformedDirtyElements=editor._dirtyElements;
untransformedDirtyElementsLength=untransformedDirtyElements.size;
infiniteTransformCount++;
}
editor._dirtyLeaves=dirtyLeaves;
editor._dirtyElements=dirtyElements;
}
function $parseSerializedNode(serializedNode){
var internalSerializedNode=serializedNode;
return $parseSerializedNodeImpl(internalSerializedNode,getActiveEditor()._nodes);
}
function $parseSerializedNodeImpl(serializedNode,registeredNodes){
var type=serializedNode.type;
var registeredNode=registeredNodes.get(type);
if(registeredNode===undefined){
{
throw Error("parseEditorState: type \""+type+"\" + not found");
}
}
var nodeClass=registeredNode.klass;
if(serializedNode.type!==nodeClass.getType()){
{
throw Error("LexicalNode: Node "+nodeClass.name+" does not implement .importJSON().");
}
}
var node=nodeClass.importJSON(serializedNode);
var children=serializedNode.children;
if($isElementNode(node)&&Array.isArray(children)){
for(var i=0;i<children.length;i++){
var serializedJSONChildNode=children[i];
var childNode=$parseSerializedNodeImpl(serializedJSONChildNode,registeredNodes);
node.append(childNode);
}
}
return node;
}
function _parseEditorState(serializedEditorState,editor,updateFn){
var editorState=createEmptyEditorState();
var previousActiveEditorState=activeEditorState;
var previousReadOnlyMode=isReadOnlyMode;
var previousActiveEditor=activeEditor;
var previousDirtyElements=editor._dirtyElements;
var previousDirtyLeaves=editor._dirtyLeaves;
var previousCloneNotNeeded=editor._cloneNotNeeded;
var previousDirtyType=editor._dirtyType;
editor._dirtyElements=new Map();
editor._dirtyLeaves=new Set();
editor._cloneNotNeeded=new Set();
editor._dirtyType=0;
activeEditorState=editorState;
isReadOnlyMode=false;
activeEditor=editor;
try{
var registeredNodes=editor._nodes;
var serializedNode=serializedEditorState.root;
$parseSerializedNodeImpl(serializedNode,registeredNodes);
if(updateFn){
updateFn();
}


editorState._readOnly=true;
{
handleDEVOnlyPendingUpdateGuarantees(editorState);
}
}catch(error){
if(error instanceof Error){
editor._onError(error);
}
}finally{
editor._dirtyElements=previousDirtyElements;
editor._dirtyLeaves=previousDirtyLeaves;
editor._cloneNotNeeded=previousCloneNotNeeded;
editor._dirtyType=previousDirtyType;
activeEditorState=previousActiveEditorState;
isReadOnlyMode=previousReadOnlyMode;
activeEditor=previousActiveEditor;
}
return editorState;
}





function readEditorState(editorState,callbackFn){
var previousActiveEditorState=activeEditorState;
var previousReadOnlyMode=isReadOnlyMode;
var previousActiveEditor=activeEditor;
activeEditorState=editorState;
isReadOnlyMode=true;
activeEditor=null;
try{
return callbackFn();
}finally{
activeEditorState=previousActiveEditorState;
isReadOnlyMode=previousReadOnlyMode;
activeEditor=previousActiveEditor;
}
}
function handleDEVOnlyPendingUpdateGuarantees(pendingEditorState){


var nodeMap=pendingEditorState._nodeMap;
nodeMap.set=function(){
throw new Error('Cannot call set() on a frozen Lexical node map');
};
nodeMap.clear=function(){
throw new Error('Cannot call clear() on a frozen Lexical node map');
};
nodeMap["delete"]=function(){
throw new Error('Cannot call delete() on a frozen Lexical node map');
};
}
function commitPendingUpdates(editor,recoveryEditorState){
var pendingEditorState=editor._pendingEditorState;
var rootElement=editor._rootElement;
var shouldSkipDOM=editor._headless||rootElement===null;
if(pendingEditorState===null){
return;
}





var currentEditorState=editor._editorState;
var currentSelection=currentEditorState._selection;
var pendingSelection=pendingEditorState._selection;
var needsUpdate=editor._dirtyType!==NO_DIRTY_NODES;
var previousActiveEditorState=activeEditorState;
var previousReadOnlyMode=isReadOnlyMode;
var previousActiveEditor=activeEditor;
var previouslyUpdating=editor._updating;
var observer=editor._observer;
var mutatedNodes=null;
editor._pendingEditorState=null;
editor._editorState=pendingEditorState;
if(!shouldSkipDOM&&needsUpdate&&observer!==null){
activeEditor=editor;
activeEditorState=pendingEditorState;
isReadOnlyMode=false;

editor._updating=true;
try{
var dirtyType=editor._dirtyType;
var _dirtyElements=editor._dirtyElements;
var _dirtyLeaves=editor._dirtyLeaves;
observer.disconnect();
mutatedNodes=reconcileRoot(currentEditorState,pendingEditorState,editor,dirtyType,_dirtyElements,_dirtyLeaves);
}catch(error){

if(error instanceof Error){
editor._onError(error);
}


if(!isAttemptingToRecoverFromReconcilerError){
resetEditor(editor,null,rootElement,pendingEditorState);
initMutationObserver(editor);
editor._dirtyType=FULL_RECONCILE;
isAttemptingToRecoverFromReconcilerError=true;
commitPendingUpdates(editor,currentEditorState);
isAttemptingToRecoverFromReconcilerError=false;
}else{

throw error;
}
return;
}finally{
observer.observe(rootElement,observerOptions);
editor._updating=previouslyUpdating;
activeEditorState=previousActiveEditorState;
isReadOnlyMode=previousReadOnlyMode;
activeEditor=previousActiveEditor;
}
}
if(!pendingEditorState._readOnly){
pendingEditorState._readOnly=true;
{
handleDEVOnlyPendingUpdateGuarantees(pendingEditorState);
if($isRangeSelection(pendingSelection)){
Object.freeze(pendingSelection.anchor);
Object.freeze(pendingSelection.focus);
}
Object.freeze(pendingSelection);
}
}
var dirtyLeaves=editor._dirtyLeaves;
var dirtyElements=editor._dirtyElements;
var normalizedNodes=editor._normalizedNodes;
var tags=editor._updateTags;
var deferred=editor._deferred;
if(needsUpdate){
editor._dirtyType=NO_DIRTY_NODES;
editor._cloneNotNeeded.clear();
editor._dirtyLeaves=new Set();
editor._dirtyElements=new Map();
editor._normalizedNodes=new Set();
editor._updateTags=new Set();
}
$garbageCollectDetachedDecorators(editor,pendingEditorState);





var domSelection=shouldSkipDOM?null:getDOMSelection(editor._window);



if(editor._editable&&

domSelection!==null&&(needsUpdate||pendingSelection===null||pendingSelection.dirty)){
activeEditor=editor;
activeEditorState=pendingEditorState;
try{
if(observer!==null){
observer.disconnect();
}
if(needsUpdate||pendingSelection===null||pendingSelection.dirty){
var blockCursorElement=editor._blockCursorElement;
if(blockCursorElement!==null){
removeDOMBlockCursorElement(blockCursorElement,editor,rootElement);
}
updateDOMSelection(currentSelection,pendingSelection,editor,domSelection,tags,rootElement);
}
updateDOMBlockCursorElement(editor,rootElement,pendingSelection);
if(observer!==null){
observer.observe(rootElement,observerOptions);
}
}finally{
activeEditor=previousActiveEditor;
activeEditorState=previousActiveEditorState;
}
}
if(mutatedNodes!==null){
triggerMutationListeners(editor,mutatedNodes,tags,dirtyLeaves,currentEditorState);
}
if(!$isRangeSelection(pendingSelection)&&pendingSelection!==null&&(currentSelection===null||!currentSelection.is(pendingSelection))){
editor.dispatchCommand(SELECTION_CHANGE_COMMAND,undefined);
}



var pendingDecorators=editor._pendingDecorators;
if(pendingDecorators!==null){
editor._decorators=pendingDecorators;
editor._pendingDecorators=null;
triggerListeners('decorator',editor,true,pendingDecorators);
}






triggerTextContentListeners(editor,recoveryEditorState||currentEditorState,pendingEditorState);
triggerListeners('update',editor,true,{
dirtyElements:dirtyElements,
dirtyLeaves:dirtyLeaves,
editorState:pendingEditorState,
normalizedNodes:normalizedNodes,
prevEditorState:recoveryEditorState||currentEditorState,
tags:tags});

triggerDeferredUpdateCallbacks(editor,deferred);
triggerEnqueuedUpdates(editor);
}
function triggerTextContentListeners(editor,currentEditorState,pendingEditorState){
var currentTextContent=getEditorStateTextContent(currentEditorState);
var latestTextContent=getEditorStateTextContent(pendingEditorState);
if(currentTextContent!==latestTextContent){
triggerListeners('textcontent',editor,true,latestTextContent);
}
}
function triggerMutationListeners(editor,mutatedNodes,updateTags,dirtyLeaves,prevEditorState){
var listeners=Array.from(editor._listeners.mutation);
var listenersLength=listeners.length;
for(var i=0;i<listenersLength;i++){var _listeners$i=
listeners[i],listener=_listeners$i[0],klass=_listeners$i[1];
var mutatedNodesByType=mutatedNodes.get(klass);
if(mutatedNodesByType!==undefined){
listener(mutatedNodesByType,{
dirtyLeaves:dirtyLeaves,
prevEditorState:prevEditorState,
updateTags:updateTags});

}
}
}
function triggerListeners(type,editor,isCurrentlyEnqueuingUpdates){
var previouslyUpdating=editor._updating;
editor._updating=isCurrentlyEnqueuingUpdates;
try{
var listeners=Array.from(editor._listeners[type]);for(var _len2=arguments.length,payload=new Array(_len2>3?_len2-3:0),_key2=3;_key2<_len2;_key2++){payload[_key2-3]=arguments[_key2];}
for(var i=0;i<listeners.length;i++){

listeners[i].apply(null,payload);
}
}finally{
editor._updating=previouslyUpdating;
}
}
function triggerCommandListeners(editor,type,payload){
if(editor._updating===false||activeEditor!==editor){
var returnVal=false;
editor.update(function(){
returnVal=triggerCommandListeners(editor,type,payload);
});
return returnVal;
}
var editors=getEditorsToPropagate(editor);
for(var i=4;i>=0;i--){
for(var e=0;e<editors.length;e++){
var currentEditor=editors[e];
var commandListeners=currentEditor._commands;
var listenerInPriorityOrder=commandListeners.get(type);
if(listenerInPriorityOrder!==undefined){
var listenersSet=listenerInPriorityOrder[i];
if(listenersSet!==undefined){
var listeners=Array.from(listenersSet);
var listenersLength=listeners.length;
for(var j=0;j<listenersLength;j++){
if(listeners[j](payload,editor)===true){
return true;
}
}
}
}
}
}
return false;
}
function triggerEnqueuedUpdates(editor){
var queuedUpdates=editor._updates;
if(queuedUpdates.length!==0){
var queuedUpdate=queuedUpdates.shift();
if(queuedUpdate){var
updateFn=queuedUpdate[0],options=queuedUpdate[1];
beginUpdate(editor,updateFn,options);
}
}
}
function triggerDeferredUpdateCallbacks(editor,deferred){
editor._deferred=[];
if(deferred.length!==0){
var previouslyUpdating=editor._updating;
editor._updating=true;
try{
for(var i=0;i<deferred.length;i++){
deferred[i]();
}
}finally{
editor._updating=previouslyUpdating;
}
}
}
function processNestedUpdates(editor,initialSkipTransforms){
var queuedUpdates=editor._updates;
var skipTransforms=initialSkipTransforms||false;




while(queuedUpdates.length!==0){
var queuedUpdate=queuedUpdates.shift();
if(queuedUpdate){var
nextUpdateFn=queuedUpdate[0],options=queuedUpdate[1];
var onUpdate=void 0;
var tag=void 0;
if(options!==undefined){
onUpdate=options.onUpdate;
tag=options.tag;
if(options.skipTransforms){
skipTransforms=true;
}
if(onUpdate){
editor._deferred.push(onUpdate);
}
if(tag){
editor._updateTags.add(tag);
}
}
nextUpdateFn();
}
}
return skipTransforms;
}
function beginUpdate(editor,updateFn,options){
var updateTags=editor._updateTags;
var onUpdate;
var tag;
var skipTransforms=false;
var discrete=false;
if(options!==undefined){
onUpdate=options.onUpdate;
tag=options.tag;
if(tag!=null){
updateTags.add(tag);
}
skipTransforms=options.skipTransforms||false;
discrete=options.discrete||false;
}
if(onUpdate){
editor._deferred.push(onUpdate);
}
var currentEditorState=editor._editorState;
var pendingEditorState=editor._pendingEditorState;
var editorStateWasCloned=false;
if(pendingEditorState===null||pendingEditorState._readOnly){
pendingEditorState=editor._pendingEditorState=cloneEditorState(pendingEditorState||currentEditorState);
editorStateWasCloned=true;
}
pendingEditorState._flushSync=discrete;
var previousActiveEditorState=activeEditorState;
var previousReadOnlyMode=isReadOnlyMode;
var previousActiveEditor=activeEditor;
var previouslyUpdating=editor._updating;
activeEditorState=pendingEditorState;
isReadOnlyMode=false;
editor._updating=true;
activeEditor=editor;
try{
if(editorStateWasCloned){
if(editor._headless){
if(currentEditorState._selection!==null){
pendingEditorState._selection=currentEditorState._selection.clone();
}
}else{
pendingEditorState._selection=internalCreateSelection(editor);
}
}
var startingCompositionKey=editor._compositionKey;
updateFn();
skipTransforms=processNestedUpdates(editor,skipTransforms);
applySelectionTransforms(pendingEditorState,editor);
if(editor._dirtyType!==NO_DIRTY_NODES){
if(skipTransforms){
$normalizeAllDirtyTextNodes(pendingEditorState,editor);
}else{
$applyAllTransforms(pendingEditorState,editor);
}
processNestedUpdates(editor);
$garbageCollectDetachedNodes(currentEditorState,pendingEditorState,editor._dirtyLeaves,editor._dirtyElements);
}
var endingCompositionKey=editor._compositionKey;
if(startingCompositionKey!==endingCompositionKey){
pendingEditorState._flushSync=true;
}
var pendingSelection=pendingEditorState._selection;
if($isRangeSelection(pendingSelection)){
var pendingNodeMap=pendingEditorState._nodeMap;
var anchorKey=pendingSelection.anchor.key;
var focusKey=pendingSelection.focus.key;
if(pendingNodeMap.get(anchorKey)===undefined||pendingNodeMap.get(focusKey)===undefined){
{
throw Error("updateEditor: selection has been lost because the previously selected nodes have been removed and selection wasn't moved to another node. Ensure selection changes after removing/replacing a selected node.");
}
}
}else if($isNodeSelection(pendingSelection)){

if(pendingSelection._nodes.size===0){
pendingEditorState._selection=null;
}
}
}catch(error){

if(error instanceof Error){
editor._onError(error);
}


editor._pendingEditorState=currentEditorState;
editor._dirtyType=FULL_RECONCILE;
editor._cloneNotNeeded.clear();
editor._dirtyLeaves=new Set();
editor._dirtyElements.clear();
commitPendingUpdates(editor);
return;
}finally{
activeEditorState=previousActiveEditorState;
isReadOnlyMode=previousReadOnlyMode;
activeEditor=previousActiveEditor;
editor._updating=previouslyUpdating;
infiniteTransformCount=0;
}
var shouldUpdate=editor._dirtyType!==NO_DIRTY_NODES||editorStateHasDirtySelection(pendingEditorState,editor);
if(shouldUpdate){
if(pendingEditorState._flushSync){
pendingEditorState._flushSync=false;
commitPendingUpdates(editor);
}else if(editorStateWasCloned){
scheduleMicroTask(function(){
commitPendingUpdates(editor);
});
}
}else{
pendingEditorState._flushSync=false;
if(editorStateWasCloned){
updateTags.clear();
editor._deferred=[];
editor._pendingEditorState=null;
}
}
}
function updateEditor(editor,updateFn,options){
if(editor._updating){
editor._updates.push([updateFn,options]);
}else{
beginUpdate(editor,updateFn,options);
}
}var










DecoratorNode=function(_LexicalNode3){babelHelpers.inheritsLoose(DecoratorNode,_LexicalNode3);
function DecoratorNode(key){return(
_LexicalNode3.call(this,key)||this);
}var _proto8=DecoratorNode.prototype;_proto8.




decorate=function decorate(editor,config){
{
throw Error("decorate: base method not extended");
}
};_proto8.
isIsolated=function isIsolated(){
return false;
};_proto8.
isInline=function isInline(){
return true;
};_proto8.
isKeyboardSelectable=function isKeyboardSelectable(){
return true;
};return DecoratorNode;}(LexicalNode);

function $isDecoratorNode(node){
return node instanceof DecoratorNode;
}var









ElementNode=function(_LexicalNode4){babelHelpers.inheritsLoose(ElementNode,_LexicalNode4);












function ElementNode(key){var _this3;
_this3=_LexicalNode4.call(this,key)||this;
_this3.__first=null;
_this3.__last=null;
_this3.__size=0;
_this3.__format=0;
_this3.__indent=0;
_this3.__dir=null;return _this3;
}var _proto9=ElementNode.prototype;_proto9.
getFormat=function getFormat(){
var self=this.getLatest();
return self.__format;
};_proto9.
getFormatType=function getFormatType(){
var format=this.getFormat();
return ELEMENT_FORMAT_TO_TYPE[format]||'';
};_proto9.
getIndent=function getIndent(){
var self=this.getLatest();
return self.__indent;
};_proto9.
getChildren=function getChildren(){
var children=[];
var child=this.getFirstChild();
while(child!==null){
children.push(child);
child=child.getNextSibling();
}
return children;
};_proto9.
getChildrenKeys=function getChildrenKeys(){
var children=[];
var child=this.getFirstChild();
while(child!==null){
children.push(child.__key);
child=child.getNextSibling();
}
return children;
};_proto9.
getChildrenSize=function getChildrenSize(){
var self=this.getLatest();
return self.__size;
};_proto9.
isEmpty=function isEmpty(){
return this.getChildrenSize()===0;
};_proto9.
isDirty=function isDirty(){
var editor=getActiveEditor();
var dirtyElements=editor._dirtyElements;
return dirtyElements!==null&&dirtyElements.has(this.__key);
};_proto9.
isLastChild=function isLastChild(){
var self=this.getLatest();
var parentLastChild=this.getParentOrThrow().getLastChild();
return parentLastChild!==null&&parentLastChild.is(self);
};_proto9.
getAllTextNodes=function getAllTextNodes(){
var textNodes=[];
var child=this.getFirstChild();
while(child!==null){
if($isTextNode(child)){
textNodes.push(child);
}
if($isElementNode(child)){
var subChildrenNodes=child.getAllTextNodes();
textNodes.push.apply(textNodes,subChildrenNodes);
}
child=child.getNextSibling();
}
return textNodes;
};_proto9.
getFirstDescendant=function getFirstDescendant(){
var node=this.getFirstChild();
while(node!==null){
if($isElementNode(node)){
var child=node.getFirstChild();
if(child!==null){
node=child;
continue;
}
}
break;
}
return node;
};_proto9.
getLastDescendant=function getLastDescendant(){
var node=this.getLastChild();
while(node!==null){
if($isElementNode(node)){
var child=node.getLastChild();
if(child!==null){
node=child;
continue;
}
}
break;
}
return node;
};_proto9.
getDescendantByIndex=function getDescendantByIndex(index){
var children=this.getChildren();
var childrenLength=children.length;


if(index>=childrenLength){
var _resolvedNode=children[childrenLength-1];
return $isElementNode(_resolvedNode)&&_resolvedNode.getLastDescendant()||_resolvedNode||null;
}
var resolvedNode=children[index];
return $isElementNode(resolvedNode)&&resolvedNode.getFirstDescendant()||resolvedNode||null;
};_proto9.
getFirstChild=function getFirstChild(){
var self=this.getLatest();
var firstKey=self.__first;
return firstKey===null?null:$getNodeByKey(firstKey);
};_proto9.
getFirstChildOrThrow=function getFirstChildOrThrow(){
var firstChild=this.getFirstChild();
if(firstChild===null){
{
throw Error("Expected node "+this.__key+" to have a first child.");
}
}
return firstChild;
};_proto9.
getLastChild=function getLastChild(){
var self=this.getLatest();
var lastKey=self.__last;
return lastKey===null?null:$getNodeByKey(lastKey);
};_proto9.
getLastChildOrThrow=function getLastChildOrThrow(){
var lastChild=this.getLastChild();
if(lastChild===null){
{
throw Error("Expected node "+this.__key+" to have a last child.");
}
}
return lastChild;
};_proto9.
getChildAtIndex=function getChildAtIndex(index){
var size=this.getChildrenSize();
var node;
var i;
if(index<size/2){
node=this.getFirstChild();
i=0;
while(node!==null&&i<=index){
if(i===index){
return node;
}
node=node.getNextSibling();
i++;
}
return null;
}
node=this.getLastChild();
i=size-1;
while(node!==null&&i>=index){
if(i===index){
return node;
}
node=node.getPreviousSibling();
i--;
}
return null;
};_proto9.
getTextContent=function getTextContent(){
var textContent='';
var children=this.getChildren();
var childrenLength=children.length;
for(var i=0;i<childrenLength;i++){
var child=children[i];
textContent+=child.getTextContent();
if($isElementNode(child)&&i!==childrenLength-1&&!child.isInline()){
textContent+=DOUBLE_LINE_BREAK;
}
}
return textContent;
};_proto9.
getTextContentSize=function getTextContentSize(){
var textContentSize=0;
var children=this.getChildren();
var childrenLength=children.length;
for(var i=0;i<childrenLength;i++){
var child=children[i];
textContentSize+=child.getTextContentSize();
if($isElementNode(child)&&i!==childrenLength-1&&!child.isInline()){
textContentSize+=DOUBLE_LINE_BREAK.length;
}
}
return textContentSize;
};_proto9.
getDirection=function getDirection(){
var self=this.getLatest();
return self.__dir;
};_proto9.
hasFormat=function hasFormat(type){
if(type!==''){
var formatFlag=ELEMENT_TYPE_TO_FORMAT[type];
return(this.getFormat()&formatFlag)!==0;
}
return false;
};_proto9.



select=function select(_anchorOffset,_focusOffset){
errorOnReadOnly();
var selection=$getSelection();
var anchorOffset=_anchorOffset;
var focusOffset=_focusOffset;
var childrenCount=this.getChildrenSize();
if(!this.canBeEmpty()){
if(_anchorOffset===0&&_focusOffset===0){
var firstChild=this.getFirstChild();
if($isTextNode(firstChild)||$isElementNode(firstChild)){
return firstChild.select(0,0);
}
}else if((_anchorOffset===undefined||_anchorOffset===childrenCount)&&(_focusOffset===undefined||_focusOffset===childrenCount)){
var lastChild=this.getLastChild();
if($isTextNode(lastChild)||$isElementNode(lastChild)){
return lastChild.select();
}
}
}
if(anchorOffset===undefined){
anchorOffset=childrenCount;
}
if(focusOffset===undefined){
focusOffset=childrenCount;
}
var key=this.__key;
if(!$isRangeSelection(selection)){
return internalMakeRangeSelection(key,anchorOffset,key,focusOffset,'element','element');
}else{
selection.anchor.set(key,anchorOffset,'element');
selection.focus.set(key,focusOffset,'element');
selection.dirty=true;
}
return selection;
};_proto9.
selectStart=function selectStart(){
var firstNode=this.getFirstDescendant();
return firstNode?firstNode.selectStart():this.select();
};_proto9.
selectEnd=function selectEnd(){
var lastNode=this.getLastDescendant();
return lastNode?lastNode.selectEnd():this.select();
};_proto9.
clear=function clear(){
var writableSelf=this.getWritable();
var children=this.getChildren();
children.forEach(function(child){return child.remove();});
return writableSelf;
};_proto9.
append=function append(){for(var _len3=arguments.length,nodesToAppend=new Array(_len3),_key3=0;_key3<_len3;_key3++){nodesToAppend[_key3]=arguments[_key3];}
return this.splice(this.getChildrenSize(),0,nodesToAppend);
};_proto9.
setDirection=function setDirection(direction){
var self=this.getWritable();
self.__dir=direction;
return self;
};_proto9.
setFormat=function setFormat(type){
var self=this.getWritable();
self.__format=type!==''?ELEMENT_TYPE_TO_FORMAT[type]:0;
return this;
};_proto9.
setIndent=function setIndent(indentLevel){
var self=this.getWritable();
self.__indent=indentLevel;
return this;
};_proto9.
splice=function splice(start,deleteCount,nodesToInsert){
var nodesToInsertLength=nodesToInsert.length;
var oldSize=this.getChildrenSize();
var writableSelf=this.getWritable();
var writableSelfKey=writableSelf.__key;
var nodesToInsertKeys=[];
var nodesToRemoveKeys=[];
var nodeAfterRange=this.getChildAtIndex(start+deleteCount);
var nodeBeforeRange=null;
var newSize=oldSize-deleteCount+nodesToInsertLength;
if(start!==0){
if(start===oldSize){
nodeBeforeRange=this.getLastChild();
}else{
var node=this.getChildAtIndex(start);
if(node!==null){
nodeBeforeRange=node.getPreviousSibling();
}
}
}
if(deleteCount>0){
var nodeToDelete=nodeBeforeRange===null?this.getFirstChild():nodeBeforeRange.getNextSibling();
for(var i=0;i<deleteCount;i++){
if(nodeToDelete===null){
{
throw Error("splice: sibling not found");
}
}
var nextSibling=nodeToDelete.getNextSibling();
var nodeKeyToDelete=nodeToDelete.__key;
var writableNodeToDelete=nodeToDelete.getWritable();
removeFromParent(writableNodeToDelete);
nodesToRemoveKeys.push(nodeKeyToDelete);
nodeToDelete=nextSibling;
}
}
var prevNode=nodeBeforeRange;
for(var _i16=0;_i16<nodesToInsertLength;_i16++){
var nodeToInsert=nodesToInsert[_i16];
if(prevNode!==null&&nodeToInsert.is(prevNode)){
nodeBeforeRange=prevNode=prevNode.getPreviousSibling();
}
var writableNodeToInsert=nodeToInsert.getWritable();
if(writableNodeToInsert.__parent===writableSelfKey){
newSize--;
}
removeFromParent(writableNodeToInsert);
var nodeKeyToInsert=nodeToInsert.__key;
if(prevNode===null){
writableSelf.__first=nodeKeyToInsert;
writableNodeToInsert.__prev=null;
}else{
var writablePrevNode=prevNode.getWritable();
writablePrevNode.__next=nodeKeyToInsert;
writableNodeToInsert.__prev=writablePrevNode.__key;
}
if(nodeToInsert.__key===writableSelfKey){
{
throw Error("append: attempting to append self");
}
}

writableNodeToInsert.__parent=writableSelfKey;
nodesToInsertKeys.push(nodeKeyToInsert);
prevNode=nodeToInsert;
}
if(start+deleteCount===oldSize){
if(prevNode!==null){
var _writablePrevNode=prevNode.getWritable();
_writablePrevNode.__next=null;
writableSelf.__last=prevNode.__key;
}
}else if(nodeAfterRange!==null){
var writableNodeAfterRange=nodeAfterRange.getWritable();
if(prevNode!==null){
var _writablePrevNode2=prevNode.getWritable();
writableNodeAfterRange.__prev=prevNode.__key;
_writablePrevNode2.__next=nodeAfterRange.__key;
}else{
writableNodeAfterRange.__prev=null;
}
}
writableSelf.__size=newSize;




if(nodesToRemoveKeys.length){

var selection=$getSelection();
if($isRangeSelection(selection)){
var nodesToRemoveKeySet=new Set(nodesToRemoveKeys);
var nodesToInsertKeySet=new Set(nodesToInsertKeys);var

anchor=

selection.anchor,focus=selection.focus;
if(isPointRemoved(anchor,nodesToRemoveKeySet,nodesToInsertKeySet)){
moveSelectionPointToSibling(anchor,anchor.getNode(),this,nodeBeforeRange,nodeAfterRange);
}
if(isPointRemoved(focus,nodesToRemoveKeySet,nodesToInsertKeySet)){
moveSelectionPointToSibling(focus,focus.getNode(),this,nodeBeforeRange,nodeAfterRange);
}

if(newSize===0&&!this.canBeEmpty()&&!$isRootOrShadowRoot(this)){
this.remove();
}
}
}
return writableSelf;
};_proto9.

exportJSON=function exportJSON(){
return{
children:[],
direction:this.getDirection(),
format:this.getFormatType(),
indent:this.getIndent(),
type:'element',
version:1};

};_proto9.

insertNewAfter=function insertNewAfter(selection,restoreSelection){
return null;
};_proto9.
canIndent=function canIndent(){
return true;
};_proto9.





collapseAtStart=function collapseAtStart(selection){
return false;
};_proto9.
excludeFromCopy=function excludeFromCopy(destination){
return false;
};_proto9.
canReplaceWith=function canReplaceWith(replacement){
return true;
};_proto9.
canInsertAfter=function canInsertAfter(node){
return true;
};_proto9.
canBeEmpty=function canBeEmpty(){
return true;
};_proto9.
canInsertTextBefore=function canInsertTextBefore(){
return true;
};_proto9.
canInsertTextAfter=function canInsertTextAfter(){
return true;
};_proto9.
isInline=function isInline(){
return false;
};_proto9.




isShadowRoot=function isShadowRoot(){
return false;
};_proto9.
canMergeWith=function canMergeWith(node){
return false;
};_proto9.
extractWithChild=function extractWithChild(child,selection,destination){
return false;
};return ElementNode;}(LexicalNode);

function $isElementNode(node){
return node instanceof ElementNode;
}
function isPointRemoved(point,nodesToRemoveKeySet,nodesToInsertKeySet){
var node=point.getNode();
while(node){
var nodeKey=node.__key;
if(nodesToRemoveKeySet.has(nodeKey)&&!nodesToInsertKeySet.has(nodeKey)){
return true;
}
node=node.getParent();
}
return false;
}var









RootNode=function(_ElementNode){babelHelpers.inheritsLoose(RootNode,_ElementNode);RootNode.


getType=function getType(){
return'root';
};RootNode.
clone=function clone(){
return new RootNode();
};
function RootNode(){var _this4;
_this4=_ElementNode.call(this,'root')||this;
_this4.__cachedText=null;return _this4;
}var _proto10=RootNode.prototype;_proto10.
getTopLevelElementOrThrow=function getTopLevelElementOrThrow(){
{
throw Error("getTopLevelElementOrThrow: root nodes are not top level elements");
}
};_proto10.
getTextContent=function getTextContent(){
var cachedText=this.__cachedText;
if(isCurrentlyReadOnlyMode()||getActiveEditor()._dirtyType===NO_DIRTY_NODES){
if(cachedText!==null){
return cachedText;
}
}
return _ElementNode.prototype.getTextContent.call(this);
};_proto10.
remove=function remove(){
{
throw Error("remove: cannot be called on root nodes");
}
};_proto10.
replace=function replace(node){
{
throw Error("replace: cannot be called on root nodes");
}
};_proto10.
insertBefore=function insertBefore(nodeToInsert){
{
throw Error("insertBefore: cannot be called on root nodes");
}
};_proto10.
insertAfter=function insertAfter(nodeToInsert){
{
throw Error("insertAfter: cannot be called on root nodes");
}
};_proto10.



updateDOM=function updateDOM(prevNode,dom){
return false;
};_proto10.



append=function append(){var _ElementNode$prototyp;for(var _len4=arguments.length,nodesToAppend=new Array(_len4),_key4=0;_key4<_len4;_key4++){nodesToAppend[_key4]=arguments[_key4];}
for(var i=0;i<nodesToAppend.length;i++){
var node=nodesToAppend[i];
if(!$isElementNode(node)&&!$isDecoratorNode(node)){
{
throw Error("rootNode.append: Only element or decorator nodes can be appended to the root node");
}
}
}
return(_ElementNode$prototyp=_ElementNode.prototype.append).call.apply(_ElementNode$prototyp,[this].concat(nodesToAppend));
};RootNode.
importJSON=function importJSON(serializedNode){

var node=$getRoot();
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto10.
exportJSON=function exportJSON(){
return{
children:[],
direction:this.getDirection(),
format:this.getFormatType(),
indent:this.getIndent(),
type:'root',
version:1};

};_proto10.
collapseAtStart=function collapseAtStart(){
return true;
};return RootNode;}(ElementNode);

function $createRootNode(){
return new RootNode();
}
function $isRootNode(node){
return node instanceof RootNode;
}








function editorStateHasDirtySelection(editorState,editor){
var currentSelection=editor.getEditorState()._selection;
var pendingSelection=editorState._selection;


if(pendingSelection!==null){
if(pendingSelection.dirty||!pendingSelection.is(currentSelection)){
return true;
}
}else if(currentSelection!==null){
return true;
}
return false;
}
function cloneEditorState(current){
return new EditorState(new Map(current._nodeMap));
}
function createEmptyEditorState(){
return new EditorState(new Map([['root',$createRootNode()]]));
}
function exportNodeToJSON(node){
var serializedNode=node.exportJSON();
var nodeClass=node.constructor;
if(serializedNode.type!==nodeClass.getType()){
{
throw Error("LexicalNode: Node "+nodeClass.name+" does not match the serialized type. Check if .exportJSON() is implemented and it is returning the correct type.");
}
}
if($isElementNode(node)){
var serializedChildren=serializedNode.children;
if(!Array.isArray(serializedChildren)){
{
throw Error("LexicalNode: Node "+nodeClass.name+" is an element but .exportJSON() does not have a children array.");
}
}
var children=node.getChildren();
for(var i=0;i<children.length;i++){
var child=children[i];
var serializedChildNode=exportNodeToJSON(child);
serializedChildren.push(serializedChildNode);
}
}


return serializedNode;
}var
EditorState=function(){
function EditorState(nodeMap,selection){
this._nodeMap=nodeMap;
this._selection=selection||null;
this._flushSync=false;
this._readOnly=false;
}var _proto11=EditorState.prototype;_proto11.
isEmpty=function isEmpty(){
return this._nodeMap.size===1&&this._selection===null;
};_proto11.
read=function read(callbackFn){
return readEditorState(this,callbackFn);
};_proto11.
clone=function clone(selection){
var editorState=new EditorState(this._nodeMap,selection===undefined?this._selection:selection);
editorState._readOnly=true;
return editorState;
};_proto11.
toJSON=function toJSON(){
return readEditorState(this,function(){return{
root:exportNodeToJSON($getRoot())};});

};return EditorState;}();var










ParagraphNode=function(_ElementNode2){babelHelpers.inheritsLoose(ParagraphNode,_ElementNode2);function ParagraphNode(){return _ElementNode2.apply(this,arguments)||this;}ParagraphNode.
getType=function getType(){
return'paragraph';
};ParagraphNode.
clone=function clone(node){
return new ParagraphNode(node.__key);
};var _proto12=ParagraphNode.prototype;_proto12.



createDOM=function createDOM(config){
var dom=document.createElement('p');
var classNames=getCachedClassNameArray(config.theme,'paragraph');
if(classNames!==undefined){
var domClassList=dom.classList;
domClassList.add.apply(domClassList,classNames);
}
return dom;
};_proto12.
updateDOM=function updateDOM(prevNode,dom,config){
return false;
};ParagraphNode.
importDOM=function importDOM(){
return{
p:function p(node){return{
conversion:convertParagraphElement,
priority:0};}};


};_proto12.
exportDOM=function exportDOM(editor){var _ElementNode2$prototy=_ElementNode2.prototype.


exportDOM.call(this,editor),element=_ElementNode2$prototy.element;
if(element&&isHTMLElement(element)){
if(this.isEmpty())element.append(document.createElement('br'));
var formatType=this.getFormatType();
element.style.textAlign=formatType;
var direction=this.getDirection();
if(direction){
element.dir=direction;
}
var indent=this.getIndent();
if(indent>0){


element.style.textIndent=indent*20+"px";
}
}
return{
element:element};

};ParagraphNode.
importJSON=function importJSON(serializedNode){
var node=$createParagraphNode();
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto12.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_ElementNode2.prototype.
exportJSON.call(this),{
type:'paragraph',
version:1});

};_proto12.



insertNewAfter=function insertNewAfter(_,restoreSelection){
var newElement=$createParagraphNode();
var direction=this.getDirection();
newElement.setDirection(direction);
this.insertAfter(newElement,restoreSelection);
return newElement;
};_proto12.
collapseAtStart=function collapseAtStart(){
var children=this.getChildren();


if(children.length===0||$isTextNode(children[0])&&children[0].getTextContent().trim()===''){
var nextSibling=this.getNextSibling();
if(nextSibling!==null){
this.selectNext();
this.remove();
return true;
}
var prevSibling=this.getPreviousSibling();
if(prevSibling!==null){
this.selectPrevious();
this.remove();
return true;
}
}
return false;
};return ParagraphNode;}(ElementNode);

function convertParagraphElement(element){
var node=$createParagraphNode();
if(element.style){
node.setFormat(element.style.textAlign);
var indent=parseInt(element.style.textIndent,10)/20;
if(indent>0){
node.setIndent(indent);
}
}
return{
node:node};

}
function $createParagraphNode(){
return $applyNodeReplacement(new ParagraphNode());
}
function $isParagraphNode(node){
return node instanceof ParagraphNode;
}














var COMMAND_PRIORITY_EDITOR=0;
var COMMAND_PRIORITY_LOW=1;
var COMMAND_PRIORITY_NORMAL=2;
var COMMAND_PRIORITY_HIGH=3;
var COMMAND_PRIORITY_CRITICAL=4;
























function resetEditor(editor,prevRootElement,nextRootElement,pendingEditorState){
var keyNodeMap=editor._keyToDOMMap;
keyNodeMap.clear();
editor._editorState=createEmptyEditorState();
editor._pendingEditorState=pendingEditorState;
editor._compositionKey=null;
editor._dirtyType=NO_DIRTY_NODES;
editor._cloneNotNeeded.clear();
editor._dirtyLeaves=new Set();
editor._dirtyElements.clear();
editor._normalizedNodes=new Set();
editor._updateTags=new Set();
editor._updates=[];
editor._blockCursorElement=null;
var observer=editor._observer;
if(observer!==null){
observer.disconnect();
editor._observer=null;
}


if(prevRootElement!==null){
prevRootElement.textContent='';
}
if(nextRootElement!==null){
nextRootElement.textContent='';
keyNodeMap.set('root',nextRootElement);
}
}
function initializeConversionCache(nodes,additionalConversions){
var conversionCache=new Map();
var handledConversions=new Set();
var addConversionsToCache=function addConversionsToCache(map){
Object.keys(map).forEach(function(key){
var currentCache=conversionCache.get(key);
if(currentCache===undefined){
currentCache=[];
conversionCache.set(key,currentCache);
}
currentCache.push(map[key]);
});
};
nodes.forEach(function(node){
var importDOM=node.klass.importDOM!=null?node.klass.importDOM.bind(node.klass):null;
if(importDOM==null||handledConversions.has(importDOM)){
return;
}
handledConversions.add(importDOM);
var map=importDOM();
if(map!==null){
addConversionsToCache(map);
}
});
if(additionalConversions){
addConversionsToCache(additionalConversions);
}
return conversionCache;
}








function createEditor(editorConfig){
var config=editorConfig||{};
var activeEditor=internalGetActiveEditor();
var theme=config.theme||{};
var parentEditor=editorConfig===undefined?activeEditor:config.parentEditor||null;
var disableEvents=config.disableEvents||false;
var editorState=createEmptyEditorState();
var namespace=config.namespace||(parentEditor!==null?parentEditor._config.namespace:createUID());
var initialEditorState=config.editorState;
var nodes=[RootNode,TextNode,LineBreakNode,TabNode,ParagraphNode].concat(config.nodes||[]);var

onError=

config.onError,html=config.html;
var isEditable=config.editable!==undefined?config.editable:true;
var registeredNodes;
if(editorConfig===undefined&&activeEditor!==null){
registeredNodes=activeEditor._nodes;
}else{
registeredNodes=new Map();var _loop2=function _loop2(
i){
var klass=nodes[i];
var replace=null;
var replaceWithKlass=null;
if(typeof klass!=='function'){
var options=klass;
klass=options.replace;
replace=options["with"];
replaceWithKlass=options.withKlass||null;
}

{
var name=klass.name;
if(name!=='RootNode'){
var proto=klass.prototype;
['getType','clone'].forEach(function(method){

if(!Object.prototype.hasOwnProperty.call(klass,method)){
console.warn(name+" must implement static \""+method+"\" method");
}
});
if(

!Object.prototype.hasOwnProperty.call(klass,'importDOM')&&Object.prototype.hasOwnProperty.call(

klass,'exportDOM')){
console.warn(name+" should implement \"importDOM\" if using a custom \"exportDOM\" method to ensure HTML serialization (important for copy & paste) works as expected");
}
if(proto instanceof DecoratorNode){

if(!Object.prototype.hasOwnProperty.call(proto,'decorate')){
console.warn(proto.constructor.name+" must implement \"decorate\" method");
}
}
if(

!Object.prototype.hasOwnProperty.call(klass,'importJSON')){
console.warn(name+" should implement \"importJSON\" method to ensure JSON and default HTML serialization works as expected");
}
if(

!Object.prototype.hasOwnProperty.call(proto,'exportJSON')){
console.warn(name+" should implement \"exportJSON\" method to ensure JSON and default HTML serialization works as expected");
}
}
}
var type=klass.getType();
var transform=klass.transform();
var transforms=new Set();
if(transform!==null){
transforms.add(transform);
}
registeredNodes.set(type,{
exportDOM:html&&html["export"]?html["export"].get(klass):undefined,
klass:klass,
replace:replace,
replaceWithKlass:replaceWithKlass,
transforms:transforms});};for(var i=0;i<nodes.length;i++){_loop2(i);

}
}
var editor=new LexicalEditor(editorState,parentEditor,registeredNodes,{
disableEvents:disableEvents,
namespace:namespace,
theme:theme},
onError?onError:console.error,initializeConversionCache(registeredNodes,html?html["import"]:undefined),isEditable);
if(initialEditorState!==undefined){
editor._pendingEditorState=initialEditorState;
editor._dirtyType=FULL_RECONCILE;
}
return editor;
}var
LexicalEditor=function(){



























































function LexicalEditor(editorState,parentEditor,nodes,config,onError,htmlConversions,editable){
this._parentEditor=parentEditor;

this._rootElement=null;

this._editorState=editorState;

this._pendingEditorState=null;

this._compositionKey=null;
this._deferred=[];

this._keyToDOMMap=new Map();
this._updates=[];
this._updating=false;

this._listeners={
decorator:new Set(),
editable:new Set(),
mutation:new Map(),
root:new Set(),
textcontent:new Set(),
update:new Set()};


this._commands=new Map();

this._config=config;

this._nodes=nodes;

this._decorators={};
this._pendingDecorators=null;

this._dirtyType=NO_DIRTY_NODES;
this._cloneNotNeeded=new Set();
this._dirtyLeaves=new Set();
this._dirtyElements=new Map();
this._normalizedNodes=new Set();
this._updateTags=new Set();

this._observer=null;

this._key=createUID();
this._onError=onError;
this._htmlConversions=htmlConversions;
this._editable=editable;
this._headless=parentEditor!==null&&parentEditor._headless;
this._window=null;
this._blockCursorElement=null;
}var _proto13=LexicalEditor.prototype;_proto13.






isComposing=function isComposing(){
return this._compositionKey!=null;
};_proto13.







registerUpdateListener=function registerUpdateListener(listener){
var listenerSetOrMap=this._listeners.update;
listenerSetOrMap.add(listener);
return function(){
listenerSetOrMap["delete"](listener);
};
};_proto13.







registerEditableListener=function registerEditableListener(listener){
var listenerSetOrMap=this._listeners.editable;
listenerSetOrMap.add(listener);
return function(){
listenerSetOrMap["delete"](listener);
};
};_proto13.









registerDecoratorListener=function registerDecoratorListener(listener){
var listenerSetOrMap=this._listeners.decorator;
listenerSetOrMap.add(listener);
return function(){
listenerSetOrMap["delete"](listener);
};
};_proto13.










registerTextContentListener=function registerTextContentListener(listener){
var listenerSetOrMap=this._listeners.textcontent;
listenerSetOrMap.add(listener);
return function(){
listenerSetOrMap["delete"](listener);
};
};_proto13.











registerRootListener=function registerRootListener(listener){var _this6=this;
var listenerSetOrMap=this._listeners.root;
listener(this._rootElement,null);
listenerSetOrMap.add(listener);
return function(){
listener(null,_this6._rootElement);
listenerSetOrMap["delete"](listener);
};
};_proto13.












registerCommand=function registerCommand(command,listener,priority){
if(priority===undefined){
{
throw Error("Listener for type \"command\" requires a \"priority\".");
}
}
var commandsMap=this._commands;
if(!commandsMap.has(command)){
commandsMap.set(command,[new Set(),new Set(),new Set(),new Set(),new Set()]);
}
var listenersInPriorityOrder=commandsMap.get(command);
if(listenersInPriorityOrder===undefined){
{
throw Error("registerCommand: Command "+String(command)+" not found in command map");
}
}
var listeners=listenersInPriorityOrder[priority];
listeners.add(listener);
return function(){
listeners["delete"](listener);
if(listenersInPriorityOrder.every(function(listenersSet){return listenersSet.size===0;})){
commandsMap["delete"](command);
}
};
};_proto13.













registerMutationListener=function registerMutationListener(klass,listener){
var registeredNode=this._nodes.get(klass.getType());
if(registeredNode===undefined){
{
throw Error("Node "+klass.name+" has not been registered. Ensure node has been passed to createEditor.");
}
}
var mutations=this._listeners.mutation;
mutations.set(listener,klass);
return function(){
mutations["delete"](listener);
};
};_proto13.


registerNodeTransformToKlass=function registerNodeTransformToKlass(klass,listener){
var type=klass.getType();
var registeredNode=this._nodes.get(type);
if(registeredNode===undefined){
{
throw Error("Node "+klass.name+" has not been registered. Ensure node has been passed to createEditor.");
}
}
var transforms=registeredNode.transforms;
transforms.add(listener);
return registeredNode;
};_proto13.











registerNodeTransform=function registerNodeTransform(klass,listener){
var registeredNode=this.registerNodeTransformToKlass(klass,listener);
var registeredNodes=[registeredNode];
var replaceWithKlass=registeredNode.replaceWithKlass;
if(replaceWithKlass!=null){
var registeredReplaceWithNode=this.registerNodeTransformToKlass(replaceWithKlass,listener);
registeredNodes.push(registeredReplaceWithNode);
}
markAllNodesAsDirty(this,klass.getType());
return function(){
registeredNodes.forEach(function(node){return node.transforms["delete"](listener);});
};
};_proto13.






hasNode=function hasNode(node){
return this._nodes.has(node.getType());
};_proto13.






hasNodes=function hasNodes(nodes){
return nodes.every(this.hasNode.bind(this));
};_proto13.








dispatchCommand=function dispatchCommand(type,payload){
return _dispatchCommand(this,type,payload);
};_proto13.





getDecorators=function getDecorators(){
return this._decorators;
};_proto13.







getRootElement=function getRootElement(){
return this._rootElement;
};_proto13.





getKey=function getKey(){
return this._key;
};_proto13.





setRootElement=function setRootElement(nextRootElement){
var prevRootElement=this._rootElement;
if(nextRootElement!==prevRootElement){
var classNames=getCachedClassNameArray(this._config.theme,'root');
var pendingEditorState=this._pendingEditorState||this._editorState;
this._rootElement=nextRootElement;
resetEditor(this,prevRootElement,nextRootElement,pendingEditorState);
if(prevRootElement!==null){

if(!this._config.disableEvents){
removeRootElementEvents(prevRootElement);
}
if(classNames!=null){var _prevRootElement$clas;
(_prevRootElement$clas=prevRootElement.classList).remove.apply(_prevRootElement$clas,classNames);
}
}
if(nextRootElement!==null){
var windowObj=getDefaultView(nextRootElement);
var style=nextRootElement.style;
style.userSelect='text';
style.whiteSpace='pre-wrap';
style.wordBreak='break-word';
nextRootElement.setAttribute('data-lexical-editor','true');
this._window=windowObj;
this._dirtyType=FULL_RECONCILE;
initMutationObserver(this);
this._updateTags.add('history-merge');
commitPendingUpdates(this);


if(!this._config.disableEvents){
addRootElementEvents(nextRootElement,this);
}
if(classNames!=null){var _nextRootElement$clas;
(_nextRootElement$clas=nextRootElement.classList).add.apply(_nextRootElement$clas,classNames);
}
}else{


this._editorState=pendingEditorState;
this._pendingEditorState=null;
this._window=null;
}
triggerListeners('root',this,false,nextRootElement,prevRootElement);
}
};_proto13.






getElementByKey=function getElementByKey(key){
return this._keyToDOMMap.get(key)||null;
};_proto13.





getEditorState=function getEditorState(){
return this._editorState;
};_proto13.






setEditorState=function setEditorState(editorState,options){
if(editorState.isEmpty()){
{
throw Error("setEditorState: the editor state is empty. Ensure the editor state's root node never becomes empty.");
}
}
flushRootMutations(this);
var pendingEditorState=this._pendingEditorState;
var tags=this._updateTags;
var tag=options!==undefined?options.tag:null;
if(pendingEditorState!==null&&!pendingEditorState.isEmpty()){
if(tag!=null){
tags.add(tag);
}
commitPendingUpdates(this);
}
this._pendingEditorState=editorState;
this._dirtyType=FULL_RECONCILE;
this._dirtyElements.set('root',false);
this._compositionKey=null;
if(tag!=null){
tags.add(tag);
}
commitPendingUpdates(this);
};_proto13.









parseEditorState=function parseEditorState(maybeStringifiedEditorState,updateFn){
var serializedEditorState=typeof maybeStringifiedEditorState==='string'?JSON.parse(maybeStringifiedEditorState):maybeStringifiedEditorState;
return _parseEditorState(serializedEditorState,this,updateFn);
};_proto13.















update=function update(updateFn,options){
updateEditor(this,updateFn,options);
};_proto13.








focus=function focus(callbackFn,options){if(options===void 0){options={};}
var rootElement=this._rootElement;
if(rootElement!==null){

rootElement.setAttribute('autocapitalize','off');
updateEditor(this,function(){
var selection=$getSelection();
var root=$getRoot();
if(selection!==null){

selection.dirty=true;
}else if(root.getChildrenSize()!==0){
if(options.defaultSelection==='rootStart'){
root.selectStart();
}else{
root.selectEnd();
}
}
},{
onUpdate:function onUpdate(){
rootElement.removeAttribute('autocapitalize');
if(callbackFn){
callbackFn();
}
},
tag:'focus'});



if(this._pendingEditorState===null){
rootElement.removeAttribute('autocapitalize');
}
}
};_proto13.




blur=function blur(){
var rootElement=this._rootElement;
if(rootElement!==null){
rootElement.blur();
}
var domSelection=getDOMSelection(this._window);
if(domSelection!==null){
domSelection.removeAllRanges();
}
};_proto13.




isEditable=function isEditable(){
return this._editable;
};_proto13.





setEditable=function setEditable(editable){
if(this._editable!==editable){
this._editable=editable;
triggerListeners('editable',this,true,editable);
}
};_proto13.









toJSON=function toJSON(){
return{
editorState:this._editorState.toJSON()};

};return LexicalEditor;}();


exports.$addUpdateTag=$addUpdateTag;
exports.$applyNodeReplacement=$applyNodeReplacement;
exports.$copyNode=$copyNode;
exports.$createLineBreakNode=$createLineBreakNode;
exports.$createNodeSelection=$createNodeSelection;
exports.$createParagraphNode=$createParagraphNode;
exports.$createPoint=$createPoint;
exports.$createRangeSelection=$createRangeSelection;
exports.$createTabNode=$createTabNode;
exports.$createTextNode=$createTextNode;
exports.$getAdjacentNode=$getAdjacentNode;
exports.$getCharacterOffsets=$getCharacterOffsets;
exports.$getEditor=$getEditor;
exports.$getNearestNodeFromDOMNode=$getNearestNodeFromDOMNode;
exports.$getNearestRootOrShadowRoot=$getNearestRootOrShadowRoot;
exports.$getNodeByKey=$getNodeByKey;
exports.$getPreviousSelection=$getPreviousSelection;
exports.$getRoot=$getRoot;
exports.$getSelection=$getSelection;
exports.$getTextContent=$getTextContent;
exports.$hasAncestor=$hasAncestor;
exports.$hasUpdateTag=$hasUpdateTag;
exports.$insertNodes=$insertNodes;
exports.$isBlockElementNode=$isBlockElementNode;
exports.$isDecoratorNode=$isDecoratorNode;
exports.$isElementNode=$isElementNode;
exports.$isInlineElementOrDecoratorNode=$isInlineElementOrDecoratorNode;
exports.$isLeafNode=$isLeafNode;
exports.$isLineBreakNode=$isLineBreakNode;
exports.$isNodeSelection=$isNodeSelection;
exports.$isParagraphNode=$isParagraphNode;
exports.$isRangeSelection=$isRangeSelection;
exports.$isRootNode=$isRootNode;
exports.$isRootOrShadowRoot=$isRootOrShadowRoot;
exports.$isTabNode=$isTabNode;
exports.$isTextNode=$isTextNode;
exports.$nodesOfType=$nodesOfType;
exports.$normalizeSelection__EXPERIMENTAL=$normalizeSelection;
exports.$parseSerializedNode=$parseSerializedNode;
exports.$selectAll=$selectAll;
exports.$setCompositionKey=$setCompositionKey;
exports.$setSelection=$setSelection;
exports.$splitNode=$splitNode;
exports.BLUR_COMMAND=BLUR_COMMAND;
exports.CAN_REDO_COMMAND=CAN_REDO_COMMAND;
exports.CAN_UNDO_COMMAND=CAN_UNDO_COMMAND;
exports.CLEAR_EDITOR_COMMAND=CLEAR_EDITOR_COMMAND;
exports.CLEAR_HISTORY_COMMAND=CLEAR_HISTORY_COMMAND;
exports.CLICK_COMMAND=CLICK_COMMAND;
exports.COMMAND_PRIORITY_CRITICAL=COMMAND_PRIORITY_CRITICAL;
exports.COMMAND_PRIORITY_EDITOR=COMMAND_PRIORITY_EDITOR;
exports.COMMAND_PRIORITY_HIGH=COMMAND_PRIORITY_HIGH;
exports.COMMAND_PRIORITY_LOW=COMMAND_PRIORITY_LOW;
exports.COMMAND_PRIORITY_NORMAL=COMMAND_PRIORITY_NORMAL;
exports.CONTROLLED_TEXT_INSERTION_COMMAND=CONTROLLED_TEXT_INSERTION_COMMAND;
exports.COPY_COMMAND=COPY_COMMAND;
exports.CUT_COMMAND=CUT_COMMAND;
exports.DELETE_CHARACTER_COMMAND=DELETE_CHARACTER_COMMAND;
exports.DELETE_LINE_COMMAND=DELETE_LINE_COMMAND;
exports.DELETE_WORD_COMMAND=DELETE_WORD_COMMAND;
exports.DRAGEND_COMMAND=DRAGEND_COMMAND;
exports.DRAGOVER_COMMAND=DRAGOVER_COMMAND;
exports.DRAGSTART_COMMAND=DRAGSTART_COMMAND;
exports.DROP_COMMAND=DROP_COMMAND;
exports.DecoratorNode=DecoratorNode;
exports.ElementNode=ElementNode;
exports.FOCUS_COMMAND=FOCUS_COMMAND;
exports.FORMAT_ELEMENT_COMMAND=FORMAT_ELEMENT_COMMAND;
exports.FORMAT_TEXT_COMMAND=FORMAT_TEXT_COMMAND;
exports.INDENT_CONTENT_COMMAND=INDENT_CONTENT_COMMAND;
exports.INSERT_LINE_BREAK_COMMAND=INSERT_LINE_BREAK_COMMAND;
exports.INSERT_PARAGRAPH_COMMAND=INSERT_PARAGRAPH_COMMAND;
exports.INSERT_TAB_COMMAND=INSERT_TAB_COMMAND;
exports.KEY_ARROW_DOWN_COMMAND=KEY_ARROW_DOWN_COMMAND;
exports.KEY_ARROW_LEFT_COMMAND=KEY_ARROW_LEFT_COMMAND;
exports.KEY_ARROW_RIGHT_COMMAND=KEY_ARROW_RIGHT_COMMAND;
exports.KEY_ARROW_UP_COMMAND=KEY_ARROW_UP_COMMAND;
exports.KEY_BACKSPACE_COMMAND=KEY_BACKSPACE_COMMAND;
exports.KEY_DELETE_COMMAND=KEY_DELETE_COMMAND;
exports.KEY_DOWN_COMMAND=KEY_DOWN_COMMAND;
exports.KEY_ENTER_COMMAND=KEY_ENTER_COMMAND;
exports.KEY_ESCAPE_COMMAND=KEY_ESCAPE_COMMAND;
exports.KEY_MODIFIER_COMMAND=KEY_MODIFIER_COMMAND;
exports.KEY_SPACE_COMMAND=KEY_SPACE_COMMAND;
exports.KEY_TAB_COMMAND=KEY_TAB_COMMAND;
exports.LineBreakNode=LineBreakNode;
exports.MOVE_TO_END=MOVE_TO_END;
exports.MOVE_TO_START=MOVE_TO_START;
exports.OUTDENT_CONTENT_COMMAND=OUTDENT_CONTENT_COMMAND;
exports.PASTE_COMMAND=PASTE_COMMAND;
exports.ParagraphNode=ParagraphNode;
exports.REDO_COMMAND=REDO_COMMAND;
exports.REMOVE_TEXT_COMMAND=REMOVE_TEXT_COMMAND;
exports.RootNode=RootNode;
exports.SELECTION_CHANGE_COMMAND=SELECTION_CHANGE_COMMAND;
exports.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND=SELECTION_INSERT_CLIPBOARD_NODES_COMMAND;
exports.SELECT_ALL_COMMAND=SELECT_ALL_COMMAND;
exports.TabNode=TabNode;
exports.TextNode=TextNode;
exports.UNDO_COMMAND=UNDO_COMMAND;
exports.createCommand=createCommand;
exports.createEditor=createEditor;
exports.getNearestEditorFromDOMNode=getNearestEditorFromDOMNode;
exports.isCurrentlyReadOnlyMode=isCurrentlyReadOnlyMode;
exports.isHTMLAnchorElement=isHTMLAnchorElement;
exports.isHTMLElement=isHTMLElement;
exports.isSelectionCapturedInDecoratorInput=isSelectionCapturedInDecoratorInput;
exports.isSelectionWithinEditor=isSelectionWithinEditor;}),null);