/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalClipboard.dev",["Lexical","LexicalHtml","LexicalSelection","LexicalUtils","Promise","regeneratorRuntime"],(function $module_LexicalClipboard_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_Promise;














var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var getDOMSelection=function getDOMSelection(targetWindow){return CAN_USE_DOM?(targetWindow||window).getSelection():null;};










function $getHtmlContent(editor){
var selection=require("Lexical").$getSelection();
if(selection==null){
{
throw Error("Expected valid LexicalSelection");
}
}


if(require("Lexical").$isRangeSelection(selection)&&selection.isCollapsed()||selection.getNodes().length===0){
return'';
}
return require("LexicalHtml").$generateHtmlFromNodes(editor,selection);
}










function $getLexicalContent(editor){
var selection=require("Lexical").$getSelection();
if(selection==null){
{
throw Error("Expected valid LexicalSelection");
}
}


if(require("Lexical").$isRangeSelection(selection)&&selection.isCollapsed()||selection.getNodes().length===0){
return null;
}
return JSON.stringify($generateJSONFromSelectedNodes(editor,selection));
}









function $insertDataTransferForPlainText(dataTransfer,selection){
var text=dataTransfer.getData('text/plain')||dataTransfer.getData('text/uri-list');
if(text!=null){
selection.insertRawText(text);
}
}










function $insertDataTransferForRichText(dataTransfer,selection,editor){
var lexicalString=dataTransfer.getData('application/x-lexical-editor');
if(lexicalString){
try{
var payload=JSON.parse(lexicalString);
if(payload.namespace===editor._config.namespace&&Array.isArray(payload.nodes)){
var nodes=$generateNodesFromSerializedNodes(payload.nodes);
return $insertGeneratedNodes(editor,nodes,selection);
}
}catch(_unused){

}
}
var htmlString=dataTransfer.getData('text/html');
if(htmlString){
try{
var parser=new DOMParser();
var dom=parser.parseFromString(htmlString,'text/html');
var _nodes=require("LexicalHtml").$generateNodesFromDOM(editor,dom);
return $insertGeneratedNodes(editor,_nodes,selection);
}catch(_unused2){

}
}




var text=dataTransfer.getData('text/plain')||dataTransfer.getData('text/uri-list');
if(text!=null){
if(require("Lexical").$isRangeSelection(selection)){
var parts=text.split(/(\r?\n|\t)/);
if(parts[parts.length-1]===''){
parts.pop();
}
for(var i=0;i<parts.length;i++){
var part=parts[i];
if(part==='\n'||part==='\r\n'){
selection.insertParagraph();
}else if(part==='\t'){
selection.insertNodes([require("Lexical").$createTabNode()]);
}else{
selection.insertText(part);
}
}
}else{
selection.insertRawText(text);
}
}
}











function $insertGeneratedNodes(editor,nodes,selection){
if(!editor.dispatchCommand(require("Lexical").SELECTION_INSERT_CLIPBOARD_NODES_COMMAND,{
nodes:nodes,
selection:selection}))
{
selection.insertNodes(nodes);
}
return;
}
function exportNodeToJSON(node){
var serializedNode=node.exportJSON();
var nodeClass=node.constructor;
if(serializedNode.type!==nodeClass.getType()){
{
throw Error("LexicalNode: Node "+nodeClass.name+" does not implement .exportJSON().");
}
}
if(require("Lexical").$isElementNode(node)){
var serializedChildren=serializedNode.children;
if(!Array.isArray(serializedChildren)){
{
throw Error("LexicalNode: Node "+nodeClass.name+" is an element but .exportJSON() does not have a children array.");
}
}
}
return serializedNode;
}
function $appendNodesToJSON(editor,selection,currentNode,targetArray){if(targetArray===void 0){targetArray=[];}
var shouldInclude=selection!==null?currentNode.isSelected(selection):true;
var shouldExclude=require("Lexical").$isElementNode(currentNode)&&currentNode.excludeFromCopy('html');
var target=currentNode;
if(selection!==null){
var clone=require("LexicalSelection").$cloneWithProperties(currentNode);
clone=require("Lexical").$isTextNode(clone)&&selection!==null?require("LexicalSelection").$sliceSelectedTextNodeContent(selection,clone):clone;
target=clone;
}
var children=require("Lexical").$isElementNode(target)?target.getChildren():[];
var serializedNode=exportNodeToJSON(target);







if(require("Lexical").$isTextNode(target)){
var text=target.__text;



if(text.length>0){
serializedNode.text=text;
}else{
shouldInclude=false;
}
}
for(var i=0;i<children.length;i++){
var childNode=children[i];
var shouldIncludeChild=$appendNodesToJSON(editor,selection,childNode,serializedNode.children);
if(!shouldInclude&&require("Lexical").$isElementNode(currentNode)&&shouldIncludeChild&&currentNode.extractWithChild(childNode,selection,'clone')){
shouldInclude=true;
}
}
if(shouldInclude&&!shouldExclude){
targetArray.push(serializedNode);
}else if(Array.isArray(serializedNode.children)){
for(var _i=0;_i<serializedNode.children.length;_i++){
var serializedChildNode=serializedNode.children[_i];
targetArray.push(serializedChildNode);
}
}
return shouldInclude;
}









function $generateJSONFromSelectedNodes(editor,selection){
var nodes=[];
var root=require("Lexical").$getRoot();
var topLevelChildren=root.getChildren();
for(var i=0;i<topLevelChildren.length;i++){
var topLevelNode=topLevelChildren[i];
$appendNodesToJSON(editor,selection,topLevelNode,nodes);
}
return{
namespace:editor._config.namespace,
nodes:nodes};

}









function $generateNodesFromSerializedNodes(serializedNodes){
var nodes=[];
for(var i=0;i<serializedNodes.length;i++){
var serializedNode=serializedNodes[i];
var node=require("Lexical").$parseSerializedNode(serializedNode);
if(require("Lexical").$isTextNode(node)){
require("LexicalSelection").$addNodeStyle(node);
}
nodes.push(node);
}
return nodes;
}
var EVENT_LATENCY=50;
var clipboardEventTimeout=null;












function copyToClipboard(editor,event){var rootElement,windowDocument,domSelection,element,range;return require("regeneratorRuntime").async(function copyToClipboard$(_context){while(1){switch(_context.prev=_context.next){case 0:if(!(
clipboardEventTimeout!==null)){_context.next=2;break;}return _context.abrupt("return",


false);case 2:if(!(

event!==null)){_context.next=4;break;}return _context.abrupt("return",
new(_require_closure_Promise||(_require_closure_Promise=require("Promise")))(function(resolve,reject){
editor.update(function(){
resolve($copyToClipboardEvent(editor,event));
});
}));case 4:

rootElement=editor.getRootElement();
windowDocument=editor._window==null?window.document:editor._window.document;
domSelection=getDOMSelection(editor._window);if(!(
rootElement===null||domSelection===null)){_context.next=9;break;}return _context.abrupt("return",
false);case 9:

element=windowDocument.createElement('span');
element.style.cssText='position: fixed; top: -1000px;';
element.append(windowDocument.createTextNode('#'));
rootElement.append(element);
range=new Range();
range.setStart(element,0);
range.setEnd(element,1);
domSelection.removeAllRanges();
domSelection.addRange(range);return _context.abrupt("return",
new(_require_closure_Promise||(_require_closure_Promise=require("Promise")))(function(resolve,reject){
var removeListener=editor.registerCommand(require("Lexical").COPY_COMMAND,function(secondEvent){
if(require("LexicalUtils").objectKlassEquals(secondEvent,ClipboardEvent)){
removeListener();
if(clipboardEventTimeout!==null){
window.clearTimeout(clipboardEventTimeout);
clipboardEventTimeout=null;
}
resolve($copyToClipboardEvent(editor,secondEvent));
}

return true;
},require("Lexical").COMMAND_PRIORITY_CRITICAL);


clipboardEventTimeout=window.setTimeout(function(){
removeListener();
clipboardEventTimeout=null;
resolve(false);
},EVENT_LATENCY);
windowDocument.execCommand('copy');
element.remove();
}));case 19:case"end":return _context.stop();}}},null,this);}



function $copyToClipboardEvent(editor,event){
var domSelection=getDOMSelection(editor._window);
if(!domSelection){
return false;
}
var anchorDOM=domSelection.anchorNode;
var focusDOM=domSelection.focusNode;
if(anchorDOM!==null&&focusDOM!==null&&!require("Lexical").isSelectionWithinEditor(editor,anchorDOM,focusDOM)){
return false;
}
event.preventDefault();
var clipboardData=event.clipboardData;
var selection=require("Lexical").$getSelection();
if(clipboardData===null||selection===null){
return false;
}
var htmlString=$getHtmlContent(editor);
var lexicalString=$getLexicalContent(editor);
var plainString='';
if(selection!==null){
plainString=selection.getTextContent();
}
if(htmlString!==null){
clipboardData.setData('text/html',htmlString);
}
if(lexicalString!==null){
clipboardData.setData('application/x-lexical-editor',lexicalString);
}
clipboardData.setData('text/plain',plainString);
return true;
}

exports.$generateJSONFromSelectedNodes=$generateJSONFromSelectedNodes;
exports.$generateNodesFromSerializedNodes=$generateNodesFromSerializedNodes;
exports.$getHtmlContent=$getHtmlContent;
exports.$getLexicalContent=$getLexicalContent;
exports.$insertDataTransferForPlainText=$insertDataTransferForPlainText;
exports.$insertDataTransferForRichText=$insertDataTransferForRichText;
exports.$insertGeneratedNodes=$insertGeneratedNodes;
exports.copyToClipboard=copyToClipboard;}),null);