/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalYjs.dev",["Lexical","LexicalOffset","LexicalSelection","yjs"],(function $module_LexicalYjs_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var













CollabLineBreakNode=function(){
function CollabLineBreakNode(map,parent){
this._key='';
this._map=map;
this._parent=parent;
this._type='linebreak';
}var _proto=CollabLineBreakNode.prototype;_proto.
getNode=function getNode(){
var node=require("Lexical").$getNodeByKey(this._key);
return require("Lexical").$isLineBreakNode(node)?node:null;
};_proto.
getKey=function getKey(){
return this._key;
};_proto.
getSharedType=function getSharedType(){
return this._map;
};_proto.
getType=function getType(){
return this._type;
};_proto.
getSize=function getSize(){
return 1;
};_proto.
getOffset=function getOffset(){
var collabElementNode=this._parent;
return collabElementNode.getChildOffset(this);
};_proto.
destroy=function destroy(binding){
var collabNodeMap=binding.collabNodeMap;
collabNodeMap["delete"](this._key);
};return CollabLineBreakNode;}();

function $createCollabLineBreakNode(map,parent){
var collabNode=new CollabLineBreakNode(map,parent);
map._collabNode=collabNode;
return collabNode;
}









function simpleDiffWithCursor(a,b,cursor){
var aLength=a.length;
var bLength=b.length;
var left=0;
var right=0;


while(left<aLength&&left<bLength&&a[left]===b[left]&&left<cursor){
left++;
}

while(right+left<aLength&&right+left<bLength&&a[aLength-right-1]===b[bLength-right-1]){
right++;
}

while(right+left<aLength&&right+left<bLength&&a[left]===b[left]){
left++;
}
return{
index:left,
insert:b.slice(left,bLength-right),
remove:aLength-left-right};

}








function diffTextContentAndApplyDelta(collabNode,key,prevText,nextText){
var selection=require("Lexical").$getSelection();
var cursorOffset=nextText.length;
if(require("Lexical").$isRangeSelection(selection)&&selection.isCollapsed()){
var anchor=selection.anchor;
if(anchor.key===key){
cursorOffset=anchor.offset;
}
}
var diff=simpleDiffWithCursor(prevText,nextText,cursorOffset);
collabNode.spliceText(diff.index,diff.remove,diff.insert);
}var
CollabTextNode=function(){
function CollabTextNode(map,text,parent,type){
this._key='';
this._map=map;
this._parent=parent;
this._text=text;
this._type=type;
this._normalized=false;
}var _proto2=CollabTextNode.prototype;_proto2.
getPrevNode=function getPrevNode(nodeMap){
if(nodeMap===null){
return null;
}
var node=nodeMap.get(this._key);
return require("Lexical").$isTextNode(node)?node:null;
};_proto2.
getNode=function getNode(){
var node=require("Lexical").$getNodeByKey(this._key);
return require("Lexical").$isTextNode(node)?node:null;
};_proto2.
getSharedType=function getSharedType(){
return this._map;
};_proto2.
getType=function getType(){
return this._type;
};_proto2.
getKey=function getKey(){
return this._key;
};_proto2.
getSize=function getSize(){
return this._text.length+(this._normalized?0:1);
};_proto2.
getOffset=function getOffset(){
var collabElementNode=this._parent;
return collabElementNode.getChildOffset(this);
};_proto2.
spliceText=function spliceText(index,delCount,newText){
var collabElementNode=this._parent;
var xmlText=collabElementNode._xmlText;
var offset=this.getOffset()+1+index;
if(delCount!==0){
xmlText["delete"](offset,delCount);
}
if(newText!==''){
xmlText.insert(offset,newText);
}
};_proto2.
syncPropertiesAndTextFromLexical=function syncPropertiesAndTextFromLexical(binding,nextLexicalNode,prevNodeMap){
var prevLexicalNode=this.getPrevNode(prevNodeMap);
var nextText=nextLexicalNode.__text;
_syncPropertiesFromLexical(binding,this._map,prevLexicalNode,nextLexicalNode);
if(prevLexicalNode!==null){
var prevText=prevLexicalNode.__text;
if(prevText!==nextText){
var key=nextLexicalNode.__key;
diffTextContentAndApplyDelta(this,key,prevText,nextText);
this._text=nextText;
}
}
};_proto2.
syncPropertiesAndTextFromYjs=function syncPropertiesAndTextFromYjs(binding,keysChanged){
var lexicalNode=this.getNode();
if(!(lexicalNode!==null)){
throw Error("syncPropertiesAndTextFromYjs: cound not find decorator node");
}
_syncPropertiesFromYjs(binding,this._map,lexicalNode,keysChanged);
var collabText=this._text;
if(lexicalNode.__text!==collabText){
var writable=lexicalNode.getWritable();
writable.__text=collabText;
}
};_proto2.
destroy=function destroy(binding){
var collabNodeMap=binding.collabNodeMap;
collabNodeMap["delete"](this._key);
};return CollabTextNode;}();

function $createCollabTextNode(map,text,parent,type){
var collabNode=new CollabTextNode(map,text,parent,type);
map._collabNode=collabNode;
return collabNode;
}








var baseExcludedProperties=new Set(['__key','__parent','__next','__prev']);
var elementExcludedProperties=new Set(['__first','__last','__size']);
var rootExcludedProperties=new Set(['__cachedText']);
var textExcludedProperties=new Set(['__text']);
function isExcludedProperty(name,node,binding){
if(baseExcludedProperties.has(name)){
return true;
}
if(require("Lexical").$isTextNode(node)){
if(textExcludedProperties.has(name)){
return true;
}
}else if(require("Lexical").$isElementNode(node)){
if(elementExcludedProperties.has(name)||require("Lexical").$isRootNode(node)&&rootExcludedProperties.has(name)){
return true;
}
}
var nodeKlass=node.constructor;
var excludedProperties=binding.excludedProperties.get(nodeKlass);
return excludedProperties!=null&&excludedProperties.has(name);
}
function $getNodeByKeyOrThrow(key){
var node=require("Lexical").$getNodeByKey(key);
if(!(node!==null)){
throw Error("could not find node by key");
}
return node;
}
function $createCollabNodeFromLexicalNode(binding,lexicalNode,parent){
var nodeType=lexicalNode.__type;
var collabNode;
if(require("Lexical").$isElementNode(lexicalNode)){
var xmlText=new(require("yjs").XmlText)();
collabNode=$createCollabElementNode(xmlText,parent,nodeType);
collabNode.syncPropertiesFromLexical(binding,lexicalNode,null);
collabNode.syncChildrenFromLexical(binding,lexicalNode,null,null,null);
}else if(require("Lexical").$isTextNode(lexicalNode)){

var map=new(require("yjs").Map)();
collabNode=$createCollabTextNode(map,lexicalNode.__text,parent,nodeType);
collabNode.syncPropertiesAndTextFromLexical(binding,lexicalNode,null);
}else if(require("Lexical").$isLineBreakNode(lexicalNode)){
var _map=new(require("yjs").Map)();
_map.set('__type','linebreak');
collabNode=$createCollabLineBreakNode(_map,parent);
}else if(require("Lexical").$isDecoratorNode(lexicalNode)){
var xmlElem=new(require("yjs").XmlElement)();
collabNode=$createCollabDecoratorNode(xmlElem,parent,nodeType);
collabNode.syncPropertiesFromLexical(binding,lexicalNode,null);
}else{
{
throw Error("Expected text, element, decorator, or linebreak node");
}
}
collabNode._key=lexicalNode.__key;
return collabNode;
}
function getNodeTypeFromSharedType(sharedType){
var type=sharedType instanceof require("yjs").Map?sharedType.get('__type'):sharedType.getAttribute('__type');
if(!(type!=null)){
throw Error("Expected shared type to include type attribute");
}
return type;
}
function getOrInitCollabNodeFromSharedType(binding,sharedType,parent){
var collabNode=sharedType._collabNode;
if(collabNode===undefined){
var registeredNodes=binding.editor._nodes;
var type=getNodeTypeFromSharedType(sharedType);
var nodeInfo=registeredNodes.get(type);
if(!(nodeInfo!==undefined)){
throw Error("Node "+type+" is not registered");
}
var sharedParent=sharedType.parent;
var targetParent=parent===undefined&&sharedParent!==null?getOrInitCollabNodeFromSharedType(binding,sharedParent):parent||null;
if(!(targetParent instanceof CollabElementNode)){
throw Error("Expected parent to be a collab element node");
}
if(sharedType instanceof require("yjs").XmlText){
return $createCollabElementNode(sharedType,targetParent,type);
}else if(sharedType instanceof require("yjs").Map){
if(type==='linebreak'){
return $createCollabLineBreakNode(sharedType,targetParent);
}
return $createCollabTextNode(sharedType,'',targetParent,type);
}else if(sharedType instanceof require("yjs").XmlElement){
return $createCollabDecoratorNode(sharedType,targetParent,type);
}
}
return collabNode;
}
function createLexicalNodeFromCollabNode(binding,collabNode,parentKey){
var type=collabNode.getType();
var registeredNodes=binding.editor._nodes;
var nodeInfo=registeredNodes.get(type);
if(!(nodeInfo!==undefined)){
throw Error("Node "+type+" is not registered");
}
var lexicalNode=new nodeInfo.klass();
lexicalNode.__parent=parentKey;
collabNode._key=lexicalNode.__key;
if(collabNode instanceof CollabElementNode){
var xmlText=collabNode._xmlText;
collabNode.syncPropertiesFromYjs(binding,null);
collabNode.applyChildrenYjsDelta(binding,xmlText.toDelta());
collabNode.syncChildrenFromYjs(binding);
}else if(collabNode instanceof CollabTextNode){
collabNode.syncPropertiesAndTextFromYjs(binding,null);
}else if(collabNode instanceof CollabDecoratorNode){
collabNode.syncPropertiesFromYjs(binding,null);
}
binding.collabNodeMap.set(lexicalNode.__key,collabNode);
return lexicalNode;
}
function _syncPropertiesFromYjs(binding,sharedType,lexicalNode,keysChanged){
var properties=keysChanged===null?sharedType instanceof require("yjs").Map?Array.from(sharedType.keys()):Object.keys(sharedType.getAttributes()):Array.from(keysChanged);
var writableNode;
for(var i=0;i<properties.length;i++){
var property=properties[i];
if(isExcludedProperty(property,lexicalNode,binding)){
continue;
}

var prevValue=lexicalNode[property];
var nextValue=sharedType instanceof require("yjs").Map?sharedType.get(property):sharedType.getAttribute(property);
if(prevValue!==nextValue){
if(nextValue instanceof require("yjs").Doc){
var yjsDocMap=binding.docMap;
if(prevValue instanceof require("yjs").Doc){
yjsDocMap["delete"](prevValue.guid);
}
var nestedEditor=require("Lexical").createEditor();
var key=nextValue.guid;
nestedEditor._key=key;
yjsDocMap.set(key,nextValue);
nextValue=nestedEditor;
}
if(writableNode===undefined){
writableNode=lexicalNode.getWritable();
}
writableNode[property]=nextValue;
}
}
}
function _syncPropertiesFromLexical(binding,sharedType,prevLexicalNode,nextLexicalNode){
var type=nextLexicalNode.__type;
var nodeProperties=binding.nodeProperties;
var properties=nodeProperties.get(type);
if(properties===undefined){
properties=Object.keys(nextLexicalNode).filter(function(property){
return!isExcludedProperty(property,nextLexicalNode,binding);
});
nodeProperties.set(type,properties);
}
var EditorClass=binding.editor.constructor;
for(var i=0;i<properties.length;i++){
var property=properties[i];
var prevValue=

prevLexicalNode===null?undefined:prevLexicalNode[property];

var nextValue=nextLexicalNode[property];
if(prevValue!==nextValue){
if(nextValue instanceof EditorClass){
var yjsDocMap=binding.docMap;
var prevDoc=void 0;
if(prevValue instanceof EditorClass){
var prevKey=prevValue._key;
prevDoc=yjsDocMap.get(prevKey);
yjsDocMap["delete"](prevKey);
}


var doc=prevDoc||new(require("yjs").Doc)();
var key=doc.guid;
nextValue._key=key;
yjsDocMap.set(key,doc);
nextValue=doc;

binding.editor.update(function(){
nextLexicalNode.markDirty();
});
}
if(sharedType instanceof require("yjs").Map){
sharedType.set(property,nextValue);
}else{
sharedType.setAttribute(property,nextValue);
}
}
}
}
function spliceString(str,index,delCount,newText){
return str.slice(0,index)+newText+str.slice(index+delCount);
}
function getPositionFromElementAndOffset(node,offset,boundaryIsEdge){
var index=0;
var i=0;
var children=node._children;
var childrenLength=children.length;
for(;i<childrenLength;i++){
var child=children[i];
var childOffset=index;
var size=child.getSize();
index+=size;
var exceedsBoundary=boundaryIsEdge?index>=offset:index>offset;
if(exceedsBoundary&&child instanceof CollabTextNode){
var textOffset=offset-childOffset-1;
if(textOffset<0){
textOffset=0;
}
var diffLength=index-offset;
return{
length:diffLength,
node:child,
nodeIndex:i,
offset:textOffset};

}
if(index>offset){
return{
length:0,
node:child,
nodeIndex:i,
offset:childOffset};

}else if(i===childrenLength-1){
return{
length:0,
node:null,
nodeIndex:i+1,
offset:childOffset+1};

}
}
return{
length:0,
node:null,
nodeIndex:0,
offset:0};

}
function doesSelectionNeedRecovering(selection){
var anchor=selection.anchor;
var focus=selection.focus;
var recoveryNeeded=false;
try{
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if(

!anchorNode.isAttached()||!focusNode.isAttached()||

require("Lexical").$isTextNode(anchorNode)&&anchor.offset>anchorNode.getTextContentSize()||require("Lexical").$isTextNode(focusNode)&&focus.offset>focusNode.getTextContentSize()){
recoveryNeeded=true;
}
}catch(e){


recoveryNeeded=true;
}
return recoveryNeeded;
}
function syncWithTransaction(binding,fn){
binding.doc.transact(fn,binding);
}
function createChildrenArray(element,nodeMap){
var children=[];
var nodeKey=element.__first;
while(nodeKey!==null){
var node=nodeMap===null?require("Lexical").$getNodeByKey(nodeKey):nodeMap.get(nodeKey);
if(node===null||node===undefined){
{
throw Error("createChildrenArray: node does not exist in nodeMap");
}
}
children.push(nodeKey);
nodeKey=node.__next;
}
return children;
}
function removeFromParent(node){
var oldParent=node.getParent();
if(oldParent!==null){
var writableNode=node.getWritable();
var writableParent=oldParent.getWritable();
var prevSibling=node.getPreviousSibling();
var nextSibling=node.getNextSibling();

if(prevSibling===null){
if(nextSibling!==null){
var writableNextSibling=nextSibling.getWritable();
writableParent.__first=nextSibling.__key;
writableNextSibling.__prev=null;
}else{
writableParent.__first=null;
}
}else{
var writablePrevSibling=prevSibling.getWritable();
if(nextSibling!==null){
var _writableNextSibling=nextSibling.getWritable();
_writableNextSibling.__prev=writablePrevSibling.__key;
writablePrevSibling.__next=_writableNextSibling.__key;
}else{
writablePrevSibling.__next=null;
}
writableNode.__prev=null;
}
if(nextSibling===null){
if(prevSibling!==null){
var _writablePrevSibling=prevSibling.getWritable();
writableParent.__last=prevSibling.__key;
_writablePrevSibling.__next=null;
}else{
writableParent.__last=null;
}
}else{
var _writableNextSibling2=nextSibling.getWritable();
if(prevSibling!==null){
var _writablePrevSibling2=prevSibling.getWritable();
_writablePrevSibling2.__next=_writableNextSibling2.__key;
_writableNextSibling2.__prev=_writablePrevSibling2.__key;
}else{
_writableNextSibling2.__prev=null;
}
writableNode.__next=null;
}
writableParent.__size--;
writableNode.__parent=null;
}
}var








CollabDecoratorNode=function(){
function CollabDecoratorNode(xmlElem,parent,type){
this._key='';
this._xmlElem=xmlElem;
this._parent=parent;
this._type=type;
}var _proto3=CollabDecoratorNode.prototype;_proto3.
getPrevNode=function getPrevNode(nodeMap){
if(nodeMap===null){
return null;
}
var node=nodeMap.get(this._key);
return require("Lexical").$isDecoratorNode(node)?node:null;
};_proto3.
getNode=function getNode(){
var node=require("Lexical").$getNodeByKey(this._key);
return require("Lexical").$isDecoratorNode(node)?node:null;
};_proto3.
getSharedType=function getSharedType(){
return this._xmlElem;
};_proto3.
getType=function getType(){
return this._type;
};_proto3.
getKey=function getKey(){
return this._key;
};_proto3.
getSize=function getSize(){
return 1;
};_proto3.
getOffset=function getOffset(){
var collabElementNode=this._parent;
return collabElementNode.getChildOffset(this);
};_proto3.
syncPropertiesFromLexical=function syncPropertiesFromLexical(binding,nextLexicalNode,prevNodeMap){
var prevLexicalNode=this.getPrevNode(prevNodeMap);
var xmlElem=this._xmlElem;
_syncPropertiesFromLexical(binding,xmlElem,prevLexicalNode,nextLexicalNode);
};_proto3.
syncPropertiesFromYjs=function syncPropertiesFromYjs(binding,keysChanged){
var lexicalNode=this.getNode();
if(!(lexicalNode!==null)){
throw Error("syncPropertiesFromYjs: cound not find decorator node");
}
var xmlElem=this._xmlElem;
_syncPropertiesFromYjs(binding,xmlElem,lexicalNode,keysChanged);
};_proto3.
destroy=function destroy(binding){
var collabNodeMap=binding.collabNodeMap;
collabNodeMap["delete"](this._key);
};return CollabDecoratorNode;}();

function $createCollabDecoratorNode(xmlElem,parent,type){
var collabNode=new CollabDecoratorNode(xmlElem,parent,type);
xmlElem._collabNode=collabNode;
return collabNode;
}var








CollabElementNode=function(){
function CollabElementNode(xmlText,parent,type){
this._key='';
this._children=[];
this._xmlText=xmlText;
this._type=type;
this._parent=parent;
}var _proto4=CollabElementNode.prototype;_proto4.
getPrevNode=function getPrevNode(nodeMap){
if(nodeMap===null){
return null;
}
var node=nodeMap.get(this._key);
return require("Lexical").$isElementNode(node)?node:null;
};_proto4.
getNode=function getNode(){
var node=require("Lexical").$getNodeByKey(this._key);
return require("Lexical").$isElementNode(node)?node:null;
};_proto4.
getSharedType=function getSharedType(){
return this._xmlText;
};_proto4.
getType=function getType(){
return this._type;
};_proto4.
getKey=function getKey(){
return this._key;
};_proto4.
isEmpty=function isEmpty(){
return this._children.length===0;
};_proto4.
getSize=function getSize(){
return 1;
};_proto4.
getOffset=function getOffset(){
var collabElementNode=this._parent;
if(!(collabElementNode!==null)){
throw Error("getOffset: cound not find collab element node");
}
return collabElementNode.getChildOffset(this);
};_proto4.
syncPropertiesFromYjs=function syncPropertiesFromYjs(binding,keysChanged){
var lexicalNode=this.getNode();
if(!(lexicalNode!==null)){
throw Error("syncPropertiesFromYjs: cound not find element node");
}
_syncPropertiesFromYjs(binding,this._xmlText,lexicalNode,keysChanged);
};_proto4.
applyChildrenYjsDelta=function applyChildrenYjsDelta(binding,deltas){
var children=this._children;
var currIndex=0;
for(var i=0;i<deltas.length;i++){
var delta=deltas[i];
var insertDelta=delta.insert;
var deleteDelta=delta["delete"];
if(delta.retain!=null){
currIndex+=delta.retain;
}else if(typeof deleteDelta==='number'){
var deletionSize=deleteDelta;
while(deletionSize>0){var _getPositionFromEleme=





getPositionFromElementAndOffset(this,currIndex,false),node=_getPositionFromEleme.node,nodeIndex=_getPositionFromEleme.nodeIndex,offset=_getPositionFromEleme.offset,length=_getPositionFromEleme.length;
if(node instanceof CollabElementNode||node instanceof CollabLineBreakNode||node instanceof CollabDecoratorNode){
children.splice(nodeIndex,1);
deletionSize-=1;
}else if(node instanceof CollabTextNode){
var delCount=Math.min(deletionSize,length);
var prevCollabNode=nodeIndex!==0?children[nodeIndex-1]:null;
var nodeSize=node.getSize();
if(offset===0&&delCount===1&&nodeIndex>0&&prevCollabNode instanceof CollabTextNode&&length===nodeSize&&

Array.from(node._map.keys()).length===0){

prevCollabNode._text+=node._text;
children.splice(nodeIndex,1);
}else if(offset===0&&delCount===nodeSize){

children.splice(nodeIndex,1);
}else{
node._text=spliceString(node._text,offset,delCount,'');
}
deletionSize-=delCount;
}else{

break;
}
}
}else if(insertDelta!=null){
if(typeof insertDelta==='string'){var _getPositionFromEleme2=



getPositionFromElementAndOffset(this,currIndex,true),node=_getPositionFromEleme2.node,offset=_getPositionFromEleme2.offset;
if(node instanceof CollabTextNode){
node._text=spliceString(node._text,offset,0,insertDelta);
}else{








this._xmlText["delete"](offset,insertDelta.length);
}
currIndex+=insertDelta.length;
}else{
var sharedType=insertDelta;var _getPositionFromEleme3=


getPositionFromElementAndOffset(this,currIndex,false),nodeIndex=_getPositionFromEleme3.nodeIndex;
var collabNode=getOrInitCollabNodeFromSharedType(binding,sharedType,this);
children.splice(nodeIndex,0,collabNode);
currIndex+=1;
}
}else{
throw new Error('Unexpected delta format');
}
}
};_proto4.
syncChildrenFromYjs=function syncChildrenFromYjs(binding){

var lexicalNode=this.getNode();
if(!(lexicalNode!==null)){
throw Error("syncChildrenFromYjs: cound not find element node");
}
var key=lexicalNode.__key;
var prevLexicalChildrenKeys=createChildrenArray(lexicalNode,null);
var lexicalChildrenKeysLength=prevLexicalChildrenKeys.length;
var collabChildren=this._children;
var collabChildrenLength=collabChildren.length;
var collabNodeMap=binding.collabNodeMap;
var visitedKeys=new Set();
var collabKeys;
var writableLexicalNode;
var prevIndex=0;
var prevChildNode=null;
if(collabChildrenLength!==lexicalChildrenKeysLength){
writableLexicalNode=lexicalNode.getWritable();
}
for(var i=0;i<collabChildrenLength;i++){
var lexicalChildKey=prevLexicalChildrenKeys[prevIndex];
var childCollabNode=collabChildren[i];
var collabLexicalChildNode=childCollabNode.getNode();
var collabKey=childCollabNode._key;
if(collabLexicalChildNode!==null&&lexicalChildKey===collabKey){
var childNeedsUpdating=require("Lexical").$isTextNode(collabLexicalChildNode);

visitedKeys.add(lexicalChildKey);
if(childNeedsUpdating){
childCollabNode._key=lexicalChildKey;
if(childCollabNode instanceof CollabElementNode){
var xmlText=childCollabNode._xmlText;
childCollabNode.syncPropertiesFromYjs(binding,null);
childCollabNode.applyChildrenYjsDelta(binding,xmlText.toDelta());
childCollabNode.syncChildrenFromYjs(binding);
}else if(childCollabNode instanceof CollabTextNode){
childCollabNode.syncPropertiesAndTextFromYjs(binding,null);
}else if(childCollabNode instanceof CollabDecoratorNode){
childCollabNode.syncPropertiesFromYjs(binding,null);
}else if(!(childCollabNode instanceof CollabLineBreakNode)){
{
throw Error("syncChildrenFromYjs: expected text, element, decorator, or linebreak collab node");
}
}
}
prevChildNode=collabLexicalChildNode;
prevIndex++;
}else{
if(collabKeys===undefined){
collabKeys=new Set();
for(var s=0;s<collabChildrenLength;s++){
var child=collabChildren[s];
var _childKey=child._key;
if(_childKey!==''){
collabKeys.add(_childKey);
}
}
}
if(collabLexicalChildNode!==null&&lexicalChildKey!==undefined&&!collabKeys.has(lexicalChildKey)){
var nodeToRemove=$getNodeByKeyOrThrow(lexicalChildKey);
removeFromParent(nodeToRemove);
i--;
prevIndex++;
continue;
}
writableLexicalNode=lexicalNode.getWritable();

var lexicalChildNode=createLexicalNodeFromCollabNode(binding,childCollabNode,key);
var childKey=lexicalChildNode.__key;
collabNodeMap.set(childKey,childCollabNode);
if(prevChildNode===null){
var nextSibling=writableLexicalNode.getFirstChild();
writableLexicalNode.__first=childKey;
if(nextSibling!==null){
var writableNextSibling=nextSibling.getWritable();
writableNextSibling.__prev=childKey;
lexicalChildNode.__next=writableNextSibling.__key;
}
}else{
var writablePrevChildNode=prevChildNode.getWritable();
var _nextSibling=prevChildNode.getNextSibling();
writablePrevChildNode.__next=childKey;
lexicalChildNode.__prev=prevChildNode.__key;
if(_nextSibling!==null){
var _writableNextSibling3=_nextSibling.getWritable();
_writableNextSibling3.__prev=childKey;
lexicalChildNode.__next=_writableNextSibling3.__key;
}
}
if(i===collabChildrenLength-1){
writableLexicalNode.__last=childKey;
}
writableLexicalNode.__size++;
prevChildNode=lexicalChildNode;
}
}
for(var _i=0;_i<lexicalChildrenKeysLength;_i++){
var _lexicalChildKey=prevLexicalChildrenKeys[_i];
if(!visitedKeys.has(_lexicalChildKey)){

var _lexicalChildNode=$getNodeByKeyOrThrow(_lexicalChildKey);
var collabNode=binding.collabNodeMap.get(_lexicalChildKey);
if(collabNode!==undefined){
collabNode.destroy(binding);
}
removeFromParent(_lexicalChildNode);
}
}
};_proto4.
syncPropertiesFromLexical=function syncPropertiesFromLexical(binding,nextLexicalNode,prevNodeMap){
_syncPropertiesFromLexical(binding,this._xmlText,this.getPrevNode(prevNodeMap),nextLexicalNode);
};_proto4.
_syncChildFromLexical=function _syncChildFromLexical(binding,index,key,prevNodeMap,dirtyElements,dirtyLeaves){
var childCollabNode=this._children[index];

var nextChildNode=$getNodeByKeyOrThrow(key);
if(childCollabNode instanceof CollabElementNode&&require("Lexical").$isElementNode(nextChildNode)){
childCollabNode.syncPropertiesFromLexical(binding,nextChildNode,prevNodeMap);
childCollabNode.syncChildrenFromLexical(binding,nextChildNode,prevNodeMap,dirtyElements,dirtyLeaves);
}else if(childCollabNode instanceof CollabTextNode&&require("Lexical").$isTextNode(nextChildNode)){
childCollabNode.syncPropertiesAndTextFromLexical(binding,nextChildNode,prevNodeMap);
}else if(childCollabNode instanceof CollabDecoratorNode&&require("Lexical").$isDecoratorNode(nextChildNode)){
childCollabNode.syncPropertiesFromLexical(binding,nextChildNode,prevNodeMap);
}
};_proto4.
syncChildrenFromLexical=function syncChildrenFromLexical(binding,nextLexicalNode,prevNodeMap,dirtyElements,dirtyLeaves){
var prevLexicalNode=this.getPrevNode(prevNodeMap);
var prevChildren=prevLexicalNode===null?[]:createChildrenArray(prevLexicalNode,prevNodeMap);
var nextChildren=createChildrenArray(nextLexicalNode,null);
var prevEndIndex=prevChildren.length-1;
var nextEndIndex=nextChildren.length-1;
var collabNodeMap=binding.collabNodeMap;
var prevChildrenSet;
var nextChildrenSet;
var prevIndex=0;
var nextIndex=0;
while(prevIndex<=prevEndIndex&&nextIndex<=nextEndIndex){
var prevKey=prevChildren[prevIndex];
var nextKey=nextChildren[nextIndex];
if(prevKey===nextKey){

this._syncChildFromLexical(binding,nextIndex,nextKey,prevNodeMap,dirtyElements,dirtyLeaves);
prevIndex++;
nextIndex++;
}else{
if(prevChildrenSet===undefined){
prevChildrenSet=new Set(prevChildren);
}
if(nextChildrenSet===undefined){
nextChildrenSet=new Set(nextChildren);
}
var nextHasPrevKey=nextChildrenSet.has(prevKey);
var prevHasNextKey=prevChildrenSet.has(nextKey);
if(!nextHasPrevKey){

this.splice(binding,nextIndex,1);
prevIndex++;
}else{

var nextChildNode=$getNodeByKeyOrThrow(nextKey);
var collabNode=$createCollabNodeFromLexicalNode(binding,nextChildNode,this);
collabNodeMap.set(nextKey,collabNode);
if(prevHasNextKey){
this.splice(binding,nextIndex,1,collabNode);
prevIndex++;
nextIndex++;
}else{
this.splice(binding,nextIndex,0,collabNode);
nextIndex++;
}
}
}
}
var appendNewChildren=prevIndex>prevEndIndex;
var removeOldChildren=nextIndex>nextEndIndex;
if(appendNewChildren&&!removeOldChildren){
for(;nextIndex<=nextEndIndex;++nextIndex){
var key=nextChildren[nextIndex];
var _nextChildNode=$getNodeByKeyOrThrow(key);
var _collabNode=$createCollabNodeFromLexicalNode(binding,_nextChildNode,this);
this.append(_collabNode);
collabNodeMap.set(key,_collabNode);
}
}else if(removeOldChildren&&!appendNewChildren){
for(var i=this._children.length-1;i>=nextIndex;i--){
this.splice(binding,i,1);
}
}
};_proto4.
append=function append(collabNode){
var xmlText=this._xmlText;
var children=this._children;
var lastChild=children[children.length-1];
var offset=lastChild!==undefined?lastChild.getOffset()+lastChild.getSize():0;
if(collabNode instanceof CollabElementNode){
xmlText.insertEmbed(offset,collabNode._xmlText);
}else if(collabNode instanceof CollabTextNode){
var map=collabNode._map;
if(map.parent===null){
xmlText.insertEmbed(offset,map);
}
xmlText.insert(offset+1,collabNode._text);
}else if(collabNode instanceof CollabLineBreakNode){
xmlText.insertEmbed(offset,collabNode._map);
}else if(collabNode instanceof CollabDecoratorNode){
xmlText.insertEmbed(offset,collabNode._xmlElem);
}
this._children.push(collabNode);
};_proto4.
splice=function splice(binding,index,delCount,collabNode){
var children=this._children;
var child=children[index];
if(child===undefined){
if(!(collabNode!==undefined)){
throw Error("splice: could not find collab element node");
}
this.append(collabNode);
return;
}
var offset=child.getOffset();
if(!(offset!==-1)){
throw Error("splice: expected offset to be greater than zero");
}
var xmlText=this._xmlText;
if(delCount!==0){


xmlText["delete"](offset,child.getSize());
}
if(collabNode instanceof CollabElementNode){
xmlText.insertEmbed(offset,collabNode._xmlText);
}else if(collabNode instanceof CollabTextNode){
var map=collabNode._map;
if(map.parent===null){
xmlText.insertEmbed(offset,map);
}
xmlText.insert(offset+1,collabNode._text);
}else if(collabNode instanceof CollabLineBreakNode){
xmlText.insertEmbed(offset,collabNode._map);
}else if(collabNode instanceof CollabDecoratorNode){
xmlText.insertEmbed(offset,collabNode._xmlElem);
}
if(delCount!==0){
var childrenToDelete=children.slice(index,index+delCount);
for(var i=0;i<childrenToDelete.length;i++){
childrenToDelete[i].destroy(binding);
}
}
if(collabNode!==undefined){
children.splice(index,delCount,collabNode);
}else{
children.splice(index,delCount);
}
};_proto4.
getChildOffset=function getChildOffset(collabNode){
var offset=0;
var children=this._children;
for(var i=0;i<children.length;i++){
var child=children[i];
if(child===collabNode){
return offset;
}
offset+=child.getSize();
}
return-1;
};_proto4.
destroy=function destroy(binding){
var collabNodeMap=binding.collabNodeMap;
var children=this._children;
for(var i=0;i<children.length;i++){
children[i].destroy(binding);
}
collabNodeMap["delete"](this._key);
};return CollabElementNode;}();

function $createCollabElementNode(xmlText,parent,type){
var collabNode=new CollabElementNode(xmlText,parent,type);
xmlText._collabNode=collabNode;
return collabNode;
}








function createBinding(editor,provider,id,doc,docMap,excludedProperties){
if(!(doc!==undefined&&doc!==null)){
throw Error("createBinding: doc is null or undefined");
}
var rootXmlText=doc.get('root',require("yjs").XmlText);
var root=$createCollabElementNode(rootXmlText,null,'root');
root._key='root';
return{
clientID:doc.clientID,
collabNodeMap:new Map(),
cursors:new Map(),
cursorsContainer:null,
doc:doc,
docMap:docMap,
editor:editor,
excludedProperties:excludedProperties||new Map(),
id:id,
nodeProperties:new Map(),
root:root};

}








function createRelativePosition(point,binding){
var collabNodeMap=binding.collabNodeMap;
var collabNode=collabNodeMap.get(point.key);
if(collabNode===undefined){
return null;
}
var offset=point.offset;
var sharedType=collabNode.getSharedType();
if(collabNode instanceof CollabTextNode){
sharedType=collabNode._parent._xmlText;
var currentOffset=collabNode.getOffset();
if(currentOffset===-1){
return null;
}
offset=currentOffset+1+offset;
}else if(collabNode instanceof CollabElementNode&&point.type==='element'){
var parent=point.getNode();
if(!require("Lexical").$isElementNode(parent)){
throw Error("Element point must be an element node");
}
var accumulatedOffset=0;
var i=0;
var node=parent.getFirstChild();
while(node!==null&&i++<offset){
if(require("Lexical").$isTextNode(node)){
accumulatedOffset+=node.getTextContentSize()+1;
}else{
accumulatedOffset++;
}
node=node.getNextSibling();
}
offset=accumulatedOffset;
}
return require("yjs").createRelativePositionFromTypeIndex(sharedType,offset);
}
function createAbsolutePosition(relativePosition,binding){
return require("yjs").createAbsolutePositionFromRelativePosition(relativePosition,binding.doc);
}
function shouldUpdatePosition(currentPos,pos){
if(currentPos==null){
if(pos!=null){
return true;
}
}else if(pos==null||!require("yjs").compareRelativePositions(currentPos,pos)){
return true;
}
return false;
}
function createCursor(name,color){
return{
color:color,
name:name,
selection:null};

}
function destroySelection(binding,selection){
var cursorsContainer=binding.cursorsContainer;
if(cursorsContainer!==null){
var selections=selection.selections;
var selectionsLength=selections.length;
for(var i=0;i<selectionsLength;i++){
cursorsContainer.removeChild(selections[i]);
}
}
}
function destroyCursor(binding,cursor){
var selection=cursor.selection;
if(selection!==null){
destroySelection(binding,selection);
}
}
function createCursorSelection(cursor,anchorKey,anchorOffset,focusKey,focusOffset){
var color=cursor.color;
var caret=document.createElement('span');
caret.style.cssText="position:absolute;top:0;bottom:0;right:-1px;width:1px;background-color:"+color+";z-index:10;";
var name=document.createElement('span');
name.textContent=cursor.name;
name.style.cssText="position:absolute;left:-2px;top:-16px;background-color:"+color+";color:#fff;line-height:12px;font-size:12px;padding:2px;font-family:Arial;font-weight:bold;white-space:nowrap;";
caret.appendChild(name);
return{
anchor:{
key:anchorKey,
offset:anchorOffset},

caret:caret,
color:color,
focus:{
key:focusKey,
offset:focusOffset},

name:name,
selections:[]};

}
function updateCursor(binding,cursor,nextSelection,nodeMap){
var editor=binding.editor;
var rootElement=editor.getRootElement();
var cursorsContainer=binding.cursorsContainer;
if(cursorsContainer===null||rootElement===null){
return;
}
var cursorsContainerOffsetParent=cursorsContainer.offsetParent;
if(cursorsContainerOffsetParent===null){
return;
}
var containerRect=cursorsContainerOffsetParent.getBoundingClientRect();
var prevSelection=cursor.selection;
if(nextSelection===null){
if(prevSelection===null){
return;
}else{
cursor.selection=null;
destroySelection(binding,prevSelection);
return;
}
}else{
cursor.selection=nextSelection;
}
var caret=nextSelection.caret;
var color=nextSelection.color;
var selections=nextSelection.selections;
var anchor=nextSelection.anchor;
var focus=nextSelection.focus;
var anchorKey=anchor.key;
var focusKey=focus.key;
var anchorNode=nodeMap.get(anchorKey);
var focusNode=nodeMap.get(focusKey);
if(anchorNode==null||focusNode==null){
return;
}
var selectionRects;






if(anchorNode===focusNode&&require("Lexical").$isLineBreakNode(anchorNode)){
var brRect=editor.getElementByKey(anchorKey).getBoundingClientRect();
selectionRects=[brRect];
}else{
var range=require("LexicalSelection").createDOMRange(editor,anchorNode,anchor.offset,focusNode,focus.offset);
if(range===null){
return;
}
selectionRects=require("LexicalSelection").createRectsFromDOMRange(editor,range);
}
var selectionsLength=selections.length;
var selectionRectsLength=selectionRects.length;
for(var i=0;i<selectionRectsLength;i++){
var selectionRect=selectionRects[i];
var selection=selections[i];
if(selection===undefined){
selection=document.createElement('span');
selections[i]=selection;
var selectionBg=document.createElement('span');
selection.appendChild(selectionBg);
cursorsContainer.appendChild(selection);
}
var top=selectionRect.top-containerRect.top;
var left=selectionRect.left-containerRect.left;
var style="position:absolute;top:"+top+"px;left:"+left+"px;height:"+selectionRect.height+"px;width:"+selectionRect.width+"px;pointer-events:none;z-index:5;";
selection.style.cssText=style;
selection.firstChild.style.cssText=style+"left:0;top:0;background-color:"+color+";opacity:0.3;";
if(i===selectionRectsLength-1){
if(caret.parentNode!==selection){
selection.appendChild(caret);
}
}
}
for(var _i2=selectionsLength-1;_i2>=selectionRectsLength;_i2--){
var _selection=selections[_i2];
cursorsContainer.removeChild(_selection);
selections.pop();
}
}
function syncLocalCursorPosition(binding,provider){
var awareness=provider.awareness;
var localState=awareness.getLocalState();
if(localState===null){
return;
}
var anchorPos=localState.anchorPos;
var focusPos=localState.focusPos;
if(anchorPos!==null&&focusPos!==null){
var anchorAbsPos=createAbsolutePosition(anchorPos,binding);
var focusAbsPos=createAbsolutePosition(focusPos,binding);
if(anchorAbsPos!==null&&focusAbsPos!==null){var _getCollabNodeAndOffs=
getCollabNodeAndOffset(anchorAbsPos.type,anchorAbsPos.index),anchorCollabNode=_getCollabNodeAndOffs[0],anchorOffset=_getCollabNodeAndOffs[1];var _getCollabNodeAndOffs2=
getCollabNodeAndOffset(focusAbsPos.type,focusAbsPos.index),focusCollabNode=_getCollabNodeAndOffs2[0],focusOffset=_getCollabNodeAndOffs2[1];
if(anchorCollabNode!==null&&focusCollabNode!==null){
var anchorKey=anchorCollabNode.getKey();
var focusKey=focusCollabNode.getKey();
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return;
}
var anchor=selection.anchor;
var focus=selection.focus;
setPoint(anchor,anchorKey,anchorOffset);
setPoint(focus,focusKey,focusOffset);
}
}
}
}
function setPoint(point,key,offset){
if(point.key!==key||point.offset!==offset){
var anchorNode=require("Lexical").$getNodeByKey(key);
if(anchorNode!==null&&!require("Lexical").$isElementNode(anchorNode)&&!require("Lexical").$isTextNode(anchorNode)){
var parent=anchorNode.getParentOrThrow();
key=parent.getKey();
offset=anchorNode.getIndexWithinParent();
anchorNode=parent;
}
point.set(key,offset,require("Lexical").$isElementNode(anchorNode)?'element':'text');
}
}
function getCollabNodeAndOffset(

sharedType,offset){
var collabNode=sharedType._collabNode;
if(collabNode===undefined){
return[null,0];
}
if(collabNode instanceof CollabElementNode){var _getPositionFromEleme4=



getPositionFromElementAndOffset(collabNode,offset,true),node=_getPositionFromEleme4.node,collabNodeOffset=_getPositionFromEleme4.offset;
if(node===null){
return[collabNode,0];
}else{
return[node,collabNodeOffset];
}
}
return[null,0];
}
function syncCursorPositions(binding,provider){
var awarenessStates=Array.from(provider.awareness.getStates());
var localClientID=binding.clientID;
var cursors=binding.cursors;
var editor=binding.editor;
var nodeMap=editor._editorState._nodeMap;
var visitedClientIDs=new Set();
for(var i=0;i<awarenessStates.length;i++){
var awarenessState=awarenessStates[i];var
clientID=awarenessState[0],awareness=awarenessState[1];
if(clientID!==localClientID){
visitedClientIDs.add(clientID);var

anchorPos=




awareness.anchorPos,focusPos=awareness.focusPos,name=awareness.name,color=awareness.color,focusing=awareness.focusing;
var selection=null;
var cursor=cursors.get(clientID);
if(cursor===undefined){
cursor=createCursor(name,color);
cursors.set(clientID,cursor);
}
if(anchorPos!==null&&focusPos!==null&&focusing){
var anchorAbsPos=createAbsolutePosition(anchorPos,binding);
var focusAbsPos=createAbsolutePosition(focusPos,binding);
if(anchorAbsPos!==null&&focusAbsPos!==null){var _getCollabNodeAndOffs3=
getCollabNodeAndOffset(anchorAbsPos.type,anchorAbsPos.index),anchorCollabNode=_getCollabNodeAndOffs3[0],anchorOffset=_getCollabNodeAndOffs3[1];var _getCollabNodeAndOffs4=
getCollabNodeAndOffset(focusAbsPos.type,focusAbsPos.index),focusCollabNode=_getCollabNodeAndOffs4[0],focusOffset=_getCollabNodeAndOffs4[1];
if(anchorCollabNode!==null&&focusCollabNode!==null){
var anchorKey=anchorCollabNode.getKey();
var focusKey=focusCollabNode.getKey();
selection=cursor.selection;
if(selection===null){
selection=createCursorSelection(cursor,anchorKey,anchorOffset,focusKey,focusOffset);
}else{
var anchor=selection.anchor;
var focus=selection.focus;
anchor.key=anchorKey;
anchor.offset=anchorOffset;
focus.key=focusKey;
focus.offset=focusOffset;
}
}
}
}
updateCursor(binding,cursor,selection,nodeMap);
}
}
var allClientIDs=Array.from(cursors.keys());
for(var _i3=0;_i3<allClientIDs.length;_i3++){
var clientID=allClientIDs[_i3];
if(!visitedClientIDs.has(clientID)){
var _cursor=cursors.get(clientID);
if(_cursor!==undefined){
destroyCursor(binding,_cursor);
cursors["delete"](clientID);
}
}
}
}
function syncLexicalSelectionToYjs(binding,provider,prevSelection,nextSelection){
var awareness=provider.awareness;
var localState=awareness.getLocalState();
if(localState===null){
return;
}var

currentAnchorPos=





localState.anchorPos,currentFocusPos=localState.focusPos,name=localState.name,color=localState.color,focusing=localState.focusing,awarenessData=localState.awarenessData;
var anchorPos=null;
var focusPos=null;
if(nextSelection===null||currentAnchorPos!==null&&!nextSelection.is(prevSelection)){
if(prevSelection===null){
return;
}
}
if(require("Lexical").$isRangeSelection(nextSelection)){
anchorPos=createRelativePosition(nextSelection.anchor,binding);
focusPos=createRelativePosition(nextSelection.focus,binding);
}
if(shouldUpdatePosition(currentAnchorPos,anchorPos)||shouldUpdatePosition(currentFocusPos,focusPos)){
awareness.setLocalState({
anchorPos:anchorPos,
awarenessData:awarenessData,
color:color,
focusPos:focusPos,
focusing:focusing,
name:name});

}
}










function syncEvent(binding,event){var

target=
event.target;
var collabNode=getOrInitCollabNodeFromSharedType(binding,target);
if(collabNode instanceof CollabElementNode&&event instanceof require("yjs").YTextEvent){var


keysChanged=


event.keysChanged,childListChanged=event.childListChanged,delta=event.delta;


if(keysChanged.size>0){
collabNode.syncPropertiesFromYjs(binding,keysChanged);
}
if(childListChanged){
collabNode.applyChildrenYjsDelta(binding,delta);
collabNode.syncChildrenFromYjs(binding);
}
}else if(collabNode instanceof CollabTextNode&&event instanceof require("yjs").YMapEvent){var

_keysChanged=
event.keysChanged;


if(_keysChanged.size>0){
collabNode.syncPropertiesAndTextFromYjs(binding,_keysChanged);
}
}else if(collabNode instanceof CollabDecoratorNode&&event instanceof require("yjs").YXmlEvent){var

attributesChanged=
event.attributesChanged;


if(attributesChanged.size>0){
collabNode.syncPropertiesFromYjs(binding,attributesChanged);
}
}else{
{
throw Error("Expected text, element, or decorator event");
}
}
}
function syncYjsChangesToLexical(binding,provider,events,isFromUndoManger){
var editor=binding.editor;
var currentEditorState=editor._editorState;






events.forEach(function(event){return event.delta;});
editor.update(function(){
var pendingEditorState=editor._pendingEditorState;
for(var i=0;i<events.length;i++){
var event=events[i];
syncEvent(binding,event);
}
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){



if(doesSelectionNeedRecovering(selection)){
var prevSelection=currentEditorState._selection;
if(require("Lexical").$isRangeSelection(prevSelection)){
var prevOffsetView=require("LexicalOffset").$createOffsetView(editor,0,currentEditorState);
var nextOffsetView=require("LexicalOffset").$createOffsetView(editor,0,pendingEditorState);var _prevOffsetView$getOf=
prevOffsetView.getOffsetsFromSelection(prevSelection),start=_prevOffsetView$getOf[0],end=_prevOffsetView$getOf[1];
var nextSelection=start>=0&&end>=0?nextOffsetView.createSelectionFromOffsets(start,end,prevOffsetView):null;
if(nextSelection!==null){
require("Lexical").$setSelection(nextSelection);
}else{

syncLocalCursorPosition(binding,provider);
if(doesSelectionNeedRecovering(selection)){
var root=require("Lexical").$getRoot();



if(root.getChildrenSize()===0){
root.append(require("Lexical").$createParagraphNode());
}


require("Lexical").$getRoot().selectEnd();
}
}
}
syncLexicalSelectionToYjs(binding,provider,prevSelection,require("Lexical").$getSelection());
}else{
syncLocalCursorPosition(binding,provider);
}
}
},{
onUpdate:function onUpdate(){
syncCursorPositions(binding,provider);
},
skipTransforms:true,
tag:isFromUndoManger?'historic':'collaboration'});

}
function handleNormalizationMergeConflicts(binding,normalizedNodes){

var normalizedNodesKeys=Array.from(normalizedNodes);
var collabNodeMap=binding.collabNodeMap;
var mergedNodes=[];
for(var i=0;i<normalizedNodesKeys.length;i++){
var nodeKey=normalizedNodesKeys[i];
var lexicalNode=require("Lexical").$getNodeByKey(nodeKey);
var collabNode=collabNodeMap.get(nodeKey);
if(collabNode instanceof CollabTextNode){
if(require("Lexical").$isTextNode(lexicalNode)){


mergedNodes.push([collabNode,lexicalNode.__text]);
}else{
var offset=collabNode.getOffset();
if(offset===-1){
continue;
}
var parent=collabNode._parent;
collabNode._normalized=true;
parent._xmlText["delete"](offset,1);
collabNodeMap["delete"](nodeKey);
var parentChildren=parent._children;
var index=parentChildren.indexOf(collabNode);
parentChildren.splice(index,1);
}
}
}
for(var _i4=0;_i4<mergedNodes.length;_i4++){var _mergedNodes$_i=
mergedNodes[_i4],_collabNode2=_mergedNodes$_i[0],text=_mergedNodes$_i[1];
if(_collabNode2 instanceof CollabTextNode&&typeof text==='string'){
_collabNode2._text=text;
}
}
}
function syncLexicalUpdateToYjs(binding,provider,prevEditorState,currEditorState,dirtyElements,dirtyLeaves,normalizedNodes,tags){
syncWithTransaction(binding,function(){
currEditorState.read(function(){







if(tags.has('collaboration')||tags.has('historic')){
if(normalizedNodes.size>0){
handleNormalizationMergeConflicts(binding,normalizedNodes);
}
return;
}
if(dirtyElements.has('root')){
var prevNodeMap=prevEditorState._nodeMap;
var nextLexicalRoot=require("Lexical").$getRoot();
var collabRoot=binding.root;
collabRoot.syncPropertiesFromLexical(binding,nextLexicalRoot,prevNodeMap);
collabRoot.syncChildrenFromLexical(binding,nextLexicalRoot,prevNodeMap,dirtyElements,dirtyLeaves);
}
var selection=require("Lexical").$getSelection();
var prevSelection=prevEditorState._selection;
syncLexicalSelectionToYjs(binding,provider,prevSelection,selection);
});
});
}


var CONNECTED_COMMAND=require("Lexical").createCommand('CONNECTED_COMMAND');
var TOGGLE_CONNECT_COMMAND=require("Lexical").createCommand('TOGGLE_CONNECT_COMMAND');
function createUndoManager(binding,root){
return new(require("yjs").UndoManager)(root,{
trackedOrigins:new Set([binding,null])});

}
function initLocalState(provider,name,color,focusing,awarenessData){
provider.awareness.setLocalState({
anchorPos:null,
awarenessData:awarenessData,
color:color,
focusPos:null,
focusing:focusing,
name:name});

}
function setLocalStateFocus(provider,name,color,focusing,awarenessData){var

awareness=
provider.awareness;
var localState=awareness.getLocalState();
if(localState===null){
localState={
anchorPos:null,
awarenessData:awarenessData,
color:color,
focusPos:null,
focusing:focusing,
name:name};

}
localState.focusing=focusing;
awareness.setLocalState(localState);
}

exports.CONNECTED_COMMAND=CONNECTED_COMMAND;
exports.TOGGLE_CONNECT_COMMAND=TOGGLE_CONNECT_COMMAND;
exports.createBinding=createBinding;
exports.createUndoManager=createUndoManager;
exports.initLocalState=initLocalState;
exports.setLocalStateFocus=setLocalStateFocus;
exports.syncCursorPositions=syncCursorPositions;
exports.syncLexicalUpdateToYjs=syncLexicalUpdateToYjs;
exports.syncYjsChangesToLexical=syncYjsChangesToLexical;}),null);