/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalLink.dev",["Lexical","LexicalUtils"],(function $module_LexicalLink_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';





var SUPPORTED_URL_PROTOCOLS=new Set(['http:','https:','mailto:','sms:','tel:']);var


LinkNode=function(_Lexical$ElementNode){babelHelpers.inheritsLoose(LinkNode,_Lexical$ElementNode);LinkNode.








getType=function getType(){
return'link';
};LinkNode.
clone=function clone(node){
return new LinkNode(node.__url,{
rel:node.__rel,
target:node.__target,
title:node.__title},
node.__key);
};
function LinkNode(url,attributes,key){var _this;if(attributes===void 0){attributes={};}
_this=_Lexical$ElementNode.call(this,key)||this;var _attributes=




attributes,_attributes$target=_attributes.target,target=_attributes$target===void 0?null:_attributes$target,_attributes$rel=_attributes.rel,rel=_attributes$rel===void 0?null:_attributes$rel,_attributes$title=_attributes.title,title=_attributes$title===void 0?null:_attributes$title;
_this.__url=url;
_this.__target=target;
_this.__rel=rel;
_this.__title=title;return _this;
}var _proto=LinkNode.prototype;_proto.
createDOM=function createDOM(config){
var element=document.createElement('a');
element.href=this.sanitizeUrl(this.__url);
if(this.__target!==null){
element.target=this.__target;
}
if(this.__rel!==null){
element.rel=this.__rel;
}
if(this.__title!==null){
element.title=this.__title;
}
require("LexicalUtils").addClassNamesToElement(element,config.theme.link);
return element;
};_proto.
updateDOM=function updateDOM(prevNode,anchor,config){
var url=this.__url;
var target=this.__target;
var rel=this.__rel;
var title=this.__title;
if(url!==prevNode.__url){
anchor.href=url;
}
if(target!==prevNode.__target){
if(target){
anchor.target=target;
}else{
anchor.removeAttribute('target');
}
}
if(rel!==prevNode.__rel){
if(rel){
anchor.rel=rel;
}else{
anchor.removeAttribute('rel');
}
}
if(title!==prevNode.__title){
if(title){
anchor.title=title;
}else{
anchor.removeAttribute('title');
}
}
return false;
};LinkNode.
importDOM=function importDOM(){
return{
a:function a(node){return{
conversion:convertAnchorElement,
priority:1};}};


};LinkNode.
importJSON=function importJSON(serializedNode){
var node=$createLinkNode(serializedNode.url,{
rel:serializedNode.rel,
target:serializedNode.target,
title:serializedNode.title});

node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto.
sanitizeUrl=function sanitizeUrl(url){
try{
var parsedUrl=new URL(url);

if(!SUPPORTED_URL_PROTOCOLS.has(parsedUrl.protocol)){
return'about:blank';
}
}catch(_unused){
return url;
}
return url;
};_proto.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode.prototype.
exportJSON.call(this),{
rel:this.getRel(),
target:this.getTarget(),
title:this.getTitle(),
type:'link',
url:this.getURL(),
version:1});

};_proto.
getURL=function getURL(){
return this.getLatest().__url;
};_proto.
setURL=function setURL(url){
var writable=this.getWritable();
writable.__url=url;
};_proto.
getTarget=function getTarget(){
return this.getLatest().__target;
};_proto.
setTarget=function setTarget(target){
var writable=this.getWritable();
writable.__target=target;
};_proto.
getRel=function getRel(){
return this.getLatest().__rel;
};_proto.
setRel=function setRel(rel){
var writable=this.getWritable();
writable.__rel=rel;
};_proto.
getTitle=function getTitle(){
return this.getLatest().__title;
};_proto.
setTitle=function setTitle(title){
var writable=this.getWritable();
writable.__title=title;
};_proto.
insertNewAfter=function insertNewAfter(_,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var linkNode=$createLinkNode(this.__url,{
rel:this.__rel,
target:this.__target,
title:this.__title});

this.insertAfter(linkNode,restoreSelection);
return linkNode;
};_proto.
canInsertTextBefore=function canInsertTextBefore(){
return false;
};_proto.
canInsertTextAfter=function canInsertTextAfter(){
return false;
};_proto.
canBeEmpty=function canBeEmpty(){
return false;
};_proto.
isInline=function isInline(){
return true;
};_proto.
extractWithChild=function extractWithChild(child,selection,destination){
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var anchorNode=selection.anchor.getNode();
var focusNode=selection.focus.getNode();
return this.isParentOf(anchorNode)&&this.isParentOf(focusNode)&&selection.getTextContent().length>0;
};return LinkNode;}(require("Lexical").ElementNode);

function convertAnchorElement(domNode){
var node=null;
if(require("LexicalUtils").isHTMLAnchorElement(domNode)){
var content=domNode.textContent;
if(content!==null&&content!==''||domNode.children.length>0){
node=$createLinkNode(domNode.getAttribute('href')||'',{
rel:domNode.getAttribute('rel'),
target:domNode.getAttribute('target'),
title:domNode.getAttribute('title')});

}
}
return{
node:node};

}







function $createLinkNode(url,attributes){
return require("Lexical").$applyNodeReplacement(new LinkNode(url,attributes));
}






function $isLinkNode(node){
return node instanceof LinkNode;
}var


AutoLinkNode=function(_LinkNode){babelHelpers.inheritsLoose(AutoLinkNode,_LinkNode);function AutoLinkNode(){return _LinkNode.apply(this,arguments)||this;}AutoLinkNode.
getType=function getType(){
return'autolink';
};AutoLinkNode.
clone=function clone(node){
return new AutoLinkNode(node.__url,{
rel:node.__rel,
target:node.__target,
title:node.__title},
node.__key);
};AutoLinkNode.
importJSON=function importJSON(serializedNode){
var node=$createAutoLinkNode(serializedNode.url,{
rel:serializedNode.rel,
target:serializedNode.target,
title:serializedNode.title});

node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};AutoLinkNode.
importDOM=function importDOM(){

return null;
};var _proto2=AutoLinkNode.prototype;_proto2.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_LinkNode.prototype.
exportJSON.call(this),{
type:'autolink',
version:1});

};_proto2.
insertNewAfter=function insertNewAfter(selection,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var element=this.getParentOrThrow().insertNewAfter(selection,restoreSelection);
if(require("Lexical").$isElementNode(element)){
var linkNode=$createAutoLinkNode(this.__url,{
rel:this.__rel,
target:this.__target,
title:this.__title});

element.append(linkNode);
return linkNode;
}
return null;
};return AutoLinkNode;}(LinkNode);









function $createAutoLinkNode(url,attributes){
return require("Lexical").$applyNodeReplacement(new AutoLinkNode(url,attributes));
}






function $isAutoLinkNode(node){
return node instanceof AutoLinkNode;
}
var TOGGLE_LINK_COMMAND=require("Lexical").createCommand('TOGGLE_LINK_COMMAND');







function toggleLink(url,attributes){if(attributes===void 0){attributes={};}var _attributes2=



attributes,target=_attributes2.target,title=_attributes2.title;
var rel=attributes.rel===undefined?'noreferrer':attributes.rel;
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return;
}
var nodes=selection.extract();
if(url===null){

nodes.forEach(function(node){
var parent=node.getParent();
if($isLinkNode(parent)){
var children=parent.getChildren();
for(var i=0;i<children.length;i++){
parent.insertBefore(children[i]);
}
parent.remove();
}
});
}else{

if(nodes.length===1){
var firstNode=nodes[0];


var _linkNode=$getAncestor(firstNode,$isLinkNode);
if(_linkNode!==null){
_linkNode.setURL(url);
if(target!==undefined){
_linkNode.setTarget(target);
}
if(rel!==null){
_linkNode.setRel(rel);
}
if(title!==undefined){
_linkNode.setTitle(title);
}
return;
}
}
var prevParent=null;
var linkNode=null;
nodes.forEach(function(node){
var parent=node.getParent();
if(parent===linkNode||parent===null||require("Lexical").$isElementNode(node)&&!node.isInline()){
return;
}
if($isLinkNode(parent)){
linkNode=parent;
parent.setURL(url);
if(target!==undefined){
parent.setTarget(target);
}
if(rel!==null){
linkNode.setRel(rel);
}
if(title!==undefined){
linkNode.setTitle(title);
}
return;
}
if(!parent.is(prevParent)){
prevParent=parent;
linkNode=$createLinkNode(url,{
rel:rel,
target:target,
title:title});

if($isLinkNode(parent)){
if(node.getPreviousSibling()===null){
parent.insertBefore(linkNode);
}else{
parent.insertAfter(linkNode);
}
}else{
node.insertBefore(linkNode);
}
}
if($isLinkNode(node)){
if(node.is(linkNode)){
return;
}
if(linkNode!==null){
var children=node.getChildren();
for(var i=0;i<children.length;i++){
linkNode.append(children[i]);
}
}
node.remove();
return;
}
if(linkNode!==null){
linkNode.append(node);
}
});
}
}
function $getAncestor(node,predicate){
var parent=node;
while(parent!==null&&parent.getParent()!==null&&!predicate(parent)){
parent=parent.getParentOrThrow();
}
return predicate(parent)?parent:null;
}

exports.$createAutoLinkNode=$createAutoLinkNode;
exports.$createLinkNode=$createLinkNode;
exports.$isAutoLinkNode=$isAutoLinkNode;
exports.$isLinkNode=$isLinkNode;
exports.AutoLinkNode=AutoLinkNode;
exports.LinkNode=LinkNode;
exports.TOGGLE_LINK_COMMAND=TOGGLE_LINK_COMMAND;
exports.toggleLink=toggleLink;}),null);