/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalCollaborationPlugin.dev",["Lexical","LexicalCollaborationContext","LexicalComposerContext","LexicalUtils","LexicalYjs","ReactDOMComet","react","yjs"],(function $module_LexicalCollaborationPlugin_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;



var React=_require_closure_react||(_require_closure_react=require("react"));













function useYjsCollaboration(editor,id,provider,docMap,name,color,shouldBootstrap,cursorsContainerRef,initialEditorState,excludedProperties,awarenessData){
var isReloadingDoc=React.useRef(false);var _React$useState=
React.useState(docMap.get(id)),doc=_React$useState[0],setDoc=_React$useState[1];
var binding=React.useMemo(function(){return require("LexicalYjs").createBinding(editor,provider,id,doc,docMap,excludedProperties);},[editor,provider,id,docMap,doc,excludedProperties]);
var connect=React.useCallback(function(){
provider.connect();
},[provider]);
var disconnect=React.useCallback(function(){
try{
provider.disconnect();
}catch(e){

}
},[provider]);
React.useEffect(function(){var

root=
binding.root;var

awareness=
provider.awareness;
var onStatus=function onStatus(_ref)

{var status=_ref.status;
editor.dispatchCommand(require("LexicalYjs").CONNECTED_COMMAND,status==='connected');
};
var onSync=function onSync(isSynced){
if(shouldBootstrap&&isSynced&&root.isEmpty()&&root._xmlText._length===0&&isReloadingDoc.current===false){
initializeEditor(editor,initialEditorState);
}
isReloadingDoc.current=false;
};
var onAwarenessUpdate=function onAwarenessUpdate(){
require("LexicalYjs").syncCursorPositions(binding,provider);
};
var onYjsTreeChanges=function onYjsTreeChanges(events,transaction){
var origin=transaction.origin;
if(origin!==binding){
var isFromUndoManger=origin instanceof require("yjs").UndoManager;
require("LexicalYjs").syncYjsChangesToLexical(binding,provider,events,isFromUndoManger);
}
};
require("LexicalYjs").initLocalState(provider,name,color,document.activeElement===editor.getRootElement(),awarenessData||{});
var onProviderDocReload=function onProviderDocReload(ydoc){
clearEditorSkipCollab(editor,binding);
setDoc(ydoc);
docMap.set(id,ydoc);
isReloadingDoc.current=true;
};
provider.on('reload',onProviderDocReload);
provider.on('status',onStatus);
provider.on('sync',onSync);
awareness.on('update',onAwarenessUpdate);

root.getSharedType().observeDeep(onYjsTreeChanges);
var removeListener=editor.registerUpdateListener(function(_ref2)






{var prevEditorState=_ref2.prevEditorState,editorState=_ref2.editorState,dirtyLeaves=_ref2.dirtyLeaves,dirtyElements=_ref2.dirtyElements,normalizedNodes=_ref2.normalizedNodes,tags=_ref2.tags;
if(tags.has('skip-collab')===false){
require("LexicalYjs").syncLexicalUpdateToYjs(binding,provider,prevEditorState,editorState,dirtyElements,dirtyLeaves,normalizedNodes,tags);
}
});
connect();
return function(){
if(isReloadingDoc.current===false){
disconnect();
}
provider.off('sync',onSync);
provider.off('status',onStatus);
provider.off('reload',onProviderDocReload);
awareness.off('update',onAwarenessUpdate);
root.getSharedType().unobserveDeep(onYjsTreeChanges);
docMap["delete"](id);
removeListener();
};
},[binding,color,connect,disconnect,docMap,editor,id,initialEditorState,name,provider,shouldBootstrap,awarenessData]);
var cursorsContainer=React.useMemo(function(){
var ref=function ref(element){
binding.cursorsContainer=element;
};
return require("ReactDOMComet").createPortal(React.createElement("div",{
ref:ref}),
cursorsContainerRef&&cursorsContainerRef.current||document.body);
},[binding,cursorsContainerRef]);
React.useEffect(function(){
return editor.registerCommand(require("LexicalYjs").TOGGLE_CONNECT_COMMAND,function(payload){
if(connect!==undefined&&disconnect!==undefined){
var shouldConnect=payload;
if(shouldConnect){

console.log('Collaboration connected!');
connect();
}else{

console.log('Collaboration disconnected!');
disconnect();
}
}
return true;
},require("Lexical").COMMAND_PRIORITY_EDITOR);
},[connect,disconnect,editor]);
return[cursorsContainer,binding];
}
function useYjsFocusTracking(editor,provider,name,color,awarenessData){
React.useEffect(function(){var _require_Lexical;
return require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).FOCUS_COMMAND,function(){
require("LexicalYjs").setLocalStateFocus(provider,name,color,true,awarenessData||{});
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.BLUR_COMMAND,function(){
require("LexicalYjs").setLocalStateFocus(provider,name,color,false,awarenessData||{});
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR));
},[color,editor,name,provider,awarenessData]);
}
function useYjsHistory(editor,binding){
var undoManager=React.useMemo(function(){return require("LexicalYjs").createUndoManager(binding,binding.root.getSharedType());},[binding]);
React.useEffect(function(){var _require_Lexical;
var undo=function undo(){
undoManager.undo();
};
var redo=function redo(){
undoManager.redo();
};
return require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).UNDO_COMMAND,function(){
undo();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.REDO_COMMAND,function(){
redo();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR));
});
var clearHistory=React.useCallback(function(){
undoManager.clear();
},[undoManager]);


React.useEffect(function(){
var updateUndoRedoStates=function updateUndoRedoStates(){
editor.dispatchCommand(require("Lexical").CAN_UNDO_COMMAND,undoManager.undoStack.length>0);
editor.dispatchCommand(require("Lexical").CAN_REDO_COMMAND,undoManager.redoStack.length>0);
};
undoManager.on('stack-item-added',updateUndoRedoStates);
undoManager.on('stack-item-popped',updateUndoRedoStates);
undoManager.on('stack-cleared',updateUndoRedoStates);
return function(){
undoManager.off('stack-item-added',updateUndoRedoStates);
undoManager.off('stack-item-popped',updateUndoRedoStates);
undoManager.off('stack-cleared',updateUndoRedoStates);
};
},[editor,undoManager]);
return clearHistory;
}
function initializeEditor(editor,initialEditorState){
editor.update(function(){
var root=require("Lexical").$getRoot();
if(root.isEmpty()){
if(initialEditorState){
switch(typeof initialEditorState){
case'string':
{
var parsedEditorState=editor.parseEditorState(initialEditorState);
editor.setEditorState(parsedEditorState,{
tag:'history-merge'});

break;
}
case'object':
{
editor.setEditorState(initialEditorState,{
tag:'history-merge'});

break;
}
case'function':
{
editor.update(function(){
var root1=require("Lexical").$getRoot();
if(root1.isEmpty()){
initialEditorState(editor);
}
},{
tag:'history-merge'});

break;
}}

}else{
var paragraph=require("Lexical").$createParagraphNode();
root.append(paragraph);var _document=


document,activeElement=_document.activeElement;
if(require("Lexical").$getSelection()!==null||activeElement!==null&&activeElement===editor.getRootElement()){
paragraph.select();
}
}
}
},{
tag:'history-merge'});

}
function clearEditorSkipCollab(editor,binding){

editor.update(function(){
var root=require("Lexical").$getRoot();
root.clear();
root.select();
},{
tag:'skip-collab'});

if(binding.cursors==null){
return;
}
var cursors=binding.cursors;
if(cursors==null){
return;
}
var cursorsContainer=binding.cursorsContainer;
if(cursorsContainer==null){
return;
}


var cursorsArr=Array.from(cursors.values());
for(var i=0;i<cursorsArr.length;i++){
var cursor=cursorsArr[i];
var selection=cursor.selection;
if(selection&&selection.selections!=null){
var selections=selection.selections;
for(var j=0;j<selections.length;j++){
cursorsContainer.removeChild(selections[i]);
}
}
}
}








function CollaborationPlugin(_ref3)









{var id=_ref3.id,providerFactory=_ref3.providerFactory,shouldBootstrap=_ref3.shouldBootstrap,username=_ref3.username,cursorColor=_ref3.cursorColor,cursorsContainerRef=_ref3.cursorsContainerRef,initialEditorState=_ref3.initialEditorState,excludedProperties=_ref3.excludedProperties,awarenessData=_ref3.awarenessData;
var collabContext=require("LexicalCollaborationContext").useCollaborationContext(username,cursorColor);var

yjsDocMap=


collabContext.yjsDocMap,name=collabContext.name,color=collabContext.color;var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];
React.useEffect(function(){
collabContext.isCollabActive=true;
return function(){


if(editor._parentEditor==null){
collabContext.isCollabActive=false;
}
};
},[collabContext,editor]);
var provider=React.useMemo(function(){return providerFactory(id,yjsDocMap);},[id,providerFactory,yjsDocMap]);var _useYjsCollaboration=
useYjsCollaboration(editor,id,provider,yjsDocMap,name,color,shouldBootstrap,cursorsContainerRef,initialEditorState,excludedProperties,awarenessData),cursors=_useYjsCollaboration[0],binding=_useYjsCollaboration[1];
collabContext.clientID=binding.clientID;
useYjsHistory(editor,binding);
useYjsFocusTracking(editor,provider,name,color,awarenessData);
return cursors;
}

exports.CollaborationPlugin=CollaborationPlugin;}),null);