/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalTreeView.dev",["Lexical","LexicalHtml","LexicalLink","LexicalMark","LexicalTable","LexicalUtils","react"],(function $module_LexicalTreeView_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;







var React=_require_closure_react||(_require_closure_react=require("react"));








var NON_SINGLE_WIDTH_CHARS_REPLACEMENT=Object.freeze({
'\t':'\\t',
'\n':'\\n'});

var NON_SINGLE_WIDTH_CHARS_REGEX=new RegExp(Object.keys(NON_SINGLE_WIDTH_CHARS_REPLACEMENT).join('|'),'g');
var SYMBOLS=Object.freeze({
ancestorHasNextSibling:'|',
ancestorIsLastChild:' ',
hasNextSibling:'├',
isLastChild:'└',
selectedChar:'^',
selectedLine:'>'});

function TreeView(_ref)







{var treeTypeButtonClassName=_ref.treeTypeButtonClassName,timeTravelButtonClassName=_ref.timeTravelButtonClassName,timeTravelPanelSliderClassName=_ref.timeTravelPanelSliderClassName,timeTravelPanelButtonClassName=_ref.timeTravelPanelButtonClassName,viewClassName=_ref.viewClassName,timeTravelPanelClassName=_ref.timeTravelPanelClassName,editor=_ref.editor;var _React$useState=
React.useState([]),timeStampedEditorStates=_React$useState[0],setTimeStampedEditorStates=_React$useState[1];var _React$useState2=
React.useState(''),content=_React$useState2[0],setContent=_React$useState2[1];var _React$useState3=
React.useState(false),timeTravelEnabled=_React$useState3[0],setTimeTravelEnabled=_React$useState3[1];var _React$useState4=
React.useState(false),showExportDOM=_React$useState4[0],setShowExportDOM=_React$useState4[1];
var playingIndexRef=React.useRef(0);
var treeElementRef=React.useRef(null);
var inputRef=React.useRef(null);var _React$useState5=
React.useState(false),isPlaying=_React$useState5[0],setIsPlaying=_React$useState5[1];var _React$useState6=
React.useState(false),isLimited=_React$useState6[0],setIsLimited=_React$useState6[1];var _React$useState7=
React.useState(false),showLimited=_React$useState7[0],setShowLimited=_React$useState7[1];
var lastEditorStateRef=React.useRef(null);
var commandsLog=useLexicalCommandsLog(editor);
var generateTree=React.useCallback(function(editorState){
var treeText=generateContent(editor,commandsLog,showExportDOM);
setContent(treeText);
if(!timeTravelEnabled){
setTimeStampedEditorStates(function(currentEditorStates){return[].concat(currentEditorStates,[[Date.now(),editorState]]);});
}
},[commandsLog,editor,timeTravelEnabled,showExportDOM]);
React.useEffect(function(){
var editorState=editor.getEditorState();
if(!showLimited&&editorState._nodeMap.size<1000){
setContent(generateContent(editor,commandsLog,showExportDOM));
}
},[commandsLog,editor,showLimited,showExportDOM]);
React.useEffect(function(){
return require("LexicalUtils").mergeRegister(editor.registerUpdateListener(function(_ref2)

{var editorState=_ref2.editorState;
if(!showLimited&&editorState._nodeMap.size>1000){
lastEditorStateRef.current=editorState;
setIsLimited(true);
if(!showLimited){
return;
}
}
generateTree(editorState);
}),editor.registerEditableListener(function(){
var treeText=generateContent(editor,commandsLog,showExportDOM);
setContent(treeText);
}));
},[commandsLog,editor,showExportDOM,isLimited,generateTree,showLimited]);
var totalEditorStates=timeStampedEditorStates.length;
React.useEffect(function(){
if(isPlaying){
var timeoutId;
var play=function play(){
var currentIndex=playingIndexRef.current;
if(currentIndex===totalEditorStates-1){
setIsPlaying(false);
return;
}
var currentTime=timeStampedEditorStates[currentIndex][0];
var nextTime=timeStampedEditorStates[currentIndex+1][0];
var timeDiff=nextTime-currentTime;
timeoutId=setTimeout(function(){
playingIndexRef.current++;
var index=playingIndexRef.current;
var input=inputRef.current;
if(input!==null){
input.value=String(index);
}
editor.setEditorState(timeStampedEditorStates[index][1]);
play();
},timeDiff);
};
play();
return function(){
clearTimeout(timeoutId);
};
}
},[timeStampedEditorStates,isPlaying,editor,totalEditorStates]);
React.useEffect(function(){
var element=treeElementRef.current;
if(element!==null){

element.__lexicalEditor=editor;
return function(){

element.__lexicalEditor=null;
};
}
},[editor]);
return React.createElement("div",{
className:viewClassName},
!showLimited&&isLimited?React.createElement("div",{
style:{
padding:20}},

React.createElement("span",{
style:{
marginRight:20}},

"Detected large EditorState, this can impact debugging performance."),React.createElement("button",{
onClick:function onClick(){
setShowLimited(true);
var editorState=lastEditorStateRef.current;
if(editorState!==null){
lastEditorStateRef.current=null;
generateTree(editorState);
}
},
style:{
background:'transparent',
border:'1px solid white',
color:'white',
cursor:'pointer',
padding:5}},

"Show full tree")):null,!showLimited?React.createElement("button",{
onClick:function onClick(){return setShowExportDOM(!showExportDOM);},
className:treeTypeButtonClassName,
type:"button"},
showExportDOM?'Tree':'Export DOM'):null,!timeTravelEnabled&&(showLimited||!isLimited)&&totalEditorStates>2&&React.createElement("button",{
onClick:function onClick(){
var rootElement=editor.getRootElement();
if(rootElement!==null){
rootElement.contentEditable='false';
playingIndexRef.current=totalEditorStates-1;
setTimeTravelEnabled(true);
}
},
className:timeTravelButtonClassName,
type:"button"},
"Time Travel"),(showLimited||!isLimited)&&React.createElement("pre",{
ref:treeElementRef},
content),timeTravelEnabled&&(showLimited||!isLimited)&&React.createElement("div",{
className:timeTravelPanelClassName},
React.createElement("button",{
className:timeTravelPanelButtonClassName,
onClick:function onClick(){
if(playingIndexRef.current===totalEditorStates-1){
playingIndexRef.current=1;
}
setIsPlaying(!isPlaying);
},
type:"button"},
isPlaying?'Pause':'Play'),React.createElement("input",{
className:timeTravelPanelSliderClassName,
ref:inputRef,
onChange:function onChange(event){
var editorStateIndex=Number(event.target.value);
var timeStampedEditorState=timeStampedEditorStates[editorStateIndex];
if(timeStampedEditorState){
playingIndexRef.current=editorStateIndex;
editor.setEditorState(timeStampedEditorState[1]);
}
},
type:"range",
min:"1",
max:totalEditorStates-1}),
React.createElement("button",{
className:timeTravelPanelButtonClassName,
onClick:function onClick(){
var rootElement=editor.getRootElement();
if(rootElement!==null){
rootElement.contentEditable='true';
var index=timeStampedEditorStates.length-1;
var timeStampedEditorState=timeStampedEditorStates[index];
editor.setEditorState(timeStampedEditorState[1]);
var input=inputRef.current;
if(input!==null){
input.value=String(index);
}
setTimeTravelEnabled(false);
setIsPlaying(false);
}
},
type:"button"},
"Exit")));
}
function useLexicalCommandsLog(editor){var _React$useState8=
React.useState([]),loggedCommands=_React$useState8[0],setLoggedCommands=_React$useState8[1];
React.useEffect(function(){
var unregisterCommandListeners=new Set();var _loop=function _loop(){if(_isArray){if(_i>=_iterator.length)return"break";_ref4=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)return"break";_ref4=_i.value;}var _ref3=_ref4;var
command=_ref3[0];
unregisterCommandListeners.add(editor.registerCommand(command,function(payload){
setLoggedCommands(function(state){
var newState=[].concat(state);
newState.push({
payload:payload,
type:command.type?command.type:'UNKNOWN'});

if(newState.length>10){
newState.shift();
}
return newState;
});
return false;
},require("Lexical").COMMAND_PRIORITY_HIGH));};for(var _iterator=editor._commands,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref4;var _ret=_loop();if(_ret==="break")break;
}
return function(){return unregisterCommandListeners.forEach(function(unregister){return unregister();});};
},[editor]);
return React.useMemo(function(){return loggedCommands;},[loggedCommands]);
}
function printRangeSelection(selection){
var res='';
var formatText=printFormatProperties(selection);
res+=": range "+(formatText!==''?"{ "+formatText+" }":'')+" "+(selection.style!==''?"{ style: "+selection.style+" } ":'');
var anchor=selection.anchor;
var focus=selection.focus;
var anchorOffset=anchor.offset;
var focusOffset=focus.offset;
res+="\n  \u251C anchor { key: "+anchor.key+", offset: "+(anchorOffset===null?'null':anchorOffset)+", type: "+anchor.type+" }";
res+="\n  \u2514 focus { key: "+focus.key+", offset: "+(focusOffset===null?'null':focusOffset)+", type: "+focus.type+" }";
return res;
}
function printNodeSelection(selection){
if(!require("Lexical").$isNodeSelection(selection))return'';
return": node\n  \u2514 ["+Array.from(selection._nodes).join(', ')+"]";
}
function printTableSelection(selection){
return": table\n  \u2514 { table: "+selection.tableKey+", anchorCell: "+selection.anchor.key+", focusCell: "+selection.focus.key+" }";
}
function generateContent(editor,commandsLog,exportDOM){
var editorState=editor.getEditorState();
var editorConfig=editor._config;
var compositionKey=editor._compositionKey;
var editable=editor._editable;
if(exportDOM){
var htmlString='';
editorState.read(function(){
htmlString=printPrettyHTML(require("LexicalHtml").$generateHtmlFromNodes(editor));
});
return htmlString;
}
var res=' root\n';
var selectionString=editorState.read(function(){
var selection=require("Lexical").$getSelection();
visitTree(require("Lexical").$getRoot(),function(node,indent){
var nodeKey=node.getKey();
var nodeKeyDisplay="("+nodeKey+")";
var typeDisplay=node.getType()||'';
var isSelected=node.isSelected();
var idsDisplay=require("LexicalMark").$isMarkNode(node)?" id: [ "+node.getIDs().join(', ')+" ] ":'';
res+=(isSelected?SYMBOLS.selectedLine:' ')+" "+indent.join(' ')+" "+nodeKeyDisplay+" "+typeDisplay+" "+idsDisplay+" "+printNode(node)+"\n";
res+=printSelectedCharsLine({
indent:indent,
isSelected:isSelected,
node:node,
nodeKeyDisplay:nodeKeyDisplay,
selection:selection,
typeDisplay:typeDisplay});

});
return selection===null?': null':require("Lexical").$isRangeSelection(selection)?printRangeSelection(selection):require("LexicalTable").$isTableSelection(selection)?printTableSelection(selection):printNodeSelection(selection);
});
res+='\n selection'+selectionString;
res+='\n\n commands:';
if(commandsLog.length){
for(var _iterator2=


commandsLog,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref6;if(_isArray2){if(_i2>=_iterator2.length)break;_ref6=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref6=_i2.value;}var _ref7=_ref6;var type=_ref7.type;var payload=_ref7.payload;
res+="\n  \u2514 { type: "+type+", payload: "+(payload instanceof Event?payload.constructor.name:payload)+" }";
}
}else{
res+='\n  └ None dispatched.';
}
res+='\n\n editor:';
res+="\n  \u2514 namespace "+editorConfig.namespace;
if(compositionKey!==null){
res+="\n  \u2514 compositionKey "+compositionKey;
}
res+="\n  \u2514 editable "+String(editable);
return res;
}
function visitTree(currentNode,visitor,indent){if(indent===void 0){indent=[];}
var childNodes=currentNode.getChildren();
var childNodesLength=childNodes.length;
childNodes.forEach(function(childNode,i){
visitor(childNode,indent.concat(i===childNodesLength-1?SYMBOLS.isLastChild:SYMBOLS.hasNextSibling));
if(require("Lexical").$isElementNode(childNode)){
visitTree(childNode,visitor,indent.concat(i===childNodesLength-1?SYMBOLS.ancestorIsLastChild:SYMBOLS.ancestorHasNextSibling));
}
});
}
function normalize(text){
return Object.entries(NON_SINGLE_WIDTH_CHARS_REPLACEMENT).reduce(function(acc,_ref8){var key=_ref8[0],value=_ref8[1];return acc.replace(new RegExp(key,'g'),String(value));},text);
}


function printNode(node){
if(require("Lexical").$isTextNode(node)){
var text=node.getTextContent();
var title=text.length===0?'(empty)':"\""+normalize(text)+"\"";
var properties=printAllTextNodeProperties(node);
return[title,properties.length!==0?"{ "+properties+" }":null].filter(Boolean).join(' ').trim();
}else if(require("LexicalLink").$isLinkNode(node)){
var link=node.getURL();
var _title=link.length===0?'(empty)':"\""+normalize(link)+"\"";
var _properties=printAllLinkNodeProperties(node);
return[_title,_properties.length!==0?"{ "+_properties+" }":null].filter(Boolean).join(' ').trim();
}else{
return'';
}
}
var FORMAT_PREDICATES=[function(node){return node.hasFormat('bold')&&'Bold';},function(node){return node.hasFormat('code')&&'Code';},function(node){return node.hasFormat('italic')&&'Italic';},function(node){return node.hasFormat('strikethrough')&&'Strikethrough';},function(node){return node.hasFormat('subscript')&&'Subscript';},function(node){return node.hasFormat('superscript')&&'Superscript';},function(node){return node.hasFormat('underline')&&'Underline';}];
var DETAIL_PREDICATES=[function(node){return node.isDirectionless()&&'Directionless';},function(node){return node.isUnmergeable()&&'Unmergeable';}];
var MODE_PREDICATES=[function(node){return node.isToken()&&'Token';},function(node){return node.isSegmented()&&'Segmented';}];
function printAllTextNodeProperties(node){
return[printFormatProperties(node),printDetailProperties(node),printModeProperties(node)].filter(Boolean).join(', ');
}
function printAllLinkNodeProperties(node){
return[printTargetProperties(node),printRelProperties(node),printTitleProperties(node)].filter(Boolean).join(', ');
}
function printDetailProperties(nodeOrSelection){
var str=DETAIL_PREDICATES.map(function(predicate){return predicate(nodeOrSelection);}).filter(Boolean).join(', ').toLocaleLowerCase();
if(str!==''){
str='detail: '+str;
}
return str;
}
function printModeProperties(nodeOrSelection){
var str=MODE_PREDICATES.map(function(predicate){return predicate(nodeOrSelection);}).filter(Boolean).join(', ').toLocaleLowerCase();
if(str!==''){
str='mode: '+str;
}
return str;
}
function printFormatProperties(nodeOrSelection){
var str=FORMAT_PREDICATES.map(function(predicate){return predicate(nodeOrSelection);}).filter(Boolean).join(', ').toLocaleLowerCase();
if(str!==''){
str='format: '+str;
}
return str;
}
function printTargetProperties(node){
var str=node.getTarget();

if(str!=null){
str='target: '+str;
}
return str;
}
function printRelProperties(node){
var str=node.getRel();

if(str!=null){
str='rel: '+str;
}
return str;
}
function printTitleProperties(node){
var str=node.getTitle();

if(str!=null){
str='title: '+str;
}
return str;
}
function printSelectedCharsLine(_ref9)






{var indent=_ref9.indent,isSelected=_ref9.isSelected,node=_ref9.node,nodeKeyDisplay=_ref9.nodeKeyDisplay,selection=_ref9.selection,typeDisplay=_ref9.typeDisplay;

if(!require("Lexical").$isTextNode(node)||!require("Lexical").$isRangeSelection(selection)||!isSelected||require("Lexical").$isElementNode(node)){
return'';
}


var anchor=selection.anchor;
var focus=selection.focus;
if(node.getTextContent()===''||anchor.getNode()===selection.focus.getNode()&&anchor.offset===focus.offset){
return'';
}var _$getSelectionStartEn=
$getSelectionStartEnd(node,selection),start=_$getSelectionStartEn[0],end=_$getSelectionStartEn[1];
if(start===end){
return'';
}
var selectionLastIndent=indent[indent.length-1]===SYMBOLS.hasNextSibling?SYMBOLS.ancestorHasNextSibling:SYMBOLS.ancestorIsLastChild;
var indentionChars=[].concat(indent.slice(0,indent.length-1),[selectionLastIndent]);
var unselectedChars=Array(start+1).fill(' ');
var selectedChars=Array(end-start).fill(SYMBOLS.selectedChar);
var paddingLength=typeDisplay.length+3;

var nodePrintSpaces=Array(nodeKeyDisplay.length+paddingLength).fill(' ');
return[SYMBOLS.selectedLine,indentionChars.join(' '),[].concat(nodePrintSpaces,unselectedChars,selectedChars).join('')].join(' ')+'\n';
}
function printPrettyHTML(str){
var div=document.createElement('div');
div.innerHTML=str.trim();
return prettifyHTML(div,0).innerHTML;
}
function prettifyHTML(node,level){
var indentBefore=new Array(level++ +1).join('  ');
var indentAfter=new Array(level-1).join('  ');
var textNode;
for(var i=0;i<node.children.length;i++){
textNode=document.createTextNode('\n'+indentBefore);
node.insertBefore(textNode,node.children[i]);
prettifyHTML(node.children[i],level);
if(node.lastElementChild===node.children[i]){
textNode=document.createTextNode('\n'+indentAfter);
node.appendChild(textNode);
}
}
return node;
}
function $getSelectionStartEnd(node,selection){
var anchorAndFocus=selection.getStartEndPoints();
if(require("Lexical").$isNodeSelection(selection)||anchorAndFocus===null){
return[-1,-1];
}var
anchor=anchorAndFocus[0],focus=anchorAndFocus[1];
var textContent=node.getTextContent();
var textLength=textContent.length;
var start=-1;
var end=-1;


if(anchor.type==='text'&&focus.type==='text'){
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
if(anchorNode===focusNode&&node===anchorNode&&anchor.offset!==focus.offset){var _ref10=
anchor.offset<focus.offset?[anchor.offset,focus.offset]:[focus.offset,anchor.offset];start=_ref10[0];end=_ref10[1];
}else if(node===anchorNode){var _ref11=
anchorNode.isBefore(focusNode)?[anchor.offset,textLength]:[0,anchor.offset];start=_ref11[0];end=_ref11[1];
}else if(node===focusNode){var _ref12=
focusNode.isBefore(anchorNode)?[focus.offset,textLength]:[0,focus.offset];start=_ref12[0];end=_ref12[1];
}else{

start=0;end=textLength;
}
}


var numNonSingleWidthCharBeforeSelection=(textContent.slice(0,start).match(NON_SINGLE_WIDTH_CHARS_REGEX)||[]).length;
var numNonSingleWidthCharInSelection=(textContent.slice(start,end).match(NON_SINGLE_WIDTH_CHARS_REGEX)||[]).length;
return[start+numNonSingleWidthCharBeforeSelection,end+numNonSingleWidthCharBeforeSelection+numNonSingleWidthCharInSelection];
}

exports.TreeView=TreeView;}),null);