/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalCode.dev",["Lexical","LexicalUtils","prismjs"],(function $module_LexicalCode_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';












var mapToPrismLanguage=function mapToPrismLanguage(language){

return language!=null&&Object.prototype.hasOwnProperty.call(require("prismjs").languages,language)?language:undefined;
};
function hasChildDOMNodeTag(node,tagName){
for(var _iterator=node.childNodes,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var child=_ref;
if(require("LexicalUtils").isHTMLElement(child)&&child.tagName===tagName){
return true;
}
hasChildDOMNodeTag(child,tagName);
}
return false;
}
var LANGUAGE_DATA_ATTRIBUTE='data-highlight-language';var


CodeNode=function(_Lexical$ElementNode){babelHelpers.inheritsLoose(CodeNode,_Lexical$ElementNode);CodeNode.


getType=function getType(){
return'code';
};CodeNode.
clone=function clone(node){
return new CodeNode(node.__language,node.__key);
};
function CodeNode(language,key){var _this;
_this=_Lexical$ElementNode.call(this,key)||this;
_this.__language=mapToPrismLanguage(language);return _this;
}var _proto=CodeNode.prototype;_proto.


createDOM=function createDOM(config){
var element=document.createElement('code');
require("LexicalUtils").addClassNamesToElement(element,config.theme.code);
element.setAttribute('spellcheck','false');
var language=this.getLanguage();
if(language){
element.setAttribute(LANGUAGE_DATA_ATTRIBUTE,language);
}
return element;
};_proto.
updateDOM=function updateDOM(prevNode,dom,config){
var language=this.__language;
var prevLanguage=prevNode.__language;
if(language){
if(language!==prevLanguage){
dom.setAttribute(LANGUAGE_DATA_ATTRIBUTE,language);
}
}else if(prevLanguage){
dom.removeAttribute(LANGUAGE_DATA_ATTRIBUTE);
}
return false;
};_proto.
exportDOM=function exportDOM(editor){
var element=document.createElement('pre');
require("LexicalUtils").addClassNamesToElement(element,editor._config.theme.code);
element.setAttribute('spellcheck','false');
var language=this.getLanguage();
if(language){
element.setAttribute(LANGUAGE_DATA_ATTRIBUTE,language);
}
return{
element:element};

};CodeNode.
importDOM=function importDOM(){
return{



code:function code(node){
var isMultiLine=node.textContent!=null&&(/\r?\n/.test(node.textContent)||hasChildDOMNodeTag(node,'BR'));
return isMultiLine?{
conversion:convertPreElement,
priority:1}:
null;
},
div:function div(node){return{
conversion:convertDivElement,
priority:1};},

pre:function pre(node){return{
conversion:convertPreElement,
priority:0};},

table:function table(node){
var table=node;

if(isGitHubCodeTable(table)){
return{
conversion:convertTableElement,
priority:3};

}
return null;
},
td:function td(node){

var td=node;
var table=td.closest('table');
if(isGitHubCodeCell(td)){
return{
conversion:convertTableCellElement,
priority:3};

}
if(table&&isGitHubCodeTable(table)){


return{
conversion:convertCodeNoop,
priority:3};

}
return null;
},
tr:function tr(node){

var tr=node;
var table=tr.closest('table');
if(table&&isGitHubCodeTable(table)){
return{
conversion:convertCodeNoop,
priority:3};

}
return null;
}};

};CodeNode.
importJSON=function importJSON(serializedNode){
var node=$createCodeNode(serializedNode.language);
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode.prototype.
exportJSON.call(this),{
language:this.getLanguage(),
type:'code',
version:1});

};_proto.


insertNewAfter=function insertNewAfter(selection,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var children=this.getChildren();
var childrenLength=children.length;
if(childrenLength>=2&&children[childrenLength-1].getTextContent()==='\n'&&children[childrenLength-2].getTextContent()==='\n'&&selection.isCollapsed()&&selection.anchor.key===this.__key&&selection.anchor.offset===childrenLength){
children[childrenLength-1].remove();
children[childrenLength-2].remove();
var newElement=require("Lexical").$createParagraphNode();
this.insertAfter(newElement,restoreSelection);
return newElement;
}var





anchor=

selection.anchor,focus=selection.focus;
var firstPoint=anchor.isBefore(focus)?anchor:focus;
var firstSelectionNode=firstPoint.getNode();
if(require("Lexical").$isTextNode(firstSelectionNode)){
var node=getFirstCodeNodeOfLine(firstSelectionNode);
var insertNodes=[];

while(true){
if(require("Lexical").$isTabNode(node)){
insertNodes.push(require("Lexical").$createTabNode());
node=node.getNextSibling();
}else if($isCodeHighlightNode(node)){
var spaces=0;
var text=node.getTextContent();
var textSize=node.getTextContentSize();
for(;spaces<textSize&&text[spaces]===' ';spaces++){;}
if(spaces!==0){
insertNodes.push($createCodeHighlightNode(' '.repeat(spaces)));
}
if(spaces!==textSize){
break;
}
node=node.getNextSibling();
}else{
break;
}
}
var split=firstSelectionNode.splitText(anchor.offset)[0];
var x=anchor.offset===0?0:1;
var index=split.getIndexWithinParent()+x;
var codeNode=firstSelectionNode.getParentOrThrow();
var nodesToInsert=[require("Lexical").$createLineBreakNode()].concat(insertNodes);
codeNode.splice(index,0,nodesToInsert);
var last=insertNodes[insertNodes.length-1];
if(last){
last.select();
}else if(anchor.offset===0){
split.selectPrevious();
}else{
split.getNextSibling().selectNext(0,0);
}
}
if($isCodeNode(firstSelectionNode)){var

offset=
selection.anchor.offset;
firstSelectionNode.splice(offset,0,[require("Lexical").$createLineBreakNode()]);
firstSelectionNode.select(offset+1,offset+1);
}
return null;
};_proto.
canIndent=function canIndent(){
return false;
};_proto.
collapseAtStart=function collapseAtStart(){
var paragraph=require("Lexical").$createParagraphNode();
var children=this.getChildren();
children.forEach(function(child){return paragraph.append(child);});
this.replace(paragraph);
return true;
};_proto.
setLanguage=function setLanguage(language){
var writable=this.getWritable();
writable.__language=mapToPrismLanguage(language);
};_proto.
getLanguage=function getLanguage(){
return this.getLatest().__language;
};return CodeNode;}(require("Lexical").ElementNode);

function $createCodeNode(language){
return require("Lexical").$applyNodeReplacement(new CodeNode(language));
}
function $isCodeNode(node){
return node instanceof CodeNode;
}
function convertPreElement(domNode){
var language;
if(require("LexicalUtils").isHTMLElement(domNode)){
language=domNode.getAttribute(LANGUAGE_DATA_ATTRIBUTE);
}
return{
node:$createCodeNode(language)};

}
function convertDivElement(domNode){

var div=domNode;
var isCode=isCodeElement(div);
if(!isCode&&!isCodeChildElement(div)){
return{
node:null};

}
return{
after:function after(childLexicalNodes){
var domParent=domNode.parentNode;
if(domParent!=null&&domNode!==domParent.lastChild){
childLexicalNodes.push(require("Lexical").$createLineBreakNode());
}
return childLexicalNodes;
},
node:isCode?$createCodeNode():null};

}
function convertTableElement(){
return{
node:$createCodeNode()};

}
function convertCodeNoop(){
return{
node:null};

}
function convertTableCellElement(domNode){

var cell=domNode;
return{
after:function after(childLexicalNodes){
if(cell.parentNode&&cell.parentNode.nextSibling){

childLexicalNodes.push(require("Lexical").$createLineBreakNode());
}
return childLexicalNodes;
},
node:null};

}
function isCodeElement(div){
return div.style.fontFamily.match('monospace')!==null;
}
function isCodeChildElement(node){
var parent=node.parentElement;
while(parent!==null){
if(isCodeElement(parent)){
return true;
}
parent=parent.parentElement;
}
return false;
}
function isGitHubCodeCell(cell){
return cell.classList.contains('js-file-line');
}
function isGitHubCodeTable(table){
return table.classList.contains('js-file-line-container');
}








var DEFAULT_CODE_LANGUAGE='javascript';
var CODE_LANGUAGE_FRIENDLY_NAME_MAP={
c:'C',
clike:'C-like',
cpp:'C++',
css:'CSS',
html:'HTML',
java:'Java',
js:'JavaScript',
markdown:'Markdown',
objc:'Objective-C',
plain:'Plain Text',
py:'Python',
rust:'Rust',
sql:'SQL',
swift:'Swift',
typescript:'TypeScript',
xml:'XML'};

var CODE_LANGUAGE_MAP={
cpp:'cpp',
java:'java',
javascript:'js',
md:'markdown',
plaintext:'plain',
python:'py',
text:'plain',
ts:'typescript'};

function normalizeCodeLang(lang){
return CODE_LANGUAGE_MAP[lang]||lang;
}
function getLanguageFriendlyName(lang){
var _lang=normalizeCodeLang(lang);
return CODE_LANGUAGE_FRIENDLY_NAME_MAP[_lang]||_lang;
}
var getDefaultCodeLanguage=function getDefaultCodeLanguage(){return DEFAULT_CODE_LANGUAGE;};
var getCodeLanguages=function getCodeLanguages(){return Object.keys(require("prismjs").languages).filter(


function(language){return typeof require("prismjs").languages[language]!=='function';}).sort();};var


CodeHighlightNode=function(_Lexical$TextNode){babelHelpers.inheritsLoose(CodeHighlightNode,_Lexical$TextNode);


function CodeHighlightNode(text,highlightType,key){var _this2;
_this2=_Lexical$TextNode.call(this,text,key)||this;
_this2.__highlightType=highlightType;return _this2;
}CodeHighlightNode.
getType=function getType(){
return'code-highlight';
};CodeHighlightNode.
clone=function clone(node){
return new CodeHighlightNode(node.__text,node.__highlightType||undefined,node.__key);
};var _proto2=CodeHighlightNode.prototype;_proto2.
getHighlightType=function getHighlightType(){
var self=this.getLatest();
return self.__highlightType;
};_proto2.
canHaveFormat=function canHaveFormat(){
return false;
};_proto2.
createDOM=function createDOM(config){
var element=_Lexical$TextNode.prototype.createDOM.call(this,config);
var className=getHighlightThemeClass(config.theme,this.__highlightType);
require("LexicalUtils").addClassNamesToElement(element,className);
return element;
};_proto2.
updateDOM=function updateDOM(prevNode,dom,config){
var update=_Lexical$TextNode.prototype.updateDOM.call(this,prevNode,dom,config);
var prevClassName=getHighlightThemeClass(config.theme,prevNode.__highlightType);
var nextClassName=getHighlightThemeClass(config.theme,this.__highlightType);
if(prevClassName!==nextClassName){
if(prevClassName){
require("LexicalUtils").removeClassNamesFromElement(dom,prevClassName);
}
if(nextClassName){
require("LexicalUtils").addClassNamesToElement(dom,nextClassName);
}
}
return update;
};CodeHighlightNode.
importJSON=function importJSON(serializedNode){
var node=$createCodeHighlightNode(serializedNode.text,serializedNode.highlightType);
node.setFormat(serializedNode.format);
node.setDetail(serializedNode.detail);
node.setMode(serializedNode.mode);
node.setStyle(serializedNode.style);
return node;
};_proto2.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$TextNode.prototype.
exportJSON.call(this),{
highlightType:this.getHighlightType(),
type:'code-highlight',
version:1});

};_proto2.


setFormat=function setFormat(format){
return this;
};_proto2.
isParentRequired=function isParentRequired(){
return true;
};_proto2.
createParentElementNode=function createParentElementNode(){
return $createCodeNode();
};return CodeHighlightNode;}(require("Lexical").TextNode);

function getHighlightThemeClass(theme,highlightType){
return highlightType&&theme&&theme.codeHighlight&&theme.codeHighlight[highlightType];
}
function $createCodeHighlightNode(text,highlightType){
return require("Lexical").$applyNodeReplacement(new CodeHighlightNode(text,highlightType));
}
function $isCodeHighlightNode(node){
return node instanceof CodeHighlightNode;
}
function getFirstCodeNodeOfLine(anchor){
var previousNode=anchor;
var node=anchor;
while($isCodeHighlightNode(node)||require("Lexical").$isTabNode(node)){
previousNode=node;
node=node.getPreviousSibling();
}
return previousNode;
}
function getLastCodeNodeOfLine(anchor){
var nextNode=anchor;
var node=anchor;
while($isCodeHighlightNode(node)||require("Lexical").$isTabNode(node)){
nextNode=node;
node=node.getNextSibling();
}
return nextNode;
}








var PrismTokenizer={
defaultLanguage:DEFAULT_CODE_LANGUAGE,
tokenize:function tokenize(code,language){
return require("prismjs").tokenize(code,require("prismjs").languages[language||'']||require("prismjs").languages[this.defaultLanguage]);
}};

function getStartOfCodeInLine(anchor,offset){
var last=null;
var lastNonBlank=null;
var node=anchor;
var nodeOffset=offset;
var nodeTextContent=anchor.getTextContent();

while(true){
if(nodeOffset===0){
node=node.getPreviousSibling();
if(node===null){
break;
}
if(!($isCodeHighlightNode(node)||require("Lexical").$isTabNode(node)||require("Lexical").$isLineBreakNode(node))){
throw Error("Expected a valid Code Node: CodeHighlightNode, TabNode, LineBreakNode");
}
if(require("Lexical").$isLineBreakNode(node)){
last={
node:node,
offset:1};

break;
}
nodeOffset=Math.max(0,node.getTextContentSize()-1);
nodeTextContent=node.getTextContent();
}else{
nodeOffset--;
}
var character=nodeTextContent[nodeOffset];
if($isCodeHighlightNode(node)&&character!==' '){
lastNonBlank={
node:node,
offset:nodeOffset};

}
}

if(lastNonBlank!==null){
return lastNonBlank;
}

var codeCharacterAtAnchorOffset=null;
if(offset<anchor.getTextContentSize()){
if($isCodeHighlightNode(anchor)){
codeCharacterAtAnchorOffset=anchor.getTextContent()[offset];
}
}else{
var nextSibling=anchor.getNextSibling();
if($isCodeHighlightNode(nextSibling)){
codeCharacterAtAnchorOffset=nextSibling.getTextContent()[0];
}
}
if(codeCharacterAtAnchorOffset!==null&&codeCharacterAtAnchorOffset!==' '){

return last;
}else{
var nextNonBlank=findNextNonBlankInLine(anchor,offset);
if(nextNonBlank!==null){
return nextNonBlank;
}else{
return last;
}
}
}
function findNextNonBlankInLine(anchor,offset){
var node=anchor;
var nodeOffset=offset;
var nodeTextContent=anchor.getTextContent();
var nodeTextContentSize=anchor.getTextContentSize();

while(true){
if(!$isCodeHighlightNode(node)||nodeOffset===nodeTextContentSize){
node=node.getNextSibling();
if(node===null||require("Lexical").$isLineBreakNode(node)){
return null;
}
if($isCodeHighlightNode(node)){
nodeOffset=0;
nodeTextContent=node.getTextContent();
nodeTextContentSize=node.getTextContentSize();
}
}
if($isCodeHighlightNode(node)){
if(nodeTextContent[nodeOffset]!==' '){
return{
node:node,
offset:nodeOffset};

}
nodeOffset++;
}
}
}
function getEndOfCodeInLine(anchor){
var lastNode=getLastCodeNodeOfLine(anchor);
if(!!require("Lexical").$isLineBreakNode(lastNode)){
throw Error("Unexpected lineBreakNode in getEndOfCodeInLine");
}
return lastNode;
}
function textNodeTransform(node,editor,tokenizer){


var parentNode=node.getParent();
if($isCodeNode(parentNode)){
codeNodeTransform(parentNode,editor,tokenizer);
}else if($isCodeHighlightNode(node)){


node.replace(require("Lexical").$createTextNode(node.__text));
}
}
function updateCodeGutter(node,editor){
var codeElement=editor.getElementByKey(node.getKey());
if(codeElement===null){
return;
}
var children=node.getChildren();
var childrenLength=children.length;

if(childrenLength===codeElement.__cachedChildrenLength){

return;
}

codeElement.__cachedChildrenLength=childrenLength;
var gutter='1';
var count=1;
for(var i=0;i<childrenLength;i++){
if(require("Lexical").$isLineBreakNode(children[i])){
gutter+='\n'+ ++count;
}
}
codeElement.setAttribute('data-gutter',gutter);
}









var nodesCurrentlyHighlighting=new Set();
function codeNodeTransform(node,editor,tokenizer){
var nodeKey=node.getKey();
if(nodesCurrentlyHighlighting.has(nodeKey)){
return;
}
nodesCurrentlyHighlighting.add(nodeKey);


if(node.getLanguage()===undefined){
node.setLanguage(tokenizer.defaultLanguage);
}




editor.update(function(){
updateAndRetainSelection(nodeKey,function(){
var currentNode=require("Lexical").$getNodeByKey(nodeKey);
if(!$isCodeNode(currentNode)||!currentNode.isAttached()){
return false;
}
var code=currentNode.getTextContent();
var tokens=tokenizer.tokenize(code,currentNode.getLanguage()||tokenizer.defaultLanguage);
var highlightNodes=getHighlightNodes(tokens);
var diffRange=getDiffRange(currentNode.getChildren(),highlightNodes);var

from=


diffRange.from,to=diffRange.to,nodesForReplacement=diffRange.nodesForReplacement;
if(from!==to||nodesForReplacement.length){
node.splice(from,to-from,nodesForReplacement);
return true;
}
return false;
});
},{
onUpdate:function onUpdate(){
nodesCurrentlyHighlighting["delete"](nodeKey);
},
skipTransforms:true});

}
function getHighlightNodes(tokens,type){
var nodes=[];
for(var _iterator2=tokens,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray2){if(_i2>=_iterator2.length)break;_ref2=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref2=_i2.value;}var token=_ref2;
if(typeof token==='string'){
var partials=token.split(/(\n|\t)/);
var partialsLength=partials.length;
for(var i=0;i<partialsLength;i++){
var part=partials[i];
if(part==='\n'||part==='\r\n'){
nodes.push(require("Lexical").$createLineBreakNode());
}else if(part==='\t'){
nodes.push(require("Lexical").$createTabNode());
}else if(part.length>0){
nodes.push($createCodeHighlightNode(part,type));
}
}
}else{var

content=
token.content;
if(typeof content==='string'){
nodes.push.apply(nodes,getHighlightNodes([content],token.type));
}else if(Array.isArray(content)){
nodes.push.apply(nodes,getHighlightNodes(content,token.type));
}
}
}
return nodes;
}



function updateAndRetainSelection(nodeKey,updateFn){
var node=require("Lexical").$getNodeByKey(nodeKey);
if(!$isCodeNode(node)||!node.isAttached()){
return;
}
var selection=require("Lexical").$getSelection();


if(!require("Lexical").$isRangeSelection(selection)){
updateFn();
return;
}
var anchor=selection.anchor;
var anchorOffset=anchor.offset;
var isNewLineAnchor=anchor.type==='element'&&require("Lexical").$isLineBreakNode(node.getChildAtIndex(anchor.offset-1));
var textOffset=0;


if(!isNewLineAnchor){
var anchorNode=anchor.getNode();
textOffset=anchorOffset+anchorNode.getPreviousSiblings().reduce(function(offset,_node){
return offset+_node.getTextContentSize();
},0);
}
var hasChanges=updateFn();
if(!hasChanges){
return;
}



if(isNewLineAnchor){
anchor.getNode().select(anchorOffset,anchorOffset);
return;
}



node.getChildren().some(function(_node){
var isText=require("Lexical").$isTextNode(_node);
if(isText||require("Lexical").$isLineBreakNode(_node)){
var textContentSize=_node.getTextContentSize();
if(isText&&textContentSize>=textOffset){
_node.select(textOffset,textOffset);
return true;
}
textOffset-=textContentSize;
}
return false;
});
}



function getDiffRange(prevNodes,nextNodes){
var leadingMatch=0;
while(leadingMatch<prevNodes.length){
if(!isEqual(prevNodes[leadingMatch],nextNodes[leadingMatch])){
break;
}
leadingMatch++;
}
var prevNodesLength=prevNodes.length;
var nextNodesLength=nextNodes.length;
var maxTrailingMatch=Math.min(prevNodesLength,nextNodesLength)-leadingMatch;
var trailingMatch=0;
while(trailingMatch<maxTrailingMatch){
trailingMatch++;
if(!isEqual(prevNodes[prevNodesLength-trailingMatch],nextNodes[nextNodesLength-trailingMatch])){
trailingMatch--;
break;
}
}
var from=leadingMatch;
var to=prevNodesLength-trailingMatch;
var nodesForReplacement=nextNodes.slice(leadingMatch,nextNodesLength-trailingMatch);
return{
from:from,
nodesForReplacement:nodesForReplacement,
to:to};

}
function isEqual(nodeA,nodeB){


return $isCodeHighlightNode(nodeA)&&$isCodeHighlightNode(nodeB)&&nodeA.__text===nodeB.__text&&nodeA.__highlightType===nodeB.__highlightType||require("Lexical").$isTabNode(nodeA)&&require("Lexical").$isTabNode(nodeB)||require("Lexical").$isLineBreakNode(nodeA)&&require("Lexical").$isLineBreakNode(nodeB);
}
function $isSelectionInCode(selection){
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var anchorNode=selection.anchor.getNode();
var focusNode=selection.focus.getNode();
if(anchorNode.is(focusNode)&&$isCodeNode(anchorNode)){
return true;
}
var anchorParent=anchorNode.getParent();
return $isCodeNode(anchorParent)&&anchorParent.is(focusNode.getParent());
}
function $getCodeLines(selection){
var nodes=selection.getNodes();
var lines=[[]];
if(nodes.length===1&&$isCodeNode(nodes[0])){
return lines;
}
var lastLine=lines[0];
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if(!($isCodeHighlightNode(node)||require("Lexical").$isTabNode(node)||require("Lexical").$isLineBreakNode(node))){
throw Error("Expected selection to be inside CodeBlock and consisting of CodeHighlightNode, TabNode and LineBreakNode");
}
if(require("Lexical").$isLineBreakNode(node)){
if(i!==0&&lastLine.length>0){
lastLine=[];
lines.push(lastLine);
}
}else{
lastLine.push(node);
}
}
return lines;
}
function handleTab(shiftKey){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)||!$isSelectionInCode(selection)){
return null;
}
var indentOrOutdent=!shiftKey?require("Lexical").INDENT_CONTENT_COMMAND:require("Lexical").OUTDENT_CONTENT_COMMAND;
var tabOrOutdent=!shiftKey?require("Lexical").INSERT_TAB_COMMAND:require("Lexical").OUTDENT_CONTENT_COMMAND;

var codeLines=$getCodeLines(selection);
if(codeLines.length>1){
return indentOrOutdent;
}

var selectionNodes=selection.getNodes();
var firstNode=selectionNodes[0];
if(!($isCodeNode(firstNode)||$isCodeHighlightNode(firstNode)||require("Lexical").$isTabNode(firstNode)||require("Lexical").$isLineBreakNode(firstNode))){
throw Error("Expected selection firstNode to be CodeHighlightNode or TabNode");
}
if($isCodeNode(firstNode)){
return indentOrOutdent;
}
var firstOfLine=getFirstCodeNodeOfLine(firstNode);
var lastOfLine=getLastCodeNodeOfLine(firstNode);
var anchor=selection.anchor;
var focus=selection.focus;
var selectionFirst;
var selectionLast;
if(focus.isBefore(anchor)){
selectionFirst=focus;
selectionLast=anchor;
}else{
selectionFirst=anchor;
selectionLast=focus;
}
if(firstOfLine!==null&&lastOfLine!==null&&selectionFirst.key===firstOfLine.getKey()&&selectionFirst.offset===0&&selectionLast.key===lastOfLine.getKey()&&selectionLast.offset===lastOfLine.getTextContentSize()){
return indentOrOutdent;
}

return tabOrOutdent;
}
function handleMultilineIndent(type){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)||!$isSelectionInCode(selection)){
return false;
}
var codeLines=$getCodeLines(selection);
var codeLinesLength=codeLines.length;

if(codeLines.length>1){
for(var i=0;i<codeLinesLength;i++){
var line=codeLines[i];
if(line.length>0){
var _firstOfLine=line[0];

if(i===0){
_firstOfLine=getFirstCodeNodeOfLine(_firstOfLine);
}
if(_firstOfLine!==null){
if(type===require("Lexical").INDENT_CONTENT_COMMAND){
_firstOfLine.insertBefore(require("Lexical").$createTabNode());
}else if(require("Lexical").$isTabNode(_firstOfLine)){
_firstOfLine.remove();
}
}
}
}
return true;
}

var selectionNodes=selection.getNodes();
var firstNode=selectionNodes[0];
if(!($isCodeNode(firstNode)||$isCodeHighlightNode(firstNode)||require("Lexical").$isTabNode(firstNode)||require("Lexical").$isLineBreakNode(firstNode))){
throw Error("Expected selection firstNode to be CodeHighlightNode or CodeTabNode");
}
if($isCodeNode(firstNode)){

if(type===require("Lexical").INDENT_CONTENT_COMMAND){
selection.insertNodes([require("Lexical").$createTabNode()]);
}
return true;
}
var firstOfLine=getFirstCodeNodeOfLine(firstNode);
if(!(firstOfLine!==null)){
throw Error("Expected getFirstCodeNodeOfLine to return a valid Code Node");
}
if(type===require("Lexical").INDENT_CONTENT_COMMAND){
if(require("Lexical").$isLineBreakNode(firstOfLine)){
firstOfLine.insertAfter(require("Lexical").$createTabNode());
}else{
firstOfLine.insertBefore(require("Lexical").$createTabNode());
}
}else if(require("Lexical").$isTabNode(firstOfLine)){
firstOfLine.remove();
}
return true;
}
function handleShiftLines(type,event){

var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}var




anchor=

selection.anchor,focus=selection.focus;
var anchorOffset=anchor.offset;
var focusOffset=focus.offset;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
var arrowIsUp=type===require("Lexical").KEY_ARROW_UP_COMMAND;


if(!$isSelectionInCode(selection)||!($isCodeHighlightNode(anchorNode)||require("Lexical").$isTabNode(anchorNode))||!($isCodeHighlightNode(focusNode)||require("Lexical").$isTabNode(focusNode))){
return false;
}
if(!event.altKey){


if(selection.isCollapsed()){
var codeNode=anchorNode.getParentOrThrow();
if(arrowIsUp&&anchorOffset===0&&anchorNode.getPreviousSibling()===null){
var codeNodeSibling=codeNode.getPreviousSibling();
if(codeNodeSibling===null){
codeNode.selectPrevious();
event.preventDefault();
return true;
}
}else if(!arrowIsUp&&anchorOffset===anchorNode.getTextContentSize()&&anchorNode.getNextSibling()===null){
var _codeNodeSibling=codeNode.getNextSibling();
if(_codeNodeSibling===null){
codeNode.selectNext();
event.preventDefault();
return true;
}
}
}
return false;
}
var start;
var end;
if(anchorNode.isBefore(focusNode)){
start=getFirstCodeNodeOfLine(anchorNode);
end=getLastCodeNodeOfLine(focusNode);
}else{
start=getFirstCodeNodeOfLine(focusNode);
end=getLastCodeNodeOfLine(anchorNode);
}
if(start==null||end==null){
return false;
}
var range=start.getNodesBetween(end);
for(var i=0;i<range.length;i++){
var node=range[i];
if(!$isCodeHighlightNode(node)&&!require("Lexical").$isTabNode(node)&&!require("Lexical").$isLineBreakNode(node)){
return false;
}
}




event.preventDefault();
event.stopPropagation();

var linebreak=arrowIsUp?start.getPreviousSibling():end.getNextSibling();
if(!require("Lexical").$isLineBreakNode(linebreak)){
return true;
}
var sibling=arrowIsUp?linebreak.getPreviousSibling():linebreak.getNextSibling();
if(sibling==null){
return true;
}
var maybeInsertionPoint=$isCodeHighlightNode(sibling)||require("Lexical").$isTabNode(sibling)||require("Lexical").$isLineBreakNode(sibling)?arrowIsUp?getFirstCodeNodeOfLine(sibling):getLastCodeNodeOfLine(sibling):null;
var insertionPoint=maybeInsertionPoint!=null?maybeInsertionPoint:sibling;
linebreak.remove();
range.forEach(function(node){return node.remove();});
if(type===require("Lexical").KEY_ARROW_UP_COMMAND){
range.forEach(function(node){return insertionPoint.insertBefore(node);});
insertionPoint.insertBefore(linebreak);
}else{
insertionPoint.insertAfter(linebreak);
insertionPoint=linebreak;
range.forEach(function(node){
insertionPoint.insertAfter(node);
insertionPoint=node;
});
}
selection.setTextNodeRange(anchorNode,anchorOffset,focusNode,focusOffset);
return true;
}
function handleMoveTo(type,event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}var

anchor=

selection.anchor,focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
var isMoveToStart=type===require("Lexical").MOVE_TO_START;
if(!($isCodeHighlightNode(anchorNode)||require("Lexical").$isTabNode(anchorNode))||!($isCodeHighlightNode(focusNode)||require("Lexical").$isTabNode(focusNode))){
return false;
}
if(isMoveToStart){
var start=getStartOfCodeInLine(focusNode,focus.offset);
if(start!==null){var

node=

start.node,offset=start.offset;
if(require("Lexical").$isLineBreakNode(node)){
node.selectNext(0,0);
}else{
selection.setTextNodeRange(node,offset,node,offset);
}
}else{
focusNode.getParentOrThrow().selectStart();
}
}else{
var _node2=getEndOfCodeInLine(focusNode);
_node2.select();
}
event.preventDefault();
event.stopPropagation();
return true;
}
function registerCodeHighlighting(editor,tokenizer){
if(!editor.hasNodes([CodeNode,CodeHighlightNode])){
throw new Error('CodeHighlightPlugin: CodeNode or CodeHighlightNode not registered on editor');
}
if(tokenizer==null){
tokenizer=PrismTokenizer;
}
return require("LexicalUtils").mergeRegister(editor.registerMutationListener(CodeNode,function(mutations){
editor.update(function(){
for(var _iterator3=mutations,_isArray3=Array.isArray(_iterator3),_i3=0,_iterator3=_isArray3?_iterator3:_iterator3[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref4;if(_isArray3){if(_i3>=_iterator3.length)break;_ref4=_iterator3[_i3++];}else{_i3=_iterator3.next();if(_i3.done)break;_ref4=_i3.value;}var _ref5=_ref4;var key=_ref5[0];var type=_ref5[1];
if(type!=='destroyed'){
var node=require("Lexical").$getNodeByKey(key);
if(node!==null){
updateCodeGutter(node,editor);
}
}
}
});
}),editor.registerNodeTransform(CodeNode,function(node){return codeNodeTransform(node,editor,tokenizer);}),editor.registerNodeTransform(require("Lexical").TextNode,function(node){return textNodeTransform(node,editor,tokenizer);}),editor.registerNodeTransform(CodeHighlightNode,function(node){return textNodeTransform(node,editor,tokenizer);}),editor.registerCommand(require("Lexical").KEY_TAB_COMMAND,function(event){
var command=handleTab(event.shiftKey);
if(command===null){
return false;
}
event.preventDefault();
editor.dispatchCommand(command,undefined);
return true;
},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").INSERT_TAB_COMMAND,function(){
var selection=require("Lexical").$getSelection();
if(!$isSelectionInCode(selection)){
return false;
}
require("Lexical").$insertNodes([require("Lexical").$createTabNode()]);
return true;
},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").INDENT_CONTENT_COMMAND,function(payload){return handleMultilineIndent(require("Lexical").INDENT_CONTENT_COMMAND);},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").OUTDENT_CONTENT_COMMAND,function(payload){return handleMultilineIndent(require("Lexical").OUTDENT_CONTENT_COMMAND);},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").KEY_ARROW_UP_COMMAND,function(payload){return handleShiftLines(require("Lexical").KEY_ARROW_UP_COMMAND,payload);},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").KEY_ARROW_DOWN_COMMAND,function(payload){return handleShiftLines(require("Lexical").KEY_ARROW_DOWN_COMMAND,payload);},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").MOVE_TO_END,function(payload){return handleMoveTo(require("Lexical").MOVE_TO_END,payload);},require("Lexical").COMMAND_PRIORITY_LOW),editor.registerCommand(require("Lexical").MOVE_TO_START,function(payload){return handleMoveTo(require("Lexical").MOVE_TO_START,payload);},require("Lexical").COMMAND_PRIORITY_LOW));
}

exports.$createCodeHighlightNode=$createCodeHighlightNode;
exports.$createCodeNode=$createCodeNode;
exports.$isCodeHighlightNode=$isCodeHighlightNode;
exports.$isCodeNode=$isCodeNode;
exports.CODE_LANGUAGE_FRIENDLY_NAME_MAP=CODE_LANGUAGE_FRIENDLY_NAME_MAP;
exports.CODE_LANGUAGE_MAP=CODE_LANGUAGE_MAP;
exports.CodeHighlightNode=CodeHighlightNode;
exports.CodeNode=CodeNode;
exports.DEFAULT_CODE_LANGUAGE=DEFAULT_CODE_LANGUAGE;
exports.PrismTokenizer=PrismTokenizer;
exports.getCodeLanguages=getCodeLanguages;
exports.getDefaultCodeLanguage=getDefaultCodeLanguage;
exports.getEndOfCodeInLine=getEndOfCodeInLine;
exports.getFirstCodeNodeOfLine=getFirstCodeNodeOfLine;
exports.getLanguageFriendlyName=getLanguageFriendlyName;
exports.getLastCodeNodeOfLine=getLastCodeNodeOfLine;
exports.getStartOfCodeInLine=getStartOfCodeInLine;
exports.normalizeCodeLang=normalizeCodeLang;
exports.registerCodeHighlighting=registerCodeHighlighting;}),null);