/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalHtml.dev",["Lexical","LexicalSelection","LexicalUtils"],(function $module_LexicalHtml_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';












function $generateNodesFromDOM(editor,dom){
var elements=dom.body?dom.body.childNodes:[];
var lexicalNodes=[];
for(var i=0;i<elements.length;i++){
var element=elements[i];
if(!IGNORE_TAGS.has(element.nodeName)){
var lexicalNode=$createNodesFromDOM(element,editor);
if(lexicalNode!==null){
lexicalNodes=lexicalNodes.concat(lexicalNode);
}
}
}
return lexicalNodes;
}
function $generateHtmlFromNodes(editor,selection){
if(typeof document==='undefined'||typeof window==='undefined'&&typeof global.window==='undefined'){
throw new Error('To use $generateHtmlFromNodes in headless mode please initialize a headless browser implementation such as JSDom before calling this function.');
}
var container=document.createElement('div');
var root=require("Lexical").$getRoot();
var topLevelChildren=root.getChildren();
for(var i=0;i<topLevelChildren.length;i++){
var topLevelNode=topLevelChildren[i];
$appendNodesToHTML(editor,topLevelNode,container,selection);
}
return container.innerHTML;
}
function $appendNodesToHTML(editor,currentNode,parentElement,selection){if(selection===void 0){selection=null;}
var shouldInclude=selection!==null?currentNode.isSelected(selection):true;
var shouldExclude=require("Lexical").$isElementNode(currentNode)&&currentNode.excludeFromCopy('html');
var target=currentNode;
if(selection!==null){
var clone=require("LexicalSelection").$cloneWithProperties(currentNode);
clone=require("Lexical").$isTextNode(clone)&&selection!==null?require("LexicalSelection").$sliceSelectedTextNodeContent(selection,clone):clone;
target=clone;
}
var children=require("Lexical").$isElementNode(target)?target.getChildren():[];
var registeredNode=editor._nodes.get(target.getType());
var exportOutput;


if(registeredNode&&registeredNode.exportDOM!==undefined){
exportOutput=registeredNode.exportDOM(editor,target);
}else{
exportOutput=target.exportDOM(editor);
}var _exportOutput=



exportOutput,element=_exportOutput.element,after=_exportOutput.after;
if(!element){
return false;
}
var fragment=document.createDocumentFragment();
for(var i=0;i<children.length;i++){
var childNode=children[i];
var shouldIncludeChild=$appendNodesToHTML(editor,childNode,fragment,selection);
if(!shouldInclude&&require("Lexical").$isElementNode(currentNode)&&shouldIncludeChild&&currentNode.extractWithChild(childNode,selection,'html')){
shouldInclude=true;
}
}
if(shouldInclude&&!shouldExclude){
if(require("LexicalUtils").isHTMLElement(element)){
element.append(fragment);
}
parentElement.append(element);
if(after){
var newElement=after.call(target,element);
if(newElement)element.replaceWith(newElement);
}
}else{
parentElement.append(fragment);
}
return shouldInclude;
}
function getConversionFunction(domNode,editor){var

nodeName=
domNode.nodeName;
var cachedConversions=editor._htmlConversions.get(nodeName.toLowerCase());
var currentConversion=null;
if(cachedConversions!==undefined){
for(var _iterator=cachedConversions,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var cachedConversion=_ref;
var domConversion=cachedConversion(domNode);
if(domConversion!==null&&(currentConversion===null||(currentConversion.priority||0)<(domConversion.priority||0))){
currentConversion=domConversion;
}
}
}
return currentConversion!==null?currentConversion.conversion:null;
}
var IGNORE_TAGS=new Set(['STYLE','SCRIPT']);
function $createNodesFromDOM(node,editor,forChildMap,parentLexicalNode){if(forChildMap===void 0){forChildMap=new Map();}
var lexicalNodes=[];
if(IGNORE_TAGS.has(node.nodeName)){
return lexicalNodes;
}
var currentLexicalNode=null;
var transformFunction=getConversionFunction(node,editor);
var transformOutput=transformFunction?transformFunction(node):null;
var postTransform=null;
if(transformOutput!==null){
postTransform=transformOutput.after;
var transformNodes=transformOutput.node;
currentLexicalNode=Array.isArray(transformNodes)?transformNodes[transformNodes.length-1]:transformNodes;
if(currentLexicalNode!==null){
for(var _iterator2=forChildMap,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref3;if(_isArray2){if(_i2>=_iterator2.length)break;_ref3=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref3=_i2.value;}var _ref4=_ref3;var forChildFunction=_ref4[1];
currentLexicalNode=forChildFunction(currentLexicalNode,parentLexicalNode);
if(!currentLexicalNode){
break;
}
}
if(currentLexicalNode){var _lexicalNodes;
(_lexicalNodes=lexicalNodes).push.apply(_lexicalNodes,Array.isArray(transformNodes)?transformNodes:[currentLexicalNode]);
}
}
if(transformOutput.forChild!=null){
forChildMap.set(node.nodeName,transformOutput.forChild);
}
}



var children=node.childNodes;
var childLexicalNodes=[];
for(var i=0;i<children.length;i++){var _childLexicalNodes;
(_childLexicalNodes=childLexicalNodes).push.apply(_childLexicalNodes,$createNodesFromDOM(children[i],editor,new Map(forChildMap),currentLexicalNode));
}
if(postTransform!=null){
childLexicalNodes=postTransform(childLexicalNodes);
}
if(currentLexicalNode==null){


lexicalNodes=lexicalNodes.concat(childLexicalNodes);
}else{
if(require("Lexical").$isElementNode(currentLexicalNode)){var _currentLexicalNode;


(_currentLexicalNode=currentLexicalNode).append.apply(_currentLexicalNode,childLexicalNodes);
}
}
return lexicalNodes;
}

exports.$generateHtmlFromNodes=$generateHtmlFromNodes;
exports.$generateNodesFromDOM=$generateNodesFromDOM;}),null);