/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("useLexicalNodeSelection.dev",["Lexical","LexicalComposerContext","react"],(function $module_useLexicalNodeSelection_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;



var react=_require_closure_react||(_require_closure_react=require("react"));








function isNodeSelected(editor,key){
return editor.getEditorState().read(function(){
var node=require("Lexical").$getNodeByKey(key);
if(node===null){
return false;
}
return node.isSelected();
});
}
function useLexicalNodeSelection(key){var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];var _react$useState=
react.useState(function(){return isNodeSelected(editor,key);}),isSelected=_react$useState[0],setIsSelected=_react$useState[1];
react.useEffect(function(){
var isMounted=true;
var unregister=editor.registerUpdateListener(function(){
if(isMounted){
setIsSelected(isNodeSelected(editor,key));
}
});
return function(){
isMounted=false;
unregister();
};
},[editor,key]);
var setSelected=react.useCallback(function(selected){
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isNodeSelection(selection)){
selection=require("Lexical").$createNodeSelection();
require("Lexical").$setSelection(selection);
}
if(require("Lexical").$isNodeSelection(selection)){
if(selected){
selection.add(key);
}else{
selection["delete"](key);
}
}
});
},[editor,key]);
var clearSelected=react.useCallback(function(){
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)){
selection.clear();
}
});
},[editor]);
return[isSelected,setSelected,clearSelected];
}

exports.useLexicalNodeSelection=useLexicalNodeSelection;}),null);