/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalMark.dev",["Lexical","LexicalUtils"],(function $module_LexicalMark_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var












MarkNode=function(_Lexical$ElementNode){babelHelpers.inheritsLoose(MarkNode,_Lexical$ElementNode);MarkNode.


getType=function getType(){
return'mark';
};MarkNode.
clone=function clone(node){
return new MarkNode(Array.from(node.__ids),node.__key);
};MarkNode.
importDOM=function importDOM(){
return null;
};MarkNode.
importJSON=function importJSON(serializedNode){
var node=$createMarkNode(serializedNode.ids);
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};var _proto=MarkNode.prototype;_proto.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode.prototype.
exportJSON.call(this),{
ids:this.getIDs(),
type:'mark',
version:1});

};
function MarkNode(ids,key){var _this;
_this=_Lexical$ElementNode.call(this,key)||this;
_this.__ids=ids||[];return _this;
}_proto.
createDOM=function createDOM(config){
var element=document.createElement('mark');
require("LexicalUtils").addClassNamesToElement(element,config.theme.mark);
if(this.__ids.length>1){
require("LexicalUtils").addClassNamesToElement(element,config.theme.markOverlap);
}
return element;
};_proto.
updateDOM=function updateDOM(prevNode,element,config){
var prevIDs=prevNode.__ids;
var nextIDs=this.__ids;
var prevIDsCount=prevIDs.length;
var nextIDsCount=nextIDs.length;
var overlapTheme=config.theme.markOverlap;
if(prevIDsCount!==nextIDsCount){
if(prevIDsCount===1){
if(nextIDsCount===2){
require("LexicalUtils").addClassNamesToElement(element,overlapTheme);
}
}else if(nextIDsCount===1){
require("LexicalUtils").removeClassNamesFromElement(element,overlapTheme);
}
}
return false;
};_proto.
hasID=function hasID(id){
var ids=this.getIDs();
for(var i=0;i<ids.length;i++){
if(id===ids[i]){
return true;
}
}
return false;
};_proto.
getIDs=function getIDs(){
var self=this.getLatest();
return $isMarkNode(self)?self.__ids:[];
};_proto.
addID=function addID(id){
var self=this.getWritable();
if($isMarkNode(self)){
var ids=self.__ids;
self.__ids=ids;
for(var i=0;i<ids.length;i++){

if(id===ids[i])return;
}
ids.push(id);
}
};_proto.
deleteID=function deleteID(id){
var self=this.getWritable();
if($isMarkNode(self)){
var ids=self.__ids;
self.__ids=ids;
for(var i=0;i<ids.length;i++){
if(id===ids[i]){
ids.splice(i,1);
return;
}
}
}
};_proto.
insertNewAfter=function insertNewAfter(selection,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var markNode=$createMarkNode(this.__ids);
this.insertAfter(markNode,restoreSelection);
return markNode;
};_proto.
canInsertTextBefore=function canInsertTextBefore(){
return false;
};_proto.
canInsertTextAfter=function canInsertTextAfter(){
return false;
};_proto.
canBeEmpty=function canBeEmpty(){
return false;
};_proto.
isInline=function isInline(){
return true;
};_proto.
extractWithChild=function extractWithChild(child,selection,destination){
if(!require("Lexical").$isRangeSelection(selection)||destination==='html'){
return false;
}
var anchor=selection.anchor;
var focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
var isBackward=selection.isBackward();
var selectionLength=isBackward?anchor.offset-focus.offset:focus.offset-anchor.offset;
return this.isParentOf(anchorNode)&&this.isParentOf(focusNode)&&this.getTextContent().length===selectionLength;
};_proto.
excludeFromCopy=function excludeFromCopy(destination){
return destination!=='clone';
};return MarkNode;}(require("Lexical").ElementNode);

function $createMarkNode(ids){
return require("Lexical").$applyNodeReplacement(new MarkNode(ids));
}
function $isMarkNode(node){
return node instanceof MarkNode;
}


function $unwrapMarkNode(node){
var children=node.getChildren();
var target=null;
for(var i=0;i<children.length;i++){
var child=children[i];
if(target===null){
node.insertBefore(child);
}else{
target.insertAfter(child);
}
target=child;
}
node.remove();
}
function $wrapSelectionInMarkNode(selection,isBackward,id,createNode){
var nodes=selection.getNodes();
var anchorOffset=selection.anchor.offset;
var focusOffset=selection.focus.offset;
var nodesLength=nodes.length;
var startOffset=isBackward?focusOffset:anchorOffset;
var endOffset=isBackward?anchorOffset:focusOffset;
var currentNodeParent;
var lastCreatedMarkNode;





for(var i=0;i<nodesLength;i++){
var node=nodes[i];
if(require("Lexical").$isElementNode(lastCreatedMarkNode)&&lastCreatedMarkNode.isParentOf(node)){

continue;
}
var isFirstNode=i===0;
var isLastNode=i===nodesLength-1;
var targetNode=null;
if(require("Lexical").$isTextNode(node)){

var textContentSize=node.getTextContentSize();
var startTextOffset=isFirstNode?startOffset:0;
var endTextOffset=isLastNode?endOffset:textContentSize;
if(startTextOffset===0&&endTextOffset===0){
continue;
}
var splitNodes=node.splitText(startTextOffset,endTextOffset);
targetNode=splitNodes.length>1&&(splitNodes.length===3||isFirstNode&&!isLastNode||endTextOffset===textContentSize)?splitNodes[1]:splitNodes[0];
}else if($isMarkNode(node)){






continue;
}else if(require("Lexical").$isElementNode(node)&&node.isInline()){


targetNode=node;
}
if(targetNode!==null){


if(targetNode&&targetNode.is(currentNodeParent)){


continue;
}
var parentNode=targetNode.getParent();
if(parentNode==null||!parentNode.is(currentNodeParent)){


lastCreatedMarkNode=undefined;
}
currentNodeParent=parentNode;
if(lastCreatedMarkNode===undefined){

var createMarkNode=createNode||$createMarkNode;
lastCreatedMarkNode=createMarkNode([id]);
targetNode.insertBefore(lastCreatedMarkNode);
}


lastCreatedMarkNode.append(targetNode);
}else{


currentNodeParent=undefined;
lastCreatedMarkNode=undefined;
}
}

if(require("Lexical").$isElementNode(lastCreatedMarkNode)){

isBackward?lastCreatedMarkNode.selectStart():lastCreatedMarkNode.selectEnd();
}
}
function $getMarkIDs(node,offset){
var currentNode=node;
while(currentNode!==null){
if($isMarkNode(currentNode)){
return currentNode.getIDs();
}else if(require("Lexical").$isTextNode(currentNode)&&offset===currentNode.getTextContentSize()){
var nextSibling=currentNode.getNextSibling();
if($isMarkNode(nextSibling)){
return nextSibling.getIDs();
}
}
currentNode=currentNode.getParent();
}
return null;
}

exports.$createMarkNode=$createMarkNode;
exports.$getMarkIDs=$getMarkIDs;
exports.$isMarkNode=$isMarkNode;
exports.$unwrapMarkNode=$unwrapMarkNode;
exports.$wrapSelectionInMarkNode=$wrapSelectionInMarkNode;
exports.MarkNode=MarkNode;}),null);