/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalPlainText.dev",["Lexical","LexicalClipboard","LexicalSelection","LexicalUtils"],(function $module_LexicalPlainText_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';














var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var documentMode=CAN_USE_DOM&&'documentMode'in document?document.documentMode:null;
CAN_USE_DOM&&/Mac|iPod|iPhone|iPad/.test(navigator.platform);
CAN_USE_DOM&&/^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);
var CAN_USE_BEFORE_INPUT=CAN_USE_DOM&&'InputEvent'in window&&!documentMode?'getTargetRanges'in new window.InputEvent('input'):false;
var IS_SAFARI=CAN_USE_DOM&&/Version\/[\d.]+.*Safari/.test(navigator.userAgent);
var IS_IOS=CAN_USE_DOM&&/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream;
CAN_USE_DOM&&/Android/.test(navigator.userAgent);



var IS_CHROME=CAN_USE_DOM&&/^(?=.*Chrome).*/i.test(navigator.userAgent);


var IS_APPLE_WEBKIT=CAN_USE_DOM&&/AppleWebKit\/[\d.]+/.test(navigator.userAgent)&&!IS_CHROME;


function onCopyForPlainText(event,editor){
editor.update(function(){
if(event!==null){
var clipboardData=event instanceof KeyboardEvent?null:event.clipboardData;
var selection=require("Lexical").$getSelection();
if(selection!==null&&clipboardData!=null){
event.preventDefault();
var htmlString=require("LexicalClipboard").$getHtmlContent(editor);
if(htmlString!==null){
clipboardData.setData('text/html',htmlString);
}
clipboardData.setData('text/plain',selection.getTextContent());
}
}
});
}
function onPasteForPlainText(event,editor){
event.preventDefault();
editor.update(function(){
var selection=require("Lexical").$getSelection();var

clipboardData=
event.clipboardData;
if(clipboardData!=null&&require("Lexical").$isRangeSelection(selection)){
require("LexicalClipboard").$insertDataTransferForPlainText(clipboardData,selection);
}
},{
tag:'paste'});

}
function onCutForPlainText(event,editor){
onCopyForPlainText(event,editor);
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){
selection.removeText();
}
});
}
function registerPlainText(editor){var _require_Lexical;
var removeListener=require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).DELETE_CHARACTER_COMMAND,function(isBackward){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.deleteCharacter(isBackward);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DELETE_WORD_COMMAND,function(isBackward){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.deleteWord(isBackward);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DELETE_LINE_COMMAND,function(isBackward){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.deleteLine(isBackward);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.CONTROLLED_TEXT_INSERTION_COMMAND,function(eventOrText){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
if(typeof eventOrText==='string'){
selection.insertText(eventOrText);
}else{
var dataTransfer=eventOrText.dataTransfer;
if(dataTransfer!=null){
require("LexicalClipboard").$insertDataTransferForPlainText(dataTransfer,selection);
}else{
var data=eventOrText.data;
if(data){
selection.insertText(data);
}
}
}
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.REMOVE_TEXT_COMMAND,function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.removeText();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.INSERT_LINE_BREAK_COMMAND,function(selectStart){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.insertLineBreak(selectStart);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.INSERT_PARAGRAPH_COMMAND,function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.insertLineBreak();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ARROW_LEFT_COMMAND,function(payload){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var event=payload;
var isHoldingShift=event.shiftKey;
if(require("LexicalSelection").$shouldOverrideDefaultCharacterSelection(selection,true)){
event.preventDefault();
require("LexicalSelection").$moveCharacter(selection,isHoldingShift,true);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ARROW_RIGHT_COMMAND,function(payload){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var event=payload;
var isHoldingShift=event.shiftKey;
if(require("LexicalSelection").$shouldOverrideDefaultCharacterSelection(selection,false)){
event.preventDefault();
require("LexicalSelection").$moveCharacter(selection,isHoldingShift,false);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_BACKSPACE_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
event.preventDefault();
return editor.dispatchCommand(require("Lexical").DELETE_CHARACTER_COMMAND,true);
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_DELETE_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
event.preventDefault();
return editor.dispatchCommand(require("Lexical").DELETE_CHARACTER_COMMAND,false);
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ENTER_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
if(event!==null){







if((IS_IOS||IS_SAFARI||IS_APPLE_WEBKIT)&&CAN_USE_BEFORE_INPUT){
return false;
}
event.preventDefault();
}
return editor.dispatchCommand(require("Lexical").INSERT_LINE_BREAK_COMMAND,false);
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.SELECT_ALL_COMMAND,function(){
require("Lexical").$selectAll();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.COPY_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
onCopyForPlainText(event,editor);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.CUT_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
onCutForPlainText(event,editor);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.PASTE_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
onPasteForPlainText(event,editor);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DROP_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}


event.preventDefault();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DRAGSTART_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}


event.preventDefault();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR));
return removeListener;
}

exports.registerPlainText=registerPlainText;}),null);