/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalHorizontalRuleNode.dev",["Lexical","LexicalComposerContext","LexicalUtils","react","useLexicalNodeSelection"],(function $module_LexicalHorizontalRuleNode_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;





var React=_require_closure_react||(_require_closure_react=require("react"));








var INSERT_HORIZONTAL_RULE_COMMAND=require("Lexical").createCommand('INSERT_HORIZONTAL_RULE_COMMAND');
function HorizontalRuleComponent(_ref)

{var nodeKey=_ref.nodeKey;var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];var _useLexicalNodeSelect=
require("useLexicalNodeSelection").useLexicalNodeSelection(nodeKey),isSelected=_useLexicalNodeSelect[0],setSelected=_useLexicalNodeSelect[1],clearSelection=_useLexicalNodeSelect[2];
var onDelete=React.useCallback(function(event){
if(isSelected&&require("Lexical").$isNodeSelection(require("Lexical").$getSelection())){
event.preventDefault();
var node=require("Lexical").$getNodeByKey(nodeKey);
if($isHorizontalRuleNode(node)){
node.remove();
return true;
}
}
return false;
},[isSelected,nodeKey]);
React.useEffect(function(){var _require_Lexical;
return require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).CLICK_COMMAND,function(event){
var hrElem=editor.getElementByKey(nodeKey);
if(event.target===hrElem){
if(!event.shiftKey){
clearSelection();
}
setSelected(!isSelected);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_LOW),editor.registerCommand(_require_Lexical.KEY_DELETE_COMMAND,onDelete,_require_Lexical.COMMAND_PRIORITY_LOW),editor.registerCommand(_require_Lexical.KEY_BACKSPACE_COMMAND,onDelete,_require_Lexical.COMMAND_PRIORITY_LOW));
},[clearSelection,editor,isSelected,nodeKey,onDelete,setSelected]);
React.useEffect(function(){
var hrElem=editor.getElementByKey(nodeKey);
if(hrElem!==null){
hrElem.className=isSelected?'selected':'';
}
},[editor,isSelected,nodeKey]);
return null;
}var
HorizontalRuleNode=function(_Lexical$DecoratorNod){babelHelpers.inheritsLoose(HorizontalRuleNode,_Lexical$DecoratorNod);function HorizontalRuleNode(){return _Lexical$DecoratorNod.apply(this,arguments)||this;}HorizontalRuleNode.
getType=function getType(){
return'horizontalrule';
};HorizontalRuleNode.
clone=function clone(node){
return new HorizontalRuleNode(node.__key);
};HorizontalRuleNode.
importJSON=function importJSON(serializedNode){
return $createHorizontalRuleNode();
};HorizontalRuleNode.
importDOM=function importDOM(){
return{
hr:function hr(){return{
conversion:convertHorizontalRuleElement,
priority:0};}};


};var _proto=HorizontalRuleNode.prototype;_proto.
exportJSON=function exportJSON(){
return{
type:'horizontalrule',
version:1};

};_proto.
exportDOM=function exportDOM(){
return{
element:document.createElement('hr')};

};_proto.
createDOM=function createDOM(){
return document.createElement('hr');
};_proto.
getTextContent=function getTextContent(){
return'\n';
};_proto.
isInline=function isInline(){
return false;
};_proto.
updateDOM=function updateDOM(){
return false;
};_proto.
decorate=function decorate(){
return React.createElement(HorizontalRuleComponent,{
nodeKey:this.__key});

};return HorizontalRuleNode;}(require("Lexical").DecoratorNode);

function convertHorizontalRuleElement(){
return{
node:$createHorizontalRuleNode()};

}
function $createHorizontalRuleNode(){
return require("Lexical").$applyNodeReplacement(new HorizontalRuleNode());
}
function $isHorizontalRuleNode(node){
return node instanceof HorizontalRuleNode;
}

exports.$createHorizontalRuleNode=$createHorizontalRuleNode;
exports.$isHorizontalRuleNode=$isHorizontalRuleNode;
exports.HorizontalRuleNode=HorizontalRuleNode;
exports.INSERT_HORIZONTAL_RULE_COMMAND=INSERT_HORIZONTAL_RULE_COMMAND;}),null);