/**
 * Copyright (c) 2017 <owner>. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modificati
 * on, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, thi
 * s list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and
 * /or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 *  may be used to endorse or promote products derived from this software withou
 * t specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" A
 * ND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPL
 * IED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DI
 * SCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FO
 * R ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMA
 * GES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVIC
 * ES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED A
 * ND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THI
 * S SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @noflow
 * @MWPCoreComponent
 * @nolint
 * @preserve-whitespace
 * @oncall maps
 * @lightSyntaxTransform
 * @providesInline maplibre_gl_worker_2.4.0
 */

var sharedChunk = {}; (function(t){var e=r;function r(t,e,r,n){this.cx=3*t, this.bx=3*(r-t)-this.cx, this.ax=1-this.cx-this.bx, this.cy=3*e, this.by=3*(n-e)-this.cy, this.ay=1-this.cy-this.by, this.p1x=t, this.p1y=e, this.p2x=r, this.p2y=n;}function n(t,r,n,i){const a=new e(t,r,n,i);return function(t){return a.solve(t)}}r.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6), t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var a=this.sampleCurveDerivativeX(r);if(Math.abs(a)<1e-6)break;r-=i/a;}var s=0,o=1;for(r=t, n=0;n<20&&(i=this.sampleCurveX(r), !(Math.abs(i-t)<e));n++)t>i?s=r:o=r, r=.5*(o-s)+s;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};const i=n(.25,.1,.25,1);function a(t,e,r){return Math.min(r,Math.max(e,t))}function s(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function o(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let l=1;function u(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function c(t,e,r){const n={};for(const i in t)n[i]=e.call(r||this,t[i],i,t);return n}function h(t,e,r){const n={};for(const i in t)e.call(r||this,t[i],i,t)&&(n[i]=t[i]);return n}function p(t){return Array.isArray(t)?t.map(p):"object"==typeof t&&t?c(t,p):t}const f={};function d(t){f[t]||("undefined"!=typeof console&&console.warn(t), f[t]=!0);}function y(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function m(t){let e=0;for(let r,n,i=0,a=t.length,s=a-1;i<a;s=i++)r=t[i], n=t[s], e+=(n.x-r.x)*(r.y+n.y);return e}function g(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function x(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const a=n||i;return e[r]=!a||a.toLowerCase(), ""})), e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let v,b,w=null;function _(t){if(null==w){const e=t.navigator?t.navigator.userAgent:null;w=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return w}function A(t){return "undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const k={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const r=window.document.createElement("canvas"),n=r.getContext("2d");if(!n)throw new Error("failed to create canvas 2d context");return r.width=t.width, r.height=t.height, n.drawImage(t,0,0,t.width,t.height), n.getImageData(-e,-e,t.width+2*e,t.height+2*e)},resolveURL:t=>(v||(v=document.createElement("a")), v.href=t, v.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return !!matchMedia&&(null==b&&(b=matchMedia("(prefers-reduced-motion: reduce)")), b.matches)}};var S=I;function I(t,e){this.x=t, this.y=e;}I.prototype={clone:function(){return new I(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y, this.y=e, this},_add:function(t){return this.x+=t.x, this.y+=t.y, this},_sub:function(t){return this.x-=t.x, this.y-=t.y, this},_mult:function(t){return this.x*=t, this.y*=t, this},_div:function(t){return this.x/=t, this.y/=t, this},_multByPoint:function(t){return this.x*=t.x, this.y*=t.y, this},_divByPoint:function(t){return this.x/=t.x, this.y/=t.y, this},_unit:function(){return this._div(this.mag()), this},_perp:function(){var t=this.y;return this.y=this.x, this.x=-t, this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y, this.y=n, this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y), this.y=i, this},_round:function(){return this.x=Math.round(this.x), this.y=Math.round(this.y), this}}, I.convert=function(t){return t instanceof I?t:Array.isArray(t)?new I(t[0],t[1]):t};const M={MAX_PARALLEL_IMAGE_REQUESTS:16,REGISTERED_PROTOCOLS:{}},z="mapbox-tiles";let B,C,P=500,V=50;function E(){"undefined"==typeof caches||B||(B=caches.open(z));}let F=1/0;const T={supported:!1,testSupport:function(t){!$&&D&&(R?O(t):L=t);}};let L,D,$=!1,R=!1;function O(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,D), t.isContextLost())return;T.supported=!0;}catch(t){}t.deleteTexture(e), $=!0;}"undefined"!=typeof document&&(D=document.createElement("img"), D.onload=function(){L&&O(L), L=null, R=!0;}, D.onerror=function(){$=!0, L=null;}, D.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const U={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(U);class q extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`), this.status=t, this.statusText=e, this.url=r, this.body=n;}}const j=g()?()=>self.worker&&self.worker.referrer:()=>("blob:"===window.location.protocol?window.parent:window).location.href;function N(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:j(),signal:r.signal});let i=!1,a=!1;"json"===t.type&&n.headers.set("Accept","application/json");return ((r,s,o)=>{if(a)return;const l=Date.now();fetch(n).then((r=>r.ok?((r,s,o)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{a||(s&&o&&function(t,e,r){if(E(), !B)return;const n={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>n.headers.set(e,t)));const i=x(e.headers.get("Cache-Control")||"");i["no-store"]||(i["max-age"]&&n.headers.set("Expires",new Date(r+1e3*i["max-age"]).toUTCString()), new Date(n.headers.get("Expires")).getTime()-r<42e4||function(t,e){if(void 0===C)try{new Response(new ReadableStream), C=!0;}catch(t){C=!1;}C?e(t.body):t.blob().then(e);}(e,(e=>{const r=new Response(e,n);E(), B&&B.then((e=>e.put(function(t){const e=t.indexOf("?");return e<0?t:t.slice(0,e)}(t.url),r))).catch((t=>d(t.message)));})));}(n,s,o), i=!0, e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{a||e(new Error(t.message));}));})(r,null,l):r.blob().then((n=>e(new q(r.status,r.statusText,t.url,n)))))).catch((t=>{20!==t.code&&e(new Error(t.message));}));})(), {cancel:()=>{a=!0, i||r.abort();}}}const Z=function(t,e){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){if(g()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e);if(!g()){const r=t.url.substring(0,t.url.indexOf("://"));return (M.REGISTERED_PROTOCOLS[r]||N)(t,e)}}if(!(/^file:/.test(r=t.url)||/^file:/.test(j())&&!/^\w+:/.test(r))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return N(t,e);if(g()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0), "arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text", r.setRequestHeader("Accept","application/json")), r.withCredentials="include"===t.credentials, r.onerror=()=>{e(new Error(r.statusText));}, r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else {const n=new Blob([r.response],{type:r.getResponseHeader("Content-Type")});e(new q(r.status,r.statusText,t.url,n));}}, r.send(t.body), {cancel:()=>r.abort()}}(t,e)},K=function(t,e){return Z(o(t,{type:"arrayBuffer"}),e)};function G(t){const e=window.document.createElement("a");return e.href=t, e.protocol===window.document.location.protocol&&e.host===window.document.location.host}const J="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let X,Y;X=[], Y=0;const H=function(t,e){if(T.supported&&(t.headers||(t.headers={}), t.headers.accept="image/webp,*/*"), Y>=M.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return X.push(r), r}Y++;let r=!1;const n=()=>{if(!r)for(r=!0, Y--;X.length&&Y<M.MAX_PARALLEL_IMAGE_REQUESTS;){const t=X.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=H(e,r).cancel);}},i=K(t,((t,r,i,a)=>{n(), t?e(t):r&&function(t,e){"function"==typeof createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(t,e):function(t,e){const r=new Image;r.onload=()=>{e(null,r), URL.revokeObjectURL(r.src), r.onload=null, window.requestAnimationFrame((()=>{r.src=J;}));}, r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):J;}(t,e);}(r,((t,r)=>{null!=t?e(t):null!=r&&e(null,r,{cacheControl:i,expires:a});}));}));return {cancel:()=>{i.cancel(), n();}}};function W(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[], r[t].push(e));}function Q(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class tt{constructor(t,e={}){o(this,e), this.type=t;}}class et extends tt{constructor(t,e={}){super("error",o({error:t},e));}}class rt{on(t,e){return this._listeners=this._listeners||{}, W(t,e,this._listeners), this}off(t,e){return Q(t,e,this._listeners), Q(t,e,this._oneTimeListeners), this}once(t,e){return this._oneTimeListeners=this._oneTimeListeners||{}, W(t,e,this._oneTimeListeners), this}fire(t,e){"string"==typeof t&&(t=new tt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)Q(r,e,this._oneTimeListeners), e.call(this,t);const i=this._eventedParent;i&&(o(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData), i.fire(t));}else t instanceof et&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t, this._eventedParentData=e, this}}var nt={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"string"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{}},default:"mapbox"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{},within:{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1},elevationOffset:{type:"number",default:450}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};class it{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r, n&&(this.identifier=n), null!=e&&e.__line__&&(this.line=e.__line__);}}function at(t){const e=t.value;return e?[new it(t.key,e,"constants have been deprecated as of v8")]:[]}function st(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function ot(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function lt(t){if(Array.isArray(t))return t.map(lt);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=lt(t[r]);return e}return ot(t)}class ut extends Error{constructor(t,e){super(e), this.message=e, this.key=t;}}class ct{constructor(t,e=[]){this.parent=t, this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new ct(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const ht={kind:"null"},pt={kind:"number"},ft={kind:"string"},dt={kind:"boolean"},yt={kind:"color"},mt={kind:"object"},gt={kind:"value"},xt={kind:"collator"},vt={kind:"formatted"},bt={kind:"padding"},wt={kind:"resolvedImage"};function _t(t,e){return {kind:"array",itemType:t,N:e}}function At(t){if("array"===t.kind){const e=At(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const kt=[ht,pt,ft,dt,yt,vt,mt,_t(gt),bt,wt];function St(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!St(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of kt)if(!St(t,e))return null}return `Expected ${At(t)} but found ${At(e)} instead.`}function It(t,e){return e.some((e=>e.kind===t.kind))}function Mt(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}var zt,Bt={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function Ct(t){return (t=Math.round(t))<0?0:t>255?255:t}function Pt(t){return Ct("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function Vt(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function Et(t,e,r){return r<0?r+=1:r>1&&(r-=1), 6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{zt=({}).parseCSSColor=function(t){var e,r=t.replace(/ /g,"").toLowerCase();if(r in Bt)return Bt[r].slice();if("#"===r[0])return 4===r.length?(e=parseInt(r.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===r.length&&(e=parseInt(r.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var n=r.indexOf("("),i=r.indexOf(")");if(-1!==n&&i+1===r.length){var a=r.substr(0,n),s=r.substr(n+1,i-(n+1)).split(","),o=1;switch(a){case"rgba":if(4!==s.length)return null;o=Vt(s.pop());case"rgb":return 3!==s.length?null:[Pt(s[0]),Pt(s[1]),Pt(s[2]),o];case"hsla":if(4!==s.length)return null;o=Vt(s.pop());case"hsl":if(3!==s.length)return null;var l=(parseFloat(s[0])%360+360)%360/360,u=Vt(s[1]),c=Vt(s[2]),h=c<=.5?c*(u+1):c+u-c*u,p=2*c-h;return [Ct(255*Et(p,h,l+1/3)),Ct(255*Et(p,h,l)),Ct(255*Et(p,h,l-1/3)),o];default:return null}}return null};}catch(t){}class Ft{constructor(t,e,r,n=1){this.r=t, this.g=e, this.b=r, this.a=n;}static parse(t){if(!t)return;if(t instanceof Ft)return t;if("string"!=typeof t)return;const e=zt(t);return e?new Ft(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toString(){const[t,e,r,n]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}}Ft.black=new Ft(0,0,0,1), Ft.white=new Ft(1,1,1,1), Ft.transparent=new Ft(0,0,0,0), Ft.red=new Ft(1,0,0,1);class Tt{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base", this.locale=r, this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Lt{constructor(t,e,r,n,i){this.text=t, this.image=e, this.scale=r, this.fontStack=n, this.textColor=i;}}class Dt{constructor(t){this.sections=t;}static fromString(t){return new Dt([new Lt(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Dt?t:Dt.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class $t{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof $t)return t;if("number"==typeof t)return new $t([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new $t(t)}}toString(){return JSON.stringify(this.values)}}class Rt{constructor(t){this.name=t.name, this.available=t.available;}toString(){return this.name}static fromString(t){return t?new Rt({name:t,available:!1}):null}}function Ot(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Ut(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof Ft)return !0;if(t instanceof Tt)return !0;if(t instanceof Dt)return !0;if(t instanceof $t)return !0;if(t instanceof Rt)return !0;if(Array.isArray(t)){for(const e of t)if(!Ut(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Ut(t[e]))return !1;return !0}return !1}function qt(t){if(null===t)return ht;if("string"==typeof t)return ft;if("boolean"==typeof t)return dt;if("number"==typeof t)return pt;if(t instanceof Ft)return yt;if(t instanceof Tt)return xt;if(t instanceof Dt)return vt;if(t instanceof $t)return bt;if(t instanceof Rt)return wt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=qt(e);if(r){if(r===t)continue;r=gt;break}r=t;}return _t(r||gt,e)}return mt}function jt(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Ft||t instanceof Dt||t instanceof $t||t instanceof Rt?t.toString():JSON.stringify(t)}class Nt{constructor(t,e){this.type=t, this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Ut(t[1]))return e.error("invalid value");const r=t[1];let n=qt(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i), new Nt(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}class Zt{constructor(t){this.name="ExpressionEvaluationError", this.message=t;}toJSON(){return this.message}}const Kt={string:ft,number:pt,boolean:dt,object:mt};class Gt{constructor(t,e){this.type=t, this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,a;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Kt)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=Kt[r], n++;}else i=gt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);a=t[2], n++;}r=_t(i,a);}else {if(!Kt[i])throw new Error(`Types doesn't contain name = ${i}`);r=Kt[i];}const a=[];for(;n<t.length;n++){const r=e.parse(t[n],n,gt);if(!r)return null;a.push(r);}return new Gt(r,a)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!St(this.type,qt(r)))return r;if(e===this.args.length-1)throw new Zt(`Expected value to be of type ${At(this.type)}, but found ${At(qt(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Jt={"to-boolean":dt,"to-color":yt,"to-number":pt,"to-string":ft};class Xt{constructor(t,e){this.type=t, this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Jt[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Jt[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,gt);if(!n)return null;i.push(n);}return new Xt(n,i)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t), r=null, e instanceof Ft)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Ot(e[0],e[1],e[2],e[3]), !r))return new Ft(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Zt(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}if("padding"===this.type.kind){let e;for(const r of this.args){e=r.evaluate(t);const n=$t.parse(e);if(n)return n}throw new Zt(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t), null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Zt(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Dt.fromString(jt(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?Rt.fromString(jt(this.args[0].evaluate(t))):jt(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Yt=["Unknown","Point","LineString","Polygon"];class Ht{constructor(){this.globals=null, this.feature=null, this.featureState=null, this.formattedSection=null, this._parseColorCache={}, this.availableImages=null, this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Yt[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Ft.parse(t)), e}}class Wt{constructor(t,e,r,n){this.name=t, this.type=e, this._evaluate=r, this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}static parse(t,e){const r=t[0],n=Wt.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,a=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,s=a.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,a]of s){o=new we(e.registry,e.path,null,e.scope);const s=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,a=o.parse(r,1+s.length,i);if(!a){l=!0;break}s.push(a);}if(!l)if(Array.isArray(n)&&n.length!==s.length)o.error(`Expected ${n.length} arguments, but found ${s.length} instead.`);else {for(let t=0;t<s.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=s[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Wt(r,i,a,s)}}if(1===s.length)e.errors.push(...o.errors);else {const r=(s.length?s:a).map((([t])=>{return e=t, Array.isArray(e)?`(${e.map(At).join(", ")})`:`(${At(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(At(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Wt.definitions=e;for(const r in e)t[r]=Wt;}}class Qt{constructor(t,e,r){this.type=xt, this.locale=r, this.caseSensitive=t, this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,dt);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,dt);if(!i)return null;let a=null;return r.locale&&(a=e.parse(r.locale,1,ft), !a)?null:new Qt(n,i,a)}evaluate(t){return new Tt(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive), t(this.diacriticSensitive), this.locale&&t(this.locale);}outputDefined(){return !1}}const te=8192;function ee(t,e){t[0]=Math.min(t[0],e[0]), t[1]=Math.min(t[1],e[1]), t[2]=Math.max(t[2],e[0]), t[3]=Math.max(t[3],e[1]);}function re(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function ne(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*te),Math.round(n*i*te)]}function ie(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],a=t[0]-r[0],s=t[1]-r[1];return n*s-a*i==0&&n*a<=0&&i*s<=0}function ae(t,e){let r=!1;for(let s=0,o=e.length;s<o;s++){const o=e[s];for(let e=0,s=o.length;e<s-1;e++){if(ie(t,o[e],o[e+1]))return !1;(i=o[e])[1]>(n=t)[1]!=(a=o[e+1])[1]>n[1]&&n[0]<(a[0]-i[0])*(n[1]-i[1])/(a[1]-i[1])+i[0]&&(r=!r);}}var n,i,a;return r}function se(t,e){for(let r=0;r<e.length;r++)if(ae(t,e[r]))return !0;return !1}function oe(t,e,r,n){const i=n[0]-r[0],a=n[1]-r[1],s=(t[0]-r[0])*a-i*(t[1]-r[1]),o=(e[0]-r[0])*a-i*(e[1]-r[1]);return s>0&&o<0||s<0&&o>0}function le(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(s=u[r+1])[0]-(a=u[r])[0],s[1]-a[1]])[0]*(l=[(i=e)[0]-(n=t)[0],i[1]-n[1]])[1]-o[1]*l[0]&&oe(n,i,a,s)&&oe(a,s,n,i))return !0;var n,i,a,s,o,l;return !1}function ue(t,e){for(let r=0;r<t.length;++r)if(!ae(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(le(t[r],t[r+1],e))return !1;return !0}function ce(t,e){for(let r=0;r<e.length;r++)if(ue(t,e[r]))return !0;return !1}function he(t,e,r){const n=[];for(let i=0;i<t.length;i++){const a=[];for(let n=0;n<t[i].length;n++){const s=ne(t[i][n],r);ee(e,s), a.push(s);}n.push(a);}return n}function pe(t,e,r){const n=[];for(let i=0;i<t.length;i++){const a=he(t[i],e,r);n.push(a);}return n}function fe(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0), t[0]+=i;}ee(e,t);}function de(t,e,r,n){const i=Math.pow(2,n.z)*te,a=[n.x*te,n.y*te],s=[];for(const n of t)for(const t of n){const n=[t.x+a[0],t.y+a[1]];fe(n,e,r,i), s.push(n);}return s}function ye(t,e,r,n){const i=Math.pow(2,n.z)*te,a=[n.x*te,n.y*te],s=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+a[0],n.y+a[1]];ee(e,r), t.push(r);}s.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0, o[2]=o[3]=-1/0;for(const t of s)for(const n of t)fe(n,e,r,i);}var o;return s}class me{constructor(t,e){this.type=dt, this.geojson=t, this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ut(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new me(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new me(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new me(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const a=he(e.coordinates,n,i),s=de(t.geometry(),r,n,i);if(!re(r,n))return !1;for(const t of s)if(!ae(t,a))return !1}if("MultiPolygon"===e.type){const a=pe(e.coordinates,n,i),s=de(t.geometry(),r,n,i);if(!re(r,n))return !1;for(const t of s)if(!se(t,a))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const a=he(e.coordinates,n,i),s=ye(t.geometry(),r,n,i);if(!re(r,n))return !1;for(const t of s)if(!ue(t,a))return !1}if("MultiPolygon"===e.type){const a=pe(e.coordinates,n,i),s=ye(t.geometry(),r,n,i);if(!re(r,n))return !1;for(const t of s)if(!ce(t,a))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}function ge(t){if(t instanceof Wt){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof me)return !1;let e=!0;return t.eachChild((t=>{e&&!ge(t)&&(e=!1);})), e}function xe(t){if(t instanceof Wt&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!xe(t)&&(e=!1);})), e}function ve(t,e){if(t instanceof Wt&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!ve(t,e)&&(r=!1);})), r}class be{constructor(t,e){this.type=e.type, this.name=t, this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new be(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}}class we{constructor(t,e=[],r,n=new ct,i=[]){this.registry=t, this.path=e, this.key=e.map((t=>`[${t}]`)).join(""), this.scope=n, this.errors=i, this.expectedType=r;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Gt(e,[t]):"coerce"===r?new Xt(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]), Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0), null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind)if("padding"!==t.kind||"value"!==i.kind&&"number"!==i.kind&&"array"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof Nt)&&"resolvedImage"!==n.type.kind&&_e(n)){const t=new Ht;try{n=new Nt(n.type,n.evaluate(t));}catch(t){return this.error(t.message), null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new we(this.registry,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new ut(r,t));}checkSubtype(t,e){const r=St(t,e);return r&&this.error(r), r}}function _e(t){if(t instanceof be)return _e(t.boundExpression);if(t instanceof Wt&&"error"===t.name)return !1;if(t instanceof Qt)return !1;if(t instanceof me)return !1;const e=t instanceof Xt||t instanceof Gt;let r=!0;return t.eachChild((t=>{r=e?r&&_e(t):r&&t instanceof Nt;})), !!r&&ge(t)&&ve(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function Ae(t,e){const r=t.length-1;let n,i,a=0,s=r,o=0;for(;a<=s;)if(o=Math.floor((a+s)/2), n=t[o], i=t[o+1], n<=e){if(o===r||e<i)return o;a=o+1;}else {if(!(n>e))throw new Zt("Input is not a number.");s=o-1;}return 0}class ke{constructor(t,e,r){this.type=t, this.input=e, this.labels=[], this.outputs=[];for(const[t,e]of r)this.labels.push(t), this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,pt);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const a=1===r?-1/0:t[r],s=t[r+1],o=r,l=r+1;if("number"!=typeof a)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=a)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(s,l,i);if(!u)return null;i=i||u.type, n.push([a,u]);}return new ke(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Ae(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Se(t,e,r){return t*(1-r)+e*r}var Ie=Object.freeze({__proto__:null,number:Se,color:function(t,e,r){return new Ft(Se(t.r,e.r,r),Se(t.g,e.g,r),Se(t.b,e.b,r),Se(t.a,e.a,r))},array:function(t,e,r){return t.map(((t,n)=>Se(t,e[n],r)))},padding:function(t,e,r){const n=t.values,i=e.values;return new $t([Se(n[0],i[0],r),Se(n[1],i[1],r),Se(n[2],i[2],r),Se(n[3],i[3],r)])}});const Me=.95047,ze=1.08883,Be=4/29,Ce=6/29,Pe=3*Ce*Ce,Ve=Math.PI/180,Ee=180/Math.PI;function Fe(t){return t>.008856451679035631?Math.pow(t,1/3):t/Pe+Be}function Te(t){return t>Ce?t*t*t:Pe*(t-Be)}function Le(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function De(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function $e(t){const e=De(t.r),r=De(t.g),n=De(t.b),i=Fe((.4124564*e+.3575761*r+.1804375*n)/Me),a=Fe((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*a-16,a:500*(i-a),b:200*(a-Fe((.0193339*e+.119192*r+.9503041*n)/ze)),alpha:t.a}}function Re(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Te(e), r=Me*Te(r), n=ze*Te(n), new Ft(Le(3.2404542*r-1.5371385*e-.4985314*n),Le(-.969266*r+1.8760108*e+.041556*n),Le(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function Oe(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const Ue={forward:$e,reverse:Re,interpolate:function(t,e,r){return {l:Se(t.l,e.l,r),a:Se(t.a,e.a,r),b:Se(t.b,e.b,r),alpha:Se(t.alpha,e.alpha,r)}}},qe={forward:function(t){const{l:e,a:r,b:n}=$e(t),i=Math.atan2(n,r)*Ee;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Ve,r=t.c;return Re({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:Oe(t.h,e.h,r),c:Se(t.c,e.c,r),l:Se(t.l,e.l,r),alpha:Se(t.alpha,e.alpha,r)}}};var je=Object.freeze({__proto__:null,lab:Ue,hcl:qe});class Ne{constructor(t,e,r,n,i){this.type=t, this.operator=e, this.interpolation=r, this.input=n, this.labels=[], this.outputs=[];for(const[t,e]of i)this.labels.push(t), this.outputs.push(e);}static interpolationFactor(t,r,n,i){let a=0;if("exponential"===t.name)a=Ze(r,t.base,n,i);else if("linear"===t.name)a=Ze(r,1,n,i);else if("cubic-bezier"===t.name){const s=t.controlPoints;a=new e(s[0],s[1],s[2],s[3]).solve(Ze(r,1,n,i));}return a}static parse(t,e){let[r,n,i,...a]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,pt), !i)return null;const s=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=yt:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<a.length;t+=2){const r=a[t],n=a[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(s.length&&s[s.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type, s.push([r,u]);}return "number"===o.kind||"color"===o.kind||"padding"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new Ne(o,r,n,i,s):e.error(`Type ${At(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const a=Ae(e,n),s=Ne.interpolationFactor(this.interpolation,n,e[a],e[a+1]),o=r[a].evaluate(t),l=r[a+1].evaluate(t);return "interpolate"===this.operator?Ie[this.type.kind.toLowerCase()](o,l,s):"interpolate-hcl"===this.operator?qe.reverse(qe.interpolate(qe.forward(o),qe.forward(l),s)):Ue.reverse(Ue.interpolate(Ue.forward(o),Ue.forward(l),s))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Ze(t,e,r,n){const i=n-r,a=t-r;return 0===i?0:1===e?a/i:(Math.pow(e,a)-1)/(Math.pow(e,i)-1)}class Ke{constructor(t,e){this.type=t, this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type, i.push(t);}if(!r)throw new Error("No output type");const a=n&&i.some((t=>St(n,t.type)));return new Ke(a?gt:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++, r=i.evaluate(t), r&&r instanceof Rt&&!r.available&&(e||(e=r.name), r=null, n===this.args.length&&(r=e)), null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}class Ge{constructor(t,e){this.type=e.type, this.bindings=[].concat(t), this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const a=e.parse(t[n+1],n+1);if(!a)return null;r.push([i,a]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Ge(r,n):null}outputDefined(){return this.result.outputDefined()}}class Je{constructor(t,e,r){this.type=t, this.index=e, this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,pt),n=e.parse(t[2],2,_t(e.expectedType||gt));return r&&n?new Je(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Zt(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Zt(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Zt(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index), t(this.input);}outputDefined(){return !1}}class Xe{constructor(t,e){this.type=dt, this.needle=t, this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,gt),n=e.parse(t[2],2,gt);return r&&n?It(r.type,[dt,ft,pt,ht,gt])?new Xe(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${At(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!Mt(e,["boolean","string","number","null"]))throw new Zt(`Expected first argument to be of type boolean, string, number or null, but found ${At(qt(e))} instead.`);if(!Mt(r,["string","array"]))throw new Zt(`Expected second argument to be of type array or string, but found ${At(qt(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle), t(this.haystack);}outputDefined(){return !0}}class Ye{constructor(t,e,r){this.type=pt, this.needle=t, this.haystack=e, this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,gt),n=e.parse(t[2],2,gt);if(!r||!n)return null;if(!It(r.type,[dt,ft,pt,ht,gt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${At(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,pt);return i?new Ye(r,n,i):null}return new Ye(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!Mt(e,["boolean","string","number","null"]))throw new Zt(`Expected first argument to be of type boolean, string, number or null, but found ${At(qt(e))} instead.`);if(!Mt(r,["string","array"]))throw new Zt(`Expected second argument to be of type array or string, but found ${At(qt(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle), t(this.haystack), this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}}class He{constructor(t,e,r,n,i,a){this.inputType=t, this.type=e, this.input=r, this.cases=n, this.outputs=i, this.otherwise=a;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},a=[];for(let s=2;s<t.length-1;s+=2){let o=t[s];const l=t[s+1];Array.isArray(o)||(o=[o]);const u=e.concat(s);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,qt(t)))return null}else r=qt(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=a.length;}const c=e.parse(l,s,n);if(!c)return null;n=n||c.type, a.push(c);}const s=e.parse(t[1],1,gt);if(!s)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==s.type.kind&&e.concat(1).checkSubtype(r,s.type)?null:new He(r,n,s,i,a,o):null}evaluate(t){const e=this.input.evaluate(t);return (qt(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input), this.outputs.forEach(t), t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class We{constructor(t,e,r){this.type=t, this.branches=e, this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const a=e.parse(t[i],i,dt);if(!a)return null;const s=e.parse(t[i+1],i+1,r);if(!s)return null;n.push([a,s]), r=r||s.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new We(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e), t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class Qe{constructor(t,e,r,n){this.type=t, this.input=e, this.beginIndex=r, this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,gt),n=e.parse(t[2],2,pt);if(!r||!n)return null;if(!It(r.type,[_t(gt),ft,gt]))return e.error(`Expected first argument to be of type array or string, but found ${At(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,pt);return i?new Qe(r.type,r,n,i):null}return new Qe(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!Mt(e,["string","array"]))throw new Zt(`Expected first argument to be of type array or string, but found ${At(qt(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input), t(this.beginIndex), this.endIndex&&t(this.endIndex);}outputDefined(){return !1}}function tr(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function er(t,e,r,n){return 0===n.compare(e,r)}function rr(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=dt, this.lhs=t, this.rhs=e, this.collator=r, this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let a=e.parse(t[1],1,gt);if(!a)return null;if(!tr(r,a.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${At(a.type)}'.`);let s=e.parse(t[2],2,gt);if(!s)return null;if(!tr(r,s.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${At(s.type)}'.`);if(a.type.kind!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error(`Cannot compare types '${At(a.type)}' and '${At(s.type)}'.`);n&&("value"===a.type.kind&&"value"!==s.type.kind?a=new Gt(s.type,[a]):"value"!==a.type.kind&&"value"===s.type.kind&&(s=new Gt(a.type,[s])));let o=null;if(4===t.length){if("string"!==a.type.kind&&"string"!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,xt), !o)return null}return new i(a,s,o)}evaluate(i){const a=this.lhs.evaluate(i),s=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=qt(a),r=qt(s);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Zt(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=qt(a),r=qt(s);if("string"!==t.kind||"string"!==r.kind)return e(i,a,s)}return this.collator?r(i,a,s,this.collator.evaluate(i)):e(i,a,s)}eachChild(t){t(this.lhs), t(this.rhs), this.collator&&t(this.collator);}outputDefined(){return !0}}}const nr=rr("==",(function(t,e,r){return e===r}),er),ir=rr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !er(0,e,r,n)})),ar=rr("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),sr=rr(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),or=rr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),lr=rr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class ur{constructor(t,e,r,n,i){this.type=ft, this.number=t, this.locale=e, this.currency=r, this.minFractionDigits=n, this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,pt);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,ft), !i))return null;let a=null;if(n.currency&&(a=e.parse(n.currency,1,ft), !a))return null;let s=null;if(n["min-fraction-digits"]&&(s=e.parse(n["min-fraction-digits"],1,pt), !s))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,pt), !o)?null:new ur(r,i,a,s,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number), this.locale&&t(this.locale), this.currency&&t(this.currency), this.minFractionDigits&&t(this.minFractionDigits), this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}}class cr{constructor(t){this.type=vt, this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const a=t[r];if(i&&"object"==typeof a&&!Array.isArray(a)){i=!1;let t=null;if(a["font-scale"]&&(t=e.parse(a["font-scale"],1,pt), !t))return null;let r=null;if(a["text-font"]&&(r=e.parse(a["text-font"],1,_t(ft)), !r))return null;let s=null;if(a["text-color"]&&(s=e.parse(a["text-color"],1,yt), !s))return null;const o=n[n.length-1];o.scale=t, o.font=r, o.textColor=s;}else {const a=e.parse(t[r],1,gt);if(!a)return null;const s=a.type.kind;if("string"!==s&&"value"!==s&&"null"!==s&&"resolvedImage"!==s)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0, n.push({content:a,scale:null,font:null,textColor:null});}}return new cr(n)}evaluate(t){return new Dt(this.sections.map((e=>{const r=e.content.evaluate(t);return qt(r)===wt?new Lt("",r,null,null,null):new Lt(jt(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content), e.scale&&t(e.scale), e.font&&t(e.font), e.textColor&&t(e.textColor);}outputDefined(){return !1}}class hr{constructor(t){this.type=wt, this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,ft);return r?new hr(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Rt.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1), r}eachChild(t){t(this.input);}outputDefined(){return !1}}class pr{constructor(t){this.type=pt, this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${At(r.type)} instead.`):new pr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new Zt(`Expected value to be of type string or array, but found ${At(qt(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}}const fr={"==":nr,"!=":ir,">":sr,"<":ar,">=":lr,"<=":or,array:Gt,at:Je,boolean:Gt,case:We,coalesce:Ke,collator:Qt,format:cr,image:hr,in:Xe,"index-of":Ye,interpolate:Ne,"interpolate-hcl":Ne,"interpolate-lab":Ne,length:pr,let:Ge,literal:Nt,match:He,number:Gt,"number-format":ur,object:Gt,slice:Qe,step:ke,string:Gt,"to-boolean":Xt,"to-color":Xt,"to-number":Xt,"to-string":Xt,var:be,within:me};function dr(t,[e,r,n,i]){e=e.evaluate(t), r=r.evaluate(t), n=n.evaluate(t);const a=i?i.evaluate(t):1,s=Ot(e,r,n,a);if(s)throw new Zt(s);return new Ft(e/255*a,r/255*a,n/255*a,a)}function yr(t,e){return t in e}function mr(t,e){const r=e[t];return void 0===r?null:r}function gr(t){return {type:t}}function xr(t){return {result:"success",value:t}}function vr(t){return {result:"error",value:t}}function br(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function wr(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function _r(t){return !!t.expression&&t.expression.interpolated}function Ar(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function kr(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Sr(t){return t}function Ir(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),a=t.type||(_r(e)?"exponential":"interval");if(r||"padding"===e.type){const n=r?Ft.parse:$t.parse;(t=st({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],n(t[1])]))), t.default=n(t.default?t.default:e.default);}if(t.colorSpace&&"rgb"!==t.colorSpace&&!je[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let s,o,l;if("exponential"===a)s=Cr;else if("interval"===a)s=Br;else if("categorical"===a){s=zr, o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==a)throw new Error(`Unknown function type "${a}"`);s=Pr;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],a=i[0].zoom;void 0===r[a]&&(r[a]={zoom:a,type:t.type,property:t.property,default:t.default,stops:[]}, n.push(a)), r[a].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Ir(r[t],e)]);const a={name:"linear"};return {kind:"composite",interpolationType:a,interpolationFactor:Ne.interpolationFactor.bind(void 0,a),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Cr({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===a?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Ne.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>s(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Mr(t.default,e.default):s(t,e,i,o,l)}}}function Mr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function zr(t,e,r,n,i){return Mr(typeof r===i?n[r]:void 0,t.default,e.default)}function Br(t,e,r){if("number"!==Ar(r))return Mr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Ae(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Cr(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Ar(r))return Mr(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const a=Ae(t.stops.map((t=>t[0])),r),s=function(t,e,r,n){const i=n-r,a=t-r;return 0===i?0:1===e?a/i:(Math.pow(e,a)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[a][0],t.stops[a+1][0]),o=t.stops[a][1],l=t.stops[a+1][1];let u=Ie[e.type]||Sr;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=je[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),s));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,s)}}:u(o,l,s)}function Pr(t,e,r){switch(e.type){case"color":r=Ft.parse(r);break;case"formatted":r=Dt.fromString(r.toString());break;case"resolvedImage":r=Rt.fromString(r.toString());break;case"padding":r=$t.parse(r);break;default:Ar(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return Mr(r,t.default,e.default)}Wt.register(fr,{error:[{kind:"error"},[ft],(t,[e])=>{throw new Zt(e.evaluate(t))}],typeof:[ft,[gt],(t,[e])=>At(qt(e.evaluate(t)))],"to-rgba":[_t(pt,4),[yt],(t,[e])=>e.evaluate(t).toArray()],rgb:[yt,[pt,pt,pt],dr],rgba:[yt,[pt,pt,pt,pt],dr],has:{type:dt,overloads:[[[ft],(t,[e])=>yr(e.evaluate(t),t.properties())],[[ft,mt],(t,[e,r])=>yr(e.evaluate(t),r.evaluate(t))]]},get:{type:gt,overloads:[[[ft],(t,[e])=>mr(e.evaluate(t),t.properties())],[[ft,mt],(t,[e,r])=>mr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[gt,[ft],(t,[e])=>mr(e.evaluate(t),t.featureState||{})],properties:[mt,[],t=>t.properties()],"geometry-type":[ft,[],t=>t.geometryType()],id:[gt,[],t=>t.id()],zoom:[pt,[],t=>t.globals.zoom],"heatmap-density":[pt,[],t=>t.globals.heatmapDensity||0],"line-progress":[pt,[],t=>t.globals.lineProgress||0],accumulated:[gt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[pt,gr(pt),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[pt,gr(pt),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:pt,overloads:[[[pt,pt],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[pt],(t,[e])=>-e.evaluate(t)]]},"/":[pt,[pt,pt],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[pt,[pt,pt],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[pt,[],()=>Math.LN2],pi:[pt,[],()=>Math.PI],e:[pt,[],()=>Math.E],"^":[pt,[pt,pt],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[pt,[pt],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[pt,[pt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[pt,[pt],(t,[e])=>Math.log(e.evaluate(t))],log2:[pt,[pt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[pt,[pt],(t,[e])=>Math.sin(e.evaluate(t))],cos:[pt,[pt],(t,[e])=>Math.cos(e.evaluate(t))],tan:[pt,[pt],(t,[e])=>Math.tan(e.evaluate(t))],asin:[pt,[pt],(t,[e])=>Math.asin(e.evaluate(t))],acos:[pt,[pt],(t,[e])=>Math.acos(e.evaluate(t))],atan:[pt,[pt],(t,[e])=>Math.atan(e.evaluate(t))],min:[pt,gr(pt),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[pt,gr(pt),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[pt,[pt],(t,[e])=>Math.abs(e.evaluate(t))],round:[pt,[pt],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[pt,[pt],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[pt,[pt],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[dt,[ft,gt],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[dt,[gt],(t,[e])=>t.id()===e.value],"filter-type-==":[dt,[ft],(t,[e])=>t.geometryType()===e.value],"filter-<":[dt,[ft,gt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[dt,[gt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[dt,[ft,gt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[dt,[gt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[dt,[ft,gt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[dt,[gt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[dt,[ft,gt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[dt,[gt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[dt,[gt],(t,[e])=>e.value in t.properties()],"filter-has-id":[dt,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[dt,[_t(ft)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[dt,[_t(gt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[dt,[ft,_t(gt)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[dt,[ft,_t(gt)],(t,[e,r])=>(function(t, e, r, n) {for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1})(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:dt,overloads:[[[dt,dt],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[gr(dt),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:dt,overloads:[[[dt,dt],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[gr(dt),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[dt,[dt],(t,[e])=>!e.evaluate(t)],"is-supported-script":[dt,[ft],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[ft,[ft],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[ft,[ft],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[ft,gr(gt),(t,e)=>e.map((e=>jt(e.evaluate(t)))).join("")],"resolved-locale":[ft,[xt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class Vr{constructor(t,e){this.expression=t, this._warningHistory={}, this._evaluator=new Ht, this._defaultValue=e?function(t){return "color"===t.type&&kr(t.default)?new Ft(0,0,0,0):"color"===t.type?Ft.parse(t.default)||null:"padding"===t.type?$t.parse(t.default)||null:void 0===t.default?null:t.default}(e):null, this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._evaluator.globals=t, this._evaluator.feature=e, this._evaluator.featureState=r, this._evaluator.canonical=n, this._evaluator.availableImages=i||null, this._evaluator.formattedSection=a, this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,a){this._evaluator.globals=t, this._evaluator.feature=e||null, this._evaluator.featureState=r||null, this._evaluator.canonical=n, this._evaluator.availableImages=i||null, this._evaluator.formattedSection=a||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Zt(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0, "undefined"!=typeof console&&console.warn(t.message)), this._defaultValue}}}function Er(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in fr}function Fr(t,e){const r=new we(fr,[],e?function(t){const e={color:yt,string:ft,number:pt,enum:ft,boolean:dt,formatted:vt,padding:bt,resolvedImage:wt};return "array"===t.type?_t(e[t.value]||gt,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?xr(new Vr(n,e)):vr(r.errors)}class Tr{constructor(t,e){this.kind=t, this._styleExpression=e, this.isStateDependent="constant"!==t&&!xe(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,a)}evaluate(t,e,r,n,i,a){return this._styleExpression.evaluate(t,e,r,n,i,a)}}class Lr{constructor(t,e,r,n){this.kind=t, this.zoomStops=r, this._styleExpression=e, this.isStateDependent="camera"!==t&&!xe(e.expression), this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,a){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,a)}evaluate(t,e,r,n,i,a){return this._styleExpression.evaluate(t,e,r,n,i,a)}interpolationFactor(t,e,r){return this.interpolationType?Ne.interpolationFactor(this.interpolationType,t,e,r):0}}function Dr(t,e){const r=Fr(t,e);if("error"===r.result)return r;const n=r.value.expression,i=ge(n);if(!i&&!br(e))return vr([new ut("","data expressions not supported")]);const a=ve(n,["zoom"]);if(!a&&!wr(e))return vr([new ut("","zoom expressions not supported")]);const s=Rr(n);return s||a?s instanceof ut?vr([s]):s instanceof Ne&&!_r(e)?vr([new ut("",'"interpolate" expressions cannot be used with this property')]):xr(s?new Lr(i?"camera":"composite",r.value,s.labels,s instanceof Ne?s.interpolation:void 0):new Tr(i?"constant":"source",r.value)):vr([new ut("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class $r{constructor(t,e){this._parameters=t, this._specification=e, st(this,Ir(this._parameters,this._specification));}static deserialize(t){return new $r(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Rr(t){let e=null;if(t instanceof Ge)e=Rr(t.result);else if(t instanceof Ke){for(const r of t.args)if(e=Rr(r), e)break}else (t instanceof ke||t instanceof Ne)&&t.input instanceof Wt&&"zoom"===t.input.name&&(e=t);return e instanceof ut||t.eachChild((t=>{const r=Rr(t);r instanceof ut?e=r:!e&&r?e=new ut("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new ut("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})), e}function Or(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},a=t.style,s=t.styleSpec;let o=[];const l=Ar(r);if("object"!==l)return [new it(e,r,`object expected, ${l} found`)];for(const t in r){const l=t.split(".")[0],u=n[l]||n["*"];let c;if(i[l])c=i[l];else if(n[l])c=yn;else if(i["*"])c=i["*"];else {if(!n["*"]){o.push(new it(e,r[t],`unknown property "${t}"`));continue}c=yn;}o=o.concat(c({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:u,style:a,styleSpec:s,object:r,objectKey:t},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&o.push(new it(e,r,`missing required property "${t}"`));return o}function Ur(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,a=t.key,s=t.arrayElementValidator||yn;if("array"!==Ar(e))return [new it(a,e,`array expected, ${Ar(e)} found`)];if(r.length&&e.length!==r.length)return [new it(a,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new it(a,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function), "object"===Ar(r.value)&&(o=r.value);let l=[];for(let t=0;t<e.length;t++)l=l.concat(s({array:e,arrayIndex:t,value:e[t],valueSpec:o,style:n,styleSpec:i,key:`${a}[${t}]`}));return l}function qr(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Ar(r);return "number"===i&&r!=r&&(i="NaN"), "number"!==i?[new it(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new it(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new it(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function jr(t){const e=t.valueSpec,r=ot(t.value.type);let n,i,a,s={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Ar(t.value.stops)&&"array"===Ar(t.value.stops[0])&&"object"===Ar(t.value.stops[0][0]),c=Or({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new it(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Ur({key:t.key,value:n,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})), "array"===Ar(n)&&0===n.length&&e.push(new it(t.key,n,"array must have at least one stop")), e},default:function(t){return yn({key:t.key,value:t.value,valueSpec:e,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new it(t.key,t.value,'missing required property "property"')), "identity"===r||t.value.stops||c.push(new it(t.key,t.value,'missing required property "stops"')), "exponential"===r&&t.valueSpec.expression&&!_r(t.valueSpec)&&c.push(new it(t.key,t.value,"exponential functions not supported")), t.styleSpec.$version>=8&&(l&&!br(t.valueSpec)?c.push(new it(t.key,t.value,"property functions not supported")):o&&!wr(t.valueSpec)&&c.push(new it(t.key,t.value,"zoom functions not supported"))), "categorical"!==r&&!u||void 0!==t.value.property||c.push(new it(t.key,t.value,'"property" property is required')), c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Ar(n))return [new it(o,n,`array expected, ${Ar(n)} found`)];if(2!==n.length)return [new it(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Ar(n[0]))return [new it(o,n,`object expected, ${Ar(n[0])} found`)];if(void 0===n[0].zoom)return [new it(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new it(o,n,"object stop key must have value")];if(a&&a>ot(n[0].zoom))return [new it(o,n[0].zoom,"stop zoom values must appear in ascending order")];ot(n[0].zoom)!==a&&(a=ot(n[0].zoom), i=void 0, s={}), r=r.concat(Or({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:qr,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},n));return Er(lt(n[1]))?r.concat([new it(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(yn({key:`${o}[1]`,value:n[1],valueSpec:e,style:t.style,styleSpec:t.styleSpec}))}function p(t,a){const o=Ar(t.value),l=ot(t.value),u=null!==t.value?t.value:a;if(n){if(o!==n)return [new it(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new it(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return br(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'), [new it(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new it(t.key,u,"stop domain values must appear in ascending order")]:(i=l, "categorical"===r&&l in s?[new it(t.key,u,"stop domain values must be unique")]:(s[l]=!0, [])):[new it(t.key,u,`integer expected, found ${l}`)]}}function Nr(t){const e=("property"===t.expressionContext?Dr:Fr)(lt(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new it(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new it(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!xe(r))return [new it(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!xe(r))return [new it(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!ve(r,["zoom","feature-state"]))return [new it(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!ge(r))return [new it(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function Zr(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(ot(r))&&i.push(new it(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(ot(r))&&i.push(new it(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)), i}function Kr(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!Kr(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const Gr={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function Jr(t){if(null==t)return {filter:()=>!0,needGeometry:!1};Kr(t)||(t=Hr(t));const e=Fr(t,Gr);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:Yr(t)}}function Xr(t,e){return t<e?-1:t>e?1:0}function Yr(t){if(!Array.isArray(t))return !1;if("within"===t[0])return !0;for(let e=1;e<t.length;e++)if(Yr(t[e]))return !0;return !1}function Hr(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Wr(t[1],t[2],"=="):"!="===e?en(Wr(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Wr(t[1],t[2],e):"any"===e?(r=t.slice(1), ["any"].concat(r.map(Hr))):"all"===e?["all"].concat(t.slice(1).map(Hr)):"none"===e?["all"].concat(t.slice(1).map(Hr).map(en)):"in"===e?Qr(t[1],t.slice(2)):"!in"===e?en(Qr(t[1],t.slice(2))):"has"===e?tn(t[1]):"!has"===e?en(tn(t[1])):"within"!==e||t;var r;}function Wr(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function Qr(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Xr)]]:["filter-in-small",t,["literal",e]]}}function tn(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function en(t){return ["!",t]}function rn(t){return Kr(lt(t.value))?Nr(st({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):nn(t)}function nn(t){const e=t.value,r=t.key;if("array"!==Ar(e))return [new it(r,e,`array expected, ${Ar(e)} found`)];const n=t.styleSpec;let i,a=[];if(e.length<1)return [new it(r,e,"filter array must have at least 1 element")];switch(a=a.concat(Zr({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})), ot(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===ot(e[1])&&a.push(new it(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&a.push(new it(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=Ar(e[1]), "string"!==i&&a.push(new it(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let s=2;s<e.length;s++)i=Ar(e[s]), "$type"===ot(e[1])?a=a.concat(Zr({key:`${r}[${s}]`,value:e[s],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&a.push(new it(`${r}[${s}]`,e[s],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)a=a.concat(nn({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=Ar(e[1]), 2!==e.length?a.push(new it(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&a.push(new it(`${r}[1]`,e[1],`string expected, ${i} found`));break;case"within":i=Ar(e[1]), 2!==e.length?a.push(new it(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"object"!==i&&a.push(new it(`${r}[1]`,e[1],`object expected, ${i} found`));}return a}function an(t,e){const r=t.key,n=t.style,i=t.styleSpec,a=t.value,s=t.objectKey,o=i[`${e}_${t.layerType}`];if(!o)return [];const l=s.match(/^(.*)-transition$/);if("paint"===e&&l&&o[l[1]]&&o[l[1]].transition)return yn({key:r,value:a,valueSpec:i.transition,style:n,styleSpec:i});const u=t.valueSpec||o[s];if(!u)return [new it(r,a,`unknown property "${s}"`)];let c;if("string"===Ar(a)&&br(u)&&!u.tokens&&(c=/^{([^}]+)}$/.exec(a)))return [new it(r,a,`"${s}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(c[1])} }\`.`)];const h=[];return "symbol"===t.layerType&&("text-field"===s&&n&&!n.glyphs&&h.push(new it(r,a,'use of "text-field" requires a style "glyphs" property')), "text-font"===s&&kr(lt(a))&&"identity"===ot(a.type)&&h.push(new it(r,a,'"text-font" does not support identity functions'))), h.concat(yn({key:t.key,value:a,valueSpec:u,style:n,styleSpec:i,expressionContext:"property",propertyType:e,propertyKey:s}))}function sn(t){return an(t,"paint")}function on(t){return an(t,"layout")}function ln(t){let e=[];const r=t.value,n=t.key,i=t.style,a=t.styleSpec;r.type||r.ref||e.push(new it(n,r,'either "type" or "ref" is required'));let s=ot(r.type);const o=ot(r.ref);if(r.id){const a=ot(r.id);for(let s=0;s<t.arrayIndex;s++){const t=i.layers[s];ot(t.id)===a&&e.push(new it(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new it(n,r[t],`"${t}" is prohibited for ref layers`));})), i.layers.forEach((e=>{ot(e.id)===o&&(t=e);})), t?t.ref?e.push(new it(n,r.ref,"ref cannot reference another ref layer")):s=ot(t.type):e.push(new it(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==s)if(r.source){const t=i.sources&&i.sources[r.source],a=t&&ot(t.type);t?"vector"===a&&"raster"===s?e.push(new it(n,r.source,`layer "${r.id}" requires a raster source`)):"raster"===a&&"raster"!==s?e.push(new it(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==a||r["source-layer"]?"raster-dem"===a&&"hillshade"!==s?e.push(new it(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==s||!r.paint||!r.paint["line-gradient"]||"geojson"===a&&t.lineMetrics||e.push(new it(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new it(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new it(n,r.source,`source "${r.source}" not found`));}else e.push(new it(n,r,'missing required property "source"'));return e=e.concat(Or({key:n,value:r,valueSpec:a.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>yn({key:`${n}.type`,value:r.type,valueSpec:a.layer.type,style:t.style,styleSpec:t.styleSpec,object:r,objectKey:"type"}),filter:rn,layout:t=>Or({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>on(st({layerType:s},t))}}),paint:t=>Or({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>sn(st({layerType:s},t))}})}})), e}function un(t){const e=t.value,r=t.key,n=Ar(e);return "string"!==n?[new it(r,e,`string expected, ${n} found`)]:[]}const cn={promoteId:function({key:t,value:e}){if("string"===Ar(e))return un({key:t,value:e});{const r=[];for(const n in e)r.push(...un({key:`${t}.${n}`,value:e[n]}));return r}}};function hn(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style;if(!e.type)return [new it(r,e,'"type" is required')];const a=ot(e.type);let s;switch(a){case"vector":case"raster":case"raster-dem":return s=Or({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:cn}), s;case"geojson":if(s=Or({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,objectElementValidators:cn}), e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],a="string"==typeof n?[n,["accumulated"],["get",t]]:n;s.push(...Nr({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})), s.push(...Nr({key:`${r}.${t}.reduce`,value:a,expressionContext:"cluster-reduce"}));}return s;case"video":return Or({key:r,value:e,valueSpec:n.source_video,style:i,styleSpec:n});case"image":return Or({key:r,value:e,valueSpec:n.source_image,style:i,styleSpec:n});case"canvas":return [new it(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Zr({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:i,styleSpec:n})}}function pn(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let a=[];const s=Ar(e);if(void 0===e)return a;if("object"!==s)return a=a.concat([new it("light",e,`object expected, ${s} found`)]), a;for(const t in e){const s=t.match(/^(.*)-transition$/);a=a.concat(s&&n[s[1]]&&n[s[1]].transition?yn({key:t,value:e[t],valueSpec:r.transition,style:i,styleSpec:r}):n[t]?yn({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}):[new it(t,e[t],`unknown property "${t}"`)]);}return a}function fn(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let a=[];const s=Ar(e);if(void 0===e)return a;if("object"!==s)return a=a.concat([new it("terrain",e,`object expected, ${s} found`)]), a;for(const t in e)a=a.concat(n[t]?yn({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}):[new it(t,e[t],`unknown property "${t}"`)]);return a}const dn={"*":()=>[],array:Ur,boolean:function(t){const e=t.value,r=t.key,n=Ar(e);return "boolean"!==n?[new it(r,e,`boolean expected, ${n} found`)]:[]},number:qr,color:function(t){const e=t.key,r=t.value,n=Ar(r);return "string"!==n?[new it(e,r,`color expected, ${n} found`)]:null===zt(r)?[new it(e,r,`color expected, "${r}" found`)]:[]},constants:at,enum:Zr,filter:rn,function:jr,layer:ln,object:Or,source:hn,light:pn,terrain:fn,string:un,formatted:function(t){return 0===un(t).length?[]:Nr(t)},resolvedImage:function(t){return 0===un(t).length?[]:Nr(t)},padding:function(t){const e=t.key,r=t.value;if("array"===Ar(r)){if(r.length<1||r.length>4)return [new it(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const t={type:"number"};let n=[];for(let i=0;i<r.length;i++)n=n.concat(yn({key:`${e}[${i}]`,value:r[i],valueSpec:t}));return n}return qr({key:e,value:r,valueSpec:{}})}};function yn(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return r.expression&&kr(ot(e))?jr(t):r.expression&&Er(lt(e))?Nr(t):r.type&&dn[r.type]?dn[r.type](t):Or(st({},t,{valueSpec:r.type?n[r.type]:r}))}function mn(t){const e=t.value,r=t.key,n=un(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new it(r,e,'"glyphs" url must include a "{fontstack}" token')), -1===e.indexOf("{range}")&&n.push(new it(r,e,'"glyphs" url must include a "{range}" token'))), n}function gn(t,e=nt){let r=[];return r=r.concat(yn({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,objectElementValidators:{glyphs:mn,"*":()=>[]}})), t.constants&&(r=r.concat(at({key:"constants",value:t.constants,style:t,styleSpec:e}))), xn(r)}function xn(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function vn(t){return function(...e){return xn(t.apply(this,e))}}gn.source=vn(hn), gn.light=vn(pn), gn.terrain=vn(fn), gn.layer=vn(ln), gn.filter=vn(rn), gn.paintProperty=vn(sn), gn.layoutProperty=vn(on);const bn=gn,wn=bn.light,_n=bn.paintProperty,An=bn.layoutProperty;function kn(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new et(new Error(n.message))), r=!0;return r}class Sn{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0], this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const a=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],a), this.bboxes=i.subarray(a), this.insert=this._insertReadonly;}else {this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[], this.bboxes=[];}this.n=e, this.extent=t, this.padding=r, this.scale=e/t, this.uid=0;const i=r/e*t;this.min=-i, this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0), this.keys.push(t), this.bboxes.push(e), this.bboxes.push(r), this.bboxes.push(n), this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,a){this.cells[i].push(a);}query(t,e,r,n,i){const a=this.min,s=this.max;if(t<=a&&e<=a&&s<=r&&s<=n&&!i)return Array.prototype.slice.call(this.keys);{const a=[];return this._forEachCell(t,e,r,n,this._queryCell,a,{},i), a}}_queryCell(t,e,r,n,i,a,s,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===s[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(s[h]=!0, a.push(i[h])):s[h]=!1;}}}}_forEachCell(t,e,r,n,i,a,s,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,a,s,o))return}}_convertFromCellCoord(t){return (t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent, n[1]=this.n, n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i, n.set(r,i), i+=r.length;}return n[3+t.length]=i, n.set(this.keys,i), i+=this.keys.length, n[3+t.length+1]=i, n.set(this.bboxes,i), i+=this.bboxes.length, n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r), {buffer:r}}static deserialize(t){return new Sn(t.buffer)}}const In={};function Mn(t,e,r={}){if(In[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}), In[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}Mn("Object",Object), Mn("TransferableGridIndex",Sn), Mn("Color",Ft), Mn("Error",Error), Mn("AJAXError",q), Mn("ResolvedImage",Rt), Mn("StylePropertyFunction",$r), Mn("StyleExpression",Vr,{omit:["_evaluator"]}), Mn("ZoomDependentExpression",Lr), Mn("ZoomConstantExpression",Tr), Mn("CompoundExpression",Wt,{omit:["_evaluate"]});for(const t in fr)fr[t]._classRegistryKey||Mn(`Expression_${t}`,fr[t]);function zn(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Bn(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob)return t;if(zn(t))return e&&e.push(t), t;if(A(t))return e&&e.push(t), t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.push(r.buffer), r}if(t instanceof ImageData)return e&&e.push(t.data.buffer), t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(Bn(n,e));return r}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error("can't serialize object of unregistered class");if(!In[n])throw new Error(`${n} is not registered.`);const i=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const r in t){if(!t.hasOwnProperty(r))continue;if(In[n].omit.indexOf(r)>=0)continue;const a=t[r];i[r]=In[n].shallow.indexOf(r)>=0?a:Bn(a,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n), i}throw new Error("can't serialize object of type "+typeof t)}function Cn(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||zn(t)||A(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(Cn);if("object"==typeof t){const e=t.$name||"Object";if(!In[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=In[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=In[e].shallow.indexOf(r)>=0?i:Cn(i);}return n}throw new Error("can't deserialize object of type "+typeof t)}class Pn{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1, this.lastIntegerZoom=r, this.lastIntegerZoomTime=0, this.lastZoom=t, this.lastFloorZoom=r, !0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1, this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r, this.lastIntegerZoomTime=e), t!==this.lastZoom&&(this.lastZoom=t, this.lastFloorZoom=r, !0))}}const Vn={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function En(t){for(const e of t)if(Ln(e.charCodeAt(0)))return !0;return !1}function Fn(t){for(const e of t)if(!Tn(e.charCodeAt(0)))return !1;return !0}function Tn(t){return !(Vn.Arabic(t)||Vn["Arabic Supplement"](t)||Vn["Arabic Extended-A"](t)||Vn["Arabic Presentation Forms-A"](t)||Vn["Arabic Presentation Forms-B"](t))}function Ln(t){return !(746!==t&&747!==t&&(t<4352||!(Vn["Bopomofo Extended"](t)||Vn.Bopomofo(t)||Vn["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||Vn["CJK Compatibility Ideographs"](t)||Vn["CJK Compatibility"](t)||Vn["CJK Radicals Supplement"](t)||Vn["CJK Strokes"](t)||!(!Vn["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Vn["CJK Unified Ideographs Extension A"](t)||Vn["CJK Unified Ideographs"](t)||Vn["Enclosed CJK Letters and Months"](t)||Vn["Hangul Compatibility Jamo"](t)||Vn["Hangul Jamo Extended-A"](t)||Vn["Hangul Jamo Extended-B"](t)||Vn["Hangul Jamo"](t)||Vn["Hangul Syllables"](t)||Vn.Hiragana(t)||Vn["Ideographic Description Characters"](t)||Vn.Kanbun(t)||Vn["Kangxi Radicals"](t)||Vn["Katakana Phonetic Extensions"](t)||Vn.Katakana(t)&&12540!==t||!(!Vn["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Vn["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Vn["Unified Canadian Aboriginal Syllabics"](t)||Vn["Unified Canadian Aboriginal Syllabics Extended"](t)||Vn["Vertical Forms"](t)||Vn["Yijing Hexagram Symbols"](t)||Vn["Yi Syllables"](t)||Vn["Yi Radicals"](t))))}function Dn(t){return !(Ln(t)||function(t){return !!(Vn["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||Vn["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||Vn["Letterlike Symbols"](t)||Vn["Number Forms"](t)||Vn["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||Vn["Control Pictures"](t)&&9251!==t||Vn["Optical Character Recognition"](t)||Vn["Enclosed Alphanumerics"](t)||Vn["Geometric Shapes"](t)||Vn["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||Vn["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Vn["CJK Symbols and Punctuation"](t)||Vn.Katakana(t)||Vn["Private Use Area"](t)||Vn["CJK Compatibility Forms"](t)||Vn["Small Form Variants"](t)||Vn["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function $n(t){return t>=1424&&t<=2303||Vn["Arabic Presentation Forms-A"](t)||Vn["Arabic Presentation Forms-B"](t)}function Rn(t,e){return !(!e&&$n(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||Vn.Khmer(t))}function On(t){for(const e of t)if($n(e.charCodeAt(0)))return !0;return !1}const Un="deferred",qn="loading",jn="loaded";let Nn=null,Zn="unavailable",Kn=null;const Gn=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Zn="error"), Nn&&Nn(t);};function Jn(){Xn.fire(new tt("pluginStateChange",{pluginStatus:Zn,pluginURL:Kn}));}const Xn=new rt,Yn=function(){return Zn},Hn=function(){if(Zn!==Un||!Kn)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Zn=qn, Jn(), Kn&&K({url:Kn},(t=>{t?Gn(t):(Zn=jn, Jn());}));},Wn={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Zn===jn||null!=Wn.applyArabicShaping,isLoading:()=>Zn===qn,setState(t){if(!g())throw new Error("Cannot set the state of the rtl-text-plugin when not in the web-worker context");Zn=t.pluginStatus, Kn=t.pluginURL;},isParsed(){if(!g())throw new Error("rtl-text-plugin is only parsed on the worker-threads");return null!=Wn.applyArabicShaping&&null!=Wn.processBidirectionalText&&null!=Wn.processStyledBidirectionalText},getPluginURL(){if(!g())throw new Error("rtl-text-plugin url can only be queried from the worker threads");return Kn}};class Qn{constructor(t,e){this.zoom=t, e?(this.now=e.now, this.fadeDuration=e.fadeDuration, this.zoomHistory=e.zoomHistory, this.transition=e.transition):(this.now=0, this.fadeDuration=0, this.zoomHistory=new Pn, this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!Rn(r.charCodeAt(0),e))return !1;return !0}(t,Wn.isLoaded())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class ti{constructor(t,e){this.property=t, this.value=e, this.expression=function(t,e){if(kr(t))return new $r(t,e);if(Er(t)){const r=Dr(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "color"===e.type&&"string"==typeof t?r=Ft.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)||(r=$t.parse(t)), {kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class ei{constructor(t){this.property=t, this.value=new ti(t,void 0);}transitioned(t,e){return new ni(this.property,this.value,e,o({},t.transition,this.transition),t.now)}untransitioned(){return new ni(this.property,this.value,null,{},0)}}class ri{constructor(t){this._properties=t, this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return p(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ei(this._values[t].property)), this._values[t].value=new ti(this._values[t].property,null===e?void 0:p(e));}getTransition(t){return p(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ei(this._values[t].property)), this._values[t].transition=p(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new ii(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new ii(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class ni{constructor(t,e,r,n,i){this.property=t, this.value=e, this.begin=i+n.delay||0, this.end=this.begin+n.duration||0, t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),a=this.prior;if(a){if(n>this.end)return this.prior=null, i;if(this.value.isDataDriven())return this.prior=null, i;if(n<this.begin)return a.possiblyEvaluate(t,e,r);{const s=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(a.possiblyEvaluate(t,e,r),i,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}(s))}}return i}}class ii{constructor(t){this._properties=t, this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new oi(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class ai{constructor(t){this._properties=t, this._values=Object.create(t.defaultPropertyValues);}getValue(t){return p(this._values[t].value)}setValue(t,e){this._values[t]=new ti(this._values[t].property,null===e?void 0:p(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new oi(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class si{constructor(t,e,r){this.property=t, this.value=e, this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class oi{constructor(t){this._properties=t, this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class li{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=Ie[this.specification.type];return n?n(t,e,r):t}}class ui{constructor(t,e){this.specification=t, this.overrides=e;}possiblyEvaluate(t,e,r,n){return new si(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new si(this,{kind:"constant",value:void 0},t.parameters);const n=Ie[this.specification.type];return n?new si(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,a){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,a)}}class ci extends ui{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new si(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),a="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,s=this._calculate(a,a,a,e);return new si(this,{kind:"constant",value:s},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new si(this,{kind:"constant",value:r},e)}return new si(this,t.expression,e)}evaluate(t,e,r,n,i,a){if("source"===t.kind){const s=t.evaluate(e,r,n,i,a);return this._calculate(s,s,s,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class hi{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Qn(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Qn(Math.floor(e.zoom),e)),t.expression.evaluate(new Qn(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class pi{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class fi{constructor(t){this.properties=t, this.defaultPropertyValues={}, this.defaultTransitionablePropertyValues={}, this.defaultTransitioningPropertyValues={}, this.defaultPossiblyEvaluatedValues={}, this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new ti(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new ei(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(), this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}Mn("DataDrivenProperty",ui), Mn("DataConstantProperty",li), Mn("CrossFadedDataDrivenProperty",ci), Mn("CrossFadedProperty",hi), Mn("ColorRampProperty",pi);const di="-transition";class yi extends rt{constructor(t,e){if(super(), this.id=t.id, this.type=t.type, this._featureFilter={filter:()=>!0,needGeometry:!1}, "custom"!==t.type&&(this.metadata=t.metadata, this.minzoom=t.minzoom, this.maxzoom=t.maxzoom, "background"!==t.type&&(this.source=t.source, this.sourceLayer=t["source-layer"], this.filter=t.filter), e.layout&&(this._unevaluatedLayout=new ai(e.layout)), e.paint)){this._transitionablePaint=new ri(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(), this.paint=new oi(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(An,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return t.endsWith(di)?this._transitionablePaint.getTransition(t.slice(0,-di.length)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(_n,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(t.endsWith(di))return this._transitionablePaint.setTransition(t.slice(0,-di.length),e||void 0), !1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),a=r.value;this._transitionablePaint.setValue(t,e), this._handleSpecialPaintPropertyUpdate(t);const s=this._transitionablePaint._values[t].value;return s.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,a,s)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()), this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)), this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{}, t.layout.visibility=this.visibility), h(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&kn(this,t.call(bn,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:nt,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof si&&br(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const mi={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class gi{constructor(t,e){this._structArray=t, this._pos1=e*this.size, this._pos2=this._pos1/2, this._pos4=this._pos1/4, this._pos8=this._pos1/8;}}class xi{constructor(){this.isTransferred=!1, this.capacity=-1, this.resize(0);}static serialize(t,e){return t._trim(), e&&(t.isTransferred=!0, e.push(t.arrayBuffer)), {length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer, e.length=t.length, e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement, e._refreshViews(), e}_trim(){this.length!==this.capacity&&(this.capacity=this.length, this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement), this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t), this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128), this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(), e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function vi(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=mi[t.type].BYTES_PER_ELEMENT,a=r=bi(r,Math.max(e,i)),s=t.components||1;return n=Math.max(n,i), r+=i*s, {name:t.name,type:t.type,components:s,offset:a}})),size:bi(r,Math.max(n,e)),alignment:e}}function bi(t,e){return Math.ceil(t/e)*e}class wi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1), this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e, this.int16[n+1]=r, t}}wi.prototype.bytesPerElement=4, Mn("StructArrayLayout2i4",wi);class _i extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1), this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.int16[a+0]=e, this.int16[a+1]=r, this.int16[a+2]=n, this.int16[a+3]=i, t}}_i.prototype.bytesPerElement=8, Mn("StructArrayLayout4i8",_i);class Ai extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1), this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=6*t;return this.int16[o+0]=e, this.int16[o+1]=r, this.int16[o+2]=n, this.int16[o+3]=i, this.int16[o+4]=a, this.int16[o+5]=s, t}}Ai.prototype.bytesPerElement=12, Mn("StructArrayLayout2i4i12",Ai);class ki extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1), this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=4*t,l=8*t;return this.int16[o+0]=e, this.int16[o+1]=r, this.uint8[l+4]=n, this.uint8[l+5]=i, this.uint8[l+6]=a, this.uint8[l+7]=s, t}}ki.prototype.bytesPerElement=8, Mn("StructArrayLayout2i4ub8",ki);class Si extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1), this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e, this.float32[n+1]=r, t}}Si.prototype.bytesPerElement=8, Mn("StructArrayLayout2f8",Si);class Ii extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u){const c=this.length;return this.resize(c+1), this.emplace(c,t,e,r,n,i,a,s,o,l,u)}emplace(t,e,r,n,i,a,s,o,l,u,c){const h=10*t;return this.uint16[h+0]=e, this.uint16[h+1]=r, this.uint16[h+2]=n, this.uint16[h+3]=i, this.uint16[h+4]=a, this.uint16[h+5]=s, this.uint16[h+6]=o, this.uint16[h+7]=l, this.uint16[h+8]=u, this.uint16[h+9]=c, t}}Ii.prototype.bytesPerElement=20, Mn("StructArrayLayout10ui20",Ii);class Mi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h){const p=this.length;return this.resize(p+1), this.emplace(p,t,e,r,n,i,a,s,o,l,u,c,h)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e, this.int16[f+1]=r, this.int16[f+2]=n, this.int16[f+3]=i, this.uint16[f+4]=a, this.uint16[f+5]=s, this.uint16[f+6]=o, this.uint16[f+7]=l, this.int16[f+8]=u, this.int16[f+9]=c, this.int16[f+10]=h, this.int16[f+11]=p, t}}Mi.prototype.bytesPerElement=24, Mn("StructArrayLayout4i4ui4i24",Mi);class zi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1), this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e, this.float32[i+1]=r, this.float32[i+2]=n, t}}zi.prototype.bytesPerElement=12, Mn("StructArrayLayout3f12",zi);class Bi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1), this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e, t}}Bi.prototype.bytesPerElement=4, Mn("StructArrayLayout1ul4",Bi);class Ci extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer), this.uint32=new Uint32Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l){const u=this.length;return this.resize(u+1), this.emplace(u,t,e,r,n,i,a,s,o,l)}emplace(t,e,r,n,i,a,s,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e, this.int16[c+1]=r, this.int16[c+2]=n, this.int16[c+3]=i, this.int16[c+4]=a, this.int16[c+5]=s, this.uint32[h+3]=o, this.uint16[c+8]=l, this.uint16[c+9]=u, t}}Ci.prototype.bytesPerElement=20, Mn("StructArrayLayout6i1ul2ui20",Ci);class Pi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a){const s=this.length;return this.resize(s+1), this.emplace(s,t,e,r,n,i,a)}emplace(t,e,r,n,i,a,s){const o=6*t;return this.int16[o+0]=e, this.int16[o+1]=r, this.int16[o+2]=n, this.int16[o+3]=i, this.int16[o+4]=a, this.int16[o+5]=s, t}}Pi.prototype.bytesPerElement=12, Mn("StructArrayLayout2i2i2i12",Pi);class Vi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const a=this.length;return this.resize(a+1), this.emplace(a,t,e,r,n,i)}emplace(t,e,r,n,i,a){const s=4*t,o=8*t;return this.float32[s+0]=e, this.float32[s+1]=r, this.float32[s+2]=n, this.int16[o+6]=i, this.int16[o+7]=a, t}}Vi.prototype.bytesPerElement=16, Mn("StructArrayLayout2f1f2i16",Vi);class Ei extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1), this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=12*t,s=3*t;return this.uint8[a+0]=e, this.uint8[a+1]=r, this.float32[s+1]=n, this.float32[s+2]=i, t}}Ei.prototype.bytesPerElement=12, Mn("StructArrayLayout2ub2f12",Ei);class Fi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1), this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e, this.uint16[i+1]=r, this.uint16[i+2]=n, t}}Fi.prototype.bytesPerElement=6, Mn("StructArrayLayout3ui6",Fi);class Ti extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer), this.uint32=new Uint32Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1), this.emplace(g,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e, this.int16[x+1]=r, this.uint16[x+2]=n, this.uint16[x+3]=i, this.uint32[v+2]=a, this.uint32[v+3]=s, this.uint32[v+4]=o, this.uint16[x+10]=l, this.uint16[x+11]=u, this.uint16[x+12]=c, this.float32[v+7]=h, this.float32[v+8]=p, this.uint8[b+36]=f, this.uint8[b+37]=d, this.uint8[b+38]=y, this.uint32[v+10]=m, this.int16[x+22]=g, t}}Ti.prototype.bytesPerElement=48, Mn("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Ti);class Li extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer), this.uint32=new Uint32Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,k,S,I,M){const z=this.length;return this.resize(z+1), this.emplace(z,t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,k,S,I,M)}emplace(t,e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,k,S,I,M,z){const B=34*t,C=17*t;return this.int16[B+0]=e, this.int16[B+1]=r, this.int16[B+2]=n, this.int16[B+3]=i, this.int16[B+4]=a, this.int16[B+5]=s, this.int16[B+6]=o, this.int16[B+7]=l, this.uint16[B+8]=u, this.uint16[B+9]=c, this.uint16[B+10]=h, this.uint16[B+11]=p, this.uint16[B+12]=f, this.uint16[B+13]=d, this.uint16[B+14]=y, this.uint16[B+15]=m, this.uint16[B+16]=g, this.uint16[B+17]=x, this.uint16[B+18]=v, this.uint16[B+19]=b, this.uint16[B+20]=w, this.uint16[B+21]=_, this.uint16[B+22]=A, this.uint32[C+12]=k, this.float32[C+13]=S, this.float32[C+14]=I, this.float32[C+15]=M, this.float32[C+16]=z, t}}Li.prototype.bytesPerElement=68, Mn("StructArrayLayout8i15ui1ul4f68",Li);class Di extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1), this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e, t}}Di.prototype.bytesPerElement=4, Mn("StructArrayLayout1f4",Di);class $i extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1), this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e, this.int16[i+1]=r, this.int16[i+2]=n, t}}$i.prototype.bytesPerElement=6, Mn("StructArrayLayout3i6",$i);class Ri extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.uint32=new Uint32Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1), this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e, this.uint16[i+2]=r, this.uint16[i+3]=n, t}}Ri.prototype.bytesPerElement=8, Mn("StructArrayLayout1ul2ui8",Ri);class Oi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1), this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e, this.uint16[n+1]=r, t}}Oi.prototype.bytesPerElement=4, Mn("StructArrayLayout2ui4",Oi);class Ui extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1), this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e, t}}Ui.prototype.bytesPerElement=2, Mn("StructArrayLayout1ui2",Ui);class qi extends xi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer), this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1), this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const a=4*t;return this.float32[a+0]=e, this.float32[a+1]=r, this.float32[a+2]=n, this.float32[a+3]=i, t}}qi.prototype.bytesPerElement=16, Mn("StructArrayLayout4f16",qi);class ji extends gi{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new S(this.anchorPointX,this.anchorPointY)}}ji.prototype.size=20;class Ni extends Ci{get(t){return new ji(this,t)}}Mn("CollisionBoxArray",Ni);class Zi extends gi{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Zi.prototype.size=48;class Ki extends Ti{get(t){return new Zi(this,t)}}Mn("PlacedSymbolArray",Ki);class Gi extends gi{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get textOffset0(){return this._structArray.float32[this._pos4+14]}get textOffset1(){return this._structArray.float32[this._pos4+15]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+16]}}Gi.prototype.size=68;class Ji extends Li{get(t){return new Gi(this,t)}}Mn("SymbolInstanceArray",Ji);class Xi extends Di{getoffsetX(t){return this.float32[1*t+0]}}Mn("GlyphOffsetArray",Xi);class Yi extends $i{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Mn("SymbolLineVertexArray",Yi);class Hi extends gi{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Hi.prototype.size=8;class Wi extends Ri{get(t){return new Hi(this,t)}}Mn("FeatureIndexArray",Wi);class Qi extends wi{}class ta extends wi{}class ea extends wi{}class ra extends Ai{}class na extends ki{}class ia extends Si{}class aa extends Ii{}class sa extends Mi{}class oa extends zi{}class la extends Bi{}class ua extends Pi{}class ca extends Ei{}class ha extends Fi{}class pa extends Oi{}const fa=vi([{name:"a_pos",components:2,type:"Int16"}],4),{members:da}=fa;class ya{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>ya.MAX_VERTEX_ARRAY_LENGTH&&d(`Max vertices per segment is ${ya.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`), (!i||i.vertexLength+t>ya.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0}, void 0!==n&&(i.sortKey=n), this.segments.push(i)), i}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new ya([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function ma(t,e){return 256*(t=a(Math.floor(t),0,255))+a(Math.floor(e),0,255)}ya.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1, Mn("SegmentVector",ya);const ga=vi([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var xa={exports:{}},va={exports:{}};va.exports=function(t,e){var r,n,i,a,s,o,l,u;for(n=t.length-(r=3&t.length), i=e, s=3432918353, o=461845907, u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24, ++u, i=27492+(65535&(a=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(a>>>16)&65535)<<16);switch(l=0, r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length, i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295, i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295, (i^=i>>>16)>>>0};var ba={exports:{}};ba.exports=function(t,e){for(var r,n=t.length,i=e^n,a=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(a)|(255&t.charCodeAt(++a))<<8|(255&t.charCodeAt(++a))<<16|(255&t.charCodeAt(++a))<<24))+((1540483477*(r>>>16)&65535)<<16), i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)), n-=4, ++a;switch(n){case 3:i^=(255&t.charCodeAt(a+2))<<16;case 2:i^=(255&t.charCodeAt(a+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(a)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16), (i^=i>>>15)>>>0};var wa=va.exports,_a=ba.exports;xa.exports=wa, xa.exports.murmur3=wa, xa.exports.murmur2=_a;class Aa{constructor(){this.ids=[], this.positions=[], this.indexed=!1;}add(t,e,r,n){this.ids.push(ka(t)), this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=ka(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}), r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Sa(r,n,0,r.length-1), e&&e.push(r.buffer,n.buffer), {ids:r,positions:n}}static deserialize(t){const e=new Aa;return e.ids=t.ids, e.positions=t.positions, e.indexed=!0, e}}function ka(t){const e=+t;return !isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:xa.exports(String(t))}function Sa(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let a=r-1,s=n+1;for(;;){do{a++;}while(t[a]<i);do{s--;}while(t[s]>i);if(a>=s)break;Ia(t,a,s), Ia(e,3*a,3*s), Ia(e,3*a+1,3*s+1), Ia(e,3*a+2,3*s+2);}s-r<n-s?(Sa(t,e,r,s), r=s+1):(Sa(t,e,s+1,n), n=s);}}function Ia(t,e,r){const n=t[e];t[e]=t[r], t[r]=n;}Mn("FeaturePositionMap",Aa);class Ma{constructor(t,e){this.gl=t.gl, this.location=e;}}class za extends Ma{constructor(t,e){super(t,e), this.current=0;}set(t){this.current!==t&&(this.current=t, this.gl.uniform1f(this.location,t));}}class Ba extends Ma{constructor(t,e){super(t,e), this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t, this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class Ca extends Ma{constructor(t,e){super(t,e), this.current=Ft.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t, this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const Pa=new Float32Array(16);function Va(t){return [ma(255*t.r,255*t.g),ma(255*t.b,255*t.a)]}class Ea{constructor(t,e,r){this.value=t, this.uniformNames=e.map((t=>`u_${t}`)), this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new Ca(t,e):new za(t,e)}}class Fa{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)), this.patternFrom=null, this.patternTo=null, this.pixelRatioFrom=1, this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio, this.pixelRatioTo=t.pixelRatio, this.patternFrom=e.tlbr, this.patternTo=t.tlbr;}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new Ba(t,e):new za(t,e)}}class Ta{constructor(t,e,r,n){this.expression=t, this.type=r, this.maxValue=0, this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))), this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i){const a=this.paintVertexArray.length,s=this.expression.evaluate(new Qn(0),e,{},n,[],i);this.paintVertexArray.resize(t), this._setPaintValue(a,t,s);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,i);}_setPaintValue(t,e,r){if("color"===this.type){const n=Va(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class La{constructor(t,e,r,n,i,a){this.expression=t, this.uniformNames=e.map((t=>`u_${t}_t`)), this.type=r, this.useIntegerZoom=n, this.zoom=i, this.maxValue=0, this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))), this.paintVertexArray=new a;}populatePaintArray(t,e,r,n,i){const a=this.expression.evaluate(new Qn(this.zoom),e,{},n,[],i),s=this.expression.evaluate(new Qn(this.zoom+1),e,{},n,[],i),o=this.paintVertexArray.length;this.paintVertexArray.resize(t), this._setPaintValue(o,t,a,s);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:this.zoom},r,n),a=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,i,a);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Va(r),a=Va(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],a[0],a[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=a(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new za(t,e)}}class Da{constructor(t,e,r,n,i,a){this.expression=t, this.type=e, this.useIntegerZoom=r, this.zoom=n, this.layerId=a, this.zoomInPaintVertexArray=new i, this.zoomOutPaintVertexArray=new i;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t), this.zoomOutPaintVertexArray.resize(t), this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:a,max:s}=r,o=n[i],l=n[a],u=n[s];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio), this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,ga.members,this.expression.isStateDependent), this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,ga.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(), this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class $a{constructor(t,e,r){this.binders={}, this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const a=t.paint.get(i);if(!(a instanceof si&&br(a.property.specification)))continue;const s=Oa(i,t.type),o=a.value,l=a.property.specification.type,u=a.property.useIntegerZoom,c=a.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new Fa(o.value,s):new Ea(o.value,s,l), n.push(`/u_${i}`);else if("source"===o.kind||h){const r=Ua(i,l,"source");this.binders[i]=h?new Da(o,l,u,e,r,t.id):new Ta(o,s,l,r), n.push(`/a_${i}`);}else {const t=Ua(i,l,"composite");this.binders[i]=new La(o,s,l,u,e,t), n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Ta||e instanceof La?e.maxValue:0}populatePaintArrays(t,e,r,n,i){for(const a in this.binders){const s=this.binders[a];(s instanceof Ta||s instanceof La||s instanceof Da)&&s.populatePaintArray(t,e,r,n,i);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Fa&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let a=!1;for(const s in t){const o=e.getPositions(s);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Ta||l instanceof La||l instanceof Da)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value, l.updatePaintArray(e.start,e.end,o,t[s],i), a=!0;}}}}return a}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Ea||r instanceof Fa)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Ta||r instanceof La)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof Da)for(let e=0;e<ga.members.length;e++)t.push(ga.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Ea||r instanceof Fa||r instanceof La)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Ea||i instanceof Fa||i instanceof La)for(const a of i.uniformNames)if(e[a]){const s=i.getBinding(t,e[a],a);r.push({name:a,property:n,binding:s});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:a}of e)this.binders[i].setUniform(a,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof Da){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof Ta||r instanceof La)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Ta||r instanceof La||r instanceof Da)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Ta||e instanceof La||e instanceof Da)&&e.destroy();}}}class Ra{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new $a(n,e,r);this.needsUpload=!1, this._featureMap=new Aa, this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,a){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,a);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t), this._bufferOffset=t, this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function Oa(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Ua(t,e,r){const n={color:{source:Si,composite:qi},number:{source:Di,composite:Si}},i=function(t){return {"line-pattern":{source:aa,composite:aa},"fill-pattern":{source:aa,composite:aa},"fill-extrusion-pattern":{source:aa,composite:aa}}[t]}(t);return i&&i[r]||n[e][r]}Mn("ConstantBinder",Ea), Mn("CrossFadedConstantBinder",Fa), Mn("SourceExpressionBinder",Ta), Mn("CrossFadedCompositeBinder",Da), Mn("CompositeExpressionBinder",La), Mn("ProgramConfiguration",$a,{omit:["_buffers"]}), Mn("ProgramConfigurationSet",Ra);var qa=8192;const ja=Math.pow(2,14)-1,Na=-ja-1;function Za(t){const e=qa/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=a(i,Na,ja), r.y=a(s,Na,ja), (i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&d("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function Ka(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Za(t):[]}}function Ga(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}class Ja{constructor(t){this.zoom=t.zoom, this.overscaling=t.overscaling, this.layers=t.layers, this.layerIds=this.layers.map((t=>t.id)), this.index=t.index, this.hasPattern=!1, this.layoutVertexArray=new ta, this.indexArray=new ha, this.segments=new ya, this.programConfigurations=new Ra(t.layers,t.zoom), this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let a=null,s=!1;"circle"===n.type&&(a=n.layout.get("circle-sort-key"), s=!a.isConstant());for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ka(e,t);if(!this.layers[0]._featureFilter.filter(new Qn(this.zoom),u,r))continue;const c=s?a.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Za(e),patterns:{},sortKey:c};i.push(h);}s&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:a,sourceLayerIndex:s}=n,o=t[a].feature;this.addFeature(n,i,a,r), e.featureIndex.insert(o,i,a,s,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,da), this.indexBuffer=t.createIndexBuffer(this.indexArray)), this.programConfigurations.upload(t), this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy());}addFeature(t,e,r,n){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=qa||n<0||n>=qa)continue;const i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),a=i.vertexLength;Ga(this.layoutVertexArray,r,n,-1,-1), Ga(this.layoutVertexArray,r,n,1,-1), Ga(this.layoutVertexArray,r,n,1,1), Ga(this.layoutVertexArray,r,n,-1,1), this.indexArray.emplaceBack(a,a+1,a+2), this.indexArray.emplaceBack(a,a+3,a+2), i.vertexLength+=4, i.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n);}}function Xa(t,e){for(let r=0;r<t.length;r++)if(is(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(is(t,e[r]))return !0;return !!Qa(t,e)}function Ya(t,e,r){return !!is(t,e)||!!es(e,t,r)}function Ha(t,e){if(1===t.length)return ns(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(is(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(ns(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Qa(t,e[r]))return !0;return !1}function Wa(t,e,r){if(t.length>1){if(Qa(t,e))return !0;for(let n=0;n<e.length;n++)if(es(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(es(t[n],e,r))return !0;return !1}function Qa(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(ts(n,i,e[t],e[t+1]))return !0}return !1}function ts(t,e,r,n){return y(t,r,n)!==y(e,r,n)&&y(t,e,r)!==y(t,e,n)}function es(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(rs(t,e[r-1],e[r])<n)return !0;return !1}function rs(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function ns(t,e){let r,n,i,a=!1;for(let s=0;s<t.length;s++){r=t[s];for(let t=0,s=r.length-1;t<r.length;s=t++)n=r[t], i=r[s], n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(a=!a);}return a}function is(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const a=t[n],s=t[i];a.y>e.y!=s.y>e.y&&e.x<(s.x-a.x)*(e.y-a.y)/(s.y-a.y)+a.x&&(r=!r);}return r}function as(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const a=y(t,e,r[0]);return a!==y(t,e,r[1])||a!==y(t,e,r[2])||a!==y(t,e,r[3])}function ss(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function os(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function ls(t,e,r,n,i){if(!e[0]&&!e[1])return t;const a=S.convert(e)._mult(i);"viewport"===r&&a._rotate(-n);const s=[];for(let e=0;e<t.length;e++)s.push(t[e].sub(a));return s}Mn("CircleBucket",Ja,{omit:["layers"]});const us=new fi({"circle-sort-key":new ui(nt.layout_circle["circle-sort-key"])});var cs={paint:new fi({"circle-radius":new ui(nt.paint_circle["circle-radius"]),"circle-color":new ui(nt.paint_circle["circle-color"]),"circle-blur":new ui(nt.paint_circle["circle-blur"]),"circle-opacity":new ui(nt.paint_circle["circle-opacity"]),"circle-translate":new li(nt.paint_circle["circle-translate"]),"circle-translate-anchor":new li(nt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new li(nt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new li(nt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new ui(nt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new ui(nt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new ui(nt.paint_circle["circle-stroke-opacity"])}),layout:us},hs=1e-6,ps="undefined"!=typeof Float32Array?Float32Array:Array;function fs(){var t=new ps(9);return ps!=Float32Array&&(t[1]=0, t[2]=0, t[3]=0, t[5]=0, t[6]=0, t[7]=0), t[0]=1, t[4]=1, t[8]=1, t}function ds(t){return t[0]=1, t[1]=0, t[2]=0, t[3]=0, t[4]=0, t[5]=1, t[6]=0, t[7]=0, t[8]=0, t[9]=0, t[10]=1, t[11]=0, t[12]=0, t[13]=0, t[14]=0, t[15]=1, t}function ys(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y, t[1]=v*i+b*l+w*p+_*m, t[2]=v*a+b*u+w*f+_*g, t[3]=v*s+b*c+w*d+_*x, t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y, t[5]=v*i+b*l+w*p+_*m, t[6]=v*a+b*u+w*f+_*g, t[7]=v*s+b*c+w*d+_*x, t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y, t[9]=v*i+b*l+w*p+_*m, t[10]=v*a+b*u+w*f+_*g, t[11]=v*s+b*c+w*d+_*x, t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y, t[13]=v*i+b*l+w*p+_*m, t[14]=v*a+b*u+w*f+_*g, t[15]=v*s+b*c+w*d+_*x, t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var ms,gs=ys;function xs(){var t=new ps(3);return ps!=Float32Array&&(t[0]=0, t[1]=0, t[2]=0), t}function vs(t,e,r){var n=new ps(3);return n[0]=t, n[1]=e, n[2]=r, n}function bs(t,e,r){var n=e[0],i=e[1],a=e[2],s=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*a+r[12]*s, t[1]=r[1]*n+r[5]*i+r[9]*a+r[13]*s, t[2]=r[2]*n+r[6]*i+r[10]*a+r[14]*s, t[3]=r[3]*n+r[7]*i+r[11]*a+r[15]*s, t}function ws(){var t=new ps(4);return ps!=Float32Array&&(t[0]=0, t[1]=0, t[2]=0), t[3]=1, t}function _s(t,e){const r=bs([],[t.x,t.y,0,1],e);return new S(r[0]/r[3],r[1]/r[3])}xs(), ms=new ps(4), ps!=Float32Array&&(ms[0]=0, ms[1]=0, ms[2]=0, ms[3]=0), xs(), vs(1,0,0), vs(0,1,0), ws(), ws(), fs(), function(){var t;t=new ps(2), ps!=Float32Array&&(t[0]=0, t[1]=0);}();class As extends Ja{}Mn("HeatmapBucket",As,{omit:["layers"]});var ks={paint:new fi({"heatmap-radius":new ui(nt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new ui(nt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new li(nt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new pi(nt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new li(nt.paint_heatmap["heatmap-opacity"])})};function Ss(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e, t.height=r, t.data=i, t}function Is(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=Ss({},{width:e,height:r},n);Ms(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n), t.width=e, t.height=r, t.data=i.data;}function Ms(t,e,r,n,i,a){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const s=t.data,o=e.data;if(s===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*a,c=((n.y+l)*e.width+n.x)*a;for(let t=0;t<i.width*a;t++)o[c+t]=s[u+t];}return e}class zs{constructor(t,e){Ss(this,t,1,e);}resize(t){Is(this,t,1);}clone(){return new zs({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Ms(t,e,r,n,i,1);}}class Bs{constructor(t,e){Ss(this,t,4,e);}resize(t){Is(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Bs({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Ms(t,e,r,n,i,4);}}function Cs(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Bs({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const a=(r,n,a)=>{e[t.evaluationKey]=a;const s=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*s.r/s.a), i.data[r+n+1]=Math.floor(255*s.g/s.a), i.data[r+n+2]=Math.floor(255*s.b/s.a), i.data[r+n+3]=Math.floor(255*s.a);};if(t.clips)for(let e=0,i=0;e<n;++e, i+=4*r)for(let n=0,s=0;n<r;n++, s+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];a(i,s,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++, e+=4)a(0,e,t/(r-1));return i}Mn("AlphaImage",zs), Mn("RGBAImage",Bs);var Ps={paint:new fi({"hillshade-illumination-direction":new li(nt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new li(nt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new li(nt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new li(nt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new li(nt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new li(nt.paint_hillshade["hillshade-accent-color"])})};const Vs=vi([{name:"a_pos",components:2,type:"Int16"}],4),{members:Es}=Vs;var Fs={exports:{}};function Ts(t,e,r){r=r||2;var n,i,a,s,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=Ls(t,0,h,r,!0),f=[];if(!p||p.next===p.prev)return f;if(c&&(p=function(t,e,r,n){var i,a,s,o=[];for(i=0, a=e.length;i<a;i++)(s=Ls(t,e[i]*n,i<a-1?e[i+1]*n:t.length,n,!1))===s.next&&(s.steiner=!0), o.push(Gs(s));for(o.sort(js), i=0;i<o.length;i++)r=Ns(o[i],r);return r}(t,e,p,r)), t.length>80*r){n=a=t[0], i=s=t[1];for(var d=r;d<h;d+=r)(o=t[d])<n&&(n=o), (l=t[d+1])<i&&(i=l), o>a&&(a=o), l>s&&(s=l);u=0!==(u=Math.max(a-n,s-i))?32767/u:0;}return $s(p,f,r,n,i,u,0), f}function Ls(t,e,r,n,i){var a,s;if(i===so(t,e,r,n)>0)for(a=e;a<r;a+=n)s=no(a,t[a],t[a+1],s);else for(a=r-n;a>=e;a-=n)s=no(a,t[a],t[a+1],s);return s&&Hs(s,s.next)&&(io(s), s=s.next), s}function Ds(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1, n.steiner||!Hs(n,n.next)&&0!==Ys(n.prev,n,n.next))n=n.next;else {if(io(n), (n=e=n.prev)===n.next)break;r=!0;}}while(r||n!==e);return e}function $s(t,e,r,n,i,a,s){if(t){!s&&a&&function(t,e,r,n){var i=t;do{0===i.z&&(i.z=Ks(i.x,i.y,e,r,n)), i.prevZ=i.prev, i.nextZ=i.next, i=i.next;}while(i!==t);i.prevZ.nextZ=null, i.prevZ=null, function(t){var e,r,n,i,a,s,o,l,u=1;do{for(r=t, t=null, a=null, s=0;r;){for(s++, n=r, o=0, e=0;e<u&&(o++, n=n.nextZ);e++);for(l=u;o>0||l>0&&n;)0!==o&&(0===l||!n||r.z<=n.z)?(i=r, r=r.nextZ, o--):(i=n, n=n.nextZ, l--), a?a.nextZ=i:t=i, i.prevZ=a, a=i;r=n;}a.nextZ=null, u*=2;}while(s>1)}(i);}(t,n,i,a);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev, l=t.next, a?Os(t,n,i,a):Rs(t))e.push(o.i/r|0), e.push(t.i/r|0), e.push(l.i/r|0), io(t), t=l.next, u=l.next;else if((t=l)===u){s?1===s?$s(t=Us(Ds(t),e,r),e,r,n,i,a,2):2===s&&qs(t,e,r,n,i,a):$s(Ds(t),e,r,n,i,a,1);break}}}function Rs(t){var e=t.prev,r=t,n=t.next;if(Ys(e,r,n)>=0)return !1;for(var i=e.x,a=r.x,s=n.x,o=e.y,l=r.y,u=n.y,c=i<a?i<s?i:s:a<s?a:s,h=o<l?o<u?o:u:l<u?l:u,p=i>a?i>s?i:s:a>s?a:s,f=o>l?o>u?o:u:l>u?l:u,d=n.next;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Js(i,o,a,l,s,u,d.x,d.y)&&Ys(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Os(t,e,r,n){var i=t.prev,a=t,s=t.next;if(Ys(i,a,s)>=0)return !1;for(var o=i.x,l=a.x,u=s.x,c=i.y,h=a.y,p=s.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,y=o>l?o>u?o:u:l>u?l:u,m=c>h?c>p?c:p:h>p?h:p,g=Ks(f,d,e,r,n),x=Ks(y,m,e,r,n),v=t.prevZ,b=t.nextZ;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==s&&Js(o,c,l,h,u,p,v.x,v.y)&&Ys(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ, b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==s&&Js(o,c,l,h,u,p,b.x,b.y)&&Ys(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==s&&Js(o,c,l,h,u,p,v.x,v.y)&&Ys(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==s&&Js(o,c,l,h,u,p,b.x,b.y)&&Ys(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Us(t,e,r){var n=t;do{var i=n.prev,a=n.next.next;!Hs(i,a)&&Ws(i,n,n.next,a)&&eo(i,a)&&eo(a,i)&&(e.push(i.i/r|0), e.push(n.i/r|0), e.push(a.i/r|0), io(n), io(n.next), n=t=a), n=n.next;}while(n!==t);return Ds(n)}function qs(t,e,r,n,i,a){var s=t;do{for(var o=s.next.next;o!==s.prev;){if(s.i!==o.i&&Xs(s,o)){var l=ro(s,o);return s=Ds(s,s.next), l=Ds(l,l.next), $s(s,e,r,n,i,a,0), void $s(l,e,r,n,i,a,0)}o=o.next;}s=s.next;}while(s!==t)}function js(t,e){return t.x-e.x}function Ns(t,e){var r=function(t,e){var r,n=e,i=t.x,a=t.y,s=-1/0;do{if(a<=n.y&&a>=n.next.y&&n.next.y!==n.y){var o=n.x+(a-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(o<=i&&o>s&&(s=o, r=n.x<n.next.x?n:n.next, o===i))return r}n=n.next;}while(n!==e);if(!r)return null;var l,u=r,c=r.x,h=r.y,p=1/0;n=r;do{i>=n.x&&n.x>=c&&i!==n.x&&Js(a<h?i:s,a,c,h,a<h?s:i,a,n.x,n.y)&&(l=Math.abs(a-n.y)/(i-n.x), eo(n,t)&&(l<p||l===p&&(n.x>r.x||n.x===r.x&&Zs(r,n)))&&(r=n, p=l)), n=n.next;}while(n!==u);return r}(t,e);if(!r)return e;var n=ro(r,t);return Ds(n,n.next), Ds(r,r.next)}function Zs(t,e){return Ys(t.prev,t,e.prev)<0&&Ys(e.next,t,t.next)<0}function Ks(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Gs(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e), e=e.next;}while(e!==t);return r}function Js(t,e,r,n,i,a,s,o){return (i-s)*(e-o)>=(t-s)*(a-o)&&(t-s)*(n-o)>=(r-s)*(e-o)&&(r-s)*(a-o)>=(i-s)*(n-o)}function Xs(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Ws(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(eo(t,e)&&eo(e,t)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,a=(t.y+e.y)/2;do{r.y>a!=r.next.y>a&&r.next.y!==r.y&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n), r=r.next;}while(r!==t);return n}(t,e)&&(Ys(t.prev,t,e.prev)||Ys(t,e.prev,e))||Hs(t,e)&&Ys(t.prev,t,t.next)>0&&Ys(e.prev,e,e.next)>0)}function Ys(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Hs(t,e){return t.x===e.x&&t.y===e.y}function Ws(t,e,r,n){var i=to(Ys(t,e,r)),a=to(Ys(t,e,n)),s=to(Ys(r,n,t)),o=to(Ys(r,n,e));return i!==a&&s!==o||!(0!==i||!Qs(t,r,e))||!(0!==a||!Qs(t,n,e))||!(0!==s||!Qs(r,t,n))||!(0!==o||!Qs(r,e,n))}function Qs(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function to(t){return t>0?1:t<0?-1:0}function eo(t,e){return Ys(t.prev,t,t.next)<0?Ys(t,e,t.next)>=0&&Ys(t,t.prev,e)>=0:Ys(t,e,t.prev)<0||Ys(t,t.next,e)<0}function ro(t,e){var r=new ao(t.i,t.x,t.y),n=new ao(e.i,e.x,e.y),i=t.next,a=e.prev;return t.next=e, e.prev=t, r.next=i, i.prev=r, n.next=r, r.prev=n, a.next=n, n.prev=a, n}function no(t,e,r,n){var i=new ao(t,e,r);return n?(i.next=n.next, i.prev=n, n.next.prev=i, n.next=i):(i.prev=i, i.next=i), i}function io(t){t.next.prev=t.prev, t.prev.next=t.next, t.prevZ&&(t.prevZ.nextZ=t.nextZ), t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function ao(t,e,r){this.i=t, this.x=e, this.y=r, this.prev=null, this.next=null, this.z=0, this.prevZ=null, this.nextZ=null, this.steiner=!1;}function so(t,e,r,n){for(var i=0,a=e,s=r-n;a<r;a+=n)i+=(t[s]-t[a])*(t[a+1]+t[s+1]), s=a;return i}function oo(t,e,r,n,i){lo(t,e,r||0,n||t.length-1,i||co);}function lo(t,e,r,n,i){for(;n>r;){if(n-r>600){var a=n-r+1,s=e-r+1,o=Math.log(a),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(a-l)/a)*(s-a/2<0?-1:1);lo(t,e,Math.max(r,Math.floor(e-s*l/a+u)),Math.min(n,Math.floor(e+(a-s)*l/a+u)),i);}var c=t[e],h=r,p=n;for(uo(t,r,e), i(t[n],c)>0&&uo(t,r,n);h<p;){for(uo(t,h,p), h++, p--;i(t[h],c)<0;)h++;for(;i(t[p],c)>0;)p--;}0===i(t[r],c)?uo(t,r,p):uo(t,++p,n), p<=e&&(r=p+1), e<=p&&(n=p-1);}}function uo(t,e,r){var n=t[e];t[e]=t[r], t[r]=n;}function co(t,e){return t<e?-1:t>e?1:0}function ho(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,a;for(let e=0;e<r;e++){const r=m(t[e]);0!==r&&(t[e].area=Math.abs(r), void 0===a&&(a=r<0), a===r<0?(i&&n.push(i), i=[t[e]]):i.push(t[e]));}if(i&&n.push(i), e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(oo(n[t],e,1,n[t].length-1,po), n[t]=n[t].slice(0,e));return n}function po(t,e){return e.area-t.area}function fo(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const a=e.constantOr(null);a&&(i=!0, n[a.to]=!0, n[a.from]=!0);}return i}function yo(t,e,r,n,i){const a=i.patternDependencies;for(const s of e){const e=s.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),o=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t, o=o&&o.name?o.name:o, l=l&&l.name?l.name:l, a[t]=!0, a[o]=!0, a[l]=!0, r.patterns[s.id]={min:t,mid:o,max:l};}}return r}Fs.exports=Ts, Fs.exports.default=Ts, Ts.deviation=function(t,e,r,n){var i=e&&e.length,a=Math.abs(so(t,0,i?e[0]*r:t.length,r));if(i)for(var s=0,o=e.length;s<o;s++)a-=Math.abs(so(t,e[s]*r,s<o-1?e[s+1]*r:t.length,r));var l=0;for(s=0;s<n.length;s+=3){var u=n[s]*r,c=n[s+1]*r,h=n[s+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===a&&0===l?0:Math.abs((l-a)/a)}, Ts.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var a=0;a<t[i].length;a++)for(var s=0;s<e;s++)r.vertices.push(t[i][a][s]);i>0&&r.holes.push(n+=t[i-1].length);}return r};class mo{constructor(t){this.zoom=t.zoom, this.overscaling=t.overscaling, this.layers=t.layers, this.layerIds=this.layers.map((t=>t.id)), this.index=t.index, this.hasPattern=!1, this.patternFeatures=[], this.layoutVertexArray=new ea, this.indexArray=new ha, this.indexArray2=new pa, this.programConfigurations=new Ra(t.layers,t.zoom), this.segments=new ya, this.segments2=new ya, this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=fo("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),a=[];for(const{feature:s,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ka(s,t);if(!this.layers[0]._featureFilter.filter(new Qn(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:s.properties,type:s.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Za(s),patterns:{},sortKey:h};a.push(p);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of a){const{geometry:i,index:a,sourceLayerIndex:s}=n;if(this.hasPattern){const t=yo("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,a,r,{});e.featureIndex.insert(t[a].feature,i,a,s,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Es), this.indexBuffer=t.createIndexBuffer(this.indexArray), this.indexBuffer2=t.createIndexBuffer(this.indexArray2)), this.programConfigurations.upload(t), this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.indexBuffer2.destroy(), this.programConfigurations.destroy(), this.segments.destroy(), this.segments2.destroy());}addFeature(t,e,r,n,i){for(const t of ho(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],a=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&a.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y), this.indexArray2.emplaceBack(n+e.length-1,n), i.push(e[0].x), i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y), this.indexArray2.emplaceBack(n+t-1,n+t), i.push(e[t].x), i.push(e[t].y);r.vertexLength+=e.length, r.primitiveLength+=e.length;}const s=Fs.exports(i,a);for(let t=0;t<s.length;t+=3)this.indexArray.emplaceBack(n+s[t],n+s[t+1],n+s[t+2]);r.vertexLength+=e, r.primitiveLength+=s.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}Mn("FillBucket",mo,{omit:["layers","patternFeatures"]});const go=new fi({"fill-sort-key":new ui(nt.layout_fill["fill-sort-key"])});var xo={paint:new fi({"fill-antialias":new li(nt.paint_fill["fill-antialias"]),"fill-opacity":new ui(nt.paint_fill["fill-opacity"]),"fill-color":new ui(nt.paint_fill["fill-color"]),"fill-outline-color":new ui(nt.paint_fill["fill-outline-color"]),"fill-translate":new li(nt.paint_fill["fill-translate"]),"fill-translate-anchor":new li(nt.paint_fill["fill-translate-anchor"]),"fill-pattern":new ci(nt.paint_fill["fill-pattern"])}),layout:go};const vo=vi([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),bo=vi([{name:"a_centroid",components:2,type:"Int16"}],4),{members:wo}=vo;var _o={},Ao=S,ko=So;function So(t,e,r,n,i){this.properties={}, this.extent=r, this.type=0, this._pbf=t, this._geometry=-1, this._keys=n, this._values=i, t.readFields(Io,this,e);}function Io(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function Mo(t){for(var e,r,n=0,i=0,a=t.length,s=a-1;i<a;s=i++)n+=((r=t[s]).x-(e=t[i]).x)*(e.y+r.y);return n}So.types=["Unknown","Point","LineString","Polygon"], So.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,i=0,a=0,s=0,o=[];t.pos<r;){if(i<=0){var l=t.readVarint();n=7&l, i=l>>3;}if(i--, 1===n||2===n)a+=t.readSVarint(), s+=t.readSVarint(), 1===n&&(e&&o.push(e), e=[]), e.push(new Ao(a,s));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&o.push(e), o}, So.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,a=0,s=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c, n=c>>3;}if(n--, 1===r||2===r)(i+=t.readSVarint())<s&&(s=i), i>o&&(o=i), (a+=t.readSVarint())<l&&(l=a), a>u&&(u=a);else if(7!==r)throw new Error("unknown command "+r)}return [s,l,o,u]}, So.prototype.toGeoJSON=function(t,e,r){var n,i,a=this.extent*Math.pow(2,r),s=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=So.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+s)/a-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/a)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],a=0;a<e;a++){var s=Mo(t[a]);0!==s&&(void 0===n&&(n=s<0), n===s<0?(r&&i.push(r), r=[t[a]]):r.push(t[a]));}return r&&i.push(r), i}(l), n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id), p};var zo=ko,Bo=Co;function Co(t,e){this.version=1, this.name=null, this.extent=4096, this.length=0, this._pbf=t, this._keys=[], this._values=[], this._features=[], t.readFields(Po,this,e), this.length=this._features.length;}function Po(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}Co.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new zo(this._pbf,e,this.extent,this._keys,this._values)};var Vo=Bo;function Eo(t,e,r){if(3===t){var n=new Vo(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}_o.VectorTile=function(t,e){this.layers=t.readFields(Eo,{},e);}, _o.VectorTileFeature=ko, _o.VectorTileLayer=Bo;const Fo=_o.VectorTileFeature.types,To=Math.pow(2,13);function Lo(t,e,r,n,i,a,s,o){t.emplaceBack(e,r,2*Math.floor(n*To)+s,i*To*2,a*To*2,Math.round(o));}class Do{constructor(t){this.zoom=t.zoom, this.overscaling=t.overscaling, this.layers=t.layers, this.layerIds=this.layers.map((t=>t.id)), this.index=t.index, this.hasPattern=!1, this.layoutVertexArray=new ra, this.centroidVertexArray=new Qi, this.indexArray=new ha, this.programConfigurations=new Ra(t.layers,t.zoom), this.segments=new ya, this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.features=[], this.hasPattern=fo("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:a,sourceLayerIndex:s}of t){const t=this.layers[0]._featureFilter.needGeometry,o=Ka(n,t);if(!this.layers[0]._featureFilter.filter(new Qn(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:s,index:a,geometry:t?o.geometry:Za(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(yo("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,a,r,{}), e.featureIndex.insert(n,l.geometry,a,s,this.index,!0);}}addFeatures(t,e,r){for(const t of this.features){const{geometry:n}=t;this.addFeature(t,n,t.index,e,r);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,wo), this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,bo.members,!0), this.indexBuffer=t.createIndexBuffer(this.indexArray)), this.programConfigurations.upload(t), this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy(), this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i){const a={x:0,y:0,vertexCount:0};for(const r of ho(e,500)){let e=0;for(const t of r)e+=t.length;let n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);for(const t of r){if(0===t.length)continue;if(Ro(t))continue;let e=0;for(let r=0;r<t.length;r++){const i=t[r];if(r>=1){const s=t[r-1];if(!$o(i,s)){n.vertexLength+4>ya.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=i.sub(s)._perp()._unit(),r=s.dist(i);e+r>32768&&(e=0), Lo(this.layoutVertexArray,i.x,i.y,t.x,t.y,0,0,e), Lo(this.layoutVertexArray,i.x,i.y,t.x,t.y,0,1,e), a.x+=2*i.x, a.y+=2*i.y, a.vertexCount+=2, e+=r, Lo(this.layoutVertexArray,s.x,s.y,t.x,t.y,0,0,e), Lo(this.layoutVertexArray,s.x,s.y,t.x,t.y,0,1,e), a.x+=2*s.x, a.y+=2*s.y, a.vertexCount+=2;const o=n.vertexLength;this.indexArray.emplaceBack(o,o+2,o+1), this.indexArray.emplaceBack(o+1,o+2,o+3), n.vertexLength+=4, n.primitiveLength+=2;}}}}if(n.vertexLength+e>ya.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray)), "Polygon"!==Fo[t.type])continue;const i=[],s=[],o=n.vertexLength;for(const t of r)if(0!==t.length){t!==r[0]&&s.push(i.length/2);for(let e=0;e<t.length;e++){const r=t[e];Lo(this.layoutVertexArray,r.x,r.y,0,0,1,1,0), a.x+=r.x, a.y+=r.y, a.vertexCount+=1, i.push(r.x), i.push(r.y);}}const l=Fs.exports(i,s);for(let t=0;t<l.length;t+=3)this.indexArray.emplaceBack(o+l[t],o+l[t+2],o+l[t+1]);n.primitiveLength+=l.length/3, n.vertexLength+=e;}for(let t=0;t<a.vertexCount;t++)this.centroidVertexArray.emplaceBack(Math.floor(a.x/a.vertexCount),Math.floor(a.y/a.vertexCount));this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}function $o(t,e){return t.x===e.x&&(t.x<0||t.x>qa)||t.y===e.y&&(t.y<0||t.y>qa)}function Ro(t){return t.every((t=>t.x<0))||t.every((t=>t.x>qa))||t.every((t=>t.y<0))||t.every((t=>t.y>qa))}Mn("FillExtrusionBucket",Do,{omit:["layers","features"]});var Oo={paint:new fi({"fill-extrusion-opacity":new li(nt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new ui(nt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new li(nt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new li(nt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ci(nt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new ui(nt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new ui(nt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new li(nt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})};function Uo(t,e){return t.x*e.x+t.y*e.y}function qo(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++], !i)return 1/0;for(;r<e.length;r++){const a=e[r],s=t[0],o=i.sub(n),l=a.sub(n),u=s.sub(n),c=Uo(o,o),h=Uo(o,l),p=Uo(l,l),f=Uo(u,o),d=Uo(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+a.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const jo=vi([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:No}=jo,Zo=vi([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Ko}=Zo,Go=_o.VectorTileFeature.types,Jo=Math.cos(Math.PI/180*37.5),Xo=Math.pow(2,14)/.5;class Yo{constructor(t){this.zoom=t.zoom, this.overscaling=t.overscaling, this.layers=t.layers, this.layerIds=this.layers.map((t=>t.id)), this.index=t.index, this.hasPattern=!1, this.patternFeatures=[], this.lineClipsArray=[], this.gradients={}, this.layers.forEach((t=>{this.gradients[t.id]={};})), this.layoutVertexArray=new na, this.layoutVertexArray2=new ia, this.indexArray=new ha, this.programConfigurations=new Ra(t.layers,t.zoom), this.segments=new ya, this.maxLineLength=0, this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=fo("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),a=[];for(const{feature:e,id:s,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ka(e,t);if(!this.layers[0]._featureFilter.filter(new Qn(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:s,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Za(e),patterns:{},sortKey:c};a.push(h);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of a){const{geometry:i,index:a,sourceLayerIndex:s}=n;if(this.hasPattern){const t=yo("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,a,r,{});e.featureIndex.insert(t[a].feature,i,a,s,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Ko)), this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,No), this.indexBuffer=t.createIndexBuffer(this.indexArray)), this.programConfigurations.upload(t), this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i){const a=this.layers[0].layout,s=a.get("line-join").evaluate(t,{}),o=a.get("line-cap"),l=a.get("line-miter-limit"),u=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,s,o,l,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}addLine(t,e,r,n,i,a){if(this.distance=0, this.scaledDistance=0, this.totalDistance=0, this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(), this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const s="Polygon"===Go[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(s?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,f,d,y;this.e1=this.e2=-1, s&&(h=t[o-2], y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(f=e===o-1?s?t[l+1]:void 0:t[e+1], f&&t[e].equals(f))continue;y&&(d=y), h&&(p=h), h=t[e], y=f?f.sub(h)._unit()._perp():d, d=d||y;let m=d.add(y);0===m.x&&0===m.y||m._unit();const g=d.x*y.x+d.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Jo&&p&&f,_=d.x*y.y-d.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e), this.addCurrentVertex(e,d,0,0,c), p=e;}}const A=p&&f;let k=A?r:s?"butt":n;if(A&&"round"===k&&(v<a?k="miter":v<=2&&(k="fakeround")), "miter"===k&&v>i&&(k="bevel"), "bevel"===k&&(v>2&&(k="flipbevel"), v<i&&(k="miter")), p&&this.updateDistance(p,h), "miter"===k)m._mult(v), this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===k){if(v>100)m=y.mult(-1);else {const t=v*d.add(y).mag()/d.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c), this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===k||"fakeround"===k){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,d,e,r,c), "fakeround"===k){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=y.sub(d)._mult(r)._add(d)._unit()._mult(_?-1:1);this.addHalfVertex(h,n.x,n.y,!1,_,0,c);}}f&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===k)this.addCurrentVertex(h,m,0,0,c);else if("square"===k){const t=p?1:-1;this.addCurrentVertex(h,m,t,t,c);}else "round"===k&&(p&&(this.addCurrentVertex(h,d,0,0,c), this.addCurrentVertex(h,d,1,1,c,!0)), f&&(this.addCurrentVertex(h,y,-1,-1,c,!0), this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(f);if(t>2*u){const e=h.add(f.sub(h)._mult(u/t)._round());this.updateDistance(h,e), this.addCurrentVertex(e,y,0,0,c), h=e;}}}}addCurrentVertex(t,e,r,n,i,a=!1){const s=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,a,!1,r,i), this.addHalfVertex(t,s,o,a,!0,-n,i), this.distance>Xo/2&&0===this.totalDistance&&(this.distance=0, this.addCurrentVertex(t,e,r,n,i,a));}addHalfVertex({x:t,y:e},r,n,i,a,s,o){const l=.5*(this.lineClips?this.scaledDistance*(Xo-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(a?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===s?0:s<0?-1:1)|(63&l)<<2,l>>6), this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u), o.primitiveLength++), a?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e), this.updateScaledDistance();}}Mn("LineBucket",Yo,{omit:["layers","patternFeatures"]});const Ho=new fi({"line-cap":new li(nt.layout_line["line-cap"]),"line-join":new ui(nt.layout_line["line-join"]),"line-miter-limit":new li(nt.layout_line["line-miter-limit"]),"line-round-limit":new li(nt.layout_line["line-round-limit"]),"line-sort-key":new ui(nt.layout_line["line-sort-key"])});var Wo={paint:new fi({"line-opacity":new ui(nt.paint_line["line-opacity"]),"line-color":new ui(nt.paint_line["line-color"]),"line-translate":new li(nt.paint_line["line-translate"]),"line-translate-anchor":new li(nt.paint_line["line-translate-anchor"]),"line-width":new ui(nt.paint_line["line-width"]),"line-gap-width":new ui(nt.paint_line["line-gap-width"]),"line-offset":new ui(nt.paint_line["line-offset"]),"line-blur":new ui(nt.paint_line["line-blur"]),"line-dasharray":new hi(nt.paint_line["line-dasharray"]),"line-pattern":new ci(nt.paint_line["line-pattern"]),"line-gradient":new pi(nt.paint_line["line-gradient"])}),layout:Ho};const Qo=new (class extends ui {possiblyEvaluate(t,e){return e=new Qn(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}), super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=o({},e,{zoom:Math.floor(e.zoom)}), super.evaluate(t,e,r,n)}})(Wo.paint.properties["line-width"].specification);function tl(t,e){return e>0?e+2*t:t}Qo.useIntegerZoom=!0;const el=vi([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),rl=vi([{name:"a_projected_pos",components:3,type:"Float32"}],4);vi([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const nl=vi([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]);vi([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const il=vi([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),al=vi([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function sl(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()), Wn.applyArabicShaping&&(t=Wn.applyArabicShaping(t)), t}(t.text,e,r);})), t}vi([{name:"triangle",components:3,type:"Uint16"}]), vi([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]), vi([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]), vi([{type:"Float32",name:"offsetX"}]), vi([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]);const ol={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var ll=24,ul=pl,cl=function(t,e,r,n,i){var a,s,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p, a=f&(1<<-c)-1, f>>=-c, c+=o;c>0;a=256*a+t[e+h], h+=p, c-=8);for(s=a&(1<<-c)-1, a>>=-c, c+=n;c>0;s=256*s+t[e+h], h+=p, c-=8);if(0===a)a=1-u;else {if(a===l)return s?NaN:1/0*(f?-1:1);s+=Math.pow(2,n), a-=u;}return (f?-1:1)*s*Math.pow(2,a-n)},hl=function(t,e,r,n,i,a){var s,o,l,u=8*a-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:a-1,d=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e), isNaN(e)||e===1/0?(o=isNaN(e)?1:0, s=c):(s=Math.floor(Math.log(e)/Math.LN2), e*(l=Math.pow(2,-s))<1&&(s--, l*=2), (e+=s+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(s++, l/=2), s+h>=c?(o=0, s=c):s+h>=1?(o=(e*l-1)*Math.pow(2,i), s+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i), s=0));i>=8;t[r+f]=255&o, f+=d, o/=256, i-=8);for(s=s<<i|o, u+=i;u>0;t[r+f]=255&s, f+=d, s/=256, u-=8);t[r+f-d]|=128*y;};function pl(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0), this.pos=0, this.type=0, this.length=this.buf.length;}pl.Varint=0, pl.Fixed64=1, pl.Bytes=2, pl.Fixed32=5;var fl,dl=4294967296,yl=1/dl,ml="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function gl(t){return t.type===pl.Bytes?t.readVarint()+t.pos:t.pos+1}function xl(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function vl(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function bl(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function wl(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function _l(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function Al(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function kl(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Sl(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Il(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Ml(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function zl(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Bl(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Cl(t,e,r){t[r]=e, t[r+1]=e>>>8, t[r+2]=e>>>16, t[r+3]=e>>>24;}function Pl(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function Vl(t,e,r){1===t&&r.readMessage(El,e);}function El(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:a,left:s,top:o,advance:l}=r.readMessage(Fl,{});e.push({id:t,bitmap:new zs({width:i+6,height:a+6},n),metrics:{width:i,height:a,left:s,top:o,advance:l}});}}function Fl(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function Tl(t){let e=0,r=0;for(const n of t)e+=n.w*n.h, r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,a=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x, e.y=r.y, a=Math.max(a,e.y+e.h), i=Math.max(i,e.x+e.w), e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w, r.w-=e.w):e.w===r.w?(r.y+=e.h, r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}), r.y+=e.h, r.h-=e.h);break}}return {w:i,h:a,fill:e/(i*a)||0}}pl.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,a=this.pos;this.type=7&n, t(i,e,this), this.pos===a&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Bl(this.buf,this.pos);return this.pos+=4, t},readSFixed32:function(){var t=Pl(this.buf,this.pos);return this.pos+=4, t},readFixed64:function(){var t=Bl(this.buf,this.pos)+Bl(this.buf,this.pos+4)*dl;return this.pos+=8, t},readSFixed64:function(){var t=Bl(this.buf,this.pos)+Pl(this.buf,this.pos+4)*dl;return this.pos+=8, t},readFloat:function(){var t=cl(this.buf,this.pos,!0,23,4);return this.pos+=4, t},readDouble:function(){var t=cl(this.buf,this.pos,!0,52,8);return this.pos+=8, t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]), r<128?e:(e|=(127&(r=n[this.pos++]))<<7, r<128?e:(e|=(127&(r=n[this.pos++]))<<14, r<128?e:(e|=(127&(r=n[this.pos++]))<<21, r<128?e:function(t,e,r){var n,i,a=r.buf;if(n=(112&(i=a[r.pos++]))>>4, i<128)return xl(t,n,e);if(n|=(127&(i=a[r.pos++]))<<3, i<128)return xl(t,n,e);if(n|=(127&(i=a[r.pos++]))<<10, i<128)return xl(t,n,e);if(n|=(127&(i=a[r.pos++]))<<17, i<128)return xl(t,n,e);if(n|=(127&(i=a[r.pos++]))<<24, i<128)return xl(t,n,e);if(n|=(1&(i=a[r.pos++]))<<31, i<128)return xl(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t, t-e>=12&&ml?function(t,e,r){return ml.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var a,s,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(a=t[i+1]))&&(u=(31&l)<<6|63&a)<=127&&(u=null):3===c?(s=t[i+2], 128==(192&(a=t[i+1]))&&128==(192&s)&&((u=(15&l)<<12|(63&a)<<6|63&s)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(s=t[i+2], o=t[i+3], 128==(192&(a=t[i+1]))&&128==(192&s)&&128==(192&o)&&((u=(15&l)<<18|(63&a)<<12|(63&s)<<6|63&o)<=65535||u>=1114112)&&(u=null)), null===u?(u=65533, c=1):u>65535&&(u-=65536, n+=String.fromCharCode(u>>>10&1023|55296), u=56320|1023&u), n+=String.fromCharCode(u), i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t, e},readPackedVarint:function(t,e){if(this.type!==pl.Bytes)return t.push(this.readVarint(e));var r=gl(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==pl.Bytes)return t.push(this.readSVarint());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==pl.Bytes)return t.push(this.readBoolean());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==pl.Bytes)return t.push(this.readFloat());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==pl.Bytes)return t.push(this.readDouble());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==pl.Bytes)return t.push(this.readFixed32());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==pl.Bytes)return t.push(this.readSFixed32());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==pl.Bytes)return t.push(this.readFixed64());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==pl.Bytes)return t.push(this.readSFixed64());var e=gl(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===pl.Varint)for(;this.buf[this.pos++]>127;);else if(e===pl.Bytes)this.pos=this.readVarint()+this.pos;else if(e===pl.Fixed32)this.pos+=4;else {if(e!==pl.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf), this.buf=r, this.length=e;}},finish:function(){return this.length=this.pos, this.pos=0, this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4), Cl(this.buf,t,this.pos), this.pos+=4;},writeSFixed32:function(t){this.realloc(4), Cl(this.buf,t,this.pos), this.pos+=4;},writeFixed64:function(t){this.realloc(8), Cl(this.buf,-1&t,this.pos), Cl(this.buf,Math.floor(t*yl),this.pos+4), this.pos+=8;},writeSFixed64:function(t){this.realloc(8), Cl(this.buf,-1&t,this.pos), Cl(this.buf,Math.floor(t*yl),this.pos+4), this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0, n=t/4294967296|0):(n=~(-t/4294967296), 4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0, n=n+1|0)), t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10), function(t,e,r){r.buf[r.pos++]=127&t|128, t>>>=7, r.buf[r.pos++]=127&t|128, t>>>=7, r.buf[r.pos++]=127&t|128, t>>>=7, r.buf[r.pos++]=127&t|128, r.buf[r.pos]=127&(t>>>=7);}(r,0,e), function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0), t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0), t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0), t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0), t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0), t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4), this.buf[this.pos++]=127&t|(t>127?128:0), t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0), t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0), t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t), this.realloc(4*t.length), this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,a=0;a<e.length;a++){if((n=e.charCodeAt(a))>55295&&n<57344){if(!i){n>56319||a+1===e.length?(t[r++]=239, t[r++]=191, t[r++]=189):i=n;continue}if(n<56320){t[r++]=239, t[r++]=191, t[r++]=189, i=n;continue}n=i-55296<<10|n-56320|65536, i=null;}else i&&(t[r++]=239, t[r++]=191, t[r++]=189, i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240, t[r++]=n>>12&63|128), t[r++]=n>>6&63|128), t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&vl(e,r,this), this.pos=e-1, this.writeVarint(r), this.pos+=r;},writeFloat:function(t){this.realloc(4), hl(this.buf,t,this.pos,!0,23,4), this.pos+=4;},writeDouble:function(t){this.realloc(8), hl(this.buf,t,this.pos,!0,52,8), this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e), this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&vl(r,n,this), this.pos=r-1, this.writeVarint(n), this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,pl.Bytes), this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,bl,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,wl,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,kl,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,_l,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Al,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Sl,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Il,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Ml,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,zl,e);},writeBytesField:function(t,e){this.writeTag(t,pl.Bytes), this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,pl.Fixed32), this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,pl.Fixed32), this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,pl.Fixed64), this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,pl.Fixed64), this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,pl.Varint), this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,pl.Varint), this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,pl.Bytes), this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,pl.Fixed32), this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,pl.Fixed64), this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};class Ll{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:a}){this.paddedRect=t, this.pixelRatio=e, this.stretchX=n, this.stretchY=i, this.content=a, this.version=r;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Dl{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i), this.addImages(e,n,i);const{w:a,h:s}=Tl(i),o=new Bs({width:a||1,height:s||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Bs.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,a=i.x+1,s=i.y+1,l=r.data.width,u=r.data.height;Bs.copy(r.data,o,{x:0,y:0},{x:a,y:s},r.data), Bs.copy(r.data,o,{x:0,y:u-1},{x:a,y:s-1},{width:l,height:1}), Bs.copy(r.data,o,{x:0,y:0},{x:a,y:s+u},{width:l,height:1}), Bs.copy(r.data,o,{x:l-1,y:0},{x:a-1,y:s},{width:1,height:u}), Bs.copy(r.data,o,{x:0,y:0},{x:a+l,y:s},{width:1,height:u});}this.image=o, this.iconPositions=r, this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],a={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(a), e[n]=new Ll(a,i), i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e), this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}Mn("ImagePosition",Ll), Mn("ImageAtlas",Dl), t.WritingMode=void 0, (fl=t.WritingMode||(t.WritingMode={}))[fl.none=0]="none", fl[fl.horizontal=1]="horizontal", fl[fl.vertical=2]="vertical", fl[fl.horizontalOnly=3]="horizontalOnly";const $l=-17;class Rl{constructor(){this.scale=1, this.fontStack="", this.imageName=null;}static forText(t,e){const r=new Rl;return r.scale=t||1, r.fontStack=e, r}static forImage(t){const e=new Rl;return e.imageName=t, e}}class Ol{constructor(){this.text="", this.sectionIndex=[], this.sections=[], this.imageSectionID=null;}static fromFeature(t,e){const r=new Ol;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&Dn(n)&&!ol[t[r+1]]||i&&Dn(i)&&!ol[t[r-1]]||!ol[t[r]]?t[r]:ol[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&ql[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&ql[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e), this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Ol;return r.text=this.text.substring(t,e), r.sectionIndex=this.sectionIndex.slice(t,e), r.sections=this.sections, r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text, this.sections.push(Rl.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void d("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r), this.sections.push(Rl.forImage(e)), this.sectionIndex.push(this.sections.length-1)):d("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344, this.imageSectionID)}}function Ul(e,r,n,i,a,s,o,l,u,c,h,p,f,d,y,m){const g=Ol.fromFeature(e,a);let x;p===t.WritingMode.vertical&&g.verticalizePunctuation();const{processBidirectionalText:v,processStyledBidirectionalText:b}=Wn;if(v&&1===g.sections.length){x=[];const t=v(g.toString(),Xl(g,c,s,r,i,d,y));for(const e of t){const t=new Ol;t.text=e, t.sections=g.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);x.push(t);}}else if(b){x=[];const t=b(g.text,g.sectionIndex,Xl(g,c,s,r,i,d,y));for(const e of t){const t=new Ol;t.text=e[0], t.sectionIndex=e[1], t.sections=g.sections, x.push(t);}}else x=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)), i=n;return i<n.length&&r.push(t.substring(i,n.length)), r}(g,Xl(g,c,s,r,i,d,y));const w=[],_={positionedLines:w,text:g.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(e,r,n,i,a,s,o,l,u,c,h,p){let f=0,d=$l,y=0,m=0;const g="right"===l?1:"left"===l?0:.5;let x=0;for(const o of a){o.trim();const a=o.getMaxScale(),l=(a-1)*ll,b={positionedGlyphs:[],lineOffset:0};e.positionedLines[x]=b;const w=b.positionedGlyphs;let _=0;if(!o.length()){d+=s, ++x;continue}for(let s=0;s<o.length();s++){const y=o.getSection(s),m=o.getSectionIndex(s),g=o.getCharCode(s);let x=0,b=null,A=null,k=null,S=ll;const I=!(u===t.WritingMode.horizontal||!h&&!Ln(g)||h&&(ql[g]||(v=g, Vn.Arabic(v)||Vn["Arabic Supplement"](v)||Vn["Arabic Extended-A"](v)||Vn["Arabic Presentation Forms-A"](v)||Vn["Arabic Presentation Forms-B"](v))));if(y.imageName){const t=i[y.imageName];if(!t)continue;k=y.imageName, e.iconsInText=e.iconsInText||!0, A=t.paddedRect;const r=t.displaySize;y.scale=y.scale*ll/p, b={width:r[0],height:r[1],left:1,top:-3,advance:I?r[1]:r[0]}, x=l+(ll-r[1]*y.scale), S=b.advance;const n=I?r[0]*y.scale-ll*a:r[1]*y.scale-ll*a;n>0&&n>_&&(_=n);}else {const t=n[y.fontStack],e=t&&t[g];if(e&&e.rect)A=e.rect, b=e.metrics;else {const t=r[y.fontStack],e=t&&t[g];if(!e)continue;b=e.metrics;}x=(a-y.scale)*ll;}I?(e.verticalizable=!0, w.push({glyph:g,imageName:k,x:f,y:d+x,vertical:I,scale:y.scale,fontStack:y.fontStack,sectionIndex:m,metrics:b,rect:A}), f+=S*y.scale+c):(w.push({glyph:g,imageName:k,x:f,y:d+x,vertical:I,scale:y.scale,fontStack:y.fontStack,sectionIndex:m,metrics:b,rect:A}), f+=b.advance*y.scale+c);}0!==w.length&&(y=Math.max(f-c,y), Hl(w,0,w.length-1,g,_)), f=0;const A=s*a+_;b.lineOffset=Math.max(_,l), d+=A, m=Math.max(A,m), ++x;}var v;const b=d-$l,{horizontalAlign:w,verticalAlign:_}=Yl(o);((function(t,e,r,n,i,a,s,o,l){const u=(e-r)*i;let c=0;c=a!==s?-o*n-$l:(-n*l+.5)*s;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u, t.y+=c;}))(e.positionedLines,g,w,_,y,m,s,b,a.length), e.top+=-_*b, e.bottom=e.top+b, e.left+=-w*y, e.right=e.left+y;}(_,r,n,i,x,o,l,u,p,c,f,m), !function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(w)&&_}const ql={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},jl={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Nl(t,e,r,n,i,a){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*ll/a+i:0}{const n=r[e.fontStack],a=n&&n[t];return a?a.metrics.advance*e.scale+i:0}}function Zl(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Kl(t,e,r){let n=0;return 10===t&&(n-=1e4), r&&(n+=150), 40!==t&&65288!==t||(n+=50), 41!==e&&65289!==e||(n+=50), n}function Gl(t,e,r,n,i,a){let s=null,o=Zl(e,r,i,a);for(const t of n){const n=Zl(e-t.x,r,i,a)+t.badness;n<=o&&(s=t, o=n);}return {index:t,x:e,priorBreak:s,badness:o}}function Jl(t){return t?Jl(t.priorBreak).concat(t.index):[]}function Xl(t,e,r,n,i,a,s){if("point"!==a)return [];if(!t)return [];const o=[],l=function(t,e,r,n,i,a){let s=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);s+=Nl(t.getCharCode(r),o,n,i,e,a);}return s/Math.max(1,Math.ceil(s/r))}(t,e,r,n,i,s),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const a=t.getSection(r),p=t.getCharCode(r);if(ql[p]||(c+=Nl(p,a,n,i,e,s)), r<t.length()-1){const e=!((h=p)<11904||!(Vn["Bopomofo Extended"](h)||Vn.Bopomofo(h)||Vn["CJK Compatibility Forms"](h)||Vn["CJK Compatibility Ideographs"](h)||Vn["CJK Compatibility"](h)||Vn["CJK Radicals Supplement"](h)||Vn["CJK Strokes"](h)||Vn["CJK Symbols and Punctuation"](h)||Vn["CJK Unified Ideographs Extension A"](h)||Vn["CJK Unified Ideographs"](h)||Vn["Enclosed CJK Letters and Months"](h)||Vn["Halfwidth and Fullwidth Forms"](h)||Vn.Hiragana(h)||Vn["Ideographic Description Characters"](h)||Vn["Kangxi Radicals"](h)||Vn["Katakana Phonetic Extensions"](h)||Vn.Katakana(h)||Vn["Vertical Forms"](h)||Vn["Yi Radicals"](h)||Vn["Yi Syllables"](h)));(jl[p]||e||a.imageName)&&o.push(Gl(r+1,c,l,o,Kl(p,t.getCharCode(r+1),e&&u),!1));}}var h;return Jl(Gl(t.length(),c,l,o,0,!0))}function Yl(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Hl(t,e,r,n,i){if(!n&&!i)return;const a=t[r],s=(t[r].x+a.metrics.advance*a.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s, t[n].y+=i;}function Wl(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Yl(r),a=e[0]-t.displaySize[0]*n,s=e[1]-t.displaySize[1]*i;return {image:t,top:s,bottom:s+t.displaySize[1],left:a,right:a+t.displaySize[0]}}function Ql(t,e,r,n,i,a){const s=t.image;let o;if(s.content){const t=s.content,e=s.pixelRatio||1;o=[t[0]/e,t[1]/e,s.displaySize[0]-t[2]/e,s.displaySize[1]-t[3]/e];}const l=e.left*a,u=e.right*a;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3], h=i[0]+u+n[1]):(f=i[0]+(l+u-s.displaySize[0])/2, h=f+s.displaySize[0]);const d=e.top*a,y=e.bottom*a;return "height"===r||"both"===r?(c=i[1]+d-n[0], p=i[1]+y+n[2]):(c=i[1]+(d+y-s.displaySize[1])/2, p=c+s.displaySize[1]), {image:s,top:c,right:h,bottom:p,left:f,collisionPadding:o}}const tu=128;function eu(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Qn(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let a=i;for(;a<e.length&&e[a]<t+1;)a++;a=Math.min(e.length-1,a);const s=e[i],o=e[a];return "composite"===r.kind?{kind:"composite",minZoom:s,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:s,maxZoom:o,minSize:r.evaluate(new Qn(s)),maxSize:r.evaluate(new Qn(o)),interpolationType:n}}}class ru extends S{constructor(t,e,r,n){super(t,e), this.angle=r, void 0!==n&&(this.segment=n);}clone(){return new ru(this.x,this.y,this.angle,this.segment)}}function nu(t,e,r,n,i){if(void 0===e.segment)return !0;let a=e,s=e.segment+1,o=0;for(;o>-r/2;){if(s--, s<0)return !1;o-=t[s].dist(a), a=t[s];}o+=t[s].dist(t[s+1]), s++;const l=[];let u=0;for(;o<r/2;){const e=t[s],r=t[s+1];if(!r)return !1;let a=t[s-1].angleTo(e)-e.angleTo(r);for(a=Math.abs((a+3*Math.PI)%(2*Math.PI)-Math.PI), l.push({distance:o,angleDelta:a}), u+=a;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;s++, o+=e.dist(r);}return !0}function iu(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function au(t,e,r){return t?.6*e*r:0}function su(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function ou(t,e,r,n,i,a){const s=au(r,i,a),o=su(r,n)*a;let l=0;const u=iu(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],a=n.dist(i);if(l+a>u){const c=(u-l)/a,h=Se(n.x,i.x,c),p=Se(n.y,i.y,c),f=new ru(h,p,i.angleTo(n),r);return f._round(), !s||nu(t,f,o,s,e)?f:void 0}l+=a;}}function lu(t,e,r,n,i,a,s,o,l){const u=au(n,a,s),c=su(n,i),h=c*s,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4), uu(t,p?e/2*o%e:(c/2+2*a)*s*o%e,e,u,r,h,p,!1,l)}function uu(t,e,r,n,i,a,s,o,l){const u=a/2,c=iu(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const s=t[e],o=t[e+1],d=s.dist(o),y=o.angleTo(s);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=Se(s.x,o.x,m),x=Se(s.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new ru(g,x,y,e);r._round(), n&&!nu(t,r,a,n,i)||f.push(r);}}h+=d;}return o||f.length||s||(f=uu(t,h/2,r,n,i,a,s,!0,l)), f}function cu(t,e,r,n,i){const a=[];for(let s=0;s<t.length;s++){const o=t[s];let l;for(let t=0;t<o.length-1;t++){let s=o[t],u=o[t+1];s.x<e&&u.x<e||(s.x<e?s=new S(e,s.y+(e-s.x)/(u.x-s.x)*(u.y-s.y))._round():u.x<e&&(u=new S(e,s.y+(e-s.x)/(u.x-s.x)*(u.y-s.y))._round()), s.y<r&&u.y<r||(s.y<r?s=new S(s.x+(r-s.y)/(u.y-s.y)*(u.x-s.x),r)._round():u.y<r&&(u=new S(s.x+(r-s.y)/(u.y-s.y)*(u.x-s.x),r)._round()), s.x>=n&&u.x>=n||(s.x>=n?s=new S(n,s.y+(n-s.x)/(u.x-s.x)*(u.y-s.y))._round():u.x>=n&&(u=new S(n,s.y+(n-s.x)/(u.x-s.x)*(u.y-s.y))._round()), s.y>=i&&u.y>=i||(s.y>=i?s=new S(s.x+(i-s.y)/(u.y-s.y)*(u.x-s.x),i)._round():u.y>=i&&(u=new S(s.x+(i-s.y)/(u.y-s.y)*(u.x-s.x),i)._round()), l&&s.equals(l[l.length-1])||(l=[s], a.push(l)), l.push(u)))));}}return a}function hu(t,e,r,n){const i=[],a=t.image,s=a.pixelRatio,o=a.paddedRect.w-2,l=a.paddedRect.h-2,u=t.right-t.left,c=t.bottom-t.top,h=a.stretchX||[[0,o]],p=a.stretchY||[[0,l]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=o-d,g=l-y;let x=0,v=d,b=0,w=y,_=0,A=m,k=0,I=g;if(a.content&&n){const t=a.content;x=pu(h,0,t[0]), b=pu(p,0,t[1]), v=pu(h,t[0],t[2]), w=pu(p,t[1],t[3]), _=t[0]-x, k=t[1]-b, A=t[2]-t[0]-v, I=t[3]-t[1]-w;}const M=(n,i,o,l)=>{const h=du(n.stretch-x,v,u,t.left),p=yu(n.fixed-_,A,n.stretch,d),f=du(i.stretch-b,w,c,t.top),m=yu(i.fixed-k,I,i.stretch,y),g=du(o.stretch-x,v,u,t.left),M=yu(o.fixed-_,A,o.stretch,d),z=du(l.stretch-b,w,c,t.top),B=yu(l.fixed-k,I,l.stretch,y),C=new S(h,f),P=new S(g,f),V=new S(g,z),E=new S(h,z),F=new S(p/s,m/s),T=new S(M/s,B/s),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];C._matMult(r), P._matMult(r), E._matMult(r), V._matMult(r);}const D=n.stretch+n.fixed,$=i.stretch+i.fixed;return {tl:C,tr:P,bl:E,br:V,tex:{x:a.paddedRect.x+1+D,y:a.paddedRect.y+1+$,w:o.stretch+o.fixed-D,h:l.stretch+l.fixed-$},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:T,minFontScaleX:A/s/u,minFontScaleY:I/s/c,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=fu(h,m,d),e=fu(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],a=t[r+1];for(let t=0;t<e.length-1;t++)i.push(M(n,e[t],a,e[t+1]));}}else i.push(M({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:o+1},{fixed:0,stretch:l+1}));return i}function pu(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function fu(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}), n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}), n}function du(t,e,r,n){return t/e*r+n}function yu(t,e,r,n){return t-e*r/n}Mn("Anchor",ru);class mu{constructor(t,e,r,n,i,a,s,o,l,u){if(this.boxStartIndex=t.length, l){let t=a.top,e=a.bottom;const r=a.collisionPadding;r&&(t-=r[1], e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n), this.circleDiameter=n);}else {let l=a.top*s-o[0],c=a.bottom*s+o[2],h=a.left*s-o[3],p=a.right*s+o[1];const f=a.collisionPadding;if(f&&(h-=f[0]*s, l-=f[1]*s, p+=f[2]*s, c+=f[3]*s), u){const t=new S(h,l),e=new S(p,l),r=new S(h,c),n=new S(p,c),i=u*Math.PI/180;t._rotate(i), e._rotate(i), r._rotate(i), n._rotate(i), h=Math.min(t.x,e.x,r.x,n.x), p=Math.max(t.x,e.x,r.x,n.x), l=Math.min(t.y,e.y,r.y,n.y), c=Math.max(t.y,e.y,r.y,n.y);}t.emplaceBack(e.x,e.y,h,l,p,c,r,n,i);}this.boxEndIndex=t.length;}}class gu{constructor(t=[],e=xu){if(this.data=t, this.length=this.data.length, this.compare=e, this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t), this.length++, this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--, this.length>0&&(this.data[0]=e, this._down(0)), t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,a=e[i];if(r(n,a)>=0)break;e[t]=a, t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1),a=e[n];const s=n+1;if(s<this.length&&r(e[s],a)<0&&(n=s, a=e[s]), r(a,i)>=0)break;e[t]=a, t=n;}e[t]=i;}}function xu(t,e){return t<e?-1:t>e?1:0}function vu(t,e=1,r=!1){let n=1/0,i=1/0,a=-1/0,s=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x), (!t||e.y<i)&&(i=e.y), (!t||e.x>a)&&(a=e.x), (!t||e.y>s)&&(s=e.y);}const l=Math.min(a-n,s-i);let u=l/2;const c=new gu([],bu);if(0===l)return new S(n,i);for(let e=n;e<a;e+=l)for(let r=i;r<s;r+=l)c.push(new wu(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,a=i.length,s=a-1;t<a;s=t++){const a=i[t],o=i[s],l=a.x*o.y-o.x*a.y;r+=(a.x+o.x)*l, n+=(a.y+o.y)*l, e+=3*l;}return new wu(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n, r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)), n.max-h.d<=e||(u=n.h/2, c.push(new wu(n.p.x-u,n.p.y-u,u,t)), c.push(new wu(n.p.x+u,n.p.y-u,u,t)), c.push(new wu(n.p.x-u,n.p.y+u,u,t)), c.push(new wu(n.p.x+u,n.p.y+u,u,t)), p+=4);}return r&&(console.log(`num probes: ${p}`), console.log(`best distance: ${h.d}`)), h.p}function bu(t,e){return e.max-t.max}function wu(t,e,r,n){this.p=new S(t,e), this.h=r, this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const a=e[i];for(let e=0,i=a.length,s=i-1;e<i;s=e++){const i=a[e],o=a[s];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r), n=Math.min(n,rs(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n), this.max=this.d+this.h*Math.SQRT2;}const _u=Number.POSITIVE_INFINITY;function Au(t,e){return e[1]!==_u?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e), r=Math.abs(r), t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.sqrt(2);switch(t){case"top-right":case"top-left":n=i-7;break;case"bottom-right":case"bottom-left":n=7-i;break;case"bottom":n=7-e;break;case"top":n=e-7;}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e;}return [r,n]}(t,e[0])}function ku(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Su(e,r,n,i,a,s,o,l,u,c,h){let p=s.textMaxSize.evaluate(r,{});void 0===p&&(p=o);const f=e.layers[0].layout,y=f.get("icon-offset").evaluate(r,{},h),m=zu(n.horizontal),g=o/24,x=e.tilePixelRatio*g,v=e.tilePixelRatio*p/24,b=e.tilePixelRatio*l,w=e.tilePixelRatio*f.get("symbol-spacing"),_=f.get("text-padding")*e.tilePixelRatio,A=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),a=i&&i.values;return [a[0]*n,a[1]*n,a[2]*n,a[3]*n]}(f,r,h,e.tilePixelRatio),k=f.get("text-max-angle")/180*Math.PI,S="viewport"!==f.get("text-rotation-alignment")&&"point"!==f.get("symbol-placement"),I="map"===f.get("icon-rotation-alignment")&&"point"!==f.get("symbol-placement"),M=f.get("symbol-placement"),z=w/2,B=f.get("icon-text-fit");let C;i&&"none"!==B&&(e.allowVerticalPlacement&&n.vertical&&(C=Ql(i,n.vertical,B,f.get("icon-text-fit-padding"),y,g)), m&&(i=Ql(i,m,B,f.get("icon-text-fit-padding"),y,g)));const P=(l,p)=>{p.x<0||p.x>=qa||p.y<0||p.y>=qa||function(e,r,n,i,a,s,o,l,u,c,h,p,f,y,m,g,x,v,b,w,_,A,k,S,I){const M=e.addToLineVertexArray(r,n);let z,B,C,P,V=0,E=0,F=0,T=0,L=-1,D=-1;const $={};let R=xa.exports(""),O=0,U=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[O,U]=l.layout.get("text-offset").evaluate(_,{},S).map((t=>t*ll)):(O=l.layout.get("text-radial-offset").evaluate(_,{},S)*ll, U=_u), e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(_,{},S)+90;C=new mu(u,r,c,h,p,i.vertical,f,y,m,t), o&&(P=new mu(u,r,c,h,p,o,x,v,m,t));}if(a){const n=l.layout.get("icon-rotate").evaluate(_,{}),i="none"!==l.layout.get("icon-text-fit"),s=hu(a,n,k,i),f=o?hu(o,n,k,i):void 0;B=new mu(u,r,c,h,p,a,x,v,!1,n), V=4*s.length;const y=e.iconSizeData;let m=null;"source"===y.kind?(m=[tu*l.layout.get("icon-size").evaluate(_,{})], m[0]>Iu&&d(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===y.kind&&(m=[tu*A.compositeIconSizes[0].evaluate(_,{},S),tu*A.compositeIconSizes[1].evaluate(_,{},S)], (m[0]>Iu||m[1]>Iu)&&d(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)), e.addSymbols(e.icon,s,m,w,b,_,t.WritingMode.none,r,M.lineStartIndex,M.lineLength,-1,S), L=e.icon.placedSymbolArray.length-1, f&&(E=4*f.length, e.addSymbols(e.icon,f,m,w,b,_,t.WritingMode.vertical,r,M.lineStartIndex,M.lineLength,-1,S), D=e.icon.placedSymbolArray.length-1);}const q=Object.keys(i.horizontal);for(const n of q){const a=i.horizontal[n];if(!z){R=xa.exports(a.text);const t=l.layout.get("text-rotate").evaluate(_,{},S);z=new mu(u,r,c,h,p,a,f,y,m,t);}const o=1===a.positionedLines.length;if(F+=Mu(e,r,a,s,l,m,_,g,M,i.vertical?t.WritingMode.horizontal:t.WritingMode.horizontalOnly,o?q:[n],$,L,A,S), o)break}i.vertical&&(T+=Mu(e,r,i.vertical,s,l,m,_,g,M,t.WritingMode.vertical,["vertical"],$,D,A,S));const j=z?z.boxStartIndex:e.collisionBoxArray.length,N=z?z.boxEndIndex:e.collisionBoxArray.length,Z=C?C.boxStartIndex:e.collisionBoxArray.length,K=C?C.boxEndIndex:e.collisionBoxArray.length,G=B?B.boxStartIndex:e.collisionBoxArray.length,J=B?B.boxEndIndex:e.collisionBoxArray.length,X=P?P.boxStartIndex:e.collisionBoxArray.length,Y=P?P.boxEndIndex:e.collisionBoxArray.length;let H=-1;const W=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;H=W(z,H), H=W(C,H), H=W(B,H), H=W(P,H);const Q=H>-1?1:0;Q&&(H*=I/ll), e.glyphOffsetArray.length>=Du.MAX_GLYPHS&&d("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"), void 0!==_.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,_.sortKey), e.symbolInstances.emplaceBack(r.x,r.y,$.right>=0?$.right:-1,$.center>=0?$.center:-1,$.left>=0?$.left:-1,$.vertical||-1,L,D,R,j,N,Z,K,G,J,X,Y,c,F,T,V,E,Q,0,f,O,U,H);}(e,p,l,n,i,a,C,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,x,[_,_,_,_],S,u,b,A,I,y,r,s,c,h,o);};if("line"===M)for(const t of cu(r.geometry,0,0,qa,qa)){const r=lu(t,w,k,n.vertical||m,i,24,v,e.overscaling,qa);for(const n of r){const r=m;r&&Bu(e,r.text,z,n)||P(t,n);}}else if("line-center"===M){for(const t of r.geometry)if(t.length>1){const e=ou(t,k,n.vertical||m,i,24,v);e&&P(t,e);}}else if("Polygon"===r.type)for(const t of ho(r.geometry,0)){const e=vu(t,16);P(t[0],new ru(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry)P(t,new ru(t[0].x,t[0].y,0));else if("Point"===r.type)for(const t of r.geometry)for(const e of t)P([e],new ru(e.x,e.y,0));}const Iu=32640;function Mu(t,e,r,n,i,a,s,o,l,u,c,h,p,f,y){const m=function(t,e,r,n,i,a,s,o){const l=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,u=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const a=n.rect||{};let c=4,h=!0,p=1,f=0;const d=(i||o)&&n.vertical,y=n.metrics.advance*n.scale/2;if(o&&e.verticalizable){const e=(n.scale-1)*ll,r=(ll-n.metrics.width*n.scale)/2;f=t.lineOffset/2-(n.imageName?-r:e);}if(n.imageName){const t=s[n.imageName];h=t.sdf, p=t.pixelRatio, c=1/p;}const m=i?[n.x+y,n.y]:[0,0];let g=i?[0,0]:[n.x+y+r[0],n.y+r[1]-f],x=[0,0];d&&(x=g, g=[0,0]);const v=(n.metrics.left-c)*n.scale-y+g[0],b=(-n.metrics.top-c)*n.scale+g[1],w=v+a.w*n.scale/p,_=b+a.h*n.scale/p,A=new S(v,b),k=new S(w,b),I=new S(v,_),M=new S(w,_);if(d){const t=new S(-y,y-$l),e=-Math.PI/2,r=12-y,i=new S(22-r,-(n.imageName?r:0)),a=new S(...x);A._rotateAround(e,t)._add(i)._add(a), k._rotateAround(e,t)._add(i)._add(a), I._rotateAround(e,t)._add(i)._add(a), M._rotateAround(e,t)._add(i)._add(a);}if(l){const t=Math.sin(l),e=Math.cos(l),r=[e,-t,t,e];A._matMult(r), k._matMult(r), I._matMult(r), M._matMult(r);}const z=new S(0,0),B=new S(0,0);u.push({tl:A,tr:k,bl:I,br:M,tex:a,writingMode:e.writingMode,glyphOffset:m,sectionIndex:n.sectionIndex,isSDF:h,pixelOffsetTL:z,pixelOffsetBR:B,minFontScaleX:0,minFontScaleY:0});}return u}(0,r,o,i,a,s,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[tu*i.layout.get("text-size").evaluate(s,{})], x[0]>Iu&&d(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[tu*f.compositeTextSizes[0].evaluate(s,{},y),tu*f.compositeTextSizes[1].evaluate(s,{},y)], (x[0]>Iu||x[1]>Iu)&&d(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)), t.addSymbols(t.text,m,x,o,a,s,u,e,l.lineStartIndex,l.lineLength,p,y);for(const e of c)h[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function zu(t){for(const e in t)return t[e];return null}function Bu(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n), !1}const Cu=_o.VectorTileFeature.types,Pu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Vu(t,e,r,n,i,a,s,o,l,u,c,h,p){const f=o?Math.min(Iu,Math.round(o[0])):0,d=o?Math.min(Iu,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),a,s,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function Eu(t,e,r){t.emplaceBack(e.x,e.y,r), t.emplaceBack(e.x,e.y,r), t.emplaceBack(e.x,e.y,r), t.emplaceBack(e.x,e.y,r);}function Fu(t){for(const e of t.sections)if(On(e.text))return !0;return !1}class Tu{constructor(t){this.layoutVertexArray=new sa, this.indexArray=new ha, this.programConfigurations=t, this.segments=new ya, this.dynamicLayoutVertexArray=new oa, this.opacityVertexArray=new la, this.placedSymbolArray=new Ki;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,el.members), this.indexBuffer=t.createIndexBuffer(this.indexArray,e), this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,rl.members,!0), this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Pu,!0), this.opacityVertexBuffer.itemSize=1), (r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.programConfigurations.destroy(), this.segments.destroy(), this.dynamicLayoutVertexBuffer.destroy(), this.opacityVertexBuffer.destroy());}}Mn("SymbolBuffers",Tu);class Lu{constructor(t,e,r){this.layoutVertexArray=new t, this.layoutAttributes=e, this.indexArray=new r, this.segments=new ya, this.collisionVertexArray=new ca;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes), this.indexBuffer=t.createIndexBuffer(this.indexArray), this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,nl.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(), this.indexBuffer.destroy(), this.segments.destroy(), this.collisionVertexBuffer.destroy());}}Mn("CollisionBuffers",Lu);class Du{constructor(e){this.collisionBoxArray=e.collisionBoxArray, this.zoom=e.zoom, this.overscaling=e.overscaling, this.layers=e.layers, this.layerIds=this.layers.map((t=>t.id)), this.index=e.index, this.pixelRatio=e.pixelRatio, this.sourceLayerIndex=e.sourceLayerIndex, this.hasPattern=!1, this.hasRTLText=!1, this.sortKeyRanges=[], this.collisionCircleArray=[], this.placementInvProjMatrix=ds([]), this.placementViewportMatrix=ds([]);const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=eu(this.zoom,r["text-size"]), this.iconSizeData=eu(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),a=n.get("symbol-z-order");this.canOverlap="never"!==qu(n,"text-overlap","text-allow-overlap")||"never"!==qu(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"), this.sortFeaturesByKey="viewport-y"!==a&&!i.isConstant(), this.sortFeaturesByY=("viewport-y"===a||"auto"===a&&!this.sortFeaturesByKey)&&this.canOverlap, "point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((e=>t.WritingMode[e]))), this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)), this.sourceID=e.sourceID;}createArrays(){this.text=new Tu(new Ra(this.layers,this.zoom,(t=>/^text/.test(t)))), this.icon=new Tu(new Ra(this.layers,this.zoom,(t=>/^icon/.test(t)))), this.glyphOffsetArray=new Xi, this.lineVertexArray=new Yi, this.symbolInstances=new Ji;}calculateGlyphDependencies(t,e,r,n,i){for(let a=0;a<t.length;a++)if(e[t.charCodeAt(a)]=!0, (r||n)&&i){const r=ol[t.charAt(a)];r&&(e[r.charCodeAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],a=i.layout,s=a.get("text-font"),o=a.get("text-field"),l=a.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof Dt&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=a.get("symbol-sort-key");if(this.features=[], !u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new Qn(this.zoom);for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=Ka(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=Za(r)), u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=Dt.factory(t);Fu(e)&&(this.hasRTLText=!0), (!this.hasRTLText||"unavailable"===Yn()||this.hasRTLText&&Wn.isParsed())&&(x=sl(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof Rt?t:Rt.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:Cu[r.type],sortKey:b}), v&&(p[v.name]=!0), x){const e=s.evaluate(g,{},n).join(","),r="viewport"!==a.get("text-rotation-alignment")&&"point"!==a.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.WritingMode.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else {const n=En(x.toString()),i=t.fontStack||e,a=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,a,r,this.allowVerticalPlacement,n);}}}"line"===a.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function a(e){n.push(t[e]), i++;}function s(t,e,i){const a=r[t];return delete r[t], r[e]=a, n[a].geometry[0].pop(), n[a].geometry[0]=n[a].geometry[0].concat(i[0]), a}function o(t,r,i){const a=e[r];return delete e[r], e[t]=a, n[a].geometry[0].shift(), n[a].geometry[0]=i[0].concat(n[a].geometry[0]), a}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){a(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=s(f,d,n[t].geometry);delete e[f], delete r[d], r[l(p,n[i].geometry,!0)]=i, n[t].geometry=null;}else f in r?s(f,d,h):d in e?o(f,d,h):(a(u), e[f]=i-1, r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)), this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r), this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t), this.iconCollisionBox.upload(t)), this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload), this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload), this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(), this.iconCollisionBox.destroy();}destroy(){this.text.destroy(), this.icon.destroy(), this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r}, n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n}, r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,r,n,i,a,s,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?s.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.WritingMode.vertical?Math.PI/2:0,v=s.text&&s.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:a,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:A}=r[t],k=y.vertexLength,S=w[1];Vu(d,l.x,l.y,i.x,S+i.y,c.x,c.y,n,_,h.x,h.y,g,b), Vu(d,l.x,l.y,a.x,S+a.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b), Vu(d,l.x,l.y,o.x,S+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b), Vu(d,l.x,l.y,u.x,S+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b), Eu(e.dynamicLayoutVertexArray,l,x), f.emplaceBack(k,k+1,k+2), f.emplaceBack(k+1,k+2,k+3), y.vertexLength+=4, y.primitiveLength+=2, this.glyphOffsetArray.emplaceBack(w[0]), t!==r.length-1&&A===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,s,s.index,{},p,v&&v[A]);}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,a){return e.emplaceBack(0,0), t.emplaceBack(r.x,r.y,n,i,Math.round(a.x),Math.round(a.y))}addCollisionDebugVertices(t,e,r,n,i,a,s){const o=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),l=o.vertexLength,u=i.layoutVertexArray,c=i.collisionVertexArray,h=s.anchorX,p=s.anchorY;this._addCollisionDebugVertex(u,c,a,h,p,new S(t,e)), this._addCollisionDebugVertex(u,c,a,h,p,new S(r,e)), this._addCollisionDebugVertex(u,c,a,h,p,new S(r,n)), this._addCollisionDebugVertex(u,c,a,h,p,new S(t,n)), o.vertexLength+=4;const f=i.indexArray;f.emplaceBack(l,l+1), f.emplaceBack(l+1,l+2), f.emplaceBack(l+2,l+3), f.emplaceBack(l+3,l), o.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(), this.textCollisionBox=new Lu(ua,il.members,pa), this.iconCollisionBox=new Lu(ua,il.members,pa);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0), this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0), this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1), this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,a,s,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY}, u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY}, u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=a;e<s;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY}, u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY}, u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2), t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],a=[];for(let t=0;t<this.symbolInstances.length;++t){a.push(t);const s=this.symbolInstances.get(t);n.push(0|Math.round(e*s.anchorX+r*s.anchorY)), i.push(s.featureIndex);}return a.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])), a}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t), this.sortedAngle=t, this.text.indexArray.clear(), this.icon.indexArray.clear(), this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex), [e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})), e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex), e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex), e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray), this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}Mn("SymbolBucket",Du,{omit:["layers","collisionBoxArray","features","compareText"]}), Du.MAX_GLYPHS=65535, Du.addDynamicAttributes=Eu;const $u=new fi({"symbol-placement":new li(nt.layout_symbol["symbol-placement"]),"symbol-spacing":new li(nt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new li(nt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new ui(nt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new li(nt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new li(nt.layout_symbol["icon-allow-overlap"]),"icon-overlap":new li(nt.layout_symbol["icon-overlap"]),"icon-ignore-placement":new li(nt.layout_symbol["icon-ignore-placement"]),"icon-optional":new li(nt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new li(nt.layout_symbol["icon-rotation-alignment"]),"icon-size":new ui(nt.layout_symbol["icon-size"]),"icon-text-fit":new li(nt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new li(nt.layout_symbol["icon-text-fit-padding"]),"icon-image":new ui(nt.layout_symbol["icon-image"]),"icon-rotate":new ui(nt.layout_symbol["icon-rotate"]),"icon-padding":new ui(nt.layout_symbol["icon-padding"]),"icon-keep-upright":new li(nt.layout_symbol["icon-keep-upright"]),"icon-offset":new ui(nt.layout_symbol["icon-offset"]),"icon-anchor":new ui(nt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new li(nt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new li(nt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new li(nt.layout_symbol["text-rotation-alignment"]),"text-field":new ui(nt.layout_symbol["text-field"]),"text-font":new ui(nt.layout_symbol["text-font"]),"text-size":new ui(nt.layout_symbol["text-size"]),"text-max-width":new ui(nt.layout_symbol["text-max-width"]),"text-line-height":new li(nt.layout_symbol["text-line-height"]),"text-letter-spacing":new ui(nt.layout_symbol["text-letter-spacing"]),"text-justify":new ui(nt.layout_symbol["text-justify"]),"text-radial-offset":new ui(nt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new li(nt.layout_symbol["text-variable-anchor"]),"text-anchor":new ui(nt.layout_symbol["text-anchor"]),"text-max-angle":new li(nt.layout_symbol["text-max-angle"]),"text-writing-mode":new li(nt.layout_symbol["text-writing-mode"]),"text-rotate":new ui(nt.layout_symbol["text-rotate"]),"text-padding":new li(nt.layout_symbol["text-padding"]),"text-keep-upright":new li(nt.layout_symbol["text-keep-upright"]),"text-transform":new ui(nt.layout_symbol["text-transform"]),"text-offset":new ui(nt.layout_symbol["text-offset"]),"text-allow-overlap":new li(nt.layout_symbol["text-allow-overlap"]),"text-overlap":new li(nt.layout_symbol["text-overlap"]),"text-ignore-placement":new li(nt.layout_symbol["text-ignore-placement"]),"text-optional":new li(nt.layout_symbol["text-optional"])});var Ru={paint:new fi({"icon-opacity":new ui(nt.paint_symbol["icon-opacity"]),"icon-color":new ui(nt.paint_symbol["icon-color"]),"icon-halo-color":new ui(nt.paint_symbol["icon-halo-color"]),"icon-halo-width":new ui(nt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new ui(nt.paint_symbol["icon-halo-blur"]),"icon-translate":new li(nt.paint_symbol["icon-translate"]),"icon-translate-anchor":new li(nt.paint_symbol["icon-translate-anchor"]),"text-opacity":new ui(nt.paint_symbol["text-opacity"]),"text-color":new ui(nt.paint_symbol["text-color"],{runtimeType:yt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new ui(nt.paint_symbol["text-halo-color"]),"text-halo-width":new ui(nt.paint_symbol["text-halo-width"]),"text-halo-blur":new ui(nt.paint_symbol["text-halo-blur"]),"text-translate":new li(nt.paint_symbol["text-translate"]),"text-translate-anchor":new li(nt.paint_symbol["text-translate-anchor"])}),layout:$u};class Ou{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:ht, this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Mn("FormatSectionOverride",Ou,{omit:["defaultValue"]});class Uu extends yi{constructor(t){super(t,Ru);}recalculate(t,e){if(super.recalculate(t,e), "auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"), "auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"), "auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"), "auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")), "point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),a=this._unevaluatedLayout._values[t];return a.isDataDriven()||Er(a.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new Du(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of Ru.paint.overridableProperties){if(!Uu.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Ou(e),n=new Vr(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Tr("source",n):new Lr("composite",n,e.value.zoomStops), this.paint._values[t]=new si(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Uu.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Ru.paint.properties[e];let i=!1;const a=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Dt)a(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof Nt&&qt(e.value)===vt?a(e.value.sections):e instanceof cr?a(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}}function qu(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"), n}var ju={paint:new fi({"background-color":new li(nt.paint_background["background-color"]),"background-pattern":new hi(nt.paint_background["background-pattern"]),"background-opacity":new li(nt.paint_background["background-opacity"])})},Nu={paint:new fi({"raster-opacity":new li(nt.paint_raster["raster-opacity"]),"raster-hue-rotate":new li(nt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new li(nt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new li(nt.paint_raster["raster-brightness-max"]),"raster-saturation":new li(nt.paint_raster["raster-saturation"]),"raster-contrast":new li(nt.paint_raster["raster-contrast"]),"raster-resampling":new li(nt.paint_raster["raster-resampling"]),"raster-fade-duration":new li(nt.paint_raster["raster-fade-duration"])})};class Zu extends yi{constructor(t){super(t,{}), this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}, this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}, this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}const Ku={circle:class extends yi{constructor(t){super(t,cs);}createBucket(t){return new Ja(t)}queryRadius(t){const e=t;return ss("circle-radius",this,e)+ss("circle-stroke-width",this,e)+os(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,a,s,o){const l=ls(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),a.angle,s),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c="map"===this.paint.get("circle-pitch-alignment"),h=c?l:function(t,e){return t.map((t=>_s(t,e)))}(l,o),p=c?u*s:u;for(const t of n)for(const e of t){const t=c?e:_s(e,o);let r=p;const n=bs([],[e.x,e.y,0,1],o);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n[3]/a.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=a.cameraToCenterDistance/n[3]), Ya(h,t,r))return !0}return !1}},heatmap:class extends yi{constructor(t){super(t,ks), this._updateColorRamp();}createBucket(t){return new As(t)}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Cs({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}), this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(), this.heatmapFbo=null);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}},hillshade:class extends yi{constructor(t){super(t,Ps);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}},fill:class extends yi{constructor(t){super(t,xo);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new mo(t)}queryRadius(){return os(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,a,s){return Ha(ls(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),a.angle,s),n)}isTileClipped(){return !0}},"fill-extrusion":class extends yi{constructor(t){super(t,Oo);}createBucket(t){return new Do(t)}queryRadius(){return os(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature(t,e,r,n,i,a,s,o){const l=ls(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,s),u=this.paint.get("fill-extrusion-height").evaluate(e,r),c=this.paint.get("fill-extrusion-base").evaluate(e,r),h=function(t,e,r,n){const i=[];for(const r of t){const t=[r.x,r.y,0,1];bs(t,t,e), i.push(new S(t[0]/t[3],t[1]/t[3]));}return i}(l,o),p=function(t,e,r,n){const i=[],a=[],s=n[8]*e,o=n[9]*e,l=n[10]*e,u=n[11]*e,c=n[8]*r,h=n[9]*r,p=n[10]*r,f=n[11]*r;for(const e of t){const t=[],r=[];for(const i of e){const e=i.x,a=i.y,d=n[0]*e+n[4]*a+n[12],y=n[1]*e+n[5]*a+n[13],m=n[2]*e+n[6]*a+n[14],g=n[3]*e+n[7]*a+n[15],x=m+l,v=g+u,b=d+c,w=y+h,_=m+p,A=g+f,k=new S((d+s)/v,(y+o)/v);k.z=x/v, t.push(k);const I=new S(b/A,w/A);I.z=_/A, r.push(I);}i.push(t), a.push(r);}return [i,a]}(n,c,u,o);return function(t,e,r){let n=1/0;Ha(r,e)&&(n=qo(r,e[0]));for(let i=0;i<e.length;i++){const a=e[i],s=t[i];for(let t=0;t<a.length-1;t++){const e=a[t],i=[e,a[t+1],s[t+1],s[t],e];Xa(r,i)&&(n=Math.min(n,qo(r,i)));}}return n!==1/0&&n}(p[0],p[1],h)}},line:class extends yi{constructor(t){super(t,Wo), this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){"line-gradient"===t&&(this.stepInterpolant=this._transitionablePaint._values["line-gradient"].value.expression._styleExpression.expression instanceof ke, this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER);}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e), this.paint._values["line-floorwidth"]=Qo.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Yo(t)}queryRadius(t){const e=t,r=tl(ss("line-width",this,e),ss("line-gap-width",this,e)),n=ss("line-offset",this,e);return r/2+Math.abs(n)+os(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,a,s){const o=ls(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,s),l=s/2*tl(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],a=[];for(let t=0;t<i.length;t++){const r=i[t-1],n=i[t],s=i[t+1],o=0===t?new S(0,0):n.sub(r)._unit()._perp(),l=t===i.length-1?new S(0,0):s.sub(n)._unit()._perp(),u=o._add(l)._unit(),c=u.x*l.x+u.y*l.y;0!==c&&u._mult(1/c), a.push(u._mult(e)._add(n));}r.push(a);}return r}(n,u*s)), function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(is(t,i[e]))return !0;if(Wa(t,i,r))return !0}return !1}(o,n,l)}isTileClipped(){return !0}},symbol:Uu,background:class extends yi{constructor(t){super(t,ju);}},raster:class extends yi{constructor(t){super(t,Nu);}}};class Gu{constructor(t){this._callback=t, this._triggered=!1, "undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel, this._channel.port2.onmessage=()=>{this._triggered=!1, this._callback();});}trigger(){this._triggered||(this._triggered=!0, this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1, this._callback();}),0));}remove(){delete this._channel, this._callback=()=>{};}}const Ju=6371008.8;class Xu{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t, this.lat=+e, this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Xu(s(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Ju*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new Yu(new Xu(this.lng-r,this.lat-e),new Xu(this.lng+r,this.lat+e))}static convert(t){if(t instanceof Xu)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Xu(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Xu(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class Yu{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof Xu?new Xu(t.lng,t.lat):Xu.convert(t), this}setSouthWest(t){return this._sw=t instanceof Xu?new Xu(t.lng,t.lat):Xu.convert(t), this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof Xu)n=t, i=t;else {if(!(t instanceof Yu))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(Yu.convert(t)):this.extend(Xu.convert(t)):this;if(n=t._sw, i=t._ne, !n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng), e.lat=Math.min(n.lat,e.lat), r.lng=Math.max(i.lng,r.lng), r.lat=Math.max(i.lat,r.lat)):(this._sw=new Xu(n.lng,n.lat), this._ne=new Xu(i.lng,i.lat)), this}getCenter(){return new Xu((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Xu(this.getWest(),this.getNorth())}getSouthEast(){return new Xu(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=Xu.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng), this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){return t instanceof Yu?t:t?new Yu(t):t}}const Hu=2*Math.PI*Ju;function Wu(t){return Hu*Math.cos(t*Math.PI/180)}function Qu(t){return (180+t)/360}function tc(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function ec(t,e){return t/Wu(e)}function rc(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class nc{constructor(t,e,r=0){this.x=+t, this.y=+e, this.z=+r;}static fromLngLat(t,e=0){const r=Xu.convert(t);return new nc(Qu(r.lng),tc(r.lat),ec(e,r.lat))}toLngLat(){return new Xu(360*this.x-180,rc(this.y))}toAltitude(){return this.z*Wu(rc(this.y))}meterInMercatorCoordinateUnits(){return 1/Hu*(t=rc(this.y), 1/Math.cos(t*Math.PI/180));var t;}}function ic(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class ac{constructor(t,e,r){if(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t, this.x=e, this.y=r, this.key=lc(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(a=this.y, s=this.z, o=ic(256*(i=this.x),256*(a=Math.pow(2,s)-a-1),s), l=ic(256*(i+1),256*(a+1),s), o[0]+","+o[1]+","+l[0]+","+l[1]);var i,a,s,o,l;const u=function(t,e,r){let n,i="";for(let a=t;a>0;a--)n=1<<a-1, i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new S((t.x*e-this.x)*qa,(t.y*e-this.y)*qa)}toString(){return `${this.z}/${this.x}/${this.y}`}}class sc{constructor(t,e){this.wrap=t, this.canonical=e, this.key=lc(t,e.z,e.z,e.x,e.y);}}class oc{constructor(t,e,r,n,i){if(t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t, this.wrap=e, this.canonical=new ac(r,+n,+i), this.key=lc(e,t,r,n,i);}clone(){return new oc(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new oc(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new oc(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?lc(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):lc(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new oc(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new oc(e,this.wrap,e,r,n),new oc(e,this.wrap,e,r+1,n),new oc(e,this.wrap,e,r,n+1),new oc(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new oc(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new oc(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new sc(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new nc(t.x-this.wrap,t.y))}}function lc(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const a=1<<r;return (a*a*t+a*i+n).toString(36)+r.toString(36)+e.toString(36)}Mn("CanonicalTileID",ac), Mn("OverscaledTileID",oc,{omit:["posMatrix"]});class uc{constructor(t,e,r){if(this.uid=t, e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return void d(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const n=this.dim=e.height-2;this.data=new Uint32Array(e.data.buffer), this.encoding=r||"mapbox";for(let t=0;t<n;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)], this.data[this._idx(n,t)]=this.data[this._idx(n-1,t)], this.data[this._idx(t,-1)]=this.data[this._idx(t,0)], this.data[this._idx(t,n)]=this.data[this._idx(t,n-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)], this.data[this._idx(n,-1)]=this.data[this._idx(n-1,0)], this.data[this._idx(-1,n)]=this.data[this._idx(0,n-1)], this.data[this._idx(n,n)]=this.data[this._idx(n-1,n-1)], this.min=Number.MAX_SAFE_INTEGER, this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<n;t++)for(let e=0;e<n;e++){const r=this.get(t,e);r>this.max&&(this.max=r), r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return ("terrarium"===this.encoding?this._unpackTerrarium:this._unpackMapbox)(r[n],r[n+1],r[n+2])}getUnpackVector(){return "terrarium"===this.encoding?[256,1,1/256,32768]:[6553.6,25.6,.1,1e4]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}_unpackMapbox(t,e,r){return (256*t*256+256*e+r)/10-1e4}_unpackTerrarium(t,e,r){return 256*t+e+r/256-32768}getPixels(){return new Bs({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,a=r*this.dim,s=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:a=s-1;break;case 1:s=a+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=a;e<s;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}Mn("DEMData",uc);class cc{constructor(t){this._stringToNumber={}, this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e, this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class hc{constructor(t,e,r,n,i){this.type="Feature", this._vectorTileFeature=t, t._z=e, t._x=r, t._y=n, this.properties=t.properties, this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry), this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class pc{constructor(t,e){this.tileID=t, this.x=t.canonical.x, this.y=t.canonical.y, this.z=t.canonical.z, this.grid=new Sn(qa,16,0), this.grid3D=new Sn(qa,16,0), this.featureIndexArray=new Wi, this.promoteId=e;}insert(t,e,r,n,i,a){const s=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=a?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x), n[1]=Math.min(n[1],e.y), n[2]=Math.max(n[2],e.x), n[3]=Math.max(n[3],e.y);}n[0]<qa&&n[1]<qa&&n[2]>=0&&n[3]>=0&&o.insert(s,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new _o.VectorTile(new ul(this.rawTileData)).layers, this.sourceLayerCoder=new cc(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])), this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},a=qa/t.tileSize/t.scale,s=Jr(i.filter),o=t.queryGeometry,l=t.queryPadding*a,u=dc(o),c=this.grid.query(u.minX-l,u.minY-l,u.maxX+l,u.maxY+l),h=dc(t.cameraQueryGeometry),p=this.grid3D.query(h.minX-l,h.minY-l,h.maxX+l,h.maxY+l,((e,r,n,i)=>(function(t, e, r, n, i) {for(const a of t)if(e<=a.x&&r<=a.y&&n>=a.x&&i>=a.y)return !0;const a=[new S(e,r),new S(e,i),new S(n,i),new S(n,r)];if(t.length>2)for(const e of a)if(is(t,e))return !0;for(let e=0;e<t.length-1;e++)if(as(t[e],t[e+1],a))return !0;return !1})(t.cameraQueryGeometry,e-l,r-l,n+l,i+l)));for(const t of p)c.push(t);c.sort(yc);const f={};let d;for(let l=0;l<c.length;l++){const u=c[l];if(u===d)continue;d=u;const h=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,s,i.layers,i.availableImages,e,r,n,((e,r,n)=>(p||(p=Za(e)), r.queryIntersectsFeature(o,e,n,p,this.z,t.transform,a,t.pixelPosMatrix))));}return f}loadMatchingFeature(t,e,r,n,i,a,s,l,u,c,h){const p=this.bucketLayerIDs[e];if(a&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(a,p))return;const f=this.sourceLayerCoder.decode(r),d=this.vtLayers[f].feature(n);if(i.needGeometry){const t=Ka(d,!0);if(!i.filter(new Qn(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new Qn(this.tileID.overscaledZ),d))return;const y=this.getId(d,f);for(let e=0;e<p.length;e++){const r=p[e];if(a&&a.indexOf(r)<0)continue;const i=l[r];if(!i)continue;let f={};y&&c&&(f=c.getState(i.sourceLayer||"_geojsonTileLayer",y));const m=o({},u[r]);m.paint=fc(m.paint,i.paint,d,f,s), m.layout=fc(m.layout,i.layout,d,f,s);const g=!h||h(d,i,f);if(!g)continue;const x=new hc(d,this.z,this.x,this.y,y);x.layer=m;let v=t[r];void 0===v&&(v=t[r]=[]), v.push({featureIndex:n,feature:x,intersectionZ:g});}}lookupSymbolFeatures(t,e,r,n,i,a,s,o){const l={};this.loadVTLayers();const u=Jr(i);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,a,s,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]], "boolean"==typeof r&&(r=Number(r))), r}}function fc(t,e,r,n,i){return c(t,((t,a)=>{const s=e instanceof oi?e.get(a):null;return s&&s.evaluate?s.evaluate(r,n,i):s}))}function dc(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const a of t)e=Math.min(e,a.x), r=Math.min(r,a.y), n=Math.max(n,a.x), i=Math.max(i,a.y);return {minX:e,minY:r,maxX:n,maxY:i}}function yc(t,e){return e-t}var mc;Mn("FeatureIndex",pc,{omit:["rawTileData","sourceLayerCoder"]}), t.PerformanceMarkers=void 0, (mc=t.PerformanceMarkers||(t.PerformanceMarkers={})).create="create", mc.load="load", mc.fullLoad="fullLoad";let gc=null,xc=[];const vc=1e3/30,bc={mark(t){performance.mark(t);},frame(t){const e=t;null!=gc&&xc.push(e-gc), gc=e;},clearMetrics(){gc=null, xc=[], performance.clearMeasures("loadTime"), performance.clearMeasures("fullLoadTime");for(const e in t.PerformanceMarkers)performance.clearMarks(t.PerformanceMarkers[e]);},getPerformanceMetrics(){performance.measure("loadTime",t.PerformanceMarkers.create,t.PerformanceMarkers.load), performance.measure("fullLoadTime",t.PerformanceMarkers.create,t.PerformanceMarkers.fullLoad);const e=performance.getEntriesByName("loadTime")[0].duration,r=performance.getEntriesByName("fullLoadTime")[0].duration,n=xc.length,i=1/(xc.reduce(((t,e)=>t+e),0)/n/1e3),a=xc.filter((t=>t>vc)).reduce(((t,e)=>t+(e-vc)/vc),0);return {loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:a/(n+a)*100}}};t.AJAXError=q, t.ARRAY_TYPE=ps, t.Actor=class{constructor(t,e,r){this.target=t, this.parent=e, this.mapId=r, this.callbacks={}, this.tasks={}, this.taskQueue=[], this.cancelCallbacks={}, u(["receive","process"],this), this.invoker=new Gu(this.process), this.target.addEventListener("message",this.receive,!1), this.globalScope=g()?t:window;}send(t,e,r,n,i=!1){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(this.callbacks[a]=r);const s=_(this.globalScope)?void 0:[];return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:Bn(e,s)},s), {cancel:()=>{r&&delete this.callbacks[a], this.target.postMessage({id:a,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){delete this.tasks[r];const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r], t&&t();}else g()||e.mustQueue?(this.tasks[r]=e, this.taskQueue.push(r), this.invoker.trigger()):this.processTask(r,e);}process(){if(!this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t], this.taskQueue.length&&this.invoker.trigger(), e&&this.processTask(t,e);}processTask(t,e){if("<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t], r&&(e.error?r(Cn(e.error)):r(null,Cn(e.data)));}else {let r=!1;const n=_(this.globalScope)?void 0:[],i=e.hasCallback?(e,i)=>{r=!0, delete this.cancelCallbacks[t], this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Bn(e):null,data:Bn(i,n)},n);}:t=>{r=!0;};let a=null;const s=Cn(e.data);if(this.parent[e.type])a=this.parent[e.type](e.sourceMapId,s,i);else if(this.parent.getWorkerSource){const t=e.type.split(".");a=this.parent.getWorkerSource(e.sourceMapId,t[0],s.source)[t[1]](s,i);}else i(new Error(`Could not find function ${e.type}`));!r&&a&&a.cancel&&(this.cancelCallbacks[t]=a.cancel);}}remove(){this.invoker.remove(), this.target.removeEventListener("message",this.receive,!1);}}, t.AlphaImage=zs, t.CanonicalTileID=ac, t.CollisionBoxArray=Ni, t.CollisionCircleLayoutArray=class extends Vi{}, t.Color=Ft, t.DEMData=uc, t.DataConstantProperty=li, t.DictionaryCoder=cc, t.EXTENT=qa, t.ErrorEvent=et, t.EvaluationParameters=Qn, t.Event=tt, t.Evented=rt, t.FeatureIndex=pc, t.FillBucket=mo, t.FillExtrusionBucket=Do, t.GeoJSONFeature=hc, t.ImageAtlas=Dl, t.ImagePosition=Ll, t.LineBucket=Yo, t.LineStripIndexArray=class extends Ui{}, t.LngLat=Xu, t.LngLatBounds=Yu, t.MercatorCoordinate=nc, t.ONE_EM=ll, t.OverscaledTileID=oc, t.PerformanceUtils=bc, t.PosArray=Qi, t.Properties=fi, t.QuadTriangleArray=class extends Fi{}, t.RGBAImage=Bs, t.RasterBoundsArray=class extends _i{}, t.RequestPerformance=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()}, performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end), t=performance.getEntriesByName(this._marks.measure), performance.clearMarks(this._marks.start), performance.clearMarks(this._marks.end), performance.clearMeasures(this._marks.measure)), t}}, t.ResourceType=U, t.SegmentVector=ya, t.SymbolBucket=Du, t.Transitionable=ri, t.TriangleIndexArray=ha, t.Uniform1f=za, t.Uniform1i=class extends Ma{constructor(t,e){super(t,e), this.current=0;}set(t){this.current!==t&&(this.current=t, this.gl.uniform1i(this.location,t));}}, t.Uniform2f=class extends Ma{constructor(t,e){super(t,e), this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t, this.gl.uniform2f(this.location,t[0],t[1]));}}, t.Uniform3f=class extends Ma{constructor(t,e){super(t,e), this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t, this.gl.uniform3f(this.location,t[0],t[1],t[2]));}}, t.Uniform4f=Ba, t.UniformColor=Ca, t.UniformMatrix4f=class extends Ma{constructor(t,e){super(t,e), this.current=Pa;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t, void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t, this.gl.uniformMatrix4fv(this.location,!1,t);break}}}, t.UnwrappedTileID=sc, t.ValidationError=it, t.ZoomHistory=Pn, t.add=function(t,e,r){return t[0]=e[0]+r[0], t[1]=e[1]+r[1], t[2]=e[2]+r[2], t}, t.addDynamicAttributes=Eu, t.asyncAll=function(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let a=null;t.forEach(((t,s)=>{e(t,((t,e)=>{t&&(a=t), i[s]=e, 0==--n&&r(a,i);}));}));}, t.bezier=n, t.bindAll=u, t.cacheEntryPossiblyAdded=function(t){F++, F>V&&(t.getActor().send("enforceCacheSizeLimit",P), F=0);}, t.clamp=a, t.clearTileCache=function(t){const e=caches.delete(z);t&&e.catch(t).then((()=>t()));}, t.clipLine=cu, t.clone=function(t){var e=new ps(16);return e[0]=t[0], e[1]=t[1], e[2]=t[2], e[3]=t[3], e[4]=t[4], e[5]=t[5], e[6]=t[6], e[7]=t[7], e[8]=t[8], e[9]=t[9], e[10]=t[10], e[11]=t[11], e[12]=t[12], e[13]=t[13], e[14]=t[14], e[15]=t[15], e}, t.clone$1=p, t.clone$2=function(t){var e=new ps(3);return e[0]=t[0], e[1]=t[1], e[2]=t[2], e}, t.collisionCircleLayout=al, t.config=M, t.copy=function(t,e){return t[0]=e[0], t[1]=e[1], t[2]=e[2], t[3]=e[3], t[4]=e[4], t[5]=e[5], t[6]=e[6], t[7]=e[7], t[8]=e[8], t[9]=e[9], t[10]=e[10], t[11]=e[11], t[12]=e[12], t[13]=e[13], t[14]=e[14], t[15]=e[15], t}, t.create=function(){var t=new ps(16);return ps!=Float32Array&&(t[1]=0, t[2]=0, t[3]=0, t[4]=0, t[6]=0, t[7]=0, t[8]=0, t[9]=0, t[11]=0, t[12]=0, t[13]=0, t[14]=0), t[0]=1, t[5]=1, t[10]=1, t[15]=1, t}, t.create$1=fs, t.createExpression=Fr, t.createFilter=Jr, t.createLayout=vi, t.createStyleLayer=function(t){return "custom"===t.type?new Zu(t):new Ku[t.type](t)}, t.cross=function(t,e,r){var n=e[0],i=e[1],a=e[2],s=r[0],o=r[1],l=r[2];return t[0]=i*l-a*o, t[1]=a*s-n*l, t[2]=n*o-i*s, t}, t.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}, t.dot$1=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]}, t.ease=i, t.emitValidationErrors=kn, t.enforceCacheSizeLimit=function(t){E(), B&&B.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));}, t.equals=function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],s=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],y=t[13],m=t[14],g=t[15],x=e[0],v=e[1],b=e[2],w=e[3],_=e[4],A=e[5],k=e[6],S=e[7],I=e[8],M=e[9],z=e[10],B=e[11],C=e[12],P=e[13],V=e[14],E=e[15];return Math.abs(r-x)<=hs*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(n-v)<=hs*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(i-b)<=hs*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(a-w)<=hs*Math.max(1,Math.abs(a),Math.abs(w))&&Math.abs(s-_)<=hs*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(o-A)<=hs*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-k)<=hs*Math.max(1,Math.abs(l),Math.abs(k))&&Math.abs(u-S)<=hs*Math.max(1,Math.abs(u),Math.abs(S))&&Math.abs(c-I)<=hs*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-M)<=hs*Math.max(1,Math.abs(h),Math.abs(M))&&Math.abs(p-z)<=hs*Math.max(1,Math.abs(p),Math.abs(z))&&Math.abs(f-B)<=hs*Math.max(1,Math.abs(f),Math.abs(B))&&Math.abs(d-C)<=hs*Math.max(1,Math.abs(d),Math.abs(C))&&Math.abs(y-P)<=hs*Math.max(1,Math.abs(y),Math.abs(P))&&Math.abs(m-V)<=hs*Math.max(1,Math.abs(m),Math.abs(V))&&Math.abs(g-E)<=hs*Math.max(1,Math.abs(g),Math.abs(E))}, t.evaluateSizeForFeature=function(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/tu:"composite"===t.kind?Se(n/tu,i/tu,r):e}, t.evaluateSizeForZoom=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:o}=t,l=i?a(Ne.interpolationFactor(i,e,s,o),0,1):0;"camera"===t.kind?n=Se(t.minSize,t.maxSize,l):r=l;}return {uSizeT:r,uSize:n}}, t.evaluateVariableOffset=Au, t.evented=Xn, t.exported=k, t.exported$1=T, t.extend=o, t.filterObject=h, t.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n, t[1]=r, t[2]=0, t[3]=-r, t[4]=n, t[5]=0, t[6]=0, t[7]=0, t[8]=1, t}, t.fromScaling=function(t,e){return t[0]=e[0], t[1]=0, t[2]=0, t[3]=0, t[4]=0, t[5]=e[1], t[6]=0, t[7]=0, t[8]=0, t[9]=0, t[10]=e[2], t[11]=0, t[12]=0, t[13]=0, t[14]=0, t[15]=1, t}, t.getAnchorAlignment=Yl, t.getAnchorJustification=ku, t.getArrayBuffer=K, t.getImage=H, t.getJSON=function(t,e){return Z(o(t,{type:"json"}),e)}, t.getOverlapMode=qu, t.getRTLTextPluginStatus=Yn, t.getReferrer=j, t.getVideo=function(t,e){const r=window.document.createElement("video");r.muted=!0, r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=window.document.createElement("source");G(t[e])||(r.crossOrigin="Anonymous"), n.src=t[e], r.appendChild(n);}return {cancel:()=>{}}}, t.identity=ds, t.invert=function(t,e){var r=e[0],n=e[1],i=e[2],a=e[3],s=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*s,v=r*l-i*s,b=r*u-a*s,w=n*l-i*o,_=n*u-a*o,A=i*u-a*l,k=c*y-h*d,S=c*m-p*d,I=c*g-f*d,M=h*m-p*y,z=h*g-f*y,B=p*g-f*m,C=x*B-v*z+b*M+w*I-_*S+A*k;return C?(t[0]=(o*B-l*z+u*M)*(C=1/C), t[1]=(i*z-n*B-a*M)*C, t[2]=(y*A-m*_+g*w)*C, t[3]=(p*_-h*A-f*w)*C, t[4]=(l*I-s*B-u*S)*C, t[5]=(r*B-i*I+a*S)*C, t[6]=(m*b-d*A-g*v)*C, t[7]=(c*A-p*b+f*v)*C, t[8]=(s*z-o*I+u*k)*C, t[9]=(n*I-r*z-a*k)*C, t[10]=(d*_-y*b+g*x)*C, t[11]=(h*b-c*_-f*x)*C, t[12]=(o*S-s*M-l*k)*C, t[13]=(r*M-n*S+i*k)*C, t[14]=(y*v-d*w-m*x)*C, t[15]=(c*w-h*v+p*x)*C, t):null}, t.isImageBitmap=A, t.isSafari=_, t.isWorker=g, t.keysDifference=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r}, t.lazyLoadRTLTextPlugin=function(){Wn.isLoading()||Wn.isLoaded()||"deferred"!==Yn()||Hn();}, t.makeRequest=Z, t.mapObject=c, t.mercatorXfromLng=Qu, t.mercatorYfromLat=tc, t.mercatorZfromAltitude=ec, t.mul=gs, t.mul$1=function(t,e,r){return t[0]=e[0]*r[0], t[1]=e[1]*r[1], t[2]=e[2]*r[2], t[3]=e[3]*r[3], t}, t.multiply=ys, t.nextPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}, t.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],a=r*r+n*n+i*i;return a>0&&(a=1/Math.sqrt(a)), t[0]=e[0]*a, t[1]=e[1]*a, t[2]=e[2]*a, t}, t.number=Se, t.ortho=function(t,e,r,n,i,a,s){var o=1/(e-r),l=1/(n-i),u=1/(a-s);return t[0]=-2*o, t[1]=0, t[2]=0, t[3]=0, t[4]=0, t[5]=-2*l, t[6]=0, t[7]=0, t[8]=0, t[9]=0, t[10]=2*u, t[11]=0, t[12]=(e+r)*o, t[13]=(i+n)*l, t[14]=(s+a)*u, t[15]=1, t}, t.parseCacheControl=x, t.parseGlyphPbf=function(t){return new ul(t).readFields(Vl,[])}, t.pbf=ul, t.performSymbolLayout=function(e){e.bucket.createArrays(), e.bucket.tilePixelRatio=qa/(512*e.bucket.overscaling), e.bucket.compareText={}, e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0].layout,n=e.bucket.layers[0]._unevaluatedLayout._values,i={layoutIconSize:n["icon-size"].possiblyEvaluate(new Qn(e.bucket.zoom+1),e.canonical),layoutTextSize:n["text-size"].possiblyEvaluate(new Qn(e.bucket.zoom+1),e.canonical),textMaxSize:n["text-size"].possiblyEvaluate(new Qn(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;i.compositeTextSizes=[n["text-size"].possiblyEvaluate(new Qn(t),e.canonical),n["text-size"].possiblyEvaluate(new Qn(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;i.compositeIconSizes=[n["icon-size"].possiblyEvaluate(new Qn(t),e.canonical),n["icon-size"].possiblyEvaluate(new Qn(r),e.canonical)];}const a=r.get("text-line-height")*ll,s="viewport"!==r.get("text-rotation-alignment")&&"point"!==r.get("symbol-placement"),o=r.get("text-keep-upright"),l=r.get("text-size");for(const n of e.bucket.features){const u=r.get("text-font").evaluate(n,{},e.canonical).join(","),c=l.evaluate(n,{},e.canonical),h=i.layoutTextSize.evaluate(n,{},e.canonical),p=i.layoutIconSize.evaluate(n,{},e.canonical),f={horizontal:{},vertical:void 0},y=n.text;let m,g=[0,0];if(y){const i=y.toString(),l=r.get("text-letter-spacing").evaluate(n,{},e.canonical)*ll,p=Fn(i)?l:0,d=r.get("text-anchor").evaluate(n,{},e.canonical),m=r.get("text-variable-anchor");if(!m){const t=r.get("text-radial-offset").evaluate(n,{},e.canonical);g=t?Au(d,[t*ll,_u]):r.get("text-offset").evaluate(n,{},e.canonical).map((t=>t*ll));}let x=s?"center":r.get("text-justify").evaluate(n,{},e.canonical);const v=r.get("symbol-placement"),b="point"===v?r.get("text-max-width").evaluate(n,{},e.canonical)*ll:0,w=()=>{e.bucket.allowVerticalPlacement&&En(i)&&(f.vertical=Ul(y,e.glyphMap,e.glyphPositions,e.imagePositions,u,b,a,d,"left",p,g,t.WritingMode.vertical,!0,v,h,c));};if(!s&&m){const r="auto"===x?m.map((t=>ku(t))):[x];let n=!1;for(let i=0;i<r.length;i++){const s=r[i];if(!f.horizontal[s])if(n)f.horizontal[s]=f.horizontal[0];else {const r=Ul(y,e.glyphMap,e.glyphPositions,e.imagePositions,u,b,a,"center",s,p,g,t.WritingMode.horizontal,!1,v,h,c);r&&(f.horizontal[s]=r, n=1===r.positionedLines.length);}}w();}else {"auto"===x&&(x=ku(d));const r=Ul(y,e.glyphMap,e.glyphPositions,e.imagePositions,u,b,a,d,x,p,g,t.WritingMode.horizontal,!1,v,h,c);r&&(f.horizontal[x]=r), w(), En(i)&&s&&o&&(f.vertical=Ul(y,e.glyphMap,e.glyphPositions,e.imagePositions,u,b,a,d,x,p,g,t.WritingMode.vertical,!1,v,h,c));}}let x=!1;if(n.icon&&n.icon.name){const t=e.imageMap[n.icon.name];t&&(m=Wl(e.imagePositions[n.icon.name],r.get("icon-offset").evaluate(n,{},e.canonical),r.get("icon-anchor").evaluate(n,{},e.canonical)), x=!!t.sdf, void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&d("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"), (t.pixelRatio!==e.bucket.pixelRatio||0!==r.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=zu(f.horizontal)||f.vertical;e.bucket.iconsInText=!!v&&v.iconsInText, (v||m)&&Su(e.bucket,n,f,m,e.imageMap,i,h,p,g,x,e.canonical);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();}, t.perspective=function(t,e,r,n,i){var a,s=1/Math.tan(e/2);return t[0]=s/r, t[1]=0, t[2]=0, t[3]=0, t[4]=0, t[5]=s, t[6]=0, t[7]=0, t[8]=0, t[9]=0, t[11]=-1, t[12]=0, t[13]=0, t[15]=0, null!=i&&i!==1/0?(t[10]=(i+n)*(a=1/(n-i)), t[14]=2*i*n*a):(t[10]=-1, t[14]=-2*n), t}, t.pick=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r}, t.plugin=Wn, t.pointGeometry=S, t.polygonIntersectsPolygon=Xa, t.potpack=Tl, t.refProperties=["type","source","source-layer","minzoom","maxzoom","filter","layout"], t.register=Mn, t.registerForPluginStateChange=function(t){return t({pluginStatus:Zn,pluginURL:Kn}), Xn.on("pluginStateChange",t), t}, t.renderColorRamp=Cs, t.rotateX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[4],s=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0], t[1]=e[1], t[2]=e[2], t[3]=e[3], t[12]=e[12], t[13]=e[13], t[14]=e[14], t[15]=e[15]), t[4]=a*i+u*n, t[5]=s*i+c*n, t[6]=o*i+h*n, t[7]=l*i+p*n, t[8]=u*i-a*n, t[9]=c*i-s*n, t[10]=h*i-o*n, t[11]=p*i-l*n, t}, t.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),a=e[0],s=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8], t[9]=e[9], t[10]=e[10], t[11]=e[11], t[12]=e[12], t[13]=e[13], t[14]=e[14], t[15]=e[15]), t[0]=a*i+u*n, t[1]=s*i+c*n, t[2]=o*i+h*n, t[3]=l*i+p*n, t[4]=u*i-a*n, t[5]=c*i-s*n, t[6]=h*i-o*n, t[7]=p*i-l*n, t}, t.scale=function(t,e,r){var n=r[0],i=r[1],a=r[2];return t[0]=e[0]*n, t[1]=e[1]*n, t[2]=e[2]*n, t[3]=e[3]*n, t[4]=e[4]*i, t[5]=e[5]*i, t[6]=e[6]*i, t[7]=e[7]*i, t[8]=e[8]*a, t[9]=e[9]*a, t[10]=e[10]*a, t[11]=e[11]*a, t[12]=e[12], t[13]=e[13], t[14]=e[14], t[15]=e[15], t}, t.scale$1=function(t,e,r){return t[0]=e[0]*r, t[1]=e[1]*r, t[2]=e[2]*r, t}, t.setCacheLimits=function(t,e){P=t, V=e;}, t.setRTLTextPlugin=function(t,e,r=!1){if(Zn===Un||Zn===qn||Zn===jn)throw new Error("setRTLTextPlugin cannot be called multiple times.");Kn=k.resolveURL(t), Zn=Un, Nn=e, Jn(), r||Hn();}, t.spec=nt, t.sphericalToCartesian=function([t,e,r]){return e+=90, e*=Math.PI/180, r*=Math.PI/180, {x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)}}, t.sqrLen=function(t){var e=t[0],r=t[1];return e*e+r*r}, t.sub=function(t,e,r){return t[0]=e[0]-r[0], t[1]=e[1]-r[1], t[2]=e[2]-r[2], t}, t.toEvaluationFeature=Ka, t.transformMat3=function(t,e,r){var n=e[0],i=e[1],a=e[2];return t[0]=n*r[0]+i*r[3]+a*r[6], t[1]=n*r[1]+i*r[4]+a*r[7], t[2]=n*r[2]+i*r[5]+a*r[8], t}, t.transformMat4=bs, t.transformMat4$1=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12], t[1]=r[1]*n+r[5]*i+r[13], t}, t.translate=function(t,e,r){var n,i,a,s,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12], t[13]=e[1]*y+e[5]*m+e[9]*g+e[13], t[14]=e[2]*y+e[6]*m+e[10]*g+e[14], t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1], a=e[2], s=e[3], o=e[4], l=e[5], u=e[6], c=e[7], h=e[8], p=e[9], f=e[10], d=e[11], t[0]=n=e[0], t[1]=i, t[2]=a, t[3]=s, t[4]=o, t[5]=l, t[6]=u, t[7]=c, t[8]=h, t[9]=p, t[10]=f, t[11]=d, t[12]=n*y+o*m+h*g+e[12], t[13]=i*y+l*m+p*g+e[13], t[14]=a*y+u*m+f*g+e[14], t[15]=s*y+c*m+d*g+e[15]), t}, t.triggerPluginCompletionEvent=Gn, t.unicodeBlockLookup=Vn, t.uniqueId=function(){return l++}, t.validateCustomStyleLayer=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}), void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}), t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}), e}, t.validateLight=wn, t.validateStyle=bn, t.vectorTile=_o, t.warnOnce=d, t.wrap=s;})(sharedChunk); (function(e){function t(e){const o=typeof e;if("number"===o||"boolean"===o||"string"===o||null==e)return JSON.stringify(e);if(Array.isArray(e)){let o="[";for(const i of e)o+=`${t(i)},`;return `${o}]`}const i=Object.keys(e).sort();let r="{";for(let o=0;o<i.length;o++)r+=`${JSON.stringify(i[o])}:${t(e[i[o]])},`;return `${r}}`}function o(o){let i="";for(const r of e.refProperties)i+=`/${t(o[r])}`;return i}class i{constructor(e){this.keyCache={}, e&&this.replace(e);}replace(e){this._layerConfigs={}, this._layers={}, this.update(e,[]);}update(t,i){for(const o of t){this._layerConfigs[o.id]=o;const t=this._layers[o.id]=e.createStyleLayer(o);t._featureFilter=e.createFilter(t.filter), this.keyCache[o.id]&&delete this.keyCache[o.id];}for(const e of i)delete this.keyCache[e], delete this._layerConfigs[e], delete this._layers[e];this.familiesBySource={};const r=function(e,t){const i={};for(let r=0;r<e.length;r++){const n=t&&t[e[r].id]||o(e[r]);t&&(t[e[r].id]=n);let s=i[n];s||(s=i[n]=[]), s.push(e[r]);}const r=[];for(const e in i)r.push(i[e]);return r}(Object.values(this._layerConfigs),this.keyCache);for(const e of r){const t=e.map((e=>this._layers[e.id])),o=t[0];if("none"===o.visibility)continue;const i=o.source||"";let r=this.familiesBySource[i];r||(r=this.familiesBySource[i]={});const n=o.sourceLayer||"_geojsonTileLayer";let s=r[n];s||(s=r[n]=[]), s.push(t);}}}class r{constructor(t){const o={},i=[];for(const e in t){const r=t[e],n=o[e]={};for(const e in r){const t=r[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const o={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};i.push(o), n[e]={rect:o,metrics:t.metrics};}}const{w:r,h:n}=e.potpack(i),s=new e.AlphaImage({width:r||1,height:n||1});for(const i in t){const r=t[i];for(const t in r){const n=r[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=o[i][t].rect;e.AlphaImage.copy(n.bitmap,s,{x:0,y:0},{x:a.x+1,y:a.y+1},n.bitmap);}}this.image=s, this.positions=o;}}e.register("GlyphAtlas",r);class n{constructor(t){this.tileID=new e.OverscaledTileID(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y), this.uid=t.uid, this.zoom=t.zoom, this.pixelRatio=t.pixelRatio, this.tileSize=t.tileSize, this.source=t.source, this.overscaling=this.tileID.overscaleFactor(), this.showCollisionBoxes=t.showCollisionBoxes, this.collectResourceTiming=!!t.collectResourceTiming, this.returnDependencies=!!t.returnDependencies, this.promoteId=t.promoteId;}parse(t,o,i,n,a){this.status="parsing", this.data=t, this.collisionBoxArray=new e.CollisionBoxArray;const l=new e.DictionaryCoder(Object.keys(t.layers).sort()),c=new e.FeatureIndex(this.tileID,this.promoteId);c.bucketLayerIDs=[];const u={},h={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:i},p=o.familiesBySource[this.source];for(const o in p){const r=t.layers[o];if(!r)continue;1===r.version&&e.warnOnce(`Vector tile source "${this.source}" layer "${o}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const n=l.encode(o),a=[];for(let e=0;e<r.length;e++){const t=r.feature(e),i=c.getId(t,o);a.push({feature:t,id:i,index:e,sourceLayerIndex:n});}for(const t of p[o]){const o=t[0];o.source!==this.source&&e.warnOnce(`layer.source = ${o.source} does not equal this.source = ${this.source}`), o.minzoom&&this.zoom<Math.floor(o.minzoom)||o.maxzoom&&this.zoom>=o.maxzoom||"none"!==o.visibility&&(s(t,this.zoom,i), (u[o.id]=o.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:n,sourceID:this.source})).populate(a,h,this.tileID.canonical), c.bucketLayerIDs.push(t.map((e=>e.id))));}}let f,d,g,m;const y=e.mapObject(h.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(y).length?n.send("getGlyphs",{uid:this.uid,stacks:y},((e,t)=>{f||(f=e, d=t, w.call(this));})):d={};const v=Object.keys(h.iconDependencies);v.length?n.send("getImages",{icons:v,source:this.source,tileID:this.tileID,type:"icons"},((e,t)=>{f||(f=e, g=t, w.call(this));})):g={};const x=Object.keys(h.patternDependencies);function w(){if(f)return a(f);if(d&&g&&m){const t=new r(d),o=new e.ImageAtlas(g,m);for(const r in u){const n=u[r];n instanceof e.SymbolBucket?(s(n.layers,this.zoom,i), e.performSymbolLayout({bucket:n,glyphMap:d,glyphPositions:t.positions,imageMap:g,imagePositions:o.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical})):n.hasPattern&&(n instanceof e.LineBucket||n instanceof e.FillBucket||n instanceof e.FillExtrusionBucket)&&(s(n.layers,this.zoom,i), n.addFeatures(h,this.tileID.canonical,o.patternPositions));}this.status="done", a(null,{buckets:Object.values(u).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,imageAtlas:o,glyphMap:this.returnDependencies?d:null,iconMap:this.returnDependencies?g:null,glyphPositions:this.returnDependencies?t.positions:null});}}x.length?n.send("getImages",{icons:x,source:this.source,tileID:this.tileID,type:"patterns"},((e,t)=>{f||(f=e, m=t, w.call(this));})):m={}, w.call(this);}}function s(t,o,i){const r=new e.EvaluationParameters(o);for(const e of t)e.recalculate(r,i);}function a(t,o){const i=e.getArrayBuffer(t.request,((t,i,r,n)=>{t?o(t):i&&o(null,{vectorTile:new e.vectorTile.VectorTile(new e.pbf(i)),rawData:i,cacheControl:r,expires:n});}));return ()=>{i.cancel(), o();}}class l{constructor(e,t,o,i){this.actor=e, this.layerIndex=t, this.availableImages=o, this.loadVectorData=i||a, this.loading={}, this.loaded={};}loadTile(t,o){const i=t.uid;this.loading||(this.loading={});const r=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.RequestPerformance(t.request),s=this.loading[i]=new n(t);s.abort=this.loadVectorData(t,((t,n)=>{if(delete this.loading[i], t||!n)return s.status="done", this.loaded[i]=s, o(t);const a=n.rawData,l={};n.expires&&(l.expires=n.expires), n.cacheControl&&(l.cacheControl=n.cacheControl);const c={};if(r){const e=r.finish();e&&(c.resourceTiming=JSON.parse(JSON.stringify(e)));}s.vectorTile=n.vectorTile, s.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,((t,i)=>{if(t||!i)return o(t);o(null,e.extend({rawTileData:a.slice(0)},i,l,c));})), this.loaded=this.loaded||{}, this.loaded[i]=s;}));}reloadTile(e,t){const o=this.loaded,i=e.uid,r=this;if(o&&o[i]){const n=o[i];n.showCollisionBoxes=e.showCollisionBoxes;const s=(e,o)=>{const i=n.reloadCallback;i&&(delete n.reloadCallback, n.parse(n.vectorTile,r.layerIndex,this.availableImages,r.actor,i)), t(e,o);};"parsing"===n.status?n.reloadCallback=s:"done"===n.status&&(n.vectorTile?n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,s):s());}}abortTile(e,t){const o=this.loading,i=e.uid;o&&o[i]&&o[i].abort&&(o[i].abort(), delete o[i]), t();}removeTile(e,t){const o=this.loaded,i=e.uid;o&&o[i]&&delete o[i], t();}}class c{constructor(){this.loaded={};}loadTile(t,o){const{uid:i,encoding:r,rawImageData:n}=t,s=e.isImageBitmap(n)?this.getImageData(n):n,a=new e.DEMData(i,s,r);this.loaded=this.loaded||{}, this.loaded[i]=a, o(null,a);}getImageData(t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(t.width,t.height), this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d")), this.offscreenCanvas.width=t.width, this.offscreenCanvas.height=t.height, this.offscreenCanvasContext.drawImage(t,0,0,t.width,t.height);const o=this.offscreenCanvasContext.getImageData(-1,-1,t.width+2,t.height+2);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height), new e.RGBAImage({width:o.width,height:o.height},o.data)}removeTile(e){const t=this.loaded,o=e.uid;t&&t[o]&&delete t[o];}}var u=function e(t,o){var i,r=t&&t.type;if("FeatureCollection"===r)for(i=0;i<t.features.length;i++)e(t.features[i],o);else if("GeometryCollection"===r)for(i=0;i<t.geometries.length;i++)e(t.geometries[i],o);else if("Feature"===r)e(t.geometry,o);else if("Polygon"===r)h(t.coordinates,o);else if("MultiPolygon"===r)for(i=0;i<t.coordinates.length;i++)h(t.coordinates[i],o);return t};function h(e,t){if(0!==e.length){p(e[0],t);for(var o=1;o<e.length;o++)p(e[o],!t);}}function p(e,t){for(var o=0,i=0,r=0,n=e.length,s=n-1;r<n;s=r++){var a=(e[r][0]-e[s][0])*(e[s][1]+e[r][1]),l=o+a;i+=Math.abs(o)>=Math.abs(a)?o-l+a:a-l+o, o=l;}o+i>=0!=!!t&&e.reverse();}const f=e.vectorTile.VectorTileFeature.prototype.toGeoJSON;class d{constructor(t){this._feature=t, this.extent=e.EXTENT, this.type=t.type, this.properties=t.tags, "id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const o of this._feature.geometry)t.push([new e.pointGeometry(o[0],o[1])]);return t}{const t=[];for(const o of this._feature.geometry){const i=[];for(const t of o)i.push(new e.pointGeometry(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,o){return f.call(this,e,t,o)}}class g{constructor(t){this.layers={_geojsonTileLayer:this}, this.name="_geojsonTileLayer", this.extent=e.EXTENT, this.length=t.length, this._features=t;}feature(e){return new d(this._features[e])}}var m={exports:{}},y=e.pointGeometry,v=e.vectorTile.VectorTileFeature,x=w;function w(e,t){this.options=t||{}, this.features=e, this.length=e.length;}function S(e,t){this.id="number"==typeof e.id?e.id:void 0, this.type=e.type, this.rawGeometry=1===e.type?[e.geometry]:e.geometry, this.properties=e.tags, this.extent=t||4096;}w.prototype.feature=function(e){return new S(this.features[e],this.options.extent)}, S.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var t=0;t<e.length;t++){for(var o=e[t],i=[],r=0;r<o.length;r++)i.push(new y(o[r][0],o[r][1]));this.geometry.push(i);}return this.geometry}, S.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,o=-1/0,i=1/0,r=-1/0,n=0;n<e.length;n++)for(var s=e[n],a=0;a<s.length;a++){var l=s[a];t=Math.min(t,l.x), o=Math.max(o,l.x), i=Math.min(i,l.y), r=Math.max(r,l.y);}return [t,i,o,r]}, S.prototype.toGeoJSON=v.prototype.toGeoJSON;var M=e.pbf,I=x;function b(e){var t=new M;return function(e,t){for(var o in e.layers)t.writeMessage(3,k,e.layers[o]);}(e,t), t.finish()}function k(e,t){var o;t.writeVarintField(15,e.version||1), t.writeStringField(1,e.name||""), t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(o=0;o<e.length;o++)i.feature=e.feature(o), t.writeMessage(2,P,i);var r=i.keys;for(o=0;o<r.length;o++)t.writeStringField(3,r[o]);var n=i.values;for(o=0;o<n.length;o++)t.writeMessage(4,L,n[o]);}function P(e,t){var o=e.feature;void 0!==o.id&&t.writeVarintField(1,o.id), t.writeMessage(2,T,e), t.writeVarintField(3,o.type), t.writeMessage(4,D,o);}function T(e,t){var o=e.feature,i=e.keys,r=e.values,n=e.keycache,s=e.valuecache;for(var a in o.properties){var l=o.properties[a],c=n[a];if(null!==l){void 0===c&&(i.push(a), n[a]=c=i.length-1), t.writeVarint(c);var u=typeof l;"string"!==u&&"boolean"!==u&&"number"!==u&&(l=JSON.stringify(l));var h=u+":"+l,p=s[h];void 0===p&&(r.push(l), s[h]=p=r.length-1), t.writeVarint(p);}}}function C(e,t){return (t<<3)+(7&e)}function _(e){return e<<1^e>>31}function D(e,t){for(var o=e.loadGeometry(),i=e.type,r=0,n=0,s=o.length,a=0;a<s;a++){var l=o[a],c=1;1===i&&(c=l.length), t.writeVarint(C(1,c));for(var u=3===i?l.length-1:l.length,h=0;h<u;h++){1===h&&1!==i&&t.writeVarint(C(2,u-1));var p=l[h].x-r,f=l[h].y-n;t.writeVarint(_(p)), t.writeVarint(_(f)), r+=p, n+=f;}3===i&&t.writeVarint(C(7,1));}}function L(e,t){var o=typeof e;"string"===o?t.writeStringField(1,e):"boolean"===o?t.writeBooleanField(7,e):"number"===o&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}function z(e,t,o,i,r,n){if(r-i<=o)return;const s=i+r>>1;O(e,t,s,i,r,n%2), z(e,t,o,i,s-1,n+1), z(e,t,o,s+1,r,n+1);}function O(e,t,o,i,r,n){for(;r>i;){if(r-i>600){const s=r-i+1,a=o-i+1,l=Math.log(s),c=.5*Math.exp(2*l/3),u=.5*Math.sqrt(l*c*(s-c)/s)*(a-s/2<0?-1:1);O(e,t,o,Math.max(i,Math.floor(o-a*c/s+u)),Math.min(r,Math.floor(o+(s-a)*c/s+u)),n);}const s=t[2*o+n];let a=i,l=r;for(E(e,t,i,o), t[2*r+n]>s&&E(e,t,i,r);a<l;){for(E(e,t,a,l), a++, l--;t[2*a+n]<s;)a++;for(;t[2*l+n]>s;)l--;}t[2*i+n]===s?E(e,t,i,l):(l++, E(e,t,l,r)), l<=o&&(i=l+1), o<=l&&(r=l-1);}}function E(e,t,o,i){F(e,o,i), F(t,2*o,2*i), F(t,2*o+1,2*i+1);}function F(e,t,o){const i=e[t];e[t]=e[o], e[o]=i;}function N(e,t,o,i){const r=e-o,n=t-i;return r*r+n*n}m.exports=b, m.exports.fromVectorTileJs=b, m.exports.fromGeojsonVt=function(e,t){t=t||{};var o={};for(var i in e)o[i]=new I(e[i].features,t), o[i].name=i, o[i].version=t.version, o[i].extent=t.extent;return b({layers:o})}, m.exports.GeoJSONWrapper=I;const A=e=>e[0],B=e=>e[1];class J{constructor(e,t=A,o=B,i=64,r=Float64Array){this.nodeSize=i, this.points=e;const n=e.length<65536?Uint16Array:Uint32Array,s=this.ids=new n(e.length),a=this.coords=new r(2*e.length);for(let i=0;i<e.length;i++)s[i]=i, a[2*i]=t(e[i]), a[2*i+1]=o(e[i]);z(s,a,i,0,s.length-1,0);}range(e,t,o,i){return function(e,t,o,i,r,n,s){const a=[0,e.length-1,0],l=[];let c,u;for(;a.length;){const h=a.pop(),p=a.pop(),f=a.pop();if(p-f<=s){for(let s=f;s<=p;s++)c=t[2*s], u=t[2*s+1], c>=o&&c<=r&&u>=i&&u<=n&&l.push(e[s]);continue}const d=Math.floor((f+p)/2);c=t[2*d], u=t[2*d+1], c>=o&&c<=r&&u>=i&&u<=n&&l.push(e[d]);const g=(h+1)%2;(0===h?o<=c:i<=u)&&(a.push(f), a.push(d-1), a.push(g)), (0===h?r>=c:n>=u)&&(a.push(d+1), a.push(p), a.push(g));}return l}(this.ids,this.coords,e,t,o,i,this.nodeSize)}within(e,t,o){return function(e,t,o,i,r,n){const s=[0,e.length-1,0],a=[],l=r*r;for(;s.length;){const c=s.pop(),u=s.pop(),h=s.pop();if(u-h<=n){for(let r=h;r<=u;r++)N(t[2*r],t[2*r+1],o,i)<=l&&a.push(e[r]);continue}const p=Math.floor((h+u)/2),f=t[2*p],d=t[2*p+1];N(f,d,o,i)<=l&&a.push(e[p]);const g=(c+1)%2;(0===c?o-r<=f:i-r<=d)&&(s.push(h), s.push(p-1), s.push(g)), (0===c?o+r>=f:i+r>=d)&&(s.push(p+1), s.push(u), s.push(g));}return a}(this.ids,this.coords,e,t,o,this.nodeSize)}}const Z={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},G=Math.fround||(j=new Float32Array(1), e=>(j[0]=+e, j[0]));var j;class Y{constructor(e){this.options=H(Object.create(Z),e), this.trees=new Array(this.options.maxZoom+1);}load(e){const{log:t,minZoom:o,maxZoom:i,nodeSize:r}=this.options;t&&console.time("total time");const n=`prepare ${e.length} points`;t&&console.time(n), this.points=e;let s=[];for(let t=0;t<e.length;t++)e[t].geometry&&s.push(X(e[t],t));this.trees[i+1]=new J(s,K,Q,r,Float32Array), t&&console.timeEnd(n);for(let e=i;e>=o;e--){const o=+Date.now();s=this._cluster(s,e), this.trees[e]=new J(s,K,Q,r,Float32Array), t&&console.log("z%d: %d clusters in %dms",e,s.length,+Date.now()-o);}return t&&console.timeEnd("total time"), this}getClusters(e,t){let o=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let r=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)o=-180, r=180;else if(o>r){const e=this.getClusters([o,i,180,n],t),s=this.getClusters([-180,i,r,n],t);return e.concat(s)}const s=this.trees[this._limitZoom(t)],a=s.range($(o),q(n),$(r),q(i)),l=[];for(const e of a){const t=s.points[e];l.push(t.numPoints?R(t):this.points[t.index]);}return l}getChildren(e){const t=this._getOriginId(e),o=this._getOriginZoom(e),i="No cluster with the specified id.",r=this.trees[o];if(!r)throw new Error(i);const n=r.points[t];if(!n)throw new Error(i);const s=this.options.radius/(this.options.extent*Math.pow(2,o-1)),a=r.within(n.x,n.y,s),l=[];for(const t of a){const o=r.points[t];o.parentId===e&&l.push(o.numPoints?R(o):this.points[o.index]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,o){const i=[];return this._appendLeaves(i,e,t=t||10,o=o||0,0), i}getTile(e,t,o){const i=this.trees[this._limitZoom(e)],r=Math.pow(2,e),{extent:n,radius:s}=this.options,a=s/n,l=(o-a)/r,c=(o+1+a)/r,u={features:[]};return this._addTileFeatures(i.range((t-a)/r,l,(t+1+a)/r,c),i.points,t,o,r,u), 0===t&&this._addTileFeatures(i.range(1-a/r,l,1,c),i.points,r,o,r,u), t===r-1&&this._addTileFeatures(i.range(0,l,a/r,c),i.points,-1,o,r,u), u.features.length?u:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const o=this.getChildren(e);if(t++, 1!==o.length)break;e=o[0].properties.cluster_id;}return t}_appendLeaves(e,t,o,i,r){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?r+n.point_count<=i?r+=n.point_count:r=this._appendLeaves(e,n.cluster_id,o,i,r):r<i?r++:e.push(t), e.length===o)break}return r}_addTileFeatures(e,t,o,i,r,n){for(const s of e){const e=t[s],a=e.numPoints;let l,c,u;if(a)l=W(e), c=e.x, u=e.y;else {const t=this.points[e.index];l=t.properties, c=$(t.geometry.coordinates[0]), u=q(t.geometry.coordinates[1]);}const h={type:1,geometry:[[Math.round(this.options.extent*(c*r-o)),Math.round(this.options.extent*(u*r-i))]],tags:l};let p;a?p=e.id:this.options.generateId?p=e.index:this.points[e.index].id&&(p=this.points[e.index].id), void 0!==p&&(h.id=p), n.features.push(h);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const o=[],{radius:i,extent:r,reduce:n,minPoints:s}=this.options,a=i/(r*Math.pow(2,t));for(let i=0;i<e.length;i++){const r=e[i];if(r.zoom<=t)continue;r.zoom=t;const l=this.trees[t+1],c=l.within(r.x,r.y,a),u=r.numPoints||1;let h=u;for(const e of c){const o=l.points[e];o.zoom>t&&(h+=o.numPoints||1);}if(h>u&&h>=s){let e=r.x*u,s=r.y*u,a=n&&u>1?this._map(r,!0):null;const p=(i<<5)+(t+1)+this.points.length;for(const o of c){const i=l.points[o];if(i.zoom<=t)continue;i.zoom=t;const c=i.numPoints||1;e+=i.x*c, s+=i.y*c, i.parentId=p, n&&(a||(a=this._map(r,!0)), n(a,this._map(i)));}r.parentId=p, o.push(V(e/h,s/h,p,h,a));}else if(o.push(r), h>1)for(const e of c){const i=l.points[e];i.zoom<=t||(i.zoom=t, o.push(i));}}return o}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t){if(e.numPoints)return t?H({},e.properties):e.properties;const o=this.points[e.index].properties,i=this.options.map(o);return t&&i===o?H({},i):i}}function V(e,t,o,i,r){return {x:G(e),y:G(t),zoom:1/0,id:o,parentId:-1,numPoints:i,properties:r}}function X(e,t){const[o,i]=e.geometry.coordinates;return {x:G($(o)),y:G(q(i)),zoom:1/0,index:t,parentId:-1}}function R(e){return {type:"Feature",id:e.id,properties:W(e),geometry:{type:"Point",coordinates:[(t=e.x, 360*(t-.5)),U(e.y)]}};var t;}function W(e){const t=e.numPoints,o=t>=1e4?`${Math.round(t/1e3)}k`:t>=1e3?Math.round(t/100)/10+"k":t;return H(H({},e.properties),{cluster:!0,cluster_id:e.id,point_count:t,point_count_abbreviated:o})}function $(e){return e/360+.5}function q(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function U(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function H(e,t){for(const o in t)e[o]=t[o];return e}function K(e){return e.x}function Q(e){return e.y}function ee(e,t,o,i){for(var r,n=i,s=o-t>>1,a=o-t,l=e[t],c=e[t+1],u=e[o],h=e[o+1],p=t+3;p<o;p+=3){var f=te(e[p],e[p+1],l,c,u,h);if(f>n)r=p, n=f;else if(f===n){var d=Math.abs(p-s);d<a&&(r=p, a=d);}}n>i&&(r-t>3&&ee(e,t,r,i), e[r+2]=n, o-r>3&&ee(e,r,o,i));}function te(e,t,o,i,r,n){var s=r-o,a=n-i;if(0!==s||0!==a){var l=((e-o)*s+(t-i)*a)/(s*s+a*a);l>1?(o=r, i=n):l>0&&(o+=s*l, i+=a*l);}return (s=e-o)*s+(a=t-i)*a}function oe(e,t,o,i){var r={id:void 0===e?null:e,type:t,geometry:o,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,o=e.type;if("Point"===o||"MultiPoint"===o||"LineString"===o)ie(e,t);else if("Polygon"===o||"MultiLineString"===o)for(var i=0;i<t.length;i++)ie(e,t[i]);else if("MultiPolygon"===o)for(i=0;i<t.length;i++)for(var r=0;r<t[i].length;r++)ie(e,t[i][r]);}(r), r}function ie(e,t){for(var o=0;o<t.length;o+=3)e.minX=Math.min(e.minX,t[o]), e.minY=Math.min(e.minY,t[o+1]), e.maxX=Math.max(e.maxX,t[o]), e.maxY=Math.max(e.maxY,t[o+1]);}function re(e,t,o,i){if(t.geometry){var r=t.geometry.coordinates,n=t.geometry.type,s=Math.pow(o.tolerance/((1<<o.maxZoom)*o.extent),2),a=[],l=t.id;if(o.promoteId?l=t.properties[o.promoteId]:o.generateId&&(l=i||0), "Point"===n)ne(r,a);else if("MultiPoint"===n)for(var c=0;c<r.length;c++)ne(r[c],a);else if("LineString"===n)se(r,a,s,!1);else if("MultiLineString"===n){if(o.lineMetrics){for(c=0;c<r.length;c++)se(r[c],a=[],s,!1), e.push(oe(l,"LineString",a,t.properties));return}ae(r,a,s,!1);}else if("Polygon"===n)ae(r,a,s,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(c=0;c<t.geometry.geometries.length;c++)re(e,{id:l,geometry:t.geometry.geometries[c],properties:t.properties},o,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(c=0;c<r.length;c++){var u=[];ae(r[c],u,s,!0), a.push(u);}}e.push(oe(l,n,a,t.properties));}}function ne(e,t){t.push(le(e[0])), t.push(ce(e[1])), t.push(0);}function se(e,t,o,i){for(var r,n,s=0,a=0;a<e.length;a++){var l=le(e[a][0]),c=ce(e[a][1]);t.push(l), t.push(c), t.push(0), a>0&&(s+=i?(r*c-l*n)/2:Math.sqrt(Math.pow(l-r,2)+Math.pow(c-n,2))), r=l, n=c;}var u=t.length-3;t[2]=1, ee(t,0,u,o), t[u+2]=1, t.size=Math.abs(s), t.start=0, t.end=t.size;}function ae(e,t,o,i){for(var r=0;r<e.length;r++){var n=[];se(e[r],n,o,i), t.push(n);}}function le(e){return e/360+.5}function ce(e){var t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function ue(e,t,o,i,r,n,s,a){if(i/=t, n>=(o/=t)&&s<i)return e;if(s<o||n>=i)return null;for(var l=[],c=0;c<e.length;c++){var u=e[c],h=u.geometry,p=u.type,f=0===r?u.minX:u.minY,d=0===r?u.maxX:u.maxY;if(f>=o&&d<i)l.push(u);else if(!(d<o||f>=i)){var g=[];if("Point"===p||"MultiPoint"===p)he(h,g,o,i,r);else if("LineString"===p)pe(h,g,o,i,r,!1,a.lineMetrics);else if("MultiLineString"===p)de(h,g,o,i,r,!1);else if("Polygon"===p)de(h,g,o,i,r,!0);else if("MultiPolygon"===p)for(var m=0;m<h.length;m++){var y=[];de(h[m],y,o,i,r,!0), y.length&&g.push(y);}if(g.length){if(a.lineMetrics&&"LineString"===p){for(m=0;m<g.length;m++)l.push(oe(u.id,p,g[m],u.tags));continue}"LineString"!==p&&"MultiLineString"!==p||(1===g.length?(p="LineString", g=g[0]):p="MultiLineString"), "Point"!==p&&"MultiPoint"!==p||(p=3===g.length?"Point":"MultiPoint"), l.push(oe(u.id,p,g,u.tags));}}}return l.length?l:null}function he(e,t,o,i,r){for(var n=0;n<e.length;n+=3){var s=e[n+r];s>=o&&s<=i&&(t.push(e[n]), t.push(e[n+1]), t.push(e[n+2]));}}function pe(e,t,o,i,r,n,s){for(var a,l,c=fe(e),u=0===r?me:ye,h=e.start,p=0;p<e.length-3;p+=3){var f=e[p],d=e[p+1],g=e[p+2],m=e[p+3],y=e[p+4],v=0===r?f:d,x=0===r?m:y,w=!1;s&&(a=Math.sqrt(Math.pow(f-m,2)+Math.pow(d-y,2))), v<o?x>o&&(l=u(c,f,d,m,y,o), s&&(c.start=h+a*l)):v>i?x<i&&(l=u(c,f,d,m,y,i), s&&(c.start=h+a*l)):ge(c,f,d,g), x<o&&v>=o&&(l=u(c,f,d,m,y,o), w=!0), x>i&&v<=i&&(l=u(c,f,d,m,y,i), w=!0), !n&&w&&(s&&(c.end=h+a*l), t.push(c), c=fe(e)), s&&(h+=a);}var S=e.length-3;f=e[S], d=e[S+1], g=e[S+2], (v=0===r?f:d)>=o&&v<=i&&ge(c,f,d,g), S=c.length-3, n&&S>=3&&(c[S]!==c[0]||c[S+1]!==c[1])&&ge(c,c[0],c[1],c[2]), c.length&&t.push(c);}function fe(e){var t=[];return t.size=e.size, t.start=e.start, t.end=e.end, t}function de(e,t,o,i,r,n){for(var s=0;s<e.length;s++)pe(e[s],t,o,i,r,n,!1);}function ge(e,t,o,i){e.push(t), e.push(o), e.push(i);}function me(e,t,o,i,r,n){var s=(n-t)/(i-t);return e.push(n), e.push(o+(r-o)*s), e.push(1), s}function ye(e,t,o,i,r,n){var s=(n-o)/(r-o);return e.push(t+(i-t)*s), e.push(n), e.push(1), s}function ve(e,t){for(var o=[],i=0;i<e.length;i++){var r,n=e[i],s=n.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)r=xe(n.geometry,t);else if("MultiLineString"===s||"Polygon"===s){r=[];for(var a=0;a<n.geometry.length;a++)r.push(xe(n.geometry[a],t));}else if("MultiPolygon"===s)for(r=[], a=0;a<n.geometry.length;a++){for(var l=[],c=0;c<n.geometry[a].length;c++)l.push(xe(n.geometry[a][c],t));r.push(l);}o.push(oe(n.id,s,r,n.tags));}return o}function xe(e,t){var o=[];o.size=e.size, void 0!==e.start&&(o.start=e.start, o.end=e.end);for(var i=0;i<e.length;i+=3)o.push(e[i]+t,e[i+1],e[i+2]);return o}function we(e,t){if(e.transformed)return e;var o,i,r,n=1<<e.z,s=e.x,a=e.y;for(o=0;o<e.features.length;o++){var l=e.features[o],c=l.geometry,u=l.type;if(l.geometry=[], 1===u)for(i=0;i<c.length;i+=2)l.geometry.push(Se(c[i],c[i+1],t,n,s,a));else for(i=0;i<c.length;i++){var h=[];for(r=0;r<c[i].length;r+=2)h.push(Se(c[i][r],c[i][r+1],t,n,s,a));l.geometry.push(h);}}return e.transformed=!0, e}function Se(e,t,o,i,r,n){return [Math.round(o*(e*i-r)),Math.round(o*(t*i-n))]}function Me(e,t,o,i,r){for(var n=t===r.maxZoom?0:r.tolerance/((1<<t)*r.extent),s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:o,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){s.numFeatures++, Ie(s,e[a],n,r);var l=e[a].minX,c=e[a].minY,u=e[a].maxX,h=e[a].maxY;l<s.minX&&(s.minX=l), c<s.minY&&(s.minY=c), u>s.maxX&&(s.maxX=u), h>s.maxY&&(s.maxY=h);}return s}function Ie(e,t,o,i){var r=t.geometry,n=t.type,s=[];if("Point"===n||"MultiPoint"===n)for(var a=0;a<r.length;a+=3)s.push(r[a]), s.push(r[a+1]), e.numPoints++, e.numSimplified++;else if("LineString"===n)be(s,r,e,o,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(a=0;a<r.length;a++)be(s,r[a],e,o,"Polygon"===n,0===a);else if("MultiPolygon"===n)for(var l=0;l<r.length;l++){var c=r[l];for(a=0;a<c.length;a++)be(s,c[a],e,o,!0,0===a);}if(s.length){var u=t.tags||null;if("LineString"===n&&i.lineMetrics){for(var h in (u={}, t.tags))u[h]=t.tags[h];u.mapbox_clip_start=r.start/r.size, u.mapbox_clip_end=r.end/r.size;}var p={geometry:s,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:u};null!==t.id&&(p.id=t.id), e.features.push(p);}}function be(e,t,o,i,r,n){var s=i*i;if(i>0&&t.size<(r?s:i))o.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===i||t[l+2]>s)&&(o.numSimplified++, a.push(t[l]), a.push(t[l+1])), o.numPoints++;r&&function(e,t){for(var o=0,i=0,r=e.length,n=r-2;i<r;n=i, i+=2)o+=(e[i]-e[n])*(e[i+1]+e[n+1]);if(o>0===t)for(i=0, r=e.length;i<r/2;i+=2){var s=e[i],a=e[i+1];e[i]=e[r-2-i], e[i+1]=e[r-1-i], e[r-2-i]=s, e[r-1-i]=a;}}(a,n), e.push(a);}}function ke(e,t){var o=(t=this.options=function(e,t){for(var o in t)e[o]=t[o];return e}(Object.create(this.options),t)).debug;if(o&&console.time("preprocess data"), t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var i=function(e,t){var o=[];if("FeatureCollection"===e.type)for(var i=0;i<e.features.length;i++)re(o,e.features[i],t,i);else re(o,"Feature"===e.type?e:{geometry:e},t);return o}(e,t);this.tiles={}, this.tileCoords=[], o&&(console.timeEnd("preprocess data"), console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints), console.time("generate tiles"), this.stats={}, this.total=0), i=function(e,t){var o=t.buffer/t.extent,i=e,r=ue(e,1,-1-o,o,0,-1,2,t),n=ue(e,1,1-o,2+o,0,-1,2,t);return (r||n)&&(i=ue(e,1,-o,1+o,0,-1,2,t)||[], r&&(i=ve(r,1).concat(i)), n&&(i=i.concat(ve(n,-1)))), i}(i,t), i.length&&this.splitTile(i,0,0,0), o&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints), console.timeEnd("generate tiles"), console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function Pe(e,t,o){return 32*((1<<e)*o+t)+e}function Te(e,t){const o=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const i=this._geoJSONIndex.getTile(o.z,o.x,o.y);if(!i)return t(null,null);const r=new g(i.features);let n=m.exports(r);0===n.byteOffset&&n.byteLength===n.buffer.byteLength||(n=new Uint8Array(n)), t(null,{vectorTile:r,rawData:n.buffer});}ke.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0}, ke.prototype.splitTile=function(e,t,o,i,r,n,s){for(var a=[e,t,o,i],l=this.options,c=l.debug;a.length;){i=a.pop(), o=a.pop(), t=a.pop(), e=a.pop();var u=1<<t,h=Pe(t,o,i),p=this.tiles[h];if(!p&&(c>1&&console.time("creation"), p=this.tiles[h]=Me(e,t,o,i,l), this.tileCoords.push({z:t,x:o,y:i}), c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,o,i,p.numFeatures,p.numPoints,p.numSimplified), console.timeEnd("creation"));var f="z"+t;this.stats[f]=(this.stats[f]||0)+1, this.total++;}if(p.source=e, r){if(t===l.maxZoom||t===r)continue;var d=1<<r-t;if(o!==Math.floor(n/d)||i!==Math.floor(s/d))continue}else if(t===l.indexMaxZoom||p.numPoints<=l.indexMaxPoints)continue;if(p.source=null, 0!==e.length){c>1&&console.time("clipping");var g,m,y,v,x,w,S=.5*l.buffer/l.extent,M=.5-S,I=.5+S,b=1+S;g=m=y=v=null, x=ue(e,u,o-S,o+I,0,p.minX,p.maxX,l), w=ue(e,u,o+M,o+b,0,p.minX,p.maxX,l), e=null, x&&(g=ue(x,u,i-S,i+I,1,p.minY,p.maxY,l), m=ue(x,u,i+M,i+b,1,p.minY,p.maxY,l), x=null), w&&(y=ue(w,u,i-S,i+I,1,p.minY,p.maxY,l), v=ue(w,u,i+M,i+b,1,p.minY,p.maxY,l), w=null), c>1&&console.timeEnd("clipping"), a.push(g||[],t+1,2*o,2*i), a.push(m||[],t+1,2*o,2*i+1), a.push(y||[],t+1,2*o+1,2*i), a.push(v||[],t+1,2*o+1,2*i+1);}}}, ke.prototype.getTile=function(e,t,o){var i=this.options,r=i.extent,n=i.debug;if(e<0||e>24)return null;var s=1<<e,a=Pe(e,t=(t%s+s)%s,o);if(this.tiles[a])return we(this.tiles[a],r);n>1&&console.log("drilling down to z%d-%d-%d",e,t,o);for(var l,c=e,u=t,h=o;!l&&c>0;)c--, u=Math.floor(u/2), h=Math.floor(h/2), l=this.tiles[Pe(c,u,h)];return l&&l.source?(n>1&&console.log("found parent tile z%d-%d-%d",c,u,h), n>1&&console.time("drilling down"), this.splitTile(l.source,c,u,h,e,t,o), n>1&&console.timeEnd("drilling down"), this.tiles[a]?we(this.tiles[a],r):null):null};class Ce extends l{constructor(e,t,o,i){super(e,t,o,Te), i&&(this.loadGeoJSON=i);}loadData(t,o){var i;null===(i=this._pendingRequest)||void 0===i||i.cancel(), this._pendingCallback&&this._pendingCallback(null,{abandoned:!0});const r=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.RequestPerformance(t.request);this._pendingCallback=o, this._pendingRequest=this.loadGeoJSON(t,((i,n)=>{if(delete this._pendingCallback, delete this._pendingRequest, i||!n)return o(i);if("object"!=typeof n)return o(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));{u(n,!0);try{if(t.filter){const o=e.createExpression(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===o.result)throw new Error(o.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const i=n.features.filter((e=>o.value.evaluate({zoom:0},e)));n={type:"FeatureCollection",features:i};}this._geoJSONIndex=t.cluster?new Y(function({superclusterOptions:t,clusterProperties:o}){if(!o||!t)return t;const i={},r={},n={accumulated:null,zoom:0},s={properties:null},a=Object.keys(o);for(const t of a){const[n,s]=o[t],a=e.createExpression(s),l=e.createExpression("string"==typeof n?[n,["accumulated"],["get",t]]:n);i[t]=a.value, r[t]=l.value;}return t.map=e=>{s.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(n,s);return t}, t.reduce=(e,t)=>{s.properties=t;for(const t of a)n.accumulated=e[t], e[t]=r[t].evaluate(n,s);}, t}(t)).load(n.features):function(e,t){return new ke(e,t)}(n,t.geojsonVtOptions);}catch(i){return o(i)}this.loaded={};const s={};if(r){const e=r.finish();e&&(s.resourceTiming={}, s.resourceTiming[t.source]=JSON.parse(JSON.stringify(e)));}o(null,s);}}));}reloadTile(e,t){const o=this.loaded;return o&&o[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,o){if(t.request)return e.getJSON(t.request,o);if("string"==typeof t.data)try{o(null,JSON.parse(t.data));}catch(e){o(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));}else o(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));return {cancel:()=>{}}}removeSource(e,t){this._pendingCallback&&this._pendingCallback(null,{abandoned:!0}), t();}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class _e{constructor(t){this.self=t, this.actor=new e.Actor(t,this), this.layerIndexes={}, this.availableImages={}, this.workerSourceTypes={vector:l,geojson:Ce}, this.workerSources={}, this.demWorkerSources={}, this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;}, this.self.registerRTLTextPlugin=t=>{if(e.plugin.isParsed())throw new Error("RTL text plugin already registered.");e.plugin.applyArabicShaping=t.applyArabicShaping, e.plugin.processBidirectionalText=t.processBidirectionalText, e.plugin.processStyledBidirectionalText=t.processStyledBidirectionalText;};}setReferrer(e,t){this.referrer=t;}setImages(e,t,o){this.availableImages[e]=t;for(const o in this.workerSources[e]){const i=this.workerSources[e][o];for(const e in i)i[e].availableImages=t;}o();}setLayers(e,t,o){this.getLayerIndex(e).replace(t), o();}updateLayers(e,t,o){this.getLayerIndex(e).update(t.layers,t.removedIds), o();}loadTile(e,t,o){this.getWorkerSource(e,t.type,t.source).loadTile(t,o);}loadDEMTile(e,t,o){this.getDEMWorkerSource(e,t.source).loadTile(t,o);}reloadTile(e,t,o){this.getWorkerSource(e,t.type,t.source).reloadTile(t,o);}abortTile(e,t,o){this.getWorkerSource(e,t.type,t.source).abortTile(t,o);}removeTile(e,t,o){this.getWorkerSource(e,t.type,t.source).removeTile(t,o);}removeDEMTile(e,t){this.getDEMWorkerSource(e,t.source).removeTile(t);}removeSource(e,t,o){if(!this.workerSources[e]||!this.workerSources[e][t.type]||!this.workerSources[e][t.type][t.source])return;const i=this.workerSources[e][t.type][t.source];delete this.workerSources[e][t.type][t.source], void 0!==i.removeSource?i.removeSource(t,o):o();}loadWorkerSource(e,t,o){try{this.self.importScripts(t.url), o();}catch(e){o(e.toString());}}syncRTLPluginState(t,o,i){try{e.plugin.setState(o);const t=e.plugin.getPluginURL();if(e.plugin.isLoaded()&&!e.plugin.isParsed()&&null!=t){this.self.importScripts(t);const o=e.plugin.isParsed();i(o?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),o);}}catch(e){i(e.toString());}}getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]), t}getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new i), t}getWorkerSource(e,t,o){if(this.workerSources[e]||(this.workerSources[e]={}), this.workerSources[e][t]||(this.workerSources[e][t]={}), !this.workerSources[e][t][o]){const i={send:(t,o,i)=>{this.actor.send(t,o,i,e);}};this.workerSources[e][t][o]=new this.workerSourceTypes[t](i,this.getLayerIndex(e),this.getAvailableImages(e));}return this.workerSources[e][t][o]}getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}), this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new c), this.demWorkerSources[e][t]}enforceCacheSizeLimit(t,o){e.enforceCacheSizeLimit(o);}}return e.isWorker()&&(self.worker=new _e(self)), _e})(sharedChunk);

/*  */