/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalDragon.dev",["Lexical"],(function $module_LexicalDragon_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';




function registerDragonSupport(editor){
var origin=window.location.origin;
var handler=function handler(event){
if(event.origin!==origin){
return;
}
var rootElement=editor.getRootElement();
if(document.activeElement!==rootElement){
return;
}
var data=event.data;
if(typeof data==='string'){
var parsedData;
try{
parsedData=JSON.parse(data);
}catch(e){
return;
}
if(parsedData&&parsedData.protocol==='nuanria_messaging'&&parsedData.type==='request'){
var payload=parsedData.payload;
if(payload&&payload.functionId==='makeChanges'){
var args=payload.args;
if(args){var
elementStart=args[0],elementLength=args[1],text=args[2],selStart=args[3],selLength=args[4],formatCommand=args[5];
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){
var anchor=selection.anchor;
var anchorNode=anchor.getNode();
var setSelStart=0;
var setSelEnd=0;
if(require("Lexical").$isTextNode(anchorNode)){

if(elementStart>=0&&elementLength>=0){
setSelStart=elementStart;
setSelEnd=elementStart+elementLength;

selection.setTextNodeRange(anchorNode,setSelStart,anchorNode,setSelEnd);
}
}
if(setSelStart!==setSelEnd||text!==''){
selection.insertRawText(text);
anchorNode=anchor.getNode();
}
if(require("Lexical").$isTextNode(anchorNode)){

setSelStart=selStart;
setSelEnd=selStart+selLength;
var anchorNodeTextLength=anchorNode.getTextContentSize();

setSelStart=setSelStart>anchorNodeTextLength?anchorNodeTextLength:setSelStart;
setSelEnd=setSelEnd>anchorNodeTextLength?anchorNodeTextLength:setSelEnd;
selection.setTextNodeRange(anchorNode,setSelStart,anchorNode,setSelEnd);
}


event.stopImmediatePropagation();
}
});
}
}
}
}
};
window.addEventListener('message',handler,true);
return function(){
window.removeEventListener('message',handler,true);
};
}

exports.registerDragonSupport=registerDragonSupport;}),null);