/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalRichText.dev",["Lexical","LexicalClipboard","LexicalSelection","LexicalUtils","regeneratorRuntime"],(function $module_LexicalRichText_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';














function caretFromPoint(x,y){
if(typeof document.caretRangeFromPoint!=='undefined'){
var range=document.caretRangeFromPoint(x,y);
if(range===null){
return null;
}
return{
node:range.startContainer,
offset:range.startOffset};


}else if(document.caretPositionFromPoint!=='undefined'){

var _range=document.caretPositionFromPoint(x,y);
if(_range===null){
return null;
}
return{
node:_range.offsetNode,
offset:_range.offset};

}else{

return null;
}
}









var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var documentMode=CAN_USE_DOM&&'documentMode'in document?document.documentMode:null;
CAN_USE_DOM&&/Mac|iPod|iPhone|iPad/.test(navigator.platform);
CAN_USE_DOM&&/^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);
var CAN_USE_BEFORE_INPUT=CAN_USE_DOM&&'InputEvent'in window&&!documentMode?'getTargetRanges'in new window.InputEvent('input'):false;
var IS_SAFARI=CAN_USE_DOM&&/Version\/[\d.]+.*Safari/.test(navigator.userAgent);
var IS_IOS=CAN_USE_DOM&&/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream;
CAN_USE_DOM&&/Android/.test(navigator.userAgent);



var IS_CHROME=CAN_USE_DOM&&/^(?=.*Chrome).*/i.test(navigator.userAgent);


var IS_APPLE_WEBKIT=CAN_USE_DOM&&/AppleWebKit\/[\d.]+/.test(navigator.userAgent)&&!IS_CHROME;


var DRAG_DROP_PASTE=require("Lexical").createCommand('DRAG_DROP_PASTE_FILE');var

QuoteNode=function(_Lexical$ElementNode){babelHelpers.inheritsLoose(QuoteNode,_Lexical$ElementNode);QuoteNode.
getType=function getType(){
return'quote';
};QuoteNode.
clone=function clone(node){
return new QuoteNode(node.__key);
};
function QuoteNode(key){return(
_Lexical$ElementNode.call(this,key)||this);
}var _proto=QuoteNode.prototype;_proto.



createDOM=function createDOM(config){
var element=document.createElement('blockquote');
require("LexicalUtils").addClassNamesToElement(element,config.theme.quote);
return element;
};_proto.
updateDOM=function updateDOM(prevNode,dom){
return false;
};QuoteNode.
importDOM=function importDOM(){
return{
blockquote:function blockquote(node){return{
conversion:convertBlockquoteElement,
priority:0};}};


};_proto.
exportDOM=function exportDOM(editor){var _Lexical$ElementNode$=_Lexical$ElementNode.prototype.


exportDOM.call(this,editor),element=_Lexical$ElementNode$.element;
if(element&&require("LexicalUtils").isHTMLElement(element)){
if(this.isEmpty())element.append(document.createElement('br'));
var formatType=this.getFormatType();
element.style.textAlign=formatType;
var direction=this.getDirection();
if(direction){
element.dir=direction;
}
}
return{
element:element};

};QuoteNode.
importJSON=function importJSON(serializedNode){
var node=$createQuoteNode();
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode.prototype.
exportJSON.call(this),{
type:'quote'});

};_proto.



insertNewAfter=function insertNewAfter(_,restoreSelection){
var newBlock=require("Lexical").$createParagraphNode();
var direction=this.getDirection();
newBlock.setDirection(direction);
this.insertAfter(newBlock,restoreSelection);
return newBlock;
};_proto.
collapseAtStart=function collapseAtStart(){
var paragraph=require("Lexical").$createParagraphNode();
var children=this.getChildren();
children.forEach(function(child){return paragraph.append(child);});
this.replace(paragraph);
return true;
};return QuoteNode;}(require("Lexical").ElementNode);

function $createQuoteNode(){
return require("Lexical").$applyNodeReplacement(new QuoteNode());
}
function $isQuoteNode(node){
return node instanceof QuoteNode;
}var

HeadingNode=function(_Lexical$ElementNode2){babelHelpers.inheritsLoose(HeadingNode,_Lexical$ElementNode2);HeadingNode.


getType=function getType(){
return'heading';
};HeadingNode.
clone=function clone(node){
return new HeadingNode(node.__tag,node.__key);
};
function HeadingNode(tag,key){var _this;
_this=_Lexical$ElementNode2.call(this,key)||this;
_this.__tag=tag;return _this;
}var _proto2=HeadingNode.prototype;_proto2.
getTag=function getTag(){
return this.__tag;
};_proto2.



createDOM=function createDOM(config){
var tag=this.__tag;
var element=document.createElement(tag);
var theme=config.theme;
var classNames=theme.heading;
if(classNames!==undefined){
var className=classNames[tag];
require("LexicalUtils").addClassNamesToElement(element,className);
}
return element;
};_proto2.
updateDOM=function updateDOM(prevNode,dom){
return false;
};HeadingNode.
importDOM=function importDOM(){
return{
h1:function h1(node){return{
conversion:convertHeadingElement,
priority:0};},

h2:function h2(node){return{
conversion:convertHeadingElement,
priority:0};},

h3:function h3(node){return{
conversion:convertHeadingElement,
priority:0};},

h4:function h4(node){return{
conversion:convertHeadingElement,
priority:0};},

h5:function h5(node){return{
conversion:convertHeadingElement,
priority:0};},

h6:function h6(node){return{
conversion:convertHeadingElement,
priority:0};},

p:function p(node){

var paragraph=node;
var firstChild=paragraph.firstChild;
if(firstChild!==null&&isGoogleDocsTitle(firstChild)){
return{
conversion:function conversion(){return{
node:null};},

priority:3};

}
return null;
},
span:function span(node){
if(isGoogleDocsTitle(node)){
return{
conversion:function conversion(domNode){
return{
node:$createHeadingNode('h1')};

},
priority:3};

}
return null;
}};

};_proto2.
exportDOM=function exportDOM(editor){var _Lexical$ElementNode3=_Lexical$ElementNode2.prototype.


exportDOM.call(this,editor),element=_Lexical$ElementNode3.element;
if(element&&require("LexicalUtils").isHTMLElement(element)){
if(this.isEmpty())element.append(document.createElement('br'));
var formatType=this.getFormatType();
element.style.textAlign=formatType;
var direction=this.getDirection();
if(direction){
element.dir=direction;
}
}
return{
element:element};

};HeadingNode.
importJSON=function importJSON(serializedNode){
var node=$createHeadingNode(serializedNode.tag);
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto2.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode2.prototype.
exportJSON.call(this),{
tag:this.getTag(),
type:'heading',
version:1});

};_proto2.


insertNewAfter=function insertNewAfter(selection,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var anchorOffet=selection?selection.anchor.offset:0;
var newElement=anchorOffet===this.getTextContentSize()||!selection?require("Lexical").$createParagraphNode():$createHeadingNode(this.getTag());
var direction=this.getDirection();
newElement.setDirection(direction);
this.insertAfter(newElement,restoreSelection);
if(anchorOffet===0&&!this.isEmpty()&&selection){
var paragraph=require("Lexical").$createParagraphNode();
paragraph.select();
this.replace(paragraph,true);
}
return newElement;
};_proto2.
collapseAtStart=function collapseAtStart(){
var newElement=!this.isEmpty()?$createHeadingNode(this.getTag()):require("Lexical").$createParagraphNode();
var children=this.getChildren();
children.forEach(function(child){return newElement.append(child);});
this.replace(newElement);
return true;
};_proto2.
extractWithChild=function extractWithChild(){
return true;
};return HeadingNode;}(require("Lexical").ElementNode);

function isGoogleDocsTitle(domNode){
if(domNode.nodeName.toLowerCase()==='span'){
return domNode.style.fontSize==='26pt';
}
return false;
}
function convertHeadingElement(element){
var nodeName=element.nodeName.toLowerCase();
var node=null;
if(nodeName==='h1'||nodeName==='h2'||nodeName==='h3'||nodeName==='h4'||nodeName==='h5'||nodeName==='h6'){
node=$createHeadingNode(nodeName);
if(element.style!==null){
node.setFormat(element.style.textAlign);
}
}
return{
node:node};

}
function convertBlockquoteElement(element){
var node=$createQuoteNode();
if(element.style!==null){
node.setFormat(element.style.textAlign);
}
return{
node:node};

}
function $createHeadingNode(headingTag){
return require("Lexical").$applyNodeReplacement(new HeadingNode(headingTag));
}
function $isHeadingNode(node){
return node instanceof HeadingNode;
}
function onPasteForRichText(event,editor){
event.preventDefault();
editor.update(function(){
var selection=require("Lexical").$getSelection();
var clipboardData=event instanceof InputEvent||event instanceof KeyboardEvent?null:event.clipboardData;
if(clipboardData!=null&&selection!==null){
require("LexicalClipboard").$insertDataTransferForRichText(clipboardData,selection,editor);
}
},{
tag:'paste'});

}
function onCutForRichText(event,editor){return require("regeneratorRuntime").async(function onCutForRichText$(_context){while(1){switch(_context.prev=_context.next){case 0:_context.next=2;return require("regeneratorRuntime").awrap(
require("LexicalClipboard").copyToClipboard(editor,require("LexicalUtils").objectKlassEquals(event,ClipboardEvent)?event:null));case 2:
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){
selection.removeText();
}else if(require("Lexical").$isNodeSelection(selection)){
selection.getNodes().forEach(function(node){return node.remove();});
}
});case 3:case"end":return _context.stop();}}},null,this);}





function eventFiles(event){
var dataTransfer=null;
if(event instanceof DragEvent){
dataTransfer=event.dataTransfer;
}else if(event instanceof ClipboardEvent){
dataTransfer=event.clipboardData;
}
if(dataTransfer===null){
return[false,[],false];
}
var types=dataTransfer.types;
var hasFiles=types.includes('Files');
var hasContent=types.includes('text/html')||types.includes('text/plain');
return[hasFiles,Array.from(dataTransfer.files),hasContent];
}
function handleIndentAndOutdent(indentOrOutdent){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var alreadyHandled=new Set();
var nodes=selection.getNodes();
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
var key=node.getKey();
if(alreadyHandled.has(key)){
continue;
}
var parentBlock=require("LexicalUtils").$getNearestBlockElementAncestorOrThrow(node);
var parentKey=parentBlock.getKey();
if(parentBlock.canIndent()&&!alreadyHandled.has(parentKey)){
alreadyHandled.add(parentKey);
indentOrOutdent(parentBlock);
}
}
return alreadyHandled.size>0;
}
function $isTargetWithinDecorator(target){
var node=require("Lexical").$getNearestNodeFromDOMNode(target);
return require("Lexical").$isDecoratorNode(node);
}
function $isSelectionAtEndOfRoot(selection){
var focus=selection.focus;
return focus.key==='root'&&focus.offset===require("Lexical").$getRoot().getChildrenSize();
}
function registerRichText(editor){var _require_Lexical;
var removeListener=require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).CLICK_COMMAND,function(payload){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)){
selection.clear();
return true;
}
return false;
},0),editor.registerCommand(_require_Lexical.DELETE_CHARACTER_COMMAND,function(isBackward){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.deleteCharacter(isBackward);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DELETE_WORD_COMMAND,function(isBackward){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.deleteWord(isBackward);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DELETE_LINE_COMMAND,function(isBackward){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.deleteLine(isBackward);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.CONTROLLED_TEXT_INSERTION_COMMAND,function(eventOrText){
var selection=require("Lexical").$getSelection();
if(typeof eventOrText==='string'){
if(selection!==null){
selection.insertText(eventOrText);
}
}else{
if(selection===null){
return false;
}
var dataTransfer=eventOrText.dataTransfer;
if(dataTransfer!=null){
require("LexicalClipboard").$insertDataTransferForRichText(dataTransfer,selection,editor);
}else if(require("Lexical").$isRangeSelection(selection)){
var data=eventOrText.data;
if(data){
selection.insertText(data);
}
return true;
}
}
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.REMOVE_TEXT_COMMAND,function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.removeText();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.FORMAT_TEXT_COMMAND,function(format){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.formatText(format);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.FORMAT_ELEMENT_COMMAND,function(format){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)&&!require("Lexical").$isNodeSelection(selection)){
return false;
}
var nodes=selection.getNodes();
for(var _iterator=nodes,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var node=_ref;
var element=require("LexicalUtils").$findMatchingParent(node,function(parentNode){return require("Lexical").$isElementNode(parentNode)&&!parentNode.isInline();});
if(element!==null){
element.setFormat(format);
}
}
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.INSERT_LINE_BREAK_COMMAND,function(selectStart){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.insertLineBreak(selectStart);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.INSERT_PARAGRAPH_COMMAND,function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
selection.insertParagraph();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.INSERT_TAB_COMMAND,function(){
require("Lexical").$insertNodes([require("Lexical").$createTabNode()]);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.INDENT_CONTENT_COMMAND,function(){
return handleIndentAndOutdent(function(block){
var indent=block.getIndent();
block.setIndent(indent+1);
});
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.OUTDENT_CONTENT_COMMAND,function(){
return handleIndentAndOutdent(function(block){
var indent=block.getIndent();
if(indent>0){
block.setIndent(indent-1);
}
});
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ARROW_UP_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)&&!$isTargetWithinDecorator(event.target)){


var nodes=selection.getNodes();
if(nodes.length>0){
nodes[0].selectPrevious();
return true;
}
}else if(require("Lexical").$isRangeSelection(selection)){
var possibleNode=require("Lexical").$getAdjacentNode(selection.focus,true);
if(!event.shiftKey&&require("Lexical").$isDecoratorNode(possibleNode)&&!possibleNode.isIsolated()&&!possibleNode.isInline()){
possibleNode.selectPrevious();
event.preventDefault();
return true;
}
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ARROW_DOWN_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)){


var nodes=selection.getNodes();
if(nodes.length>0){
nodes[0].selectNext(0,0);
return true;
}
}else if(require("Lexical").$isRangeSelection(selection)){
if($isSelectionAtEndOfRoot(selection)){
event.preventDefault();
return true;
}
var possibleNode=require("Lexical").$getAdjacentNode(selection.focus,false);
if(!event.shiftKey&&require("Lexical").$isDecoratorNode(possibleNode)&&!possibleNode.isIsolated()&&!possibleNode.isInline()){
possibleNode.selectNext();
event.preventDefault();
return true;
}
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ARROW_LEFT_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)){


var nodes=selection.getNodes();
if(nodes.length>0){
event.preventDefault();
nodes[0].selectPrevious();
return true;
}
}
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
if(require("LexicalSelection").$shouldOverrideDefaultCharacterSelection(selection,true)){
var isHoldingShift=event.shiftKey;
event.preventDefault();
require("LexicalSelection").$moveCharacter(selection,isHoldingShift,true);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ARROW_RIGHT_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isNodeSelection(selection)&&!$isTargetWithinDecorator(event.target)){


var nodes=selection.getNodes();
if(nodes.length>0){
event.preventDefault();
nodes[0].selectNext(0,0);
return true;
}
}
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var isHoldingShift=event.shiftKey;
if(require("LexicalSelection").$shouldOverrideDefaultCharacterSelection(selection,false)){
event.preventDefault();
require("LexicalSelection").$moveCharacter(selection,isHoldingShift,false);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_BACKSPACE_COMMAND,function(event){
if($isTargetWithinDecorator(event.target)){
return false;
}
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
event.preventDefault();var

anchor=
selection.anchor;
var anchorNode=anchor.getNode();
if(selection.isCollapsed()&&anchor.offset===0&&!require("Lexical").$isRootNode(anchorNode)){
var element=require("LexicalUtils").$getNearestBlockElementAncestorOrThrow(anchorNode);
if(element.getIndent()>0){
return editor.dispatchCommand(require("Lexical").OUTDENT_CONTENT_COMMAND,undefined);
}
}
return editor.dispatchCommand(require("Lexical").DELETE_CHARACTER_COMMAND,true);
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_DELETE_COMMAND,function(event){
if($isTargetWithinDecorator(event.target)){
return false;
}
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
event.preventDefault();
return editor.dispatchCommand(require("Lexical").DELETE_CHARACTER_COMMAND,false);
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ENTER_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
if(event!==null){







if((IS_IOS||IS_SAFARI||IS_APPLE_WEBKIT)&&CAN_USE_BEFORE_INPUT){
return false;
}
event.preventDefault();
if(event.shiftKey){
return editor.dispatchCommand(require("Lexical").INSERT_LINE_BREAK_COMMAND,false);
}
}
return editor.dispatchCommand(require("Lexical").INSERT_PARAGRAPH_COMMAND,undefined);
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.KEY_ESCAPE_COMMAND,function(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
editor.blur();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DROP_COMMAND,function(event){var _eventFiles=
eventFiles(event),files=_eventFiles[1];
if(files.length>0){
var x=event.clientX;
var y=event.clientY;
var eventRange=caretFromPoint(x,y);
if(eventRange!==null){var

domOffset=

eventRange.offset,domNode=eventRange.node;
var node=require("Lexical").$getNearestNodeFromDOMNode(domNode);
if(node!==null){
var _selection=require("Lexical").$createRangeSelection();
if(require("Lexical").$isTextNode(node)){
_selection.anchor.set(node.getKey(),domOffset,'text');
_selection.focus.set(node.getKey(),domOffset,'text');
}else{
var parentKey=node.getParentOrThrow().getKey();
var offset=node.getIndexWithinParent()+1;
_selection.anchor.set(parentKey,offset,'element');
_selection.focus.set(parentKey,offset,'element');
}
var normalizedSelection=require("Lexical").$normalizeSelection__EXPERIMENTAL(_selection);
require("Lexical").$setSelection(normalizedSelection);
}
editor.dispatchCommand(DRAG_DROP_PASTE,files);
}
event.preventDefault();
return true;
}
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DRAGSTART_COMMAND,function(event){var _eventFiles2=
eventFiles(event),isFileTransfer=_eventFiles2[0];
var selection=require("Lexical").$getSelection();
if(isFileTransfer&&!require("Lexical").$isRangeSelection(selection)){
return false;
}
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.DRAGOVER_COMMAND,function(event){var _eventFiles3=
eventFiles(event),isFileTransfer=_eventFiles3[0];
var selection=require("Lexical").$getSelection();
if(isFileTransfer&&!require("Lexical").$isRangeSelection(selection)){
return false;
}
var x=event.clientX;
var y=event.clientY;
var eventRange=caretFromPoint(x,y);
if(eventRange!==null){
var node=require("Lexical").$getNearestNodeFromDOMNode(eventRange.node);
if(require("Lexical").$isDecoratorNode(node)){


event.preventDefault();
}
}
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.SELECT_ALL_COMMAND,function(){
require("Lexical").$selectAll();
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.COPY_COMMAND,function(event){
require("LexicalClipboard").copyToClipboard(editor,require("LexicalUtils").objectKlassEquals(event,ClipboardEvent)?event:null);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.CUT_COMMAND,function(event){
onCutForRichText(event,editor);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.PASTE_COMMAND,function(event){var _eventFiles4=
eventFiles(event),files=_eventFiles4[1],hasTextContent=_eventFiles4[2];
if(files.length>0&&!hasTextContent){
editor.dispatchCommand(DRAG_DROP_PASTE,files);
return true;
}


if(require("Lexical").isSelectionCapturedInDecoratorInput(event.target)){
return false;
}
var selection=require("Lexical").$getSelection();
if(selection!==null){
onPasteForRichText(event,editor);
return true;
}
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR));
return removeListener;
}

exports.$createHeadingNode=$createHeadingNode;
exports.$createQuoteNode=$createQuoteNode;
exports.$isHeadingNode=$isHeadingNode;
exports.$isQuoteNode=$isQuoteNode;
exports.DRAG_DROP_PASTE=DRAG_DROP_PASTE;
exports.HeadingNode=HeadingNode;
exports.QuoteNode=QuoteNode;
exports.eventFiles=eventFiles;
exports.registerRichText=registerRichText;}),null);