/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalTable.dev",["Lexical","LexicalUtils"],(function $module_LexicalTable_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';












var PIXEL_VALUE_REG_EXP=/^(\d+(?:\.\d+)?)px$/;








var TableCellHeaderStates={
BOTH:3,
COLUMN:2,
NO_STATUS:0,
ROW:1};var


TableCellNode=function(_Lexical$ElementNode){babelHelpers.inheritsLoose(TableCellNode,_Lexical$ElementNode);TableCellNode.










getType=function getType(){
return'tablecell';
};TableCellNode.
clone=function clone(node){
var cellNode=new TableCellNode(node.__headerState,node.__colSpan,node.__width,node.__key);
cellNode.__rowSpan=node.__rowSpan;
cellNode.__backgroundColor=node.__backgroundColor;
return cellNode;
};TableCellNode.
importDOM=function importDOM(){
return{
td:function td(node){return{
conversion:convertTableCellNodeElement,
priority:0};},

th:function th(node){return{
conversion:convertTableCellNodeElement,
priority:0};}};


};TableCellNode.
importJSON=function importJSON(serializedNode){
var colSpan=serializedNode.colSpan||1;
var rowSpan=serializedNode.rowSpan||1;
var cellNode=$createTableCellNode(serializedNode.headerState,colSpan,serializedNode.width||undefined);
cellNode.__rowSpan=rowSpan;
cellNode.__backgroundColor=serializedNode.backgroundColor||null;
return cellNode;
};
function TableCellNode(headerState,colSpan,width,key){var _this;if(headerState===void 0){headerState=TableCellHeaderStates.NO_STATUS;}if(colSpan===void 0){colSpan=1;}
_this=_Lexical$ElementNode.call(this,key)||this;
_this.__colSpan=colSpan;
_this.__rowSpan=1;
_this.__headerState=headerState;
_this.__width=width;
_this.__backgroundColor=null;return _this;
}var _proto=TableCellNode.prototype;_proto.
createDOM=function createDOM(config){
var element=document.createElement(this.getTag());
if(this.__width){
element.style.width=this.__width+"px";
}
if(this.__colSpan>1){
element.colSpan=this.__colSpan;
}
if(this.__rowSpan>1){
element.rowSpan=this.__rowSpan;
}
if(this.__backgroundColor!==null){
element.style.backgroundColor=this.__backgroundColor;
}
require("LexicalUtils").addClassNamesToElement(element,config.theme.tableCell,this.hasHeader()&&config.theme.tableCellHeader);
return element;
};_proto.
exportDOM=function exportDOM(editor){var _Lexical$ElementNode$=_Lexical$ElementNode.prototype.


exportDOM.call(this,editor),element=_Lexical$ElementNode$.element;
if(element){
var element_=element;
var maxWidth=700;
var colCount=this.getParentOrThrow().getChildrenSize();
element_.style.border='1px solid black';
if(this.__colSpan>1){
element_.colSpan=this.__colSpan;
}
if(this.__rowSpan>1){
element_.rowSpan=this.__rowSpan;
}
element_.style.width=(this.getWidth()||Math.max(90,maxWidth/colCount))+"px";
element_.style.verticalAlign='top';
element_.style.textAlign='start';
var backgroundColor=this.getBackgroundColor();
if(backgroundColor!==null){
element_.style.backgroundColor=backgroundColor;
}else if(this.hasHeader()){
element_.style.backgroundColor='#f2f3f5';
}
}
return{
element:element};

};_proto.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode.prototype.
exportJSON.call(this),{
backgroundColor:this.getBackgroundColor(),
colSpan:this.__colSpan,
headerState:this.__headerState,
rowSpan:this.__rowSpan,
type:'tablecell',
width:this.getWidth()});

};_proto.
getColSpan=function getColSpan(){
return this.__colSpan;
};_proto.
setColSpan=function setColSpan(colSpan){
this.getWritable().__colSpan=colSpan;
return this;
};_proto.
getRowSpan=function getRowSpan(){
return this.__rowSpan;
};_proto.
setRowSpan=function setRowSpan(rowSpan){
this.getWritable().__rowSpan=rowSpan;
return this;
};_proto.
getTag=function getTag(){
return this.hasHeader()?'th':'td';
};_proto.
setHeaderStyles=function setHeaderStyles(headerState){
var self=this.getWritable();
self.__headerState=headerState;
return this.__headerState;
};_proto.
getHeaderStyles=function getHeaderStyles(){
return this.getLatest().__headerState;
};_proto.
setWidth=function setWidth(width){
var self=this.getWritable();
self.__width=width;
return this.__width;
};_proto.
getWidth=function getWidth(){
return this.getLatest().__width;
};_proto.
getBackgroundColor=function getBackgroundColor(){
return this.getLatest().__backgroundColor;
};_proto.
setBackgroundColor=function setBackgroundColor(newBackgroundColor){
this.getWritable().__backgroundColor=newBackgroundColor;
};_proto.
toggleHeaderStyle=function toggleHeaderStyle(headerStateToToggle){
var self=this.getWritable();
if((self.__headerState&headerStateToToggle)===headerStateToToggle){
self.__headerState-=headerStateToToggle;
}else{
self.__headerState+=headerStateToToggle;
}
return self;
};_proto.
hasHeaderState=function hasHeaderState(headerState){
return(this.getHeaderStyles()&headerState)===headerState;
};_proto.
hasHeader=function hasHeader(){
return this.getLatest().__headerState!==TableCellHeaderStates.NO_STATUS;
};_proto.
updateDOM=function updateDOM(prevNode){
return prevNode.__headerState!==this.__headerState||prevNode.__width!==this.__width||prevNode.__colSpan!==this.__colSpan||prevNode.__rowSpan!==this.__rowSpan||prevNode.__backgroundColor!==this.__backgroundColor;
};_proto.
isShadowRoot=function isShadowRoot(){
return true;
};_proto.
collapseAtStart=function collapseAtStart(){
return true;
};_proto.
canBeEmpty=function canBeEmpty(){
return false;
};_proto.
canIndent=function canIndent(){
return false;
};return TableCellNode;}(require("Lexical").ElementNode);

function convertTableCellNodeElement(domNode){
var domNode_=domNode;
var nodeName=domNode.nodeName.toLowerCase();
var width=undefined;
if(PIXEL_VALUE_REG_EXP.test(domNode_.style.width)){
width=parseFloat(domNode_.style.width);
}
var tableCellNode=$createTableCellNode(nodeName==='th'?TableCellHeaderStates.ROW:TableCellHeaderStates.NO_STATUS,domNode_.colSpan,width);
tableCellNode.__rowSpan=domNode_.rowSpan;
var backgroundColor=domNode_.style.backgroundColor;
if(backgroundColor!==''){
tableCellNode.__backgroundColor=backgroundColor;
}
return{
forChild:function forChild(lexicalNode,parentLexicalNode){
if($isTableCellNode(parentLexicalNode)&&!require("Lexical").$isElementNode(lexicalNode)){
var paragraphNode=require("Lexical").$createParagraphNode();
if(require("Lexical").$isLineBreakNode(lexicalNode)&&lexicalNode.getTextContent()==='\n'){
return null;
}
paragraphNode.append(lexicalNode);
return paragraphNode;
}
return lexicalNode;
},
node:tableCellNode};

}
function $createTableCellNode(headerState,colSpan,width){if(colSpan===void 0){colSpan=1;}
return require("Lexical").$applyNodeReplacement(new TableCellNode(headerState,colSpan,width));
}
function $isTableCellNode(node){
return node instanceof TableCellNode;
}








var INSERT_TABLE_COMMAND=require("Lexical").createCommand('INSERT_TABLE_COMMAND');var









TableRowNode=function(_Lexical$ElementNode2){babelHelpers.inheritsLoose(TableRowNode,_Lexical$ElementNode2);TableRowNode.


getType=function getType(){
return'tablerow';
};TableRowNode.
clone=function clone(node){
return new TableRowNode(node.__height,node.__key);
};TableRowNode.
importDOM=function importDOM(){
return{
tr:function tr(node){return{
conversion:convertTableRowElement,
priority:0};}};


};TableRowNode.
importJSON=function importJSON(serializedNode){
return $createTableRowNode(serializedNode.height);
};
function TableRowNode(height,key){var _this2;
_this2=_Lexical$ElementNode2.call(this,key)||this;
_this2.__height=height;return _this2;
}var _proto2=TableRowNode.prototype;_proto2.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode2.prototype.
exportJSON.call(this),{
type:'tablerow',
version:1});

};_proto2.
createDOM=function createDOM(config){
var element=document.createElement('tr');
if(this.__height){
element.style.height=this.__height+"px";
}
require("LexicalUtils").addClassNamesToElement(element,config.theme.tableRow);
return element;
};_proto2.
isShadowRoot=function isShadowRoot(){
return true;
};_proto2.
setHeight=function setHeight(height){
var self=this.getWritable();
self.__height=height;
return this.__height;
};_proto2.
getHeight=function getHeight(){
return this.getLatest().__height;
};_proto2.
updateDOM=function updateDOM(prevNode){
return prevNode.__height!==this.__height;
};_proto2.
canBeEmpty=function canBeEmpty(){
return false;
};_proto2.
canIndent=function canIndent(){
return false;
};return TableRowNode;}(require("Lexical").ElementNode);

function convertTableRowElement(domNode){
var domNode_=domNode;
var height=undefined;
if(PIXEL_VALUE_REG_EXP.test(domNode_.style.height)){
height=parseFloat(domNode_.style.height);
}
return{
node:$createTableRowNode(height)};

}
function $createTableRowNode(height){
return require("Lexical").$applyNodeReplacement(new TableRowNode(height));
}
function $isTableRowNode(node){
return node instanceof TableRowNode;
}









var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








function $createTableNodeWithDimensions(rowCount,columnCount,includeHeaders){if(includeHeaders===void 0){includeHeaders=true;}
var tableNode=$createTableNode();
for(var iRow=0;iRow<rowCount;iRow++){
var tableRowNode=$createTableRowNode();
for(var iColumn=0;iColumn<columnCount;iColumn++){
var headerState=TableCellHeaderStates.NO_STATUS;
if(typeof includeHeaders==='object'){
if(iRow===0&&includeHeaders.rows)headerState|=TableCellHeaderStates.ROW;
if(iColumn===0&&includeHeaders.columns)headerState|=TableCellHeaderStates.COLUMN;
}else if(includeHeaders){
if(iRow===0)headerState|=TableCellHeaderStates.ROW;
if(iColumn===0)headerState|=TableCellHeaderStates.COLUMN;
}
var tableCellNode=$createTableCellNode(headerState);
var paragraphNode=require("Lexical").$createParagraphNode();
paragraphNode.append(require("Lexical").$createTextNode());
tableCellNode.append(paragraphNode);
tableRowNode.append(tableCellNode);
}
tableNode.append(tableRowNode);
}
return tableNode;
}
function $getTableCellNodeFromLexicalNode(startingNode){
var node=require("LexicalUtils").$findMatchingParent(startingNode,function(n){return $isTableCellNode(n);});
if($isTableCellNode(node)){
return node;
}
return null;
}
function $getTableRowNodeFromTableCellNodeOrThrow(startingNode){
var node=require("LexicalUtils").$findMatchingParent(startingNode,function(n){return $isTableRowNode(n);});
if($isTableRowNode(node)){
return node;
}
throw new Error('Expected table cell to be inside of table row.');
}
function $getTableNodeFromLexicalNodeOrThrow(startingNode){
var node=require("LexicalUtils").$findMatchingParent(startingNode,function(n){return $isTableNode(n);});
if($isTableNode(node)){
return node;
}
throw new Error('Expected table cell to be inside of table.');
}
function $getTableRowIndexFromTableCellNode(tableCellNode){
var tableRowNode=$getTableRowNodeFromTableCellNodeOrThrow(tableCellNode);
var tableNode=$getTableNodeFromLexicalNodeOrThrow(tableRowNode);
return tableNode.getChildren().findIndex(function(n){return n.is(tableRowNode);});
}
function $getTableColumnIndexFromTableCellNode(tableCellNode){
var tableRowNode=$getTableRowNodeFromTableCellNodeOrThrow(tableCellNode);
return tableRowNode.getChildren().findIndex(function(n){return n.is(tableCellNode);});
}
function $getTableCellSiblingsFromTableCellNode(tableCellNode,table){
var tableNode=$getTableNodeFromLexicalNodeOrThrow(tableCellNode);var _tableNode$getCordsFr=



tableNode.getCordsFromCellNode(tableCellNode,table),x=_tableNode$getCordsFr.x,y=_tableNode$getCordsFr.y;
return{
above:tableNode.getCellNodeFromCords(x,y-1,table),
below:tableNode.getCellNodeFromCords(x,y+1,table),
left:tableNode.getCellNodeFromCords(x-1,y,table),
right:tableNode.getCellNodeFromCords(x+1,y,table)};

}
function $removeTableRowAtIndex(tableNode,indexToDelete){
var tableRows=tableNode.getChildren();
if(indexToDelete>=tableRows.length||indexToDelete<0){
throw new Error('Expected table cell to be inside of table row.');
}
var targetRowNode=tableRows[indexToDelete];
targetRowNode.remove();
return tableNode;
}
function $insertTableRow(tableNode,targetIndex,shouldInsertAfter,rowCount,table){if(shouldInsertAfter===void 0){shouldInsertAfter=true;}
var tableRows=tableNode.getChildren();
if(targetIndex>=tableRows.length||targetIndex<0){
throw new Error('Table row target index out of range');
}
var targetRowNode=tableRows[targetIndex];
if($isTableRowNode(targetRowNode)){
for(var r=0;r<rowCount;r++){
var tableRowCells=targetRowNode.getChildren();
var tableColumnCount=tableRowCells.length;
var newTableRowNode=$createTableRowNode();
for(var c=0;c<tableColumnCount;c++){
var tableCellFromTargetRow=tableRowCells[c];
if(!$isTableCellNode(tableCellFromTargetRow)){
throw Error("Expected table cell");
}var _$getTableCellSibling=



$getTableCellSiblingsFromTableCellNode(tableCellFromTargetRow,table),above=_$getTableCellSibling.above,below=_$getTableCellSibling.below;
var headerState=TableCellHeaderStates.NO_STATUS;
var width=above&&above.getWidth()||below&&below.getWidth()||undefined;
if(above&&above.hasHeaderState(TableCellHeaderStates.COLUMN)||below&&below.hasHeaderState(TableCellHeaderStates.COLUMN)){
headerState|=TableCellHeaderStates.COLUMN;
}
var tableCellNode=$createTableCellNode(headerState,1,width);
tableCellNode.append(require("Lexical").$createParagraphNode());
newTableRowNode.append(tableCellNode);
}
if(shouldInsertAfter){
targetRowNode.insertAfter(newTableRowNode);
}else{
targetRowNode.insertBefore(newTableRowNode);
}
}
}else{
throw new Error('Row before insertion index does not exist.');
}
return tableNode;
}
var getHeaderState=function getHeaderState(currentState,possibleState){
if(currentState===TableCellHeaderStates.BOTH||currentState===possibleState){
return possibleState;
}
return TableCellHeaderStates.NO_STATUS;
};
function $insertTableRow__EXPERIMENTAL(insertAfter){if(insertAfter===void 0){insertAfter=true;}
var selection=require("Lexical").$getSelection();
if(!(require("Lexical").$isRangeSelection(selection)||$isTableSelection(selection))){
throw Error("Expected a RangeSelection or GridSelection");
}
var focus=selection.focus.getNode();var _$getNodeTriplet=
$getNodeTriplet(focus),focusCell=_$getNodeTriplet[0],grid=_$getNodeTriplet[2];var _$computeTableMap=
$computeTableMap(grid,focusCell,focusCell),gridMap=_$computeTableMap[0],focusCellMap=_$computeTableMap[1];
var columnCount=gridMap[0].length;var

focusStartRow=
focusCellMap.startRow;
if(insertAfter){
var focusEndRow=focusStartRow+focusCell.__rowSpan-1;
var focusEndRowMap=gridMap[focusEndRow];
var newRow=$createTableRowNode();
for(var i=0;i<columnCount;i++){var _focusEndRowMap$i=



focusEndRowMap[i],cell=_focusEndRowMap$i.cell,startRow=_focusEndRowMap$i.startRow;
if(startRow+cell.__rowSpan-1<=focusEndRow){
var currentCell=focusEndRowMap[i].cell;
var currentCellHeaderState=currentCell.__headerState;
var headerState=getHeaderState(currentCellHeaderState,TableCellHeaderStates.COLUMN);
newRow.append($createTableCellNode(headerState).append(require("Lexical").$createParagraphNode()));
}else{
cell.setRowSpan(cell.__rowSpan+1);
}
}
var focusEndRowNode=grid.getChildAtIndex(focusEndRow);
if(!$isTableRowNode(focusEndRowNode)){
throw Error("focusEndRow is not a TableRowNode");
}
focusEndRowNode.insertAfter(newRow);
}else{
var focusStartRowMap=gridMap[focusStartRow];
var _newRow=$createTableRowNode();
for(var _i=0;_i<columnCount;_i++){var _focusStartRowMap$_i=



focusStartRowMap[_i],cell=_focusStartRowMap$_i.cell,startRow=_focusStartRowMap$_i.startRow;
if(startRow===focusStartRow){
var _currentCell=focusStartRowMap[_i].cell;
var _currentCellHeaderState=_currentCell.__headerState;
var _headerState=getHeaderState(_currentCellHeaderState,TableCellHeaderStates.COLUMN);
_newRow.append($createTableCellNode(_headerState).append(require("Lexical").$createParagraphNode()));
}else{
cell.setRowSpan(cell.__rowSpan+1);
}
}
var focusStartRowNode=grid.getChildAtIndex(focusStartRow);
if(!$isTableRowNode(focusStartRowNode)){
throw Error("focusEndRow is not a TableRowNode");
}
focusStartRowNode.insertBefore(_newRow);
}
}
function $insertTableColumn(tableNode,targetIndex,shouldInsertAfter,columnCount,table){if(shouldInsertAfter===void 0){shouldInsertAfter=true;}
var tableRows=tableNode.getChildren();
var tableCellsToBeInserted=[];
for(var r=0;r<tableRows.length;r++){
var currentTableRowNode=tableRows[r];
if($isTableRowNode(currentTableRowNode)){
for(var c=0;c<columnCount;c++){
var tableRowChildren=currentTableRowNode.getChildren();
if(targetIndex>=tableRowChildren.length||targetIndex<0){
throw new Error('Table column target index out of range');
}
var targetCell=tableRowChildren[targetIndex];
if(!$isTableCellNode(targetCell)){
throw Error("Expected table cell");
}var _$getTableCellSibling2=



$getTableCellSiblingsFromTableCellNode(targetCell,table),left=_$getTableCellSibling2.left,right=_$getTableCellSibling2.right;
var headerState=TableCellHeaderStates.NO_STATUS;
if(left&&left.hasHeaderState(TableCellHeaderStates.ROW)||right&&right.hasHeaderState(TableCellHeaderStates.ROW)){
headerState|=TableCellHeaderStates.ROW;
}
var newTableCell=$createTableCellNode(headerState);
newTableCell.append(require("Lexical").$createParagraphNode());
tableCellsToBeInserted.push({
newTableCell:newTableCell,
targetCell:targetCell});

}
}
}
tableCellsToBeInserted.forEach(function(_ref)


{var newTableCell=_ref.newTableCell,targetCell=_ref.targetCell;
if(shouldInsertAfter){
targetCell.insertAfter(newTableCell);
}else{
targetCell.insertBefore(newTableCell);
}
});
return tableNode;
}
function $insertTableColumn__EXPERIMENTAL(insertAfter){if(insertAfter===void 0){insertAfter=true;}
var selection=require("Lexical").$getSelection();
if(!(require("Lexical").$isRangeSelection(selection)||$isTableSelection(selection))){
throw Error("Expected a RangeSelection or GridSelection");
}
var anchor=selection.anchor.getNode();
var focus=selection.focus.getNode();var _$getNodeTriplet2=
$getNodeTriplet(anchor),anchorCell=_$getNodeTriplet2[0];var _$getNodeTriplet3=
$getNodeTriplet(focus),focusCell=_$getNodeTriplet3[0],grid=_$getNodeTriplet3[2];var _$computeTableMap2=
$computeTableMap(grid,focusCell,anchorCell),gridMap=_$computeTableMap2[0],focusCellMap=_$computeTableMap2[1],anchorCellMap=_$computeTableMap2[2];
var rowCount=gridMap.length;
var startColumn=insertAfter?Math.max(focusCellMap.startColumn,anchorCellMap.startColumn):Math.min(focusCellMap.startColumn,anchorCellMap.startColumn);
var insertAfterColumn=insertAfter?startColumn+focusCell.__colSpan-1:startColumn-1;
var gridFirstChild=grid.getFirstChild();
if(!$isTableRowNode(gridFirstChild)){
throw Error("Expected firstTable child to be a row");
}
var firstInsertedCell=null;
function $createTableCellNodeForInsertTableColumn(headerState){if(headerState===void 0){headerState=TableCellHeaderStates.NO_STATUS;}
var cell=$createTableCellNode(headerState).append(require("Lexical").$createParagraphNode());
if(firstInsertedCell===null){
firstInsertedCell=cell;
}
return cell;
}
var loopRow=gridFirstChild;
rowLoop:for(var i=0;i<rowCount;i++){
if(i!==0){
var currentRow=loopRow.getNextSibling();
if(!$isTableRowNode(currentRow)){
throw Error("Expected row nextSibling to be a row");
}
loopRow=currentRow;
}
var rowMap=gridMap[i];
var currentCellHeaderState=rowMap[insertAfterColumn<0?0:insertAfterColumn].cell.__headerState;
var headerState=getHeaderState(currentCellHeaderState,TableCellHeaderStates.ROW);
if(insertAfterColumn<0){
$insertFirst(loopRow,$createTableCellNodeForInsertTableColumn(headerState));
continue;
}var _rowMap$insertAfterCo=




rowMap[insertAfterColumn],currentCell=_rowMap$insertAfterCo.cell,currentStartColumn=_rowMap$insertAfterCo.startColumn,currentStartRow=_rowMap$insertAfterCo.startRow;
if(currentStartColumn+currentCell.__colSpan-1<=insertAfterColumn){
var insertAfterCell=currentCell;
var insertAfterCellRowStart=currentStartRow;
var prevCellIndex=insertAfterColumn;
while(insertAfterCellRowStart!==i&&insertAfterCell.__rowSpan>1){
prevCellIndex-=currentCell.__colSpan;
if(prevCellIndex>=0){var _rowMap$prevCellIndex=



rowMap[prevCellIndex],cell_=_rowMap$prevCellIndex.cell,startRow_=_rowMap$prevCellIndex.startRow;
insertAfterCell=cell_;
insertAfterCellRowStart=startRow_;
}else{
loopRow.append($createTableCellNodeForInsertTableColumn(headerState));
continue rowLoop;
}
}
insertAfterCell.insertAfter($createTableCellNodeForInsertTableColumn(headerState));
}else{
currentCell.setColSpan(currentCell.__colSpan+1);
}
}
if(firstInsertedCell!==null){
$moveSelectionToCell(firstInsertedCell);
}
}
function $deleteTableColumn(tableNode,targetIndex){
var tableRows=tableNode.getChildren();
for(var i=0;i<tableRows.length;i++){
var currentTableRowNode=tableRows[i];
if($isTableRowNode(currentTableRowNode)){
var tableRowChildren=currentTableRowNode.getChildren();
if(targetIndex>=tableRowChildren.length||targetIndex<0){
throw new Error('Table column target index out of range');
}
tableRowChildren[targetIndex].remove();
}
}
return tableNode;
}
function $deleteTableRow__EXPERIMENTAL(){
var selection=require("Lexical").$getSelection();
if(!(require("Lexical").$isRangeSelection(selection)||$isTableSelection(selection))){
throw Error("Expected a RangeSelection or GridSelection");
}
var anchor=selection.anchor.getNode();
var focus=selection.focus.getNode();var _$getNodeTriplet4=
$getNodeTriplet(anchor),anchorCell=_$getNodeTriplet4[0],grid=_$getNodeTriplet4[2];var _$getNodeTriplet5=
$getNodeTriplet(focus),focusCell=_$getNodeTriplet5[0];var _$computeTableMap3=
$computeTableMap(grid,anchorCell,focusCell),gridMap=_$computeTableMap3[0],anchorCellMap=_$computeTableMap3[1],focusCellMap=_$computeTableMap3[2];var

anchorStartRow=
anchorCellMap.startRow;var

focusStartRow=
focusCellMap.startRow;
var focusEndRow=focusStartRow+focusCell.__rowSpan-1;
if(gridMap.length===focusEndRow-anchorStartRow+1){

grid.remove();
return;
}
var columnCount=gridMap[0].length;
var nextRow=gridMap[focusEndRow+1];
var nextRowNode=grid.getChildAtIndex(focusEndRow+1);
for(var row=focusEndRow;row>=anchorStartRow;row--){
for(var column=columnCount-1;column>=0;column--){var _gridMap$row$column=




gridMap[row][column],cell=_gridMap$row$column.cell,cellStartRow=_gridMap$row$column.startRow,cellStartColumn=_gridMap$row$column.startColumn;
if(cellStartColumn!==column){

continue;
}

if(row===anchorStartRow&&cellStartRow<anchorStartRow){
cell.setRowSpan(cell.__rowSpan-(cellStartRow-anchorStartRow));
}

if(cellStartRow>=anchorStartRow&&cellStartRow+cell.__rowSpan-1>focusEndRow){
cell.setRowSpan(cell.__rowSpan-(focusEndRow-cellStartRow+1));
if(!(nextRowNode!==null)){
throw Error("Expected nextRowNode not to be null");
}
if(column===0){
$insertFirst(nextRowNode,cell);
}else{var

previousCell=
nextRow[column-1].cell;
previousCell.insertAfter(cell);
}
}
}
var rowNode=grid.getChildAtIndex(row);
if(!$isTableRowNode(rowNode)){
throw Error("Expected GridNode childAtIndex("+String(row)+") to be RowNode");
}
rowNode.remove();
}
if(nextRow!==undefined){var

cell=
nextRow[0].cell;
$moveSelectionToCell(cell);
}else{
var previousRow=gridMap[anchorStartRow-1];var

_cell=
previousRow[0].cell;
$moveSelectionToCell(_cell);
}
}
function $deleteTableColumn__EXPERIMENTAL(){
var selection=require("Lexical").$getSelection();
if(!(require("Lexical").$isRangeSelection(selection)||$isTableSelection(selection))){
throw Error("Expected a RangeSelection or GridSelection");
}
var anchor=selection.anchor.getNode();
var focus=selection.focus.getNode();var _$getNodeTriplet6=
$getNodeTriplet(anchor),anchorCell=_$getNodeTriplet6[0],grid=_$getNodeTriplet6[2];var _$getNodeTriplet7=
$getNodeTriplet(focus),focusCell=_$getNodeTriplet7[0];var _$computeTableMap4=
$computeTableMap(grid,anchorCell,focusCell),gridMap=_$computeTableMap4[0],anchorCellMap=_$computeTableMap4[1],focusCellMap=_$computeTableMap4[2];var

anchorStartColumn=
anchorCellMap.startColumn;var

focusStartRow=

focusCellMap.startRow,focusStartColumn=focusCellMap.startColumn;
var startColumn=Math.min(anchorStartColumn,focusStartColumn);
var endColumn=Math.max(anchorStartColumn+anchorCell.__colSpan-1,focusStartColumn+focusCell.__colSpan-1);
var selectedColumnCount=endColumn-startColumn+1;
var columnCount=gridMap[0].length;
if(columnCount===endColumn-startColumn+1){

grid.selectPrevious();
grid.remove();
return;
}
var rowCount=gridMap.length;
for(var row=0;row<rowCount;row++){
for(var column=startColumn;column<=endColumn;column++){var _gridMap$row$column2=



gridMap[row][column],cell=_gridMap$row$column2.cell,cellStartColumn=_gridMap$row$column2.startColumn;
if(cellStartColumn<startColumn){
if(column===startColumn){
var overflowLeft=startColumn-cellStartColumn;

cell.setColSpan(cell.__colSpan-

Math.min(selectedColumnCount,cell.__colSpan-overflowLeft));
}
}else if(cellStartColumn+cell.__colSpan-1>endColumn){
if(column===endColumn){

var inSelectedArea=endColumn-cellStartColumn+1;
cell.setColSpan(cell.__colSpan-inSelectedArea);
}
}else{
cell.remove();
}
}
}
var focusRowMap=gridMap[focusStartRow];
var nextColumn=focusRowMap[focusStartColumn+focusCell.__colSpan];
if(nextColumn!==undefined){var

cell=
nextColumn.cell;
$moveSelectionToCell(cell);
}else{
var previousRow=focusRowMap[focusStartColumn-1];var

_cell2=
previousRow.cell;
$moveSelectionToCell(_cell2);
}
}
function $moveSelectionToCell(cell){
var firstDescendant=cell.getFirstDescendant();
if(firstDescendant==null){
cell.selectStart();
}else{
firstDescendant.getParentOrThrow().selectStart();
}
}
function $insertFirst(parent,node){
var firstChild=parent.getFirstChild();
if(firstChild!==null){
firstChild.insertBefore(node);
}else{
parent.append(node);
}
}
function $unmergeCell(){
var selection=require("Lexical").$getSelection();
if(!(require("Lexical").$isRangeSelection(selection)||$isTableSelection(selection))){
throw Error("Expected a RangeSelection or GridSelection");
}
var anchor=selection.anchor.getNode();var _$getNodeTriplet8=
$getNodeTriplet(anchor),cell=_$getNodeTriplet8[0],row=_$getNodeTriplet8[1],grid=_$getNodeTriplet8[2];
var colSpan=cell.__colSpan;
var rowSpan=cell.__rowSpan;
if(colSpan>1){
for(var i=1;i<colSpan;i++){
cell.insertAfter($createTableCellNode(TableCellHeaderStates.NO_STATUS));
}
cell.setColSpan(1);
}
if(rowSpan>1){var _$computeTableMap5=
$computeTableMap(grid,cell,cell),map=_$computeTableMap5[0],cellMap=_$computeTableMap5[1];var

startColumn=

cellMap.startColumn,startRow=cellMap.startRow;
var currentRowNode;
for(var _i2=1;_i2<rowSpan;_i2++){
var currentRow=startRow+_i2;
var currentRowMap=map[currentRow];
currentRowNode=(currentRowNode||row).getNextSibling();
if(!$isTableRowNode(currentRowNode)){
throw Error("Expected row next sibling to be a row");
}
var insertAfterCell=null;
for(var column=0;column<startColumn;column++){
var currentCellMap=currentRowMap[column];
var currentCell=currentCellMap.cell;
if(currentCellMap.startRow===currentRow){
insertAfterCell=currentCell;
}
if(currentCell.__colSpan>1){
column+=currentCell.__colSpan-1;
}
}
if(insertAfterCell===null){
for(var j=0;j<colSpan;j++){
$insertFirst(currentRowNode,$createTableCellNode(TableCellHeaderStates.NO_STATUS));
}
}else{
for(var _j=0;_j<colSpan;_j++){
insertAfterCell.insertAfter($createTableCellNode(TableCellHeaderStates.NO_STATUS));
}
}
}
cell.setRowSpan(1);
}
}
function $computeTableMap(grid,cellA,cellB){
var tableMap=[];
var cellAValue=null;
var cellBValue=null;
function write(startRow,startColumn,cell){
var value={
cell:cell,
startColumn:startColumn,
startRow:startRow};

var rowSpan=cell.__rowSpan;
var colSpan=cell.__colSpan;
for(var i=0;i<rowSpan;i++){
if(tableMap[startRow+i]===undefined){
tableMap[startRow+i]=[];
}
for(var j=0;j<colSpan;j++){
tableMap[startRow+i][startColumn+j]=value;
}
}
if(cellA.is(cell)){
cellAValue=value;
}
if(cellB.is(cell)){
cellBValue=value;
}
}
function isEmpty(row,column){
return tableMap[row]===undefined||tableMap[row][column]===undefined;
}
var gridChildren=grid.getChildren();
for(var i=0;i<gridChildren.length;i++){
var row=gridChildren[i];
if(!$isTableRowNode(row)){
throw Error("Expected GridNode children to be TableRowNode");
}
var rowChildren=row.getChildren();
var j=0;
for(var _iterator=rowChildren,_isArray=Array.isArray(_iterator),_i3=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray){if(_i3>=_iterator.length)break;_ref2=_iterator[_i3++];}else{_i3=_iterator.next();if(_i3.done)break;_ref2=_i3.value;}var cell=_ref2;
if(!$isTableCellNode(cell)){
throw Error("Expected TableRowNode children to be TableCellNode");
}
while(!isEmpty(i,j)){
j++;
}
write(i,j,cell);
j+=cell.__colSpan;
}
}
if(!(cellAValue!==null)){
throw Error("Anchor not found in Grid");
}
if(!(cellBValue!==null)){
throw Error("Focus not found in Grid");
}
return[tableMap,cellAValue,cellBValue];
}
function $getNodeTriplet(source){
var cell;
if(source instanceof TableCellNode){
cell=source;
}else if('__type'in source){
var cell_=require("LexicalUtils").$findMatchingParent(source,$isTableCellNode);
if(!$isTableCellNode(cell_)){
throw Error("Expected to find a parent TableCellNode");
}
cell=cell_;
}else{
var _cell_=require("LexicalUtils").$findMatchingParent(source.getNode(),$isTableCellNode);
if(!$isTableCellNode(_cell_)){
throw Error("Expected to find a parent TableCellNode");
}
cell=_cell_;
}
var row=cell.getParent();
if(!$isTableRowNode(row)){
throw Error("Expected TableCellNode to have a parent TableRowNode");
}
var grid=row.getParent();
if(!$isTableNode(grid)){
throw Error("Expected TableRowNode to have a parent GridNode");
}
return[cell,row,grid];
}
function $getTableCellNodeRect(tableCellNode){var _$getNodeTriplet9=
$getNodeTriplet(tableCellNode),cellNode=_$getNodeTriplet9[0],gridNode=_$getNodeTriplet9[2];
var rows=gridNode.getChildren();
var rowCount=rows.length;
var columnCount=rows[0].getChildren().length;


var cellMatrix=new Array(rowCount);
for(var i=0;i<rowCount;i++){
cellMatrix[i]=new Array(columnCount);
}
for(var rowIndex=0;rowIndex<rowCount;rowIndex++){
var row=rows[rowIndex];
var cells=row.getChildren();
var columnIndex=0;
for(var cellIndex=0;cellIndex<cells.length;cellIndex++){

while(cellMatrix[rowIndex][columnIndex]){
columnIndex++;
}
var cell=cells[cellIndex];
var rowSpan=cell.__rowSpan||1;
var colSpan=cell.__colSpan||1;


for(var _i4=0;_i4<rowSpan;_i4++){
for(var j=0;j<colSpan;j++){
cellMatrix[rowIndex+_i4][columnIndex+j]=cell;
}
}


if(cellNode===cell){
return{
colSpan:colSpan,
columnIndex:columnIndex,
rowIndex:rowIndex,
rowSpan:rowSpan};

}
columnIndex+=colSpan;
}
}
return null;
}var








TableSelection=function(){
function TableSelection(tableKey,anchor,focus){
this.anchor=anchor;
this.focus=focus;
anchor._selection=this;
focus._selection=this;
this._cachedNodes=null;
this.dirty=false;
this.tableKey=tableKey;
}var _proto3=TableSelection.prototype;_proto3.
getStartEndPoints=function getStartEndPoints(){
return[this.anchor,this.focus];
};_proto3.






isBackward=function isBackward(){
return this.focus.isBefore(this.anchor);
};_proto3.
getCachedNodes=function getCachedNodes(){
return this._cachedNodes;
};_proto3.
setCachedNodes=function setCachedNodes(nodes){
this._cachedNodes=nodes;
};_proto3.
is=function is(selection){
if(!$isTableSelection(selection)){
return false;
}
return this.tableKey===selection.tableKey&&this.anchor.is(selection.anchor)&&this.focus.is(selection.focus);
};_proto3.
set=function set(tableKey,anchorCellKey,focusCellKey){
this.dirty=true;
this.tableKey=tableKey;
this.anchor.key=anchorCellKey;
this.focus.key=focusCellKey;
this._cachedNodes=null;
};_proto3.
clone=function clone(){
return new TableSelection(this.tableKey,this.anchor,this.focus);
};_proto3.
isCollapsed=function isCollapsed(){
return false;
};_proto3.
extract=function extract(){
return this.getNodes();
};_proto3.
insertRawText=function insertRawText(text){

};_proto3.
insertText=function insertText(){

};_proto3.
insertNodes=function insertNodes(nodes){
var focusNode=this.focus.getNode();
if(!require("Lexical").$isElementNode(focusNode)){
throw Error("Expected TableSelection focus to be an ElementNode");
}
var selection=require("Lexical").$normalizeSelection__EXPERIMENTAL(focusNode.select(0,focusNode.getChildrenSize()));
selection.insertNodes(nodes);
};_proto3.


getShape=function getShape(){
var anchorCellNode=require("Lexical").$getNodeByKey(this.anchor.key);
if(!$isTableCellNode(anchorCellNode)){
throw Error("Expected TableSelection anchor to be (or a child of) TableCellNode");
}
var anchorCellNodeRect=$getTableCellNodeRect(anchorCellNode);
if(!(anchorCellNodeRect!==null)){
throw Error("getCellRect: expected to find AnchorNode");
}
var focusCellNode=require("Lexical").$getNodeByKey(this.focus.key);
if(!$isTableCellNode(focusCellNode)){
throw Error("Expected TableSelection focus to be (or a child of) TableCellNode");
}
var focusCellNodeRect=$getTableCellNodeRect(focusCellNode);
if(!(focusCellNodeRect!==null)){
throw Error("getCellRect: expected to find focusCellNode");
}
var startX=Math.min(anchorCellNodeRect.columnIndex,focusCellNodeRect.columnIndex);
var stopX=Math.max(anchorCellNodeRect.columnIndex,focusCellNodeRect.columnIndex);
var startY=Math.min(anchorCellNodeRect.rowIndex,focusCellNodeRect.rowIndex);
var stopY=Math.max(anchorCellNodeRect.rowIndex,focusCellNodeRect.rowIndex);
return{
fromX:Math.min(startX,stopX),
fromY:Math.min(startY,stopY),
toX:Math.max(startX,stopX),
toY:Math.max(startY,stopY)};

};_proto3.
getNodes=function getNodes(){
var cachedNodes=this._cachedNodes;
if(cachedNodes!==null){
return cachedNodes;
}
var anchorNode=this.anchor.getNode();
var focusNode=this.focus.getNode();
var anchorCell=require("LexicalUtils").$findMatchingParent(anchorNode,$isTableCellNode);

var focusCell=require("LexicalUtils").$findMatchingParent(focusNode,$isTableCellNode);
if(!$isTableCellNode(anchorCell)){
throw Error("Expected TableSelection anchor to be (or a child of) TableCellNode");
}
if(!$isTableCellNode(focusCell)){
throw Error("Expected TableSelection focus to be (or a child of) TableCellNode");
}
var anchorRow=anchorCell.getParent();
if(!$isTableRowNode(anchorRow)){
throw Error("Expected anchorCell to have a parent TableRowNode");
}
var tableNode=anchorRow.getParent();
if(!$isTableNode(tableNode)){
throw Error("Expected tableNode to have a parent TableNode");
}
var focusCellGrid=focusCell.getParents()[1];
if(focusCellGrid!==tableNode){
if(!tableNode.isParentOf(focusCell)){

var gridParent=tableNode.getParent();
if(!(gridParent!=null)){
throw Error("Expected gridParent to have a parent");
}
this.set(this.tableKey,gridParent.getKey(),focusCell.getKey());
}else{

var focusCellParent=focusCellGrid.getParent();
if(!(focusCellParent!=null)){
throw Error("Expected focusCellParent to have a parent");
}
this.set(this.tableKey,focusCell.getKey(),focusCellParent.getKey());
}
return this.getNodes();
}var _$computeTableMap6=





$computeTableMap(tableNode,anchorCell,focusCell),map=_$computeTableMap6[0],cellAMap=_$computeTableMap6[1],cellBMap=_$computeTableMap6[2];
var minColumn=Math.min(cellAMap.startColumn,cellBMap.startColumn);
var minRow=Math.min(cellAMap.startRow,cellBMap.startRow);
var maxColumn=Math.max(cellAMap.startColumn+cellAMap.cell.__colSpan-1,cellBMap.startColumn+cellBMap.cell.__colSpan-1);
var maxRow=Math.max(cellAMap.startRow+cellAMap.cell.__rowSpan-1,cellBMap.startRow+cellBMap.cell.__rowSpan-1);
var exploredMinColumn=minColumn;
var exploredMinRow=minRow;
var exploredMaxColumn=minColumn;
var exploredMaxRow=minRow;
function expandBoundary(mapValue){var

cell=


mapValue.cell,cellStartColumn=mapValue.startColumn,cellStartRow=mapValue.startRow;
minColumn=Math.min(minColumn,cellStartColumn);
minRow=Math.min(minRow,cellStartRow);
maxColumn=Math.max(maxColumn,cellStartColumn+cell.__colSpan-1);
maxRow=Math.max(maxRow,cellStartRow+cell.__rowSpan-1);
}
while(minColumn<exploredMinColumn||minRow<exploredMinRow||maxColumn>exploredMaxColumn||maxRow>exploredMaxRow){
if(minColumn<exploredMinColumn){

var rowDiff=exploredMaxRow-exploredMinRow;
var previousColumn=exploredMinColumn-1;
for(var i=0;i<=rowDiff;i++){
expandBoundary(map[exploredMinRow+i][previousColumn]);
}
exploredMinColumn=previousColumn;
}
if(minRow<exploredMinRow){

var columnDiff=exploredMaxColumn-exploredMinColumn;
var previousRow=exploredMinRow-1;
for(var _i5=0;_i5<=columnDiff;_i5++){
expandBoundary(map[previousRow][exploredMinColumn+_i5]);
}
exploredMinRow=previousRow;
}
if(maxColumn>exploredMaxColumn){

var _rowDiff=exploredMaxRow-exploredMinRow;
var nextColumn=exploredMaxColumn+1;
for(var _i6=0;_i6<=_rowDiff;_i6++){
expandBoundary(map[exploredMinRow+_i6][nextColumn]);
}
exploredMaxColumn=nextColumn;
}
if(maxRow>exploredMaxRow){

var _columnDiff=exploredMaxColumn-exploredMinColumn;
var nextRow=exploredMaxRow+1;
for(var _i7=0;_i7<=_columnDiff;_i7++){
expandBoundary(map[nextRow][exploredMinColumn+_i7]);
}
exploredMaxRow=nextRow;
}
}
var nodes=[tableNode];
var lastRow=null;
for(var _i8=minRow;_i8<=maxRow;_i8++){
for(var j=minColumn;j<=maxColumn;j++){var

cell=
map[_i8][j].cell;
var currentRow=cell.getParent();
if(!$isTableRowNode(currentRow)){
throw Error("Expected TableCellNode parent to be a TableRowNode");
}
if(currentRow!==lastRow){
nodes.push(currentRow);
}
nodes.push.apply(nodes,[cell].concat($getChildrenRecursively(cell)));
lastRow=currentRow;
}
}
if(!require("Lexical").isCurrentlyReadOnlyMode()){
this._cachedNodes=nodes;
}
return nodes;
};_proto3.
getTextContent=function getTextContent(){
var nodes=this.getNodes();
var textContent='';
for(var i=0;i<nodes.length;i++){
textContent+=nodes[i].getTextContent();
}
return textContent;
};return TableSelection;}();

function $isTableSelection(x){
return x instanceof TableSelection;
}
function $createTableSelection(){
var anchor=require("Lexical").$createPoint('root',0,'element');
var focus=require("Lexical").$createPoint('root',0,'element');
return new TableSelection('root',anchor,focus);
}
function $getChildrenRecursively(node){
var nodes=[];
var stack=[node];
while(stack.length>0){
var currentNode=stack.pop();
if(!(currentNode!==undefined)){
throw Error("Stack.length > 0; can't be undefined");
}
if(require("Lexical").$isElementNode(currentNode)){
stack.unshift.apply(stack,currentNode.getChildren());
}
if(currentNode!==node){
nodes.push(currentNode);
}
}
return nodes;
}








var getDOMSelection=function getDOMSelection(targetWindow){return CAN_USE_DOM?(targetWindow||window).getSelection():null;};var
TableObserver=function(){
function TableObserver(editor,tableNodeKey){
this.isHighlightingCells=false;
this.anchorX=-1;
this.anchorY=-1;
this.focusX=-1;
this.focusY=-1;
this.listenersToRemove=new Set();
this.tableNodeKey=tableNodeKey;
this.editor=editor;
this.table={
columns:0,
domRows:[],
rows:0};

this.tableSelection=null;
this.anchorCellNodeKey=null;
this.focusCellNodeKey=null;
this.anchorCell=null;
this.focusCell=null;
this.hasHijackedSelectionStyles=false;
this.trackTable();
}var _proto4=TableObserver.prototype;_proto4.
getTable=function getTable(){
return this.table;
};_proto4.
removeListeners=function removeListeners(){
Array.from(this.listenersToRemove).forEach(function(removeListener){return removeListener();});
};_proto4.
trackTable=function trackTable(){var _this3=this;
var observer=new MutationObserver(function(records){
_this3.editor.update(function(){
var gridNeedsRedraw=false;
for(var i=0;i<records.length;i++){
var record=records[i];
var target=record.target;
var nodeName=target.nodeName;
if(nodeName==='TABLE'||nodeName==='TR'){
gridNeedsRedraw=true;
break;
}
}
if(!gridNeedsRedraw){
return;
}
var tableElement=_this3.editor.getElementByKey(_this3.tableNodeKey);
if(!tableElement){
throw new Error('Expected to find TableElement in DOM');
}
_this3.table=getTable(tableElement);
});
});
this.editor.update(function(){
var tableElement=_this3.editor.getElementByKey(_this3.tableNodeKey);
if(!tableElement){
throw new Error('Expected to find TableElement in DOM');
}
_this3.table=getTable(tableElement);
observer.observe(tableElement,{
childList:true,
subtree:true});

});
};_proto4.
clearHighlight=function clearHighlight(){var _this4=this;
var editor=this.editor;
this.isHighlightingCells=false;
this.anchorX=-1;
this.anchorY=-1;
this.focusX=-1;
this.focusY=-1;
this.tableSelection=null;
this.anchorCellNodeKey=null;
this.focusCellNodeKey=null;
this.anchorCell=null;
this.focusCell=null;
this.hasHijackedSelectionStyles=false;
this.enableHighlightStyle();
editor.update(function(){
var tableNode=require("Lexical").$getNodeByKey(_this4.tableNodeKey);
if(!$isTableNode(tableNode)){
throw new Error('Expected TableNode.');
}
var tableElement=editor.getElementByKey(_this4.tableNodeKey);
if(!tableElement){
throw new Error('Expected to find TableElement in DOM');
}
var grid=getTable(tableElement);
$updateDOMForSelection(editor,grid,null);
require("Lexical").$setSelection(null);
editor.dispatchCommand(require("Lexical").SELECTION_CHANGE_COMMAND,undefined);
});
};_proto4.
enableHighlightStyle=function enableHighlightStyle(){var _this5=this;
var editor=this.editor;
editor.update(function(){
var tableElement=editor.getElementByKey(_this5.tableNodeKey);
if(!tableElement){
throw new Error('Expected to find TableElement in DOM');
}
require("LexicalUtils").removeClassNamesFromElement(tableElement,editor._config.theme.tableSelection);
tableElement.classList.remove('disable-selection');
_this5.hasHijackedSelectionStyles=false;
});
};_proto4.
disableHighlightStyle=function disableHighlightStyle(){var _this6=this;
var editor=this.editor;
editor.update(function(){
var tableElement=editor.getElementByKey(_this6.tableNodeKey);
if(!tableElement){
throw new Error('Expected to find TableElement in DOM');
}
require("LexicalUtils").addClassNamesToElement(tableElement,editor._config.theme.tableSelection);
_this6.hasHijackedSelectionStyles=true;
});
};_proto4.
updateTableTableSelection=function updateTableTableSelection(selection){
if(selection!==null&&selection.tableKey===this.tableNodeKey){
var editor=this.editor;
this.tableSelection=selection;
this.isHighlightingCells=true;
this.disableHighlightStyle();
$updateDOMForSelection(editor,this.table,this.tableSelection);
}else if(selection==null){
this.clearHighlight();
}else{
this.tableNodeKey=selection.tableKey;
this.updateTableTableSelection(selection);
}
};_proto4.
setFocusCellForSelection=function setFocusCellForSelection(cell,ignoreStart){var _this7=this;if(ignoreStart===void 0){ignoreStart=false;}
var editor=this.editor;
editor.update(function(){
var tableNode=require("Lexical").$getNodeByKey(_this7.tableNodeKey);
if(!$isTableNode(tableNode)){
throw new Error('Expected TableNode.');
}
var tableElement=editor.getElementByKey(_this7.tableNodeKey);
if(!tableElement){
throw new Error('Expected to find TableElement in DOM');
}
var cellX=cell.x;
var cellY=cell.y;
_this7.focusCell=cell;
if(_this7.anchorCell!==null){
var domSelection=getDOMSelection(editor._window);

if(domSelection){
domSelection.setBaseAndExtent(_this7.anchorCell.elem,0,_this7.focusCell.elem,0);
}
}
if(!_this7.isHighlightingCells&&(_this7.anchorX!==cellX||_this7.anchorY!==cellY||ignoreStart)){
_this7.isHighlightingCells=true;
_this7.disableHighlightStyle();
}else if(cellX===_this7.focusX&&cellY===_this7.focusY){
return;
}
_this7.focusX=cellX;
_this7.focusY=cellY;
if(_this7.isHighlightingCells){
var focusTableCellNode=require("Lexical").$getNearestNodeFromDOMNode(cell.elem);
if(_this7.tableSelection!=null&&_this7.anchorCellNodeKey!=null&&$isTableCellNode(focusTableCellNode)){
var focusNodeKey=focusTableCellNode.getKey();
_this7.tableSelection=_this7.tableSelection.clone()||$createTableSelection();
_this7.focusCellNodeKey=focusNodeKey;
_this7.tableSelection.set(_this7.tableNodeKey,_this7.anchorCellNodeKey,_this7.focusCellNodeKey);
require("Lexical").$setSelection(_this7.tableSelection);
editor.dispatchCommand(require("Lexical").SELECTION_CHANGE_COMMAND,undefined);
$updateDOMForSelection(editor,_this7.table,_this7.tableSelection);
}
}
});
};_proto4.
setAnchorCellForSelection=function setAnchorCellForSelection(cell){var _this8=this;
this.isHighlightingCells=false;
this.anchorCell=cell;
this.anchorX=cell.x;
this.anchorY=cell.y;
this.editor.update(function(){
var anchorTableCellNode=require("Lexical").$getNearestNodeFromDOMNode(cell.elem);
if($isTableCellNode(anchorTableCellNode)){
var anchorNodeKey=anchorTableCellNode.getKey();
_this8.tableSelection=_this8.tableSelection!=null?_this8.tableSelection.clone():$createTableSelection();
_this8.anchorCellNodeKey=anchorNodeKey;
}
});
};_proto4.
formatCells=function formatCells(type){var _this9=this;
this.editor.update(function(){
var selection=require("Lexical").$getSelection();
if(!$isTableSelection(selection)){
{
throw Error("Expected grid selection");
}
}
var formatSelection=require("Lexical").$createRangeSelection();
var anchor=formatSelection.anchor;
var focus=formatSelection.focus;
selection.getNodes().forEach(function(cellNode){
if($isTableCellNode(cellNode)&&cellNode.getTextContentSize()!==0){
anchor.set(cellNode.getKey(),0,'element');
focus.set(cellNode.getKey(),cellNode.getChildrenSize(),'element');
formatSelection.formatText(type);
}
});
require("Lexical").$setSelection(selection);
_this9.editor.dispatchCommand(require("Lexical").SELECTION_CHANGE_COMMAND,undefined);
});
};_proto4.
clearText=function clearText(){var _this10=this;
var editor=this.editor;
editor.update(function(){
var tableNode=require("Lexical").$getNodeByKey(_this10.tableNodeKey);
if(!$isTableNode(tableNode)){
throw new Error('Expected TableNode.');
}
var selection=require("Lexical").$getSelection();
if(!$isTableSelection(selection)){
{
throw Error("Expected grid selection");
}
}
var selectedNodes=selection.getNodes().filter($isTableCellNode);
if(selectedNodes.length===_this10.table.columns*_this10.table.rows){
tableNode.selectPrevious();

tableNode.remove();
var rootNode=require("Lexical").$getRoot();
rootNode.selectStart();
return;
}
selectedNodes.forEach(function(cellNode){
if(require("Lexical").$isElementNode(cellNode)){
var paragraphNode=require("Lexical").$createParagraphNode();
var textNode=require("Lexical").$createTextNode();
paragraphNode.append(textNode);
cellNode.append(paragraphNode);
cellNode.getChildren().forEach(function(child){
if(child!==paragraphNode){
child.remove();
}
});
}
});
$updateDOMForSelection(editor,_this10.table,null);
require("Lexical").$setSelection(null);
editor.dispatchCommand(require("Lexical").SELECTION_CHANGE_COMMAND,undefined);
});
};return TableObserver;}();









var LEXICAL_ELEMENT_KEY='__lexicalTableSelection';
function applyTableHandlers(tableNode,tableElement,editor,hasTabHandler){
var rootElement=editor.getRootElement();
if(rootElement===null){
throw new Error('No root element.');
}
var tableObserver=new TableObserver(editor,tableNode.getKey());
var editorWindow=editor._window||window;
attachTableObserverToTableElement(tableElement,tableObserver);
tableElement.addEventListener('mousedown',function(event){
setTimeout(function(){
if(event.button!==0){
return;
}
if(!editorWindow){
return;
}
var anchorCell=getDOMCellFromTarget(event.target);
if(anchorCell!==null){
stopEvent(event);
tableObserver.setAnchorCellForSelection(anchorCell);
}
var onMouseUp=function onMouseUp(){
editorWindow.removeEventListener('mouseup',onMouseUp);
editorWindow.removeEventListener('mousemove',onMouseMove);
};
var onMouseMove=function onMouseMove(moveEvent){
var focusCell=getDOMCellFromTarget(moveEvent.target);
if(focusCell!==null&&(tableObserver.anchorX!==focusCell.x||tableObserver.anchorY!==focusCell.y)){
moveEvent.preventDefault();
tableObserver.setFocusCellForSelection(focusCell);
}
};
editorWindow.addEventListener('mouseup',onMouseUp);
editorWindow.addEventListener('mousemove',onMouseMove);
},0);
});


var mouseDownCallback=function mouseDownCallback(event){
if(event.button!==0){
return;
}
editor.update(function(){
var selection=require("Lexical").$getSelection();
var target=event.target;
if($isTableSelection(selection)&&selection.tableKey===tableObserver.tableNodeKey&&rootElement.contains(target)){
tableObserver.clearHighlight();
}
});
};
editorWindow.addEventListener('mousedown',mouseDownCallback);
tableObserver.listenersToRemove.add(function(){return editorWindow.removeEventListener('mousedown',mouseDownCallback);});
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_ARROW_DOWN_COMMAND,function(event){return $handleArrowKey(editor,event,'down',tableNode,tableObserver);},require("Lexical").COMMAND_PRIORITY_HIGH));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_ARROW_UP_COMMAND,function(event){return $handleArrowKey(editor,event,'up',tableNode,tableObserver);},require("Lexical").COMMAND_PRIORITY_HIGH));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_ARROW_LEFT_COMMAND,function(event){return $handleArrowKey(editor,event,'backward',tableNode,tableObserver);},require("Lexical").COMMAND_PRIORITY_HIGH));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_ARROW_RIGHT_COMMAND,function(event){return $handleArrowKey(editor,event,'forward',tableNode,tableObserver);},require("Lexical").COMMAND_PRIORITY_HIGH));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_ESCAPE_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if($isTableSelection(selection)){
var focusCellNode=require("LexicalUtils").$findMatchingParent(selection.focus.getNode(),$isTableCellNode);
if($isTableCellNode(focusCellNode)){
stopEvent(event);
focusCellNode.selectEnd();
return true;
}
}
return false;
},require("Lexical").COMMAND_PRIORITY_HIGH));
var deleteTextHandler=function deleteTextHandler(command){return function(){
var selection=require("Lexical").$getSelection();
if(!$isSelectionInTable(selection,tableNode)){
return false;
}
if($isTableSelection(selection)){
tableObserver.clearText();
return true;
}else if(require("Lexical").$isRangeSelection(selection)){
var tableCellNode=require("LexicalUtils").$findMatchingParent(selection.anchor.getNode(),function(n){return $isTableCellNode(n);});
if(!$isTableCellNode(tableCellNode)){
return false;
}
var anchorNode=selection.anchor.getNode();
var focusNode=selection.focus.getNode();
var isAnchorInside=tableNode.isParentOf(anchorNode);
var isFocusInside=tableNode.isParentOf(focusNode);
var selectionContainsPartialTable=isAnchorInside&&!isFocusInside||isFocusInside&&!isAnchorInside;
if(selectionContainsPartialTable){
tableObserver.clearText();
return true;
}
var nearestElementNode=require("LexicalUtils").$findMatchingParent(selection.anchor.getNode(),function(n){return require("Lexical").$isElementNode(n);});
var topLevelCellElementNode=nearestElementNode&&require("LexicalUtils").$findMatchingParent(nearestElementNode,function(n){return require("Lexical").$isElementNode(n)&&$isTableCellNode(n.getParent());});
if(!require("Lexical").$isElementNode(topLevelCellElementNode)||!require("Lexical").$isElementNode(nearestElementNode)){
return false;
}
if(command===require("Lexical").DELETE_LINE_COMMAND&&topLevelCellElementNode.getPreviousSibling()===null){

return true;
}
if(command===require("Lexical").DELETE_CHARACTER_COMMAND||command===require("Lexical").DELETE_WORD_COMMAND){
if(selection.isCollapsed()&&selection.anchor.offset===0){
if(nearestElementNode!==topLevelCellElementNode){
var children=nearestElementNode.getChildren();
var newParagraphNode=require("Lexical").$createParagraphNode();
children.forEach(function(child){return newParagraphNode.append(child);});
nearestElementNode.replace(newParagraphNode);
nearestElementNode.getWritable().__parent=tableCellNode.getKey();
return true;
}
}
}
}
return false;
};};
[require("Lexical").DELETE_WORD_COMMAND,require("Lexical").DELETE_LINE_COMMAND,require("Lexical").DELETE_CHARACTER_COMMAND].forEach(function(command){
tableObserver.listenersToRemove.add(editor.registerCommand(command,deleteTextHandler(command),require("Lexical").COMMAND_PRIORITY_CRITICAL));
});
var deleteCellHandler=function deleteCellHandler(event){
var selection=require("Lexical").$getSelection();
if(!$isSelectionInTable(selection,tableNode)){
return false;
}
if($isTableSelection(selection)){
event.preventDefault();
event.stopPropagation();
tableObserver.clearText();
return true;
}else if(require("Lexical").$isRangeSelection(selection)){
var tableCellNode=require("LexicalUtils").$findMatchingParent(selection.anchor.getNode(),function(n){return $isTableCellNode(n);});
if(!$isTableCellNode(tableCellNode)){
return false;
}
}
return false;
};
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_BACKSPACE_COMMAND,deleteCellHandler,require("Lexical").COMMAND_PRIORITY_CRITICAL));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_DELETE_COMMAND,deleteCellHandler,require("Lexical").COMMAND_PRIORITY_CRITICAL));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").FORMAT_TEXT_COMMAND,function(payload){
var selection=require("Lexical").$getSelection();
if(!$isSelectionInTable(selection,tableNode)){
return false;
}
if($isTableSelection(selection)){
tableObserver.formatCells(payload);
return true;
}else if(require("Lexical").$isRangeSelection(selection)){
var tableCellNode=require("LexicalUtils").$findMatchingParent(selection.anchor.getNode(),function(n){return $isTableCellNode(n);});
if(!$isTableCellNode(tableCellNode)){
return false;
}
}
return false;
},require("Lexical").COMMAND_PRIORITY_CRITICAL));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").CONTROLLED_TEXT_INSERTION_COMMAND,function(payload){
var selection=require("Lexical").$getSelection();
if(!$isSelectionInTable(selection,tableNode)){
return false;
}
if($isTableSelection(selection)){
tableObserver.clearHighlight();
return false;
}else if(require("Lexical").$isRangeSelection(selection)){
var tableCellNode=require("LexicalUtils").$findMatchingParent(selection.anchor.getNode(),function(n){return $isTableCellNode(n);});
if(!$isTableCellNode(tableCellNode)){
return false;
}
}
return false;
},require("Lexical").COMMAND_PRIORITY_CRITICAL));
if(hasTabHandler){
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").KEY_TAB_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)||!selection.isCollapsed()||!$isSelectionInTable(selection,tableNode)){
return false;
}
var tableCellNode=$findCellNode(selection.anchor.getNode());
if(tableCellNode===null){
return false;
}
stopEvent(event);
var currentCords=tableNode.getCordsFromCellNode(tableCellNode,tableObserver.table);
selectTableNodeInDirection(tableObserver,tableNode,currentCords.x,currentCords.y,!event.shiftKey?'forward':'backward');
return true;
},require("Lexical").COMMAND_PRIORITY_CRITICAL));
}
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").FOCUS_COMMAND,function(payload){
return tableNode.isSelected();
},require("Lexical").COMMAND_PRIORITY_HIGH));
function getObserverCellFromCellNode(tableCellNode){
var currentCords=tableNode.getCordsFromCellNode(tableCellNode,tableObserver.table);
return tableNode.getDOMCellFromCordsOrThrow(currentCords.x,currentCords.y,tableObserver.table);
}
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").SELECTION_INSERT_CLIPBOARD_NODES_COMMAND,function(selectionPayload){var

nodes=

selectionPayload.nodes,selection=selectionPayload.selection;
var anchorAndFocus=selection.getStartEndPoints();
var isTableSelection=$isTableSelection(selection);
var isRangeSelection=require("Lexical").$isRangeSelection(selection);
var isSelectionInsideOfGrid=isRangeSelection&&require("LexicalUtils").$findMatchingParent(selection.anchor.getNode(),function(n){return $isTableCellNode(n);})!==null&&require("LexicalUtils").$findMatchingParent(selection.focus.getNode(),function(n){return $isTableCellNode(n);})!==null||isTableSelection;
if(nodes.length!==1||!$isTableNode(nodes[0])||!isSelectionInsideOfGrid||anchorAndFocus===null){
return false;
}var
anchor=anchorAndFocus[0];
var newGrid=nodes[0];
var newGridRows=newGrid.getChildren();
var newColumnCount=newGrid.getFirstChildOrThrow().getChildrenSize();
var newRowCount=newGrid.getChildrenSize();
var gridCellNode=require("LexicalUtils").$findMatchingParent(anchor.getNode(),function(n){return $isTableCellNode(n);});
var gridRowNode=gridCellNode&&require("LexicalUtils").$findMatchingParent(gridCellNode,function(n){return $isTableRowNode(n);});
var gridNode=gridRowNode&&require("LexicalUtils").$findMatchingParent(gridRowNode,function(n){return $isTableNode(n);});
if(!$isTableCellNode(gridCellNode)||!$isTableRowNode(gridRowNode)||!$isTableNode(gridNode)){
return false;
}
var startY=gridRowNode.getIndexWithinParent();
var stopY=Math.min(gridNode.getChildrenSize()-1,startY+newRowCount-1);
var startX=gridCellNode.getIndexWithinParent();
var stopX=Math.min(gridRowNode.getChildrenSize()-1,startX+newColumnCount-1);
var fromX=Math.min(startX,stopX);
var fromY=Math.min(startY,stopY);
var toX=Math.max(startX,stopX);
var toY=Math.max(startY,stopY);
var gridRowNodes=gridNode.getChildren();
var newRowIdx=0;
var newAnchorCellKey;
var newFocusCellKey;
for(var r=fromY;r<=toY;r++){
var currentGridRowNode=gridRowNodes[r];
if(!$isTableRowNode(currentGridRowNode)){
return false;
}
var newGridRowNode=newGridRows[newRowIdx];
if(!$isTableRowNode(newGridRowNode)){
return false;
}
var gridCellNodes=currentGridRowNode.getChildren();
var newGridCellNodes=newGridRowNode.getChildren();
var newColumnIdx=0;var _loop=function _loop(
c){
var currentGridCellNode=gridCellNodes[c];
if(!$isTableCellNode(currentGridCellNode)){
return{v:false};
}
var newGridCellNode=newGridCellNodes[newColumnIdx];
if(!$isTableCellNode(newGridCellNode)){
return{v:false};
}
if(r===fromY&&c===fromX){
newAnchorCellKey=currentGridCellNode.getKey();
}else if(r===toY&&c===toX){
newFocusCellKey=currentGridCellNode.getKey();
}
var originalChildren=currentGridCellNode.getChildren();
newGridCellNode.getChildren().forEach(function(child){
if(require("Lexical").$isTextNode(child)){
var paragraphNode=require("Lexical").$createParagraphNode();
paragraphNode.append(child);
currentGridCellNode.append(child);
}else{
currentGridCellNode.append(child);
}
});
originalChildren.forEach(function(n){return n.remove();});
newColumnIdx++;};for(var c=fromX;c<=toX;c++){var _ret=_loop(c);if(typeof _ret==="object")return _ret.v;
}
newRowIdx++;
}
if(newAnchorCellKey&&newFocusCellKey){
var newTableSelection=$createTableSelection();
newTableSelection.set(nodes[0].getKey(),newAnchorCellKey,newFocusCellKey);
require("Lexical").$setSelection(newTableSelection);
}
return true;
},require("Lexical").COMMAND_PRIORITY_CRITICAL));
tableObserver.listenersToRemove.add(editor.registerCommand(require("Lexical").SELECTION_CHANGE_COMMAND,function(){
var selection=require("Lexical").$getSelection();
var prevSelection=require("Lexical").$getPreviousSelection();
if(require("Lexical").$isRangeSelection(selection)){var

anchor=

selection.anchor,focus=selection.focus;
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();


var anchorCellNode=$findCellNode(anchorNode);
var focusCellNode=$findCellNode(focusNode);
var isAnchorInside=!!(anchorCellNode&&tableNode.is($findTableNode(anchorCellNode)));
var isFocusInside=!!(focusCellNode&&tableNode.is($findTableNode(focusCellNode)));
var isPartialyWithinTable=isAnchorInside!==isFocusInside;
var isWithinTable=isAnchorInside&&isFocusInside;
var isBackward=selection.isBackward();
if(isPartialyWithinTable){
var newSelection=selection.clone();
newSelection.focus.set(tableNode.getKey(),isBackward?0:tableNode.getChildrenSize(),'element');
require("Lexical").$setSelection(newSelection);
$addHighlightStyleToTable(editor,tableObserver);
}else if(isWithinTable){


if(!anchorCellNode.is(focusCellNode)){
tableObserver.setAnchorCellForSelection(getObserverCellFromCellNode(anchorCellNode));
tableObserver.setFocusCellForSelection(getObserverCellFromCellNode(focusCellNode),true);
}
}
}
if(selection&&!selection.is(prevSelection)&&($isTableSelection(selection)||$isTableSelection(prevSelection))&&tableObserver.tableSelection&&!tableObserver.tableSelection.is(prevSelection)){
if($isTableSelection(selection)&&selection.tableKey===tableObserver.tableNodeKey){
tableObserver.updateTableTableSelection(selection);
}else if(!$isTableSelection(selection)&&$isTableSelection(prevSelection)&&prevSelection.tableKey===tableObserver.tableNodeKey){
tableObserver.updateTableTableSelection(null);
}
return false;
}
if(tableObserver.hasHijackedSelectionStyles&&!tableNode.isSelected()){
$removeHighlightStyleToTable(editor,tableObserver);
}else if(!tableObserver.hasHijackedSelectionStyles&&tableNode.isSelected()){
$addHighlightStyleToTable(editor,tableObserver);
}
return false;
},require("Lexical").COMMAND_PRIORITY_CRITICAL));
return tableObserver;
}
function attachTableObserverToTableElement(tableElement,tableObserver){
tableElement[LEXICAL_ELEMENT_KEY]=tableObserver;
}
function getTableObserverFromTableElement(tableElement){
return tableElement[LEXICAL_ELEMENT_KEY];
}
function getDOMCellFromTarget(node){
var currentNode=node;
while(currentNode!=null){
var nodeName=currentNode.nodeName;
if(nodeName==='TD'||nodeName==='TH'){

var cell=currentNode._cell;
if(cell===undefined){
return null;
}
return cell;
}
currentNode=currentNode.parentNode;
}
return null;
}
function getTable(tableElement){
var domRows=[];
var grid={
columns:0,
domRows:domRows,
rows:0};

var currentNode=tableElement.firstChild;
var x=0;
var y=0;
domRows.length=0;
while(currentNode!=null){
var nodeMame=currentNode.nodeName;
if(nodeMame==='TD'||nodeMame==='TH'){
var elem=currentNode;
var cell={
elem:elem,
hasBackgroundColor:elem.style.backgroundColor!=='',
highlighted:false,
x:x,
y:y};



currentNode._cell=cell;
var row=domRows[y];
if(row===undefined){
row=domRows[y]=[];
}
row[x]=cell;
}else{
var child=currentNode.firstChild;
if(child!=null){
currentNode=child;
continue;
}
}
var sibling=currentNode.nextSibling;
if(sibling!=null){
x++;
currentNode=sibling;
continue;
}
var parent=currentNode.parentNode;
if(parent!=null){
var parentSibling=parent.nextSibling;
if(parentSibling==null){
break;
}
y++;
x=0;
currentNode=parentSibling;
}
}
grid.columns=x+1;
grid.rows=y+1;
return grid;
}
function $updateDOMForSelection(editor,table,selection){
var selectedCellNodes=new Set(selection?selection.getNodes():[]);
$forEachTableCell(table,function(cell,lexicalNode){
var elem=cell.elem;
if(selectedCellNodes.has(lexicalNode)){
cell.highlighted=true;
$addHighlightToDOM(editor,cell);
}else{
cell.highlighted=false;
$removeHighlightFromDOM(editor,cell);
if(!elem.getAttribute('style')){
elem.removeAttribute('style');
}
}
});
}
function $forEachTableCell(grid,cb){var

domRows=
grid.domRows;
for(var y=0;y<domRows.length;y++){
var row=domRows[y];
if(!row){
continue;
}
for(var x=0;x<row.length;x++){
var cell=row[x];
if(!cell){
continue;
}
var lexicalNode=require("Lexical").$getNearestNodeFromDOMNode(cell.elem);
if(lexicalNode!==null){
cb(cell,lexicalNode,{
x:x,
y:y});

}
}
}
}
function $addHighlightStyleToTable(editor,tableSelection){
tableSelection.disableHighlightStyle();
$forEachTableCell(tableSelection.table,function(cell){
cell.highlighted=true;
$addHighlightToDOM(editor,cell);
});
}
function $removeHighlightStyleToTable(editor,tableObserver){
tableObserver.enableHighlightStyle();
$forEachTableCell(tableObserver.table,function(cell){
var elem=cell.elem;
cell.highlighted=false;
$removeHighlightFromDOM(editor,cell);
if(!elem.getAttribute('style')){
elem.removeAttribute('style');
}
});
}
var selectTableNodeInDirection=function selectTableNodeInDirection(tableObserver,tableNode,x,y,direction){
var isForward=direction==='forward';
switch(direction){
case'backward':
case'forward':
if(x!==(isForward?tableObserver.table.columns-1:0)){
selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(x+(isForward?1:-1),y,tableObserver.table),isForward);
}else{
if(y!==(isForward?tableObserver.table.rows-1:0)){
selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(isForward?0:tableObserver.table.columns-1,y+(isForward?1:-1),tableObserver.table),isForward);
}else if(!isForward){
tableNode.selectPrevious();
}else{
tableNode.selectNext();
}
}
return true;
case'up':
if(y!==0){
selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(x,y-1,tableObserver.table),false);
}else{
tableNode.selectPrevious();
}
return true;
case'down':
if(y!==tableObserver.table.rows-1){
selectTableCellNode(tableNode.getCellNodeFromCordsOrThrow(x,y+1,tableObserver.table),true);
}else{
tableNode.selectNext();
}
return true;
default:
return false;}

};
var adjustFocusNodeInDirection=function adjustFocusNodeInDirection(tableObserver,tableNode,x,y,direction){
var isForward=direction==='forward';
switch(direction){
case'backward':
case'forward':
if(x!==(isForward?tableObserver.table.columns-1:0)){
tableObserver.setFocusCellForSelection(tableNode.getDOMCellFromCordsOrThrow(x+(isForward?1:-1),y,tableObserver.table));
}
return true;
case'up':
if(y!==0){
tableObserver.setFocusCellForSelection(tableNode.getDOMCellFromCordsOrThrow(x,y-1,tableObserver.table));
return true;
}else{
return false;
}
case'down':
if(y!==tableObserver.table.rows-1){
tableObserver.setFocusCellForSelection(tableNode.getDOMCellFromCordsOrThrow(x,y+1,tableObserver.table));
return true;
}else{
return false;
}
default:
return false;}

};
function $isSelectionInTable(selection,tableNode){
if(require("Lexical").$isRangeSelection(selection)||$isTableSelection(selection)){
var isAnchorInside=tableNode.isParentOf(selection.anchor.getNode());
var isFocusInside=tableNode.isParentOf(selection.focus.getNode());
return isAnchorInside&&isFocusInside;
}
return false;
}
function selectTableCellNode(tableCell,fromStart){
if(fromStart){
tableCell.selectStart();
}else{
tableCell.selectEnd();
}
}
var BROWSER_BLUE_RGB='172,206,247';
function $addHighlightToDOM(editor,cell){
var element=cell.elem;
var node=require("Lexical").$getNearestNodeFromDOMNode(element);
if(!$isTableCellNode(node)){
throw Error("Expected to find LexicalNode from Table Cell DOMNode");
}
var backgroundColor=node.getBackgroundColor();
if(backgroundColor===null){
element.style.setProperty('background-color',"rgb("+BROWSER_BLUE_RGB+")");
}else{
element.style.setProperty('background-image',"linear-gradient(to right, rgba("+BROWSER_BLUE_RGB+",0.85), rgba("+BROWSER_BLUE_RGB+",0.85))");
}
element.style.setProperty('caret-color','transparent');
}
function $removeHighlightFromDOM(editor,cell){
var element=cell.elem;
var node=require("Lexical").$getNearestNodeFromDOMNode(element);
if(!$isTableCellNode(node)){
throw Error("Expected to find LexicalNode from Table Cell DOMNode");
}
var backgroundColor=node.getBackgroundColor();
if(backgroundColor===null){
element.style.removeProperty('background-color');
}
element.style.removeProperty('background-image');
element.style.removeProperty('caret-color');
}
function $findCellNode(node){
var cellNode=require("LexicalUtils").$findMatchingParent(node,$isTableCellNode);
return $isTableCellNode(cellNode)?cellNode:null;
}
function $findTableNode(node){
var tableNode=require("LexicalUtils").$findMatchingParent(node,$isTableNode);
return $isTableNode(tableNode)?tableNode:null;
}
function $handleArrowKey(editor,event,direction,tableNode,tableObserver){
var selection=require("Lexical").$getSelection();
if(!$isSelectionInTable(selection,tableNode)){
return false;
}
if(require("Lexical").$isRangeSelection(selection)&&selection.isCollapsed()){


if(direction==='backward'||direction==='forward'){
return false;
}var

anchor=

selection.anchor,focus=selection.focus;
var anchorCellNode=require("LexicalUtils").$findMatchingParent(anchor.getNode(),$isTableCellNode);
var focusCellNode=require("LexicalUtils").$findMatchingParent(focus.getNode(),$isTableCellNode);
if(!$isTableCellNode(anchorCellNode)||!anchorCellNode.is(focusCellNode)){
return false;
}
var anchorCellTable=$findTableNode(anchorCellNode);
if(anchorCellTable!==tableNode&&anchorCellTable!=null){
var anchorCellTableElement=editor.getElementByKey(anchorCellTable.getKey());
if(anchorCellTableElement!=null){
tableObserver.table=getTable(anchorCellTableElement);
return $handleArrowKey(editor,event,direction,anchorCellTable,tableObserver);
}
}
var anchorCellDom=editor.getElementByKey(anchorCellNode.__key);
var anchorDOM=editor.getElementByKey(anchor.key);
if(anchorDOM==null||anchorCellDom==null){
return false;
}
var edgeSelectionRect;
if(anchor.type==='element'){
edgeSelectionRect=anchorDOM.getBoundingClientRect();
}else{
var domSelection=window.getSelection();
if(domSelection===null||domSelection.rangeCount===0){
return false;
}
var range=domSelection.getRangeAt(0);
edgeSelectionRect=range.getBoundingClientRect();
}
var edgeChild=direction==='up'?anchorCellNode.getFirstChild():anchorCellNode.getLastChild();
if(edgeChild==null){
return false;
}
var edgeChildDOM=editor.getElementByKey(edgeChild.__key);
if(edgeChildDOM==null){
return false;
}
var edgeRect=edgeChildDOM.getBoundingClientRect();
var isExiting=direction==='up'?edgeRect.top>edgeSelectionRect.top-edgeSelectionRect.height:edgeSelectionRect.bottom+edgeSelectionRect.height>edgeRect.bottom;
if(isExiting){
stopEvent(event);
var cords=tableNode.getCordsFromCellNode(anchorCellNode,tableObserver.table);
if(event.shiftKey){
var cell=tableNode.getDOMCellFromCordsOrThrow(cords.x,cords.y,tableObserver.table);
tableObserver.setAnchorCellForSelection(cell);
tableObserver.setFocusCellForSelection(cell,true);
}else{
return selectTableNodeInDirection(tableObserver,tableNode,cords.x,cords.y,direction);
}
return true;
}
}else if($isTableSelection(selection)){var

_anchor=

selection.anchor,_focus=selection.focus;
var _anchorCellNode=require("LexicalUtils").$findMatchingParent(_anchor.getNode(),$isTableCellNode);
var _focusCellNode=require("LexicalUtils").$findMatchingParent(_focus.getNode(),$isTableCellNode);var _selection$getNodes=
selection.getNodes(),tableNodeFromSelection=_selection$getNodes[0];
var tableElement=editor.getElementByKey(tableNodeFromSelection.getKey());
if(!$isTableCellNode(_anchorCellNode)||!$isTableCellNode(_focusCellNode)||!$isTableNode(tableNodeFromSelection)||tableElement==null){
return false;
}
tableObserver.updateTableTableSelection(selection);
var grid=getTable(tableElement);
var cordsAnchor=tableNode.getCordsFromCellNode(_anchorCellNode,grid);
var anchorCell=tableNode.getDOMCellFromCordsOrThrow(cordsAnchor.x,cordsAnchor.y,grid);
tableObserver.setAnchorCellForSelection(anchorCell);
stopEvent(event);
if(event.shiftKey){
var _cords=tableNode.getCordsFromCellNode(_focusCellNode,grid);
return adjustFocusNodeInDirection(tableObserver,tableNodeFromSelection,_cords.x,_cords.y,direction);
}else{
_focusCellNode.selectEnd();
}
return true;
}
return false;
}
function stopEvent(event){
event.preventDefault();
event.stopImmediatePropagation();
event.stopPropagation();
}var









TableNode=function(_Lexical$ElementNode3){babelHelpers.inheritsLoose(TableNode,_Lexical$ElementNode3);TableNode.
getType=function getType(){
return'table';
};TableNode.
clone=function clone(node){
return new TableNode(node.__key);
};TableNode.
importDOM=function importDOM(){
return{
table:function table(_node){return{
conversion:convertTableElement,
priority:1};}};


};TableNode.
importJSON=function importJSON(_serializedNode){
return $createTableNode();
};
function TableNode(key){return(
_Lexical$ElementNode3.call(this,key)||this);
}var _proto5=TableNode.prototype;_proto5.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode3.prototype.
exportJSON.call(this),{
type:'table',
version:1});

};_proto5.
createDOM=function createDOM(config,editor){
var tableElement=document.createElement('table');
require("LexicalUtils").addClassNamesToElement(tableElement,config.theme.table);
return tableElement;
};_proto5.
updateDOM=function updateDOM(){
return false;
};_proto5.
exportDOM=function exportDOM(editor){var _this11=this;
return babelHelpers["extends"]({},_Lexical$ElementNode3.prototype.
exportDOM.call(this,editor),{
after:function after(tableElement){
if(tableElement){
var newElement=tableElement.cloneNode();
var colGroup=document.createElement('colgroup');
var tBody=document.createElement('tbody');
if(require("LexicalUtils").isHTMLElement(tableElement)){
tBody.append.apply(tBody,tableElement.children);
}
var firstRow=_this11.getFirstChildOrThrow();
if(!$isTableRowNode(firstRow)){
throw new Error('Expected to find row node.');
}
var colCount=firstRow.getChildrenSize();
for(var i=0;i<colCount;i++){
var col=document.createElement('col');
colGroup.append(col);
}
newElement.replaceChildren(colGroup,tBody);
return newElement;
}
}});

};_proto5.
canBeEmpty=function canBeEmpty(){
return false;
};_proto5.
isShadowRoot=function isShadowRoot(){
return true;
};_proto5.
getCordsFromCellNode=function getCordsFromCellNode(tableCellNode,table){var

rows=

table.rows,domRows=table.domRows;
for(var y=0;y<rows;y++){
var row=domRows[y];
if(row==null){
continue;
}
var x=row.findIndex(function(cell){
if(!cell)return;var

elem=
cell.elem;
var cellNode=require("Lexical").$getNearestNodeFromDOMNode(elem);
return cellNode===tableCellNode;
});
if(x!==-1){
return{
x:x,
y:y};

}
}
throw new Error('Cell not found in table.');
};_proto5.
getDOMCellFromCords=function getDOMCellFromCords(x,y,table){var

domRows=
table.domRows;
var row=domRows[y];
if(row==null){
return null;
}
var cell=row[x];
if(cell==null){
return null;
}
return cell;
};_proto5.
getDOMCellFromCordsOrThrow=function getDOMCellFromCordsOrThrow(x,y,table){
var cell=this.getDOMCellFromCords(x,y,table);
if(!cell){
throw new Error('Cell not found at cords.');
}
return cell;
};_proto5.
getCellNodeFromCords=function getCellNodeFromCords(x,y,table){
var cell=this.getDOMCellFromCords(x,y,table);
if(cell==null){
return null;
}
var node=require("Lexical").$getNearestNodeFromDOMNode(cell.elem);
if($isTableCellNode(node)){
return node;
}
return null;
};_proto5.
getCellNodeFromCordsOrThrow=function getCellNodeFromCordsOrThrow(x,y,table){
var node=this.getCellNodeFromCords(x,y,table);
if(!node){
throw new Error('Node at cords not TableCellNode.');
}
return node;
};_proto5.
canSelectBefore=function canSelectBefore(){
return true;
};_proto5.
canIndent=function canIndent(){
return false;
};return TableNode;}(require("Lexical").ElementNode);

function $getElementForTableNode(editor,tableNode){
var tableElement=editor.getElementByKey(tableNode.getKey());
if(tableElement==null){
throw new Error('Table Element Not Found');
}
return getTable(tableElement);
}
function convertTableElement(_domNode){
return{
node:$createTableNode()};

}
function $createTableNode(){
return require("Lexical").$applyNodeReplacement(new TableNode());
}
function $isTableNode(node){
return node instanceof TableNode;
}

exports.$computeTableMap=$computeTableMap;
exports.$createTableCellNode=$createTableCellNode;
exports.$createTableNode=$createTableNode;
exports.$createTableNodeWithDimensions=$createTableNodeWithDimensions;
exports.$createTableRowNode=$createTableRowNode;
exports.$createTableSelection=$createTableSelection;
exports.$deleteTableColumn=$deleteTableColumn;
exports.$deleteTableColumn__EXPERIMENTAL=$deleteTableColumn__EXPERIMENTAL;
exports.$deleteTableRow__EXPERIMENTAL=$deleteTableRow__EXPERIMENTAL;
exports.$getElementForTableNode=$getElementForTableNode;
exports.$getNodeTriplet=$getNodeTriplet;
exports.$getTableCellNodeFromLexicalNode=$getTableCellNodeFromLexicalNode;
exports.$getTableCellNodeRect=$getTableCellNodeRect;
exports.$getTableColumnIndexFromTableCellNode=$getTableColumnIndexFromTableCellNode;
exports.$getTableNodeFromLexicalNodeOrThrow=$getTableNodeFromLexicalNodeOrThrow;
exports.$getTableRowIndexFromTableCellNode=$getTableRowIndexFromTableCellNode;
exports.$getTableRowNodeFromTableCellNodeOrThrow=$getTableRowNodeFromTableCellNodeOrThrow;
exports.$insertTableColumn=$insertTableColumn;
exports.$insertTableColumn__EXPERIMENTAL=$insertTableColumn__EXPERIMENTAL;
exports.$insertTableRow=$insertTableRow;
exports.$insertTableRow__EXPERIMENTAL=$insertTableRow__EXPERIMENTAL;
exports.$isTableCellNode=$isTableCellNode;
exports.$isTableNode=$isTableNode;
exports.$isTableRowNode=$isTableRowNode;
exports.$isTableSelection=$isTableSelection;
exports.$removeTableRowAtIndex=$removeTableRowAtIndex;
exports.$unmergeCell=$unmergeCell;
exports.INSERT_TABLE_COMMAND=INSERT_TABLE_COMMAND;
exports.TableCellHeaderStates=TableCellHeaderStates;
exports.TableCellNode=TableCellNode;
exports.TableNode=TableNode;
exports.TableObserver=TableObserver;
exports.TableRowNode=TableRowNode;
exports.applyTableHandlers=applyTableHandlers;
exports.getDOMCellFromTarget=getDOMCellFromTarget;
exports.getTableObserverFromTableElement=getTableObserverFromTableElement;}),null);