/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalLinkPlugin.dev",["Lexical","LexicalComposerContext","LexicalLink","LexicalUtils","react"],(function $module_LexicalLinkPlugin_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;





var react=_require_closure_react||(_require_closure_react=require("react"));








function LinkPlugin(_ref)

{var validateUrl=_ref.validateUrl;var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];
react.useEffect(function(){
if(!editor.hasNodes([require("LexicalLink").LinkNode])){
throw new Error('LinkPlugin: LinkNode not registered on editor');
}
return require("LexicalUtils").mergeRegister(editor.registerCommand(require("LexicalLink").TOGGLE_LINK_COMMAND,function(payload){
if(payload===null){
require("LexicalLink").toggleLink(payload);
return true;
}else if(typeof payload==='string'){
if(validateUrl===undefined||validateUrl(payload)){
require("LexicalLink").toggleLink(payload);
return true;
}
return false;
}else{var

url=



payload.url,target=payload.target,rel=payload.rel,title=payload.title;
require("LexicalLink").toggleLink(url,{
rel:rel,
target:target,
title:title});

return true;
}
},require("Lexical").COMMAND_PRIORITY_LOW),validateUrl!==undefined?editor.registerCommand(require("Lexical").PASTE_COMMAND,function(event){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)||selection.isCollapsed()||!(event instanceof ClipboardEvent)||event.clipboardData==null){
return false;
}
var clipboardText=event.clipboardData.getData('text');
if(!validateUrl(clipboardText)){
return false;
}

if(!selection.getNodes().some(function(node){return require("Lexical").$isElementNode(node);})){
editor.dispatchCommand(require("LexicalLink").TOGGLE_LINK_COMMAND,clipboardText);
event.preventDefault();
return true;
}
return false;
},require("Lexical").COMMAND_PRIORITY_LOW):function(){

});
},[editor,validateUrl]);
return null;
}

exports.LinkPlugin=LinkPlugin;}),null);