/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalTablePlugin.dev",["Lexical","LexicalComposerContext","LexicalTable","LexicalUtils","react"],(function $module_LexicalTablePlugin_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;





var react=_require_closure_react||(_require_closure_react=require("react"));








function TablePlugin(_ref)



{var _ref$hasCellMerge=_ref.hasCellMerge,hasCellMerge=_ref$hasCellMerge===void 0?true:_ref$hasCellMerge,_ref$hasCellBackgroun=_ref.hasCellBackgroundColor,hasCellBackgroundColor=_ref$hasCellBackgroun===void 0?true:_ref$hasCellBackgroun,_ref$hasTabHandler=_ref.hasTabHandler,hasTabHandler=_ref$hasTabHandler===void 0?true:_ref$hasTabHandler;var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];
react.useEffect(function(){
if(!editor.hasNodes([require("LexicalTable").TableNode,require("LexicalTable").TableCellNode,require("LexicalTable").TableRowNode])){
{
throw Error("TablePlugin: TableNode, TableCellNode or TableRowNode not registered on editor");
}
}
return editor.registerCommand(require("LexicalTable").INSERT_TABLE_COMMAND,function(_ref2)



{var columns=_ref2.columns,rows=_ref2.rows,includeHeaders=_ref2.includeHeaders;
var tableNode=require("LexicalTable").$createTableNodeWithDimensions(Number(rows),Number(columns),includeHeaders);
require("LexicalUtils").$insertNodeToNearestRoot(tableNode);
var firstDescendant=tableNode.getFirstDescendant();
if(require("Lexical").$isTextNode(firstDescendant)){
firstDescendant.select();
}
return true;
},require("Lexical").COMMAND_PRIORITY_EDITOR);
},[editor]);
react.useEffect(function(){
var tableSelections=new Map();
var initializeTableNode=function initializeTableNode(tableNode){
var nodeKey=tableNode.getKey();
var tableElement=editor.getElementByKey(nodeKey);
if(tableElement&&!tableSelections.has(nodeKey)){
var tableSelection=require("LexicalTable").applyTableHandlers(tableNode,tableElement,editor,hasTabHandler);
tableSelections.set(nodeKey,tableSelection);
}
};



editor.getEditorState().read(function(){
var tableNodes=require("Lexical").$nodesOfType(require("LexicalTable").TableNode);
for(var _iterator=tableNodes,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref3;if(_isArray){if(_i>=_iterator.length)break;_ref3=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref3=_i.value;}var tableNode=_ref3;
if(require("LexicalTable").$isTableNode(tableNode)){
initializeTableNode(tableNode);
}
}
});
var unregisterMutationListener=editor.registerMutationListener(require("LexicalTable").TableNode,function(nodeMutations){var _loop=function _loop(){if(_isArray2){if(_i2>=_iterator2.length)return"break";_ref5=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)return"break";_ref5=_i2.value;}var _ref4=_ref5;var
nodeKey=_ref4[0];var mutation=_ref4[1];
if(mutation==='created'){
editor.getEditorState().read(function(){
var tableNode=require("Lexical").$getNodeByKey(nodeKey);
if(require("LexicalTable").$isTableNode(tableNode)){
initializeTableNode(tableNode);
}
});
}else if(mutation==='destroyed'){
var tableSelection=tableSelections.get(nodeKey);
if(tableSelection!==undefined){
tableSelection.removeListeners();
tableSelections["delete"](nodeKey);
}
}};for(var _iterator2=nodeMutations,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref5;var _ret=_loop();if(_ret==="break")break;
}
});
return function(){
unregisterMutationListener();


for(var _iterator3=tableSelections,_isArray3=Array.isArray(_iterator3),_i3=0,_iterator3=_isArray3?_iterator3:_iterator3[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref7;if(_isArray3){if(_i3>=_iterator3.length)break;_ref7=_iterator3[_i3++];}else{_i3=_iterator3.next();if(_i3.done)break;_ref7=_i3.value;}var _ref8=_ref7;var tableSelection=_ref8[1];
tableSelection.removeListeners();
}
};
},[editor,hasTabHandler]);


react.useEffect(function(){
if(hasCellMerge){
return;
}
return editor.registerNodeTransform(require("LexicalTable").TableCellNode,function(node){
if(node.getColSpan()>1||node.getRowSpan()>1){var _LexicalTable$$getNod=


require("LexicalTable").$getNodeTriplet(node),gridNode=_LexicalTable$$getNod[2];var _LexicalTable$$comput=
require("LexicalTable").$computeTableMap(gridNode,node,node),gridMap=_LexicalTable$$comput[0];

var rowsCount=gridMap.length;
var columnsCount=gridMap[0].length;
var row=gridNode.getFirstChild();
if(!require("LexicalTable").$isTableRowNode(row)){
throw Error("Expected TableNode first child to be a RowNode");
}
var unmerged=[];
for(var i=0;i<rowsCount;i++){
if(i!==0){
row=row.getNextSibling();
if(!require("LexicalTable").$isTableRowNode(row)){
throw Error("Expected TableNode first child to be a RowNode");
}
}
var lastRowCell=null;
for(var j=0;j<columnsCount;j++){
var cellMap=gridMap[i][j];
var cell=cellMap.cell;
if(cellMap.startRow===i&&cellMap.startColumn===j){
lastRowCell=cell;
unmerged.push(cell);
}else if(cell.getColSpan()>1||cell.getRowSpan()>1){
if(!require("LexicalTable").$isTableCellNode(cell)){
throw Error("Expected TableNode cell to be a TableCellNode");
}
var newCell=require("LexicalTable").$createTableCellNode(cell.__headerState);
if(lastRowCell!==null){
lastRowCell.insertAfter(newCell);
}else{
require("LexicalUtils").$insertFirst(row,newCell);
}
}
}
}
for(var _i4=0;_i4<unmerged.length;_i4++){var _cell=unmerged[_i4];
_cell.setColSpan(1);
_cell.setRowSpan(1);
}
}
});
},[editor,hasCellMerge]);


react.useEffect(function(){
if(hasCellBackgroundColor){
return;
}
return editor.registerNodeTransform(require("LexicalTable").TableCellNode,function(node){
if(node.getBackgroundColor()!==null){
node.setBackgroundColor(null);
}
});
},[editor,hasCellBackgroundColor,hasCellMerge]);
return null;
}

exports.TablePlugin=TablePlugin;}),null);