/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalContentEditable.dev",["LexicalComposerContext","react"],(function $module_LexicalContentEditable_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;


var React=_require_closure_react||(_require_closure_react=require("react"));

function _extends(){
_extends=Object.assign?Object.assign.bind():function(target){
for(var i=1;i<arguments.length;i++){
var source=arguments[i];
for(var key in source){
if(Object.prototype.hasOwnProperty.call(source,key)){
target[key]=source[key];
}
}
}
return target;
};
return _extends.apply(this,arguments);
}









var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var useLayoutEffectImpl=CAN_USE_DOM?React.useLayoutEffect:React.useEffect;
var useLayoutEffect=useLayoutEffectImpl;

function ContentEditable(_ref)



















{var ariaActiveDescendant=_ref.ariaActiveDescendant,ariaAutoComplete=_ref.ariaAutoComplete,ariaControls=_ref.ariaControls,ariaDescribedBy=_ref.ariaDescribedBy,ariaExpanded=_ref.ariaExpanded,ariaLabel=_ref.ariaLabel,ariaLabelledBy=_ref.ariaLabelledBy,ariaMultiline=_ref.ariaMultiline,ariaOwns=_ref.ariaOwns,ariaRequired=_ref.ariaRequired,autoCapitalize=_ref.autoCapitalize,className=_ref.className,id=_ref.id,_ref$role=_ref.role,role=_ref$role===void 0?'textbox':_ref$role,_ref$spellCheck=_ref.spellCheck,spellCheck=_ref$spellCheck===void 0?true:_ref$spellCheck,style=_ref.style,tabIndex=_ref.tabIndex,testid=_ref['data-testid'],rest=babelHelpers.objectWithoutPropertiesLoose(_ref,["ariaActiveDescendant","ariaAutoComplete","ariaControls","ariaDescribedBy","ariaExpanded","ariaLabel","ariaLabelledBy","ariaMultiline","ariaOwns","ariaRequired","autoCapitalize","className","id","role","spellCheck","style","tabIndex","data-testid"]);var _LexicalComposerConte=
require("LexicalComposerContext").useLexicalComposerContext(),editor=_LexicalComposerConte[0];var _React$useState=
React.useState(false),isEditable=_React$useState[0],setEditable=_React$useState[1];
var ref=React.useCallback(function(rootElement){
editor.setRootElement(rootElement);
},[editor]);
useLayoutEffect(function(){
setEditable(editor.isEditable());
return editor.registerEditableListener(function(currentIsEditable){
setEditable(currentIsEditable);
});
},[editor]);
return React.createElement("div",_extends({},rest,{
"aria-activedescendant":!isEditable?undefined:ariaActiveDescendant,
"aria-autocomplete":!isEditable?'none':ariaAutoComplete,
"aria-controls":!isEditable?undefined:ariaControls,
"aria-describedby":ariaDescribedBy,
"aria-expanded":!isEditable?undefined:role==='combobox'?!!ariaExpanded:undefined,
"aria-label":ariaLabel,
"aria-labelledby":ariaLabelledBy,
"aria-multiline":ariaMultiline,
"aria-owns":!isEditable?undefined:ariaOwns,
"aria-readonly":!isEditable?true:undefined,
"aria-required":ariaRequired,
autoCapitalize:autoCapitalize,
className:className,
contentEditable:isEditable,
"data-testid":testid,
id:id,
ref:ref,
role:role,
spellCheck:spellCheck,
style:style,
tabIndex:tabIndex}));

}

exports.ContentEditable=ContentEditable;}),null);