__d("CDSFallback.fs",[],(function(a,b,c,d,e,f){a="\n  varying highp vec2 vTextureCoord;\n  varying highp vec3 vPos;\n  varying lowp float vRecompute;\n\n  uniform highp vec2 uOffset;\n  uniform sampler2D uSampler;\n\n  highp vec2 EquirectPart( highp vec3 p )\n  {\n    highp float xz = sqrt( p.x * p.x + p.z * p.z );\n    highp float lat = -atan( p.y, xz );\n    highp float t = lat / 1.57079633 / 1.01 + 0.5;\n    highp float s = atan( p.x, -p.z ) / 1.01 / (2.5 * 3.1415927) + 0.4;\n    highp vec2 st = vec2(s, t);\n    return st;\n  }\n\n  highp vec2 FacePart( highp vec3 p )\n  {\n      highp vec2 t = p.xz / p.y;\n      highp float s = sign(p.y);\n      return vec2(0.9 + t.x * s * 0.099009901,\n          0.5 - s * 0.25 - t.y * 0.247524752);\n  }\n\n  void main()\n  {\n    if (vRecompute > 0.0) {\n      highp vec3 v = normalize( vPos );\n      highp float d = length( v.xz );\n      highp vec2 t = normalize(v.xz / d + uOffset) * d;\n      v = vec3(t.x, v.y, t.y);\n      highp vec2 o;\n      if ( abs(v.y) < 0.707106781 ) {\n        o = EquirectPart( v );\n      } else {\n        o = FacePart( v );\n      }\n      gl_FragColor = texture2D( uSampler, o );\n    } else {\n      gl_FragColor = texture2D( uSampler, vTextureCoord );\n    }\n  }\n";f["default"]=a}),66);
__d("CDSFallback.vs",[],(function(a,b,c,d,e,f){a="\n  attribute vec3 aVertexPosition;\n\n  // It's actually inverse MV matrix\n  uniform mat4 uMVMatrix;\n  uniform mat4 uPMatrix;\n  uniform highp vec2 uOffset;\n\n  varying highp vec2 vTextureCoord;\n  varying highp vec3 vPos;\n  varying lowp float vRecompute;\n\n  highp vec2 EquirectPart( highp vec3 p )\n  {\n    highp float xz = sqrt( p.x * p.x + p.z * p.z );\n    highp float lat = -atan( p.y, xz );\n    highp float t = lat / 1.57079633 / 1.01 + 0.5;\n    highp float s = atan( p.x, -p.z ) / 1.01 / (2.5 * 3.1415927) + 0.4;\n    highp vec2 st = vec2(s, t);\n    return st;\n  }\n  highp vec2 FacePart( highp vec3 p )\n  {\n      highp vec2 t = p.xz / p.y;\n      highp float s = sign(p.y);\n      return vec2(0.9 + t.x * s * 0.099009901,\n          0.5 - s * 0.25 - t.y * 0.247524752);\n  }\n\n  const float eps = 0.03;\n\n  void main(void) {\n    gl_Position = uPMatrix * vec4(aVertexPosition, 1.0);\n    vPos = (uMVMatrix * vec4(aVertexPosition, 1.0)).xyz;\n    highp vec3 v = normalize( vPos );\n    highp float d = length( v.xz );\n    highp vec2 t = normalize(v.xz / d + uOffset) * d;\n    v = vec3(t.x, v.y, t.y);\n    vRecompute = 0.0;\n    if ( abs(v.y) < 0.707106781 ) {\n      vTextureCoord = EquirectPart( v );\n      vRecompute += float( vTextureCoord.x < eps * 0.5 ||\n          vTextureCoord.x > 0.8 - eps * 0.5 );\n    } else {\n      vTextureCoord = FacePart( v );\n      vRecompute += float( abs(v.y) > 1.0 - eps );\n    }\n    vRecompute += float( abs(v.y) < 0.707106781 + eps &&\n        abs(v.y) > 0.707106781 - eps );\n  }\n";f["default"]=a}),66);
__d("CDSRenderer.fs",[],(function(a,b,c,d,e,f){a="\n  varying highp vec2 vTextureCoord;\n  varying highp vec3 vPos;\n  varying lowp float vRecompute;\n  varying highp vec2 vOffset;\n\n  uniform sampler2D uSampler;\n\n  highp vec2 EquirectPart( highp vec3 p )\n  {\n    highp float xz = sqrt( p.x * p.x + p.z * p.z );\n    highp float lat = -atan( p.y, xz );\n    highp float t = lat / 1.57079633 / 1.01 + 0.5;\n    highp float s = atan( p.x, -p.z ) / 1.01 / (2.5 * 3.1415927) + 0.4;\n    highp vec2 st = vec2(s, t);\n    return st;\n  }\n\n  highp vec2 FacePart( highp vec3 p )\n  {\n      highp vec2 t = p.xz / p.y;\n      highp float s = sign(p.y);\n      return vec2(0.9 + t.x * s * 0.099009901,\n          0.5 - s * 0.25 - t.y * 0.247524752);\n  }\n\n  void main()\n  {\n    if (vRecompute > 0.0) {\n      highp vec3 v = normalize( vPos );\n      highp float d = length( v.xz );\n      highp vec2 t = normalize(v.xz / d + vOffset) * d;\n      v = vec3(t.x, v.y, t.y);\n      highp vec2 o;\n      if ( abs(v.y) < 0.707106781 ) {\n        o = EquirectPart( v );\n      } else {\n        o = FacePart( v );\n      }\n      gl_FragColor = texture2D( uSampler, o );\n    } else {\n      gl_FragColor = texture2D( uSampler, vTextureCoord );\n    }\n  }\n";f["default"]=a}),66);
__d("CDSRenderer.vs",[],(function(a,b,c,d,e,f){a="\n  attribute vec3 aVertexPosition;\n\n  uniform sampler2D uSampler;\n  // It's actually inverse MV matrix\n  uniform mat4 uMVMatrix;\n  uniform mat4 uPMatrix;\n\n  varying highp vec2 vTextureCoord;\n  varying highp vec3 vPos;\n  varying lowp float vRecompute;\n  varying highp vec2 vOffset;\n\n  highp vec2 EquirectPart( highp vec3 p )\n  {\n    highp float xz = sqrt( p.x * p.x + p.z * p.z );\n    highp float lat = -atan( p.y, xz );\n    highp float t = lat / 1.57079633 / 1.01 + 0.5;\n    highp float s = atan( p.x, -p.z ) / 1.01 / (2.5 * 3.1415927) + 0.4;\n    highp vec2 st = vec2(s, t);\n    return st;\n  }\n\n  highp vec2 FacePart( highp vec3 p )\n  {\n      highp vec2 t = p.xz / p.y;\n      highp float s = sign(p.y);\n      return vec2(0.9 + t.x * s * 0.099009901,\n          0.5 - s * 0.25 - t.y * 0.247524752);\n  }\n\n  highp vec4 extractFromSample(highp vec4 c)\n  {\n    highp float minC = min(0.5, min(c.r, min(c.g, c.b)));\n    highp float diffC = max(0.5, max(c.r, max(c.g, c.b))) - minC + 0.001;\n    return step(0.5, (c - minC) / diffC);\n  }\n\n  highp vec2 parseOffset()\n  {\n    highp float calculated_offsetX, calculated_offsetZ;\n    highp float offset_v, offset_e, offset_sig; // temp variables\n    highp vec4 texCoordsX[7], texCoordsZ[7]; // constants\n\n    texCoordsX[0] = extractFromSample(texture2D(uSampler, vec2(0.396, 1.0)));\n    texCoordsX[1] = extractFromSample(texture2D(uSampler, vec2(0.404, 1.0)));\n    texCoordsX[2] = extractFromSample(texture2D(uSampler, vec2(0.412, 1.0)));\n    texCoordsX[3] = extractFromSample(texture2D(uSampler, vec2(0.420, 1.0)));\n    texCoordsX[4] = extractFromSample(texture2D(uSampler, vec2(0.428, 1.0)));\n    texCoordsX[5] = extractFromSample(texture2D(uSampler, vec2(0.436, 1.0)));\n    texCoordsX[6] = extractFromSample(texture2D(uSampler, vec2(0.444, 1.0)));\n\n    offset_v = texCoordsX[0].r * 0.0009765625\n      + dot(texCoordsX[1].bgr, vec3(0.001953125, 0.00390625, 0.0078125))\n      + dot(texCoordsX[2].bgr, vec3(0.015625, 0.03125, 0.0625))\n      + dot(texCoordsX[3].bgr, vec3(0.125, 0.25, 0.5))\n      + 1.0;\n\n    offset_e = dot(texCoordsX[4].bgr, vec3(1.0, 2.0, 4.0))\n      + dot(texCoordsX[5].bgr, vec3(8.0, 16.0, 32.0))\n      + dot(texCoordsX[6].bg, vec2(64.0, 128.0))\n      - 127.0;\n\n    offset_sig = -2.0 * texCoordsX[6].r + 1.0;\n    calculated_offsetX = offset_sig * offset_v * pow(2.0, offset_e);\n\n\n    texCoordsZ[0] = extractFromSample(texture2D(uSampler, vec2(0.572, 1.0)));\n    texCoordsZ[1] = extractFromSample(texture2D(uSampler, vec2(0.580, 1.0)));\n    texCoordsZ[2] = extractFromSample(texture2D(uSampler, vec2(0.588, 1.0)));\n    texCoordsZ[3] = extractFromSample(texture2D(uSampler, vec2(0.596, 1.0)));\n    texCoordsZ[4] = extractFromSample(texture2D(uSampler, vec2(0.604, 1.0)));\n    texCoordsZ[5] = extractFromSample(texture2D(uSampler, vec2(0.612, 1.0)));\n    texCoordsZ[6] = extractFromSample(texture2D(uSampler, vec2(0.620, 1.0)));\n\n    offset_v = dot(texCoordsZ[0].bgr, vec3(0.0009765625, 0.001953125, 0.00390625))\n      + dot(texCoordsZ[1].bgr, vec3(0.0078125, 0.015625, 0.03125))\n      + dot(texCoordsZ[2].bgr, vec3(0.0625, 0.125, 0.25))\n      + texCoordsZ[3].b * 0.5\n      + 1.0;\n\n    offset_e = dot(texCoordsZ[3].gr, vec2(1.0, 2.0))\n      + dot(texCoordsZ[4].bgr, vec3(4.0, 8.0, 16.0))\n      + dot(texCoordsZ[5].bgr, vec3(32.0, 64.0, 128.0))\n      - 127.0;\n\n    offset_sig = 2.0 * texCoordsZ[6].b - 1.0;\n    calculated_offsetZ = offset_sig * offset_v * pow(2.0, offset_e);\n\n    return vec2(calculated_offsetX, calculated_offsetZ);\n  }\n\n  const float eps = 0.03;\n\n  void main(void) {\n    gl_Position = uPMatrix * vec4(aVertexPosition, 1.0);\n    vPos = (uMVMatrix * vec4(aVertexPosition, 1.0)).xyz;\n    highp vec3 v = normalize( vPos );\n    vOffset = parseOffset();\n    highp float d = length( v.xz );\n    highp vec2 t = normalize(v.xz / d + vOffset) * d;\n    v.xz = t.xy;\n    vRecompute = 0.0;\n    highp float abs_vy = abs(v.y);\n    if ( abs_vy < 0.707106781 ) {\n      vTextureCoord = EquirectPart( v );\n      vRecompute += float( vTextureCoord.x < eps * 0.5 ||\n          vTextureCoord.x > 0.8 - eps * 0.5 );\n    } else {\n      vTextureCoord = FacePart( v );\n      vRecompute += float( abs_vy > 1.0 - eps );\n    }\n    vRecompute += float( abs_vy < 0.707106781 + eps &&\n        abs_vy > 0.707106781 - eps );\n  }\n";f["default"]=a}),66);
__d("DefaultRenderer.fs",[],(function(a,b,c,d,e,f){a="\n  varying highp vec2 vTextureCoord;\n\n  uniform sampler2D uSampler;\n\n  void main(void) {\n    gl_FragColor = texture2D(\n      uSampler,\n      vec2(vTextureCoord.s, vTextureCoord.t)\n    );\n  }\n";f["default"]=a}),66);
__d("DefaultRenderer.vs",[],(function(a,b,c,d,e,f){a="\n  attribute vec3 aVertexPosition;\n  attribute vec2 aTextureCoord;\n\n  uniform mat4 uMVMatrix;\n  uniform mat4 uPMatrix;\n\n  varying highp vec2 vTextureCoord;\n\n  void main(void) {\n    gl_Position = uPMatrix * uMVMatrix * vec4(aVertexPosition, 1.0);\n    vTextureCoord = aTextureCoord;\n  }\n";f["default"]=a}),66);
__d("HalfEquirect.fs",[],(function(a,b,c,d,e,f){a="\n  // If changed, copy this constant to the vertex shader\n  #define FEATHER_RATIO 0.0278  // 10 / 360 degrees\n\n  uniform highp mat4 uSTMatrix;\n  uniform mediump vec2 uBoundaries;\n  uniform sampler2D uSampler;\n\n  varying highp vec2 vTextureCoord;\n  varying mediump vec4 vLeftBoundaryColor;\n  varying mediump vec4 vRightBoundaryColor;\n\n  mediump float leftBoundary;\n  mediump float rightBoundary;\n  mediump float processedX;\n\n  mediump vec4 getTextureColor() {\n    return texture2D(uSampler, (uSTMatrix * vec4(vTextureCoord, 0, 1)).xy);\n  }\n\n  mediump float getWrappedValue(mediump float value) {\n    return value + (value < leftBoundary ? 1.0 : 0.0);\n  }\n\n  mediump vec4 interpolate() {\n    mediump float interp = (processedX - rightBoundary) / (1.0 + leftBoundary - rightBoundary);\n    return mix(vRightBoundaryColor, vLeftBoundaryColor, interp);\n  }\n\n  mediump vec4 getFeatheredPixel() {\n    bool useLeftBoundary = processedX <= leftBoundary + FEATHER_RATIO;\n    mediump vec4 currColor = getTextureColor();\n    mediump vec4 boundaryColor = useLeftBoundary ? vLeftBoundaryColor : vRightBoundaryColor;\n    mediump float interp =\n      (useLeftBoundary ? (processedX - leftBoundary) : (rightBoundary - processedX))\n      / FEATHER_RATIO;\n    return mix(boundaryColor, currColor, interp);\n  }\n\n  void main(void) {\n    leftBoundary = uBoundaries.x;\n    rightBoundary = getWrappedValue(uBoundaries.y);\n\n    processedX = getWrappedValue(vTextureCoord.x);\n    bool mainImageBetweenFeatheredBounds =\n      (processedX > leftBoundary + FEATHER_RATIO)\n      && (processedX < rightBoundary - FEATHER_RATIO);\n\n    if (mainImageBetweenFeatheredBounds) {\n      gl_FragColor = getTextureColor();\n    } else if (processedX < leftBoundary || processedX > rightBoundary) {\n      gl_FragColor = interpolate();\n    } else {\n      gl_FragColor = getFeatheredPixel();\n    }\n  }\n";f["default"]=a}),66);
__d("HalfEquirect.vs",[],(function(a,b,c,d,e,f){a="\n  #define HALF_WINDOW_SIZE 20\n  #define WINDOW_SIZE 2*HALF_WINDOW_SIZE\n  #define TRIANGLE_WIDTH 0.04  // 1 / 30 triangles\n  #define INV_HEIGHT 0.005\n  #define BLUR_LENGTH float(HALF_WINDOW_SIZE)*INV_HEIGHT\n\n  // If changed, copy this definition to the fragment shader\n  #define FEATHER_RATIO 0.0278  // 10 / 360 degrees\n\n  uniform mat4 uMVMatrix;\n  uniform mat4 uPMatrix;\n  uniform mat4 uSTMatrix;\n  uniform mediump vec2 uBoundaries;\n  uniform sampler2D uSampler;\n\n  attribute vec3 aVertexPosition;\n  attribute vec2 aTextureCoord;\n\n  varying highp vec2 vTextureCoord;\n  varying mediump vec4 vLeftBoundaryColor;\n  varying mediump vec4 vRightBoundaryColor;\n\n  mediump float leftBoundary;\n  mediump float rightBoundary;\n\n  mediump float getUnWrappedValue(mediump float value) {\n    return value - (value > 1.0 ? 1.0 : 0.0);\n  }\n\n  mediump vec4 getVerticalBlurredBoundaryPixel(mediump float y, bool isLeft) {\n    mediump vec4 result = vec4(0.0);\n    mediump float boundaryFactor = FEATHER_RATIO * 0.5;\n    mediump float coordJEnd = clamp(y + BLUR_LENGTH, 0.0, 1.0);\n    mediump float coordJ = clamp(y - BLUR_LENGTH, 0.0, 1.0);\n    int numSamples = 0;\n\n    for (int j = 0; j <= WINDOW_SIZE; j++) {\n      if (coordJ > coordJEnd) {\n        break;\n      }\n      mediump float coordI = isLeft ? leftBoundary : rightBoundary;\n\n      // get boundary pixel color\n      result += texture2D(uSampler, (uSTMatrix * vec4(getUnWrappedValue(coordI), coordJ, 0, 1)).xy);\n\n      // get one more horizontal sample to average out any noise\n      coordI += boundaryFactor * (isLeft ? 1.0 : -1.0);\n      result += texture2D(uSampler, (uSTMatrix * vec4(getUnWrappedValue(coordI), coordJ, 0, 1)).xy);\n\n      numSamples += 2;\n      coordJ += INV_HEIGHT;\n    }\n\n    result.rgb /= float(numSamples);\n    result.a = 1.0;\n    return result;\n  }\n\n  mediump float getWrappedValue(mediump float value) {\n    return value + (value < leftBoundary ? 1.0 : 0.0);\n  }\n\n  void maybeSetBoundaryColors() {\n    mediump float processedX = getWrappedValue(vTextureCoord.x);\n    bool mainImageBetweenFeatheredBounds =\n      processedX > (leftBoundary + FEATHER_RATIO + TRIANGLE_WIDTH)\n      && processedX < (rightBoundary - FEATHER_RATIO - TRIANGLE_WIDTH);\n    if (mainImageBetweenFeatheredBounds) {\n      return;\n    }\n    vLeftBoundaryColor = getVerticalBlurredBoundaryPixel(vTextureCoord.y, true);\n    vRightBoundaryColor = getVerticalBlurredBoundaryPixel(vTextureCoord.y, false);\n  }\n\n  void main(void) {\n    leftBoundary = uBoundaries.x;\n    rightBoundary = getWrappedValue(uBoundaries.y);\n    gl_Position = uPMatrix * uMVMatrix * vec4(aVertexPosition, 1.0);\n    vTextureCoord = aTextureCoord;\n    maybeSetBoundaryColors();\n  }\n";f["default"]=a}),66);
__d("TextureCubeMap.fs",[],(function(a,b,c,d,e,f){a="\n  varying highp vec3 vVertexDirectionVector;\n  uniform samplerCube uSampler;\n\n  void main(void) {\n    gl_FragColor = textureCube(uSampler, vVertexDirectionVector);\n  }\n";f["default"]=a}),66);
__d("TextureCubeMap.vs",[],(function(a,b,c,d,e,f){a="\n  attribute vec3 aVertexPosition;\n\n  uniform mat4 uMVMatrix;\n  uniform mat4 uPMatrix;\n\n  varying highp vec3 vVertexDirectionVector;\n\n  void main(void) {\n    gl_Position = uPMatrix * uMVMatrix * vec4(aVertexPosition, 1.0);\n    vVertexDirectionVector = aVertexPosition;\n  }\n";f["default"]=a}),66);
__d("SphericalShaderUtils",["CDSFallback.fs","CDSFallback.vs","CDSRenderer.fs","CDSRenderer.vs","DefaultRenderer.fs","DefaultRenderer.vs","HalfEquirect.fs","HalfEquirect.vs","TextureCubeMap.fs","TextureCubeMap.vs"],(function(a,b,c,d,e,f,g){function a(a){switch(a){case"cube_map":return c("TextureCubeMap.vs");case"cds":return c("CDSRenderer.vs");case"cds_fallback":return c("CDSFallback.vs");case"half_equirectangular":return c("HalfEquirect.vs");default:return c("DefaultRenderer.vs")}}function b(a){switch(a){case"cube_map":return c("TextureCubeMap.fs");case"cds":return c("CDSRenderer.fs");case"cds_fallback":return c("CDSFallback.fs");case"half_equirectangular":return c("HalfEquirect.fs");default:return c("DefaultRenderer.fs")}}g.getVertexShader=a;g.getFragmentShader=b}),98);
__d("SphericalRenderer",["EventEmitter","EventListener","SphericalShaderUtils","cr:6114","gl-matrix"],(function(a,b,c,d,e,f,g){var h=Math.max(window.devicePixelRatio||1,1),i=.25,j=.75,k=function(){};e=function(e){babelHelpers.inheritsLoose(f,e);function f(a,b,d){var f;f=e.call(this)||this;f.$SphericalRenderer2=d;f.$SphericalRenderer23=d.fieldOfView;f.$SphericalRenderer18=!0;f.$SphericalRenderer17=a;f.$SphericalRenderer1=b;f.$SphericalRenderer11=c("gl-matrix").mat4.create();f.$SphericalRenderer12=c("gl-matrix").mat4.create();f.$SphericalRenderer13=c("gl-matrix").mat4.create();f.$SphericalRenderer14=c("gl-matrix").mat4.create();f.$SphericalRenderer3=!1;f.$SphericalRenderer20=[];f.$SphericalRenderer22=null;f.$SphericalRenderer21=null;f.$SphericalRenderer19=!1;f.$SphericalRenderer9=d.projectionType==="rotated_cubemap";f.$SphericalRenderer7=d.projectionType==="cds_barrel";f.$SphericalRenderer8=!1;f.$SphericalRenderer10=d.projectionType==="half_equirectangular";f.$SphericalRenderer25=new k();f.$SphericalRenderer25.ready=!1;f.$SphericalRenderer26=!1;f.$SphericalRenderer4=f.$SphericalRenderer27.bind(babelHelpers.assertThisInitialized(f));f.$SphericalRenderer5=f.$SphericalRenderer28.bind(babelHelpers.assertThisInitialized(f));f.$SphericalRenderer1.addEventListener("webglcontextlost",f.$SphericalRenderer4);f.$SphericalRenderer1.addEventListener("webglcontextrestored",f.$SphericalRenderer5);f.$SphericalRenderer29();return f}var g=f.prototype;g.destroy=function(){this.removeAllListeners(),this.$SphericalRenderer1.removeEventListener("webglcontextlost",this.$SphericalRenderer4),this.$SphericalRenderer1.removeEventListener("webglcontextrestored",this.$SphericalRenderer5)};g.reconfigure=function(a,b,c){c===void 0&&(c=!1),c&&(this.$SphericalRenderer20=[],this.$SphericalRenderer22=null,this.$SphericalRenderer21=null),this.$SphericalRenderer23=b.fieldOfView,this.$SphericalRenderer17=a,this.$SphericalRenderer2=b,this.$SphericalRenderer19=!1,this.$SphericalRenderer9=b.projectionType==="rotated_cubemap",this.$SphericalRenderer7=b.projectionType==="cds_barrel",this.$SphericalRenderer10=b.projectionType==="half_equirectangular",this.$SphericalRenderer25.framebuffer=null,this.$SphericalRenderer26=!1,this.$SphericalRenderer29()};g.hasRenderingContext=function(){return!this.$SphericalRenderer3};g.$SphericalRenderer27=function(a){a.preventDefault(),this.emit("renderingContextLost"),this.$SphericalRenderer3=!0};g.$SphericalRenderer28=function(a){this.$SphericalRenderer3=!1,this.$SphericalRenderer29(),this.emit("renderingContextRestore")};g.setAutoUpdateTexture=function(a){this.$SphericalRenderer18=a};g.updateFieldOfView=function(a){this.$SphericalRenderer23!==a&&(this.$SphericalRenderer23=a,this.$SphericalRenderer30())};g.updateViewportDimensions=function(a,b){this.$SphericalRenderer1.width=a*h,this.$SphericalRenderer1.height=b*h,this.$SphericalRenderer30()};g.$SphericalRenderer30=function(){c("gl-matrix").mat4.perspective(this.$SphericalRenderer11,c("gl-matrix").glMatrix.toRadian(this.$SphericalRenderer23),this.$SphericalRenderer1.width/this.$SphericalRenderer1.height,.1,100),this.$SphericalRenderer6.viewport(0,0,this.$SphericalRenderer6.drawingBufferWidth,this.$SphericalRenderer6.drawingBufferHeight)};g.$SphericalRenderer31=function(){this.$SphericalRenderer14=c("gl-matrix").mat4.create(),this.$SphericalRenderer10&&(this.$SphericalRenderer14[0]=1/this.$SphericalRenderer24.x/(j-i),this.$SphericalRenderer14[5]=1/this.$SphericalRenderer24.y,this.$SphericalRenderer14[12]=-(this.$SphericalRenderer14[0]*i),this.$SphericalRenderer24={x:1,y:1})};g.$SphericalRenderer29=function(){this.$SphericalRenderer32();if(this.$SphericalRenderer7){var a=this.$SphericalRenderer6.getParameter(this.$SphericalRenderer6.MAX_VERTEX_TEXTURE_IMAGE_UNITS);this.$SphericalRenderer8=a==0}this.updateViewportDimensions(this.$SphericalRenderer1.clientWidth,this.$SphericalRenderer1.clientHeight);this.$SphericalRenderer24={x:this.$SphericalRenderer2.stereoFormat==="left-right"?2:1,y:this.$SphericalRenderer2.stereoFormat==="top-bottom"?2:1};this.$SphericalRenderer31();this.$SphericalRenderer33();this.$SphericalRenderer34();this.$SphericalRenderer6.clearColor(0,0,0,1);this.$SphericalRenderer17.setAttribute("crossorigin","anonymous")};g.getScreenshotDataURL=function(a,b,c,d){if(!this.$SphericalRenderer6||this.$SphericalRenderer3)return"";this.render(a,b);return this.$SphericalRenderer1.toDataURL(c,d)};g.$SphericalRenderer32=function(){if(this.$SphericalRenderer6&&!this.$SphericalRenderer3)return;if(!(a.WebGLRenderingContext||a.WebGL2RenderingContext))throw new Error("WebGLRenderingContext not available.");var b=["webgl2","webgl","experimental-webgl"],d=null,e=null,f=c("EventListener").listen(this.$SphericalRenderer1,"webglcontextcreationerror",function(a){return e=a.statusMessage});for(var g=0;g<b.length;g++){try{d=this.$SphericalRenderer1.getContext(b[g])}catch(a){}if(d)break}f.remove();if(!d){e||(e="Unknown error.");throw new Error("Failed to acquire 3D rendering context: "+e)}this.$SphericalRenderer6=d;this.$SphericalRenderer3=!1};g.$SphericalRenderer33=function(){var a=this.$SphericalRenderer7?this.$SphericalRenderer8?"cds_fallback":"cds":this.$SphericalRenderer19?"cube_map":this.$SphericalRenderer10?"half_equirectangular":"default",b=this.$SphericalRenderer35(a);a=this.$SphericalRenderer36(a);this.$SphericalRenderer16=this.$SphericalRenderer6.createProgram();this.$SphericalRenderer6.attachShader(this.$SphericalRenderer16,b);this.$SphericalRenderer6.attachShader(this.$SphericalRenderer16,a);this.$SphericalRenderer6.linkProgram(this.$SphericalRenderer16)};g.$SphericalRenderer37=function(){if(!this.$SphericalRenderer6.getProgramParameter(this.$SphericalRenderer16,this.$SphericalRenderer6.LINK_STATUS)){var a="",b=this.$SphericalRenderer6.getAttachedShaders(this.$SphericalRenderer16);for(var c=0;c<b.length;c++)if(!this.$SphericalRenderer6.getShaderParameter(b[c],this.$SphericalRenderer6.COMPILE_STATUS)){a="Shader error: "+this.$SphericalRenderer6.getShaderInfoLog(b[c]);break}a===""&&(a="Program link error: "+this.$SphericalRenderer6.getProgramInfoLog(this.$SphericalRenderer16));throw new Error(a)}this.$SphericalRenderer6.useProgram(this.$SphericalRenderer16);this.$SphericalRenderer16.vertexPositionAttribute=this.$SphericalRenderer6.getAttribLocation(this.$SphericalRenderer16,"aVertexPosition");this.$SphericalRenderer6.enableVertexAttribArray(this.$SphericalRenderer16.vertexPositionAttribute);this.$SphericalRenderer16.pMatrixUniform=this.$SphericalRenderer6.getUniformLocation(this.$SphericalRenderer16,"uPMatrix");this.$SphericalRenderer16.mvMatrixUniform=this.$SphericalRenderer6.getUniformLocation(this.$SphericalRenderer16,"uMVMatrix");this.$SphericalRenderer16.stMatrixUniform=this.$SphericalRenderer6.getUniformLocation(this.$SphericalRenderer16,"uSTMatrix");this.$SphericalRenderer16.samplerUniform=this.$SphericalRenderer6.getUniformLocation(this.$SphericalRenderer16,"uSampler");!this.$SphericalRenderer19&&!this.$SphericalRenderer7&&(this.$SphericalRenderer16.textureCoordAttribute=this.$SphericalRenderer6.getAttribLocation(this.$SphericalRenderer16,"aTextureCoord"),this.$SphericalRenderer6.enableVertexAttribArray(this.$SphericalRenderer16.textureCoordAttribute));this.$SphericalRenderer8&&(this.$SphericalRenderer16.offsetUniform=this.$SphericalRenderer6.getUniformLocation(this.$SphericalRenderer16,"uOffset"));this.$SphericalRenderer10&&(this.$SphericalRenderer16.boundariesUniform=this.$SphericalRenderer6.getUniformLocation(this.$SphericalRenderer16,"uBoundaries"));this.$SphericalRenderer26=!0};g.$SphericalRenderer34=function(){this.$SphericalRenderer15=this.$SphericalRenderer6.createTexture();this.$SphericalRenderer15.image=this.$SphericalRenderer17;var a=this.$SphericalRenderer19?this.$SphericalRenderer6.TEXTURE_CUBE_MAP:this.$SphericalRenderer6.TEXTURE_2D;this.$SphericalRenderer6.bindTexture(a,this.$SphericalRenderer15);this.$SphericalRenderer6.texParameteri(a,this.$SphericalRenderer6.TEXTURE_MAG_FILTER,this.$SphericalRenderer6.LINEAR);this.$SphericalRenderer6.texParameteri(a,this.$SphericalRenderer6.TEXTURE_MIN_FILTER,this.$SphericalRenderer6.LINEAR);this.$SphericalRenderer6.texParameteri(a,this.$SphericalRenderer6.TEXTURE_WRAP_S,this.$SphericalRenderer6.CLAMP_TO_EDGE);this.$SphericalRenderer6.texParameteri(a,this.$SphericalRenderer6.TEXTURE_WRAP_T,this.$SphericalRenderer6.CLAMP_TO_EDGE)};g.$SphericalRenderer38=function(a,b,c,d,e,f){b===void 0&&(b=30);c===void 0&&(c=30);d===void 0&&(d=Math.PI);e===void 0&&(e=Math.PI*2);f===void 0&&(f=0);var g=2,h=[],i=[],j,k;for(j=0;j<=b;j++){var l=(j/b-.5)*d,m=Math.sin(l);l=Math.cos(l);for(k=0;k<=c;k++){var n=(k/c-.5)*e+f,o=Math.sin(n);n=Math.cos(n);n=n*l;var p=m;o=o*l;var q=k/c/this.$SphericalRenderer24.x,r=j/b/this.$SphericalRenderer24.y;i.push(q);i.push(r);h.push(g*n);h.push(g*p);h.push(g*o)}}q=[];for(j=0;j<b;j++)for(k=0;k<c;k++){r=j*(c+1)+k;n=r+c+1;q.push(r);q.push(n);q.push(r+1);q.push(n);q.push(n+1);q.push(r+1)}this.$SphericalRenderer20[a]=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer20[a]);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ARRAY_BUFFER,new Float32Array(i),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer20[a].itemSize=2;this.$SphericalRenderer20[a].numItems=i.length/2;this.$SphericalRenderer22=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer22);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ARRAY_BUFFER,new Float32Array(h),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer22&&(this.$SphericalRenderer22.itemSize=3,this.$SphericalRenderer22.numItems=h.length/3);this.$SphericalRenderer21=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,this.$SphericalRenderer21);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,new Uint16Array(q),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer21&&(this.$SphericalRenderer21.itemSize=1,this.$SphericalRenderer21.numItems=q.length)};g.$SphericalRenderer39=function(a,b){var c=40,d=60,e=2,f=[],g=[],h=[],i=[],j,k;for(j=0;j<=c;j++){var l=j/c-.5,m=l*.5*Math.PI,n=Math.sin(m);m=Math.cos(m);var o=(l/a+.5)/this.$SphericalRenderer24.y;for(k=0;k<=d;k++){var p=k/d-.5,q=p*2*Math.PI,r=Math.sin(q);q=Math.cos(q);var s=q*m*e,t=n*e,u=r*m*e;p=(p/a*.8+.4)/this.$SphericalRenderer24.x;g.push(p);g.push(o);f.push(s);f.push(t);f.push(u);if(j==0||j==c){p=Math.sign(1-j);r=(r*.1/a+.9)/this.$SphericalRenderer24.x;q=(q*.25*p/a+.5+l*.5)/this.$SphericalRenderer24.y;i.push(r);i.push(q);h.push(s);h.push(t);h.push(u)}}}p=f.length/3;g.push.apply(g,i);f.push.apply(f,h);r=f.length/3;q=Math.sin(Math.PI*.25)*e;g.push(.9/this.$SphericalRenderer24.x);g.push(.25/this.$SphericalRenderer24.y);f.push(0);f.push(-q);f.push(0);g.push(.9/this.$SphericalRenderer24.x);g.push(.75/this.$SphericalRenderer24.y);f.push(0);f.push(q);f.push(0);s=[];for(j=0;j<c;j++)for(k=0;k<d;k++){t=j*(d+1)+k;u=t+d+1;s.push(t);s.push(u);s.push(t+1);s.push(u);s.push(u+1);s.push(t+1)}for(m=0;m<2;m++)for(k=0;k<d;k++)s.push(k+p+m*(d+1)),s.push(k+p+m*(d+1)+1),s.push(r+m);this.$SphericalRenderer20[b]=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer20[b]);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ARRAY_BUFFER,new Float32Array(g),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer20[b].itemSize=2;this.$SphericalRenderer20[b].numItems=g.length/2;this.$SphericalRenderer22=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer22);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ARRAY_BUFFER,new Float32Array(f),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer22&&(this.$SphericalRenderer22.itemSize=3,this.$SphericalRenderer22.numItems=f.length/3);this.$SphericalRenderer21=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,this.$SphericalRenderer21);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,new Uint16Array(s),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer21&&(this.$SphericalRenderer21.itemSize=1,this.$SphericalRenderer21.numItems=s.length)};g.$SphericalRenderer40=function(a,b,c){this.$SphericalRenderer9?a=[1,3,7,5,6,7,3,2,0,2,3,1,4,5,7,6,4,6,2,0,0,1,5,4]:a=[5,1,3,7,0,4,6,2,6,7,3,2,0,1,5,4,4,5,7,6,1,0,2,3];var d=[];for(var e=0;e<a.length;e++){var f=a[e]>>2&1,g=a[e]>>1&1,h=a[e]>>0&1;d.push(f*2-1);d.push(g*2-1);d.push(h*2-1)}this.$SphericalRenderer22=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer22);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ARRAY_BUFFER,new Float32Array(d),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer22&&(this.$SphericalRenderer22.itemSize=3,this.$SphericalRenderer22.numItems=d.length/3);if(!this.$SphericalRenderer19){var i;f=[];if(this.$SphericalRenderer9){g=this.$SphericalRenderer15.image.videoWidth/2;b=g/(Math.floor(g/32)*32);h=(1-1/b)/2;e=3;d=2;g=1/d;i=1/e}else h=(1-1/b)/2,e=2,d=3,g=1/d,i=1/e;for(b=0;b<e;++b)for(var j=0;j<d;++j){var k=e-1-b,l=j;f.push((l+h)*g);f.push((k+h)*i);f.push((l+1-h)*g);f.push((k+h)*i);f.push((l+1-h)*g);f.push((k+1-h)*i);f.push((l+h)*g);f.push((k+1-h)*i)}this.$SphericalRenderer20[c]=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer20[c]);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ARRAY_BUFFER,new Float32Array(f),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer20[c].itemSize=2;this.$SphericalRenderer20[c].numItems=f.length/2}l=[];for(k=0;k<a.length;k+=4)l.push(k),l.push(k+2),l.push(k+1),l.push(k),l.push(k+3),l.push(k+2);this.$SphericalRenderer21=this.$SphericalRenderer6.createBuffer();this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,this.$SphericalRenderer21);this.$SphericalRenderer6.bufferData(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,new Uint16Array(l),this.$SphericalRenderer6.STATIC_DRAW);this.$SphericalRenderer21&&(this.$SphericalRenderer21.itemSize=1,this.$SphericalRenderer21.numItems=l.length)};g.$SphericalRenderer35=function(a){var b=this.$SphericalRenderer6.createShader(this.$SphericalRenderer6.VERTEX_SHADER);a=d("SphericalShaderUtils").getVertexShader(a);this.$SphericalRenderer6.shaderSource(b,a);this.$SphericalRenderer6.compileShader(b);return b};g.$SphericalRenderer36=function(a){var b=this.$SphericalRenderer6.createShader(this.$SphericalRenderer6.FRAGMENT_SHADER);a=d("SphericalShaderUtils").getFragmentShader(a);this.$SphericalRenderer6.shaderSource(b,a);this.$SphericalRenderer6.compileShader(b);return b};g.$SphericalRenderer41=function(){this.$SphericalRenderer25.framebuffer=this.$SphericalRenderer6.createFramebuffer(),this.$SphericalRenderer6.bindFramebuffer(this.$SphericalRenderer6.FRAMEBUFFER,this.$SphericalRenderer25.framebuffer),this.$SphericalRenderer6.framebufferTexture2D(this.$SphericalRenderer6.FRAMEBUFFER,this.$SphericalRenderer6.COLOR_ATTACHMENT0,this.$SphericalRenderer6.TEXTURE_2D,this.$SphericalRenderer15,0),this.$SphericalRenderer6.bindFramebuffer(this.$SphericalRenderer6.FRAMEBUFFER,null)};g.$SphericalRenderer42=function(){this.$SphericalRenderer6.bindFramebuffer(this.$SphericalRenderer6.FRAMEBUFFER,this.$SphericalRenderer25.framebuffer),this.$SphericalRenderer6.readPixels(0,this.$SphericalRenderer15.image.videoHeight-1,this.$SphericalRenderer15.image.videoWidth,1,this.$SphericalRenderer6.RGBA,this.$SphericalRenderer6.UNSIGNED_BYTE,this.$SphericalRenderer25.pixels),this.$SphericalRenderer6.bindFramebuffer(this.$SphericalRenderer6.FRAMEBUFFER,null)};g.$SphericalRenderer43=function(){this.$SphericalRenderer25.bitmask.fill(0);var a=[0,0,0],b=this.$SphericalRenderer15.image.videoWidth/125,c=Math.round(b),d;for(d=0;d<33;++d){var e=Math.floor((45+d)*b)*4,f=128,g=127;for(var h=0;h<3;++h){a[h]=0;for(var i=0;i<c;++i)a[h]+=this.$SphericalRenderer25.pixels[e+i*4+(2-h)];a[h]/=c;f=Math.max(f,a[h]);g=Math.min(g,a[h])}for(h=0;h<3;++h){i=(a[h]-g)/(f-g);this.$SphericalRenderer25.bitmask[d*3+h]=i>.5?1:0}}for(d=0;d<12;++d){e=0;for(i=0;i<8;++i)e+=this.$SphericalRenderer25.bitmask[1+d*8+i]*Math.pow(2,i);this.$SphericalRenderer25.dataView.setUint8(d,e)}this.$SphericalRenderer25.offsetX=this.$SphericalRenderer25.dataView.getFloat32(0,!0);this.$SphericalRenderer25.offsetZ=-this.$SphericalRenderer25.dataView.getFloat32(8,!0)};g.$SphericalRenderer44=function(){try{this.$SphericalRenderer25.ready||(this.$SphericalRenderer25.pixels=new Uint8Array(3840*4),this.$SphericalRenderer25.bitmask=new Uint8Array(33*3),this.$SphericalRenderer25.dataView=new DataView(new ArrayBuffer(12)),this.$SphericalRenderer25.ready=!0),this.$SphericalRenderer25.framebuffer||this.$SphericalRenderer41(),this.$SphericalRenderer42(),this.$SphericalRenderer43()}catch(a){this.emit("renderingError",a)}};g.$SphericalRenderer45=function(){if(this.$SphericalRenderer19)this.$SphericalRenderer46();else{this.$SphericalRenderer6.bindTexture(this.$SphericalRenderer6.TEXTURE_2D,this.$SphericalRenderer15);this.$SphericalRenderer6.pixelStorei(this.$SphericalRenderer6.UNPACK_FLIP_Y_WEBGL,!this.$SphericalRenderer7);try{this.$SphericalRenderer6.texImage2D(this.$SphericalRenderer6.TEXTURE_2D,0,this.$SphericalRenderer6.RGBA,this.$SphericalRenderer6.RGBA,this.$SphericalRenderer6.UNSIGNED_BYTE,this.$SphericalRenderer15.image)}catch(a){this.emit("renderingError",a)}this.$SphericalRenderer8&&this.$SphericalRenderer44()}};g.renderWithRotationMatrix=function(a){if(this.$SphericalRenderer3)return;this.$SphericalRenderer18&&this.$SphericalRenderer45();this.$SphericalRenderer12=a;this.$SphericalRenderer7&&c("gl-matrix").mat4.rotateY(this.$SphericalRenderer12,this.$SphericalRenderer12,c("gl-matrix").glMatrix.toRadian(-90));this.$SphericalRenderer47()};g.render=function(a,b){if(this.$SphericalRenderer3)return;this.$SphericalRenderer18&&this.$SphericalRenderer45();if(this.$SphericalRenderer9){var d;(d=c("gl-matrix")).mat4.identity(this.$SphericalRenderer12);d.mat4.rotateX(this.$SphericalRenderer12,this.$SphericalRenderer12,d.glMatrix.toRadian(-b));d.mat4.rotateY(this.$SphericalRenderer12,this.$SphericalRenderer12,d.glMatrix.toRadian(a-135));d.mat4.rotateZ(this.$SphericalRenderer12,this.$SphericalRenderer12,d.glMatrix.toRadian(45))}else this.$SphericalRenderer7&&(a-=90),c("gl-matrix").mat4.identity(this.$SphericalRenderer12),c("gl-matrix").mat4.rotateX(this.$SphericalRenderer12,this.$SphericalRenderer12,-c("gl-matrix").glMatrix.toRadian(b)),c("gl-matrix").mat4.rotateY(this.$SphericalRenderer12,this.$SphericalRenderer12,c("gl-matrix").glMatrix.toRadian(a));this.$SphericalRenderer47()};g.$SphericalRenderer47=function(){if(this.$SphericalRenderer19)this.$SphericalRenderer22===null&&this.$SphericalRenderer40(this.$SphericalRenderer2.projectionType,this.$SphericalRenderer2.expansionCoef||0,0);else{this.$SphericalRenderer26||(this.$SphericalRenderer37(),this.$SphericalRenderer6.activeTexture(this.$SphericalRenderer6.TEXTURE0));var a=this.$SphericalRenderer15.image.videoWidth;this.$SphericalRenderer2.projectionType==="cubemap"||this.$SphericalRenderer2.projectionType==="rotated_cubemap"?a in this.$SphericalRenderer20||this.$SphericalRenderer40(this.$SphericalRenderer2.projectionType,this.$SphericalRenderer2.expansionCoef||0,a):this.$SphericalRenderer2.projectionType==="barrel"?a in this.$SphericalRenderer20||this.$SphericalRenderer39(this.$SphericalRenderer2.expansionCoef||1.01,a):this.$SphericalRenderer7?a in this.$SphericalRenderer20||this.$SphericalRenderer38(a,40,40,Math.PI/180*111,Math.PI/180*142,-Math.PI/2):a in this.$SphericalRenderer20||this.$SphericalRenderer38(a);this.$SphericalRenderer7||(this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer20[a]),this.$SphericalRenderer6.vertexAttribPointer(this.$SphericalRenderer16.textureCoordAttribute,this.$SphericalRenderer20[a].itemSize,this.$SphericalRenderer6.FLOAT,!1,0,0))}this.$SphericalRenderer6.uniform1i(this.$SphericalRenderer16.samplerUniform,0);this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ARRAY_BUFFER,this.$SphericalRenderer22);this.$SphericalRenderer22&&this.$SphericalRenderer6.vertexAttribPointer(this.$SphericalRenderer16.vertexPositionAttribute,this.$SphericalRenderer22.itemSize,this.$SphericalRenderer6.FLOAT,!1,0,0);this.$SphericalRenderer6.bindBuffer(this.$SphericalRenderer6.ELEMENT_ARRAY_BUFFER,this.$SphericalRenderer21);this.$SphericalRenderer6.uniformMatrix4fv(this.$SphericalRenderer16.pMatrixUniform,!1,this.$SphericalRenderer11);this.$SphericalRenderer10&&this.$SphericalRenderer6.uniform2f(this.$SphericalRenderer16.boundariesUniform,i,j);this.$SphericalRenderer7?(c("gl-matrix").mat4.invert(this.$SphericalRenderer13,this.$SphericalRenderer12),this.$SphericalRenderer6.uniformMatrix4fv(this.$SphericalRenderer16.mvMatrixUniform,!1,this.$SphericalRenderer13),this.$SphericalRenderer8&&this.$SphericalRenderer6.uniform2f(this.$SphericalRenderer16.offsetUniform,this.$SphericalRenderer25.offsetX,this.$SphericalRenderer25.offsetZ)):this.$SphericalRenderer6.uniformMatrix4fv(this.$SphericalRenderer16.mvMatrixUniform,!1,this.$SphericalRenderer12);this.$SphericalRenderer10&&this.$SphericalRenderer6.uniformMatrix4fv(this.$SphericalRenderer16.stMatrixUniform,!1,this.$SphericalRenderer14);this.$SphericalRenderer21&&this.$SphericalRenderer6.drawElements(this.$SphericalRenderer6.TRIANGLES,this.$SphericalRenderer21.numItems,this.$SphericalRenderer6.UNSIGNED_SHORT,0)};g.$SphericalRenderer48=function(){var a=this.$SphericalRenderer6.getParameter(this.$SphericalRenderer6.MAX_CUBE_MAP_TEXTURE_SIZE),b=this.$SphericalRenderer15.image.width;return Math.min(a,b)};g.$SphericalRenderer46=function(){var a=this.$SphericalRenderer48(),c=this.$SphericalRenderer15.image.width,d=b("cr:6114").create("canvas",{width:a,height:a});d=d.getContext("2d");this.$SphericalRenderer6.bindTexture(this.$SphericalRenderer6.TEXTURE_CUBE_MAP,this.$SphericalRenderer15);this.$SphericalRenderer6.pixelStorei(this.$SphericalRenderer6.UNPACK_FLIP_Y_WEBGL,!1);for(var e=0;e<6;e++){d.drawImage(this.$SphericalRenderer15.image,0,e*c,c,c,0,0,a,a);var f=new Uint8Array(d.getImageData(0,0,a,a).data);this.$SphericalRenderer6.texImage2D(this.$SphericalRenderer6.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,this.$SphericalRenderer6.RGBA,a,a,0,this.$SphericalRenderer6.RGBA,this.$SphericalRenderer6.UNSIGNED_BYTE,f)}};return f}(c("EventEmitter"));g["default"]=e}),98);