/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalHistory.dev",["Lexical","LexicalUtils"],(function $module_LexicalHistory_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';





var HISTORY_MERGE=0;
var HISTORY_PUSH=1;
var DISCARD_HISTORY_CANDIDATE=2;
var OTHER=0;
var COMPOSING_CHARACTER=1;
var INSERT_CHARACTER_AFTER_SELECTION=2;
var DELETE_CHARACTER_BEFORE_SELECTION=3;
var DELETE_CHARACTER_AFTER_SELECTION=4;
function getDirtyNodes(editorState,dirtyLeaves,dirtyElements){
var nodeMap=editorState._nodeMap;
var nodes=[];
for(var _iterator=dirtyLeaves,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var dirtyLeafKey=_ref;
var dirtyLeaf=nodeMap.get(dirtyLeafKey);
if(dirtyLeaf!==undefined){
nodes.push(dirtyLeaf);
}
}
for(var _iterator2=dirtyElements,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref3;if(_isArray2){if(_i2>=_iterator2.length)break;_ref3=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref3=_i2.value;}var _ref4=_ref3;var dirtyElementKey=_ref4[0];var intentionallyMarkedAsDirty=_ref4[1];
if(!intentionallyMarkedAsDirty){
continue;
}
var dirtyElement=nodeMap.get(dirtyElementKey);
if(dirtyElement!==undefined&&!require("Lexical").$isRootNode(dirtyElement)){
nodes.push(dirtyElement);
}
}
return nodes;
}
function getChangeType(prevEditorState,nextEditorState,dirtyLeavesSet,dirtyElementsSet,isComposing){
if(prevEditorState===null||dirtyLeavesSet.size===0&&dirtyElementsSet.size===0&&!isComposing){
return OTHER;
}
var nextSelection=nextEditorState._selection;
var prevSelection=prevEditorState._selection;
if(isComposing){
return COMPOSING_CHARACTER;
}
if(!require("Lexical").$isRangeSelection(nextSelection)||!require("Lexical").$isRangeSelection(prevSelection)||!prevSelection.isCollapsed()||!nextSelection.isCollapsed()){
return OTHER;
}
var dirtyNodes=getDirtyNodes(nextEditorState,dirtyLeavesSet,dirtyElementsSet);
if(dirtyNodes.length===0){
return OTHER;
}



if(dirtyNodes.length>1){
var nextNodeMap=nextEditorState._nodeMap;
var nextAnchorNode=nextNodeMap.get(nextSelection.anchor.key);
var prevAnchorNode=nextNodeMap.get(prevSelection.anchor.key);
if(nextAnchorNode&&prevAnchorNode&&!prevEditorState._nodeMap.has(nextAnchorNode.__key)&&require("Lexical").$isTextNode(nextAnchorNode)&&nextAnchorNode.__text.length===1&&nextSelection.anchor.offset===1){
return INSERT_CHARACTER_AFTER_SELECTION;
}
return OTHER;
}
var nextDirtyNode=dirtyNodes[0];
var prevDirtyNode=prevEditorState._nodeMap.get(nextDirtyNode.__key);
if(!require("Lexical").$isTextNode(prevDirtyNode)||!require("Lexical").$isTextNode(nextDirtyNode)||prevDirtyNode.__mode!==nextDirtyNode.__mode){
return OTHER;
}
var prevText=prevDirtyNode.__text;
var nextText=nextDirtyNode.__text;
if(prevText===nextText){
return OTHER;
}
var nextAnchor=nextSelection.anchor;
var prevAnchor=prevSelection.anchor;
if(nextAnchor.key!==prevAnchor.key||nextAnchor.type!=='text'){
return OTHER;
}
var nextAnchorOffset=nextAnchor.offset;
var prevAnchorOffset=prevAnchor.offset;
var textDiff=nextText.length-prevText.length;
if(textDiff===1&&prevAnchorOffset===nextAnchorOffset-1){
return INSERT_CHARACTER_AFTER_SELECTION;
}
if(textDiff===-1&&prevAnchorOffset===nextAnchorOffset+1){
return DELETE_CHARACTER_BEFORE_SELECTION;
}
if(textDiff===-1&&prevAnchorOffset===nextAnchorOffset){
return DELETE_CHARACTER_AFTER_SELECTION;
}
return OTHER;
}
function isTextNodeUnchanged(key,prevEditorState,nextEditorState){
var prevNode=prevEditorState._nodeMap.get(key);
var nextNode=nextEditorState._nodeMap.get(key);
var prevSelection=prevEditorState._selection;
var nextSelection=nextEditorState._selection;
var isDeletingLine=false;
if(require("Lexical").$isRangeSelection(prevSelection)&&require("Lexical").$isRangeSelection(nextSelection)){
isDeletingLine=prevSelection.anchor.type==='element'&&prevSelection.focus.type==='element'&&nextSelection.anchor.type==='text'&&nextSelection.focus.type==='text';
}
if(!isDeletingLine&&require("Lexical").$isTextNode(prevNode)&&require("Lexical").$isTextNode(nextNode)){
return prevNode.__type===nextNode.__type&&prevNode.__text===nextNode.__text&&prevNode.__mode===nextNode.__mode&&prevNode.__detail===nextNode.__detail&&prevNode.__style===nextNode.__style&&prevNode.__format===nextNode.__format&&prevNode.__parent===nextNode.__parent;
}
return false;
}
function createMergeActionGetter(editor,delay){
var prevChangeTime=Date.now();
var prevChangeType=OTHER;
return function(prevEditorState,nextEditorState,currentHistoryEntry,dirtyLeaves,dirtyElements,tags){
var changeTime=Date.now();



if(tags.has('historic')){
prevChangeType=OTHER;
prevChangeTime=changeTime;
return DISCARD_HISTORY_CANDIDATE;
}
var changeType=getChangeType(prevEditorState,nextEditorState,dirtyLeaves,dirtyElements,editor.isComposing());
var mergeAction=function(){
var isSameEditor=currentHistoryEntry===null||currentHistoryEntry.editor===editor;
var shouldPushHistory=tags.has('history-push');
var shouldMergeHistory=!shouldPushHistory&&isSameEditor&&tags.has('history-merge');
if(shouldMergeHistory){
return HISTORY_MERGE;
}
if(prevEditorState===null){
return HISTORY_PUSH;
}
var selection=nextEditorState._selection;
var hasDirtyNodes=dirtyLeaves.size>0||dirtyElements.size>0;
if(!hasDirtyNodes){
if(selection!==null){
return HISTORY_MERGE;
}
return DISCARD_HISTORY_CANDIDATE;
}
if(shouldPushHistory===false&&changeType!==OTHER&&changeType===prevChangeType&&changeTime<prevChangeTime+delay&&isSameEditor){
return HISTORY_MERGE;
}



if(dirtyLeaves.size===1){
var dirtyLeafKey=Array.from(dirtyLeaves)[0];
if(isTextNodeUnchanged(dirtyLeafKey,prevEditorState,nextEditorState)){
return HISTORY_MERGE;
}
}
return HISTORY_PUSH;
}();
prevChangeTime=changeTime;
prevChangeType=changeType;
return mergeAction;
};
}
function redo(editor,historyState){
var redoStack=historyState.redoStack;
var undoStack=historyState.undoStack;
if(redoStack.length!==0){
var current=historyState.current;
if(current!==null){
undoStack.push(current);
editor.dispatchCommand(require("Lexical").CAN_UNDO_COMMAND,true);
}
var historyStateEntry=redoStack.pop();
if(redoStack.length===0){
editor.dispatchCommand(require("Lexical").CAN_REDO_COMMAND,false);
}
historyState.current=historyStateEntry||null;
if(historyStateEntry){
historyStateEntry.editor.setEditorState(historyStateEntry.editorState,{
tag:'historic'});

}
}
}
function undo(editor,historyState){
var redoStack=historyState.redoStack;
var undoStack=historyState.undoStack;
var undoStackLength=undoStack.length;
if(undoStackLength!==0){
var current=historyState.current;
var historyStateEntry=undoStack.pop();
if(current!==null){
redoStack.push(current);
editor.dispatchCommand(require("Lexical").CAN_REDO_COMMAND,true);
}
if(undoStack.length===0){
editor.dispatchCommand(require("Lexical").CAN_UNDO_COMMAND,false);
}
historyState.current=historyStateEntry||null;
if(historyStateEntry){
historyStateEntry.editor.setEditorState(historyStateEntry.editorState,{
tag:'historic'});

}
}
}
function clearHistory(historyState){
historyState.undoStack=[];
historyState.redoStack=[];
historyState.current=null;
}










function registerHistory(editor,historyState,delay){var _require_Lexical;
var getMergeAction=createMergeActionGetter(editor,delay);
var applyChange=function applyChange(_ref5)





{var editorState=_ref5.editorState,prevEditorState=_ref5.prevEditorState,dirtyLeaves=_ref5.dirtyLeaves,dirtyElements=_ref5.dirtyElements,tags=_ref5.tags;
var current=historyState.current;
var redoStack=historyState.redoStack;
var undoStack=historyState.undoStack;
var currentEditorState=current===null?null:current.editorState;
if(current!==null&&editorState===currentEditorState){
return;
}
var mergeAction=getMergeAction(prevEditorState,editorState,current,dirtyLeaves,dirtyElements,tags);
if(mergeAction===HISTORY_PUSH){
if(redoStack.length!==0){
historyState.redoStack=[];
editor.dispatchCommand(require("Lexical").CAN_REDO_COMMAND,false);
}
if(current!==null){
undoStack.push(babelHelpers["extends"]({},
current));

editor.dispatchCommand(require("Lexical").CAN_UNDO_COMMAND,true);
}
}else if(mergeAction===DISCARD_HISTORY_CANDIDATE){
return;
}


historyState.current={
editor:editor,
editorState:editorState};

};
var unregisterCommandListener=require("LexicalUtils").mergeRegister(editor.registerCommand((_require_Lexical=require("Lexical")).UNDO_COMMAND,function(){
undo(editor,historyState);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.REDO_COMMAND,function(){
redo(editor,historyState);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.CLEAR_EDITOR_COMMAND,function(){
clearHistory(historyState);
return false;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerCommand(_require_Lexical.CLEAR_HISTORY_COMMAND,function(){
clearHistory(historyState);
editor.dispatchCommand(require("Lexical").CAN_REDO_COMMAND,false);
editor.dispatchCommand(require("Lexical").CAN_UNDO_COMMAND,false);
return true;
},_require_Lexical.COMMAND_PRIORITY_EDITOR),editor.registerUpdateListener(applyChange));
var unregisterUpdateListener=editor.registerUpdateListener(applyChange);
return function(){
unregisterCommandListener();
unregisterUpdateListener();
};
}





function createEmptyHistoryState(){
return{
current:null,
redoStack:[],
undoStack:[]};

}

exports.createEmptyHistoryState=createEmptyHistoryState;
exports.registerHistory=registerHistory;}),null);