/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalList.dev",["Lexical","LexicalUtils"],(function $module_LexicalList_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_Lexical;

















function $getListDepth(listNode){
var depth=1;
var parent=listNode.getParent();
while(parent!=null){
if($isListItemNode(parent)){
var parentList=parent.getParent();
if($isListNode(parentList)){
depth++;
parent=parentList.getParent();
continue;
}
{
throw Error("A ListItemNode must have a ListNode for a parent.");
}
}
return depth;
}
return depth;
}






function $getTopListNode(listItem){
var list=listItem.getParent();
if(!$isListNode(list)){
{
throw Error("A ListItemNode must have a ListNode for a parent.");
}
}
var parent=list;
while(parent!==null){
parent=parent.getParent();
if($isListNode(parent)){
list=parent;
}
}
return list;
}








function $getAllListItems(node){
var listItemNodes=[];
var listChildren=node.getChildren().filter($isListItemNode);
for(var i=0;i<listChildren.length;i++){
var listItemNode=listChildren[i];
var firstChild=listItemNode.getFirstChild();
if($isListNode(firstChild)){
listItemNodes=listItemNodes.concat($getAllListItems(firstChild));
}else{
listItemNodes.push(listItemNode);
}
}
return listItemNodes;
}






function isNestedListNode(node){
return $isListItemNode(node)&&$isListNode(node.getFirstChild());
}








function $removeHighestEmptyListParent(sublist){






var emptyListPtr=sublist;
while(emptyListPtr.getNextSibling()==null&&emptyListPtr.getPreviousSibling()==null){
var parent=emptyListPtr.getParent();
if(parent==null||!($isListItemNode(emptyListPtr)||$isListNode(emptyListPtr))){
break;
}
emptyListPtr=parent;
}
emptyListPtr.remove();
}






function wrapInListItem(node){
var listItemWrapper=$createListItemNode();
return listItemWrapper.append(node);
}








function $isSelectingEmptyListItem(anchorNode,nodes){
return $isListItemNode(anchorNode)&&(nodes.length===0||nodes.length===1&&anchorNode.is(nodes[0])&&anchorNode.getChildrenSize()===0);
}











function insertList(editor,listType){
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(selection!==null){
var nodes=selection.getNodes();
var anchorAndFocus=selection.getStartEndPoints();
if(!(anchorAndFocus!==null)){
throw Error("insertList: anchor should be defined");
}var
anchor=anchorAndFocus[0];
var anchorNode=anchor.getNode();
var anchorNodeParent=anchorNode.getParent();
if($isSelectingEmptyListItem(anchorNode,nodes)){
var list=$createListNode(listType);
if(require("Lexical").$isRootOrShadowRoot(anchorNodeParent)){
anchorNode.replace(list);
var listItem=$createListItemNode();
if(require("Lexical").$isElementNode(anchorNode)){
listItem.setFormat(anchorNode.getFormatType());
listItem.setIndent(anchorNode.getIndent());
}
list.append(listItem);
}else if($isListItemNode(anchorNode)){
var parent=anchorNode.getParentOrThrow();
append(list,parent.getChildren());
parent.replace(list);
}
return;
}else{
var handled=new Set();
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if(require("Lexical").$isElementNode(node)&&node.isEmpty()&&!$isListItemNode(node)&&!handled.has(node.getKey())){
createListOrMerge(node,listType);
continue;
}
if(require("Lexical").$isLeafNode(node)){
var _parent=node.getParent();
while(_parent!=null){
var parentKey=_parent.getKey();
if($isListNode(_parent)){
if(!handled.has(parentKey)){
var newListNode=$createListNode(listType);
append(newListNode,_parent.getChildren());
_parent.replace(newListNode);
handled.add(parentKey);
}
break;
}else{
var nextParent=_parent.getParent();
if(require("Lexical").$isRootOrShadowRoot(nextParent)&&!handled.has(parentKey)){
handled.add(parentKey);
createListOrMerge(_parent,listType);
break;
}
_parent=nextParent;
}
}
}
}
}
}
});
}
function append(node,nodesToAppend){
node.splice(node.getChildrenSize(),0,nodesToAppend);
}
function createListOrMerge(node,listType){
if($isListNode(node)){
return node;
}
var previousSibling=node.getPreviousSibling();
var nextSibling=node.getNextSibling();
var listItem=$createListItemNode();
listItem.setFormat(node.getFormatType());
listItem.setIndent(node.getIndent());
append(listItem,node.getChildren());
if($isListNode(previousSibling)&&listType===previousSibling.getListType()){
previousSibling.append(listItem);
node.remove();


if($isListNode(nextSibling)&&listType===nextSibling.getListType()){
append(previousSibling,nextSibling.getChildren());
nextSibling.remove();
}
return previousSibling;
}else if($isListNode(nextSibling)&&listType===nextSibling.getListType()){
nextSibling.getFirstChildOrThrow().insertBefore(listItem);
node.remove();
return nextSibling;
}else{
var list=$createListNode(listType);
list.append(listItem);
node.replace(list);
return list;
}
}







function mergeLists(list1,list2){
var listItem1=list1.getLastChild();
var listItem2=list2.getFirstChild();
if(listItem1&&listItem2&&isNestedListNode(listItem1)&&isNestedListNode(listItem2)){
mergeLists(listItem1.getFirstChild(),listItem2.getFirstChild());
listItem2.remove();
}
var toMerge=list2.getChildren();
if(toMerge.length>0){
list1.append.apply(list1,toMerge);
}
list2.remove();
}








function removeList(editor){
editor.update(function(){
var selection=require("Lexical").$getSelection();
if(require("Lexical").$isRangeSelection(selection)){
var listNodes=new Set();
var nodes=selection.getNodes();
var anchorNode=selection.anchor.getNode();
if($isSelectingEmptyListItem(anchorNode,nodes)){
listNodes.add($getTopListNode(anchorNode));
}else{
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if(require("Lexical").$isLeafNode(node)){
var listItemNode=require("LexicalUtils").$getNearestNodeOfType(node,ListItemNode);
if(listItemNode!=null){
listNodes.add($getTopListNode(listItemNode));
}
}
}
}
for(var _iterator=listNodes,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var listNode=_ref;
var insertionPoint=listNode;
var listItems=$getAllListItems(listNode);
for(var _iterator2=listItems,_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray2){if(_i2>=_iterator2.length)break;_ref2=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref2=_i2.value;}var _listItemNode=_ref2;
var paragraph=require("Lexical").$createParagraphNode();
append(paragraph,_listItemNode.getChildren());
insertionPoint.insertAfter(paragraph);
insertionPoint=paragraph;







if(_listItemNode.__key===selection.anchor.key){
selection.anchor.set(paragraph.getKey(),0,'element');
}
if(_listItemNode.__key===selection.focus.key){
selection.focus.set(paragraph.getKey(),0,'element');
}
_listItemNode.remove();
}
listNode.remove();
}
}
});
}







function updateChildrenListItemValue(list){
var isNotChecklist=list.getListType()!=='check';
var value=list.getStart();
for(var _iterator3=list.getChildren(),_isArray3=Array.isArray(_iterator3),_i3=0,_iterator3=_isArray3?_iterator3:_iterator3[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref3;if(_isArray3){if(_i3>=_iterator3.length)break;_ref3=_iterator3[_i3++];}else{_i3=_iterator3.next();if(_i3.done)break;_ref3=_i3.value;}var child=_ref3;
if($isListItemNode(child)){
if(child.getValue()!==value){
child.setValue(value);
}
if(isNotChecklist&&child.getChecked()!=null){
child.setChecked(undefined);
}
if(!$isListNode(child.getFirstChild())){
value++;
}
}
}
}







function $handleIndent(listItemNode){

var removed=new Set();
if(isNestedListNode(listItemNode)||removed.has(listItemNode.getKey())){
return;
}
var parent=listItemNode.getParent();


var nextSibling=listItemNode.getNextSibling();
var previousSibling=listItemNode.getPreviousSibling();


if(isNestedListNode(nextSibling)&&isNestedListNode(previousSibling)){
var innerList=previousSibling.getFirstChild();
if($isListNode(innerList)){
innerList.append(listItemNode);
var nextInnerList=nextSibling.getFirstChild();
if($isListNode(nextInnerList)){
var children=nextInnerList.getChildren();
append(innerList,children);
nextSibling.remove();
removed.add(nextSibling.getKey());
}
}
}else if(isNestedListNode(nextSibling)){

var _innerList=nextSibling.getFirstChild();
if($isListNode(_innerList)){
var firstChild=_innerList.getFirstChild();
if(firstChild!==null){
firstChild.insertBefore(listItemNode);
}
}
}else if(isNestedListNode(previousSibling)){
var _innerList2=previousSibling.getFirstChild();
if($isListNode(_innerList2)){
_innerList2.append(listItemNode);
}
}else{


if($isListNode(parent)){
var newListItem=$createListItemNode();
var newList=$createListNode(parent.getListType());
newListItem.append(newList);
newList.append(listItemNode);
if(previousSibling){
previousSibling.insertAfter(newListItem);
}else if(nextSibling){
nextSibling.insertBefore(newListItem);
}else{
parent.append(newListItem);
}
}
}
}







function $handleOutdent(listItemNode){


if(isNestedListNode(listItemNode)){
return;
}
var parentList=listItemNode.getParent();
var grandparentListItem=parentList?parentList.getParent():undefined;
var greatGrandparentList=grandparentListItem?grandparentListItem.getParent():undefined;


if($isListNode(greatGrandparentList)&&$isListItemNode(grandparentListItem)&&$isListNode(parentList)){


var firstChild=parentList?parentList.getFirstChild():undefined;
var lastChild=parentList?parentList.getLastChild():undefined;
if(listItemNode.is(firstChild)){
grandparentListItem.insertBefore(listItemNode);
if(parentList.isEmpty()){
grandparentListItem.remove();
}


}else if(listItemNode.is(lastChild)){
grandparentListItem.insertAfter(listItemNode);
if(parentList.isEmpty()){
grandparentListItem.remove();
}
}else{

var listType=parentList.getListType();
var previousSiblingsListItem=$createListItemNode();
var previousSiblingsList=$createListNode(listType);
previousSiblingsListItem.append(previousSiblingsList);
listItemNode.getPreviousSiblings().forEach(function(sibling){return previousSiblingsList.append(sibling);});
var nextSiblingsListItem=$createListItemNode();
var nextSiblingsList=$createListNode(listType);
nextSiblingsListItem.append(nextSiblingsList);
append(nextSiblingsList,listItemNode.getNextSiblings());

grandparentListItem.insertBefore(previousSiblingsListItem);
grandparentListItem.insertAfter(nextSiblingsListItem);

grandparentListItem.replace(listItemNode);
}
}
}










function $handleListInsertParagraph(){
var selection=require("Lexical").$getSelection();
if(!require("Lexical").$isRangeSelection(selection)||!selection.isCollapsed()){
return false;
}

var anchor=selection.anchor.getNode();
if(!$isListItemNode(anchor)||anchor.getChildrenSize()!==0){
return false;
}
var topListNode=$getTopListNode(anchor);
var parent=anchor.getParent();
if(!$isListNode(parent)){
throw Error("A ListItemNode must have a ListNode for a parent.");
}
var grandparent=parent.getParent();
var replacementNode;
if(require("Lexical").$isRootOrShadowRoot(grandparent)){
replacementNode=require("Lexical").$createParagraphNode();
topListNode.insertAfter(replacementNode);
}else if($isListItemNode(grandparent)){
replacementNode=$createListItemNode();
grandparent.insertAfter(replacementNode);
}else{
return false;
}
replacementNode.select();
var nextSiblings=anchor.getNextSiblings();
if(nextSiblings.length>0){
var newList=$createListNode(parent.getListType());
if(require("Lexical").$isParagraphNode(replacementNode)){
replacementNode.insertAfter(newList);
}else{
var newListItem=$createListItemNode();
newListItem.append(newList);
replacementNode.insertAfter(newListItem);
}
nextSiblings.forEach(function(sibling){
sibling.remove();
newList.append(sibling);
});
}


$removeHighestEmptyListParent(anchor);
return true;
}var









ListItemNode=function(_Lexical$ElementNode){babelHelpers.inheritsLoose(ListItemNode,_Lexical$ElementNode);ListItemNode.




getType=function getType(){
return'listitem';
};ListItemNode.
clone=function clone(node){
return new ListItemNode(node.__value,node.__checked,node.__key);
};
function ListItemNode(value,checked,key){var _this;
_this=_Lexical$ElementNode.call(this,key)||this;
_this.__value=value===undefined?1:value;
_this.__checked=checked;return _this;
}var _proto=ListItemNode.prototype;_proto.
createDOM=function createDOM(config){
var element=document.createElement('li');
var parent=this.getParent();
if($isListNode(parent)&&parent.getListType()==='check'){
updateListItemChecked(element,this,null);
}
element.value=this.__value;
$setListItemThemeClassNames(element,config.theme,this);
return element;
};_proto.
updateDOM=function updateDOM(prevNode,dom,config){
var parent=this.getParent();
if($isListNode(parent)&&parent.getListType()==='check'){
updateListItemChecked(dom,this,prevNode);
}

dom.value=this.__value;
$setListItemThemeClassNames(dom,config.theme,this);
return false;
};ListItemNode.
transform=function transform(){
return function(node){
if(!$isListItemNode(node)){
throw Error("node is not a ListItemNode");
}
if(node.__checked==null){
return;
}
var parent=node.getParent();
if($isListNode(parent)){
if(parent.getListType()!=='check'&&node.getChecked()!=null){
node.setChecked(undefined);
}
}
};
};ListItemNode.
importDOM=function importDOM(){
return{
li:function li(node){return{
conversion:convertListItemElement,
priority:0};}};


};ListItemNode.
importJSON=function importJSON(serializedNode){
var node=$createListItemNode();
node.setChecked(serializedNode.checked);
node.setValue(serializedNode.value);
node.setFormat(serializedNode.format);
node.setDirection(serializedNode.direction);
return node;
};_proto.
exportDOM=function exportDOM(editor){
var element=this.createDOM(editor._config);
element.style.textAlign=this.getFormatType();
return{
element:element};

};_proto.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode.prototype.
exportJSON.call(this),{
checked:this.getChecked(),
type:'listitem',
value:this.getValue(),
version:1});

};_proto.
append=function append(){
for(var i=0;i<arguments.length;i++){
var node=i<0||arguments.length<=i?undefined:arguments[i];
if(require("Lexical").$isElementNode(node)&&this.canMergeWith(node)){
var children=node.getChildren();
this.append.apply(this,children);
node.remove();
}else{
_Lexical$ElementNode.prototype.append.call(this,node);
}
}
return this;
};_proto.
replace=function replace(replaceWithNode,includeChildren){
if($isListItemNode(replaceWithNode)){
return _Lexical$ElementNode.prototype.replace.call(this,replaceWithNode);
}
this.setIndent(0);
var list=this.getParentOrThrow();
if(!$isListNode(list))return replaceWithNode;
if(list.__first===this.getKey()){
list.insertBefore(replaceWithNode);
}else if(list.__last===this.getKey()){
list.insertAfter(replaceWithNode);
}else{

var newList=$createListNode(list.getListType());
var nextSibling=this.getNextSibling();
while(nextSibling){
var nodeToAppend=nextSibling;
nextSibling=nextSibling.getNextSibling();
newList.append(nodeToAppend);
}
list.insertAfter(replaceWithNode);
replaceWithNode.insertAfter(newList);
}
if(includeChildren){
if(!require("Lexical").$isElementNode(replaceWithNode)){
throw Error("includeChildren should only be true for ElementNodes");
}
this.getChildren().forEach(function(child){
replaceWithNode.append(child);
});
}
this.remove();
if(list.getChildrenSize()===0){
list.remove();
}
return replaceWithNode;
};_proto.
insertAfter=function insertAfter(node,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var listNode=this.getParentOrThrow();
if(!$isListNode(listNode)){
{
throw Error("insertAfter: list node is not parent of list item node");
}
}
if($isListItemNode(node)){
return _Lexical$ElementNode.prototype.insertAfter.call(this,node,restoreSelection);
}
var siblings=this.getNextSiblings();



if($isListNode(node)){
var child=node;
var children=node.getChildren();
for(var i=children.length-1;i>=0;i--){
child=children[i];
this.insertAfter(child,restoreSelection);
}
return child;
}



listNode.insertAfter(node,restoreSelection);
if(siblings.length!==0){
var newListNode=$createListNode(listNode.getListType());
siblings.forEach(function(sibling){return newListNode.append(sibling);});
node.insertAfter(newListNode,restoreSelection);
}
return node;
};_proto.
remove=function remove(preserveEmptyParent){
var prevSibling=this.getPreviousSibling();
var nextSibling=this.getNextSibling();
_Lexical$ElementNode.prototype.remove.call(this,preserveEmptyParent);
if(prevSibling&&nextSibling&&isNestedListNode(prevSibling)&&isNestedListNode(nextSibling)){
mergeLists(prevSibling.getFirstChild(),nextSibling.getFirstChild());
nextSibling.remove();
}
};_proto.
insertNewAfter=function insertNewAfter(_,restoreSelection){if(restoreSelection===void 0){restoreSelection=true;}
var newElement=$createListItemNode(this.__checked==null?undefined:false);
this.insertAfter(newElement,restoreSelection);
return newElement;
};_proto.
collapseAtStart=function collapseAtStart(selection){
var paragraph=require("Lexical").$createParagraphNode();
var children=this.getChildren();
children.forEach(function(child){return paragraph.append(child);});
var listNode=this.getParentOrThrow();
var listNodeParent=listNode.getParentOrThrow();
var isIndented=$isListItemNode(listNodeParent);
if(listNode.getChildrenSize()===1){
if(isIndented){


listNode.remove();
listNodeParent.select();
}else{
listNode.insertBefore(paragraph);
listNode.remove();


var anchor=selection.anchor;
var focus=selection.focus;
var key=paragraph.getKey();
if(anchor.type==='element'&&anchor.getNode().is(this)){
anchor.set(key,anchor.offset,'element');
}
if(focus.type==='element'&&focus.getNode().is(this)){
focus.set(key,focus.offset,'element');
}
}
}else{
listNode.insertBefore(paragraph);
this.remove();
}
return true;
};_proto.
getValue=function getValue(){
var self=this.getLatest();
return self.__value;
};_proto.
setValue=function setValue(value){
var self=this.getWritable();
self.__value=value;
};_proto.
getChecked=function getChecked(){
var self=this.getLatest();
return self.__checked;
};_proto.
setChecked=function setChecked(checked){
var self=this.getWritable();
self.__checked=checked;
};_proto.
toggleChecked=function toggleChecked(){
this.setChecked(!this.__checked);
};_proto.
getIndent=function getIndent(){

var parent=this.getParent();
if(parent===null){
return this.getLatest().__indent;
}

var listNodeParent=parent.getParentOrThrow();
var indentLevel=0;
while($isListItemNode(listNodeParent)){
listNodeParent=listNodeParent.getParentOrThrow().getParentOrThrow();
indentLevel++;
}
return indentLevel;
};_proto.
setIndent=function setIndent(indent){
if(!(typeof indent==='number'&&indent>-1)){
throw Error("Invalid indent value.");
}
var currentIndent=this.getIndent();
while(currentIndent!==indent){
if(currentIndent<indent){
$handleIndent(this);
currentIndent++;
}else{
$handleOutdent(this);
currentIndent--;
}
}
return this;
};_proto.
canInsertAfter=function canInsertAfter(node){
return $isListItemNode(node);
};_proto.
canReplaceWith=function canReplaceWith(replacement){
return $isListItemNode(replacement);
};_proto.
canMergeWith=function canMergeWith(node){
return require("Lexical").$isParagraphNode(node)||$isListItemNode(node);
};_proto.
extractWithChild=function extractWithChild(child,selection){
if(!require("Lexical").$isRangeSelection(selection)){
return false;
}
var anchorNode=selection.anchor.getNode();
var focusNode=selection.focus.getNode();
return this.isParentOf(anchorNode)&&this.isParentOf(focusNode)&&this.getTextContent().length===selection.getTextContent().length;
};_proto.
isParentRequired=function isParentRequired(){
return true;
};_proto.
createParentElementNode=function createParentElementNode(){
return $createListNode('bullet');
};return ListItemNode;}((_require_Lexical=require("Lexical")).ElementNode);

function $setListItemThemeClassNames(dom,editorThemeClasses,node){
var classesToAdd=[];
var classesToRemove=[];
var listTheme=editorThemeClasses.list;
var listItemClassName=listTheme?listTheme.listitem:undefined;
var nestedListItemClassName;
if(listTheme&&listTheme.nested){
nestedListItemClassName=listTheme.nested.listitem;
}
if(listItemClassName!==undefined){
var listItemClasses=listItemClassName.split(' ');
classesToAdd.push.apply(classesToAdd,listItemClasses);
}
if(listTheme){
var parentNode=node.getParent();
var isCheckList=$isListNode(parentNode)&&parentNode.getListType()==='check';
var checked=node.getChecked();
if(!isCheckList||checked){
classesToRemove.push(listTheme.listitemUnchecked);
}
if(!isCheckList||!checked){
classesToRemove.push(listTheme.listitemChecked);
}
if(isCheckList){
classesToAdd.push(checked?listTheme.listitemChecked:listTheme.listitemUnchecked);
}
}
if(nestedListItemClassName!==undefined){
var nestedListItemClasses=nestedListItemClassName.split(' ');
if(node.getChildren().some(function(child){return $isListNode(child);})){
classesToAdd.push.apply(classesToAdd,nestedListItemClasses);
}else{
classesToRemove.push.apply(classesToRemove,nestedListItemClasses);
}
}
if(classesToRemove.length>0){
require("LexicalUtils").removeClassNamesFromElement.apply(require("LexicalUtils"),[dom].concat(classesToRemove));
}
if(classesToAdd.length>0){
require("LexicalUtils").addClassNamesToElement.apply(require("LexicalUtils"),[dom].concat(classesToAdd));
}
}
function updateListItemChecked(dom,listItemNode,prevListItemNode,listNode){

if($isListNode(listItemNode.getFirstChild())){
dom.removeAttribute('role');
dom.removeAttribute('tabIndex');
dom.removeAttribute('aria-checked');
}else{
dom.setAttribute('role','checkbox');
dom.setAttribute('tabIndex','-1');
if(!prevListItemNode||listItemNode.__checked!==prevListItemNode.__checked){
dom.setAttribute('aria-checked',listItemNode.getChecked()?'true':'false');
}
}
}
function convertListItemElement(domNode){
var checked=require("LexicalUtils").isHTMLElement(domNode)&&domNode.getAttribute('aria-checked')==='true';
return{
node:$createListItemNode(checked)};

}






function $createListItemNode(checked){
return require("Lexical").$applyNodeReplacement(new ListItemNode(undefined,checked));
}






function $isListItemNode(node){
return node instanceof ListItemNode;
}var









ListNode=function(_Lexical$ElementNode2){babelHelpers.inheritsLoose(ListNode,_Lexical$ElementNode2);ListNode.






getType=function getType(){
return'list';
};ListNode.
clone=function clone(node){
var listType=node.__listType||TAG_TO_LIST_TYPE[node.__tag];
return new ListNode(listType,node.__start,node.__key);
};
function ListNode(listType,start,key){var _this2;
_this2=_Lexical$ElementNode2.call(this,key)||this;
var _listType=TAG_TO_LIST_TYPE[listType]||listType;
_this2.__listType=_listType;
_this2.__tag=_listType==='number'?'ol':'ul';
_this2.__start=start;return _this2;
}var _proto2=ListNode.prototype;_proto2.
getTag=function getTag(){
return this.__tag;
};_proto2.
setListType=function setListType(type){
var writable=this.getWritable();
writable.__listType=type;
writable.__tag=type==='number'?'ol':'ul';
};_proto2.
getListType=function getListType(){
return this.__listType;
};_proto2.
getStart=function getStart(){
return this.__start;
};_proto2.



createDOM=function createDOM(config,_editor){
var tag=this.__tag;
var dom=document.createElement(tag);
if(this.__start!==1){
dom.setAttribute('start',String(this.__start));
}

dom.__lexicalListType=this.__listType;
setListThemeClassNames(dom,config.theme,this);
return dom;
};_proto2.
updateDOM=function updateDOM(prevNode,dom,config){
if(prevNode.__tag!==this.__tag){
return true;
}
setListThemeClassNames(dom,config.theme,this);
return false;
};ListNode.
transform=function transform(){
return function(node){
if(!$isListNode(node)){
throw Error("node is not a ListNode");
}
updateChildrenListItemValue(node);
};
};ListNode.
importDOM=function importDOM(){
return{
ol:function ol(node){return{
conversion:convertListNode,
priority:0};},

ul:function ul(node){return{
conversion:convertListNode,
priority:0};}};


};ListNode.
importJSON=function importJSON(serializedNode){
var node=$createListNode(serializedNode.listType,serializedNode.start);
node.setFormat(serializedNode.format);
node.setIndent(serializedNode.indent);
node.setDirection(serializedNode.direction);
return node;
};_proto2.
exportDOM=function exportDOM(editor){var _Lexical$ElementNode3=_Lexical$ElementNode2.prototype.


exportDOM.call(this,editor),element=_Lexical$ElementNode3.element;
if(element&&require("LexicalUtils").isHTMLElement(element)){
if(this.__start!==1){
element.setAttribute('start',String(this.__start));
}
if(this.__listType==='check'){
element.setAttribute('__lexicalListType','check');
}
}
return{
element:element};

};_proto2.
exportJSON=function exportJSON(){
return babelHelpers["extends"]({},_Lexical$ElementNode2.prototype.
exportJSON.call(this),{
listType:this.getListType(),
start:this.getStart(),
tag:this.getTag(),
type:'list',
version:1});

};_proto2.
canBeEmpty=function canBeEmpty(){
return false;
};_proto2.
canIndent=function canIndent(){
return false;
};_proto2.
append=function append(){
for(var i=0;i<arguments.length;i++){
var currentNode=i<0||arguments.length<=i?undefined:arguments[i];
if($isListItemNode(currentNode)){
_Lexical$ElementNode2.prototype.append.call(this,currentNode);
}else{
var listItemNode=$createListItemNode();
if($isListNode(currentNode)){
listItemNode.append(currentNode);
}else if(require("Lexical").$isElementNode(currentNode)){
var textNode=require("Lexical").$createTextNode(currentNode.getTextContent());
listItemNode.append(textNode);
}else{
listItemNode.append(currentNode);
}
_Lexical$ElementNode2.prototype.append.call(this,listItemNode);
}
}
return this;
};_proto2.
extractWithChild=function extractWithChild(child){
return $isListItemNode(child);
};return ListNode;}(_require_Lexical.ElementNode);

function setListThemeClassNames(dom,editorThemeClasses,node){
var classesToAdd=[];
var classesToRemove=[];
var listTheme=editorThemeClasses.list;
if(listTheme!==undefined){
var listLevelsClassNames=listTheme[node.__tag+"Depth"]||[];
var listDepth=$getListDepth(node)-1;
var normalizedListDepth=listDepth%listLevelsClassNames.length;
var listLevelClassName=listLevelsClassNames[normalizedListDepth];
var listClassName=listTheme[node.__tag];
var nestedListClassName;
var nestedListTheme=listTheme.nested;
var checklistClassName=listTheme.checklist;
if(nestedListTheme!==undefined&&nestedListTheme.list){
nestedListClassName=nestedListTheme.list;
}
if(listClassName!==undefined){
classesToAdd.push(listClassName);
}
if(checklistClassName!==undefined&&node.__listType==='check'){
classesToAdd.push(checklistClassName);
}
if(listLevelClassName!==undefined){
var listItemClasses=listLevelClassName.split(' ');
classesToAdd.push.apply(classesToAdd,listItemClasses);
for(var i=0;i<listLevelsClassNames.length;i++){
if(i!==normalizedListDepth){
classesToRemove.push(node.__tag+i);
}
}
}
if(nestedListClassName!==undefined){
var nestedListItemClasses=nestedListClassName.split(' ');
if(listDepth>1){
classesToAdd.push.apply(classesToAdd,nestedListItemClasses);
}else{
classesToRemove.push.apply(classesToRemove,nestedListItemClasses);
}
}
}
if(classesToRemove.length>0){
require("LexicalUtils").removeClassNamesFromElement.apply(require("LexicalUtils"),[dom].concat(classesToRemove));
}
if(classesToAdd.length>0){
require("LexicalUtils").addClassNamesToElement.apply(require("LexicalUtils"),[dom].concat(classesToAdd));
}
}






function normalizeChildren(nodes){
var normalizedListItems=[];
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if($isListItemNode(node)){
normalizedListItems.push(node);
var children=node.getChildren();
if(children.length>1){
children.forEach(function(child){
if($isListNode(child)){
normalizedListItems.push(wrapInListItem(child));
}
});
}
}else{
normalizedListItems.push(wrapInListItem(node));
}
}
return normalizedListItems;
}
function convertListNode(domNode){
var nodeName=domNode.nodeName.toLowerCase();
var node=null;
if(nodeName==='ol'){

var start=domNode.start;
node=$createListNode('number',start);
}else if(nodeName==='ul'){
if(require("LexicalUtils").isHTMLElement(domNode)&&domNode.getAttribute('__lexicallisttype')==='check'){
node=$createListNode('check');
}else{
node=$createListNode('bullet');
}
}
return{
after:normalizeChildren,
node:node};

}
var TAG_TO_LIST_TYPE={
ol:'number',
ul:'bullet'};








function $createListNode(listType,start){if(start===void 0){start=1;}
return require("Lexical").$applyNodeReplacement(new ListNode(listType,start));
}






function $isListNode(node){
return node instanceof ListNode;
}


var INSERT_UNORDERED_LIST_COMMAND=_require_Lexical.createCommand('INSERT_UNORDERED_LIST_COMMAND');
var INSERT_ORDERED_LIST_COMMAND=_require_Lexical.createCommand('INSERT_ORDERED_LIST_COMMAND');
var INSERT_CHECK_LIST_COMMAND=_require_Lexical.createCommand('INSERT_CHECK_LIST_COMMAND');
var REMOVE_LIST_COMMAND=_require_Lexical.createCommand('REMOVE_LIST_COMMAND');

exports.$createListItemNode=$createListItemNode;
exports.$createListNode=$createListNode;
exports.$getListDepth=$getListDepth;
exports.$handleListInsertParagraph=$handleListInsertParagraph;
exports.$isListItemNode=$isListItemNode;
exports.$isListNode=$isListNode;
exports.INSERT_CHECK_LIST_COMMAND=INSERT_CHECK_LIST_COMMAND;
exports.INSERT_ORDERED_LIST_COMMAND=INSERT_ORDERED_LIST_COMMAND;
exports.INSERT_UNORDERED_LIST_COMMAND=INSERT_UNORDERED_LIST_COMMAND;
exports.ListItemNode=ListItemNode;
exports.ListNode=ListNode;
exports.REMOVE_LIST_COMMAND=REMOVE_LIST_COMMAND;
exports.insertList=insertList;
exports.removeList=removeList;}),null);