/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalSelection.dev",["Lexical"],(function $module_LexicalSelection_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';










var CSS_TO_STYLES=new Map();








function getDOMTextNode(element){
var node=element;
while(node!=null){
if(node.nodeType===Node.TEXT_NODE){
return node;
}
node=node.firstChild;
}
return null;
}
function getDOMIndexWithinParent(node){
var parent=node.parentNode;
if(parent==null){
throw new Error('Should never happen');
}
return[parent,Array.from(parent.childNodes).indexOf(node)];
}










function createDOMRange(editor,anchorNode,_anchorOffset,focusNode,_focusOffset){
var anchorKey=anchorNode.getKey();
var focusKey=focusNode.getKey();
var range=document.createRange();
var anchorDOM=editor.getElementByKey(anchorKey);
var focusDOM=editor.getElementByKey(focusKey);
var anchorOffset=_anchorOffset;
var focusOffset=_focusOffset;
if(require("Lexical").$isTextNode(anchorNode)){
anchorDOM=getDOMTextNode(anchorDOM);
}
if(require("Lexical").$isTextNode(focusNode)){
focusDOM=getDOMTextNode(focusDOM);
}
if(anchorNode===undefined||focusNode===undefined||anchorDOM===null||focusDOM===null){
return null;
}
if(anchorDOM.nodeName==='BR'){var _getDOMIndexWithinPar=
getDOMIndexWithinParent(anchorDOM);anchorDOM=_getDOMIndexWithinPar[0];anchorOffset=_getDOMIndexWithinPar[1];
}
if(focusDOM.nodeName==='BR'){var _getDOMIndexWithinPar2=
getDOMIndexWithinParent(focusDOM);focusDOM=_getDOMIndexWithinPar2[0];focusOffset=_getDOMIndexWithinPar2[1];
}
var firstChild=anchorDOM.firstChild;
if(anchorDOM===focusDOM&&firstChild!=null&&firstChild.nodeName==='BR'&&anchorOffset===0&&focusOffset===0){
focusOffset=1;
}
try{
range.setStart(anchorDOM,anchorOffset);
range.setEnd(focusDOM,focusOffset);
}catch(e){
return null;
}
if(range.collapsed&&(anchorOffset!==focusOffset||anchorKey!==focusKey)){

range.setStart(focusDOM,focusOffset);
range.setEnd(anchorDOM,anchorOffset);
}
return range;
}







function createRectsFromDOMRange(editor,range){
var rootElement=editor.getRootElement();
if(rootElement===null){
return[];
}
var rootRect=rootElement.getBoundingClientRect();
var computedStyle=getComputedStyle(rootElement);
var rootPadding=parseFloat(computedStyle.paddingLeft)+parseFloat(computedStyle.paddingRight);
var selectionRects=Array.from(range.getClientRects());
var selectionRectsLength=selectionRects.length;

selectionRects.sort(function(a,b){
var top=a.top-b.top;


if(Math.abs(top)<=3){
return a.left-b.left;
}
return top;
});
var prevRect;
for(var i=0;i<selectionRectsLength;i++){
var selectionRect=selectionRects[i];

var isOverlappingRect=prevRect&&prevRect.top<=selectionRect.top&&prevRect.top+prevRect.height>selectionRect.top&&prevRect.left+prevRect.width>selectionRect.left;

var selectionSpansElement=selectionRect.width+rootPadding===rootRect.width;
if(isOverlappingRect||selectionSpansElement){
selectionRects.splice(i--,1);
selectionRectsLength--;
continue;
}
prevRect=selectionRect;
}
return selectionRects;
}






function getStyleObjectFromRawCSS(css){
var styleObject={};
var styles=css.split(';');
for(var _iterator=styles,_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var style=_ref;
if(style!==''){var _style$split=
style.split(/:([^]+)/),key=_style$split[0],value=_style$split[1];
if(key&&value){
styleObject[key.trim()]=value.trim();
}
}
}
return styleObject;
}






function getStyleObjectFromCSS(css){
var value=CSS_TO_STYLES.get(css);
if(value===undefined){
value=getStyleObjectFromRawCSS(css);
CSS_TO_STYLES.set(css,value);
}
{

Object.freeze(value);
}
return value;
}






function getCSSFromStyleObject(styles){
var css='';
for(var style in styles){
if(style){
css+=style+": "+styles[style]+";";
}
}
return css;
}








function $updateElementNodeProperties(target,source){
target.__first=source.__first;
target.__last=source.__last;
target.__size=source.__size;
target.__format=source.__format;
target.__indent=source.__indent;
target.__dir=source.__dir;
return target;
}
function $updateTextNodeProperties(target,source){
target.__format=source.__format;
target.__style=source.__style;
target.__mode=source.__mode;
target.__detail=source.__detail;
return target;
}






function $cloneWithProperties(node){
var constructor=node.constructor;

var clone=constructor.clone(node);
clone.__parent=node.__parent;
clone.__next=node.__next;
clone.__prev=node.__prev;
if(require("Lexical").$isElementNode(node)&&require("Lexical").$isElementNode(clone)){
return $updateElementNodeProperties(clone,node);
}
if(require("Lexical").$isTextNode(node)&&require("Lexical").$isTextNode(clone)){
return $updateTextNodeProperties(clone,node);
}
return clone;
}








function $sliceSelectedTextNodeContent(selection,textNode){
var anchorAndFocus=selection.getStartEndPoints();
if(textNode.isSelected(selection)&&!textNode.isSegmented()&&!textNode.isToken()&&anchorAndFocus!==null){var
anchor=anchorAndFocus[0],focus=anchorAndFocus[1];
var isBackward=selection.isBackward();
var anchorNode=anchor.getNode();
var focusNode=focus.getNode();
var isAnchor=textNode.is(anchorNode);
var isFocus=textNode.is(focusNode);
if(isAnchor||isFocus){var _Lexical$$getCharacte=
require("Lexical").$getCharacterOffsets(selection),anchorOffset=_Lexical$$getCharacte[0],focusOffset=_Lexical$$getCharacte[1];
var isSame=anchorNode.is(focusNode);
var isFirst=textNode.is(isBackward?focusNode:anchorNode);
var isLast=textNode.is(isBackward?anchorNode:focusNode);
var startOffset=0;
var endOffset=undefined;
if(isSame){
startOffset=anchorOffset>focusOffset?focusOffset:anchorOffset;
endOffset=anchorOffset>focusOffset?anchorOffset:focusOffset;
}else if(isFirst){
var offset=isBackward?focusOffset:anchorOffset;
startOffset=offset;
endOffset=undefined;
}else if(isLast){
var _offset=isBackward?anchorOffset:focusOffset;
startOffset=0;
endOffset=_offset;
}
textNode.__text=textNode.__text.slice(startOffset,endOffset);
return textNode;
}
}
return textNode;
}






function $isAtNodeEnd(point){
if(point.type==='text'){
return point.offset===point.getNode().getTextContentSize();
}
var node=point.getNode();
if(!require("Lexical").$isElementNode(node)){
throw Error("isAtNodeEnd: node must be a TextNode or ElementNode");
}
return point.offset===node.getChildrenSize();
}









function trimTextContentFromAnchor(editor,anchor,delCount){

var currentNode=anchor.getNode();
var remaining=delCount;
if(require("Lexical").$isElementNode(currentNode)){
var descendantNode=currentNode.getDescendantByIndex(anchor.offset);
if(descendantNode!==null){
currentNode=descendantNode;
}
}
while(remaining>0&&currentNode!==null){
if(require("Lexical").$isElementNode(currentNode)){
var lastDescendant=currentNode.getLastDescendant();
if(lastDescendant!==null){
currentNode=lastDescendant;
}
}
var nextNode=currentNode.getPreviousSibling();
var additionalElementWhitespace=0;
if(nextNode===null){
var parent=currentNode.getParentOrThrow();
var parentSibling=parent.getPreviousSibling();
while(parentSibling===null){
parent=parent.getParent();
if(parent===null){
nextNode=null;
break;
}
parentSibling=parent.getPreviousSibling();
}
if(parent!==null){
additionalElementWhitespace=parent.isInline()?0:2;
nextNode=parentSibling;
}
}
var text=currentNode.getTextContent();


if(text===''&&require("Lexical").$isElementNode(currentNode)&&!currentNode.isInline()){

text='\n\n';
}
var currentNodeSize=text.length;
if(!require("Lexical").$isTextNode(currentNode)||remaining>=currentNodeSize){
var _parent=currentNode.getParent();
currentNode.remove();
if(_parent!=null&&_parent.getChildrenSize()===0&&!require("Lexical").$isRootNode(_parent)){
_parent.remove();
}
remaining-=currentNodeSize+additionalElementWhitespace;
currentNode=nextNode;
}else{(function(){
var key=currentNode.getKey();

var prevTextContent=editor.getEditorState().read(function(){
var prevNode=require("Lexical").$getNodeByKey(key);
if(require("Lexical").$isTextNode(prevNode)&&prevNode.isSimpleText()){
return prevNode.getTextContent();
}
return null;
});
var offset=currentNodeSize-remaining;
var slicedText=text.slice(0,offset);
if(prevTextContent!==null&&prevTextContent!==text){
var prevSelection=require("Lexical").$getPreviousSelection();
var target=currentNode;
if(!currentNode.isSimpleText()){
var textNode=require("Lexical").$createTextNode(prevTextContent);
currentNode.replace(textNode);
target=textNode;
}else{
currentNode.setTextContent(prevTextContent);
}
if(require("Lexical").$isRangeSelection(prevSelection)&&prevSelection.isCollapsed()){
var prevOffset=prevSelection.anchor.offset;
target.select(prevOffset,prevOffset);
}
}else if(currentNode.isSimpleText()){

var isSelected=anchor.key===key;
var anchorOffset=anchor.offset;


if(anchorOffset<remaining){
anchorOffset=currentNodeSize;
}
var splitStart=isSelected?anchorOffset-remaining:0;
var splitEnd=isSelected?anchorOffset:offset;
if(isSelected&&splitStart===0){var _currentNode$splitTex=
currentNode.splitText(splitStart,splitEnd),excessNode=_currentNode$splitTex[0];
excessNode.remove();
}else{var _currentNode$splitTex2=
currentNode.splitText(splitStart,splitEnd),_excessNode=_currentNode$splitTex2[1];
_excessNode.remove();
}
}else{
var _textNode=require("Lexical").$createTextNode(slicedText);
currentNode.replace(_textNode);
}
remaining=0;})();
}
}
}





function $addNodeStyle(node){
var CSSText=node.getStyle();
var styles=getStyleObjectFromRawCSS(CSSText);
CSS_TO_STYLES.set(CSSText,styles);
}
function $patchStyle(target,patch){
var prevStyles=getStyleObjectFromCSS('getStyle'in target?target.getStyle():target.style);
var newStyles=Object.entries(patch).reduce(function(styles,_ref2){var key=_ref2[0],value=_ref2[1];
if(value instanceof Function){
styles[key]=value(prevStyles[key]);
}else if(value===null){
delete styles[key];
}else{
styles[key]=value;
}
return styles;
},babelHelpers["extends"]({},
prevStyles)||
{});
var newCSSText=getCSSFromStyleObject(newStyles);
target.setStyle(newCSSText);
CSS_TO_STYLES.set(newCSSText,newStyles);
}








function $patchStyleText(selection,patch){
var selectedNodes=selection.getNodes();
var selectedNodesLength=selectedNodes.length;
var anchorAndFocus=selection.getStartEndPoints();
if(anchorAndFocus===null){
return;
}var
anchor=anchorAndFocus[0],focus=anchorAndFocus[1];
var lastIndex=selectedNodesLength-1;
var firstNode=selectedNodes[0];
var lastNode=selectedNodes[lastIndex];
if(selection.isCollapsed()&&require("Lexical").$isRangeSelection(selection)){
$patchStyle(selection,patch);
return;
}
var firstNodeText=firstNode.getTextContent();
var firstNodeTextLength=firstNodeText.length;
var focusOffset=focus.offset;
var anchorOffset=anchor.offset;
var isBefore=anchor.isBefore(focus);
var startOffset=isBefore?anchorOffset:focusOffset;
var endOffset=isBefore?focusOffset:anchorOffset;
var startType=isBefore?anchor.type:focus.type;
var endType=isBefore?focus.type:anchor.type;
var endKey=isBefore?focus.key:anchor.key;



if(require("Lexical").$isTextNode(firstNode)&&startOffset===firstNodeTextLength){
var nextSibling=firstNode.getNextSibling();
if(require("Lexical").$isTextNode(nextSibling)){

anchorOffset=0;
startOffset=0;
firstNode=nextSibling;
}
}


if(selectedNodes.length===1){
if(require("Lexical").$isTextNode(firstNode)&&firstNode.canHaveFormat()){
startOffset=startType==='element'?0:anchorOffset>focusOffset?focusOffset:anchorOffset;
endOffset=endType==='element'?firstNodeTextLength:anchorOffset>focusOffset?anchorOffset:focusOffset;


if(startOffset===endOffset){
return;
}


if(startOffset===0&&endOffset===firstNodeTextLength){
$patchStyle(firstNode,patch);
firstNode.select(startOffset,endOffset);
}else{


var splitNodes=firstNode.splitText(startOffset,endOffset);
var replacement=startOffset===0?splitNodes[0]:splitNodes[1];
$patchStyle(replacement,patch);
replacement.select(0,endOffset-startOffset);
}
}
}else{
if(require("Lexical").$isTextNode(firstNode)&&startOffset<firstNode.getTextContentSize()&&firstNode.canHaveFormat()){
if(startOffset!==0){

firstNode=firstNode.splitText(startOffset)[1];
startOffset=0;
anchor.set(firstNode.getKey(),startOffset,'text');
}
$patchStyle(firstNode,patch);
}
if(require("Lexical").$isTextNode(lastNode)&&lastNode.canHaveFormat()){
var lastNodeText=lastNode.getTextContent();
var lastNodeTextLength=lastNodeText.length;





if(lastNode.__key!==endKey&&endOffset!==0){
endOffset=lastNodeTextLength;
}


if(endOffset!==lastNodeTextLength){var _lastNode$splitText=
lastNode.splitText(endOffset);lastNode=_lastNode$splitText[0];
}
if(endOffset!==0||endType==='element'){
$patchStyle(lastNode,patch);
}
}


for(var i=1;i<lastIndex;i++){
var selectedNode=selectedNodes[i];
var selectedNodeKey=selectedNode.getKey();
if(require("Lexical").$isTextNode(selectedNode)&&selectedNode.canHaveFormat()&&selectedNodeKey!==firstNode.getKey()&&selectedNodeKey!==lastNode.getKey()&&!selectedNode.isToken()){
$patchStyle(selectedNode,patch);
}
}
}
}














function $setBlocksType(selection,createElement){
if(selection===null){
return;
}
var anchorAndFocus=selection.getStartEndPoints();
var anchor=anchorAndFocus?anchorAndFocus[0]:null;
if(anchor!==null&&anchor.key==='root'){
var element=createElement();
var root=require("Lexical").$getRoot();
var firstChild=root.getFirstChild();
if(firstChild){
firstChild.replace(element,true);
}else{
root.append(element);
}
return;
}
var nodes=selection.getNodes();
var firstSelectedBlock=anchor!==null?$getAncestor(anchor.getNode(),INTERNAL_$isBlock):false;
if(firstSelectedBlock&&nodes.indexOf(firstSelectedBlock)===-1){
nodes.push(firstSelectedBlock);
}
for(var i=0;i<nodes.length;i++){
var node=nodes[i];
if(!INTERNAL_$isBlock(node)){
continue;
}
if(!require("Lexical").$isElementNode(node)){
throw Error("Expected block node to be an ElementNode");
}
var targetElement=createElement();
targetElement.setFormat(node.getFormatType());
targetElement.setIndent(node.getIndent());
node.replace(targetElement,true);
}
}
function isPointAttached(point){
return point.getNode().isAttached();
}
function $removeParentEmptyElements(startingNode){
var node=startingNode;
while(node!==null&&!require("Lexical").$isRootOrShadowRoot(node)){
var latest=node.getLatest();
var parentNode=node.getParent();
if(latest.getChildrenSize()===0){
node.remove(true);
}
node=parentNode;
}
}








function $wrapNodes(selection,createElement,wrappingElement){if(wrappingElement===void 0){wrappingElement=null;}
var anchorAndFocus=selection.getStartEndPoints();
var anchor=anchorAndFocus?anchorAndFocus[0]:null;
var nodes=selection.getNodes();
var nodesLength=nodes.length;
if(anchor!==null&&(nodesLength===0||nodesLength===1&&anchor.type==='element'&&anchor.getNode().getChildrenSize()===0)){
var target=anchor.type==='text'?anchor.getNode().getParentOrThrow():anchor.getNode();
var children=target.getChildren();
var element=createElement();
element.setFormat(target.getFormatType());
element.setIndent(target.getIndent());
children.forEach(function(child){return element.append(child);});
if(wrappingElement){
element=wrappingElement.append(element);
}
target.replace(element);
return;
}
var topLevelNode=null;
var descendants=[];
for(var i=0;i<nodesLength;i++){
var node=nodes[i];




if(require("Lexical").$isRootOrShadowRoot(node)){
$wrapNodesImpl(selection,descendants,descendants.length,createElement,wrappingElement);
descendants=[];
topLevelNode=node;
}else if(topLevelNode===null||topLevelNode!==null&&require("Lexical").$hasAncestor(node,topLevelNode)){
descendants.push(node);
}else{
$wrapNodesImpl(selection,descendants,descendants.length,createElement,wrappingElement);
descendants=[node];
}
}
$wrapNodesImpl(selection,descendants,descendants.length,createElement,wrappingElement);
}










function $wrapNodesImpl(selection,nodes,nodesLength,createElement,wrappingElement){if(wrappingElement===void 0){wrappingElement=null;}
if(nodes.length===0){
return;
}
var firstNode=nodes[0];
var elementMapping=new Map();
var elements=[];




var target=require("Lexical").$isElementNode(firstNode)?firstNode:firstNode.getParentOrThrow();
if(target.isInline()){
target=target.getParentOrThrow();
}
var targetIsPrevSibling=false;
while(target!==null){
var prevSibling=target.getPreviousSibling();
if(prevSibling!==null){
target=prevSibling;
targetIsPrevSibling=true;
break;
}
target=target.getParentOrThrow();
if(require("Lexical").$isRootOrShadowRoot(target)){
break;
}
}
var emptyElements=new Set();


for(var i=0;i<nodesLength;i++){
var node=nodes[i];
if(require("Lexical").$isElementNode(node)&&node.getChildrenSize()===0){
emptyElements.add(node.getKey());
}
}
var movedNodes=new Set();




for(var _i2=0;_i2<nodesLength;_i2++){
var _node=nodes[_i2];
var parent=_node.getParent();
if(parent!==null&&parent.isInline()){
parent=parent.getParent();
}
if(parent!==null&&require("Lexical").$isLeafNode(_node)&&!movedNodes.has(_node.getKey())){
var parentKey=parent.getKey();
if(elementMapping.get(parentKey)===undefined){(function(){
var targetElement=createElement();
targetElement.setFormat(parent.getFormatType());
targetElement.setIndent(parent.getIndent());
elements.push(targetElement);
elementMapping.set(parentKey,targetElement);


parent.getChildren().forEach(function(child){
targetElement.append(child);
movedNodes.add(child.getKey());
if(require("Lexical").$isElementNode(child)){

child.getChildrenKeys().forEach(function(key){return movedNodes.add(key);});
}
});
$removeParentEmptyElements(parent);})();
}
}else if(emptyElements.has(_node.getKey())){
if(!require("Lexical").$isElementNode(_node)){
throw Error("Expected node in emptyElements to be an ElementNode");
}
var targetElement=createElement();
targetElement.setFormat(_node.getFormatType());
targetElement.setIndent(_node.getIndent());
elements.push(targetElement);
_node.remove(true);
}
}
if(wrappingElement!==null){
for(var _i3=0;_i3<elements.length;_i3++){
var element=elements[_i3];
wrappingElement.append(element);
}
}
var lastElement=null;



if(require("Lexical").$isRootOrShadowRoot(target)){
if(targetIsPrevSibling){
if(wrappingElement!==null){
target.insertAfter(wrappingElement);
}else{
for(var _i4=elements.length-1;_i4>=0;_i4--){
var _element=elements[_i4];
target.insertAfter(_element);
}
}
}else{
var firstChild=target.getFirstChild();
if(require("Lexical").$isElementNode(firstChild)){
target=firstChild;
}
if(firstChild===null){
if(wrappingElement){
target.append(wrappingElement);
}else{
for(var _i5=0;_i5<elements.length;_i5++){
var _element2=elements[_i5];
target.append(_element2);
lastElement=_element2;
}
}
}else{
if(wrappingElement!==null){
firstChild.insertBefore(wrappingElement);
}else{
for(var _i6=0;_i6<elements.length;_i6++){
var _element3=elements[_i6];
firstChild.insertBefore(_element3);
lastElement=_element3;
}
}
}
}
}else{
if(wrappingElement){
target.insertAfter(wrappingElement);
}else{
for(var _i7=elements.length-1;_i7>=0;_i7--){
var _element4=elements[_i7];
target.insertAfter(_element4);
lastElement=_element4;
}
}
}
var prevSelection=require("Lexical").$getPreviousSelection();
if(require("Lexical").$isRangeSelection(prevSelection)&&isPointAttached(prevSelection.anchor)&&isPointAttached(prevSelection.focus)){
require("Lexical").$setSelection(prevSelection.clone());
}else if(lastElement!==null){
lastElement.selectEnd();
}else{
selection.dirty=true;
}
}







function $shouldOverrideDefaultCharacterSelection(selection,isBackward){
var possibleNode=require("Lexical").$getAdjacentNode(selection.focus,isBackward);
return require("Lexical").$isDecoratorNode(possibleNode)&&!possibleNode.isIsolated()||require("Lexical").$isElementNode(possibleNode)&&!possibleNode.isInline()&&!possibleNode.canBeEmpty();
}








function $moveCaretSelection(selection,isHoldingShift,isBackward,granularity){
selection.modify(isHoldingShift?'extend':'move',isBackward,granularity);
}






function $isParentElementRTL(selection){
var anchorNode=selection.anchor.getNode();
var parent=require("Lexical").$isRootNode(anchorNode)?anchorNode:anchorNode.getParentOrThrow();
return parent.getDirection()==='rtl';
}







function $moveCharacter(selection,isHoldingShift,isBackward){
var isRTL=$isParentElementRTL(selection);
$moveCaretSelection(selection,isHoldingShift,isBackward?!isRTL:isRTL,'character');
}





function $selectAll(selection){
var anchor=selection.anchor;
var focus=selection.focus;
var anchorNode=anchor.getNode();
var topParent=anchorNode.getTopLevelElementOrThrow();
var root=topParent.getParentOrThrow();
var firstNode=root.getFirstDescendant();
var lastNode=root.getLastDescendant();
var firstType='element';
var lastType='element';
var lastOffset=0;
if(require("Lexical").$isTextNode(firstNode)){
firstType='text';
}else if(!require("Lexical").$isElementNode(firstNode)&&firstNode!==null){
firstNode=firstNode.getParentOrThrow();
}
if(require("Lexical").$isTextNode(lastNode)){
lastType='text';
lastOffset=lastNode.getTextContentSize();
}else if(!require("Lexical").$isElementNode(lastNode)&&lastNode!==null){
lastNode=lastNode.getParentOrThrow();
}
if(firstNode&&lastNode){
anchor.set(firstNode.getKey(),0,firstType);
focus.set(lastNode.getKey(),lastOffset,lastType);
}
}








function $getNodeStyleValueForProperty(node,styleProperty,defaultValue){
var css=node.getStyle();
var styleObject=getStyleObjectFromCSS(css);
if(styleObject!==null){
return styleObject[styleProperty]||defaultValue;
}
return defaultValue;
}









function $getSelectionStyleValueForProperty(selection,styleProperty,defaultValue){if(defaultValue===void 0){defaultValue='';}
var styleValue=null;
var nodes=selection.getNodes();
var anchor=selection.anchor;
var focus=selection.focus;
var isBackward=selection.isBackward();
var endOffset=isBackward?focus.offset:anchor.offset;
var endNode=isBackward?focus.getNode():anchor.getNode();
if(selection.isCollapsed()&&selection.style!==''){
var css=selection.style;
var styleObject=getStyleObjectFromCSS(css);
if(styleObject!==null&&styleProperty in styleObject){
return styleObject[styleProperty];
}
}
for(var i=0;i<nodes.length;i++){
var node=nodes[i];




if(i!==0&&endOffset===0&&node.is(endNode)){
continue;
}
if(require("Lexical").$isTextNode(node)){
var nodeStyleValue=$getNodeStyleValueForProperty(node,styleProperty,defaultValue);
if(styleValue===null){
styleValue=nodeStyleValue;
}else if(styleValue!==nodeStyleValue){


styleValue='';
break;
}
}
}
return styleValue===null?defaultValue:styleValue;
}





function INTERNAL_$isBlock(node){
if(require("Lexical").$isDecoratorNode(node)){
return false;
}
if(!require("Lexical").$isElementNode(node)||require("Lexical").$isRootOrShadowRoot(node)){
return false;
}
var firstChild=node.getFirstChild();
var isLeafElement=firstChild===null||require("Lexical").$isLineBreakNode(firstChild)||require("Lexical").$isTextNode(firstChild)||firstChild.isInline();
return!node.isInline()&&node.canBeEmpty()!==false&&isLeafElement;
}
function $getAncestor(node,predicate){
var parent=node;
while(parent!==null&&parent.getParent()!==null&&!predicate(parent)){
parent=parent.getParentOrThrow();
}
return predicate(parent)?parent:null;
}

exports.$addNodeStyle=$addNodeStyle;
exports.$cloneWithProperties=$cloneWithProperties;
exports.$getSelectionStyleValueForProperty=$getSelectionStyleValueForProperty;
exports.$isAtNodeEnd=$isAtNodeEnd;
exports.$isParentElementRTL=$isParentElementRTL;
exports.$moveCaretSelection=$moveCaretSelection;
exports.$moveCharacter=$moveCharacter;
exports.$patchStyleText=$patchStyleText;
exports.$selectAll=$selectAll;
exports.$setBlocksType=$setBlocksType;
exports.$shouldOverrideDefaultCharacterSelection=$shouldOverrideDefaultCharacterSelection;
exports.$sliceSelectedTextNodeContent=$sliceSelectedTextNodeContent;
exports.$wrapNodes=$wrapNodes;
exports.createDOMRange=createDOMRange;
exports.createRectsFromDOMRange=createRectsFromDOMRange;
exports.getStyleObjectFromCSS=getStyleObjectFromCSS;
exports.trimTextContentFromAnchor=trimTextContentFromAnchor;}),null);