/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
*
* @fullSyntaxTransform
* @generated
* @noflow
* @nolint
* @oncall lexical_web_text_editor
* @preserve-invariant-messages
* @preserve-whitespace
* @preventMunge
 */__d("LexicalComposer.dev",["Lexical","LexicalComposerContext","react"],(function $module_LexicalComposer_dev(global,require,requireDynamic,requireLazy,module,exports){
'use strict';var _require_closure_react;



var React=_require_closure_react||(_require_closure_react=require("react"));









var CAN_USE_DOM=typeof window!=='undefined'&&typeof window.document!=='undefined'&&typeof window.document.createElement!=='undefined';








var useLayoutEffectImpl=CAN_USE_DOM?React.useLayoutEffect:React.useEffect;
var useLayoutEffect=useLayoutEffectImpl;








var HISTORY_MERGE_OPTIONS={
tag:'history-merge'};

function LexicalComposer(_ref)


{var initialConfig=_ref.initialConfig,children=_ref.children;
var composerContext=React.useMemo(function(){var

theme=






initialConfig.theme,namespace=initialConfig.namespace,initialEditor=initialConfig.editor__DEPRECATED,nodes=initialConfig.nodes,_onError=initialConfig.onError,initialEditorState=initialConfig.editorState,html=initialConfig.html;
var context=require("LexicalComposerContext").createLexicalComposerContext(null,theme);
var editor=initialEditor||null;
if(editor===null){
var newEditor=require("Lexical").createEditor({
editable:initialConfig.editable,
html:html,
namespace:namespace,
nodes:nodes,
onError:function onError(error){return _onError(error,newEditor);},
theme:theme});

initializeEditor(newEditor,initialEditorState);
editor=newEditor;
}
return[editor,context];
},


[]);
useLayoutEffect(function(){
var isEditable=initialConfig.editable;var
editor=composerContext[0];
editor.setEditable(isEditable!==undefined?isEditable:true);



},[]);
return React.createElement(require("LexicalComposerContext").LexicalComposerContext.Provider,{
value:composerContext},
children);
}
function initializeEditor(editor,initialEditorState){
if(initialEditorState===null){
return;
}else if(initialEditorState===undefined){
editor.update(function(){
var root=require("Lexical").$getRoot();
if(root.isEmpty()){
var paragraph=require("Lexical").$createParagraphNode();
root.append(paragraph);
var activeElement=CAN_USE_DOM?document.activeElement:null;
if(require("Lexical").$getSelection()!==null||activeElement!==null&&activeElement===editor.getRootElement()){
paragraph.select();
}
}
},HISTORY_MERGE_OPTIONS);
}else if(initialEditorState!==null){
switch(typeof initialEditorState){
case'string':
{
var parsedEditorState=editor.parseEditorState(initialEditorState);
editor.setEditorState(parsedEditorState,HISTORY_MERGE_OPTIONS);
break;
}
case'object':
{
editor.setEditorState(initialEditorState,HISTORY_MERGE_OPTIONS);
break;
}
case'function':
{
editor.update(function(){
var root=require("Lexical").$getRoot();
if(root.isEmpty()){
initialEditorState(editor);
}
},HISTORY_MERGE_OPTIONS);
break;
}}

}
}

exports.LexicalComposer=LexicalComposer;}),null);